/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.eas.helper.MoveEasCommonHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BusApBillModel;
import kd.fi.arapcommon.model.BusArBillModel;
import kd.fi.arapcommon.model.BusBillModel;

public class BusAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BusAfterProcess4EasOp.class);
    private BusBillModel billModel = new BusArBillModel();

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("BusAfterProcess4EasOp endOperationTransaction begin.");
        this.billModel = "ar_busbill".equals(this.billEntityType.getName()) ? new BusArBillModel() : new BusApBillModel();
        DynamicObject[] dataEntities = this.getBusArBills(e);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org.id"));
        }
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        HashSet<Long> srcBusIds = new HashSet<Long>(2);
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(2);
        Map<String, Set<Long>> srcTypeAndSrcIdMap = MoveEasCommonHelper.buildSrcTypeAndSrcId(dataEntities, (BillModel)this.billModel);
        Map<String, Map<Long, String>> srcTypeAndBillNoMap = MoveEasCommonHelper.findSrcTypeAndBillNo(srcTypeAndSrcIdMap);
        for (DynamicObject dataEntity : dataEntities) {
            String remark;
            boolean isWoff;
            long orgId = dataEntity.getLong("org.id");
            DynamicObject initObj = initObjMap.get(orgId);
            if (initObj != null) {
                if (dataEntity.getDynamicObject(this.billModel.HEAD_EXRATETABLE) == null) {
                    dataEntity.set(this.billModel.HEAD_EXRATETABLE, (Object)initObj.getDynamicObject("exratetable"));
                }
                if (dataEntity.getDynamicObject(this.billModel.HEAD_BASECURRENCY) == null) {
                    dataEntity.set(this.billModel.HEAD_BASECURRENCY, (Object)initObj.getDynamicObject("standardcurrency"));
                }
            }
            if (isWoff = (remark = dataEntity.getString(this.billModel.HEAD_REMARK)).contains(ResManager.loadKDString((String)"\u51b2\u56de", (String)"BusAfterProcess4EasOp_0", (String)"fi-arapcommon", (Object[])new Object[0]))) {
                srcBusIds.add(dataEntity.getLong(this.billModel.HEAD_SOURCEBILLID));
                dataEntity.set(this.billModel.HEAD_ISADJUST, (Object)isWoff);
                DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(this.billModel.ENTRY);
                for (DynamicObject entry : entryColl) {
                    entryMap.put(entry.getLong(this.billModel.E_SOURCEBILLENTRYID), entry);
                    srcBusIds.add(entry.getLong(this.billModel.E_SOURCEBILLID));
                    entry.set(this.billModel.E_UNWOFFNOTAXAMT, (Object)0);
                    entry.set(this.billModel.E_UNWOFFNOTAXLOCAMT, (Object)0);
                    entry.set(this.billModel.E_UNWOFFTAX, (Object)0);
                    entry.set(this.billModel.E_UNWOFFTAXLOCAL, (Object)0);
                    entry.set(this.billModel.E_UNWOFFQTY, (Object)0);
                }
            }
            List<Tuple<String, String>> sumAmtFieldList = this.getSumAmtFieldList();
            MoveEasCommonHelper.entryAmtSumToHead(dataEntity, this.billModel.ENTRY, sumAmtFieldList);
            MoveEasCommonHelper.dealSrcBillNoSetValue(srcTypeAndBillNoMap, dataEntity, (BillModel)this.billModel);
        }
        if (!srcBusIds.isEmpty()) {
            DynamicObject[] srcBusBills = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"unwoffnotaxamt,unwoffnotaxlocamt,unwofftax,unwofftaxlocal,entry.id,entry.e_iswriteoff,entry.e_unwoffqty,entry.e_unwoffnotaxamt,entry.e_unwoffnotaxlocamt,entry.e_unwofftax,entry.e_unwofftaxlocal,entry.e_unwoffamt", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIds)});
            logger.info("BusAfterProcess4EasOp srcBusBills: " + srcBusBills.length);
            for (DynamicObject srcBusBill : srcBusBills) {
                DynamicObjectCollection entrys = srcBusBill.getDynamicObjectCollection("entry");
                for (DynamicObject srcBillEntry : entrys) {
                    Long entryId = srcBillEntry.getLong("id");
                    DynamicObject tarBillEntry = (DynamicObject)entryMap.get(entryId);
                    if (tarBillEntry == null) continue;
                    srcBillEntry.set(this.billModel.E_UNWOFFNOTAXAMT, (Object)srcBillEntry.getBigDecimal(this.billModel.E_UNWOFFNOTAXAMT).add(tarBillEntry.getBigDecimal(this.billModel.E_AMOUNT)));
                    srcBillEntry.set(this.billModel.E_UNWOFFNOTAXLOCAMT, (Object)srcBillEntry.getBigDecimal(this.billModel.E_UNWOFFNOTAXLOCAMT).add(tarBillEntry.getBigDecimal(this.billModel.E_LOCALAMT)));
                    srcBillEntry.set(this.billModel.E_UNWOFFTAX, (Object)srcBillEntry.getBigDecimal(this.billModel.E_UNWOFFTAX).add(tarBillEntry.getBigDecimal(this.billModel.E_TAX)));
                    srcBillEntry.set(this.billModel.E_UNWOFFTAXLOCAL, (Object)srcBillEntry.getBigDecimal(this.billModel.E_UNWOFFTAXLOCAL).add(tarBillEntry.getBigDecimal(this.billModel.E_TAXLOCALAMT)));
                    BigDecimal unWoffQty = srcBillEntry.getBigDecimal(this.billModel.E_UNWOFFQTY).add(tarBillEntry.getBigDecimal(this.billModel.E_QUANTITY));
                    srcBillEntry.set(this.billModel.E_UNWOFFQTY, (Object)unWoffQty);
                    if (unWoffQty.compareTo(BigDecimal.ZERO) != 0) continue;
                    srcBillEntry.set(this.billModel.E_ISWRITEOFF, (Object)Boolean.TRUE);
                }
                List<Tuple<String, String>> sumAmtFieldList = this.getSumAmtFieldList4Woff();
                MoveEasCommonHelper.entryAmtSumToHead(srcBusBill, this.billModel.ENTRY, sumAmtFieldList);
            }
            SaveServiceHelper.save((DynamicObject[])srcBusBills);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(dataEntities);
        logger.info("BusAfterProcess4EasOp endOperationTransaction end.");
    }

    private List<Tuple<String, String>> getSumAmtFieldList() {
        ArrayList<Tuple<String, String>> sumAmtFieldList = new ArrayList<Tuple<String, String>>(16);
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_AMOUNT, (Object)this.billModel.HEAD_AMOUNT));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_LOCALAMT, (Object)this.billModel.HEAD_LOCALAMT));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_TAX, (Object)this.billModel.HEAD_TAX));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_TAXLOCALAMT, (Object)this.billModel.HEAD_TAXLOCAMT));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_PRICETAXTOTAL, (Object)this.billModel.HEAD_PRICETAXTOTAL));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_PRICETAXTOTALLOC, (Object)this.billModel.HEAD_PRICETAXTOTALLOC));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_UNWOFFAMT, (Object)this.billModel.HEAD_UNWOFFAMT));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_UNWOFFLOCAMT, (Object)this.billModel.HEAD_UNWOFFLOCAMT));
        sumAmtFieldList.addAll(this.getSumAmtFieldList4Woff());
        return sumAmtFieldList;
    }

    private List<Tuple<String, String>> getSumAmtFieldList4Woff() {
        ArrayList<Tuple<String, String>> sumAmtFieldList = new ArrayList<Tuple<String, String>>(16);
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_UNWOFFNOTAXAMT, (Object)this.billModel.HEAD_UNWOFFNOTAXAMT));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_UNWOFFNOTAXLOCAMT, (Object)this.billModel.HEAD_UNWOFFNOTAXLOCAMT));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_UNWOFFTAX, (Object)this.billModel.HEAD_UNWOFFTAX));
        sumAmtFieldList.add(Tuple.create((Object)this.billModel.E_UNWOFFTAXLOCAL, (Object)this.billModel.HEAD_UNWOFFTAXLOCAL));
        return sumAmtFieldList;
    }

    private DynamicObject[] getBusArBills(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add(this.billModel.HEAD_PK);
        selector.add(this.billModel.HEAD_ORG);
        selector.add(this.billModel.HEAD_BILLNO);
        selector.add(this.billModel.HEAD_REMARK);
        selector.add(this.billModel.HEAD_BIZDATE);
        selector.add(this.billModel.HEAD_DUEDATE);
        selector.add(this.billModel.HEAD_ASSTACT);
        selector.add(this.billModel.HEAD_ASSTACTTYPE);
        selector.add(this.billModel.HEAD_BILLTYPE);
        selector.add(this.billModel.HEAD_EXRATETABLE);
        selector.add(this.billModel.HEAD_EXCHANGERATE);
        selector.add(this.billModel.HEAD_CURRENCY);
        selector.add(this.billModel.HEAD_ISPERIOD);
        selector.add(this.billModel.HEAD_ISADJUST);
        selector.add(this.billModel.HEAD_ISINCLUDETAX);
        selector.add(this.billModel.HEAD_ISPRICETOTAL);
        selector.add(this.billModel.HEAD_PAYPROPERTY);
        selector.add(this.billModel.HEAD_BASECURRENCY);
        selector.add(this.billModel.HEAD_BILLSTATUS);
        selector.add(this.billModel.HEAD_SOURCEBILLID);
        selector.add(this.billModel.HEAD_SOURCEBILLTYPE);
        selector.add(this.billModel.HEAD_SOURCEBILLNO);
        selector.add(this.billModel.E_QUANTITY);
        selector.add(this.billModel.E_MATERIAL);
        selector.add(this.billModel.E_EXPENSEITEM);
        selector.add(this.billModel.E_SOURCEBILLID);
        selector.add(this.billModel.E_SOURCEBILLENTRYID);
        selector.add(this.billModel.HEAD_PRICETAXTOTAL);
        selector.add(this.billModel.HEAD_PRICETAXTOTALLOC);
        selector.add(this.billModel.HEAD_AMOUNT);
        selector.add(this.billModel.HEAD_LOCALAMT);
        selector.add(this.billModel.HEAD_TAX);
        selector.add(this.billModel.HEAD_TAXLOCAMT);
        selector.add(this.billModel.E_PRICETAXTOTAL);
        selector.add(this.billModel.E_PRICETAXTOTALLOC);
        selector.add(this.billModel.E_AMOUNT);
        selector.add(this.billModel.E_LOCALAMT);
        selector.add(this.billModel.E_TAX);
        selector.add(this.billModel.E_TAXLOCALAMT);
        selector.add(this.billModel.HEAD_UNWOFFAMT);
        selector.add(this.billModel.HEAD_UNWOFFLOCAMT);
        selector.add(this.billModel.HEAD_UNWOFFNOTAXAMT);
        selector.add(this.billModel.HEAD_UNWOFFNOTAXLOCAMT);
        selector.add(this.billModel.HEAD_UNWOFFTAX);
        selector.add(this.billModel.HEAD_UNWOFFTAXLOCAL);
        selector.add(this.billModel.E_UNWOFFQTY);
        selector.add(this.billModel.E_UNWOFFAMT);
        selector.add(this.billModel.E_UNWOFFLOCAMT);
        selector.add(this.billModel.E_UNWOFFNOTAXAMT);
        selector.add(this.billModel.E_UNWOFFNOTAXLOCAMT);
        selector.add(this.billModel.E_UNWOFFTAX);
        selector.add(this.billModel.E_UNWOFFTAXLOCAL);
        selector.add(this.billModel.E_ISWRITEOFF);
        selector.add(this.billModel.HEAD_INVOICEDAMT);
        selector.add(this.billModel.HEAD_INVOICEDLOCAMT);
        selector.add(this.billModel.HEAD_UNINVOICEDAMT);
        selector.add(this.billModel.HEAD_UNINVOICEDLOCAMT);
        selector.add(this.billModel.E_INVOICEDQTY);
        selector.add(this.billModel.E_UNINVOICEDQTY);
        selector.add(this.billModel.E_INVOICEDAMT);
        selector.add(this.billModel.E_INVOICEDLOCAMT);
        selector.add(this.billModel.E_UNINVOICEDAMT);
        selector.add(this.billModel.E_UNINVOICEDLOCAMT);
        selector.add(this.billModel.E_INVOICEDONOTAXAMT);
        selector.add(this.billModel.E_INVNOTAXLOCALAMT);
        selector.add(this.billModel.E_UNINVNOTAXAMT);
        selector.add(this.billModel.E_UNINVNOTAXLOCALAMT);
        return selector;
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        boolean isAr = this.billEntityType.getName().startsWith("ar");
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)(isAr ? "ar_init" : "ap_init"), (String)"exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }
}

