/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.eas.helper.EasSettleRecordHelper;
import kd.fi.arapcommon.eas.helper.MoveEasCommonHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.model.FinApBillModel;
import kd.fi.arapcommon.model.FinArBillModel;
import kd.fi.arapcommon.model.FinBillModel;

public class FinAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinAfterProcess4EasOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("FinAfterProcess4EasOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> billIds = new ArrayList<Long>(64);
        String entityName = this.billEntityType.getName();
        FinApBillModel billModel = "ap_finapbill".equals(entityName) ? new FinApBillModel() : new FinArBillModel();
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong(billModel.HEAD_ORG + ".id"));
            billIds.add(dataEntity.getLong("id"));
        }
        dataEntities = this.getFinBills(entityName, billIds);
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        Map<String, DynamicObject> sourceBillMap = this.getSourceBillMap(dataEntities, (FinBillModel)billModel);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject sourceBill;
            String sourceBillType = dataEntity.getString(billModel.HEAD_SOURCEBILLTYPE);
            long orgId = dataEntity.getLong("org.id");
            DynamicObject initObj = initObjMap.get(orgId);
            if (initObj != null) {
                if (dataEntity.getDynamicObject(billModel.HEAD_EXRATETABLE) == null) {
                    dataEntity.set(billModel.HEAD_EXRATETABLE, (Object)initObj.getDynamicObject("exratetable"));
                }
                if (dataEntity.getDynamicObject(billModel.HEAD_BASECURRENCY) == null) {
                    dataEntity.set(billModel.HEAD_BASECURRENCY, (Object)initObj.getDynamicObject("standardcurrency"));
                }
            }
            if (!ObjectUtils.isEmpty((Object)sourceBillType) && (sourceBill = sourceBillMap.get(dataEntity.getString(billModel.HEAD_SOURCEBILLID))) != null) {
                dataEntity.set(billModel.HEAD_SOURCEBILLNO, (Object)sourceBill.getString("billno"));
            }
            this.processCommonLogic(dataEntity, (FinBillModel)billModel);
            if ("ap_finapbill".equals(entityName)) {
                this.processFinApBill(dataEntity);
            }
            if (!"ar_finarbill".equals(entityName)) continue;
            this.processFinArBill(dataEntity);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(dataEntities);
        EasSettleRecordHelper.insertEasRecordData(dataEntities);
        logger.info("FinAfterProcess4EasOp endOperationTransaction end.");
    }

    private void processCommonLogic(DynamicObject dataEntity, FinBillModel billModel) {
        String entityName = this.billEntityType.getName();
        int amtPrecision = dataEntity.getInt(billModel.HEAD_CURRENCY + ".amtprecision");
        BigDecimal exchangeRate = dataEntity.getBigDecimal(billModel.HEAD_EXCHANGERATE);
        boolean isTansPay = dataEntity.getBoolean(billModel.HEAD_ISTRANSFER);
        List<Tuple<String, String>> sumAmtFieldList = this.getSumAmtFieldList(entityName);
        MoveEasCommonHelper.entryAmtSumToHead(dataEntity, billModel.ENTRY, sumAmtFieldList);
        BigDecimal lockAmtSum = BigDecimal.ZERO;
        BigDecimal unLockAmtSum = BigDecimal.ZERO;
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(billModel.ENTRY);
        for (DynamicObject detail : entry) {
            DynamicObject material = detail.getDynamicObject(billModel.E_MATERIAL);
            DynamicObject unit = detail.getDynamicObject(billModel.E_MEASUREUNIT);
            DynamicObject baseunit = detail.getDynamicObject(billModel.E_BASEUNIT);
            BigDecimal verifyBaseQty = detail.getBigDecimal(billModel.ENTRY_VERIFYBASEQTY);
            BigDecimal unVerifyBaseQty = detail.getBigDecimal(billModel.ENTRY_UNVERIFYBASEQTY);
            lockAmtSum = lockAmtSum.add(detail.getBigDecimal(billModel.E_LOCKEDAMT));
            unLockAmtSum = unLockAmtSum.add(detail.getBigDecimal(billModel.E_UNLOCKAMT));
            if (isTansPay) {
                detail.set(billModel.E_VERIFIEDQTY, (Object)BigDecimal.ZERO);
                detail.set(billModel.E_UNVERIFYQTY, (Object)BigDecimal.ZERO);
                detail.set(billModel.ENTRY_UNVERIFYBASEQTY, (Object)BigDecimal.ZERO);
                detail.set(billModel.ENTRY_VERIFYBASEQTY, (Object)BigDecimal.ZERO);
                detail.set(billModel.E_UNVERIFYAMT, (Object)BigDecimal.ZERO);
                detail.set(billModel.E_VERIFIEDAMT, (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal unverifyAmount = detail.getBigDecimal(billModel.E_UNVERIFYAMT).divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP);
            detail.set(billModel.E_UNVERIFYAMT, (Object)unverifyAmount);
            detail.set(billModel.E_VERIFIEDAMT, (Object)detail.getBigDecimal(billModel.E_AMOUNT).subtract(unverifyAmount));
            if (material != null && unit != null && baseunit != null) {
                BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)unit.getLong("id"), (Long)baseunit.getLong("id"));
                BigDecimal verifyQty = UnitConvertHelper.getUnitQty((BigDecimal)verifyBaseQty, (BigDecimal)unitRateConv, (DynamicObject)unit);
                detail.set(billModel.E_VERIFIEDQTY, (Object)verifyQty);
                detail.set(billModel.E_UNVERIFYQTY, (Object)detail.getBigDecimal(billModel.E_QUANTITY).subtract(verifyQty));
                continue;
            }
            detail.set(billModel.E_VERIFIEDQTY, (Object)verifyBaseQty);
            detail.set(billModel.E_UNVERIFYQTY, (Object)unVerifyBaseQty);
        }
        DynamicObjectCollection planEntry = dataEntity.getDynamicObjectCollection(billModel.P_ENTRY);
        planEntry.clear();
        DynamicObject newPlan = planEntry.addNew();
        newPlan.set("seq", (Object)1);
        newPlan.set(billModel.P_PLANDUEDATE, dataEntity.get(billModel.HEAD_DUEDATE));
        newPlan.set(billModel.P_PLANSETTLETYPE, dataEntity.get(billModel.HEAD_SETTLEMENTTYPE));
        newPlan.set(billModel.P_PLANPRICETAX, dataEntity.get(billModel.HEAD_PRICETAXTOTAL));
        newPlan.set(billModel.P_PLANPRICETAXLOC, dataEntity.get(billModel.HEAD_PRICETAXTOTALLOC));
        newPlan.set(billModel.P_RECORPAY_RATE, (Object)Double.valueOf("100"));
        newPlan.set(billModel.P_UNPLANLOCKAMT, (Object)unLockAmtSum);
        newPlan.set(billModel.P_PLANLOCKEDAMT, (Object)lockAmtSum);
        newPlan.set(billModel.P_UNPLANSETTLEAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_UNSETTLEAMOUNT));
        newPlan.set(billModel.P_UNPLANSETTLELOCAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_UNSETTLELOCALAMT));
        newPlan.set(billModel.P_PLANSETTLEDAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_SETTLEAMOUNT));
        newPlan.set(billModel.P_PLANSETTLEDLOCAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_SETTLELOCALAMT));
        if (ObjectUtils.isEmpty((Object)dataEntity.getString(billModel.HEAD_SETTLESTATUS))) {
            dataEntity.set(billModel.HEAD_SETTLESTATUS, (Object)"unsettle");
        }
        if (isTansPay) {
            dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)("ap_finapbill".equals(entityName) ? "10" : "unverify"));
            dataEntity.set(billModel.HEAD_UNVERIFYAMOUNT, (Object)BigDecimal.ZERO);
        } else if (dataEntity.getBigDecimal(billModel.HEAD_UNVERIFYAMOUNT).compareTo(dataEntity.getBigDecimal(billModel.HEAD_AMOUNT)) == 0) {
            dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)("ap_finapbill".equals(entityName) ? "10" : "unverify"));
        } else if (dataEntity.getBigDecimal(billModel.HEAD_UNVERIFYAMOUNT).compareTo(BigDecimal.ZERO) == 0) {
            dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)("ap_finapbill".equals(entityName) ? "30" : "verified"));
        } else {
            dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)("ap_finapbill".equals(entityName) ? "20" : "partverify"));
        }
    }

    private Map<String, DynamicObject> getSourceBillMap(DynamicObject[] dataEntities, FinBillModel billModel) {
        HashMap<String, DynamicObject> sourceBillMap = new HashMap<String, DynamicObject>(8);
        HashMap<String, Set> billEntity4IdsMap = new HashMap<String, Set>(8);
        for (DynamicObject dataEntity : dataEntities) {
            String sourceBillType = dataEntity.getString("sourcebilltype");
            if (ObjectUtils.isEmpty((Object)sourceBillType)) continue;
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(billModel.ENTRY);
            Set sourceBillIds = billEntity4IdsMap.getOrDefault(sourceBillType, new HashSet(32));
            for (DynamicObject detail : entry) {
                String sourceBillId = detail.getString(billModel.E_SOURCEBILLID);
                if (ObjectUtils.isEmpty((Object)sourceBillId)) continue;
                sourceBillIds.add(Long.parseLong(sourceBillId));
            }
            if (sourceBillIds.isEmpty()) continue;
            billEntity4IdsMap.put(sourceBillType, sourceBillIds);
        }
        if (billEntity4IdsMap.isEmpty()) {
            return sourceBillMap;
        }
        for (Map.Entry entry : billEntity4IdsMap.entrySet()) {
            String entityName = (String)entry.getKey();
            Set sourceBillIds = (Set)entry.getValue();
            DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)entityName, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceBillIds)});
            for (DynamicObject sourceBill : sourceBills) {
                sourceBillMap.put(sourceBill.getString("id"), sourceBill);
            }
        }
        return sourceBillMap;
    }

    private void processFinApBill(DynamicObject dataEntity) {
        DynamicObject invRow;
        DynamicObjectCollection invEntry;
        String sourceBillType = dataEntity.getString("sourcebilltype");
        String billTypeId = dataEntity.getString("billtypeid.number");
        String asstactType = dataEntity.getString("asstacttype");
        DynamicObject asstact = dataEntity.getDynamicObject("asstact");
        if (ObjectUtils.isEmpty((Object)dataEntity.getString("freezestate"))) {
            dataEntity.set("freezestate", (Object)"unfreeze");
        }
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("detailentry");
        for (DynamicObject detail : entry) {
            if (!"bd_supplier".equals(asstactType)) continue;
            detail.set("e_invoicesupplierid", (Object)asstact);
            detail.set("e_deliversupplierid", (Object)asstact);
        }
        if ("ap_finapbill".equals(sourceBillType) && "ApFin_borr_BT_S".equals(billTypeId)) {
            dataEntity.set("isadjust", (Object)Boolean.TRUE);
            dataEntity.set("adjusttype", (Object)"adjustinv");
        }
        if (!(invEntry = dataEntity.getDynamicObjectCollection("inventry")).isEmpty() && ObjectUtils.isEmpty((Object)(invRow = (DynamicObject)invEntry.get(0)).getString("i_invoicecode")) && ObjectUtils.isEmpty((Object)invRow.getString("i_invoiceno"))) {
            invEntry.clear();
        }
        DynamicObjectCollection planEntity = dataEntity.getDynamicObjectCollection("planentity");
        ((DynamicObject)planEntity.get(0)).set("e_freezestate", (Object)"unfreeze");
    }

    private void processFinArBill(DynamicObject dataEntity) {
        String sourceBillType = dataEntity.getString("sourcebilltype");
        String billTypeId = dataEntity.getString("billtype.number");
        if ("ar_finarbill".equals(sourceBillType) && "arfin_borrowar_BT_S".equals(billTypeId)) {
            dataEntity.set("adjusttype", (Object)"adjustinv");
        }
    }

    private List<Tuple<String, String>> getSumAmtFieldList(String entityName) {
        ArrayList<Tuple<String, String>> sumAmtFieldList = new ArrayList<Tuple<String, String>>(16);
        if ("ap_finapbill".equals(entityName)) {
            sumAmtFieldList.add(Tuple.create((Object)"e_amount", (Object)"amount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_amountbase", (Object)"amountbase"));
            sumAmtFieldList.add(Tuple.create((Object)"e_tax", (Object)"tax"));
            sumAmtFieldList.add(Tuple.create((Object)"e_taxlocalamt", (Object)"taxlocamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_pricetaxtotal", (Object)"pricetaxtotal"));
            sumAmtFieldList.add(Tuple.create((Object)"e_pricetaxtotalbase", (Object)"pricetaxtotalbase"));
            sumAmtFieldList.add(Tuple.create((Object)"unsettleamt", (Object)"unsettleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"unsettleamtbase", (Object)"unsettleamountbase"));
            sumAmtFieldList.add(Tuple.create((Object)"settledamt", (Object)"settleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"settledamtbase", (Object)"settleamountbase"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unverifyamount", (Object)"unverifyamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_uninvoicedamt", (Object)"uninvoicedamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_adjustamount", (Object)"adjustamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_adjustlocalamt", (Object)"adjustlocalamt"));
        } else {
            sumAmtFieldList.add(Tuple.create((Object)"e_amount", (Object)"amount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_localamt", (Object)"localamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_tax", (Object)"tax"));
            sumAmtFieldList.add(Tuple.create((Object)"e_taxlocalamt", (Object)"taxlocamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_recamount", (Object)"recamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_reclocalamt", (Object)"reclocalamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unsettleamt", (Object)"unsettleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unsettlelocalamt", (Object)"unsettlelocalamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_settledamt", (Object)"settleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_settledlocalamt", (Object)"settlelocalamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unverifyamt", (Object)"unverifyamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_invoicedamt", (Object)"invoicedamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_invoicedlocalamt", (Object)"invoicedlocalamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_uninvoicedamt", (Object)"uninvoicedamt"));
            sumAmtFieldList.add((Tuple<String, String>)Tuple.create((Object)"e_uninvoicedlocalamt", (Object)"uninvoicedlocalamt"));
            sumAmtFieldList.add((Tuple<String, String>)Tuple.create((Object)"e_issueinvrecamt", (Object)"issueinvrecamt"));
            sumAmtFieldList.add((Tuple<String, String>)Tuple.create((Object)"e_issueinvreclocalamt", (Object)"issueinvreclocalamt"));
        }
        return sumAmtFieldList;
    }

    private DynamicObject[] getFinBills(String entityName, List<Long> billIds) {
        String selectors = "ap_finapbill".equals(entityName) ? "org,basecurrency,exratetable,e_amount,amount,e_amountbase,amountbase,e_tax,tax,e_taxlocalamt,taxlocamt,e_pricetaxtotal,pricetaxtotal,e_pricetaxtotalbase,pricetaxtotalbase,unsettleamt,unsettleamount,unsettleamtbase,unsettleamountbase,settledamt,settleamount,settledamtbase,settleamountbase,e_unverifyamount,unverifyamount,e_uninvoicedamt,uninvoicedamt,e_adjustamount,adjustamount,e_adjustlocalamt,adjustlocalamt,settlestatus,verifystatus,iswrittenoff,hadwrittenoff,e_sourcebillid,sourcebillid,billsrctype,istanspay,e_sourcebillentryid,currency,exchangerate,i_invoicecode,i_invoiceno,taxrateid,taxrate,verifyamount,freezestate,plansettledamt,plansettledlocamt,unplansettleamt,unplansettlelocamt,bizdate,billno,sourcebilltype,billtypeid,asstacttype,asstact,e_invoicesupplierid,e_deliversupplierid,plansettletype,settlementtype,e_freezestate,isadjust,adjusttype,creator,sourcebillno,p_payrate,verifyquantity,unverifyquantity,e_verifybaseqty,e_unverifybaseqty,lockedamt,unlockamt,planentity.seq,duedate,planduedate,planpricetax,planpricetaxloc,unplanlockamt,planlockedamt,e_baseunit,measureunit,material,quantity" : "e_amount,amount,e_localamt,localamt,e_tax,tax,e_taxlocalamt,taxlocamt,e_recamount,recamount,e_reclocalamt,reclocalamt,e_unsettleamt,unsettleamount,e_unsettlelocalamt,unsettlelocalamt,e_settledamt,settleamount,e_settledlocalamt,settlelocalamt,e_verifiedamt,e_unverifyamt,unverifyamount,exratetable,basecurrency,org,settlestatus,verifystatus,istransfer,hadwrittenoff,iswrittenoff,sourcebillid,e_srcid,e_srcentryid,currency,exchangerate,taxrateid,taxrate,plansettledamt,plansettledlocamt,unplansettleamt,unplansettlelocamt,bizdate,billno,creator,sourcebillno,sourcebilltype,p_recrate,e_verifiedqty,e_unverifyqty,e_verifybaseqty,e_unverifybaseqty,e_unlockamt,e_lockedamt,planduedate,planentity.seq,unplanlockamt,planlockedamt,duedate,settlementtype,plansettletype,planpricetax,planpricetaxloc,billtype,adjusttype,e_invoicedamt,invoicedamt,e_invoicedlocalamt,invoicedlocalamt,e_uninvoicedamt,uninvoicedamt,e_uninvoicedlocalamt,uninvoicedlocalamt,e_issueinvrecamt,issueinvrecamt,e_issueinvreclocalamt,issueinvreclocalamt,e_material,e_measureunit,e_baseunit,e_quantity,billsrctype";
        return BusinessDataServiceHelper.load((String)entityName, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        String entityName = this.billEntityType.getName();
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)(entityName.contains("ap_") ? "ap_init" : "ar_init"), (String)"exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }
}

