/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.journal.JournalService;

public class PrePaidReceivedAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PrePaidReceivedAfterProcess4EasOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("PrePaidReceivedAfterProcess4EasOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = this.getBills(e);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org.id"));
        }
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getLong("org.id");
            DynamicObject initObj = initObjMap.get(orgId);
            if (initObj == null) continue;
            if (dataEntity.getDynamicObject("exratetable") == null) {
                dataEntity.set("exratetable", (Object)initObj.getDynamicObject("exratetable"));
            }
            if (dataEntity.getDynamicObject("basecurrency") != null) continue;
            dataEntity.set("basecurrency", (Object)initObj.getDynamicObject("standardcurrency"));
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(dataEntities);
        logger.info("PrePaidReceivedAfterProcess4EasOp endOperationTransaction end.");
    }

    private DynamicObject[] getBills(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        boolean isAr = this.billEntityType.getName().startsWith("ar");
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)(isAr ? "ar_init" : "ap_init"), (String)"exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("org");
        selector.add("exratetable");
        selector.add("basecurrency");
        return selector;
    }
}

