/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.balance.BalanceRebuildService;
import kd.fi.arapcommon.eas.helper.EasSettleRecordHelper;
import kd.fi.arapcommon.eas.service.EasSettleRecordConvertService;
import kd.fi.arapcommon.enums.EasRecordToXhStatusEnum;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StdConfig;

public class EasMigrateService {
    private static final Log logger = LogFactory.getLog(EasMigrateService.class);

    public Long[] easRecordToXhRecord() {
        logger.info("EasSettleRecordConvertService easRecordToXhRecord begin.");
        QFilter filter = new QFilter("xhrecordstatus", "in", Arrays.asList(EasRecordToXhStatusEnum.UNPRODUCE.getValue(), EasRecordToXhStatusEnum.PRODUCEFAIL.getValue()));
        Object[] easSettleRecords = BusinessDataServiceHelper.load((String)"ap_eassettlerecord", (String)String.join((CharSequence)",", EasSettleRecordHelper.getEasSettleRecordSelectors()), (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object[])easSettleRecords)) {
            logger.info("EasSettleRecordConvertService easRecordToXhRecord easSettleRecords is Empty.");
            return new Long[0];
        }
        String easSettleRecordSplitNumber = StdConfig.get((String)"easSettleRecordSplitNumber");
        int splitNumber = ObjectUtils.isEmpty((Object)easSettleRecordSplitNumber) ? 5000 : Integer.parseInt(easSettleRecordSplitNumber);
        ArrayList<Object> hasSpiltEasSettleRecords = new ArrayList<Object>(64);
        ArrayList<Long> allXhSettleRecordIds = new ArrayList<Long>(64);
        int hasAddRowSize = 0;
        EasSettleRecordConvertService convertService = new EasSettleRecordConvertService();
        for (Object easSettleRecord : easSettleRecords) {
            hasSpiltEasSettleRecords.add(easSettleRecord);
            if ((hasAddRowSize += easSettleRecord.getDynamicObjectCollection("entry").size()) < splitNumber) continue;
            Long[] xhRecordIds = convertService.easRecordToXhRecord(hasSpiltEasSettleRecords.toArray(new DynamicObject[0]));
            allXhSettleRecordIds.addAll(Arrays.asList(xhRecordIds));
            hasSpiltEasSettleRecords.clear();
            hasAddRowSize = 0;
        }
        if (!hasSpiltEasSettleRecords.isEmpty()) {
            Long[] xhRecordIds = convertService.easRecordToXhRecord(hasSpiltEasSettleRecords.toArray(new DynamicObject[0]));
            allXhSettleRecordIds.addAll(Arrays.asList(xhRecordIds));
        }
        logger.info("EasSettleRecordConvertService easRecordToXhRecord end.");
        return allXhSettleRecordIds.toArray(new Long[0]);
    }

    public void rebuildBalance() {
        DynamicObjectCollection apInitColl = QueryServiceHelper.query((String)"ap_init", (String)"org.id,startdate", null);
        for (DynamicObject apInit : apInitColl) {
            long orgId = apInit.getLong("org.id");
            Date startdate = apInit.getDate("startdate");
            startdate = DateUtils.getLastDay((Date)startdate, (int)1);
            BalanceRebuildService service = new BalanceRebuildService(Long.valueOf(orgId), startdate, "ap");
            service.rebuild();
        }
        DynamicObjectCollection arInitColl = QueryServiceHelper.query((String)"ar_init", (String)"org.id,startdate", null);
        for (DynamicObject arInit : arInitColl) {
            long orgId = arInit.getLong("org.id");
            Date startdate = arInit.getDate("startdate");
            startdate = DateUtils.getLastDay((Date)startdate, (int)1);
            BalanceRebuildService service = new BalanceRebuildService(Long.valueOf(orgId), startdate, "ar");
            service.rebuild();
        }
    }

    public Map<String, Object> easMigrateBeforeCheck(Map<String, Object> inputArgs) {
        logger.info("EasSettleRecordConvertService easMigrateBeforeCheck begin,inputArgs is : " + inputArgs);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        logger.info("EasSettleRecordConvertService easMigrateBeforeCheck end.");
        return result;
    }
}

