/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.eas.helper.EasSettleBillInfoMakeupHelper;
import kd.fi.arapcommon.eas.settle.IEasSettleRecordAnalysis;
import kd.fi.arapcommon.enums.EasRecordOriginTypeEnum;
import kd.fi.arapcommon.enums.EasRecordToXhStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.settle.convert.SettleRecordConverter;
import kd.fi.arapcommon.util.MD5;
import kd.fi.arapcommon.vo.EasSettleRecordContext;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class EasSettleRecordConvertService {
    private static final Log logger = LogFactory.getLog(EasSettleRecordConvertService.class);
    private static final String EAS_AR_SETTLE_RECORD_BOSTYPE = "3C41FD86";
    private static final String EAS_AP_SETTLE_RECORD_BOSTYPE = "2F368848";
    private static final String DMW_EASIDCHANGE = "dmw_easidchange";

    public Long[] easRecordToXhRecord(DynamicObject[] easSettleRecords) {
        logger.info("EasSettleRecordConvertService easRecordToXhRecord begin.");
        if (ObjectUtils.isEmpty((Object[])easSettleRecords)) {
            return new Long[0];
        }
        ArrayList<DynamicObject> settleRecords = new ArrayList<DynamicObject>(64);
        try (TXHandle tx = TX.required();){
            logger.info("EasSettleRecordConvertService easRecordToXhRecord begin,easSettleRecords size :" + easSettleRecords.length);
            easSettleRecords = (DynamicObject[])Arrays.stream(easSettleRecords).filter(r -> EasRecordToXhStatusEnum.UNPRODUCE.getValue().equals(r.getString("xhrecordstatus")) || EasRecordToXhStatusEnum.PRODUCEFAIL.getValue().equals(r.getString("xhrecordstatus"))).toArray(DynamicObject[]::new);
            logger.info("EasSettleRecordConvertService easRecordToXhRecord filter later size : " + easSettleRecords.length);
            if (ObjectUtils.isEmpty((Object[])easSettleRecords)) {
                Long[] longArray = new Long[]{};
                return longArray;
            }
            try {
                Set easRecordIds = Arrays.stream(easSettleRecords).map(r -> r.getLong("id")).collect(Collectors.toSet());
                ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_eassettlerecord", (String)"ap_eassettlerecord_settle_lock", easRecordIds, (boolean)true);
                EasSettleRecordContext recordContext = this.contextInit(easSettleRecords);
                HashMap<Long, String> failMessageMap = new HashMap<Long, String>(64);
                HashMap<String, List<DynamicObject>> needSaveOtherBills = new HashMap<String, List<DynamicObject>>(8);
                ArrayList<DynamicObject> easidChangeList = new ArrayList<DynamicObject>(16);
                for (DynamicObject easSettleRecord : easSettleRecords) {
                    try {
                        DynamicObject[] tempSettleRecords;
                        recordContext.getNeedSaveOtherBillsMap().clear();
                        List<SettleRecordVO> settleRecordVOS = this.analysisEasRecord(easSettleRecord, recordContext);
                        if (ObjectUtils.isEmpty(settleRecordVOS)) {
                            throw new KDBizException("Please confirm the integrity of the EAS intermediate table data. If there are no issues, please try again.");
                        }
                        for (DynamicObject tempSettleRecord : tempSettleRecords = SettleRecordConverter.convertVO2Dyn(settleRecordVOS, false)) {
                            tempSettleRecord.set("id", (Object)recordContext.getUniqueKey());
                            this.makeupMainAndAsstBillInfo(tempSettleRecord, recordContext);
                            this.settleRecordSetCommonValue(tempSettleRecord, easSettleRecord);
                        }
                        List<DynamicObject> tempEasidChangeList = this.prepareDmwDynamicObject(tempSettleRecords, easSettleRecord);
                        if (!ObjectUtils.isEmpty(tempEasidChangeList)) {
                            easidChangeList.addAll(tempEasidChangeList);
                        }
                        for (Map.Entry<String, List<DynamicObject>> entrySet : recordContext.getNeedSaveOtherBillsMap().entrySet()) {
                            List otherBills = needSaveOtherBills.getOrDefault(entrySet.getKey(), new ArrayList(16));
                            otherBills.addAll((Collection)entrySet.getValue());
                            needSaveOtherBills.put(entrySet.getKey(), otherBills);
                        }
                        settleRecords.addAll(Arrays.asList(tempSettleRecords));
                    }
                    catch (Exception e) {
                        failMessageMap.put(easSettleRecord.getLong("id"), ArApHelper.getStackTraceMessage((Throwable)e));
                    }
                }
                logger.info("EasSettleRecordConvertService easRecordToXhRecord failMessageMap ids is: " + failMessageMap.keySet());
                this.writeBackEasSettleRecord(easSettleRecords, failMessageMap);
                logger.info("EasSettleRecordConvertService easRecordToXhRecord settleRecords is: " + settleRecords.size());
                if (!settleRecords.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])settleRecords.toArray(new DynamicObject[0]));
                    JournalService journalService = new JournalService();
                    journalService.pushAndSaveJournals(settleRecords.toArray(new DynamicObject[0]));
                }
                logger.info("EasSettleRecordConvertService easRecordToXhRecord needSaveOtherBills is: " + needSaveOtherBills.keySet());
                for (Map.Entry entry : needSaveOtherBills.entrySet()) {
                    SaveServiceHelper.save((DynamicObject[])((List)entry.getValue()).toArray(new DynamicObject[0]));
                }
                this.insertDmwTableData(easidChangeList);
                this.saveLiquidateBotpRelation(needSaveOtherBills);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw e;
            }
        }
        Object[] successXhRecordIds = (Long[])settleRecords.stream().map(r -> r.getLong("id")).toArray(Long[]::new);
        logger.info("EasSettleRecordConvertService easRecordToXhRecord end,successXhRecordIds is : " + Arrays.toString(successXhRecordIds));
        return successXhRecordIds;
    }

    private void insertDmwTableData(List<DynamicObject> easidChangeList) {
        logger.info("EasSettleRecordConvertService insertDmwTableData easidChangeList is : " + easidChangeList.size());
        if (easidChangeList.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"insertDmwTableData");){
            try {
                Set easRecordIds = easidChangeList.stream().map(bill -> bill.getString("easparentid")).collect(Collectors.toSet());
                QFilter filter = new QFilter("easparentid", "in", easRecordIds);
                filter.and(new QFilter("bostype", "in", Arrays.asList(EAS_AP_SETTLE_RECORD_BOSTYPE, EAS_AR_SETTLE_RECORD_BOSTYPE)));
                DeleteServiceHelper.delete((String)DMW_EASIDCHANGE, (QFilter[])new QFilter[]{filter});
                SaveServiceHelper.save((DynamicObject[])easidChangeList.toArray(new DynamicObject[0]));
            }
            catch (Exception exc) {
                logger.info("EasSettleRecordConvertService insertDmwTableData error : " + exc.getMessage());
                tx.markRollback();
                throw exc;
            }
        }
        logger.info("EasSettleRecordConvertService insertDmwTableData end.");
    }

    private EasSettleRecordContext contextInit(DynamicObject[] easSettleRecords) {
        EasSettleRecordContext recordContext = new EasSettleRecordContext();
        HashMap<String, Set<Long>> billEntity4BillIds = new HashMap<String, Set<Long>>(8);
        for (DynamicObject easSettleRecord : easSettleRecords) {
            DynamicObjectCollection entry = easSettleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String billEntity = row.getString("e_billentity");
                Set billIds = billEntity4BillIds.getOrDefault(billEntity, new HashSet(64));
                billIds.add(row.getLong("e_billid"));
                billEntity4BillIds.put(billEntity, billIds);
            }
        }
        EasSettleBillInfoMakeupHelper.getBillMapInfo(billEntity4BillIds, recordContext);
        return recordContext;
    }

    private List<SettleRecordVO> analysisEasRecord(DynamicObject easSettleRecord, EasSettleRecordContext recordContext) {
        ArrayList<SettleRecordVO> settleRecordEasVOS = new ArrayList<SettleRecordVO>(64);
        Set<String> finSelfAnalysisSettleRelation = this.getEasRecordFinSelfAnalysisSettleRe();
        String originType = easSettleRecord.getString("origintype");
        String settleRelation = easSettleRecord.getString("settlerelation");
        if (EasRecordOriginTypeEnum.FROMBILL.getValue().equals(originType)) {
            if (finSelfAnalysisSettleRelation.contains(settleRelation)) {
                IEasSettleRecordAnalysis easSettleAnalysisImpl = recordContext.getEasSettleRecordAnalysisMap("easFinSelfSettle");
                settleRecordEasVOS.addAll(easSettleAnalysisImpl.analysis(easSettleRecord, recordContext));
            }
        } else if (EasRecordOriginTypeEnum.EASRECORD.getValue().equals(originType)) {
            DynamicObjectCollection easEntry = easSettleRecord.getDynamicObjectCollection("entry");
            List billEntityList = easEntry.stream().map(row -> row.getString("e_billentity")).distinct().collect(Collectors.toList());
            String billEntitys = String.join((CharSequence)"-", billEntityList);
            IEasSettleRecordAnalysis easSettleAnalysisImpl = recordContext.getEasSettleRecordAnalysisMap(billEntitys);
            settleRecordEasVOS.addAll(easSettleAnalysisImpl.analysis(easSettleRecord, recordContext));
        } else if (EasRecordOriginTypeEnum.EASLIQUIDATE.getValue().equals(originType)) {
            IEasSettleRecordAnalysis easSettleAnalysisImpl = recordContext.getEasSettleRecordAnalysisMap("easliquidate-" + settleRelation);
            settleRecordEasVOS.addAll(easSettleAnalysisImpl.analysis(easSettleRecord, recordContext));
        }
        return settleRecordEasVOS;
    }

    private List<DynamicObject> prepareDmwDynamicObject(DynamicObject[] tempSettleRecords, DynamicObject easSettleRecord) {
        ArrayList<DynamicObject> easidChangeList = new ArrayList<DynamicObject>(16);
        if (!EasRecordOriginTypeEnum.EASRECORD.getValue().equals(easSettleRecord.getString("origintype"))) {
            return easidChangeList;
        }
        HashMap<String, List> entity4SettleRecordMap = new HashMap<String, List>(2);
        for (DynamicObject tempSettleRecord : tempSettleRecords) {
            SettleRelationEnum settleRelation = SettleRelationEnum.getSettleRelationEnumByValue((String)tempSettleRecord.getString("settlerelation"));
            String xhRecordEntityName = "ap_settlerecord";
            if (settleRelation != null) {
                xhRecordEntityName = settleRelation.isAp() ? "ap_settlerecord" : "ar_settlerecord";
            }
            List recordList = entity4SettleRecordMap.getOrDefault(xhRecordEntityName, new ArrayList(8));
            recordList.add(tempSettleRecord);
            entity4SettleRecordMap.put(xhRecordEntityName, recordList);
        }
        String easRecordId = easSettleRecord.getString("srcsysbillid");
        String easRecordBosType = easSettleRecord.getBoolean("isfromar") ? EAS_AR_SETTLE_RECORD_BOSTYPE : EAS_AP_SETTLE_RECORD_BOSTYPE;
        for (Map.Entry entrySet : entity4SettleRecordMap.entrySet()) {
            String xhRecordEntityName = (String)entrySet.getKey();
            List settleRecords = (List)entrySet.getValue();
            for (DynamicObject settleRecord : settleRecords) {
                DynamicObject easIdChange = BusinessDataServiceHelper.newDynamicObject((String)DMW_EASIDCHANGE);
                easIdChange.set("bostype", (Object)easRecordBosType);
                easIdChange.set("easparentid", (Object)easRecordId);
                StringBuilder entryEASId = new StringBuilder(easSettleRecord.getString("id"));
                entryEASId.append(settleRecord.getString("mainbillentryid"));
                DynamicObjectCollection recordEntry = settleRecord.getDynamicObjectCollection("entry");
                for (DynamicObject row : recordEntry) {
                    entryEASId.append(row.getString("billentryid"));
                }
                easIdChange.set("easentryid", (Object)MD5.md5crypt((String)entryEASId.toString()));
                easIdChange.set("conentity", (Object)xhRecordEntityName);
                easIdChange.set("conparentid", (Object)settleRecord.getLong("id"));
                easidChangeList.add(easIdChange);
            }
        }
        return easidChangeList;
    }

    private void saveLiquidateBotpRelation(Map<String, List<DynamicObject>> needSaveOtherBills) {
        if (needSaveOtherBills.isEmpty()) {
            return;
        }
        logger.info("EasSettleRecordConvertService saveLiquidateBotpRelation needSaveOtherBills is: " + needSaveOtherBills.keySet());
        for (Map.Entry<String, List<DynamicObject>> entrySet : needSaveOtherBills.entrySet()) {
            String billEntityName = entrySet.getKey();
            if (!"ap_liquidation".equals(billEntityName) && !"ar_liquidation".equals(billEntityName)) continue;
            List<DynamicObject> liquidateBills = entrySet.getValue();
            HashMap<String, Map> source4NeedSaveBotpMap = new HashMap<String, Map>(2);
            for (DynamicObject dynamicObject : liquidateBills) {
                String sourceBillType = dynamicObject.getString("sourcebilltype");
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                Map needSaveBotpMap = source4NeedSaveBotpMap.getOrDefault(sourceBillType, new HashMap(8));
                needSaveBotpMap.put(dynamicObject.getLong("id"), Collections.singletonList(((DynamicObject)entryEntity.get(0)).getLong("sourcebillid")));
                source4NeedSaveBotpMap.put(sourceBillType, needSaveBotpMap);
            }
            logger.info("EasSettleRecordConvertService saveLiquidateBotpRelation source4NeedSaveBotpMap is: " + source4NeedSaveBotpMap);
            for (Map.Entry entry : source4NeedSaveBotpMap.entrySet()) {
                String sourceName = (String)entry.getKey();
                Map needSaveBotpMap = (Map)entry.getValue();
                BillRelationBuilder billRelationBuilder = new BillRelationBuilder(sourceName, billEntityName);
                for (Map.Entry entrySet2 : needSaveBotpMap.entrySet()) {
                    billRelationBuilder.saveRelation((Collection)entrySet2.getValue(), (Long)entrySet2.getKey());
                }
            }
        }
    }

    private void makeupMainAndAsstBillInfo(DynamicObject settleRecord, EasSettleRecordContext recordContext) {
        String mainBillEntity = settleRecord.getString("billentity");
        EasSettleBillInfoMakeupHelper.settleRecordBillInfoMakeUpByMain(mainBillEntity, recordContext, settleRecord);
        DynamicObjectCollection entry = settleRecord.getDynamicObjectCollection("entry");
        String asstBillEntity = ((DynamicObject)entry.get(0)).getString("e_billentity");
        EasSettleBillInfoMakeupHelper.settleRecordBillInfoMakeUpByAsst(asstBillEntity, recordContext, (List<DynamicObject>)entry);
    }

    private void settleRecordSetCommonValue(DynamicObject settleRecord, DynamicObject easSettleRecord) {
        settleRecord.set("billstatus", (Object)"C");
        settleRecord.set("settletype", (Object)"fromeas");
        settleRecord.set("org", easSettleRecord.get("org"));
        settleRecord.set("settledate", (Object)easSettleRecord.getDate("settledate"));
        settleRecord.set("settleentry", (Object)"1");
        DynamicObjectCollection entry = settleRecord.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            row.set("e_settleentry", (Object)"1");
        }
        settleRecord.set("creator", easSettleRecord.get("creator"));
        settleRecord.set("modifier", easSettleRecord.get("modifier"));
        settleRecord.set("modifytime", easSettleRecord.get("modifytime"));
        settleRecord.set("iswrittenoff", easSettleRecord.get("isreversebill"));
        settleRecord.set("hadwrittenoff", easSettleRecord.get("isreversed"));
    }

    private void writeBackEasSettleRecord(DynamicObject[] easSettleRecords, Map<Long, String> failMessageMap) {
        List recordIds = Arrays.stream(easSettleRecords).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        for (DynamicObject easRecord : easSettleRecords = BusinessDataServiceHelper.load((String)"ap_eassettlerecord", (String)"failmessage,failmessage_tag,xhrecordstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", recordIds)})) {
            String failMassage = failMessageMap.get(easRecord.getLong("id"));
            if (failMassage == null) {
                easRecord.set("failmessage", (Object)" ");
                easRecord.set("failmessage_tag", (Object)" ");
                easRecord.set("xhrecordstatus", (Object)EasRecordToXhStatusEnum.HASPRODUCE.getValue());
                continue;
            }
            easRecord.set("xhrecordstatus", (Object)EasRecordToXhStatusEnum.PRODUCEFAIL.getValue());
            easRecord.set("failmessage", (Object)(failMassage.length() > 255 ? failMassage.substring(0, 255) : failMassage));
            easRecord.set("failmessage_tag", (Object)failMassage);
        }
        SaveServiceHelper.save((DynamicObject[])easSettleRecords);
    }

    private Set<String> getEasRecordFinSelfAnalysisSettleRe() {
        HashSet<String> finSelfSettleRelations = new HashSet<String>(8);
        finSelfSettleRelations.add(SettleRelationEnum.PAYTRANS.getValue());
        finSelfSettleRelations.add(SettleRelationEnum.APWRITEOFF.getValue());
        finSelfSettleRelations.add(SettleRelationEnum.ARTRANSFER.getValue());
        finSelfSettleRelations.add(SettleRelationEnum.ARWRITEOFF.getValue());
        finSelfSettleRelations.add(SettleRelationEnum.ARSELF.getValue());
        finSelfSettleRelations.add(SettleRelationEnum.BADDEBTLOSS.getValue());
        return finSelfSettleRelations;
    }
}

