/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.monitor;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ArapSettleDataAmountMonitor {
    public static final Log logger = LogFactory.getLog(ArapSettleDataAmountMonitor.class);
    private static Object MAIN_GAUGE = null;
    private static Object ASST_GAUGE = null;
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final ConcurrentHashMap<Integer, String> mainRecords = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, String> asstRecords = new ConcurrentHashMap();

    public static void recordData(Integer mainDataAmount, Integer asstDataAmount) {
        if (MAIN_GAUGE != null && ASST_GAUGE != null) {
            logger.info("record data...");
            try {
                Method labelsMethod = MAIN_GAUGE.getClass().getDeclaredMethod("labels", String[].class);
                Method setMethod = MAIN_GAUGE.getClass().getDeclaredMethod("set", Double.TYPE);
                setMethod.invoke(MAIN_GAUGE, mainDataAmount);
            }
            catch (Exception e) {
                logger.warn("record data failed:", (Throwable)e);
            }
        }
    }

    public static void recordData(int mainBillAmount, int asstBillAmount, long costTime) {
        ArapSettleDataAmountMonitor.recordHistogramData("ap_settle_main_bill_count", "settle main bill count", new double[]{10.0, 25.0, 50.1, 200.0, 300.0, 400.0, 500.0, 1000.0, 2000.0, 5000.0}, mainBillAmount);
        ArapSettleDataAmountMonitor.recordHistogramData("ap_settle_asst_bill_count", "settle asst bill count", new double[]{10.0, 25.0, 50.1, 200.0, 300.0, 400.0, 500.0, 1000.0, 2000.0, 5000.0}, asstBillAmount);
        ArapSettleDataAmountMonitor.recordHistogramData("ap_settle_cost", "settle time cost", new double[]{100.0, 300.0, 500.0, 1000.0, 2000.0, 3000.0, 5000.0, 10000.0, 60000.0}, costTime);
    }

    public static void recordHistogramData(String name, String help, double[] buckets, double data) {
        try {
            Class<?> kdHistogram = Class.forName("kd.bos.monitor.sdk.KDHistogram");
            Method kdHistogramBuildMethod = kdHistogram.getDeclaredMethod("build", String.class, String.class, double[].class);
            Object kdHistogramInstance = kdHistogramBuildMethod.invoke(null, name, help, buckets);
            Method kdHistogramObserveMethod = kdHistogramInstance.getClass().getDeclaredMethod("observe", Double.TYPE);
            kdHistogramObserveMethod.invoke(kdHistogramInstance, data);
        }
        catch (Exception e) {
            logger.warn("record data error: ", (Throwable)e);
        }
    }

    static {
        try {
            Class<?> kdGaugeClass = Class.forName("kd.bos.monitor.sdk.KDGauge");
            Method gaugeBuildMethod = kdGaugeClass.getDeclaredMethod("build", String.class, String.class, String[].class);
            Object labelNames = null;
            MAIN_GAUGE = gaugeBuildMethod.invoke(null, "manuel_settle_data_amount_main", "manuel settle main bill data amount", labelNames);
            ASST_GAUGE = gaugeBuildMethod.invoke(null, "manuel_settle_data_amount_asst", "manuel settle assist bill data amount", labelNames);
        }
        catch (Exception e) {
            logger.warn("gauge instance create failed: ", (Throwable)e);
        }
    }
}

