/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.journal.convert.BasedataBatchReader;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.SingleValAggFunction;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.IPreAcctageRptProvider;
import kd.fi.arapcommon.report.acctage.PreAcctageRptFactory;
import kd.fi.arapcommon.report.acctage.PreAcctageRptParam;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class PreAcctageHelper {
    public static PreAcctageRptParam setCommonParam(ReportQueryParam queryParam, String entityKey) {
        String sumSetting;
        int j;
        FilterInfo filterInfo = queryParam.getFilter();
        PreAcctageRptParam param = new PreAcctageRptParam();
        param.setOrgIds(DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("orgs")));
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            param.setAsstactType(asstactType);
            String asstact = filterInfo.getString(asstactType);
            if ("other".equals(asstactType) && EmptyUtils.isNotEmpty((Object)asstact)) {
                String[] orders = asstact.split(";");
                ArrayList<String> asstactPks = new ArrayList<String>(Arrays.asList(orders));
                param.setAsstactPks(asstactPks);
            } else if (!"other".equals(asstactType)) {
                DynamicObjectCollection acctacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
                param.setAsstactPks(ReportHelper.getBasedataIds((List)acctacts));
            }
        }
        param.setCurrencyIds(DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("q_currency")));
        Date queryDate = filterInfo.getDate("date");
        if (queryDate != null) {
            queryDate = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        }
        param.setQueryDate(queryDate);
        String compareDateFieldKey = filterInfo.getString("standard");
        param.setCompareDateField(compareDateFieldKey);
        DynamicObjectCollection paymentTypes = queryParam.getFilter().getDynamicObjectCollection("paymentbilltypes");
        param.setPaymentTypes((List)paymentTypes);
        param.setShowlocalamt(filterInfo.getBoolean("showlocalamt"));
        param.setShowbybill(filterInfo.getBoolean("showbybill"));
        param.setContainson(filterInfo.getBoolean("containson"));
        param.setBillEntity(entityKey);
        String groupStr = (String)filterInfo.getFilterItem("groups").getValue();
        List groups = SerializationUtils.fromJsonStringToList((String)groupStr, AcctageGroup.class);
        param.setGroups(groups);
        ArrayList<Field> groupFields = new ArrayList<Field>(groups.size() * 2);
        for (j = 0; j < groups.size(); ++j) {
            groupFields.add(new Field(AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)groups.get(j)), (String)"balance"), (DataType)DataType.BigDecimalType));
        }
        if (param.isShowlocalamt()) {
            for (j = 0; j < groups.size(); ++j) {
                groupFields.add(new Field(AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)groups.get(j)), (String)"localbalance"), (DataType)DataType.BigDecimalType));
            }
        }
        param.setGroupFields(groupFields);
        String statisticalDimensionSetting = filterInfo.getString("statisticaldimension");
        String[] statisticalDimensions = statisticalDimensionSetting.split("[,]");
        HashSet<String> statisticalDimensionList = new HashSet<String>(Arrays.asList(statisticalDimensions));
        statisticalDimensionList.add("currency");
        if (param.isShowlocalamt()) {
            statisticalDimensionList.add("basecurrency");
        }
        for (String dimension : statisticalDimensionList) {
            if (("cas_recbill".equals(entityKey) || "ar_receivedbill".equals(entityKey)) && "asstact".equals(dimension)) {
                param.addStatisticalDimentions(new String[]{"asstact_name"});
                continue;
            }
            param.addStatisticalDimentions(new String[]{dimension});
        }
        param.addStatisticalAmtField(new String[]{"recamt"});
        param.addStatisticalAmtField(new String[]{"balance"});
        if (param.isShowlocalamt()) {
            param.addStatisticalAmtField(new String[]{"localrecamt"});
            param.addStatisticalAmtField(new String[]{"localbalance"});
        }
        for (Field groupField : groupFields) {
            param.addStatisticalAmtField(new String[]{groupField.getAlias()});
        }
        if (param.isShowbybill() && !EmptyUtils.isEmpty((Object)(sumSetting = queryParam.getFilter().getString("sumsetting"))) && !"NULL".equals(sumSetting)) {
            String[] sumsettings = sumSetting.split("[,]");
            for (String sumsetting : sumsettings) {
                param.addSumDimensions(new String[]{sumsetting});
            }
            param.addSumAmtFields(new String[]{"recamt"});
            param.addSumAmtFields(new String[]{"balance"});
            if (param.isShowlocalamt()) {
                param.addSumAmtFields(new String[]{"localrecamt"});
                param.addSumAmtFields(new String[]{"localbalance"});
            }
            for (Field groupField : groupFields) {
                param.addSumAmtFields(new String[]{groupField.getAlias()});
            }
        }
        param.setIsHyperLinkClick(filterInfo.getBoolean("isHyperLinkClickByGroup"));
        param.getFilters().addAll(PreAcctageHelper.getQFilter(param, entityKey));
        return param;
    }

    public static DataSet queryBill(PreAcctageRptParam param) {
        String billEntity = param.getBillEntity();
        IPreAcctageRptProvider provider = PreAcctageRptFactory.getPerAcctageRptProvider((String)billEntity);
        DataSet rawDataSet = QueryServiceHelper.queryDataSet((String)"commonquery", (String)billEntity, (String)String.join((CharSequence)",", provider.selectFields(param)), (QFilter[])param.getFilters().toArray(new QFilter[0]), null);
        String[] selectFields = rawDataSet.getRowMeta().getFieldNames();
        SumParam sumParams = provider.afterLoadBillSumField(param);
        GroupbyDataSet groupDataSet = rawDataSet.groupBy(sumParams.getGroupByFields().toArray(new String[0]));
        for (String sumField : sumParams.getSummaryFields()) {
            groupDataSet.sum(sumField);
        }
        for (String field : selectFields) {
            if (sumParams.getGroupByFields().contains(field) || sumParams.getSummaryFields().contains(field)) continue;
            groupDataSet.agg((CustomAggFunction)new SingleValAggFunction((DataType)DataType.AnyType), field, field);
        }
        DataSet dataSetRes = groupDataSet.finish();
        rawDataSet.close();
        return dataSetRes;
    }

    public static DataSet loadSettleRecord(PreAcctageRptParam param) {
        List currencyIds;
        List orgIds;
        ArrayList<QFilter> allFilters = new ArrayList<QFilter>();
        Date date = param.getQueryDate();
        if (date != null) {
            Date compareDate = DateUtils.getDataFormat((Date)date, (boolean)false);
            allFilters.add(new QFilter("settledate", ">", (Object)compareDate));
        }
        if (!(orgIds = param.getOrgIds()).isEmpty()) {
            allFilters.add(new QFilter("org", "in", (Object)orgIds));
        }
        ArrayList<QFilter> mainSettleRecordFilters = new ArrayList<QFilter>();
        String asstactType = param.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            mainSettleRecordFilters.add(new QFilter("mainasstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty((Object)(currencyIds = param.getCurrencyIds()))) {
            mainSettleRecordFilters.add(new QFilter("maincurrency", "in", (Object)currencyIds));
        }
        mainSettleRecordFilters.add(new QFilter("billentity", "=", (Object)param.getBillEntity()));
        mainSettleRecordFilters.addAll(allFilters);
        String mainSelectField = "mainbillid as mainbillid,totalsettleamt,localtotalsettleamt";
        if (param.getBillEntity().contains("cas_")) {
            mainSelectField = "mainbillentryid as mainbillid,totalsettleamt,localtotalsettleamt";
        }
        DataSet mainSettleRecords = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ap_settlerecord", (String)mainSelectField, (QFilter[])mainSettleRecordFilters.toArray(new QFilter[0]), null);
        ArrayList<QFilter> asstSettleRecordFilters = new ArrayList<QFilter>();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstSettleRecordFilters.add(new QFilter("entry.asstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty((Object)currencyIds)) {
            asstSettleRecordFilters.add(new QFilter("entry.currency", "in", (Object)currencyIds));
        }
        asstSettleRecordFilters.add(new QFilter("entry.e_billentity", "=", (Object)param.getBillEntity()));
        asstSettleRecordFilters.addAll(allFilters);
        String asstSelectField = "entry.billid as mainbillid,entry.settleamt as totalsettleamt,entry.localsettleamt as localtotalsettleamt";
        if (param.getBillEntity().contains("cas_")) {
            asstSelectField = "entry.billentryid as mainbillid,entry.settleamt as totalsettleamt,entry.localsettleamt as localtotalsettleamt";
        }
        DataSet asstSettleRecords = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_settlerecord", (String)asstSelectField, (QFilter[])asstSettleRecordFilters.toArray(new QFilter[0]), null);
        DataSet settleRecords = mainSettleRecords.union(asstSettleRecords);
        mainSettleRecords.close();
        asstSettleRecords.close();
        DataSet groupBySettleRecords = settleRecords.groupBy(new String[]{"mainbillid"}).sum("totalsettleamt").sum("localtotalsettleamt").finish();
        return groupBySettleRecords;
    }

    private static List<QFilter> getQFilter(PreAcctageRptParam param, String billEntity) {
        Date date;
        List currencyIds;
        String asstactType;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        IPreAcctageRptProvider provider = PreAcctageRptFactory.getPerAcctageRptProvider((String)billEntity);
        List orgIds = param.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter(provider.getOrgEntity(), "in", (Object)orgIds));
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = param.getAsstactType()))) {
            filters.add(new QFilter(provider.getAsstactTypeEntity(), "=", (Object)asstactType));
        }
        if (ObjectUtils.isEmpty((Object)asstactType) && ("ap_paidbill".equals(param.getBillEntity()) || "cas_paybill".equals(param.getBillEntity()))) {
            ArrayList<String> asstactTypes = new ArrayList<String>();
            asstactTypes.add("bd_supplier");
            asstactTypes.add("bd_customer");
            asstactTypes.add("bos_user");
            filters.add(new QFilter(provider.getAsstactTypeEntity(), "in", asstactTypes));
        } else if (ObjectUtils.isEmpty((Object)asstactType)) {
            filters.add(new QFilter(provider.getAsstactTypeEntity(), "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user", "bos_org", "other")));
        }
        if (EmptyUtils.isNotEmpty((Object)param.getAsstactPks())) {
            if ("cas_recbill".equals(billEntity) && "other".equals(asstactType)) {
                filters.add(new QFilter("payername", "in", (Object)param.getAsstactPks()));
            } else if ("other".equals(asstactType)) {
                filters.add(new QFilter(provider.getAsstactEntity() + ".name", "in", (Object)param.getAsstactPks()));
            } else {
                filters.add(new QFilter(provider.getAsstactEntity(), "in", (Object)param.getAsstactPks()));
            }
        }
        if ((currencyIds = param.getCurrencyIds()) != null && !currencyIds.isEmpty()) {
            filters.add(new QFilter(provider.getCurrencyEntity(), "in", (Object)currencyIds));
        }
        if ((date = param.getQueryDate()) != null) {
            Date compareDate = DateUtils.getDataFormat((Date)date, (boolean)false);
            filters.add(new QFilter(provider.getDateEntity(param.getCompareDateField()), "<=", (Object)compareDate));
        }
        filters.add(new QFilter("billstatus", "in", (Object)provider.getBillStatus(param.isContainson())));
        List paymentTypes = param.getPaymentTypes();
        if (!ObjectUtils.isEmpty((Object)paymentTypes)) {
            List billTypeIds = DynamicObjectHelper.getIdList((Collection)paymentTypes);
            filters.add(new QFilter(provider.getPaymentBillTypeEntity(), "in", (Object)billTypeIds));
        }
        filters.addAll(provider.queryBillFilter());
        return filters;
    }

    public static DataSet divideAmountIntoGroup(DataSet dataSet, PreAcctageRptParam param) {
        List groups = param.getGroups();
        Field[] fields = dataSet.getRowMeta().getFields();
        int asstactTypeIndex = -1;
        int asstactIndex = -1;
        int asstactNameIndex = -1;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ("asstacttype".equalsIgnoreCase(field.getName())) {
                asstactTypeIndex = i;
                continue;
            }
            if ("asstact".equalsIgnoreCase(field.getName())) {
                asstactIndex = i;
                continue;
            }
            if (!"asstact_name".equalsIgnoreCase(field.getName())) continue;
            asstactNameIndex = i;
        }
        int oldLength = fields.length;
        List groupFields = param.getGroupFields();
        int newLength = oldLength + groupFields.size();
        Field[] newFields = Arrays.copyOf(fields, newLength);
        for (int i = 0; i < groupFields.size(); ++i) {
            newFields[oldLength + i] = (Field)groupFields.get(i);
        }
        DataSetBuilder dataSetBuilder = Algo.create((String)"ap.acctagegroup.DivideGroup").createDataSetBuilder(new RowMeta(newFields));
        BasedataBatchReader basedataBatchReader = new BasedataBatchReader();
        for (Row row : dataSet) {
            Object amt;
            AcctageGroup group;
            int j;
            int i;
            Object[] rowData = new Object[newLength];
            for (i = 0; i < oldLength; ++i) {
                rowData[i] = row.get(i);
            }
            if (asstactTypeIndex >= 0 && asstactIndex >= 0) {
                basedataBatchReader.addParam((String)rowData[asstactTypeIndex], rowData[asstactIndex]);
            }
            for (i = oldLength; i < newLength; ++i) {
                rowData[i] = 0;
            }
            Date compareDate = row.getDate(param.getCompareDateField());
            for (j = 0; j < groups.size(); ++j) {
                group = (AcctageGroup)groups.get(j);
                if (!AcctageHelper.match((AcctageGroup)group, (Date)param.getQueryDate(), (Date)compareDate)) continue;
                rowData[oldLength + j] = amt = row.get("balance");
                break;
            }
            if (param.isShowlocalamt()) {
                for (j = 0; j < groups.size(); ++j) {
                    group = (AcctageGroup)groups.get(j);
                    if (!AcctageHelper.match((AcctageGroup)group, (Date)param.getQueryDate(), (Date)compareDate)) continue;
                    rowData[oldLength + groups.size() + j] = amt = row.get("localbalance");
                    break;
                }
            }
            if (param.getIsHyperLinkClick()) {
                BigDecimal balanceAmount = new BigDecimal(rowData[oldLength].toString());
                if (balanceAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                dataSetBuilder.append(rowData);
                continue;
            }
            dataSetBuilder.append(rowData);
        }
        DataSet tempDataSet = dataSetBuilder.build();
        dataSetBuilder = Algo.create((String)"ap.acctagegroup.DivideGroup").createDataSetBuilder(new RowMeta(newFields));
        while (tempDataSet.hasNext()) {
            DynamicObject basedata;
            Row row = tempDataSet.next();
            Object[] rowData = new Object[newLength];
            for (int i = 0; i < newLength; ++i) {
                rowData[i] = row.get(i);
            }
            if (asstactTypeIndex >= 0 && asstactIndex >= 0 && (basedata = basedataBatchReader.read((String)rowData[asstactTypeIndex], rowData[asstactIndex])) != null) {
                long masterId = basedata.getLong("masterid");
                if (masterId != 0L) {
                    rowData[asstactIndex] = masterId;
                }
                if (asstactNameIndex >= 0 && asstactNameIndex < rowData.length) {
                    rowData[asstactNameIndex] = basedata.getString("name");
                }
            }
            dataSetBuilder.append(rowData);
        }
        return dataSetBuilder.build();
    }
}

