/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.exception.ManaulSettleQueryException;
import kd.fi.arapcommon.filterscheme.FilterSchemeHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApLicenseServiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.monitor.ArapSettleDataAmountMonitor;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.ext.ManualSettleExtColumnHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleHelper;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.service.manualsettle.ManualSettleServletBillProviderFactory;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderFactory;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;
import kd.fi.arapcommon.service.settleconsole.IBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.SettleConsoleBaseHandler;
import kd.fi.arapcommon.service.settleconsole.SettleConsoleSettleFactory;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ManualSettleParam;

public class SettleConsoleRightHandler
extends SettleConsoleBaseHandler {
    private static final Log log = LogFactory.getLog(SettleConsoleRightHandler.class);
    private String entityName;
    private List<String> mainListFields;
    private List<String> asstListFields;
    private IBillDataProvider mainProvider;
    private IBillDataProvider asstProvider;
    private static final String PERMISSION_SETTLE = "/SJ=C433GRR6";

    public SettleConsoleRightHandler() {
    }

    public SettleConsoleRightHandler(IFormView view, AbstractFormPlugin plugin, String entityName, String initEntityName) {
        super(view, plugin, initEntityName);
        this.entityName = entityName;
    }

    public void addListeners() {
        EntryGrid apGrid = (EntryGrid)this.getControl("mainbill");
        apGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                EntryGrid entryGrid = (EntryGrid)evt.getSource();
                SettleConsoleRightHandler.this.calCurSettleAmt(entryGrid, "summary_main", "currency", "cursettleamt");
            }
        });
        EntryGrid payGrid = (EntryGrid)this.getControl("asstbill");
        payGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                EntryGrid entryGrid = (EntryGrid)evt.getSource();
                SettleConsoleRightHandler.this.calCurSettleAmt(entryGrid, "summary_asst", "asst_currency", "asst_cursettleamt");
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        Object oldValue = changeData[0].getOldValue();
        String name = e.getProperty().getName();
        if ("cursettleamt".equals(name)) {
            BigDecimal curSettleAmt = (BigDecimal)newValue;
            EntryGrid entryGrid = (EntryGrid)this.getControl("mainbill");
            DynamicObject focusRow = this.getModel().getEntryRowEntity("mainbill", rowIndex);
            BigDecimal unSettleAmt = focusRow.getBigDecimal("enableamt");
            if (curSettleAmt.abs().compareTo(unSettleAmt.abs()) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5141\u8bb8\u7ed3\u7b97\u91d1\u989d\u3002", (String)"SettleConsoleRightHandler_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("mainbill", "cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"SettleConsoleRightHandler_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("mainbill", "cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.multiply(unSettleAmt).compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u80fd\u6539\u53d8\u3002", (String)"SettleConsoleRightHandler_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("mainbill", "cursettleamt", oldValue, rowIndex);
                return;
            }
            this.calCurSettleAmt(entryGrid, "summary_main", "currency", "cursettleamt");
            BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate", rowIndex);
            DynamicObject basecurrency = focusRow.getDynamicObject("basecurrency");
            int baseAmtPrecision = basecurrency.getInt("amtprecision");
            String quotation = focusRow.getString("quotation");
            BigDecimal locamt = CommonSettleServiceHelper.getLocamtByQuotation((String)quotation, (BigDecimal)curSettleAmt, (BigDecimal)exchangeRate, (int)baseAmtPrecision);
            this.setEntryField("mainbill", "cursettlelocamt", locamt, rowIndex);
        } else if ("asst_cursettleamt".equals(name)) {
            BigDecimal curSettleAmt = (BigDecimal)newValue;
            EntryGrid entryGrid = (EntryGrid)this.getControl("asstbill");
            DynamicObject focusRow = this.getModel().getEntryRowEntity("asstbill", rowIndex);
            BigDecimal unSettleAmt = focusRow.getBigDecimal("asst_unsettleamt");
            if (curSettleAmt.abs().compareTo(unSettleAmt.abs()) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5141\u8bb8\u7ed3\u7b97\u91d1\u989d\u3002", (String)"SettleConsoleRightHandler_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("asstbill", "asst_cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"SettleConsoleRightHandler_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("asstbill", "asst_cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.multiply(unSettleAmt).compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u80fd\u6539\u53d8\u3002", (String)"SettleConsoleRightHandler_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("asstbill", "asst_cursettleamt", oldValue, rowIndex);
                return;
            }
            this.calCurSettleAmt(entryGrid, "summary_asst", "asst_currency", "asst_cursettleamt");
            BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("asst_exchangerate", rowIndex);
            DynamicObject asst_basecurrency = focusRow.getDynamicObject("asst_basecurrency");
            int asstBaseAmtPrecision = asst_basecurrency.getInt("amtprecision");
            String asstQuotation = focusRow.getString("asst_quotation");
            BigDecimal asstLocamt = CommonSettleServiceHelper.getLocamtByQuotation((String)asstQuotation, (BigDecimal)curSettleAmt, (BigDecimal)exchangeRate, (int)asstBaseAmtPrecision);
            this.setEntryField("asstbill", "asst_cursettlelocamt", asstLocamt, rowIndex);
        } else if ("exchangerate".equals(name)) {
            BigDecimal exchangeRate = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("cursettleamt", rowIndex);
            DynamicObject focusRow = this.getModel().getEntryRowEntity("mainbill", rowIndex);
            DynamicObject basecurrency = focusRow.getDynamicObject("basecurrency");
            int baseAmtPrecision = basecurrency.getInt("amtprecision");
            String quotation = focusRow.getString("quotation");
            BigDecimal locamt = CommonSettleServiceHelper.getLocamtByQuotation((String)quotation, (BigDecimal)curSettleAmt, (BigDecimal)exchangeRate, (int)baseAmtPrecision);
            this.setEntryField("mainbill", "cursettlelocamt", locamt, rowIndex);
        } else if ("asst_exchangerate".equals(name)) {
            BigDecimal exchangeRate = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("asst_cursettleamt", rowIndex);
            DynamicObject focusRow = this.getModel().getEntryRowEntity("asstbill", rowIndex);
            DynamicObject asst_basecurrency = focusRow.getDynamicObject("asst_basecurrency");
            int asstBaseAmtPrecision = asst_basecurrency.getInt("amtprecision");
            String asstQuotation = focusRow.getString("asst_quotation");
            BigDecimal asstLocamt = CommonSettleServiceHelper.getLocamtByQuotation((String)asstQuotation, (BigDecimal)curSettleAmt, (BigDecimal)exchangeRate, (int)asstBaseAmtPrecision);
            this.setEntryField("asstbill", "asst_cursettlelocamt", asstLocamt, rowIndex);
        } else if ("cursettlelocamt".equals(name)) {
            BigDecimal cursettleLocAmt = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("cursettleamt", rowIndex);
            if (curSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                this.setEntryField("mainbill", "exchangerate", cursettleLocAmt.divide(curSettleAmt, 10, RoundingMode.HALF_UP), rowIndex);
            }
        } else if ("asst_cursettlelocamt".equals(name)) {
            BigDecimal cursettleLocAmt = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("asst_cursettleamt", rowIndex);
            if (curSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                this.setEntryField("asstbill", "asst_exchangerate", cursettleLocAmt.divide(curSettleAmt, 10, RoundingMode.HALF_UP), rowIndex);
            }
        }
    }

    public void query() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(this.isAr() ? "ar_settlequery" : "ap_settlequery");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        HashMap<String, Object> customeParams = new HashMap<String, Object>();
        customeParams.put("settleorg", org.getPkValue());
        customeParams.put("settlerelation", this.getSettleRelation());
        customeParams.put("mainEntity", this.getPageCache().get("mainEntity"));
        customeParams.put("mainFilterKeys", this.getMainProvider().getFilterFieldKeys());
        customeParams.put("mainFilterDefault", this.getMainProvider().getDefaultFilter());
        String mainFilterJson = (String)this.getModel().getValue("mainfilter");
        FilterCondition mainFilter = this.getMainProvider().getDefaultFilter();
        if (!StringUtils.isEmpty((CharSequence)mainFilterJson)) {
            mainFilter = (FilterCondition)SerializationUtils.fromJsonString((String)mainFilterJson, FilterCondition.class);
        }
        if (this.isLoadAsstInfo()) {
            customeParams.put("asstEntity", this.getPageCache().get("asstEntity"));
            customeParams.put("asstFilterKeys", this.getAsstProvider().getFilterFieldKeys());
            customeParams.put("asstFilterDefault", this.getAsstProvider().getDefaultFilter());
            String asstFilterJson = (String)this.getModel().getValue("asstfilter");
            FilterCondition asstFilter = this.getAsstProvider().getDefaultFilter();
            if (!StringUtils.isEmpty((CharSequence)asstFilterJson)) {
                asstFilter = (FilterCondition)SerializationUtils.fromJsonString((String)asstFilterJson, FilterCondition.class);
            }
            customeParams.put("asstFilter", asstFilter);
        }
        customeParams.put("mainFilter", mainFilter);
        IPageCache pageCache = this.getPageCache();
        customeParams.put("schemeid", pageCache.get("schemeid"));
        customeParams.put("schemename", pageCache.get("schemename"));
        fsp.setCustomParams(customeParams);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "query"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent callback) {
        String actionId = callback.getActionId();
        if (callback.getReturnData() != null && "query".equals(actionId)) {
            Map returnData = (Map)callback.getReturnData();
            IPageCache pageCache = this.getPageCache();
            pageCache.put("schemeid", (String)returnData.get("schemeid"));
            pageCache.put("schemename", (String)returnData.get("schemename"));
            FilterCondition mainFilter = (FilterCondition)returnData.get("mainFilter");
            this.getModel().setValue("mainfilter", (Object)SerializationUtils.toJsonString((Object)mainFilter));
            FilterCondition asstFilter = (FilterCondition)returnData.get("asstFilter");
            this.getModel().setValue("asstfilter", (Object)SerializationUtils.toJsonString((Object)asstFilter));
            this.fillGridValue();
        }
        if ("operationConfirm".equals(actionId) && callback.getReturnData() != null) {
            this.getView().getPageCache().put("operationConfirm", "ok");
            long userId = RequestContext.get().getCurrUserId();
            Map returnData = (Map)callback.getReturnData();
            boolean nexthide = (Boolean)returnData.get("nexthide");
            String cacheKey = this.isAr() ? "ar_manualSettleNextHide" : "ap_manualSettleNextHide";
            boolean manualSettleNextHideRes = UserConfigServiceHelper.setSetting((long)userId, (String)cacheKey, (String)(nexthide ? "1" : "0"));
            if (manualSettleNextHideRes) {
                this.settle();
            }
        }
    }

    public void resetFilter() {
        String settleRelation = this.getSettleRelation();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object apCustomParam = formShowParameter.getCustomParam("finapbills");
        Object arCustomParam = formShowParameter.getCustomParam("finarbills");
        String cacheSettleRelation = this.getPageCache().get("settlerelation");
        if (!ObjectUtils.isEmpty((Object)apCustomParam) || !ObjectUtils.isEmpty((Object)arCustomParam)) {
            this.byHyperLinkSetFilter(formShowParameter, cacheSettleRelation);
            Object dataScope = formShowParameter.getCustomParam("datascope");
            if ("prebill".equals(dataScope)) {
                this.getPageCache().put("datascope", (String)dataScope);
            }
        } else {
            this.noByHyperLinkSetFilter(cacheSettleRelation);
        }
        this.getPageCache().put("settlerelation", settleRelation);
    }

    private void clearFilter() {
        this.getModel().setValue("mainfilter", (Object)"");
        this.getModel().setValue("asstfilter", (Object)"");
        this.getPageCache().put("schemeid", "");
    }

    private void byHyperLinkSetFilter(FormShowParameter formShowParameter, String cacheSettleRelation) {
        String settleRelation = this.getSettleRelation();
        Object apCustomParam = formShowParameter.getCustomParam("finapbills");
        Object arCustomParam = formShowParameter.getCustomParam("finarbills");
        String node = this.getPageCache().get("node");
        String oldNode = this.getPageCache().get("oldnode");
        ArrayList<Long> billIds = new ArrayList<Long>(8);
        if (StringUtils.isEmpty((CharSequence)cacheSettleRelation) || !settleRelation.equals(cacheSettleRelation)) {
            List strArray = JSON.parseArray((String)(this.isAr() ? arCustomParam.toString() : apCustomParam.toString()), String.class);
            for (String str : strArray) {
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                billIds.add(Long.valueOf(str));
            }
            Object[] bills = BusinessDataServiceHelper.load((String)(this.isAr() ? "ar_finarbill" : "ap_finapbill"), (String)"id,billno,org,asstacttype,asstact,currency,billstatus,settlestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
            if (!ObjectUtils.isEmpty((Object[])bills) && bills.length > 0) {
                Long orgId = bills[0].getLong("org.id");
                this.getModel().setValue("settleorg", (Object)orgId);
                this.getPageCache().put("org", orgId.toString());
                this.setServletFilterValue((DynamicObject[])bills);
                boolean submitSettle = (Boolean)formShowParameter.getCustomParam("submitsettle");
                String billStatus = (String)formShowParameter.getCustomParam("billstatus");
                if ("B".equals(billStatus)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"settlerelation"});
                }
                this.getPageCache().put("submitsettle", String.valueOf(submitSettle));
                Long asstactId = bills[0].getLong("asstact.masterid");
                if (StringUtils.isEmpty((CharSequence)oldNode) || oldNode.equals(asstactId.toString())) {
                    TreeView treeView = (TreeView)this.getControl("treeview");
                    TreeNode root = new TreeNode(null, asstactId.toString(), "", false);
                    treeView.focusNode(root);
                    this.getPageCache().put("node", String.valueOf(asstactId));
                    this.getPageCache().put("oldnode", String.valueOf(asstactId));
                }
            }
            this.getPageCache().put("schemeid", "");
        } else {
            if (!this.filterIsEmpty()) {
                this.clearFilter();
            }
            this.getPageCache().put("node", node);
        }
    }

    private void noByHyperLinkSetFilter(String cacheSettleRelation) {
        String settleRelation = this.getSettleRelation();
        if (StringUtils.isEmpty((CharSequence)cacheSettleRelation) || !settleRelation.equals(cacheSettleRelation)) {
            FilterSchemeHelper filterSchemeHelper = new FilterSchemeHelper(this.isAr() ? "ar_settlequery" : "ap_settlequery");
            DynamicObject scheme = filterSchemeHelper.getDefaultSchemeStr();
            if (ObjectUtils.isEmpty((Object)scheme)) {
                this.clearFilter();
            } else {
                String schemeStr = scheme.getString("schemestr_tag");
                Map schemeMap = (Map)SerializationUtils.fromJsonString((String)schemeStr, Map.class);
                String schemeMainfilter = (String)schemeMap.get("mainfilter");
                String schemeAsstfilter = (String)schemeMap.get("asstfilter");
                this.getModel().setValue("asstfilter", (Object)schemeAsstfilter);
                this.getModel().setValue("mainfilter", (Object)schemeMainfilter);
                this.getPageCache().put("schemeid", String.valueOf(scheme.getLong("id")));
                this.getPageCache().put("schemename", scheme.getString("name"));
            }
        } else if (!this.filterIsEmpty()) {
            this.clearFilter();
        }
    }

    public void fillGridValue() {
        try {
            this.fillMainGrid();
            if (this.isLoadAsstInfo()) {
                this.fillAsstGrid();
            }
        }
        catch (ManaulSettleQueryException e) {
            ErrorCode errorCode = e.getErrorCode();
            if ("MANUALSETTLE_QUERY".equals(errorCode.getCode())) {
                this.getView().showTipNotification(e.getMessage(), Integer.valueOf(5000));
            }
            this.getView().showErrorNotification(e.getMessage());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"summary_main", "summary_asst"});
    }

    public void billCheck() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        IDataModel m = this.getModel();
        parameter.setCustomParam("bustype", (Object)"settle");
        DynamicObject org = (DynamicObject)m.getValue("settleorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleConsoleRightHandler_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("org", (Object)org.getLong("id"));
        parameter.setCustomParam("settlerelation", (Object)this.getSettleRelation());
        parameter.setFormId("ap_checkverifybill");
        this.getView().showForm(parameter);
    }

    public boolean clearing() {
        EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
        int[] mainSelectRows = mainGrid.getSelectRows();
        if (mainSelectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6e05\u7406\u7684\u5355\u636e\u3002", (String)"SettleConsoleRightHandler_22", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleConsoleRightHandler_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        HashMap<String, HashSet<Long>> selectBillIdsByBillKey = new HashMap<String, HashSet<Long>>(1);
        for (int mainSelectRow : mainSelectRows) {
            DynamicObject mainRow = this.getModel().getEntryRowEntity("mainbill", mainSelectRow);
            Long pk = mainRow.getLong("id");
            String mainBillKey = mainRow.getString("billtype");
            HashSet<Long> ids = (HashSet<Long>)selectBillIdsByBillKey.get(mainBillKey);
            if (ObjectUtils.isEmpty((Object)ids)) {
                ids = new HashSet<Long>(mainSelectRows.length);
                ids.add(pk);
            } else {
                ids.add(pk);
            }
            selectBillIdsByBillKey.put(mainBillKey, ids);
        }
        if (selectBillIdsByBillKey.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u5355\u636e\u7c7b\u578b\u7684\u5355\u636e\u8fdb\u884c\u6e05\u7406\u3002", (String)"SettleConsoleRightHandler_24", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        Map.Entry selectBills = selectBillIdsByBillKey.entrySet().iterator().next();
        String mainBillKey = (String)selectBills.getKey();
        Set selectIds = (Set)selectBills.getValue();
        String liquidateBillKey = "ap_finapbill".equals(mainBillKey) || "cas_paybill".equals(mainBillKey) || "ap_paidbill".equals(mainBillKey) ? "ap_liquidation" : "ar_liquidation";
        String mainEntity = this.getPageCache().get("mainEntity");
        if ("cas_paybill".equals(mainEntity)) {
            TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(selectIds.stream().map(String::valueOf).collect(Collectors.toList()));
        } else if ("cas_recbill".equals(mainEntity)) {
            TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(selectIds.stream().map(String::valueOf).collect(Collectors.toList()));
        }
        HashMap<String, String> customParam = new HashMap<String, String>(1);
        customParam.put("orgId", org.getString("id"));
        return BOTPNewHelper.pushAndShow((String)mainBillKey, (String)liquidateBillKey, (Set)selectIds, customParam, (IFormView)this.getView());
    }

    @Deprecated
    protected boolean pushAndShow(String sourceEntity, String targetEntity, String ruleId, List<ListSelectedRow> selectedRows, Long orgId) {
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setRuleId(ruleId);
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        args.setAppId("ar");
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        args.addCustomParam("bos_support_bigdata_aysn", "true");
        args.addCustomParam("botp_requiredatamutex", "true");
        args.addCustomParam("ishasright", "true");
        args.addCustomParam("specialdataperm_currentappid", "ar");
        args.addCustomParam("skipbillnovalidatorabstractcoderule", "false");
        args.addCustomParam("botp_outformula", "false");
        args.addCustomParam("botp_isstrict", "false");
        args.addCustomParam("skipbillnovalidator", "false");
        args.addCustomParam("isstrict", "false");
        args.addCustomParam("ignoreassignperson", "false");
        args.addCustomParam("orgId", orgId.toString());
        IFormView parentView = this.getView();
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (result.isSuccess() && result.getCachePageIds().size() + result.getTargetBillIds().size() != 0) {
            if (result.getCachePageIds().size() + result.getTargetBillIds().size() == 1) {
                Push.showTargetBill((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)false);
                this.getView().sendFormAction(parentView);
                return true;
            }
            Push.showMultiTargetBills((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)false);
            this.getView().sendFormAction(parentView);
            return true;
        }
        Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        return false;
    }

    public boolean settle() {
        DynamicObject org;
        long startTime = System.currentTimeMillis();
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("dhc".equalsIgnoreCase(appId)) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String entityName = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
            String mainAppId = this.isAr() ? "/BBRH+122=39" : "+HKZHSKFXOX";
            LicenseCheckResult checkResult = ArApLicenseServiceHelper.check((String)mainAppId, (String)entityName);
            if (!checkResult.getHasLicense().booleanValue()) {
                this.getView().showErrorNotification(checkResult.getMsg());
                return false;
            }
        }
        if ((org = (DynamicObject)this.getModel().getValue("settleorg")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleConsoleRightHandler_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        if (!this.orgIsfinishinit(org.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u672a\u8fdb\u884c\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u3002", (String)"SettleConsoleRightHandler_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)(this.getModel().getDataEntityType().getName().contains("ar") ? "ar" : "ap"), (String)this.getModel().getDataEntityType().getName(), (String)PERMISSION_SETTLE)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u7ed3\u7b97\u5de5\u4f5c\u53f0\u7684\u201c\u7ed3\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SettleConsoleRightHandler_25", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        if (!this.verify()) {
            return false;
        }
        EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
        int[] mainSelectRows = mainGrid.getSelectRows();
        EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
        int[] asstSelectRows = asstGrid.getSelectRows();
        HashSet<Long> mainBillIds = new HashSet<Long>(mainSelectRows.length);
        DynamicObject[] mainRows = new DynamicObject[mainSelectRows.length];
        for (int i = 0; i < mainSelectRows.length; ++i) {
            DynamicObject mainRow;
            mainRows[i] = mainRow = this.getModel().getEntryRowEntity("mainbill", mainSelectRows[i]);
            mainBillIds.add(mainRow.getLong("id"));
        }
        HashSet<Long> asstBillIds = new HashSet<Long>(asstSelectRows.length);
        DynamicObject[] asstRows = new DynamicObject[asstSelectRows.length];
        for (int i = 0; i < asstSelectRows.length; ++i) {
            DynamicObject asstRow;
            asstRows[i] = asstRow = this.getModel().getEntryRowEntity("asstbill", asstSelectRows[i]);
            asstBillIds.add(asstRow.getLong("asst_id"));
        }
        Date createTime = new Date(System.currentTimeMillis() - 1000L);
        try (TXHandle tx = TX.required((String)"settleconsole");){
            try {
                Object newValue = this.getModel().getValue("settledate");
                ManualSettleParam param = new ManualSettleParam();
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    param.setSettleDate((Date)newValue);
                }
                param.setOrgPk(org.getPkValue());
                param.setTotal(this.isTotalDisplay());
                param.setSettleEntryParam(this.getSettleEntry());
                Boolean isdiffcurreny = (Boolean)this.getModel().getValue("isdiffcurrency");
                param.setDiffCurrencySettle(isdiffcurreny.booleanValue());
                String mainEntity = this.getPageCache().get("mainEntity");
                if ("cas_paybill".equals(mainEntity)) {
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(mainBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                } else if ("cas_recbill".equals(mainEntity)) {
                    TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(mainBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                }
                String asstEntity = this.getPageCache().get("asstEntity");
                if ("cas_paybill".equals(asstEntity)) {
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(asstBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                } else if ("cas_recbill".equals(asstEntity)) {
                    TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(asstBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                }
                CommonSettleServiceHelper.settleAddMutexCtrl(mainBillIds, (String)mainEntity, asstBillIds, (String)asstEntity, (boolean)false);
                IManualSettleService manualService = SettleConsoleSettleFactory.getManualService((String)this.getSettleRelation());
                manualService.manualSettle(mainRows, asstRows, param);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
            finally {
                CommonSettleServiceHelper.settleReleaseMutexCtrl();
            }
        }
        HashSet<Long> billIds = new HashSet<Long>(mainSelectRows.length);
        billIds.addAll(mainBillIds);
        billIds.addAll(asstBillIds);
        Set settleSeqs = CommonSettleServiceHelper.getSettleSeqs(billIds, (Date)createTime);
        if (EmptyUtils.isNotEmpty((Object)settleSeqs)) {
            this.getPageCache().put("settleseq", SerializationUtils.toJsonString((Object)settleSeqs));
        }
        this.fillGridValue();
        this.getView().setVisible(Boolean.TRUE, new String[]{"viewcurrent"});
        DynamicObjectCollection settlerecord = QueryServiceHelper.query((String)"ap_settlerecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get("org"))), new QFilter("settleseq", "in", (Object)settleSeqs), new QFilter("createtime", ">=", (Object)createTime)});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u5b8c\u6210\uff0c\u5171\u751f\u6210%s\u6761\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"SettleConsoleRightHandler_6", (String)"fi-arapcommon", (Object[])new Object[]{settlerecord.size()}));
        long endTime = System.currentTimeMillis();
        try {
            ArapSettleDataAmountMonitor.recordData(mainSelectRows.length, asstSelectRows.length);
            ArapSettleDataAmountMonitor.recordData(mainSelectRows.length, asstSelectRows.length, endTime - startTime);
        }
        catch (Exception e) {
            log.warn("\u7ed3\u7b97\u76d1\u63a7\u6570\u636e\u8bb0\u5f55\u5931\u8d25\u3002", (Throwable)e);
        }
        return true;
    }

    private boolean verify() {
        BigDecimal curSettleAmt;
        int i;
        EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
        int[] mainSelectRows = mainGrid.getSelectRows();
        EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
        int[] asstSelectRows = asstGrid.getSelectRows();
        Object matchCondition = this.getModel().getValue("matchcondition");
        if (mainSelectRows.length == 0 || asstSelectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u65b9\u548c\u8f85\u65b9\u9700\u8981\u6267\u884c\u7ed3\u7b97\u7684\u6570\u636e\u3002", (String)"SettleConsoleRightHandler_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        String tempMainAsst = null;
        long tempCurrencyId = 0L;
        BigDecimal tempSettleAmt = BigDecimal.ZERO;
        Map mainSelectRowAsstList = SettleHelper.getAsstTypeToAssListMap((IDataModel)this.getModel(), (boolean)true, (int[])mainSelectRows);
        boolean mainMatch = SettleHelper.isAsstMatch((IDataModel)this.getModel(), (boolean)true, (int[])mainSelectRows, (Map)mainSelectRowAsstList);
        Date MaxDate = (Date)this.getModel().getValue("settledate");
        boolean hasBoookDateField = this.getMainGridFields().contains("bookdate");
        for (int i2 = 0; i2 < mainSelectRows.length; ++i2) {
            DynamicObject mainRow = this.getModel().getEntryRowEntity("mainbill", mainSelectRows[i2]);
            boolean isMaxDate = this.compareSettleDate(MaxDate, mainRow, hasBoookDateField, "bizdate", "bookdate");
            if (!isMaxDate && MaxDate != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u7ed3\u7b97\u53cc\u65b9\u5355\u636e\u8bb0\u8d26\u6216\u4e1a\u52a1\u65e5\u671f\u3002", (String)"SettleConsoleRightHandler_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            String asstActName = mainRow.get("asstact") != null ? mainRow.getString("asstact.name") : "";
            DynamicObject currency = mainRow.getDynamicObject("currency");
            BigDecimal settleAmt = mainRow.getBigDecimal("cursettleamt");
            long currencyId = currency.getLong("id");
            if (i2 == 0) {
                tempMainAsst = asstActName;
                tempCurrencyId = currencyId;
                tempSettleAmt = settleAmt;
                continue;
            }
            if (!mainMatch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u7684\u5f80\u6765\u6237\u5e94\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_8", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (tempCurrencyId != currencyId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u7684\u5e01\u79cd\u5e94\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if ((tempSettleAmt.compareTo(BigDecimal.ZERO) <= 0 || settleAmt.compareTo(BigDecimal.ZERO) >= 0) && (tempSettleAmt.compareTo(BigDecimal.ZERO) >= 0 || settleAmt.compareTo(BigDecimal.ZERO) <= 0)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u7684\u201c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u201d\u65b9\u5411\u5e94\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_10", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        String tempAsst = null;
        long tempAsstCurrencyId = 0L;
        Map asstSelectRowAsstList = SettleHelper.getAsstTypeToAssListMap((IDataModel)this.getModel(), (boolean)false, (int[])asstSelectRows);
        boolean asstMatch = SettleHelper.isAsstMatch((IDataModel)this.getModel(), (boolean)false, (int[])asstSelectRows, (Map)asstSelectRowAsstList);
        for (int i3 = 0; i3 < asstSelectRows.length; ++i3) {
            DynamicObject asstRow = this.getModel().getEntryRowEntity("asstbill", asstSelectRows[i3]);
            boolean isMaxDate = this.compareSettleDate(MaxDate, asstRow, hasBoookDateField, "asst_bizdate", "asst_bookdate");
            if (!isMaxDate && MaxDate != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u7ed3\u7b97\u53cc\u65b9\u5355\u636e\u8bb0\u8d26\u6216\u4e1a\u52a1\u65e5\u671f\u3002", (String)"SettleConsoleRightHandler_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            String asstActName = asstRow.get("asst_asstact") != null ? asstRow.getString("asst_asstact.name") : "";
            DynamicObject currency = asstRow.getDynamicObject("asst_currency");
            BigDecimal settleAmt = asstRow.getBigDecimal("asst_cursettleamt");
            long currencyId = currency.getLong("id");
            if (i3 == 0) {
                tempAsst = asstActName;
                tempAsstCurrencyId = currencyId;
                tempSettleAmt = settleAmt;
                continue;
            }
            if (!asstMatch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u65b9\u7684\u5f80\u6765\u6237\u5e94\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (tempAsstCurrencyId != currencyId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u65b9\u7684\u5e01\u79cd\u5e94\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_12", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if ((tempSettleAmt.compareTo(BigDecimal.ZERO) <= 0 || settleAmt.compareTo(BigDecimal.ZERO) >= 0) && (tempSettleAmt.compareTo(BigDecimal.ZERO) >= 0 || settleAmt.compareTo(BigDecimal.ZERO) <= 0)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u65b9\u7684\u201c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u201d\u65b9\u5411\u5e94\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_13", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        Boolean isdiffcurreny = (Boolean)this.getModel().getValue("isdiffcurrency");
        BigDecimal mainSettleAmt = BigDecimal.ZERO;
        BigDecimal asstSettleAmt = BigDecimal.ZERO;
        for (i = 0; i < mainSelectRows.length; ++i) {
            curSettleAmt = (BigDecimal)this.getModel().getValue("cursettleamt", mainSelectRows[i]);
            mainSettleAmt = mainSettleAmt.add(curSettleAmt);
        }
        for (i = 0; i < asstSelectRows.length; ++i) {
            curSettleAmt = (BigDecimal)this.getModel().getValue("asst_cursettleamt", asstSelectRows[i]);
            asstSettleAmt = asstSettleAmt.add(curSettleAmt);
        }
        String settleRelation = this.getSettleRelation();
        if (this.getSettleRelationsOfValidate().contains(settleRelation) && mainSettleAmt.signum() != asstSettleAmt.signum()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e3b\u65b9\u548c\u8f85\u65b9\u6570\u636e\u91d1\u989d\u65b9\u5411\u5fc5\u987b\u76f8\u540c!", (String)"SettleConsoleRightHandler_19", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        if (isdiffcurreny.booleanValue()) {
            if (tempCurrencyId == tempAsstCurrencyId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u5e01\u79cd\u76f8\u540c\uff0c\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u7ed3\u7b97\u3002", (String)"SettleConsoleRightHandler_14", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
        } else {
            boolean match = SettleHelper.isAsstMatch((IDataModel)this.getModel(), (int[])mainSelectRows, (Map)mainSelectRowAsstList, (int[])asstSelectRows, (Map)asstSelectRowAsstList);
            if ("asstandcur".equals(matchCondition) && (!match || tempCurrencyId != tempAsstCurrencyId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u7684\u201c\u5f80\u6765\u6237\u201d\u4e0e\u201c\u5e01\u79cd\u201d\u4e0d\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_15", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (tempCurrencyId != tempAsstCurrencyId && "bycurrency".equals(matchCondition)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u7684\u201c\u5e01\u79cd\u201d\u4e0d\u76f8\u540c\u3002", (String)"SettleConsoleRightHandler_16", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (mainSettleAmt.abs().compareTo(asstSettleAmt.abs()) != 0) {
                boolean manualSettleNextHideRes = this.getManualSettleNextHide();
                String operationConfirm = this.getView().getPageCache().get("operationConfirm");
                if (!manualSettleNextHideRes && EmptyUtils.isEmpty((Object)operationConfirm)) {
                    String title = ResManager.loadKDString((String)"\u7ed3\u7b97\u53cc\u65b9\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u5c06\u6309\u6240\u52fe\u9009\u5355\u636e\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u8f83\u5c0f\u4e00\u65b9\u503c\u8fdb\u884c\u7ed3\u7b97\uff0c\u591a\u9009\u5355\u636e\u65f6\u6309\u65e5\u671f\u4ece\u5c0f\u5230\u5927\u4f9d\u6b21\u7ed3\u7b97\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SettleConsoleRightHandler_20", (String)"fi-arapcommon", (Object[])new Object[0]);
                    OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this.plugin);
                    operationConfirmHelper.openOperationConfirm(title, new ArrayList(1), true);
                    return false;
                }
                this.getPageCache().remove("operationConfirm");
            }
        }
        return BizExtendHelper.invokeBeforeSettleCallback((IFormView)this.getView());
    }

    private boolean getManualSettleNextHide() {
        String cacheKey;
        long userId = RequestContext.get().getCurrUserId();
        String manualSettleNextHide = UserConfigServiceHelper.getSetting((long)userId, (String)(cacheKey = this.isAr() ? "ar_manualSettleNextHide" : "ap_manualSettleNextHide"));
        return "1".equals(manualSettleNextHide);
    }

    private List<String> getSettleRelationsOfValidate() {
        ArrayList<String> settleRelations = new ArrayList<String>(7);
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.APARSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARAPSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.RECPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.PAYRECSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.RECSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.BADDEBTRECOVERY.getValue());
        return settleRelations;
    }

    private void calCurSettleAmt(EntryGrid entryGrid, String summaryKey, String currencyKey, String curSettleAmtKey) {
        int[] selectRowIndexs = entryGrid.getSelectRows();
        if (selectRowIndexs.length > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{summaryKey});
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (int i = 0; i < selectRowIndexs.length; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), selectRowIndexs[i]);
                DynamicObject currency = row.getDynamicObject(currencyKey);
                totalAmt = totalAmt.add(row.getBigDecimal(curSettleAmtKey));
                totalAmt = totalAmt.setScale(currency.getInt("amtprecision"), 4);
                Label summary = (Label)this.getControl(summaryKey);
                String text = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\uff1a%1$s%2$s\u3002", (String)"SettleConsoleRightHandler_18", (String)"fi-arapcommon", (Object[])new Object[0]), currency.getString("sign"), totalAmt.toPlainString());
                summary.setText(text);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{summaryKey});
        }
    }

    private void setEntryField(String entryKey, String entryFieldKey, Object value, int focusRowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRowIndexs = entryGrid.getSelectRows();
        this.getModel().beginInit();
        this.getModel().setValue(entryFieldKey, value, focusRowIndex);
        this.getModel().endInit();
        this.getView().updateView(entryKey, focusRowIndex);
        entryGrid.selectRows(selectRowIndexs, focusRowIndex);
    }

    private void fillMainGrid() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("mainbill");
        LocaleString amtColumnName = this.getMainProvider().getAmtColumnName();
        grid.setColumnProperty("pricetaxtotal", "header", (Object)amtColumnName);
        grid.setColumnProperty("e_pricetaxtotal", "header", (Object)amtColumnName);
        ManualSettleExtColumnHelper.visibleAllExtColumns((IFormView)this.getView(), (boolean)true);
        IBillDataProvider provider = this.getMainProvider();
        Map extMap = provider.getExtListInfo(true);
        extMap.forEach((k, v) -> {
            grid.setColumnProperty(k, "header", (Object)new LocaleString(ResManager.loadKDString((String)v.getSettleBillKeyName(), (String)"SettleConsoleRightHandler_21", (String)"fi-arapcommon", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.TRUE, new String[]{k});
        });
        String billKey = this.getPageCache().get("mainEntity");
        if (this.isTotalDisplay()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"material", "expenseitem", "planduedate", "e_pricetaxtotal"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"pricetaxtotal"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"material", "expenseitem", "planduedate", "e_pricetaxtotal"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"pricetaxtotal"});
            if ("ap_finapbill".equals(billKey) || "ar_finarbill".equals(billKey)) {
                if (this.getSettleEntry() == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"planduedate"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"material", "expenseitem"});
                }
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"paymenttype", "receivetype"});
        if ("cas_paybill".equals(billKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"paymenttype"});
        }
        if ("cas_recbill".equals(billKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"receivetype"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"asstacttype", "asstact", "asstacttypeenum", "asstactname"});
        if ("cas_paybill".equals(billKey) || "cas_recbill".equals(billKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"asstacttypeenum", "asstactname"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"asstacttype", "asstact"});
        }
        this.getModel().deleteEntryData("mainbill");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = this.getMainSetter();
        this.fillMainVSData(vs);
        model.batchCreateNewEntryRow("mainbill", vs);
        model.endInit();
        this.getView().updateView("mainbill");
        this.getView().updateView("tabap");
    }

    private void fillAsstGrid() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("asstbill");
        LocaleString amtColumnName = this.getAsstProvider().getAmtColumnName();
        grid.setColumnProperty("asst_amount", "header", (Object)amtColumnName);
        grid.setColumnProperty("asst_e_amount", "header", (Object)amtColumnName);
        ManualSettleExtColumnHelper.visibleAllExtColumns((IFormView)this.getView(), (boolean)false);
        IBillDataProvider provider = this.getAsstProvider();
        Map extMap = provider.getExtListInfo(false);
        extMap.forEach((k, v) -> {
            grid.setColumnProperty(k, "header", (Object)new LocaleString(ResManager.loadKDString((String)v.getSettleBillKeyName(), (String)"SettleConsoleRightHandler_21", (String)"fi-arapcommon", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.TRUE, new String[]{k});
        });
        String billKey = this.getPageCache().get("asstEntity");
        if (this.isTotalDisplay()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"asst_material", "asst_expenseitem", "asst_planduedate", "asst_e_amount"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"asst_amount"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"asst_material", "asst_expenseitem", "asst_planduedate", "asst_e_amount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"asst_amount"});
            if ("ap_finapbill".equals(billKey) || "ar_finarbill".equals(billKey)) {
                int settleEntryParam = this.getSettleEntry();
                DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
                if (SettleRelationEnum.ARAPSETTLE.getValue().equals(this.getSettleRelation())) {
                    if (org != null) {
                        settleEntryParam = ArApHelper.getApSettleParam((Object)org.getLong("id"));
                    }
                } else if (SettleRelationEnum.APARSETTLE.getValue().equals(this.getSettleRelation()) && org != null) {
                    settleEntryParam = ArApHelper.getArSettleParam((Object)org.getLong("id"));
                }
                if (settleEntryParam == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"asst_planduedate"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"asst_material", "asst_expenseitem"});
                }
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"pay_paymenttype", "asst_receivetype"});
        if ("cas_paybill".equals(billKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pay_paymenttype"});
        }
        if ("cas_recbill".equals(billKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"asst_receivetype"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"asst_asstacttype", "asst_asstact", "asst_asstacttypeenum", "asst_asstactname"});
        if ("cas_paybill".equals(billKey) || "cas_recbill".equals(billKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"asst_asstacttypeenum", "asst_asstactname"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"asst_asstacttype", "asst_asstact"});
        }
        this.getModel().deleteEntryData("asstbill");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = this.getAsstSetter();
        this.fillAsstVSData(vs);
        model.batchCreateNewEntryRow("asstbill", vs);
        model.endInit();
        this.getView().updateView("asstbill");
    }

    private TableValueSetter getMainSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> mainGridFields = this.getMainGridFields();
        for (String fieldkey : mainGridFields) {
            vs.addField(fieldkey, new Object[0]);
        }
        return vs;
    }

    private TableValueSetter getAsstSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> asstGridFields = this.getAsstGridFields();
        for (String fieldkey : asstGridFields) {
            vs.addField(fieldkey, new Object[0]);
        }
        return vs;
    }

    private void fillMainVSData(TableValueSetter vs) {
        IBillDataProvider mainBillProvider = this.getMainProvider();
        List mainRows = mainBillProvider.getBillDataRows();
        if (mainRows != null && mainRows.size() > 0) {
            for (Object[] row : mainRows) {
                vs.addRow(row);
            }
        }
        Tab tab = (Tab)this.getControl("tabap");
        String settleRelation = tab.getCurrentTab();
        List tabPages = tab.getItems();
        for (Control tabPage : tabPages) {
            TabPage tabP = (TabPage)tabPage;
            if (tabP.getKey().equals(settleRelation)) {
                tabP.setText(new LocaleString(String.format("%s(%s)", SettleRelationEnum.getNameByValue((String)settleRelation), mainRows != null ? mainRows.size() : 0)));
                continue;
            }
            tabP.setText(new LocaleString(SettleRelationEnum.getNameByValue((String)tabP.getKey())));
        }
    }

    private void fillAsstVSData(TableValueSetter vs) {
        IBillDataProvider asstBillProvider = this.getAsstProvider();
        List mainRows = asstBillProvider.getBillDataRows();
        if (mainRows != null && mainRows.size() > 0) {
            for (Object[] row : mainRows) {
                vs.addRow(row);
            }
        }
    }

    private List<String> getMainGridFields() {
        if (this.mainListFields == null) {
            this.mainListFields = new ArrayList<String>(64);
            EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
            List fieldEdits = mainGrid.getFieldEdits();
            for (FieldEdit field : fieldEdits) {
                this.mainListFields.add(field.getKey());
            }
        }
        return this.mainListFields;
    }

    private List<String> getAsstGridFields() {
        if (this.asstListFields == null) {
            this.asstListFields = new ArrayList<String>(64);
            EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
            List fieldEdits = asstGrid.getFieldEdits();
            for (FieldEdit field : fieldEdits) {
                this.asstListFields.add(field.getKey());
            }
        }
        return this.asstListFields;
    }

    private QFilter getFilterGridValue(boolean isMain) {
        String entityNumber = isMain ? this.getPageCache().get("mainEntity") : this.getPageCache().get("asstEntity");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String filterJson = "";
        filterJson = isMain ? (String)this.getModel().getValue("mainfilter") : (String)this.getModel().getValue("asstfilter");
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
        filterBuilder.setUserService((IUserService)this.getView().getService(IUserService.class));
        filterBuilder.buildFilter(false);
        QFilter filter = filterBuilder.getQFilter();
        return filter;
    }

    private IBillDataProvider getMainProvider() {
        String mainEntity = this.getPageCache().get("mainEntity");
        this.mainProvider = BillDataProviderFactory.getBillProvider((String)mainEntity, (boolean)this.isRedBillDataProvider(), (BillDataProviderParam)this.getBillDataProviderParam(true));
        return this.mainProvider;
    }

    private IBillDataProvider getAsstProvider() {
        String asstEntity = this.getPageCache().get("asstEntity");
        this.asstProvider = BillDataProviderFactory.getBillProvider((String)asstEntity, (boolean)this.isRedBillDataProvider(), (BillDataProviderParam)this.getBillDataProviderParam(false));
        return this.asstProvider;
    }

    private BillDataProviderParam getBillDataProviderParam(boolean isMain) {
        int asstSettleParam;
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        String assactType = (String)this.getModel().getValue("asstactype");
        boolean submitSettle = false;
        if (org != null) {
            submitSettle = this.isAr() ? SystemParameterHelper.getARBooleanParam((long)org.getLong("id"), (String)"ar_016") : SystemParameterHelper.getAPBooleanParam((long)org.getLong("id"), (String)"ap_016");
        }
        BillDataProviderParam param = new BillDataProviderParam();
        param.setOrgPk(org == null ? org : org.getPkValue());
        param.setFields(this.getMainGridFields());
        param.setGridFilter(this.getFilterGridValue(isMain));
        String nodeId = this.getPageCache().get("node");
        if ("all".equals(nodeId)) {
            Set mainAsstactIdSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("mainAsstactIdSet"), Set.class);
            param.setMainAsstactIdSet(mainAsstactIdSet);
            if (ObjectUtils.isEmpty((Object)mainAsstactIdSet)) {
                param.setAsstactIdSetZero(true);
            }
        } else {
            param.setAsstactId(nodeId);
        }
        param.setAsstactype(assactType);
        param.setSettleEntry(this.getSettleEntry());
        param.setSettleRelation(this.getSettleRelation());
        param.setTotalDisplay(this.isTotalDisplay());
        param.setMain(isMain);
        param.setSubmitSettle(submitSettle);
        DynamicObject standardCurrency = (DynamicObject)this.getModel().getValue("standardcurrency");
        param.setStandardCurrency(standardCurrency);
        String matchCondition = (String)this.getModel().getValue("matchcondition");
        param.setMatchCondition(matchCondition);
        String datascope = this.getPageCache().get("datascope");
        if ("prebill".equals(datascope)) {
            param.setOnlyShowPre(true);
        }
        if (SettleRelationEnum.ARAPSETTLE.getValue().equals(this.getSettleRelation()) && org != null) {
            asstSettleParam = ArApHelper.getApSettleParam((Object)org.getLong("id"));
            param.setAsstSettleEntryParam(asstSettleParam);
        }
        if (SettleRelationEnum.APARSETTLE.getValue().equals(this.getSettleRelation()) && org != null) {
            asstSettleParam = ArApHelper.getArSettleParam((Object)org.getLong("id"));
            param.setAsstSettleEntryParam(asstSettleParam);
        }
        return param;
    }

    private boolean isRedBillDataProvider() {
        return SettleRelationEnum.APRECSETTLE.getValue().equals(this.getSettleRelation()) || SettleRelationEnum.ARPAYSETTLE.getValue().equals(this.getSettleRelation());
    }

    public void setCountValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        String asstactType = (String)this.getModel().getValue("asstactype");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and(new QFilter("asstacttype", "=", (Object)asstactType));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("unsettleamount", "!=", (Object)0));
        String nodeId = this.getPageCache().get("node");
        if (!StringUtils.isEmpty((CharSequence)nodeId) && !"all".equals(nodeId)) {
            filter.and("asstact", "in", (Object)BaseDataHelper.getBaseDataIds((String)asstactType, (long)Long.parseLong(nodeId)));
        }
        this.setTotalAmount(filter);
        this.setTotalPlanAmount(filter);
        this.setTotalPayOrRecAmount(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalAmount(QFilter filter) {
        DataSet dataSet = null;
        DataSet result = null;
        if (this.isAr()) {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.entityName, (String)"id,unsettlelocalamt", (QFilter[])filter.toArray(), null);
            if (dataSet != null) {
                result = dataSet.groupBy().sum("unsettlelocalamt", "unsettlelocalamt").finish();
            }
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.entityName, (String)"id,unsettleamountbase", (QFilter[])filter.toArray(), null);
            if (dataSet != null) {
                result = dataSet.groupBy().sum("unsettleamountbase", "unsettlelocalamt").finish();
            }
        }
        BigDecimal totalamount = BigDecimal.ZERO;
        this.getModel().setValue("totalamount", (Object)totalamount);
        if (dataSet != null && result != null) {
            try {
                for (Row row : result) {
                    totalamount = row.getBigDecimal("unsettlelocalamt");
                    this.getModel().setValue("totalamount", (Object)totalamount);
                }
            }
            finally {
                dataSet.close();
                result.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalPlanAmount(QFilter filter) {
        LocalDate today = LocalDate.now();
        LocalDate firstday = LocalDate.of(today.getYear(), today.getMonth(), 1);
        LocalDate lastDay = today.with(TemporalAdjusters.lastDayOfMonth());
        filter.and("planentity.planduedate", ">=", (Object)Date.from(firstday.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        filter.and("planentity.planduedate", "<=", (Object)Date.from(lastDay.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.entityName, (String)"id,planentity.unplansettlelocamt", (QFilter[])filter.toArray(), null);
        DataSet result = dataSet.groupBy().sum("planentity.unplansettlelocamt", "unsettlelocalamt").finish();
        BigDecimal totalplanamount = BigDecimal.ZERO;
        this.getModel().setValue("totalplanamount", (Object)totalplanamount);
        try {
            for (Row row : result) {
                totalplanamount = row.getBigDecimal("unsettlelocalamt");
                this.getModel().setValue("totalplanamount", (Object)totalplanamount);
            }
        }
        finally {
            dataSet.close();
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalPayOrRecAmount(String nodeId) {
        DataSet result;
        DataSet dataSet;
        QFilter filter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        String asstactType = (String)this.getModel().getValue("asstactype");
        if (this.isAr()) {
            filter = new QFilter("entry.e_settleorg", "=", org.getPkValue());
            filter.and("billstatus", "=", (Object)"D").and("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", "!=", (Object)0);
            if (!StringUtils.isEmpty((CharSequence)nodeId) && !"all".equals(nodeId)) {
                filter.and("itempayer", "in", (Object)BaseDataHelper.getBaseDataIds((String)asstactType, (long)Long.parseLong(nodeId)));
            }
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_recbill", (String)"id,(entry.e_unsettledamt * exchangerate) as unsettledamt", (QFilter[])filter.toArray(), null);
            result = dataSet.groupBy().sum("unsettledamt", "unsettledamt").finish();
        } else {
            filter = new QFilter("entry.settleorg", "=", org.getPkValue());
            filter.and("billstatus", "=", (Object)"D").and("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", "!=", (Object)0);
            if (!StringUtils.isEmpty((CharSequence)nodeId) && !"all".equals(nodeId)) {
                filter.and("itempayee", "in", (Object)BaseDataHelper.getBaseDataIds((String)asstactType, (long)Long.parseLong(nodeId)));
            }
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paybill", (String)"id,(entry.e_unsettledamt * exchangerate) as unsettledamt", (QFilter[])filter.toArray(), null);
            result = dataSet.groupBy().sum("unsettledamt", "unsettledamt").finish();
        }
        BigDecimal totalunamount = BigDecimal.ZERO;
        this.getModel().setValue("totalunamount", (Object)totalunamount);
        try {
            for (Row row : result) {
                totalunamount = row.getBigDecimal("unsettledamt");
                this.getModel().setValue("totalunamount", (Object)totalunamount);
            }
        }
        finally {
            dataSet.close();
            result.close();
        }
    }

    public void cacheEntityNum() {
        String settleRelation = this.getSettleRelation();
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "ar_finarbill");
        } else if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "ap_finapbill");
        } else if (SettleRelationEnum.BADDEBTRECOVERY.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_baddebtlossbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_recbill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_paybill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "ap_finapbill");
        } else if (SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_paybill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "ar_finarbill");
        } else if (SettleRelationEnum.RECSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_recbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_recbill");
            this.getPageCache().put("asstEntity", "ar_liquidation");
        } else if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_paybill");
            this.getPageCache().put("asstEntity", "ap_liquidation");
        }
    }

    private boolean orgIsfinishinit(long orgId) {
        String entityName = this.isAr() ? "ar_init" : "ap_init";
        DynamicObject initOrg = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE), new QFilter("org", "=", (Object)orgId)});
        return initOrg != null;
    }

    protected boolean isLoadAsstInfo() {
        return !this.getPageCache().get("asstEntity").equals("ar_liquidation") && !this.getPageCache().get("asstEntity").equals("ap_liquidation");
    }

    protected boolean isLoadServletAsstInfo() {
        String settleRelation = this.getSettleRelation();
        if ("payrecsettle".equals(settleRelation) || "payself".equals(settleRelation) || "baddebtrecovery".equals(settleRelation) || "recpaysettle".equals(settleRelation) || "recself".equals(settleRelation)) {
            return false;
        }
        return this.isLoadAsstInfo();
    }

    private boolean compareSettleDate(Date MaxDate, DynamicObject mainRow, boolean hasBoookDateField, String bizDateFiled, String bookDateFiled) {
        if (EmptyUtils.isNotEmpty((Object)MaxDate)) {
            Date bookDate;
            Date bizDate = mainRow.getDate(bizDateFiled);
            if (DateUtils.getDiffDaysIgnoreTime((Date)bizDate, (Date)MaxDate) >= 0) {
                return true;
            }
            if (hasBoookDateField && (bookDate = mainRow.getDate(bookDateFiled)) != null && DateUtils.getDiffDaysIgnoreTime((Date)bookDate, (Date)MaxDate) >= 0) {
                return true;
            }
        }
        return false;
    }

    private boolean filterIsEmpty() {
        String mainFilter = (String)this.getModel().getValue("mainfilter");
        String asstFilter = (String)this.getModel().getValue("asstfilter");
        if (StringUtils.isEmpty((CharSequence)mainFilter) && StringUtils.isEmpty((CharSequence)asstFilter)) {
            return false;
        }
        if (!StringUtils.isEmpty((CharSequence)mainFilter) && !StringUtils.isEmpty((CharSequence)asstFilter)) {
            FilterCondition mainFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)mainFilter, FilterCondition.class);
            List mainFilterRow = mainFilterCondition.getFilterRow();
            FilterCondition asstFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)asstFilter, FilterCondition.class);
            List asstFilterRow = asstFilterCondition.getFilterRow();
            return !ObjectUtils.isEmpty((Object)mainFilterRow) || !ObjectUtils.isEmpty((Object)asstFilterRow);
        }
        return true;
    }

    protected void setServletFilterValue(DynamicObject[] bills) {
        FilterCondition mainFilter = new FilterCondition();
        ArrayList<SimpleFilterRow> mainRows = new ArrayList<SimpleFilterRow>(64);
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>(bills.length);
        for (DynamicObject finBill : bills) {
            FilterValue dateValue = new FilterValue();
            dateValue.setValue((Object)finBill.getString("billno"));
            dateValues.add(dateValue);
        }
        SimpleFilterRow bizDateRow = new SimpleFilterRow("", "17", "billno", "", "0", dateValues);
        bizDateRow.setValue(dateValues);
        mainRows.add(bizDateRow);
        mainFilter.setFilterRow(mainRows);
        String mainFilterString = SerializationUtils.toJsonString((Object)mainFilter);
        if (this.isLoadServletAsstInfo()) {
            ManualProviderParam param = new ManualProviderParam();
            param.setSettleRelation(this.getSettleRelation());
            FilterCondition asstFilter = ManualSettleServletBillProviderFactory.getAsstBillProvider((ManualProviderParam)param).getServletFilter(bills[0]);
            String asstFilterString = SerializationUtils.toJsonString((Object)asstFilter);
            this.getModel().setValue("asstfilter", (Object)asstFilterString);
        } else {
            this.getModel().setValue("asstfilter", (Object)"");
        }
        this.getModel().setValue("mainfilter", (Object)mainFilterString);
    }
}

