/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.InvokeTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;

public class FinApBillTestHelper {
    protected static final Log logger = LogFactory.getLog(FinApBillTestHelper.class);

    public static void searchOneRowDataByBillNo(AbstractJUnitTestPlugIn junit, String currentBillNo) {
        SimulatorTestHelper util = new SimulatorTestHelper(junit);
        InvokeTestHelper.invokeAction((String)("[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[{\"FieldName\":[\"billno\",\"payproperty.name\"],\"Value\":[\"" + currentBillNo + "\"]}],[{\"FieldName\":[\"org.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"verifystatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"settlestatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"freezestate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]}],\"detailentry\"],\"postData\":[{},[]]}]"), (AbstractJUnitTestPlugIn)junit);
        util.selectAllRows();
    }

    public static void selectInitOrg(AbstractJUnitTestPlugIn junit, long orgId) {
        SimulatorTestHelper util = new SimulatorTestHelper(junit);
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"bizdate\"],\"Value\":[\"63\"],\"Compare\":[\"63\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"verifystatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"settlestatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]}],\"detailentry\"],\"postData\":[]}]";
        util.invokeAction((IFormView)((IListView)junit.getView()), param);
    }

    public static void turnPayByRow(AbstractJUnitTestPlugIn junit) {
        IListView listView = (IListView)junit.getView();
        SimulatorTestHelper util = new SimulatorTestHelper(junit);
        IFormView turnPayView = util.clickBarItemReturnChildView((IFormView)listView, "transferpay", "transpay");
        IDataModel turnPayModel = turnPayView.getModel();
        turnPayModel.setValue("asstact", (Object)BaseDataTestProvider.getSupplier());
        turnPayModel.setValue("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        turnPayModel.setValue("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        turnPayModel.setValue("exratedate", (Object)new Date());
        turnPayModel.setValue("taxrateid", (Object)BaseDataTestProvider.getTaxRate(), 0);
        turnPayModel.setValue("transqty", (Object)BigDecimal.valueOf(2L), 0);
        turnPayModel.setValue("transamount", (Object)BigDecimal.valueOf(10L), 0);
        turnPayModel.setValue("transtax", (Object)BigDecimal.valueOf(5L), 0);
        turnPayView.invokeOperation("transpay");
    }

    public static void modifyQty(DynamicObject finApBill, BigDecimal[] qtys) {
        DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
        BigDecimal exchangeRate = finApBill.getBigDecimal("exchangerate");
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal priceTaxTotalSum = BigDecimal.ZERO;
        BigDecimal amountBaseSum = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBaseSum = BigDecimal.ZERO;
        BigDecimal taxSum = BigDecimal.ZERO;
        int index = 0;
        Iterator iterator = detailEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            BigDecimal qty = qtys[index];
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
            }
            BigDecimal actPrice = row.getBigDecimal("actprice");
            BigDecimal actPriceTax = row.getBigDecimal("actpricetax");
            BigDecimal amount = qty.multiply(actPrice);
            BigDecimal amountBase = qty.multiply(actPrice).multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            BigDecimal priceTaxTotal = qty.multiply(actPriceTax);
            BigDecimal priceTaxTotalBase = qty.multiply(actPriceTax).multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            amountSum = amountSum.add(amount);
            amountBaseSum = amountBaseSum.add(amountBase);
            priceTaxTotalSum = priceTaxTotalSum.add(priceTaxTotal);
            priceTaxTotalBaseSum = priceTaxTotalBaseSum.add(priceTaxTotalBase);
            row.set("quantity", (Object)qty);
            row.set("e_baseunitqty", (Object)qty);
            row.set("e_amount", (Object)amount);
            row.set("e_amountbase", (Object)amountBase);
            row.set("e_pricetaxtotal", (Object)priceTaxTotal);
            row.set("e_pricetaxtotalbase", (Object)priceTaxTotalBase);
            row.set("unverifyquantity", (Object)qty);
            row.set("e_unverifyamount", (Object)amount);
            row.set("unlockamt", (Object)priceTaxTotal);
            row.set("unsettleamt", (Object)priceTaxTotal);
            row.set("unsettleamtbase", (Object)priceTaxTotalBase);
            row.set("e_uninvoicedamt", (Object)priceTaxTotal);
            BigDecimal taxRate = row.getBigDecimal("taxrate");
            BigDecimal tax = priceTaxTotal.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            row.set("e_tax", (Object)tax);
            taxSum = taxSum.add(tax);
            ++index;
        }
        finApBill.set("amount", (Object)amountSum);
        finApBill.set("amountbase", (Object)amountBaseSum);
        finApBill.set("tax", (Object)taxSum);
        finApBill.set("pricetaxtotal", (Object)priceTaxTotalSum);
        finApBill.set("pricetaxtotalbase", (Object)priceTaxTotalBaseSum);
        finApBill.set("unsettleamount", (Object)priceTaxTotalSum);
        finApBill.set("unsettleamountbase", (Object)priceTaxTotalBaseSum);
        finApBill.set("unverifyamount", (Object)amountSum);
        finApBill.set("uninvoicedamt", (Object)priceTaxTotalSum);
        DynamicObjectCollection planEntity = finApBill.getDynamicObjectCollection("planentity");
        int planIndex = 0;
        Iterator planIterator = planEntity.iterator();
        while (planIterator.hasNext()) {
            DynamicObject planRow = (DynamicObject)planIterator.next();
            if (planIndex == 0) {
                planRow.set("planpricetax", (Object)priceTaxTotalSum);
                planRow.set("planpricetaxloc", (Object)priceTaxTotalBaseSum);
                planRow.set("unplanlockamt", (Object)priceTaxTotalSum);
                planRow.set("unplansettleamt", (Object)priceTaxTotalSum);
                planRow.set("unplansettlelocamt", (Object)priceTaxTotalBaseSum);
            } else {
                planIterator.remove();
            }
            ++planIndex;
        }
    }

    public static DynamicObject[] pushFinApBill(String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate) {
        return FinApBillTestHelper.pushFinApBill(BigDecimal.valueOf(999999L), sourceEntity, srcIds, billStatus, billNo, exchangeRate);
    }

    public static DynamicObject[] pushFinApBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billNo) {
        return FinApBillTestHelper.pushFinApBill(deleteAmt, sourceEntity, srcIds, "C", billNo, null);
    }

    public static DynamicObject[] fullPushFinArpill(String sourceEntity, List<Long> srcIds, String billStatus, String billNo) {
        return FinApBillTestHelper.pushFinApBill(null, sourceEntity, srcIds, billStatus, billNo, null);
    }

    public static DynamicObject[] fullPushFinApBill(String sourceEntity, List<Long> srcIds, String billNo) {
        return FinApBillTestHelper.pushFinApBill(null, sourceEntity, srcIds, "C", billNo, null);
    }

    public static DynamicObject[] fullPushFinApBill(String sourceEntity, List<Long> srcIds, String billNo, String ruleId) {
        return FinApBillTestHelper.pushFinApBill(null, sourceEntity, srcIds, "C", billNo, null, ruleId);
    }

    public static DynamicObject[] fullPushFinApBill(String sourceEntity, List<Long> srcIds, String billNo, BigDecimal exchangeRate) {
        return FinApBillTestHelper.pushFinApBill(null, sourceEntity, srcIds, "C", billNo, exchangeRate);
    }

    public static List<Object> pushFinApBillIds(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate) {
        List finApBills = BOTPHelper.push((String)sourceEntity, (String)"ap_finapbill", srcIds);
        return FinApBillTestHelper.commonPushFinApbillIds(deleteAmt, billStatus, billNo, exchangeRate, finApBills);
    }

    public static List<Object> pushFinApBillIds(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate, String ruleId) {
        List finApBills = BOTPHelper.push((String)sourceEntity, (String)"ap_finapbill", (String)ruleId, srcIds);
        return FinApBillTestHelper.commonPushFinApbillIds(deleteAmt, billStatus, billNo, exchangeRate, finApBills);
    }

    public static List<Object> commonPushFinApbillIds(BigDecimal deleteAmt, String billStatus, String billNo, BigDecimal exchangeRate, List<DynamicObject> finApBills) {
        DynamicObject[] finApBillArray = finApBills.toArray(new DynamicObject[0]);
        if (exchangeRate != null && exchangeRate.compareTo(BigDecimal.ZERO) != 0) {
            FinApBillTestHelper.remedyNoSameRateFinApData(finApBillArray, exchangeRate);
        }
        if (deleteAmt != null && BigDecimal.ZERO.compareTo(deleteAmt) != 0) {
            for (DynamicObject finApBill : finApBillArray) {
                DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
                BigDecimal[] qtys = new BigDecimal[detailEntry.size()];
                for (int i = 0; i < detailEntry.size(); ++i) {
                    DynamicObject detail = (DynamicObject)detailEntry.get(i);
                    qtys[i] = detail.getBigDecimal("quantity").divide(BigDecimal.valueOf(2L));
                    if (deleteAmt.compareTo(detail.getBigDecimal("e_pricetaxtotal")) != 0) continue;
                    qtys[i] = BigDecimal.ZERO;
                }
                FinApBillTestHelper.modifyQty(finApBill, qtys);
            }
        }
        OperateOption option = OperateOption.create();
        OperationResult saveOperate = OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])finApBillArray, (OperateOption)option);
        List finApIds = saveOperate.getSuccessPkIds();
        logger.info("\u4fdd\u5b58\u6210\u529f\u7684\u8d22\u52a1\u5e94\u4ed8\u5355id\u4e3a\uff1a" + finApIds);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ap_finapbill");
        finApBillArray = BusinessDataServiceHelper.load((Object[])finApIds.toArray(), (DynamicObjectType)entityType);
        logger.info("\u8d22\u52a1\u5e94\u4ed8\u5355\u6570\u91cf\u4e3a\uff1a" + finApBillArray.length);
        FinApBillTestHelper.fillValueInFinApBill(finApBillArray);
        if (billNo != null) {
            finApBillArray[0].set("billno", (Object)billNo);
        }
        SaveServiceHelper.save((DynamicObject[])finApBillArray);
        if ("C".equals(billStatus) || "B".contains(billStatus)) {
            OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])finApIds.toArray(), (OperateOption)option);
            KDAssert.assertInvokeOperation((OperationResult)submit);
            KDAssert.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u63d0\u4ea4\u5931\u8d25", (boolean)true, (boolean)submit.isSuccess());
        }
        if ("C".equals(billStatus)) {
            option.setVariableValue("WF", "TRUE");
            OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])finApIds.toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)audit);
        }
        return finApIds;
    }

    public static DynamicObject[] pushFinApBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate) {
        List<Object> finApIds = FinApBillTestHelper.pushFinApBillIds(deleteAmt, sourceEntity, srcIds, billStatus, billNo, exchangeRate);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ap_finapbill");
        return BusinessDataServiceHelper.load((Object[])finApIds.toArray(), (DynamicObjectType)entityType);
    }

    public static DynamicObject[] pushFinApBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate, String ruleId) {
        List<Object> finApIds = FinApBillTestHelper.pushFinApBillIds(deleteAmt, sourceEntity, srcIds, billStatus, billNo, exchangeRate, ruleId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ap_finapbill");
        return BusinessDataServiceHelper.load((Object[])finApIds.toArray(), (DynamicObjectType)entityType);
    }

    public static DynamicObject[] remedyNoSameRateFinApData(DynamicObject[] finBills, BigDecimal exchangeRate) {
        for (DynamicObject finBill : finBills) {
            finBill.set("exchangerate", (Object)exchangeRate);
            BigDecimal amountbase = BigDecimal.ZERO;
            BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
            DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detail : detailEntry) {
                BigDecimal eAmountBase = detail.getBigDecimal("e_amount").multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
                BigDecimal ePriceTaxTotalBase = detail.getBigDecimal("e_pricetaxtotal").multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
                detail.set("e_amountbase", (Object)eAmountBase);
                detail.set("e_pricetaxtotalbase", (Object)ePriceTaxTotalBase);
                detail.set("unsettleamtbase", (Object)ePriceTaxTotalBase);
                amountbase = amountbase.add(eAmountBase);
                pricetaxtotalbase = pricetaxtotalbase.add(ePriceTaxTotalBase);
            }
            DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
            ((DynamicObject)planEntity.get(0)).set("planpricetaxloc", (Object)pricetaxtotalbase);
            ((DynamicObject)planEntity.get(0)).set("unplansettlelocamt", (Object)pricetaxtotalbase);
            finBill.set("amountbase", (Object)amountbase);
            finBill.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
            finBill.set("unsettleamountbase", (Object)pricetaxtotalbase);
        }
        return finBills;
    }

    private static void fillValueInFinApBill(DynamicObject[] finApBillArray) {
        for (DynamicObject finApBill : finApBillArray) {
            if (ObjectUtils.isEmpty((Object)finApBill.get("payproperty"))) {
                finApBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
            }
            finApBill.set("quotation", (Object)"0");
        }
    }

    public static DynamicObject executeAndGetWriteOffBill(long finApBillId) {
        FinApBillTestHelper.executeWriteOff(finApBillId);
        return BusinessDataServiceHelper.loadSingle((Object)FinApBillTestHelper.getWriteOffBillId(finApBillId), (String)"ap_finapbill");
    }

    public static void executeWriteOff(long finApBillId) {
        List writeOffBills = BOTPHelper.push((String)"ap_finapbill", (String)"ap_finapbill", (String)"520819751337865216", Collections.singletonList(finApBillId));
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])writeOffBills.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)result);
    }

    public static long getWriteOffBillId(long srcBillId) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)srcBillId);
        filter.and("iswrittenoff", "=", (Object)Boolean.TRUE);
        DynamicObject writeOff = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u51b2\u9500\u5355", (boolean)false, (writeOff == null ? 1 : 0) != 0);
        return writeOff.getLong("id");
    }

    public static long getPremiumBillId(long srcBillId) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)srcBillId);
        filter.and("ispremium", "=", (Object)Boolean.TRUE);
        DynamicObject premiumBill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u8d28\u4fdd\u91d1\u5355", (boolean)false, (premiumBill == null ? 1 : 0) != 0);
        return premiumBill.getLong("id");
    }

    public static long getTransBillId(long srcBillId) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)srcBillId);
        filter.and("istanspay", "=", (Object)Boolean.TRUE);
        DynamicObject transBill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u8f6c\u4ed8\u5355", (boolean)false, (transBill == null ? 1 : 0) != 0);
        return transBill.getLong("id");
    }
}

