/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.arapcommon.util.EmptyUtils;

public class AllocationUtils {
    private static Map<String, String> billDetailEntryProperties = new HashMap<String, String>(16);
    private static Map<String, String> expenseAllocProperties = new HashMap<String, String>(8);
    private static Map<String, String> expenseAllocDetailProperties = new HashMap<String, String>(8);
    public static final int PERCENT_SCALE = 10;

    public static Map<String, String> getAllocProperties(boolean wholeAlloc) {
        if (wholeAlloc) {
            return expenseAllocProperties;
        }
        return expenseAllocDetailProperties;
    }

    public static String getBillDetailPropertyName(String billName) {
        String propertyName = billDetailEntryProperties.get(billName);
        if (EmptyUtils.isEmpty((Object)propertyName)) {
            return "entry";
        }
        return propertyName;
    }

    public static boolean isNeedRecalculate(BigDecimal billAmt, DynamicObject billEntity) {
        boolean expenseAlloc = billEntity.getBoolean("isexpensealloc");
        if (!expenseAlloc) {
            return false;
        }
        DynamicObjectCollection allocEntries = billEntity.getDynamicObjectCollection("allocationentry");
        BigDecimal totalAllocAmt = allocEntries.stream().map(entry -> entry.getBigDecimal("a_allocationamt")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(billAmt.scale(), RoundingMode.HALF_UP);
        return totalAllocAmt.compareTo(billAmt) != 0;
    }

    public static boolean isNeedRecalculateLocAmt(BigDecimal billAmt, DynamicObject billEntity) {
        boolean expenseAlloc = billEntity.getBoolean("isexpensealloc");
        if (!expenseAlloc) {
            return false;
        }
        DynamicObjectCollection allocEntries = billEntity.getDynamicObjectCollection("allocationentry");
        BigDecimal totalAllocAmt = allocEntries.stream().map(entry -> entry.getBigDecimal("a_localamt")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(billAmt.scale(), RoundingMode.HALF_UP);
        return totalAllocAmt.compareTo(billAmt) != 0;
    }

    public static void executeCalculation(BigDecimal billAmt, DynamicObject targetBill) {
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        DynamicObjectCollection allocEntries = targetBill.getDynamicObjectCollection("allocationentry");
        int headCurrencyPrecision = AllocationUtils.getHeadCurrencyPercision(targetBill);
        int baseCurrencyPrecision = AllocationUtils.getBaseCurrencyPrecision(targetBill);
        for (int i = 0; i < allocEntries.size(); ++i) {
            DynamicObject allocRow = (DynamicObject)allocEntries.get(i);
            BigDecimal allocRowPer = allocRow.getBigDecimal("a_allocationper");
            BigDecimal allocRowAmt = billAmt.multiply(allocRowPer.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)).setScale(headCurrencyPrecision, RoundingMode.HALF_UP);
            BigDecimal allocRowLocalAmt = allocRowAmt.multiply(exchangeRate).setScale(baseCurrencyPrecision, RoundingMode.HALF_UP);
            allocRow.set("a_allocationamt", (Object)allocRowAmt);
            allocRow.set("a_localamt", (Object)allocRowLocalAmt);
        }
        BigDecimal headLocalAmt = billAmt.multiply(exchangeRate);
        DynamicObject lastRow = (DynamicObject)allocEntries.get(allocEntries.size() - 1);
        BigDecimal allocAmt = lastRow.getBigDecimal("a_allocationamt");
        BigDecimal localAmt = lastRow.getBigDecimal("a_localamt");
        BigDecimal allocAmtDifference = AllocationUtils.getPropertyDifference(targetBill, billAmt, "allocationentry", "a_allocationamt");
        BigDecimal localAmtDifference = AllocationUtils.getPropertyDifference(targetBill, headLocalAmt, "allocationentry", "a_localamt");
        lastRow.set("a_allocationamt", (Object)allocAmt.add(allocAmtDifference).setScale(headCurrencyPrecision, RoundingMode.HALF_UP));
        lastRow.set("a_localamt", (Object)localAmt.add(localAmtDifference).setScale(baseCurrencyPrecision, RoundingMode.HALF_UP));
    }

    public static void executeCalculation(BigDecimal billAmt, BigDecimal billAmtLoc, DynamicObject targetBill) {
        DynamicObject tempLastRow;
        int i;
        BigDecimal allocRowPer;
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        String quotation = targetBill.getString("quotation");
        DynamicObjectCollection allocEntries = targetBill.getDynamicObjectCollection("allocationentry");
        int headCurrencyPrecision = AllocationUtils.getHeadCurrencyPercision(targetBill);
        int baseCurrencyPrecision = AllocationUtils.getBaseCurrencyPrecision(targetBill);
        for (DynamicObject allocRow : allocEntries) {
            allocRowPer = allocRow.getBigDecimal("a_allocationper");
            BigDecimal allocRowAmt = billAmt.multiply(allocRowPer.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)).setScale(headCurrencyPrecision, RoundingMode.HALF_UP);
            BigDecimal allocRowLocalAmt = BigDecimal.ZERO;
            if ("1".equals(quotation)) {
                if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    exchangeRate = BigDecimal.ONE;
                }
                allocRowLocalAmt = allocRowAmt.divide(exchangeRate, baseCurrencyPrecision, RoundingMode.HALF_UP);
            } else {
                allocRowLocalAmt = allocRowAmt.multiply(exchangeRate).setScale(baseCurrencyPrecision, RoundingMode.HALF_UP);
            }
            allocRow.set("a_allocationamt", (Object)allocRowAmt);
            allocRow.set("a_localamt", (Object)allocRowLocalAmt);
        }
        for (i = allocEntries.size() - 1; i >= 0; --i) {
            BigDecimal allocAmtDifference;
            DynamicObject lastRow = (DynamicObject)allocEntries.get(i);
            BigDecimal allocAmt = lastRow.getBigDecimal("a_allocationamt");
            BigDecimal afterAllocAmt = allocAmt.add(allocAmtDifference = AllocationUtils.getPropertyDifference(targetBill, billAmt, "allocationentry", "a_allocationamt"));
            if (afterAllocAmt.multiply(billAmt).signum() > 0) {
                lastRow.set("a_allocationamt", (Object)afterAllocAmt.setScale(headCurrencyPrecision, RoundingMode.HALF_UP));
                break;
            }
            lastRow.set("a_allocationamt", (Object)BigDecimal.ZERO);
        }
        for (i = allocEntries.size() - 1; i >= 0; --i) {
            BigDecimal localAmtDifference;
            tempLastRow = (DynamicObject)allocEntries.get(i);
            BigDecimal localAmt = tempLastRow.getBigDecimal("a_localamt");
            BigDecimal afterAllocLocAmt = localAmt.add(localAmtDifference = AllocationUtils.getPropertyDifference(targetBill, billAmtLoc, "allocationentry", "a_localamt"));
            if (afterAllocLocAmt.multiply(billAmtLoc).signum() > 0) {
                tempLastRow.set("a_localamt", (Object)afterAllocLocAmt.setScale(baseCurrencyPrecision, RoundingMode.HALF_UP));
                break;
            }
            tempLastRow.set("a_localamt", (Object)BigDecimal.ZERO);
        }
        for (i = allocEntries.size() - 1; i >= 0; --i) {
            tempLastRow = (DynamicObject)allocEntries.get(i);
            allocRowPer = tempLastRow.getBigDecimal("a_allocationper");
            BigDecimal allocAmt = tempLastRow.getBigDecimal("a_allocationamt");
            BigDecimal allocLocalAmt = tempLastRow.getBigDecimal("a_localamt");
            if (allocLocalAmt.compareTo(BigDecimal.ZERO) != 0 || allocRowPer.compareTo(BigDecimal.ZERO) != 0 || allocAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            allocEntries.remove(i);
        }
    }

    public static void executeAllocateByPerCalculation(BigDecimal billAmt, DynamicObject targetBill) {
        DynamicObjectCollection allocEntries = targetBill.getDynamicObjectCollection("allocationentry");
        int headCurrencyPrecision = AllocationUtils.getHeadCurrencyPercision(targetBill);
        for (DynamicObject allocRow : allocEntries) {
            BigDecimal allocRowAmount = allocRow.getBigDecimal("a_allocationamt");
            BigDecimal allocRowPer = allocRowAmount.divide(billAmt, 10, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(headCurrencyPrecision, RoundingMode.HALF_UP);
            allocRow.set("a_allocationper", (Object)allocRowPer);
        }
        DynamicObject lastRow = (DynamicObject)allocEntries.get(allocEntries.size() - 1);
        BigDecimal allocPer = lastRow.getBigDecimal("a_allocationper");
        BigDecimal allocPerDifference = AllocationUtils.getPropertyDifference(targetBill, BigDecimal.valueOf(100L), "allocationentry", "a_allocationper");
        BigDecimal afterAllocPer = allocPer.add(allocPerDifference);
        lastRow.set("a_allocationper", (Object)afterAllocPer);
        for (int i = allocEntries.size() - 1; i >= 0; --i) {
            DynamicObject tempLastRow = (DynamicObject)allocEntries.get(i);
            BigDecimal allocRowPer = tempLastRow.getBigDecimal("a_allocationper");
            BigDecimal allocAmt = tempLastRow.getBigDecimal("a_allocationamt");
            BigDecimal allocLocalAmt = tempLastRow.getBigDecimal("a_localamt");
            if (allocLocalAmt.compareTo(BigDecimal.ZERO) != 0 || allocRowPer.compareTo(BigDecimal.ZERO) != 0 || allocAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            allocEntries.remove(i);
        }
    }

    public static BigDecimal getPropertyDifference(DynamicObject billEntity, BigDecimal target, String entryName, String propertyName) {
        DynamicObjectCollection allocEntries = billEntity.getDynamicObjectCollection(entryName);
        BigDecimal totalAmt = allocEntries.stream().map(entry -> entry.getBigDecimal(propertyName)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (totalAmt.compareTo(target) == 0) {
            return BigDecimal.ZERO;
        }
        return target.subtract(totalAmt);
    }

    public static BigDecimal getEntryTotalAllocPer(DynamicObject billEntity) {
        return billEntity.getDynamicObjectCollection("allocationentry").stream().map(entry -> entry.getBigDecimal("a_allocationper")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static boolean isAllocationByPercent(String billName, DynamicObject billEntity) {
        if (!"ap_finapbill".equals(billName)) {
            return true;
        }
        boolean allocaByPer = billEntity.getBoolean("allocatebyper");
        return allocaByPer;
    }

    public static int getBaseCurrencyPrecision(DynamicObject billEntity) {
        DynamicObject baseCurrency = billEntity.getDynamicObject("basecurrency");
        if (baseCurrency == null) {
            BigDecimal headAmt = billEntity.getBigDecimal("amount");
            return headAmt.scale();
        }
        return baseCurrency.getInt("amtprecision");
    }

    public static int getHeadCurrencyPercision(DynamicObject billEntity) {
        DynamicObject headCurrency = billEntity.getDynamicObject("currency");
        if (headCurrency == null) {
            return AllocationUtils.getBaseCurrencyPrecision(billEntity);
        }
        return headCurrency.getInt("amtprecision");
    }

    public static void calculateAndSetAllocDifference(DynamicObject[] entities) {
        String entityName = entities[0].getDataEntityType().getName();
        String headLocalAmtName = null;
        for (DynamicObject bill : entities) {
            DynamicObject tempLastRow;
            int i;
            boolean expenseAlloc = bill.getBoolean("isexpensealloc");
            if (!expenseAlloc) continue;
            boolean allocByPer = bill.getBoolean("allocatebyper");
            boolean isInTax = false;
            headLocalAmtName = "ap_finapbill".equals(entityName) ? ((isInTax = bill.getBoolean("isintax")) ? "pricetaxtotalbase" : "amountbase") : "localamt";
            DynamicObjectCollection allocEntries = bill.getDynamicObjectCollection("allocationentry");
            DynamicObject lastRow = (DynamicObject)allocEntries.get(allocEntries.size() - 1);
            BigDecimal headAmt = isInTax ? bill.getBigDecimal("pricetaxtotal") : bill.getBigDecimal("amount");
            int headCurrencyPrecision = AllocationUtils.getHeadCurrencyPercision(bill);
            int baseCurrencyPrecision = AllocationUtils.getBaseCurrencyPrecision(bill);
            if (allocByPer) {
                BigDecimal allocAmt = lastRow.getBigDecimal("a_allocationamt");
                BigDecimal allocAmtDifference = AllocationUtils.getPropertyDifference(bill, headAmt, "allocationentry", "a_allocationamt");
                lastRow.set("a_allocationamt", (Object)allocAmt.add(allocAmtDifference).setScale(headCurrencyPrecision, RoundingMode.HALF_UP));
            } else {
                BigDecimal allocPer = lastRow.getBigDecimal("a_allocationper");
                BigDecimal allocPerDifference = AllocationUtils.getPropertyDifference(bill, BigDecimal.valueOf(100L), "allocationentry", "a_allocationper");
                lastRow.set("a_allocationper", (Object)allocPer.add(allocPerDifference).setScale(10, RoundingMode.HALF_UP));
            }
            for (i = allocEntries.size() - 1; i >= 0; --i) {
                BigDecimal headLocalAmt;
                BigDecimal localAmtDifference;
                tempLastRow = (DynamicObject)allocEntries.get(i);
                BigDecimal localAmt = tempLastRow.getBigDecimal("a_localamt");
                BigDecimal afterAllocLocAmt = localAmt.add(localAmtDifference = AllocationUtils.getPropertyDifference(bill, headLocalAmt = bill.getBigDecimal(headLocalAmtName), "allocationentry", "a_localamt"));
                if (afterAllocLocAmt.multiply(headLocalAmt).signum() > 0) {
                    tempLastRow.set("a_localamt", (Object)afterAllocLocAmt.setScale(baseCurrencyPrecision, RoundingMode.HALF_UP));
                    break;
                }
                tempLastRow.set("a_localamt", (Object)BigDecimal.ZERO);
            }
            for (i = allocEntries.size() - 1; i >= 0; --i) {
                tempLastRow = (DynamicObject)allocEntries.get(i);
                BigDecimal allocRowPer = tempLastRow.getBigDecimal("a_allocationper");
                BigDecimal allocAmt = tempLastRow.getBigDecimal("a_allocationamt");
                BigDecimal allocLocalAmt = tempLastRow.getBigDecimal("a_localamt");
                if (allocLocalAmt.compareTo(BigDecimal.ZERO) != 0 || allocRowPer.compareTo(BigDecimal.ZERO) != 0 || allocAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                allocEntries.remove(i);
            }
        }
    }

    public static void calculateAndSetAllocDifference(IDataModel model) {
        BigDecimal headAmt;
        DynamicObject bill = model.getDataEntity();
        String entityName = bill.getDataEntityType().getName();
        String headLocalAmtName = null;
        boolean expenseAlloc = (Boolean)model.getValue("isexpensealloc");
        if (!expenseAlloc) {
            return;
        }
        boolean allocByPer = (Boolean)model.getValue("allocatebyper");
        boolean isInTax = (Boolean)model.getValue("isintax");
        headLocalAmtName = "ap_finapbill".equals(entityName) ? (isInTax ? "pricetaxtotalbase" : "amountbase") : "localamt";
        DynamicObjectCollection allocEntryColl = (DynamicObjectCollection)model.getValue("allocationentry");
        if (allocEntryColl == null || allocEntryColl.size() == 0) {
            return;
        }
        DynamicObjectCollection allocEntries = model.getEntryEntity("allocationentry");
        DynamicObject lastRow = (DynamicObject)allocEntries.get(allocEntries.size() - 1);
        BigDecimal bigDecimal = headAmt = isInTax ? (BigDecimal)model.getValue("pricetaxtotal") : (BigDecimal)model.getValue("amount");
        if (allocByPer) {
            BigDecimal allocationper = BigDecimal.ZERO;
            for (DynamicObject allocEntry : allocEntries) {
                allocationper = allocationper.add(allocEntry.getBigDecimal("a_allocationper"));
            }
            if (allocationper.compareTo(BigDecimal.valueOf(100L)) != 0) {
                return;
            }
        } else {
            BigDecimal allocationamt = BigDecimal.ZERO;
            for (DynamicObject allocEntry : allocEntries) {
                allocationamt = allocationamt.add(allocEntry.getBigDecimal("a_allocationamt"));
            }
            if (allocationamt.compareTo(headAmt) != 0) {
                return;
            }
        }
        int headCurrencyPrecision = AllocationUtils.getHeadCurrencyPercision(bill);
        int baseCurrencyPrecision = AllocationUtils.getBaseCurrencyPrecision(bill);
        if (allocByPer) {
            BigDecimal allocAmt = lastRow.getBigDecimal("a_allocationamt");
            BigDecimal allocAmtDifference = AllocationUtils.getPropertyDifference(bill, headAmt, "allocationentry", "a_allocationamt");
            model.setValue("a_allocationamt", (Object)allocAmt.add(allocAmtDifference).setScale(headCurrencyPrecision, RoundingMode.HALF_UP), allocEntries.size() - 1);
        } else {
            BigDecimal allocPer = lastRow.getBigDecimal("a_allocationper");
            BigDecimal allocPerDifference = AllocationUtils.getPropertyDifference(bill, BigDecimal.valueOf(100L), "allocationentry", "a_allocationper");
            model.setValue("a_allocationper", (Object)allocPer.add(allocPerDifference).setScale(10, RoundingMode.HALF_UP), allocEntries.size() - 1);
        }
        for (int i = allocEntries.size() - 1; i >= 0; --i) {
            BigDecimal headLocalAmt;
            BigDecimal localAmtDifference;
            DynamicObject tempLastRow = (DynamicObject)allocEntries.get(i);
            BigDecimal localAmt = tempLastRow.getBigDecimal("a_localamt");
            BigDecimal afterAllocLocAmt = localAmt.add(localAmtDifference = AllocationUtils.getPropertyDifference(bill, headLocalAmt = bill.getBigDecimal(headLocalAmtName), "allocationentry", "a_localamt"));
            if (afterAllocLocAmt.multiply(headLocalAmt).signum() > 0) {
                model.setValue("a_localamt", (Object)afterAllocLocAmt.setScale(baseCurrencyPrecision, RoundingMode.HALF_UP), i);
                break;
            }
            model.setValue("a_localamt", (Object)BigDecimal.ZERO, i);
        }
    }

    static {
        expenseAllocProperties.put("entry", "allocationentry");
        expenseAllocProperties.put("percent", "a_allocationper");
        expenseAllocProperties.put("amount", "a_allocationamt");
        expenseAllocProperties.put("localAmt", "a_localamt");
        expenseAllocDetailProperties.put("entry", "detailallocentry");
        expenseAllocDetailProperties.put("percent", "a_detailallocationper");
        expenseAllocDetailProperties.put("amount", "a_detailallocationamt");
        expenseAllocDetailProperties.put("localAmt", "a_detaillocalamt");
        billDetailEntryProperties.put("ap_finapbill", "detailentry");
        billDetailEntryProperties.put("ap_busbill", "entry");
    }
}

