/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;

public class AntiCloseAccountValidatorBase
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(AntiCloseAccountValidatorBase.class);
    protected Date antiCloseDate;

    public void setAntiCloseDate(Date antiCloseDate) {
        this.antiCloseDate = antiCloseDate;
    }

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        List orgIds = Arrays.stream(datas).map(e -> e.getDataEntity().getLong("org.id")).collect(Collectors.toList());
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imsc", (String)"dmw", (String)"EASMigrateService", (String)"GetControlDateByOrg", (Object[])new Object[]{"ar_closeaccount".equals(this.entityKey) ? "ar" : "ap", orgIds});
        logger.info("AntiCloseAccountValidatorBase.result:" + result);
        Map orgIdAndControlDateMap = (Map)result.get("data");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logger.info("AntiCloseAccountValidatorBase.orgIdAndControlDateMap:" + orgIdAndControlDateMap);
        for (ExtendedDataEntity data : datas) {
            Date startDate;
            DynamicObject closeAccountsInfo = data.getDataEntity();
            DynamicObject org = closeAccountsInfo.getDynamicObject("org");
            boolean isFinishInit = closeAccountsInfo.getBoolean("isfinishinit");
            if (!isFinishInit) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5173\u8d26\u64cd\u4f5c\u3002", (String)"AntiCloseAccountValidatorBase_0", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(data, message);
            }
            if (this.antiCloseDate.compareTo(DateUtils.getLastDay((Date)(startDate = closeAccountsInfo.getDate("startdate")), (int)1)) < 0) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u9009\u62e9\u7684\u201c\u53cd\u5173\u8d26\u65e5\u671f\u201d\u4e0d\u80fd\u5c0f\u4e8e\u7ec4\u7ec7\u542f\u7528\u65e5\u671f\u7684\u524d\u4e00\u5929\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"AntiCloseAccountValidatorBase_1", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(data, message);
                continue;
            }
            Date currentDate = closeAccountsInfo.getDate("currentdate");
            if (this.antiCloseDate.compareTo(currentDate) >= 0) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u9009\u62e9\u7684\u201c\u53cd\u5173\u8d26\u65e5\u671f\u201d\u5e94\u8be5\u5c0f\u4e8e\u201c\u5f53\u524d\u65e5\u671f\u201d\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"AntiCloseAccountValidatorBase_2", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(data, message);
                continue;
            }
            if (!this.controlDateCheck(this.antiCloseDate, org.getLong("id"), orgIdAndControlDateMap, simpleDateFormat, data)) continue;
            String initEntity = "ar_closeaccount".equals(this.entityKey) ? "ar_init" : "ap_init";
            InitHelper helper = new InitHelper(((Long)org.getPkValue()).longValue(), initEntity);
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)helper.getCurperiodId(), (String)"bd_period");
            if (DateUtils.getNextDay((Date)this.antiCloseDate, (int)1).compareTo(currPeriod.getDate("begindate")) >= 0) continue;
            String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ed3\u8d26\uff0c\u9009\u62e9\u7684\u201c\u53cd\u5173\u8d26\u65e5\u671f\u201d\u5e94\u8be5\u5927\u4e8e\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"AntiCloseAccountValidatorBase_3", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"));
            this.addErrorMessage(data, message);
        }
    }

    private boolean controlDateCheck(Date beginDate, Long orgPk, Map<Long, String> orgIdAndControlDateMap, SimpleDateFormat simpleDateFormat, ExtendedDataEntity data) {
        Date controlDate;
        String controlDateString = orgIdAndControlDateMap.get(orgPk);
        if (controlDateString == null || "".equals(controlDateString)) {
            return true;
        }
        try {
            controlDate = simpleDateFormat.parse(controlDateString + " 00:00:00");
        }
        catch (ParseException eb) {
            throw new KDException((Throwable)eb, BosErrorCode.systemError, new Object[0]);
        }
        if (beginDate.compareTo(controlDate) <= 0) {
            this.addErrorMessage(data, "prohibit close account from eas date control");
            return false;
        }
        return true;
    }
}

