/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.BOTPNewHelper;

public class CasPayEntryRelationValidator
implements IOthersExecCtrlService {
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("sourcebilltype");
        selectors.add("entry.id");
        return selectors;
    }

    public Map<Long, String> validate(DynamicObject[] payBills) {
        HashMap<Long, String> result = new HashMap<Long, String>(payBills.length);
        HashMap payBillIdToEntryIdMap = new HashMap(payBills.length);
        HashSet<Long> needValidateBillPks = new HashSet<Long>(payBills.length);
        for (DynamicObject payBill : payBills) {
            String sourcebilltype = payBill.getString("sourcebilltype");
            if ("ap_finapbill".equals(sourcebilltype) || "ar_finarbill".equals(sourcebilltype) || "cas_paybill".equals(sourcebilltype)) continue;
            long payBillId = payBill.getLong("id");
            needValidateBillPks.add(payBillId);
            DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
            Set entryIds = entrys.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            payBillIdToEntryIdMap.put(payBillId, entryIds);
        }
        if (needValidateBillPks.size() > 0) {
            List linkUpNodeList = BFTrackerServiceHelper.loadLinkUpNodes((String)"cas_paybill", (Long[])needValidateBillPks.toArray(new Long[0]), (OperateOption)OperateOption.create());
            HashSet<Long> srcArBillIdSet = new HashSet<Long>(needValidateBillPks.size());
            HashSet<Long> srcApBillIdSet = new HashSet<Long>(needValidateBillPks.size());
            HashSet<Long> srcApOrArBillIdSet = new HashSet<Long>(needValidateBillPks.size());
            if (!linkUpNodeList.isEmpty()) {
                TableDefine arTableDefine = EntityMetadataCache.loadTableDefine((String)"ar_finarbill", (String)"ar_finarbill");
                Long arTableId = arTableDefine.getTableId();
                TableDefine apTableDefine = EntityMetadataCache.loadTableDefine((String)"ap_finapbill", (String)"ap_finapbill");
                Long apTableId = apTableDefine.getTableId();
                for (Long payId : needValidateBillPks) {
                    List nodes = linkUpNodeList.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(payId) == 0).collect(Collectors.toList());
                    ArrayList<BFRowLinkUpNode> arOrApsrcNodes = new ArrayList<BFRowLinkUpNode>(10);
                    for (BFRowLinkUpNode node : nodes) {
                        List<BFRowLinkUpNode> sourceNodes = CasPayEntryRelationValidator.findSourceNodes(node, arTableId, apTableId, payId);
                        arOrApsrcNodes.addAll(sourceNodes);
                    }
                    if (arOrApsrcNodes.isEmpty()) continue;
                    Long tableId = ((BFRowLinkUpNode)arOrApsrcNodes.get(0)).getRowId().getMainTableId();
                    if (arTableId.compareTo(tableId) == 0) {
                        srcArBillIdSet.add(payId);
                        srcApOrArBillIdSet.add(payId);
                        continue;
                    }
                    if (apTableId.compareTo(tableId) != 0) continue;
                    srcApBillIdSet.add(payId);
                    srcApOrArBillIdSet.add(payId);
                }
            }
            if (!srcApOrArBillIdSet.isEmpty()) {
                List relationentryids;
                HashSet srcApOrArEntryIds = new HashSet(srcApOrArBillIdSet.size());
                for (Long payId : srcApOrArBillIdSet) {
                    srcApOrArEntryIds.addAll((Collection)payBillIdToEntryIdMap.get(payId));
                }
                Map entryRelationMap = BOTPNewHelper.loadAllSourceBillIds((String)"cas_paybill", (String)"entry", (Long[])srcApOrArBillIdSet.toArray(new Long[0]), (Long[])srcApOrArEntryIds.toArray(new Long[0]));
                for (Long srcApBillId : srcApBillIdSet) {
                    Map entryRelation4SrcApBillId = (Map)entryRelationMap.get(srcApBillId);
                    if (entryRelation4SrcApBillId == null) {
                        result.put(srcApBillId, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728\u660e\u7ec6\u884c\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"CasPayEntryRelationValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                        continue;
                    }
                    relationentryids = (List)entryRelation4SrcApBillId.get("ap_finapbill");
                    if (relationentryids != null) continue;
                    result.put(srcApBillId, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728\u660e\u7ec6\u884c\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"CasPayEntryRelationValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                for (Long srcArBillId : srcArBillIdSet) {
                    Map entryRelation4SrcArBillId = (Map)entryRelationMap.get(srcArBillId);
                    if (entryRelation4SrcArBillId == null) {
                        result.put(srcArBillId, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355\u4e0d\u5b58\u5728\u660e\u7ec6\u884c\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"CasPayEntryRelationValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                        continue;
                    }
                    relationentryids = (List)entryRelation4SrcArBillId.get("ar_finarbill");
                    if (relationentryids != null) continue;
                    result.put(srcArBillId, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355\u4e0d\u5b58\u5728\u660e\u7ec6\u884c\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"CasPayEntryRelationValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long arTableId, Long apTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        Long mainTableId = node.getRowId().getMainTableId();
        if ((mainTableId.compareTo(arTableId) == 0 || mainTableId.compareTo(apTableId) == 0) && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(CasPayEntryRelationValidator.findSourceNodes(sNode, arTableId, apTableId, id));
            }
        }
        return nodes;
    }
}

