/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.business.dao.CashFlowItemDao;
import kd.fi.bd.business.service.PeriodService;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.cashflow.replace.CashFlowItemDBReplaceExecutor;
import kd.fi.bd.enums.CashFlowItemType;
import kd.fi.bd.interfaces.service.ICashFlowItemService;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.collector.ExtCollectors;
import kd.fi.bd.util.filter.QFilterBuilder;

public class CashFlowItemServiceImpl
implements ICashFlowItemService {
    private static final Log extLogger = ExtLogFactory.getLog(CashFlowItemServiceImpl.class, (String)"[CashFlowItemServiceImpl]");

    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Long periodId) {
        return this.loadSingleForVersion(itemNumber, orgId, periodId, (CashFlowItemVO itemVO) -> true);
    }

    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new String[]{itemNumber}, orgId, periodId, extFilter).get(itemNumber));
    }

    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Date effectiveDate) {
        return this.loadSingleForVersion(itemNumber, orgId, effectiveDate, (CashFlowItemVO itemVO) -> true);
    }

    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new String[]{itemNumber}, orgId, effectiveDate, extFilter).get(itemNumber));
    }

    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Long periodId) {
        return this.loadSingleForVersion(cashFlowItemId, orgId, periodId, (CashFlowItemVO itemVO) -> true);
    }

    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new Long[]{cashFlowItemId}, orgId, periodId, extFilter).get(cashFlowItemId));
    }

    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Date effectiveDate) {
        return this.loadSingleForVersion(cashFlowItemId, orgId, effectiveDate, (CashFlowItemVO itemVO) -> true);
    }

    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new Long[]{cashFlowItemId}, orgId, effectiveDate, extFilter).get(cashFlowItemId));
    }

    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Long periodId) {
        return this.loadForVersion(itemNumbers, orgId, periodId, (CashFlowItemVO ignore) -> true);
    }

    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        Date effectiveDate = PeriodService.loadSingle((Long)periodId).getEndDate();
        return this.loadForVersion(itemNumbers, orgId, effectiveDate, extFilter);
    }

    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Date effectiveDate) {
        return this.loadForVersion(itemNumbers, orgId, effectiveDate, (CashFlowItemVO ignore) -> true);
    }

    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        extLogger.info("loadForVersion params---itemNumbers:{}, orgId:{}, effectiveDate:{}", new Object[]{itemNumbers, orgId, effectiveDate});
        if (ArrayUtils.isEmpty((Object[])itemNumbers)) {
            return Collections.emptyMap();
        }
        QFilterBuilder baseQFilterBuilder = new QFilterBuilder();
        baseQFilterBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId));
        List cashFlowItemVOS = CashFlowItemDao.load((QFilter[])baseQFilterBuilder.toArray(new QFilter("number", "in", (Object)itemNumbers)), (String)"", (int)-1);
        Predicate<CashFlowItemVO> correctFilter = extFilter.and(item -> item.getStartDate().compareTo(effectiveDate) <= 0 && item.getEndDate().compareTo(effectiveDate) > 0);
        List poppedItems = BDUtil.popFromCollection((Collection)cashFlowItemVOS, correctFilter.negate());
        Map<String, CashFlowItemVO> result = cashFlowItemVOS.stream().collect(Collectors.toMap(CashFlowItemVO::getNumber, cfItem -> cfItem, (o, n) -> n));
        poppedItems.removeIf(itemVO -> result.containsKey(itemVO.getNumber()));
        if (poppedItems.isEmpty()) {
            extLogger.info("all items found in current level, loadForVersion result---result:{}", result);
            return result;
        }
        Multimap parentNumOriNumMap = (Multimap)poppedItems.stream().flatMap(item -> Arrays.stream(item.getLongNumber().split("@")).filter(numPerLevel -> !item.getNumber().equals(numPerLevel)).map(num -> Tuple.create((Object)num, (Object)item.getNumber()))).collect(ExtCollectors.toMultiap(t -> (String)t.item1, t -> (String)t.item2));
        List parentItemVOS = CashFlowItemDao.load((QFilter[])baseQFilterBuilder.toArray(new QFilter("number", "in", (Object)parentNumOriNumMap.keySet())), (String)"level desc", (int)-1);
        for (CashFlowItemVO parentItemVO : parentItemVOS) {
            for (String curOriNumber : parentNumOriNumMap.get((Object)parentItemVO.getNumber())) {
                if (!correctFilter.test(parentItemVO) || result.containsKey(curOriNumber)) continue;
                result.put(curOriNumber, parentItemVO);
            }
        }
        extLogger.info("loadForVersion result---result:{}", result);
        return result;
    }

    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Long periodId) {
        return this.loadForVersion(cashFlowItemIds, orgId, periodId, (CashFlowItemVO itemVO) -> true);
    }

    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        Date effectiveDate = PeriodService.loadSingle((Long)periodId).getEndDate();
        return this.loadForVersion(cashFlowItemIds, orgId, effectiveDate, extFilter);
    }

    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Date effectiveDate) {
        return this.loadForVersion(cashFlowItemIds, orgId, effectiveDate, (CashFlowItemVO ignore) -> true);
    }

    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        extLogger.info("loadForVersion params---itemIds:{}, orgId:{}, effectiveDate:{}", new Object[]{cashFlowItemIds, orgId, effectiveDate});
        if (ArrayUtils.isEmpty((Object[])cashFlowItemIds)) {
            return Collections.emptyMap();
        }
        Map<Long, CashFlowItemVO> result = this.load(cashFlowItemIds);
        Set<Long> allPermittedItems = this.getAllPermittedItems(orgId);
        Predicate<CashFlowItemVO> correctFilter = extFilter.and(item -> item.getStartDate().compareTo(effectiveDate) <= 0 && item.getEndDate().compareTo(effectiveDate) > 0).and(item -> allPermittedItems.contains(item.getId()));
        Map poppedMap = BDUtil.popFromMap(result, e -> correctFilter.negate().test(e.getValue()));
        if (poppedMap.isEmpty()) {
            extLogger.info("all items found with id, loadForVersion result---result:{}", result);
            return result;
        }
        Map<String, Long> numberIdMap = poppedMap.entrySet().stream().map(e -> Tuple.create((Object)((CashFlowItemVO)e.getValue()).getNumber(), e.getKey())).collect(Collectors.toMap(t -> (String)t.item1, t -> (Long)t.item2));
        Map<String, CashFlowItemVO> numberItemMap = this.loadForVersion(numberIdMap.keySet().toArray(new String[0]), orgId, effectiveDate, extFilter);
        numberItemMap.forEach((number, item) -> result.put((Long)numberIdMap.get(number), (CashFlowItemVO)item));
        extLogger.info("loadForVersion result---result:{}", result);
        return result;
    }

    public List<CashFlowItemVO> loadVersionByOrg(Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        QFilterBuilder qFilterBuilder = new QFilterBuilder();
        Date periodEndDate = PeriodService.loadSingle((Long)periodId).getEndDate();
        qFilterBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId)).add("startdate", "<=", periodEndDate).add("enddate", ">", periodEndDate);
        return CashFlowItemDao.load((QFilter[])qFilterBuilder.toArray(new QFilter[0]), (String)"", (int)-1).stream().filter(extFilter).collect(Collectors.toList());
    }

    public CashFlowItemVO loadSingle(Long cashFlowItemId) {
        return CashFlowItemDao.loadSingle((Long)cashFlowItemId);
    }

    public Map<Long, CashFlowItemVO> load(Long[] cashFlowItemIds) {
        return CashFlowItemDao.load((Long[])cashFlowItemIds);
    }

    public Set<Long> getAllPermittedItems(Long orgId) {
        QFilter baseDataIdInFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"gl_cashflowitem", (Long)orgId);
        extLogger.info("getAllPermittedItems: generated filter is {}", (Object)baseDataIdInFilter);
        if (baseDataIdInFilter == null || !(baseDataIdInFilter.getValue() instanceof Collection)) {
            return Collections.emptySet();
        }
        return new HashSet<Long>((Collection)baseDataIdInFilter.getValue());
    }

    public QFilterBuilder buildSpeceficVersionFilter(CashFlowItemType type, Long periodId) {
        Date periodEndDate = PeriodService.loadSingle((Long)periodId).getEndDate();
        QFilterBuilder qFilterBuilder = (QFilterBuilder)type.getBaseFilter().get();
        qFilterBuilder.add("startdate", "<=", periodEndDate).add("enddate", ">", periodEndDate);
        return qFilterBuilder;
    }

    public QFilterBuilder buildLatestVersionFilter(CashFlowItemType type) {
        Date endDate = AccountRefUtils.getEndDate();
        QFilterBuilder qFilterBuilder = (QFilterBuilder)type.getBaseFilter().get();
        qFilterBuilder.addEqual("enddate", endDate);
        return qFilterBuilder;
    }

    public int replaceDBItem(Long orgId, Long previousMasterId, Long updatedId) {
        return CashFlowItemDBReplaceExecutor.replace((Long)orgId, (Long)previousMasterId, (Long)updatedId);
    }
}

