/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.filter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.multi.MultiQuery;
import kd.bos.util.StringUtils;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.filter.FIQFilterUtil;
import kd.fi.bd.util.filter.FilterMergedStatusCode;
import kd.fi.bd.util.filter.FilterValueMergeContainer;
import kd.fi.bd.util.filter.IStoredWildcardKey;
import kd.fi.bd.util.filter.QFilterBuilder;

public class QFilterBuilder
implements Serializable {
    private static final long serialVersionUID = 2607013596458482545L;
    private static final QFilter Void_Filter = new QFilter("1", "!=", (Object)"1", true);
    private static final List<QFilter> Void_Filter_Collection = Collections.singletonList(Void_Filter);
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final char DEFAULT_WILDCARD = '%';
    private static final int SINGLE_FILTER_LEN_LIMIT = 200;
    private LinkedList<QFilter> filters = new LinkedList();
    private int modifyCnt = 0;
    private int deleteCnt = 0;
    private boolean isValidFilter = true;
    private static final Predicate<QFilter> IS_SINGLE_Q_FILTER = x -> null != x && !x.isJoinFilter() && !x.isExistsFilter() && !x.isExpressValue() && !x.isParseExistsValue() && !x.isOnMetaJoinPropertyFilter() && !x.isJoinSQLFilter();

    public QFilterBuilder() {
    }

    public QFilterBuilder(Collection<QFilter> srcFilters) {
        this();
        if (srcFilters != null && !srcFilters.isEmpty()) {
            this.filters.addAll(srcFilters);
        }
    }

    public QFilterBuilder(QFilter[] srcFilters) {
        this(Arrays.asList(srcFilters));
    }

    public static QFilterBuilder create(Collection<QFilter> srcFilters) {
        return new QFilterBuilder(srcFilters);
    }

    public static QFilterBuilder create(QFilter[] srcFilters) {
        return new QFilterBuilder(Arrays.asList(srcFilters));
    }

    public String toString() {
        return "QFilterBuilder{filters=" + this.filters + ", modifyCnt=" + this.modifyCnt + ", deleteCnt=" + this.deleteCnt + '}';
    }

    public static QFilter getVoidFilter() {
        return Void_Filter;
    }

    public static List<QFilter> getVoid_Filter_Collection() {
        return Void_Filter_Collection;
    }

    public static void collectFilterInfos(boolean allowMultipleMatch, boolean processNestFilter, Collection<QFilter> srcFilters, BiConsumer<QFilter, Integer> processFunc, Collection<String> matchPropertyNames) {
        QFilterBuilder.collectFilterInfos(processNestFilter, srcFilters, processFunc, (IQFilterMatcher)(matchPropertyNames == null ? null : new SimpleFilterNameMatcher(matchPropertyNames, allowMultipleMatch)));
    }

    public static void collectFilterInfos(Collection<QFilter> srcFilters, BiConsumer<QFilter, Integer> processFunc, String[] matchNames) {
        QFilterBuilder.collectFilterInfos(false, true, srcFilters, processFunc, Arrays.asList(matchNames));
    }

    public void collectFilterInfos(BiConsumer<QFilter, Integer> processFunc, String[] matchNames) {
        QFilterBuilder.collectFilterInfos(false, true, this.getFilters(), processFunc, Arrays.asList(matchNames));
    }

    public static void collectFilterInfos(boolean processNestFilter, Collection<QFilter> srcFilters, BiConsumer<QFilter, Integer> processFunc, IQFilterMatcher propMatcher) {
        QFilterBuilder.collectFilterInfos(processNestFilter, srcFilters, processFunc, propMatcher, -1);
    }

    private static int collectFilterInfos(boolean processNestFilter, Collection<QFilter> srcFilters, BiConsumer<QFilter, Integer> processFunc, IQFilterMatcher propMatcher, int filterIndex) {
        if (srcFilters == null || srcFilters.isEmpty() || processFunc == null) {
            return filterIndex;
        }
        boolean matchAll = propMatcher == null;
        for (QFilter filter : srcFilters) {
            List nestFilters;
            String propertyName;
            ++filterIndex;
            if (filter == null || StringUtils.isEmpty((String)(propertyName = filter.getProperty()))) continue;
            if (matchAll || propMatcher.test(propertyName, filter)) {
                processFunc.accept(filter, filterIndex);
                if (!matchAll && propMatcher.isEmpty()) break;
            }
            if (!processNestFilter || (nestFilters = filter.getNests(false)).isEmpty()) continue;
            filterIndex = QFilterBuilder.collectFilterInfos(processNestFilter, nestFilters.stream().map(nestFilter -> nestFilter.getFilter()).collect(Collectors.toList()), processFunc, propMatcher, filterIndex);
            if (matchAll || !propMatcher.isEmpty()) continue;
            break;
        }
        return filterIndex;
    }

    public static QFilterBuilder modifyFilters(Collection<QFilter> srcFilters, boolean processNestFilter, Function<QFilter, QFilter> processFunc, IQFilterMatcher propMatcher) {
        QFilterBuilder result = new QFilterBuilder();
        if (srcFilters.isEmpty() || processFunc == null) {
            return result;
        }
        boolean isMatchAll = propMatcher == null;
        for (QFilter filter : srcFilters) {
            QFilter modifiedFilter;
            String propertyName;
            if (filter == null || StringUtils.isEmpty((String)(propertyName = filter.getProperty()))) continue;
            if (isMatchAll || propMatcher.test(propertyName, filter)) {
                ++result.modifyCnt;
                modifiedFilter = processFunc.apply(filter);
                if (modifiedFilter == null) {
                    ++result.deleteCnt;
                    continue;
                }
            } else {
                modifiedFilter = filter;
                if (processNestFilter) {
                    QFilterBuilder modifiedBuf = QFilterBuilder.modifyNestFilters(filter, processFunc, propMatcher);
                    if (modifiedBuf.modifyCnt > 0) {
                        modifiedFilter = modifiedBuf.buildSingleFilter();
                    }
                }
            }
            result.add(modifiedFilter);
        }
        return result;
    }

    public static QFilterBuilder modifyFilters(Collection<QFilter> srcFilters, Function<QFilter, QFilter> processFunc, String[] matchPropertyNames) {
        return QFilterBuilder.modifyFilters(srcFilters, true, processFunc, (IQFilterMatcher)new SimpleFilterNameMatcher(Arrays.asList(matchPropertyNames)));
    }

    public static QFilterBuilder modifyFilters(Collection<QFilter> srcFilters, boolean processNestFilter, Function<QFilter, QFilter> processFunc, String[] matchPropertyNames) {
        return QFilterBuilder.modifyFilters(srcFilters, processNestFilter, processFunc, (IQFilterMatcher)new SimpleFilterNameMatcher(Arrays.asList(matchPropertyNames)));
    }

    public QFilterBuilder modifyFilters(Function<QFilter, QFilter> processFunc, boolean processNestFilter, String[] matchPropertyNames) {
        return QFilterBuilder.modifyFilters(this.filters, processNestFilter, processFunc, (IQFilterMatcher)new SimpleFilterNameMatcher(Arrays.asList(matchPropertyNames)));
    }

    public QFilterBuilder modifyFilters(Function<QFilter, QFilter> processFunc, String[] matchPropertyNames) {
        return QFilterBuilder.modifyFilters(this.filters, true, processFunc, (IQFilterMatcher)new SimpleFilterNameMatcher(Arrays.asList(matchPropertyNames)));
    }

    public static QFilterBuilder modifyNestFilters(QFilter srcFilter, Function<QFilter, QFilter> processFunc, IQFilterMatcher propMatcher) {
        QFilterBuilder result = new QFilterBuilder();
        if (srcFilter == null || processFunc == null) {
            return result;
        }
        List nestFilters = srcFilter.getNests(false);
        if (nestFilters == null || nestFilters.isEmpty()) {
            return result;
        }
        boolean isMatchAll = propMatcher == null;
        boolean needAdd = true;
        QFilter modifiedFilter = srcFilter.__copy(false);
        if (isMatchAll || propMatcher.test(modifiedFilter.getProperty(), modifiedFilter)) {
            ++result.modifyCnt;
            if ((modifiedFilter = processFunc.apply(modifiedFilter)) == null) {
                ++result.deleteCnt;
                needAdd = false;
            }
        }
        if (needAdd) {
            result.add(modifiedFilter);
        }
        boolean changeCnt = false;
        block8: for (QFilter.QFilterNest filter : nestFilters) {
            List childNestFilters;
            if (filter == null || (modifiedFilter = filter.getFilter()) == null) continue;
            if (isMatchAll || propMatcher.test(modifiedFilter.getProperty(), modifiedFilter)) {
                ++result.modifyCnt;
                if ((modifiedFilter = processFunc.apply(modifiedFilter)) == null) {
                    ++result.deleteCnt;
                }
            }
            if ((childNestFilters = filter.getFilter().getNests(false)) != null && !childNestFilters.isEmpty()) {
                for (QFilter.QFilterNest childFilter : childNestFilters) {
                    QFilterBuilder nestResult = QFilterBuilder.modifyNestFilters(childFilter.getFilter(), processFunc, propMatcher);
                    if (!nestResult.isEmpty()) {
                        result.add(nestResult.buildSingleFilter());
                    }
                    result.modifyCnt += nestResult.modifyCnt;
                    result.deleteCnt += nestResult.deleteCnt;
                }
            }
            if (modifiedFilter == null) continue;
            switch (filter.getOp()) {
                case "AND": {
                    result.and(modifiedFilter);
                    continue block8;
                }
                case "OR": {
                    result.or(modifiedFilter);
                    continue block8;
                }
            }
        }
        return result;
    }

    public static QFilterBuilder modifyNestFilters(QFilter srcFilter, Function<QFilter, QFilter> processFunc, String ... matchPropertyNames) {
        return QFilterBuilder.modifyNestFilters(srcFilter, processFunc, (IQFilterMatcher)new SimpleFilterNameMatcher(Arrays.asList(matchPropertyNames), true));
    }

    public static IQFilterMatcher createQFilterMatcher(String ... matchPropertyNames) {
        return new SimpleFilterNameMatcher(matchPropertyNames);
    }

    public static QFilterBuilder create(String field, String qc, Object val) {
        return new QFilterBuilder().add(field, qc, val);
    }

    public QFilterBuilder add(String field, String qc, Object val) {
        this.add(new QFilter(field, qc, val));
        return this;
    }

    public QFilterBuilder addIn(String field, Object val, boolean skipNull) {
        List param = IDataValueUtil.enumerateObjectToList((Object)val);
        if (!param.isEmpty() || !skipNull) {
            this.add(new QFilter(field, "in", (Object)param));
        }
        return this;
    }

    public QFilterBuilder addIn(String field, Object val) {
        return this.addIn(field, val, false);
    }

    public QFilterBuilder addEqual(String field, Object val, boolean skipNull) {
        if (val == null && skipNull) {
            return this;
        }
        LinkedList buf = new LinkedList();
        IDataValueUtil.enumerateObject((Object)val, (i, v) -> buf.add(v));
        if (buf.size() == 1) {
            this.add(new QFilter(field, "=", buf.getFirst()));
        } else {
            this.add(new QFilter(field, "in", buf));
        }
        return this;
    }

    public QFilterBuilder addEqual(String field, Object val) {
        return this.addEqual(field, val, false);
    }

    public QFilterBuilder add(List<QFilter> ls) {
        for (QFilter filter : ls) {
            this.add(filter);
        }
        return this;
    }

    public final QFilterBuilder add(QFilter f) {
        if (f != null) {
            this.filters.add(f);
        }
        return this;
    }

    public QFilterBuilder and(QFilter f) {
        if (this.filters.isEmpty()) {
            this.add(f);
        } else if (f != null) {
            this.filters.getLast().and(f);
        }
        return this;
    }

    public QFilterBuilder and(String field, String qc, Object val) {
        return this.and(new QFilter(field, qc, val));
    }

    public QFilterBuilder and(QFilterBuilder qfBuilder) {
        if (this.filters.isEmpty()) {
            this.filters.addAll(qfBuilder.filters);
        } else {
            for (QFilter qFilter : qfBuilder.filters) {
                this.filters.getLast().and(qFilter);
            }
        }
        return this;
    }

    public QFilterBuilder or(QFilter f) {
        if (this.filters.isEmpty()) {
            this.add(f);
        } else if (f != null) {
            this.filters.getLast().or(f);
        }
        return this;
    }

    public QFilterBuilder or(String field, String qc, Object val) {
        return this.or(new QFilter(field, qc, val));
    }

    public QFilterBuilder or(QFilterBuilder qfBuilder) {
        if (this.filters.isEmpty()) {
            this.filters.addAll(qfBuilder.filters);
        } else {
            QFilter lastFilter = this.filters.getLast();
            for (QFilter qFilter : qfBuilder.filters) {
                lastFilter.or(qFilter);
            }
        }
        return this;
    }

    public int size() {
        return this.filters.size();
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public QFilterBuilder clear() {
        this.deleteCnt = 0;
        this.modifyCnt = 0;
        this.filters.clear();
        return this;
    }

    public QFilter[] toArray(QFilter ... additionFilters) {
        int additionSize;
        int orginalSize = this.filters.size();
        int n = additionSize = additionFilters != null ? additionFilters.length : 0;
        if (orginalSize + additionSize <= 0) {
            return null;
        }
        QFilter[] result = new QFilter[orginalSize + additionSize];
        int i = 0;
        for (QFilter f : this.filters) {
            result[i++] = f;
        }
        if (additionSize > 0) {
            for (QFilter f : additionFilters) {
                result[i++] = f;
            }
        }
        return result;
    }

    public LinkedList<QFilter> getFilters() {
        return this.filters;
    }

    public QFilter buildSingleFilter() {
        if (this.filters.isEmpty()) {
            return null;
        }
        Iterator filterIterator = this.filters.iterator();
        QFilter result = ((QFilter)filterIterator.next()).copy();
        while (filterIterator.hasNext()) {
            QFilter buf = (QFilter)filterIterator.next();
            if (buf == null) continue;
            result.and(buf.copy());
        }
        return result;
    }

    public String toFilterString() {
        QFilter filter = this.buildSingleFilter();
        return filter != null ? QFilterBuilder.qfilterToString(filter, true, FIQFilterUtil::parametertoString) : null;
    }

    public static QFilter removeQFilter(QFilter srcFilter, String ... matchPropNames) {
        if (srcFilter == null) {
            return null;
        }
        return QFilterBuilder.modifyFilters(Collections.singleton(srcFilter), oldFilter -> null, matchPropNames).buildSingleFilter();
    }

    public static QFilterBuilder removeQFilter(Collection<QFilter> srcFilters, String ... matchPropNames) {
        if (srcFilters == null) {
            return null;
        }
        return QFilterBuilder.modifyFilters(srcFilters, oldFilter -> null, matchPropNames);
    }

    public static QFilterBuilder removeQFilter(QFilter[] srcFilters, String ... matchPropNames) {
        if (srcFilters == null) {
            return null;
        }
        return QFilterBuilder.removeQFilter(Arrays.asList(srcFilters), matchPropNames);
    }

    public boolean isWildcardQCP(String qcp) {
        if (qcp != null) {
            switch (qcp.toLowerCase()) {
                case "like": 
                case "ilike": 
                case "match": 
                case "ftlike": {
                    return true;
                }
            }
        }
        return false;
    }

    public static void parseContainerValues(Object srcValue, Object replaceForNullValue, boolean skipNullValue, Consumer<Object> valueConsumer) {
        if (srcValue == null) {
            if (!skipNullValue) {
                valueConsumer.accept(replaceForNullValue);
            }
        } else if (srcValue instanceof Collection) {
            for (Object v : (Collection)srcValue) {
                QFilterBuilder.parseContainerValues(v, replaceForNullValue, skipNullValue, valueConsumer);
            }
        } else if (srcValue.getClass().isArray()) {
            for (Object v : (Object[])srcValue) {
                QFilterBuilder.parseContainerValues(v, replaceForNullValue, skipNullValue, valueConsumer);
            }
        } else {
            valueConsumer.accept(srcValue instanceof IStoredWildcardKey ? ((IStoredWildcardKey)srcValue).getCompareKey(true) : srcValue);
        }
    }

    public static void parseContainerValues(Object srcValue, Consumer<Object> valueConsumer) {
        QFilterBuilder.parseContainerValues(srcValue, null, true, valueConsumer);
    }

    public static List<Object> getContainerValues(Object srcValue) {
        LinkedList<Object> resultList = new LinkedList<Object>();
        QFilterBuilder.parseContainerValues(srcValue, v -> resultList.add(v));
        return resultList;
    }

    public static QParameter getQParameterFromQFilter(String entityName, QFilter srcFilter) {
        return QFilterBuilder.getQParameterFromQFilter(entityName, "id", srcFilter);
    }

    public static QParameter getQParameterFromQFilter(String entityName, QFilter[] srcFilters) {
        return QFilterBuilder.getQParameterFromQFilter(entityName, QFilterBuilder.create(srcFilters).buildSingleFilter());
    }

    public static QParameter getQParameterFromQFilter(String entityName, String entityKeyField, QFilter srcFilter) {
        if (entityName == null || srcFilter == null || StringUtils.isEmpty((String)entityKeyField)) {
            return null;
        }
        MultiQuery multiQuery = ORM.create().$createMultiQuery(entityName, entityKeyField, new QFilter[]{srcFilter});
        return srcFilter.toQParameter(multiQuery.getQueries()[0].getAllCtx());
    }

    public static List<QFilter> mergeDuplicateFilters(Collection<QFilter> filters, BiFunction<String, QFilter, String> aliasNameConvertor) {
        LinkedHashMap<String, QFilter> skipProcfilters = new LinkedHashMap<String, QFilter>(filters.size());
        boolean isComplexFilter = false;
        boolean isValidFilter = true;
        FilterValueMergeContainer filterValueMergeContainer = new FilterValueMergeContainer(16);
        for (QFilter filter : filters) {
            if (IS_SINGLE_Q_FILTER.test(filter)) {
                List nests = filter.getNests(true);
                if (!nests.isEmpty()) {
                    if (!nests.stream().anyMatch(x -> !x.isAnd())) {
                        QFilter.QFilterNest nest;
                        Iterator iterator = nests.iterator();
                        while (iterator.hasNext() && !(isValidFilter = FilterMergedStatusCode.Terminated != filterValueMergeContainer.addFilter((nest = (QFilter.QFilterNest)iterator.next()).getFilter()))) {
                        }
                        if (!isValidFilter || FilterMergedStatusCode.Terminated != filterValueMergeContainer.pack()) continue;
                        filter = filterValueMergeContainer.getFilterBuilder().buildSingleFilter();
                        filterValueMergeContainer.clear();
                    } else {
                        isComplexFilter = true;
                    }
                }
            } else {
                isComplexFilter = true;
            }
            skipProcfilters.put(filter.toString(), filter);
        }
        if (isValidFilter && !isComplexFilter) {
            filterValueMergeContainer.clear();
            boolean hasAliasNameConvertor = aliasNameConvertor != null;
            for (QFilter filter : skipProcfilters.values()) {
                if (hasAliasNameConvertor) {
                    filter.__setProperty(aliasNameConvertor.apply(filter.getProperty(), filter));
                }
                if (FilterMergedStatusCode.Terminated == filterValueMergeContainer.addFilter(filter)) {
                    return Void_Filter_Collection;
                }
                List nests = filter.getNests(true);
                if (nests == null || nests.isEmpty()) continue;
                for (QFilter.QFilterNest nest : nests) {
                    filterValueMergeContainer.addFilter(nest.getFilter());
                }
            }
            if (FilterMergedStatusCode.Terminated == filterValueMergeContainer.pack()) {
                return Void_Filter_Collection;
            }
            return filterValueMergeContainer.getFilterBuilder().getFilters();
        }
        return new LinkedList<QFilter>(skipProcfilters.values());
    }

    public static List<QFilter> mergeDuplicateFilters(Collection<QFilter> filters) {
        return QFilterBuilder.mergeDuplicateFilters(filters, null);
    }

    public void pack(BiFunction<String, QFilter, String> alaisNameConvertor) {
        List<QFilter> newFilters = QFilterBuilder.mergeDuplicateFilters(this.filters, alaisNameConvertor);
        this.filters.clear();
        this.filters.addAll(newFilters);
    }

    public static PairTuple<String, List<Object>> convertToJoinSQL(String initialSQL, List<QFilter> srcFilters, Function<Integer, String> joinSQLCustomizer) {
        LinkedList filterParams = new LinkedList();
        StringBuilder filterClause = new StringBuilder(initialSQL);
        block26: for (QFilter filter : srcFilters) {
            String sqlBufString;
            if (filter == null || (sqlBufString = filter.getCP()) == null) continue;
            Object filterValBuf = filter.getValue();
            switch (sqlBufString.toLowerCase()) {
                case "like": 
                case "ilike": 
                case "match": 
                case "not like": 
                case "ftlike": 
                case "=": 
                case "!=": 
                case "<>": {
                    filterClause.append(String.format(joinSQLCustomizer.apply(1), sqlBufString, "?"));
                    QFilterBuilder.parseContainerValues(filterValBuf, v -> filterParams.add(v));
                    continue block26;
                }
                case "in": 
                case "not in": {
                    LinkedHashSet paramBuf = new LinkedHashSet(4);
                    QFilterBuilder.parseContainerValues(filterValBuf, v -> paramBuf.add(v));
                    filterClause.append(String.format(joinSQLCustomizer.apply(Integer.MAX_VALUE), sqlBufString, QFilterBuilder.buildSQLParamHolder(paramBuf.size())));
                    if (paramBuf.isEmpty()) continue block26;
                    filterParams.addAll(paramBuf);
                    continue block26;
                }
                case "is null": 
                case "is not null": {
                    filterClause.append(String.format(joinSQLCustomizer.apply(0), sqlBufString, ""));
                    continue block26;
                }
                case ">=": 
                case ">": 
                case "<=": 
                case "<": {
                    filterClause.append(String.format(joinSQLCustomizer.apply(2), sqlBufString, "?"));
                    QFilterBuilder.parseContainerValues(filterValBuf, v -> filterParams.add(v));
                    continue block26;
                }
            }
            throw new IllegalArgumentException("Unsupported Filter Operator on Filter: " + filter);
        }
        return new PairTuple((Object)filterClause.toString(), filterParams);
    }

    public static PairTuple<String, List<Object>> convertToJoinSQL(String initialSQL, QFilterBuilder srcQFilterBuilder, Function<Integer, String> joinSQLCustomizer) {
        return QFilterBuilder.convertToJoinSQL(initialSQL, srcQFilterBuilder.getFilters(), joinSQLCustomizer);
    }

    public static void dumpQFilters(Collection<QFilter> srcFilters, StringBuilder outputBuffer, int singleFilterLimit, int totalOutputLimit) {
        if (outputBuffer == null) {
            return;
        }
        if (srcFilters == null || srcFilters.isEmpty()) {
            outputBuffer.append("- null -");
        } else {
            boolean unlimitAppend = totalOutputLimit <= 0;
            int remainTotalLength = unlimitAppend ? Integer.MAX_VALUE : totalOutputLimit;
            boolean unlimitSingleFilter = singleFilterLimit <= 0;
            int totalLength = 0;
            int totalNestFilterCnt = 0;
            for (QFilter filter : srcFilters) {
                List nestFilterList;
                String filterText;
                int currentTextLength;
                if (filter == null || (currentTextLength = (filterText = filter.toString()).length()) <= 0) continue;
                totalLength += currentTextLength;
                int cutTextLength = currentTextLength;
                if (!unlimitAppend && cutTextLength > remainTotalLength) {
                    cutTextLength = remainTotalLength;
                }
                if (!unlimitSingleFilter && cutTextLength > singleFilterLimit) {
                    cutTextLength = singleFilterLimit;
                }
                if (cutTextLength < currentTextLength) {
                    filterText = filterText.substring(0, cutTextLength) + String.format(" /** ignore:%s **/", currentTextLength - cutTextLength);
                }
                if (unlimitAppend || (remainTotalLength -= cutTextLength) > 0) {
                    outputBuffer.append(' ').append(filterText);
                }
                if ((nestFilterList = filter.getNests(true)) == null || nestFilterList.isEmpty()) continue;
                totalNestFilterCnt += nestFilterList.size();
            }
            outputBuffer.insert(0, String.format("/** Len:(%d/%d), Root Cnt=%d, NestCnt=%d **/ ", totalOutputLimit, totalLength, srcFilters.size(), totalNestFilterCnt));
        }
    }

    public static void dumpQFilters(Collection<QFilter> srcFilters, StringBuilder outputBuffer) {
        QFilterBuilder.dumpQFilters(srcFilters, outputBuffer, 200, -1);
    }

    public static String dumpQFilters(Collection<QFilter> srcFilters) {
        StringBuilder outputBuffer = new StringBuilder();
        QFilterBuilder.dumpQFilters(srcFilters, outputBuffer, 200, -1);
        return outputBuffer.toString();
    }

    public static String buildSQLParamHolder(int size) {
        if (size <= 0) {
            return "()";
        }
        if (size == 1) {
            return "(?)";
        }
        StringBuilder builder = new StringBuilder("(?");
        for (int i = 1; i < size; ++i) {
            builder.append(",?");
        }
        return builder.append(")").toString();
    }

    public static String buildClause(String propName, String qcp, Object filterValues, boolean skipNull) {
        if (filterValues != null || !skipNull) {
            return " and " + propName + ' ' + qcp + '?';
        }
        return "";
    }

    public static String buildClause(String propName, String qcp, Object filterValues) {
        return QFilterBuilder.buildClause(propName, qcp, filterValues, false);
    }

    public static String buildClause(String propName, Collection filterValues, boolean skipNull) {
        if (filterValues != null || !skipNull) {
            return " and " + propName + " in " + QFilterBuilder.buildSQLParamHolder(filterValues == null ? 0 : filterValues.size());
        }
        return "";
    }

    public static String buildClause(String propName, Collection filterValues) {
        return QFilterBuilder.buildClause(propName, filterValues, false);
    }

    public static String qfilterToString(QFilter srcFilter) {
        return QFilterBuilder.qfilterToString(srcFilter, true, FIQFilterUtil::parametertoString);
    }

    public static String qfilterToString(QFilter srcFilter, boolean recursive, Function<Object, String> param2StringFnc) {
        StringBuilder s = new StringBuilder(128);
        if (srcFilter.isJoinSQLFilter()) {
            s.append(srcFilter.getProperty());
        } else {
            s.append(srcFilter.getProperty()).append(' ').append(srcFilter.getCP());
            if (srcFilter.isExpressValue()) {
                s.append(srcFilter.getValue());
            } else {
                String lcp = srcFilter.getCP();
                if (!lcp.equalsIgnoreCase("in") && !lcp.equalsIgnoreCase("not in")) {
                    s.append(' ').append(param2StringFnc.apply(srcFilter.getValue()));
                } else {
                    s.append(" (").append(param2StringFnc.apply(srcFilter.getValue())).append(')');
                }
            }
        }
        List nests = srcFilter.getNests(false);
        if (recursive && !nests.isEmpty()) {
            QFilterBuilder.resloveNests(nests, s, nest -> {
                s.append(' ').append(nest.getOp()).append(' ').append(nest.getFilter().__toStringWithParamEncode(param2StringFnc));
                return null;
            });
        }
        return s.toString();
    }

    private static void resloveNests(List<QFilter.QFilterNest> nests, StringBuilder s, Function<QFilter.QFilterNest, Void> nestFun) {
        boolean withOr = false;
        boolean allOr = true;
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                allOr = false;
                continue;
            }
            withOr = true;
        }
        if (withOr) {
            s.insert(0, '(');
        }
        if (allOr) {
            for (QFilter.QFilterNest nest : nests) {
                nestFun.apply(nest);
            }
        } else {
            boolean preIsAnd = true;
            for (QFilter.QFilterNest subNest : nests) {
                boolean and = subNest.isAnd();
                if (!preIsAnd && and) {
                    s.insert(0, '(');
                    s.append(')');
                }
                nestFun.apply(subNest);
                preIsAnd = and;
            }
        }
        if (withOr) {
            s.append(')');
        }
    }

    public int getModifyCnt() {
        return this.modifyCnt;
    }

    public int getDeleteCnt() {
        return this.deleteCnt;
    }

    public QFilter removeFirst() {
        return this.filters.isEmpty() ? null : this.filters.removeFirst();
    }

    public QFilter removeLast() {
        return this.filters.isEmpty() ? null : this.filters.removeLast();
    }

    public boolean isValidFilter() {
        return this.isValidFilter;
    }

    public void setValidFilter(boolean validFilter) {
        this.isValidFilter = validFilter;
    }
}

