/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.expt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bd.accountimport.AccountImportConfig;
import kd.fi.bd.accountimport.AccountImportHelper;
import kd.fi.bd.formplugin.account.expt.EntryCellList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportToColumnHelper {
    private static final String NEW_SHEET_NAME = "new";

    public void entryRowToColumn(File file) {
        try (FileInputStream in = this.getFileInputStream(file);){
            Workbook wb = this.getWorkbook(in);
            Sheet sheet1 = wb.getSheetAt(0);
            Sheet sheet2 = wb.createSheet(NEW_SHEET_NAME);
            this.copyFirstTwoRows(wb, sheet1, sheet2);
            TreeMap<Integer, Tuple<Cell, Cell>> currColumnIdxes = new TreeMap<Integer, Tuple<Cell, Cell>>();
            TreeMap<Integer, Tuple<Cell, Cell>> assistColumnIdxes = new TreeMap<Integer, Tuple<Cell, Cell>>();
            Tuple<Integer, Integer> tuple = this.copyTitleRows(wb, sheet1, sheet2, currColumnIdxes, assistColumnIdxes);
            int maxCommonColumnIdx = (Integer)tuple.item2;
            int numberColIdx = (Integer)tuple.item1;
            if (numberColIdx <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6478\u7248\u6ca1\u6709\u79d1\u76ee\u7f16\u7801\u5217\u3002", (String)"ExportToColumnHelper_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            EntryCellList currEntryCells = new EntryCellList();
            EntryCellList assistEntryCells = new EntryCellList();
            Tuple<Integer, Integer> entrySizes = this.readAndCopyDataRows(wb, sheet1, sheet2, currEntryCells, assistEntryCells, currColumnIdxes, assistColumnIdxes, maxCommonColumnIdx, numberColIdx);
            int maxCurrEntrySize = Math.max((Integer)entrySizes.item1, 1);
            int maxAssistEntrySize = Math.max((Integer)entrySizes.item2, 3);
            int currColumnStart = maxCommonColumnIdx + assistColumnIdxes.size() * maxAssistEntrySize;
            int maxColumnIdx = maxCommonColumnIdx;
            this.appendEntryColumns(wb, sheet2, assistEntryCells, currEntryCells, maxCommonColumnIdx, currColumnStart);
            maxColumnIdx = this.setEntryTitleRows(wb, sheet2, maxColumnIdx, assistColumnIdxes, maxAssistEntrySize);
            maxColumnIdx = this.setEntryTitleRows(wb, sheet2, maxColumnIdx, currColumnIdxes, maxCurrEntrySize);
            this.setColumnStyle(sheet1, sheet2, maxColumnIdx);
            this.setColumnValidation(sheet1, sheet2, maxCommonColumnIdx, maxColumnIdx, maxCurrEntrySize, maxAssistEntrySize, currColumnIdxes.navigableKeySet(), assistColumnIdxes.navigableKeySet());
            this.deleteOriSheet(wb);
            this.saveFile(wb, file);
        }
        catch (Throwable e) {
            throw new IllegalStateException("export error.", e);
        }
    }

    private void setColumnValidation(Sheet sheet1, Sheet sheet2, int maxCommonColumnIdx, int maxColumnIdx, int maxCurrEntrySize, int maxAssistEntrySize, NavigableSet<Integer> currIdxItr, NavigableSet<Integer> assistIdxItr) {
        int i;
        ArrayList<DataValidation> currValidations = new ArrayList<DataValidation>(8);
        ArrayList<DataValidation> assistValidations = new ArrayList<DataValidation>(32);
        for (Integer idx : assistIdxItr) {
            assistValidations.add(ExportToColumnHelper.getDataValidationForColumn(sheet1, idx));
        }
        for (Integer idx : currIdxItr) {
            currValidations.add(ExportToColumnHelper.getDataValidationForColumn(sheet1, idx));
        }
        ArrayList<DataValidation> allValidations = new ArrayList<DataValidation>(32);
        for (i = 0; i < maxCurrEntrySize + maxAssistEntrySize; ++i) {
            if (i < maxAssistEntrySize) {
                allValidations.addAll(assistValidations);
                continue;
            }
            allValidations.addAll(currValidations);
        }
        for (i = 0; i < maxColumnIdx; ++i) {
            DataValidation dataValidation = i < maxCommonColumnIdx ? ExportToColumnHelper.getDataValidationForColumn(sheet1, i) : (DataValidation)allValidations.get(i - maxCommonColumnIdx);
            this.copyValidation(sheet2, dataValidation, i);
        }
    }

    private void copyValidation(Sheet sheet2, DataValidation sourceValidation, int sourceColumnIndex) {
        if (sourceValidation != null) {
            DataValidation targetValidation = ExportToColumnHelper.copyDataValidation(sourceValidation, sourceColumnIndex, sheet2);
            sheet2.addValidationData(targetValidation);
        }
    }

    private static DataValidation getDataValidationForColumn(Sheet sheet, int columnIndex) {
        for (DataValidation validation : sheet.getDataValidations()) {
            CellRangeAddressList regions = validation.getRegions();
            for (int i = 0; i < regions.countRanges(); ++i) {
                CellRangeAddress range = regions.getCellRangeAddress(i);
                if (range.getFirstColumn() != columnIndex || range.getLastColumn() != columnIndex) continue;
                return validation;
            }
        }
        return null;
    }

    private static DataValidation copyDataValidation(DataValidation sourceValidation, int targetColumnIndex, Sheet sheet) {
        DataValidationHelper validationHelper = sheet.getDataValidationHelper();
        XSSFDataValidationConstraint constraint = (XSSFDataValidationConstraint)sourceValidation.getValidationConstraint();
        CellRangeAddressList targetRegions = new CellRangeAddressList();
        CellRangeAddressList sourceRegions = sourceValidation.getRegions();
        for (int i = 0; i < sourceRegions.countRanges(); ++i) {
            CellRangeAddress sourceRange = sourceRegions.getCellRangeAddress(i);
            CellRangeAddress targetRange = new CellRangeAddress(sourceRange.getFirstRow(), sourceRange.getLastRow(), targetColumnIndex, targetColumnIndex);
            targetRegions.addCellRangeAddress(targetRange);
        }
        XSSFDataValidation targetValidation = (XSSFDataValidation)validationHelper.createValidation((DataValidationConstraint)constraint, targetRegions);
        targetValidation.createErrorBox(sourceValidation.getErrorBoxTitle(), sourceValidation.getErrorBoxText());
        targetValidation.createPromptBox(sourceValidation.getPromptBoxTitle(), sourceValidation.getPromptBoxText());
        targetValidation.setShowErrorBox(sourceValidation.getShowErrorBox());
        targetValidation.setShowPromptBox(sourceValidation.getShowPromptBox());
        return targetValidation;
    }

    private Tuple<Integer, Integer> readAndCopyDataRows(Workbook wb, Sheet sheet1, Sheet sheet2, EntryCellList currEntryCells, EntryCellList assistEntryCells, Map<Integer, Tuple<Cell, Cell>> currColumnIdxes, Map<Integer, Tuple<Cell, Cell>> assistColumnIdxes, int maxCommonColumnIdx, int numberColIdx) {
        HashSet<Integer> entryColumnIdxes = new HashSet<Integer>(currColumnIdxes.keySet());
        entryColumnIdxes.addAll(assistColumnIdxes.keySet());
        ArrayList<Cell> currCells = new ArrayList<Cell>(4);
        ArrayList<Cell> assistCells = new ArrayList<Cell>(8);
        int maxCurrEntrySize = 0;
        int maxAssistEntrySize = 0;
        Row preEntityRow = null;
        int[] cursor = new int[]{0, 0};
        String acctNumber = "";
        for (Row oldRow : sheet1) {
            if (cursor[0] < 4) {
                cursor[0] = cursor[0] + 1;
                cursor[1] = cursor[1] + 1;
                continue;
            }
            if (oldRow.getCell(numberColIdx) != null && !acctNumber.equalsIgnoreCase(oldRow.getCell(numberColIdx).getStringCellValue())) {
                Row newRow = this.createAndCopyRow(oldRow, wb, sheet2, cursor[1]);
                acctNumber = oldRow.getCell(numberColIdx).getStringCellValue();
                newRow.setRowNum(cursor[1]);
                if (preEntityRow != null) {
                    maxCurrEntrySize = Math.max(maxCurrEntrySize, currCells.size() / currColumnIdxes.size());
                    maxAssistEntrySize = Math.max(maxAssistEntrySize, assistCells.size() / assistColumnIdxes.size());
                    assistEntryCells.addCells(assistCells);
                    currEntryCells.addCells(currCells);
                    assistCells.clear();
                    currCells.clear();
                }
                int maxIdx = maxCommonColumnIdx + currColumnIdxes.size() + assistColumnIdxes.size();
                int i = 0;
                int j = 0;
                while (i <= maxIdx) {
                    Cell cell2 = oldRow.getCell(i);
                    if (cell2 != null) {
                        int columnIndex = cell2.getColumnIndex();
                        if (entryColumnIdxes.contains(columnIndex)) {
                            this.addEntryCell(cell2, currColumnIdxes, assistColumnIdxes, currCells, assistCells);
                        } else {
                            this.createAndCopyCell(wb, cell2, newRow, j);
                        }
                    }
                    ++i;
                    ++j;
                }
                preEntityRow = newRow;
                cursor[1] = cursor[1] + 1;
            } else {
                oldRow.cellIterator().forEachRemaining(cell -> this.addEntryCell((Cell)cell, currColumnIdxes, assistColumnIdxes, (List<Cell>)currCells, (List<Cell>)assistCells));
            }
            cursor[0] = cursor[0] + 1;
        }
        if (preEntityRow != null) {
            maxCurrEntrySize = Math.max(maxCurrEntrySize, currCells.size() / currColumnIdxes.size());
            maxAssistEntrySize = Math.max(maxAssistEntrySize, assistCells.size() / assistColumnIdxes.size());
            assistEntryCells.addCells(assistCells);
            currEntryCells.addCells(currCells);
        }
        return new Tuple((Object)maxCurrEntrySize, (Object)maxAssistEntrySize);
    }

    private Workbook getWorkbook(FileInputStream in) throws IOException {
        return new XSSFWorkbook((InputStream)in);
    }

    private void deleteOriSheet(Workbook wb) {
        if (AccountImportConfig.EXPORT_DELETE_ORI_SHEET.getBoolean()) {
            String sheetName = wb.getSheetAt(0).getSheetName();
            wb.removeSheetAt(0);
            wb.setSheetOrder(NEW_SHEET_NAME, 0);
            wb.setSheetName(0, sheetName);
            wb.setSheetHidden(1, true);
            wb.setActiveSheet(0);
        }
    }

    private void appendEntryColumns(Workbook wb, Sheet sheet2, EntryCellList assistEntryCells, EntryCellList currEntryCells, int assistColumnStart, int currColumnStart) {
        Iterator firstRowItr = wb.getSheetAt(0).getRow(0).cellIterator();
        firstRowItr.next();
        Row newRow = sheet2.getRow(0);
        Cell entryTagCell1 = (Cell)firstRowItr.next();
        Cell entryTagCell2 = (Cell)firstRowItr.next();
        if (entryTagCell1.getStringCellValue().contains("checkitementry")) {
            this.createAndCopyCell(wb, entryTagCell1, newRow, assistColumnStart);
            this.createAndCopyCell(wb, entryTagCell2, newRow, currColumnStart);
        } else {
            this.createAndCopyCell(wb, entryTagCell1, newRow, currColumnStart);
            this.createAndCopyCell(wb, entryTagCell2, newRow, assistColumnStart);
        }
        for (int i = 0; i < assistEntryCells.getEntryCells().size(); ++i) {
            Row row = sheet2.getRow(4 + i);
            this.setEntryRows(wb, row, assistEntryCells.getEntryCells().get(i), assistColumnStart);
            this.setEntryRows(wb, row, currEntryCells.getEntryCells().get(i), currColumnStart);
        }
    }

    private FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private void saveFile(Workbook wb, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        wb.write((OutputStream)out);
        wb.close();
        out.close();
    }

    private void setColumnStyle(Sheet sheet1, Sheet sheet2, int maxCommonColumnIdx) {
        for (int j = 0; j < maxCommonColumnIdx; ++j) {
            if (j == 0) {
                sheet2.setColumnWidth(0, 12800);
                continue;
            }
            sheet2.autoSizeColumn(j);
        }
    }

    private int setEntryTitleRows(Workbook wb, Sheet sheet2, int maxCommonColumnIdx, Map<Integer, Tuple<Cell, Cell>> assistColumnIdxes, int maxAssistEntrySize) {
        Row numRow = sheet2.getRow(2);
        Row nameRow = sheet2.getRow(3);
        AtomicInteger columnIdx = new AtomicInteger(maxCommonColumnIdx);
        for (int k = 0; k < maxAssistEntrySize; ++k) {
            assistColumnIdxes.forEach((x, numAndName) -> {
                this.createAndCopyCell(wb, (Cell)numAndName.item1, numRow, columnIdx.get());
                this.createAndCopyCell(wb, (Cell)numAndName.item2, nameRow, columnIdx.getAndIncrement());
            });
        }
        return columnIdx.get();
    }

    private void addEntryCell(Cell cell, Map<Integer, Tuple<Cell, Cell>> currColumnIdxes, Map<Integer, Tuple<Cell, Cell>> assistColumnIdxes, List<Cell> currCells, List<Cell> assistCells) {
        int columnIndex = cell.getColumnIndex();
        if (currColumnIdxes.containsKey(columnIndex)) {
            currCells.add(cell);
        } else if (assistColumnIdxes.containsKey(columnIndex)) {
            assistCells.add(cell);
        }
    }

    private void setEntryRows(Workbook wb, Row preEntityRow, List<Cell> assistCells, int columnStartIdx) {
        for (int j = 0; j < assistCells.size(); ++j) {
            this.createAndCopyCell(wb, assistCells.get(j), preEntityRow, columnStartIdx + j);
        }
        assistCells.clear();
    }

    private Tuple<Integer, Integer> copyTitleRows(Workbook wb, Sheet sheet1, Sheet sheet2, Map<Integer, Tuple<Cell, Cell>> currColumnIdxes, Map<Integer, Tuple<Cell, Cell>> assistColumnIdxes) {
        Set currEntryKeys = AccountImportHelper.getCurrEntryKeys();
        Set assistEntryKeys = AccountImportHelper.getAssistEntryKeys();
        Row newNumRow = sheet2.createRow(2);
        Row newNameRow = sheet2.createRow(3);
        Row numRow = sheet1.getRow(2);
        Row nameRow = sheet1.getRow(3);
        newNumRow.setRowStyle(wb.createCellStyle());
        newNameRow.setRowStyle(wb.createCellStyle());
        this.copyRow(numRow, newNumRow);
        this.copyRow(nameRow, newNameRow);
        newNumRow.setHeightInPoints(15.0f);
        newNameRow.setHeightInPoints(15.0f);
        AtomicInteger j = new AtomicInteger();
        int[] numberColIdx = new int[1];
        numRow.cellIterator().forEachRemaining(cell -> {
            String cellVal = cell.getStringCellValue();
            int columnIndex = cell.getColumnIndex();
            if ("number".equals(cellVal)) {
                numberColIdx[0] = columnIndex;
            }
            if (currEntryKeys.contains(cellVal)) {
                currColumnIdxes.put(columnIndex, new Tuple(cell, (Object)nameRow.getCell(columnIndex)));
            } else if (assistEntryKeys.contains(cellVal)) {
                assistColumnIdxes.put(columnIndex, new Tuple(cell, (Object)nameRow.getCell(columnIndex)));
            } else {
                this.createAndCopyCell(wb, (Cell)cell, newNumRow, j.get());
                this.createAndCopyCell(wb, nameRow.getCell(columnIndex), newNameRow, j.getAndIncrement());
            }
        });
        return new Tuple((Object)numberColIdx[0], (Object)j.get());
    }

    private void copyFirstTwoRows(Workbook wb, Sheet sheet1, Sheet sheet2) {
        Row oldRow1 = sheet1.getRow(0);
        Row oldRow2 = sheet1.getRow(1);
        Row newRow1 = sheet2.createRow(0);
        Row newRow2 = sheet2.createRow(1);
        newRow1.setRowStyle(wb.createCellStyle());
        newRow2.setRowStyle(wb.createCellStyle());
        this.copyRow(oldRow1, newRow1);
        this.copyRow(oldRow2, newRow2);
        newRow2.setHeightInPoints(120.0f);
        this.createAndCopyCell(wb, oldRow1.getCell(0), newRow1, 0);
        this.createAndCopyCell(wb, oldRow2.getCell(0), newRow2, 0);
    }

    private void createAndCopyCell(Workbook wb, Cell from, Row row, int copyIdx) {
        Cell cell = row.createCell(copyIdx);
        this.copyCell(wb, from, cell);
    }

    private void copyCell(Workbook wb, Cell from, Cell to) {
        if (from == null) {
            return;
        }
        if (from.getRow().getRowNum() < 5 && from.getCellStyle() != null) {
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.cloneStyleFrom(from.getCellStyle());
            to.setCellStyle(cellStyle);
        }
        to.setCellValue(from.getStringCellValue());
        if (from.getCellComment() != null) {
            this.copyComment(wb, from, to);
        }
    }

    private void copyComment(Workbook wb, Cell from, Cell to) {
        ClientAnchor anchor = wb.getCreationHelper().createClientAnchor();
        Comment oldCellComment = from.getCellComment();
        int columnIndex = to.getColumnIndex();
        int rowIndex = to.getRow().getRowNum();
        anchor.setCol1(columnIndex);
        anchor.setRow1(rowIndex);
        anchor.setCol2(columnIndex + 2);
        anchor.setRow2(rowIndex + 2);
        Comment cellComment = to.getSheet().createDrawingPatriarch().createCellComment(anchor);
        cellComment.setAddress(rowIndex, columnIndex);
        cellComment.setString(oldCellComment.getString());
        to.setCellComment(cellComment);
    }

    private Row createAndCopyRow(Row oldRow, Workbook wb, Sheet sheet2, int createAt) {
        Row newRow = sheet2.createRow(createAt);
        newRow.setRowStyle(wb.createCellStyle());
        this.copyRow(oldRow, newRow);
        return newRow;
    }

    private void copyRow(Row from, Row to) {
        to.setHeight(from.getHeight());
        to.setRowNum(from.getRowNum());
        if (to.getRowStyle() != null && from.getRowStyle() != null) {
            to.getRowStyle().cloneStyleFrom(from.getRowStyle());
        }
        to.setHeightInPoints(25.0f);
    }
}

