/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import org.xml.sax.SAXException;

class AccountBatchImportSheetHandler
extends SheetHandler {
    private static final Log LOGGER = LogFactory.getLog(AccountBatchImportSheetHandler.class);
    private String PREFIX_LOG = "AccountBatchImportSheetHandler_";
    private String url;
    private ImportContext ctx;
    private MainEntityType mainEntityType;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private ImportLogger logger;
    private Map<Integer, String> nameRow;
    private ImportEntityMapping entityMapping;
    private int dataIndex = 0;
    private int startRowNum = 0;
    private int lastStartRowNum = 0;
    private int startEntryRowNum = 0;
    private boolean errorData = false;
    private boolean isNewFormat = true;
    private boolean hasErrorCol;
    private JSONObject data;
    LinkedHashMap<Integer, Set<Integer>> forceInjectedAsstactitemColsMap = new LinkedHashMap(16);
    LinkedHashMap<Integer, Set<Integer>> forceInjectedCurrencyColsMap = new LinkedHashMap(16);
    private SheetHandler.ParsedRow currentRow;
    private Map<String, Object> option = new HashMap<String, Object>(16);
    private HeartBeat heartbeat;

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public AccountBatchImportSheetHandler(ImportContext ctx, MainEntityType mainEntityType, String url, Map<String, Object> option, HeartBeat heartbeat) {
        this.ctx = ctx;
        this.url = url;
        this.mainEntityType = mainEntityType;
        this.dataQueue = ctx.getDataQueue(url);
        this.logger = ctx.getLogger(url);
        this.option = option;
        this.heartbeat = heartbeat;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        if (this.heartbeat != null) {
            this.heartbeat.refresh();
        }
        int currRowNum = row.getRowNum();
        this.logger.setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.logger.setLastRowIndex(this.getRowCount());
            if (row.isEmpty()) {
                return;
            }
            String entityName = row.get(Integer.valueOf(0));
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = row.get(Integer.valueOf(1));
                this.hasErrorCol = true;
            }
            if (entityName == null || !entityName.contains(" # ") || !this.mainEntityType.getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
                this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
                this.ctx.setResolveComplete(this.url);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u6570\u636e\uff1a%s", (String)"AccountBatchImportPlugin_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), entityName));
            }
        }
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.initForceColumns(this.nameRow);
            this.isNewFormat = !this.nameRow.get(this.hasErrorCol ? 1 : 0).contains(" # ");
            this.ctx.setNewFormat(this.isNewFormat);
        }
        if (currRowNum >= 2) {
            if (this.isNewFormat) {
                this.buildBill(row);
            } else {
                this.buildBillOld(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBill(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 3) {
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow, (Map)row.getData(), this.option);
        } else if (currRowNum > 3) {
            try {
                if (!this.entityMapping.isSameOne(this.currentRow, row.getData()) ? !this.addNewBillData(row) : this.ctx.isBatchByEntry() && currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize() && !this.addNewEntryBatch(row)) {
                    return;
                }
                if (row.isEmpty()) {
                    return;
                }
                List errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject());
                if (this.data != null) {
                    JSONArray checkitementry = (JSONArray)this.data.get((Object)"checkitementry");
                    boolean isAsstactitemEntryFirst = true;
                    for (Map.Entry<Integer, Set<Integer>> entry : this.forceInjectedAsstactitemColsMap.entrySet()) {
                        boolean isAddNew = false;
                        JSONObject entryRow = null;
                        if (isAsstactitemEntryFirst && checkitementry.size() > 0) {
                            entryRow = checkitementry.getJSONObject(checkitementry.size() - 1);
                        } else {
                            isAddNew = true;
                            entryRow = new JSONObject();
                        }
                        isAsstactitemEntryFirst = false;
                        Set<Integer> value = entry.getValue();
                        boolean isNull = false;
                        for (Integer colIndex : value) {
                            String cellValue = row.get(colIndex);
                            String colName = this.nameRow.get(colIndex);
                            if (cellValue == null) {
                                if (!"asstactitem.number".equals(colName)) continue;
                                isNull = true;
                                continue;
                            }
                            if ("asstactitem.number".equals(colName) || "asstactitem.name".equals(colName)) {
                                JSONObject asstactitemJson = null;
                                Object asstactitem = entryRow.get((Object)"asstactitem");
                                asstactitemJson = asstactitem == null ? new JSONObject() : (asstactitem instanceof JSONObject ? (JSONObject)asstactitem : new JSONObject());
                                asstactitemJson.getInnerMap().put(colName.substring("asstactitem".length() + 1), cellValue);
                                entryRow.getInnerMap().put("asstactitem", asstactitemJson);
                                continue;
                            }
                            entryRow.getInnerMap().put(colName, cellValue);
                        }
                        if (isAddNew && !isNull) {
                            checkitementry.add((Object)entryRow);
                        }
                        if (checkitementry.size() <= 0) continue;
                        this.data.put("checkitementry", (Object)checkitementry);
                    }
                    if (DebugTrace.enable()) {
                        LOGGER.info(this.PREFIX_LOG + "checkitementry", (Object)checkitementry.toJSONString());
                    }
                    JSONArray currencyentry = (JSONArray)this.data.get((Object)"currencyentry");
                    boolean isCurrencyEntryFirst = true;
                    for (Map.Entry<Integer, Set<Integer>> entry : this.forceInjectedCurrencyColsMap.entrySet()) {
                        boolean isAddNew = false;
                        JSONObject entryRow = null;
                        if (isCurrencyEntryFirst && currencyentry.size() > 0) {
                            entryRow = currencyentry.getJSONObject(currencyentry.size() - 1);
                        } else {
                            isAddNew = true;
                            entryRow = new JSONObject();
                        }
                        isCurrencyEntryFirst = false;
                        Set<Integer> value = entry.getValue();
                        boolean isNull = false;
                        for (Integer colIndex : value) {
                            String cellValue = row.get(colIndex);
                            String colName = this.nameRow.get(colIndex);
                            if (cellValue == null) {
                                if (!"currency.number".equals(colName)) continue;
                                isNull = true;
                                continue;
                            }
                            if ("currency.number".equals(colName) || "currency.name".equals(colName)) {
                                JSONObject itemJson = null;
                                Object asstactitem = entryRow.get((Object)"currency");
                                itemJson = asstactitem == null ? new JSONObject() : (asstactitem instanceof JSONObject ? (JSONObject)asstactitem : new JSONObject());
                                itemJson.getInnerMap().put(colName.substring("currency".length() + 1), cellValue);
                                entryRow.getInnerMap().put("currency", itemJson);
                                continue;
                            }
                            entryRow.getInnerMap().put(colName, cellValue);
                        }
                        if (isAddNew && !isNull) {
                            currencyentry.add((Object)entryRow);
                        }
                        if (currencyentry.size() <= 0) continue;
                        this.data.put("currencyentry", (Object)currencyentry);
                    }
                }
                if (!errMsg.isEmpty()) {
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"; ", errMsg) + ";");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    private boolean addNewEntryBatch(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        JSONObject lastData = this.data;
        if (this.data != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                this.addBillData(billData);
            }
            this.errorData = false;
        }
        this.data = new JSONObject();
        if (lastData != null) {
            for (Map.Entry fieldItem : lastData.entrySet()) {
                if (fieldItem.getValue() instanceof JSONArray) continue;
                this.data.put((String)fieldItem.getKey(), fieldItem.getValue());
            }
        }
        this.startEntryRowNum = currRowNum;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBillOld(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.initForceColumns(this.nameRow);
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow);
        } else if (currRowNum > 2) {
            try {
                List errMsg;
                if (!this.entityMapping.isSameOne(this.currentRow, row.getData())) {
                    if (!this.addNewBillData(row)) {
                        return;
                    }
                } else if (!this.ctx.isBatchByEntry() || currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize()) {
                    // empty if block
                }
                if (!(errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject())).isEmpty()) {
                    if (!this.errorData) {
                        // empty if block
                    }
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"; ", errMsg) + ";");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    private boolean addNewBillData(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (this.entityMapping.isEntityEmpty(row.getData())) {
            return false;
        }
        if (this.data != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                this.addBillData(billData);
            }
            this.errorData = false;
            ++this.dataIndex;
        }
        this.data = new JSONObject();
        this.startRowNum = currRowNum;
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private void addBillData(ImportBillData billData) {
        block8: {
            block7: {
                try {
                    if (!this.dataQueue.offer(billData, 10L, TimeUnit.MINUTES)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"AccountBatchImportPlugin_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    throw new KDBizException(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"ImportSheetHandler_2", (String)"bos-form-business", (Object[])new Object[0]));
                }
                if (this.lastStartRowNum == 0) break block7;
                if (billData.getEndIndex() - this.lastStartRowNum < 1000) break block8;
            }
            this.ctx.feedbackProgress(0, this.logger, null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            ImportBillData lastBillData;
            int currRowNum = this.currentRow.getRowNum();
            if (this.errorData) {
                this.logger.fail().tick();
                lastBillData = new ImportBillData(new JSONObject(), this.startRowNum, currRowNum);
            } else {
                lastBillData = new ImportBillData(this.data, this.startRowNum, currRowNum, this.entityMapping);
            }
            lastBillData.setDataIndex(this.dataIndex);
            lastBillData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
            this.addBillData(lastBillData);
        }
        this.ctx.setResolveComplete(this.url);
    }

    private void initForceColumns(Map<Integer, String> nameRow) {
        if (Objects.nonNull(nameRow) && !nameRow.isEmpty()) {
            nameRow.forEach((index, colName) -> {
                if (StringUtils.isNotEmpty((CharSequence)colName)) {
                    if ("checkitementry_id".equals(colName)) {
                        this.forceInjectedAsstactitemColsMap.computeIfAbsent((Integer)index, k -> new HashSet(10)).add(index);
                    } else if ("asstactitem.number".equals(colName)) {
                        this.forceInjectedAsstactitemColsMap.computeIfAbsent(index - 1, k -> new HashSet(10)).add(index);
                    } else if ("asstactitem.name".equals(colName)) {
                        this.forceInjectedAsstactitemColsMap.computeIfAbsent(index - 2, k -> new HashSet(10)).add(index);
                    } else if ("isrequire".equals(colName)) {
                        this.forceInjectedAsstactitemColsMap.computeIfAbsent(index - 3, k -> new HashSet(10)).add(index);
                    } else if ("isdetail".equals(colName)) {
                        this.forceInjectedAsstactitemColsMap.computeIfAbsent(index - 4, k -> new HashSet(10)).add(index);
                    } else if ("enaccheck".equals(colName)) {
                        this.forceInjectedAsstactitemColsMap.computeIfAbsent(index - 5, k -> new HashSet(10)).add(index);
                    } else if ("currency.number".equals(colName)) {
                        this.forceInjectedCurrencyColsMap.computeIfAbsent((Integer)index, k -> new HashSet(10)).add(index);
                    } else if ("currency.name".equals(colName)) {
                        this.forceInjectedCurrencyColsMap.computeIfAbsent(index - 1, k -> new HashSet(10)).add(index);
                    }
                }
            });
        }
    }
}

