/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.form.plugin.bdctrl.BaseDataDeletePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefServiceParam;
import kd.fi.bd.opplugin.AccountviewDeleteValidator;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BillParamUtil;

public class AccountViewDeletePlugin
extends BaseDataDeletePlugin {
    public void onAddValidators(AddValidatorsEventArgs e) {
        String appendIds = BillParamUtil.getStringValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.delete.ignorerefentityids", (String)"gl_voucher");
        Set<String> ignorerefSet = this.getIgnoreref();
        Collections.addAll(ignorerefSet, appendIds.split(","));
        appendIds = String.join((CharSequence)",", ignorerefSet);
        this.getOption().setVariableValue("ignorerefentityids", appendIds);
        super.onAddValidators(e);
        e.getValidators().add(new AccountviewDeleteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("accounttable");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("level");
        e.getFieldKeys().add("startdate");
        e.getFieldKeys().add("enddate");
        e.getFieldKeys().add("ctrlstrategy");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        HashMap<Long, Map> orgMasteridMap = new HashMap<Long, Map>();
        HashMap<Long, Map> orgTableAcctMasterIdIdMap = new HashMap<Long, Map>();
        for (DynamicObject account : e.getDataEntities()) {
            Date startDate = account.getDate("startdate");
            if (0 == AccountVersionUtil.compareDate((Date)startDate, (Date)AccountVersionUtil.getInitBeginDate())) continue;
            DynamicObject createOrg = account.getDynamicObject("createorg");
            long createOrgId = createOrg.getLong("id");
            long masterId = account.getLong("masterid");
            Map masterIdMap = orgMasteridMap.computeIfAbsent(createOrgId, k -> new HashMap());
            masterIdMap.put(masterId, startDate);
            Map tableAcctMap = orgTableAcctMasterIdIdMap.computeIfAbsent(createOrgId, k -> new HashMap());
            long tableId = account.getLong("accounttable_id");
            Map acctIds = tableAcctMap.computeIfAbsent(tableId, k -> new HashMap());
            acctIds.put(masterId, account.getLong("id"));
        }
        HashMap<String, AccountTableRefServiceParam> paramMap = new HashMap<String, AccountTableRefServiceParam>();
        for (Map.Entry entry : orgMasteridMap.entrySet()) {
            long orgId = (Long)entry.getKey();
            QFilter qorg = new QFilter("createorg", "=", (Object)orgId);
            Map masterIdMap = (Map)entry.getValue();
            if (masterIdMap.isEmpty()) continue;
            Map tableAcctMap = (Map)orgTableAcctMasterIdIdMap.get(orgId);
            QFilter qmasterid = new QFilter("masterid", "in", masterIdMap.keySet());
            DynamicObject[] accts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,masterid,enddate,accounttable", (QFilter[])new QFilter[]{qorg, qmasterid});
            ArrayList<DynamicObject> needUpdateAccts = new ArrayList<DynamicObject>(accts.length);
            for (DynamicObject acct : accts) {
                long masterId;
                Date endDate = acct.getDate("enddate");
                if (!endDate.equals(masterIdMap.get(masterId = acct.getLong("masterid")))) continue;
                acct.set("enddate", (Object)AccountVersionUtil.getEndDate());
                needUpdateAccts.add(acct);
                long tableId = acct.getLong("accounttable_id");
                String key = AccountVersionUtil.getRefServiceKey((long)orgId, (long)tableId, (Date)endDate);
                AccountTableRefServiceParam param = paramMap.computeIfAbsent(key, k -> new AccountTableRefServiceParam(orgId, tableId, endDate, new AccountTableRef(tableId, tableId, new AccountRef())));
                Map acctIds = (Map)tableAcctMap.get(tableId);
                if (acctIds == null) continue;
                param.getAccountTableRef().getAccountRef().addAccountRef(Long.valueOf(acct.getLong("id")), (Long)acctIds.get(masterId), new HashMap());
            }
            if (needUpdateAccts.isEmpty()) continue;
            SaveServiceHelper.save((DynamicObject[])needUpdateAccts.toArray(new DynamicObject[0]));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    private Set<String> getIgnoreref() {
        Object row2;
        HashSet<String> ignorerefSet = new HashSet<String>(20);
        ignorerefSet.add("gl_voucher");
        ignorerefSet.add("gl_voucher_ajust");
        ignorerefSet.add("gl_voucher_cashflowedit");
        ignorerefSet.add("gl_voucher_ref");
        ignorerefSet.add("gl_balance");
        ignorerefSet.add("gl_balance_log");
        ignorerefSet.add("gl_initbalance");
        ignorerefSet.add("gl_initacccurrent");
        ignorerefSet.add("gl_acnotice");
        ignorerefSet.add("gl_acccurrent");
        ignorerefSet.add("gl_presetcashflowitem");
        ignorerefSet.add("ai_bizvoucher");
        ignorerefSet.add("pa_aiprofile");
        ignorerefSet.add("pa_aiprofilewt");
        ignorerefSet.add("gl_acctbalance");
        String ignorerefentitycheck = BillParamUtil.getStringValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.delete.ignorerefentitycheck", (String)"check");
        if (!ignorerefentitycheck.equals("check")) {
            return ignorerefSet;
        }
        SqlBuilder allOutFiEntityIdSql = new SqlBuilder();
        allOutFiEntityIdSql.append("select distinct re.fobjecttypeid", new Object[0]);
        allOutFiEntityIdSql.append("from t_meta_objecttyperef as re", new Object[0]);
        allOutFiEntityIdSql.append("inner join T_META_BIZUNITRELFORM as bf on bf.fformid =re.fentityid", new Object[0]);
        allOutFiEntityIdSql.append("inner join t_meta_bizapp as bizapp on bizapp.fid=bf.fbizappid", new Object[0]);
        allOutFiEntityIdSql.append("inner join t_meta_bizcloud as bizcloud on bizapp.fbizcloudid=bizcloud.fid", new Object[0]);
        allOutFiEntityIdSql.append("WHERE re.frefobjecttypeid='bd_accountview'", new Object[0]);
        allOutFiEntityIdSql.append("and bizcloud.fnumber != 'FI'", new Object[0]);
        allOutFiEntityIdSql.append("and re.ftablename != ''", new Object[0]);
        allOutFiEntityIdSql.append("and re.ftablename != ' '", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"AccountViewDeletePlugin", (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)allOutFiEntityIdSql);){
            for (Object row2 : dataSet) {
                ignorerefSet.add(row2.getString("fobjecttypeid"));
            }
        }
        HashSet<String> ignorerefTablename = new HashSet<String>(20);
        SqlBuilder findTableName = new SqlBuilder();
        findTableName.appendIn("select distinct ftablename from t_meta_entityinfo where fid", new ArrayList<String>(ignorerefSet));
        DataSet dataSet = DB.queryDataSet((String)"AccountViewDeletePlugin", (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)findTableName);
        row2 = null;
        try {
            for (Row row3 : dataSet) {
                ignorerefTablename.add(row3.getString("ftablename"));
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (row2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (ignorerefTablename.size() > 0) {
            SqlBuilder sb = new SqlBuilder();
            sb.append("select distinct fobjecttypeid", new Object[0]);
            sb.append("from t_meta_objecttyperef", new Object[0]);
            sb.append("WHERE frefobjecttypeid ='bd_accountview' ", new Object[0]);
            sb.appendIn("and ftablename", new ArrayList(ignorerefTablename));
            DataSet dataSet2 = DB.queryDataSet((String)"AccountViewDeletePlugin", (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)sb);
            Object object = null;
            try {
                for (Row row4 : dataSet2) {
                    ignorerefSet.add(row4.getString("fobjecttypeid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet2 != null) {
                    if (object != null) {
                        try {
                            dataSet2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet2.close();
                    }
                }
            }
        }
        return ignorerefSet;
    }
}

