/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bd.accountimport.AccountImportConfig;
import kd.fi.bd.opplugin.accountimport.ColumnImportSheetHandler;

public class AccImportByColumnHelper {
    private MainEntityType assTactType;
    private MainEntityType currType;

    public MainEntityType getImportEntityType(MainEntityType entityType) {
        MainEntityType accImportCloneType = this.getAccImportCloneType(entityType);
        List<DynamicProperty> columnProps = this.getColumnProps();
        columnProps.forEach(arg_0 -> ((MainEntityType)accImportCloneType).addProperty(arg_0));
        return accImportCloneType;
    }

    MainEntityType getAssTactType() {
        if (this.assTactType == null) {
            this.assTactType = MetadataServiceHelper.getDataEntityType((String)"bd_asstacttype");
        }
        return this.assTactType;
    }

    MainEntityType getCurrType() {
        if (this.currType == null) {
            this.currType = MetadataServiceHelper.getDataEntityType((String)"bd_currency");
        }
        return this.currType;
    }

    List<DynamicProperty> getColumnProps() {
        List<DynamicProperty> assistProps = this.getColumnProps(this::getAssistColumnProps, this.getAssistEntrySize());
        List<DynamicProperty> currProps = this.getColumnProps(this::getCurrColumnProps, this.getCurrEntrySize());
        ArrayList<DynamicProperty> props = new ArrayList<DynamicProperty>(assistProps);
        props.addAll(currProps);
        return props;
    }

    List<DynamicProperty> getAssistColumnProps(int index) {
        ArrayList<DynamicProperty> list = new ArrayList<DynamicProperty>();
        BasedataProp assistItermProp = new BasedataProp();
        String suffix = "_" + index;
        assistItermProp.setName("asstactitem" + suffix);
        assistItermProp.setComplexType((IDataEntityType)this.getAssTactType());
        list.add((DynamicProperty)assistItermProp);
        BooleanProp enAccCheck = new BooleanProp();
        enAccCheck.setName("enaccheck" + suffix);
        enAccCheck.setDefValue((Object)false);
        list.add((DynamicProperty)enAccCheck);
        BooleanProp isDetail = new BooleanProp();
        isDetail.setName("isdetail" + suffix);
        isDetail.setDefValue((Object)false);
        list.add((DynamicProperty)isDetail);
        BooleanProp isRequire = new BooleanProp();
        isRequire.setName("isrequire" + suffix);
        isRequire.setDefValue((Object)false);
        list.add((DynamicProperty)isRequire);
        LongProp entryId = new LongProp();
        entryId.setName("checkitementry_id" + suffix);
        list.add((DynamicProperty)entryId);
        return list;
    }

    List<DynamicProperty> getCurrColumnProps(int index) {
        ArrayList<DynamicProperty> list = new ArrayList<DynamicProperty>();
        String suffix = "_" + index;
        BasedataProp prop = new BasedataProp();
        prop.setName("currency" + suffix);
        prop.setComplexType((IDataEntityType)this.getCurrType());
        list.add((DynamicProperty)prop);
        LongProp entryId = new LongProp();
        entryId.setName("currencyentry_id" + suffix);
        list.add((DynamicProperty)entryId);
        return list;
    }

    List<DynamicProperty> getColumnProps(Function<Integer, List<DynamicProperty>> propsGetter, int size) {
        return IntStream.range(0, size).boxed().map(propsGetter).reduce((x1, x2) -> {
            ArrayList list = new ArrayList(x1);
            list.addAll(x2);
            return list;
        }).orElseGet(ArrayList::new);
    }

    MainEntityType getAccImportCloneType(MainEntityType entityType) {
        try {
            if (entityType == null) {
                entityType = MetadataServiceHelper.getDataEntityType((String)"bd_accountview");
            }
            entityType = (MainEntityType)entityType.clone();
            entityType.clearRefEntityTypeVer();
            entityType.clearSubEntityTypecache();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        return entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveExcel(ImportContext ctx, Log log, MainEntityType mainEntityType) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        for (String url : ctx.getAllUrls()) {
            HeartBeat heartbeat = new HeartBeat();
            ctx.getImportMonitor().addImportLog(ResManager.loadKDString((String)"\u5f00\u59cb\u89e3\u6790excel\u6570\u636e", (String)"BatchImportPlugin_11", (String)"bos-import", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6587\u4ef6url\u4e3a\uff1a%s", (String)"BatchImportPlugin_12", (String)"bos-import", (Object[])new Object[]{url}));
            try {
                InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, service.getInputStream(url));
                Throwable throwable = null;
                try {
                    Map option = ctx.getOption();
                    reader.read(in, (SheetHandler)new ColumnImportSheetHandler(ctx, mainEntityType, url, option, heartbeat));
                }
                catch (Throwable option) {
                    throwable = option;
                    throw option;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable option) {
                            throwable.addSuppressed(option);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                log.error(e);
                Throwable cause = e.getCause();
                String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"BatchImportPlugin_1", (String)"bos-import", (Object[])new Object[0]);
                ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            }
            finally {
                ctx.setResolveComplete(url);
            }
        }
    }

    public void transColumn2Entry(List<ImportBillData> rowdatas) {
        for (ImportBillData rowData : rowdatas) {
            JSONObject data = rowData.getData();
            int rowNum = data.getIntValue("rowNum");
            JSONArray assistEntry = (JSONArray)data.computeIfAbsent((Object)"checkitementry", x -> new JSONArray());
            for (int i = 0; i < this.getAssistEntrySize(); ++i) {
                JSONObject entryData = this.getAssistEntryData(data, i, rowNum);
                if (entryData == null) continue;
                assistEntry.add((Object)entryData);
            }
            JSONArray currEntry = (JSONArray)data.computeIfAbsent((Object)"currencyentry", x -> new JSONArray());
            for (int i = 0; i < this.getCurrEntrySize(); ++i) {
                currEntry.addAll(this.getCurrEntryData(data, i, rowNum));
            }
        }
    }

    private List<JSONObject> getCurrEntryData(JSONObject data, int i, int rowNum) {
        JSONObject currData;
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        String suffix = "_" + i;
        if (data.containsKey((Object)("currency" + suffix)) && (currData = (JSONObject)data.remove((Object)("currency" + suffix))) != null) {
            String number = currData.getString("number");
            String name = currData.getString("name");
            String id = currData.getString("id");
            String eId = Optional.ofNullable(data.remove((Object)("currencyentry_id" + suffix))).map(Object::toString).orElse(null);
            List<Object> numList = new ArrayList<String>();
            List<Object> nameList = new ArrayList<String>();
            List<Object> idList = new ArrayList<String>();
            List<Object> eIdList = new ArrayList<String>();
            String[] numArr = number.split(";");
            if (numArr.length > 1) {
                numList = Arrays.asList(numArr);
                if (name != null) {
                    nameList = Arrays.asList(name.split(";"));
                }
                if (id != null) {
                    idList = Arrays.asList(id.split(";"));
                }
                if (eId != null) {
                    eIdList = Arrays.asList(eId.split(";"));
                }
            } else {
                numList.add(number);
                if (name != null) {
                    nameList.add(name);
                }
                if (id != null) {
                    idList.add(id);
                }
                if (eId != null) {
                    eIdList.add(eId);
                }
            }
            for (int j = 0; j < numList.size(); ++j) {
                JSONObject curr = new JSONObject();
                curr.put("number", numList.get(j));
                if (j < nameList.size()) {
                    curr.put("name", nameList.get(j));
                }
                if (j < idList.size()) {
                    curr.put("id", idList.get(j));
                }
                JSONObject entryData = new JSONObject();
                entryData.put("currency", (Object)curr);
                if (j < eIdList.size()) {
                    entryData.put("id", eIdList.get(j));
                }
                entryData.put("rowNum", (Object)rowNum);
                res.add(entryData);
            }
        }
        return res;
    }

    private JSONObject getAssistEntryData(JSONObject data, int i, int rowNum) {
        String suffix = "_" + i;
        if (data.containsKey((Object)("asstactitem" + suffix))) {
            JSONObject entryData = new JSONObject();
            entryData.put("asstactitem", data.remove((Object)("asstactitem" + suffix)));
            entryData.put("isdetail", data.remove((Object)("isdetail" + suffix)));
            entryData.put("isrequire", data.remove((Object)("isrequire" + suffix)));
            entryData.put("enaccheck", data.remove((Object)("enaccheck" + suffix)));
            entryData.put("id", data.remove((Object)("checkitementry_id" + suffix)));
            entryData.put("rowNum", (Object)rowNum);
            return entryData;
        }
        return null;
    }

    public int getAssistEntrySize() {
        return AccountImportConfig.IMPORT_MAX_ASSIST_ENTRY_SIZE.getInt();
    }

    public int getCurrEntrySize() {
        return AccountImportConfig.IMPORT_MAX_CURR_ENTRY_SIZE.getInt();
    }
}

