/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountimport;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.assign.AssignResult;
import kd.fi.bd.assign.AssignServiceHelper;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.opplugin.accountimport.AccountImportContext;
import kd.fi.bd.opplugin.accountimport.AccountImportUtil;
import kd.fi.bd.opplugin.accountimport.AccountKeyVO;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.OrgVO;
import org.apache.commons.lang3.ObjectUtils;

public class AccountBatchUpdateImportPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AccountBatchUpdateImportPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AccountBatchImportValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            long useOrgId;
            long tableId = dynamicObject.getLong("accounttable_id");
            AccountKeyVO accountKeyVO = new AccountKeyVO(tableId, useOrgId = dynamicObject.getLong("useorg_id"), dynamicObject.getString("number"));
            OperateOption operateOption = (OperateOption)ThreadCache.get((Object)accountKeyVO);
            if (operateOption == null) continue;
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption);
            String validateMsg = BDUtil.buildOperationResultFailedMsg((OperationResult)operationResult, (boolean)true);
            if (!StringUtils.isNotBlank((CharSequence)validateMsg)) continue;
            e.setCancel(true);
            e.setCancelMessage(validateMsg);
        }
    }

    static class AccountBatchImportValidator
    extends AbstractValidator {
        private static final String USED_PROPS = String.join((CharSequence)",", Arrays.asList("id", "number", "name", "accounttable", "accounttype", "accrualdirection", "orgcontrollevel", "isallowca", "ismanual", "createorg", "iscash", "isbank", "iscashequivalent", "acnotice", "ischangecurrency", "isqty", "acctcurrency", "currencyentry", "currencyentry.currency", "dc", "asstactitem", "accounttable", "checkitementry.asstactitem", "checkitementry.isrequire", "checkitementry.isdetail", "checkitementry.enaccheck", "asstactitem.flexfield", "pltype"));
        private Map<Long, Integer> levelMap = new HashMap<Long, Integer>(10);
        private static final String PREFIX_LOG = "AccountBatchImportValidator_";
        private static final List<String> assignAbleCtrl = Arrays.asList("1", "2");

        AccountBatchImportValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            Preconditions.checkArgument((dataEntities.length > 0 ? 1 : 0) != 0);
            AccountImportContext currImportContext = new AccountImportContext(dataEntities);
            String cacheKey = "accountupdateimport_" + RequestContext.get().getGlobalSessionId();
            String importEntryInfo = CacheHelper.getDistributeCache((CacheModule)CacheModule.report).get(cacheKey);
            Map entryInfoObj = null;
            if (StringUtils.isNotBlank((CharSequence)importEntryInfo)) {
                entryInfoObj = (Map)SerializationUtils.fromJsonString((String)importEntryInfo, Map.class);
            }
            if (DebugTrace.enable()) {
                logger.info("AccountBatchImportValidator_requestId: {}; accountImportEntryVo: {}", (Object)cacheKey, (Object)importEntryInfo);
            }
            HashSet<Long> updateImportAccounts = new HashSet<Long>(8);
            HashSet<Long> assignOrgs = new HashSet<Long>(10);
            HashSet<String> assignNumbers = new HashSet<String>(10);
            for (ExtendedDataEntity entry : dataEntities) {
                DynamicObject dynamicObject = entry.getDataEntity();
                long accTableId = currImportContext.getAccTableId();
                long currAccId = dynamicObject.getLong("id");
                this.fixEntry(dynamicObject, entryInfoObj);
                this.setRealLevel(dynamicObject);
                this.setHiddenProperty(dynamicObject);
                long useOrgId = dynamicObject.getLong("useorg_id");
                String number = dynamicObject.getString("number");
                Map<AccountKeyVO, Long> currOrgAccountMap = currImportContext.getCurrOrgAccountMap();
                AccountKeyVO key = new AccountKeyVO(accTableId, useOrgId, number);
                if ("new".equals(this.getOption().getVariableValue("importtype")) && !CollectionUtil.isEmpty(currOrgAccountMap) && null != currOrgAccountMap.get(key)) {
                    String orgNumber = dynamicObject.getDynamicObject("useorg").getString("number");
                    this.addErrorMessage(entry, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u201c%1$s\u201d\u7684\u79d1\u76ee\u5728\u7ec4\u7ec7\u7f16\u7801\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"AccountBatchUpdateImportPlugin_11", (String)"fi-bd-opplugin", (Object[])new Object[0]), number, orgNumber));
                    return;
                }
                updateImportAccounts.add(currAccId);
                Optional<String> checkRes = this.normalCheck(dynamicObject, currImportContext, assignOrgs, assignNumbers);
                if (checkRes.isPresent()) {
                    this.addErrorMessage(entry, checkRes.get());
                    return;
                }
                if (assignNumbers.isEmpty()) continue;
                HashMap orgAccMap = new HashMap(8);
                Map currOrgAccount = AccountImportUtil.getCurrOrgAccount((long)accTableId, assignNumbers, orgAccMap, new HashMap(8));
                currImportContext.getCurrOrgAccountMap().putAll(currOrgAccount);
                for (Map.Entry orgAccountEntry : orgAccMap.entrySet()) {
                    updateImportAccounts.addAll(new HashSet((Collection)orgAccountEntry.getValue()));
                }
            }
            Map<Object, Object> dbDynamicObjectMap = new HashMap<Object, DynamicObject>(8);
            if (!updateImportAccounts.isEmpty()) {
                dbDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])updateImportAccounts.toArray(), (String)"bd_accountview");
                logger.info("AccountBatchImportValidator_dbDynamicObjectMap :", (Object)dbDynamicObjectMap.size());
            }
            this.dealEachAccOp(currImportContext, dataEntities, dbDynamicObjectMap);
            currImportContext.getCurrOrgAccountMap().putAll(currImportContext.getCurrOrgAccountMap());
        }

        private Optional<String> normalCheck(DynamicObject dynamicObject, AccountImportContext currImportContext, Set<Long> assignOrgs, Set<String> assignNumbers) {
            boolean isNewFirstLevelAccount;
            long useOrgId = dynamicObject.getLong("useorg_id");
            List createOrgs = BaseDataServiceHelper.getCreateOrgList((String)"bd_accountview", (String)"fibd");
            if (!createOrgs.contains(useOrgId)) {
                DynamicObject useOrg = dynamicObject.getDynamicObject("useorg");
                OrmLocaleValue orgNameInfo = (OrmLocaleValue)useOrg.get("name");
                String orgName = orgNameInfo.get((Object)"zh_CN");
                return Optional.ofNullable(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7(%s)\u4e0d\u5141\u8bb8\u521b\u5efa\u57fa\u7840\u6570\u636e\u3002", (String)"AccountBatchUpdateImportPlugin_10", (String)"fi-bd-opplugin", (Object[])new Object[0]), orgName));
            }
            String number = dynamicObject.getString("number");
            Map<AccountKeyVO, Long> currOrgAccountMap = currImportContext.getCurrOrgAccountMap();
            DynamicObject parentDy = dynamicObject.getDynamicObject("parent");
            if (dynamicObject.getInt("level") != 1 && parentDy == null) {
                DynamicObject createOrg = dynamicObject.getDynamicObject("createorg");
                return Optional.ofNullable(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%1$s(%2$s)\uff0c%s\u79d1\u76ee\u65e0\u4e0a\u7ea7\u79d1\u76ee\u6216\u672a\u5206\u914d\u4e0a\u7ea7\u79d1\u76ee\uff0c\u8bf7\u5148\u521b\u5efa\u4e0a\u7ea7\u79d1\u76ee\u3002", (String)"AccountBatchUpdateImportPlugin_2", (String)"fi-bd-opplugin", (Object[])new Object[0]), createOrg.getString("name"), createOrg.getString("number"), number));
            }
            String importType = this.getOption().getVariableValue("importtype");
            boolean bl = isNewFirstLevelAccount = "new".equals(importType) && dynamicObject.getInt("level") == 1;
            if (!isNewFirstLevelAccount) {
                BiTreeNode<Long, OrgVO> currAccTableOrgTreeNode = currImportContext.getAccTableOrgTreeNode();
                Map nodeIdMap = BiTreeNode.toMap(currAccTableOrgTreeNode);
                BiTreeNode currOpOrgTreeNode = (BiTreeNode)nodeIdMap.get(useOrgId);
                HashSet childOrgIds = new HashSet(currOpOrgTreeNode.collect(BiTreeNode::getId));
                String longNumber = dynamicObject.getString("longnumber");
                if (dynamicObject.getInt("level") != 1 && BizHappenUtils.existOnLaterPeriods((long)parentDy.getLong("masterid"), childOrgIds, null)) {
                    return Optional.ofNullable(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee(%s)\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u65b0\u5bfc\u5165\u3002", (String)"AccountBatchUpdateImportPlugin_12", (String)"fi-bd-opplugin", (Object[])new Object[0]), parentDy.getString("number")));
                }
                QFilter accFilter = new QFilter("accounttable", "=", dynamicObject.get("accounttable_id")).and("masterid", "=", (Object)dynamicObject.getLong("masterid"));
                Set acctIds = AccountVersionUtil.queryAllAccIdsByUseOrgs(childOrgIds, (boolean)true, (QFilter)accFilter);
                if (!CollectionUtils.isEmpty((Collection)acctIds) && BizHappenUtils.batchExist((Set)acctIds, childOrgIds)) {
                    return Optional.ofNullable(String.format(ResManager.loadKDString((String)"\u79d1\u76ee(%s)\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u65b0\u5bfc\u5165\u3002", (String)"AccountBatchUpdateImportPlugin_5", (String)"fi-bd-opplugin", (Object[])new Object[0]), number));
                }
            }
            DynamicObject accTableDy = dynamicObject.getDynamicObject("accounttable");
            String accTableNumber = accTableDy.getString("number");
            long accountTableId = accTableDy.getLong("id");
            String numberCountKey = useOrgId + accTableNumber + number;
            int count = currImportContext.getNumberCountMap().get(numberCountKey);
            if (count > 1) {
                return Optional.ofNullable(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5217\u8868\u4e2d\u5b58\u5728%1$s\u4e2a\u7f16\u7801\u4e3a%2$s\u7684\u79d1\u76ee\u3002", (String)"AccountBatchUpdateImportPlugin_4", (String)"fi-bd-opplugin", (Object[])new Object[0]), count, number));
            }
            long createOrgId = currImportContext.getAccTableOrgId();
            if (!"override".equals(importType) && !dynamicObject.getDataEntityState().getFromDatabase()) {
                long parentOrg = AccountImportUtil.getParentOrg((long)useOrgId, currImportContext.getAccTableOrgTreeNode());
                AccountKeyVO accountKeyVO = new AccountKeyVO(accountTableId, parentOrg, number);
                Long parentOrgCurrAccId = currOrgAccountMap.get(accountKeyVO);
                if (null == parentOrgCurrAccId) {
                    HashMap orgAccMap = new HashMap(8);
                    Map parentOrgAccount = AccountImportUtil.getCurrOrgAccount((long)accountTableId, new HashSet<String>(Collections.singletonList(number)), orgAccMap, currImportContext.getAccCtrlStrategyMap());
                    currOrgAccountMap.putAll(parentOrgAccount);
                    parentOrgCurrAccId = (Long)parentOrgAccount.get(accountKeyVO);
                }
                if (createOrgId != dynamicObject.getLong("useorg_id") && parentOrgCurrAccId == null && dynamicObject.getInt("level") == 1) {
                    return Optional.ofNullable(ResManager.loadKDString((String)"\u4e00\u7ea7\u79d1\u76ee\u53ea\u80fd\u7531\u79d1\u76ee\u8868\u7684\u521b\u5efa\u7ec4\u7ec7\u521b\u5efa\u3002", (String)"AccountBatchUpdateImportPlugin_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                }
                String ctrlStrategy = null;
                Tuple<String, Integer> tuple = currImportContext.getAccCtrlStrategyMap().get(parentOrgCurrAccId);
                Integer parentOrgControlLevel = 1;
                if (tuple != null) {
                    ctrlStrategy = (String)tuple.item1;
                    parentOrgControlLevel = (Integer)tuple.item2;
                }
                if (null != parentOrgCurrAccId && 0L != parentOrgCurrAccId && assignAbleCtrl.contains(ctrlStrategy)) {
                    AssignResult assignRes = AssignServiceHelper.assign((Long)parentOrg, Collections.singletonList(useOrgId), (Long)parentOrgCurrAccId, (String)"1");
                    if (!assignRes.getResultType().name().equals("success")) {
                        return Optional.ofNullable(String.join((CharSequence)",", assignRes.getMsgs()));
                    }
                    if (dynamicObject.getInt("orgcontrollevel") < parentOrgControlLevel) {
                        dynamicObject.set("orgcontrollevel", (Object)parentOrgControlLevel);
                    }
                    assignOrgs.add(useOrgId);
                    assignNumbers.add(number);
                }
            }
            return Optional.empty();
        }

        private void dealEachAccOp(AccountImportContext importContext, ExtendedDataEntity[] dataEntities, Map<Object, DynamicObject> dbDynamicObjectMap) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                String number = dynamicObject.getString("number");
                long useOrgId = dynamicObject.getLong("useorg_id");
                long currAccId = dynamicObject.getLong("id");
                long accTableId = dynamicObject.getLong("accounttable_id");
                boolean fromDatabase = dynamicObject.getDataEntityState().getFromDatabase();
                AccountKeyVO accountKeyVO = new AccountKeyVO(accTableId, useOrgId, number);
                Long dbAccountId = importContext.getCurrOrgAccountMap().get(accountKeyVO);
                if (!fromDatabase && null != dbAccountId && 0L != dbAccountId) {
                    fromDatabase = true;
                    dynamicObject.set("id", (Object)dbAccountId);
                    DynamicObject dbAccount = dbDynamicObjectMap.get(dbAccountId);
                    dynamicObject.set("createorg_id", (Object)dbAccount.getLong("createorg_id"));
                    dynamicObject.set("createorg", (Object)dbAccount.getDynamicObject("createorg"));
                    dynamicObject.set("masterid", (Object)dbAccount.getLong("masterid"));
                }
                String key = AccountImportContext.buildKey(new Object[]{currAccId, accTableId, useOrgId});
                OperateOption opRes = OperateOption.create();
                if (fromDatabase && null != dbDynamicObjectMap && !dbDynamicObjectMap.isEmpty()) {
                    logger.info(PREFIX_LOG + key + " \uff1a", (Object)currAccId, (Object)useOrgId);
                    DynamicObject dbAccount = dbDynamicObjectMap.get(currAccId);
                    if (null == dbAccount) {
                        dbAccount = dbDynamicObjectMap.get(dbAccountId);
                    }
                    long dbAccTypeId = dbAccount.getLong("accounttype_id");
                    long accountTypeId = dynamicObject.getLong("accounttype_id");
                    if (!dynamicObject.getString("number").equals(dbAccount.getString("number"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u4e0d\u652f\u6301\u4fee\u6539\u79d1\u76ee\u7f16\u7801\u3002", (String)"AccountBatchUpdateImportPlugin_9", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (dbAccTypeId != accountTypeId) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u4e0d\u652f\u6301\u4fee\u6539\u79d1\u76ee\u7c7b\u578b\u3002", (String)"AccountBatchUpdateImportPlugin_7", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    long dbAccTableId = dbAccount.getLong("accounttable_id");
                    if (accTableId != dbAccTableId) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u4e0d\u652f\u6301\u4fee\u6539\u79d1\u76ee\u8868\u3002", (String)"AccountBatchUpdateImportPlugin_3", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!dynamicObject.getString("pltype").equals(dbAccount.getString("pltype"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u4e0d\u652f\u6301\u4fee\u6539\u635f\u76ca\u7c7b\u578b\u3002", (String)"AccountBatchUpdateImportPlugin_8", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    opRes = AccountImportContext.dealImportAccount(false, dbAccount, dynamicObject);
                    dataEntity.setDataEntity(dbAccount);
                } else {
                    opRes = AccountImportContext.dealImportAccount(true, null, dynamicObject);
                }
                if (opRes.getVariables() == null || opRes.getVariables().isEmpty()) continue;
                ThreadCache.put((Object)accountKeyVO, (Object)opRes);
            }
        }

        private void fixEntry(DynamicObject dynamicObject, Map entryInfoObj) {
            boolean fixEntry = Boolean.parseBoolean(this.getOption().getVariableValue("fixEntry", Boolean.TRUE.toString()));
            DynamicObjectCollection checkitems = dynamicObject.getDynamicObjectCollection("checkitementry");
            if (fixEntry) {
                String useOrgNumber = dynamicObject.getDynamicObject("useorg").getString("number");
                String accTableNumber = dynamicObject.getDynamicObject("accounttable").getString("number");
                String number = dynamicObject.getString("number");
                String key = AccountImportContext.buildKey(new Object[]{useOrgNumber, accTableNumber, number});
                Map currAccountAssitemMap = null;
                Map currencyMap = null;
                if (ObjectUtils.isNotEmpty((Object)entryInfoObj)) {
                    if (entryInfoObj.containsKey("asstactitem") && ObjectUtils.isNotEmpty(entryInfoObj.get("asstactitem"))) {
                        currAccountAssitemMap = (Map)entryInfoObj.get("asstactitem");
                    }
                    if (entryInfoObj.containsKey("currency") && ObjectUtils.isNotEmpty(entryInfoObj.get("currency"))) {
                        currencyMap = (Map)entryInfoObj.get("currency");
                    }
                }
                this.dealCurrEntry(checkitems, key, "asstactitem", currAccountAssitemMap);
                DynamicObjectCollection currencys = dynamicObject.getDynamicObjectCollection("currencyentry");
                this.dealCurrEntry(currencys, key, "currency", currencyMap);
            }
        }

        private void dealCurrEntry(DynamicObjectCollection entrys, String key, String idefication, Map<String, List<String>> entryInfos) {
            for (int i = entrys.size() - 1; i >= 0; --i) {
                boolean isNeedRemoveEntry;
                DynamicObject item = ((DynamicObject)entrys.get(i)).getDynamicObject(idefication);
                boolean bl = isNeedRemoveEntry = item == null || CollectionUtil.isEmpty(entryInfos) || CollectionUtil.isEmpty((Collection)entryInfos.get(key)) || !entryInfos.get(key).contains(item.getString("number"));
                if (DebugTrace.enable()) {
                    String currAssistNumber = item == null ? null : item.getString("number");
                    this.writeOutLog(key, entryInfos, currAssistNumber);
                }
                if (!isNeedRemoveEntry) continue;
                entrys.remove(i);
            }
        }

        private void writeOutLog(String key, Map<String, List<String>> entryInfos, String currAssistNumber) {
            boolean empty = CollectionUtil.isEmpty(entryInfos);
            boolean isExistAssistEntry = false;
            List<String> asstactitemNumberSet = null;
            boolean contains = false;
            if (!empty && !(isExistAssistEntry = CollectionUtil.isEmpty(asstactitemNumberSet = entryInfos.get(key))) && StringUtils.isNotBlank((CharSequence)currAssistNumber)) {
                contains = asstactitemNumberSet.contains(currAssistNumber);
            }
            logger.info("AccountBatchImportValidator_CollectionUtil.isEmpty(entryInfos):{}, CollectionUtil.isEmpty(entryInfos.get(key)): {},!entryInfos.get(key).contains(item.getString(NUMBER) remove_entry\uff1a {}, entryInfos.get(key): {}item.getString(NUMBER): {}", new Object[]{empty, isExistAssistEntry, contains, asstactitemNumberSet, currAssistNumber});
        }

        private void removeDupEntryRow(DynamicObjectCollection entry, String keyField) {
            int i;
            ArrayList<Object> ids = new ArrayList<Object>();
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            for (i = 0; i < entry.size(); ++i) {
                DynamicObject dyo = ((DynamicObject)entry.get(i)).getDynamicObject(keyField);
                if (dyo == null) continue;
                Object pkValue = dyo.getPkValue();
                if (ids.contains(pkValue)) {
                    indexs.add(i);
                    continue;
                }
                ids.add(pkValue);
            }
            for (i = indexs.size(); i > 0; --i) {
                int index = (Integer)indexs.get(i - 1);
                entry.remove(index);
            }
        }

        private void setRealLevel(DynamicObject dynamicObject) {
            DynamicObject parent = dynamicObject.getDynamicObject("parent");
            if (dynamicObject.getDataEntityState().getFromDatabase()) {
                return;
            }
            if (parent == null) {
                long parentId = dynamicObject.getLong("parent_id");
                if (parentId != 0L) {
                    int plevel = this.levelMap.get(parentId) == null ? 0 : this.levelMap.get(parentId);
                    dynamicObject.set("level", (Object)(plevel + 1));
                    dynamicObject.set("orgcontrollevel", (Object)(plevel + 1));
                } else {
                    dynamicObject.set("level", (Object)1);
                }
            } else {
                dynamicObject.set("level", (Object)(parent.getInt("level") + 1));
                int controLevel = dynamicObject.getInt("orgcontrollevel");
                controLevel = controLevel >= dynamicObject.getInt("level") ? controLevel : dynamicObject.getInt("level");
                int pControlLevel = parent.getInt("orgcontrollevel");
                int relControlLevel = controLevel >= pControlLevel ? controLevel : pControlLevel + 1;
                dynamicObject.set("orgcontrollevel", (Object)relControlLevel);
                dynamicObject.set("enable", parent.get("enable"));
            }
            this.levelMap.put(dynamicObject.getLong("id"), dynamicObject.getInt("level"));
        }

        private void setHiddenProperty(DynamicObject dynamicObject) {
            DynamicObjectCollection checkitems = dynamicObject.getDynamicObjectCollection("checkitementry");
            boolean isAssist = false;
            boolean isAccheck = false;
            for (DynamicObject entry : checkitems) {
                DynamicObject item = entry.getDynamicObject("asstactitem");
                if (item == null) continue;
                isAssist = true;
                if (!entry.getBoolean("enaccheck")) continue;
                isAccheck = true;
            }
            dynamicObject.set("isassist", (Object)isAssist);
            dynamicObject.set("accheck", (Object)isAccheck);
        }
    }
}

