/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountimport;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportSheetHandler;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.fi.bd.accountimport.AccountImportConfig;
import kd.fi.bd.accountimport.AccountImportHelper;
import kd.fi.bd.util.FibdApp;

public class ColumnImportSheetHandler
extends BatchImportSheetHandler {
    private final ImportLogger logger;
    private boolean setNumRow = false;
    private boolean isOutOfSize = false;

    public ColumnImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, Map<String, Object> option, HeartBeat heartbeat) {
        super(ctx2, mainEntityType2, url2, option, heartbeat);
        this.logger = ctx2.getLogger(url2);
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        Set keySet;
        int currRowNum;
        if (!this.setNumRow && (currRowNum = row.getRowNum()) <= 5 && ((keySet = row.getData().values().stream().map(x -> x.split("\\.")[0]).collect(Collectors.toSet())).contains("asstactitem") || keySet.contains("currency"))) {
            this.setNumRow = true;
            Map sizeMap = AccountImportHelper.getSizeMap();
            TreeMap<Integer, String> data = new TreeMap<Integer, String>(row.getData());
            data.forEach((excelIdx, columnKey) -> {
                String[] split = columnKey.split("\\.", 2);
                if (sizeMap.containsKey(columnKey)) {
                    Integer idx = (Integer)sizeMap.get(columnKey);
                    row.getData().put(excelIdx, split.length == 1 ? split[0] + "_" + idx : split[0] + "_" + idx + "." + split[1]);
                    idx = idx + 1;
                    sizeMap.put(columnKey, idx);
                }
            });
            this.isOutOfSize = this.checkOutOfSize(this.getLogger(), currRowNum, sizeMap);
        }
        if (!this.isOutOfSize) {
            super.handleRow(row);
        }
    }

    private boolean checkOutOfSize(ImportLogger logger, int currRowNum, Map<String, Integer> sizeMap) {
        List maxAssistEntrySize = sizeMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("asstactitem")).map(Map.Entry::getValue).sorted().collect(Collectors.toList());
        int maxAssistSize = AccountImportConfig.IMPORT_MAX_ASSIST_ENTRY_SIZE.getInt();
        if ((Integer)maxAssistEntrySize.get(maxAssistEntrySize.size() - 1) > maxAssistSize) {
            logger.log(Integer.valueOf(currRowNum), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5217\u7684\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ColumnImportSheetHandler_1", (String)FibdApp.instance.oppluginModule(), (Object[])new Object[0]));
            return true;
        }
        List maxCurrEntrySize = sizeMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("currency")).map(Map.Entry::getValue).sorted().collect(Collectors.toList());
        int maxCurrSize = AccountImportConfig.IMPORT_MAX_CURR_ENTRY_SIZE.getInt();
        if ((Integer)maxCurrEntrySize.get(maxCurrEntrySize.size() - 1) > maxCurrSize) {
            logger.log(Integer.valueOf(currRowNum), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5e01\u522b\u5217\u7684\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ColumnImportSheetHandler_2", (String)FibdApp.instance.oppluginModule(), (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public ImportLogger getLogger() {
        return this.logger;
    }
}

