/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.M;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimAnnounceMobListPlugin;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.enums.BillStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimHandleStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.helper.CasServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.helper.RecClaimHelper;
import kd.fi.cas.formplugin.mobile.recclaim.operation.CustomCtrlPropHelper;
import kd.fi.cas.formplugin.mobile.recclaim.operation.RecClaimBillOperationHelper;
import kd.fi.cas.formplugin.mobile.recclaim.result.InvokeResult;
import kd.fi.cas.formplugin.mobile.recclaim.temp.TempPush;
import kd.fi.cas.formplugin.mobile.recclaim.utils.CastUtils;
import kd.fi.cas.formplugin.mobile.recclaim.utils.EmptyUtil;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimBillMobBillPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static Log log = LogFactory.getLog(RecClaimBillMobBillPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String ADD_ENTRY = "btn_addentry";
    private static final String VIEW_ANNOUNCE_INFO = "btn_announcedetail";
    private static final String DELETE_ENTRY = "deleteclaimentry";

    public void initialize() {
        super.initialize();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid entryentity = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{ADD_ENTRY, VIEW_ANNOUNCE_INFO, DELETE_ENTRY, "btn_done", "flex_reject_reason", "btn_auditinformation"});
        BasedataEdit finAcc = (BasedataEdit)this.getControl("inneraccount");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara;
            DynamicObject orgId;
            QFilter innerAccQFilter = new QFilter("acctclassify", "=", (Object)"I");
            innerAccQFilter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency != null) {
                innerAccQFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            if ((orgId = (DynamicObject)this.getModel().getValue("org")) != null) {
                innerAccQFilter.and(new QFilter("bank.org.id", "=", orgId.getPkValue()));
            }
            if ((showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter()) != null) {
                showPara.setCustomParam("isclearcorefilter", (Object)"true");
                showPara.getListFilterParameter().setFilter(innerAccQFilter);
            }
        });
        BasedataEdit recPayType = (BasedataEdit)this.getControl("recpaytype");
        recPayType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (showPara != null) {
                showPara.getListFilterParameter().setFilter(new QFilter("biztype", "!=", (Object)"110"));
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.handleButtonShow();
        if ("true".equals(this.getPageCache().get("DELETE_BILL"))) {
            return;
        }
        this.setPaymentType();
        this.setBaseDataPayer();
        this.setOtherDefaultValue();
    }

    private void handleButtonShow() {
        BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
        Object billno = this.getModel().getValue("billno");
        log.info("param: " + param.getCustomParams().toString());
        log.info("param.getPkId: " + param.getPkId());
        log.info("billno: " + billno);
        if (param.getPkId() == null && StringUtils.isBlank((Object)billno)) {
            this.getPageCache().put("DELETE_BILL", "false");
            this.showPanel(Boolean.TRUE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_auditinformation", "btn_audit"});
            return;
        }
        Object pkId = param.getPkId();
        Long billId = pkId instanceof String ? Long.valueOf(pkId.toString()) : (Long)pkId;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cas_claimbill", (String)"id,billStatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (dynamicObject != null) {
            this.getPageCache().put("DELETE_BILL", "false");
            this.showPanel(Boolean.TRUE);
            this.fixBillOperationStatus(dynamicObject.get("id"), dynamicObject.get("billStatus"));
        } else {
            this.getPageCache().put("DELETE_BILL", "true");
            this.showPanel(Boolean.FALSE);
        }
    }

    private void showPanel(Boolean exsitData) {
        if (exsitData.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"panel_content"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"panel_no_data"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"panel_content"});
            Container panel_no_data = (Container)this.getView().getControl("panel_no_data");
            FlexPanelAp flexPanelAp = new FlexPanelAp();
            flexPanelAp.setKey("nodata");
            flexPanelAp.setGrow(1);
            flexPanelAp.setShrink(0);
            flexPanelAp.setMaximize(true);
            panel_no_data.addControls(Collections.singletonList(flexPanelAp.createControl()));
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("cas_empty_data_m");
            StyleCss styleCss = new StyleCss();
            styleCss.setMarginLeft("0px");
            styleCss.setMarginRight("0px");
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("nodata");
            this.getView().showForm((FormShowParameter)showParameter);
            this.getView().setVisible(Boolean.TRUE, new String[]{"panel_no_data"});
        }
    }

    private void fixBillOperationStatus(Object id, Object billStatus) {
        BillStatusProp billStatusProp;
        IDataEntityProperty property;
        boolean noWorkFlow;
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            noWorkFlow = true;
        } else {
            List maps = RecClaimBillOperationHelper.forecastWorkflow((String)id.toString());
            noWorkFlow = CollectionUtils.isEmpty((Collection)maps);
        }
        this.getView().setVisible(Boolean.valueOf(!noWorkFlow), new String[]{"btn_auditinformation"});
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            if (noWorkFlow) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_audit"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_audit"});
            }
        }
        if ((property = this.getModel().getProperty("billstatus")) != null && !billStatus.equals((billStatusProp = (BillStatusProp)CastUtils.cast((Object)property)).getDefValue())) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            } else if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
            } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
            } else if (BillStatusEnum.DEAD.getValue().equals(billStatus)) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            }
            ((IBillView)this.getView()).updateViewStatus();
        }
    }

    private void refreshClaimBillInfo() {
        Object noticeBillId = this.getModel().getValue("sourceid");
        List margeBills = RecClaimHelper.getAllChildNoticeBill((Object)noticeBillId);
        BigDecimal sumreamount = BigDecimal.ZERO;
        for (DynamicObject bill : margeBills) {
            sumreamount = sumreamount.add(bill.getBigDecimal("reamount"));
        }
        this.getModel().setValue("reamount", (Object)sumreamount);
        ((Label)this.getControl("rejectreasonlabel")).setText(this.getModel().getValue("rejectreason").toString());
        Label billNoLabel = (Label)this.getControl("labelap3121");
        billNoLabel.setText(this.getModel().getDataEntity().getString("billno"));
    }

    private void setOtherDefaultValue() {
        QFilter claimNoQ;
        IDataModel iDataModel = this.getModel();
        String billstatus = (String)iDataModel.getValue("billstatus");
        String claimNo = (String)iDataModel.getValue("claimno");
        String claimtype = (String)iDataModel.getValue("claimtype");
        boolean isNeedUpdate = true;
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SAVE.getValue()) || StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
            if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.ADJUST.getValue()) || StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CHANGE.getValue())) {
                claimNoQ = new QFilter("id", "=", this.getModel().getValue("id"));
                Object pkId = this.getModel().getValue("id");
                if (StringUtils.isNotBlank((Object)pkId)) {
                    boolean isExist = QueryServiceHelper.exists((String)"cas_claimbill", (Object)pkId);
                    isNeedUpdate = !isExist;
                }
            }
        } else {
            isNeedUpdate = false;
        }
        if (isNeedUpdate) {
            claimNoQ = new QFilter("claimNo", "=", (Object)claimNo);
            claimNoQ.and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())).and(new QFilter("claimtype", "!=", (Object)ClaimTypeEnum.ADJUST.getValue()));
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimbill", (String)"recpaytype,paymenttype,recpayer,bizdate,inneraccount", (QFilter[])new QFilter[]{claimNoQ}, (String)" auditdate asc ");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
                boolean updateFlag = false;
                DynamicObject claimbill = (DynamicObject)colls.get(0);
                Long recpaytypeDy = claimbill.getLong("recpaytype");
                String paymenttypeStr = claimbill.getString("paymenttype");
                String recpayerDy = claimbill.getString("recpayer");
                Date biz = claimbill.getDate("bizdate");
                Object recpaytypeObj = iDataModel.getValue("recpaytype");
                String paymenttype = (String)iDataModel.getValue("paymenttype");
                Object recpayerObj = iDataModel.getValue("recpayer");
                Date bizDate = (Date)iDataModel.getValue("bizdate");
                if (!(EmptyUtil.isEmpty((Object)recpaytypeObj) || EmptyUtil.isEmpty((String)paymenttype) || EmptyUtil.isEmpty((Object)recpayerObj))) {
                    Long recpaytype = null;
                    String recpayer = null;
                    if (recpaytypeObj instanceof Long) {
                        recpaytype = (Long)recpaytypeObj;
                    }
                    if (recpaytypeObj instanceof DynamicObject) {
                        recpaytype = ((DynamicObject)recpaytypeObj).getLong("id");
                    }
                    if (recpayerObj instanceof Long) {
                        recpayer = String.valueOf(recpayerObj);
                    }
                    if (recpayerObj instanceof DynamicObject) {
                        recpayer = String.valueOf(((DynamicObject)recpayerObj).getLong("id"));
                    }
                    if (recpayerObj instanceof String) {
                        recpayer = (String)recpayerObj;
                    }
                    if (recpaytypeDy.compareTo(recpaytype) != 0 || !StringUtils.equals((CharSequence)paymenttypeStr, (CharSequence)paymenttype) || !StringUtils.equals((CharSequence)recpayerDy, (CharSequence)recpayer) || biz.compareTo(bizDate) != 0) {
                        updateFlag = true;
                    }
                } else {
                    updateFlag = true;
                }
                if (updateFlag) {
                    iDataModel.beginInit();
                    iDataModel.setValue("recpaytype", (Object)recpaytypeDy);
                    iDataModel.setValue("paymenttype", (Object)paymenttypeStr);
                    iDataModel.setValue("recpayer", (Object)recpayerDy);
                    iDataModel.setValue("bizdate", (Object)biz);
                    iDataModel.setValue("inneraccount", claimbill.get("inneraccount"));
                    iDataModel.endInit();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u901a\u77e5\u5355\u4e0b\u5df2\u5b58\u5728\u5ba1\u6838\u7684\u8ba4\u9886\u4fe1\u606f\uff0c\u5c06\u4f7f\u7528\u5df2\u5ba1\u6838\u8ba4\u9886\u5355\u7684\u6536\u6b3e\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u4fe1\u606f\u3001\u4e1a\u52a1\u65e5\u671f\u3002", (String)"RecClaimBillMobBillPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]), Integer.valueOf(8000));
                }
                if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CLAIM.getValue())) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"recpaytype", "paymenttype", "recpayer", "recbasepayer", "inneraccount", "bizdate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap18"});
                }
            }
        }
        DynamicObject org = (DynamicObject)iDataModel.getValue("org");
        String payment = (String)iDataModel.getValue("paymenttype");
        Object recpaytypeObj = this.getModel().getValue("recpaytype");
        boolean ispartreceivable = true;
        if (!EmptyUtil.isEmpty((Object)recpaytypeObj)) {
            DynamicObject recpaytype = (DynamicObject)recpaytypeObj;
            String bizType = recpaytype.getString("biztype");
            QFilter typeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
            QFilter orgFilter = new QFilter("org.id", "=", org.getPkValue());
            DynamicObject[] bdFinorginfo = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{typeFilter.and(orgFilter)});
            if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType) && bdFinorginfo.length > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccountname"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
            }
            String paymenttype = "";
            ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.CUSTOMER.getName()), ClaimPaymentTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.SUPPLIER.getName()), ClaimPaymentTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.ORG.getName()), ClaimPaymentTypeEnum.ORG.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.USER.getName()), ClaimPaymentTypeEnum.USER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(ClaimPaymentTypeEnum.OTHER.getName()), ClaimPaymentTypeEnum.OTHER.getValue()));
            if (!recpaytype.getBoolean("ispartreceivable")) {
                ispartreceivable = false;
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_settleorg", "e_corebillentryseq", "e_itemname", "e_material", "e_discountamt", "e_saleman"});
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity(ENTRYENTITY))) {
                    int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                    for (int i = 0; i < entryRowCount; ++i) {
                        this.getModel().setValue("e_corebillentryseq", null, i);
                        this.getModel().setValue("e_itemname", null, i);
                        this.getModel().setValue("e_material", null, i);
                        this.getModel().setValue("e_discountamt", null, i);
                        this.getModel().setValue("e_saleman", null, i);
                        this.getModel().setValue("e_corebillnoinput", this.getModel().getValue("e_corebillno", i), i);
                    }
                }
                paymenttype = "other";
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillno"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"e_settleorg", "e_corebillentryseq", "e_itemname", "e_material", "e_discountamt", "e_saleman"});
                paymenttype = "bd_customer";
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillnoinput"});
            }
            ComboEdit recpaytypeCbo = (ComboEdit)this.getView().getControl("paymenttype");
            recpaytypeCbo.setComboItems(comboItem);
            if (EmptyUtil.isEmpty((String)payment)) {
                this.getModel().beginInit();
                this.getModel().setValue("paymenttype", (Object)paymenttype);
                this.getModel().setValue("paymentbasetype", (Object)(StringUtils.equals((CharSequence)"other", (CharSequence)paymenttype) ? "" : paymenttype));
                this.getModel().endInit();
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_corebillnoinput"});
        }
        if (EmptyUtil.isNotEmpty((String)payment) && !StringUtils.equals((CharSequence)payment, (CharSequence)"other")) {
            iDataModel.setValue("paymentbasetype", (Object)payment);
            iDataModel.setValue("recbasepayer", iDataModel.getValue("recpayer"));
            Object recbasepayerDy = this.getModel().getValue("recbasepayer");
            if (EmptyUtil.isEmpty((Object)recbasepayerDy)) {
                this.getModel().setValue("recviewpayer", null);
            } else {
                this.getModel().setValue("recviewpayer", (Object)((DynamicObject)recbasepayerDy).getString("name"));
            }
        } else {
            iDataModel.setValue("recviewpayer", iDataModel.getValue("recpayer"));
        }
        this.refreshNoticeBillInfo();
        this.getView().setVisible(Boolean.FALSE, new String[]{"recviewpayer"});
        this.getView().getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("true".equals(this.getPageCache().get("DELETE_BILL"))) {
            return;
        }
        this.handleEntryPanel();
        this.refreshNoticeBillInfo();
        this.refreshClaimBillInfo();
        this.setFieldMustInput();
        this.setNoticeProgressBar();
    }

    private void setFieldMustInput() {
        FieldEdit recpayType = (FieldEdit)this.getView().getControl("recpaytype");
        recpayType.setMustInput(true);
        FieldEdit paymentType = (FieldEdit)this.getView().getControl("paymenttype");
        paymentType.setMustInput(true);
        DynamicObject recPayType = (DynamicObject)this.getModel().getValue("recpaytype");
        if (recPayType != null) {
            String bizType = recPayType.getString("biztype");
            FieldEdit innerAccount = (FieldEdit)this.getView().getControl("inneraccount");
            innerAccount.setMustInput(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType));
        } else {
            FieldEdit innerAccount = (FieldEdit)this.getView().getControl("inneraccount");
            innerAccount.setMustInput(false);
        }
        this.validateOther();
    }

    private void setNoticeProgressBar() {
        int amtPercent;
        int processBarPercent;
        String businesstype = this.getModel().getDataEntity().getString("businesstype");
        if (StringUtils.equals((CharSequence)businesstype, (CharSequence)"recticket")) {
            Label oppunitNameLabel = (Label)this.getControl("labelap51");
            oppunitNameLabel.setText(ResManager.loadKDString((String)"\u4ea4\u7968\u4eba\u5168\u79f0", (String)"RecClaimBillMobBillPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]));
        }
        Label oppunitLabel = (Label)this.getControl("labelap511");
        oppunitLabel.setText(this.getModel().getDataEntity().getString("oppunit"));
        DynamicObjectCollection notices = QueryServiceHelper.query((String)"cas_claimannounce", (String)"reamount,unclaimamount,claimedamount", (QFilter[])new QFilter("billno", "=", this.getModel().getValue("claimno")).toArray());
        BigDecimal unclaimAmount = ((DynamicObject)notices.get(0)).getBigDecimal("unclaimamount");
        BigDecimal claimedAmount = ((DynamicObject)notices.get(0)).getBigDecimal("claimedamount");
        if (unclaimAmount.compareTo(BigDecimal.ZERO) <= 0) {
            processBarPercent = 100;
            amtPercent = claimedAmount.divide(unclaimAmount.add(claimedAmount), 2, 3).multiply(new BigDecimal(100)).intValue();
        } else {
            amtPercent = processBarPercent = claimedAmount.divide(unclaimAmount.add(claimedAmount), 2, 3).multiply(new BigDecimal(100)).intValue();
        }
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.setPercent(processBarPercent, amtPercent + "%");
        Label labelap61 = (Label)this.getControl("labelap61");
        String claimedAmountWithCurrency = M.getCurrencyFormatStr((DynamicObject)((DynamicObject)this.getModel().getValue("currency")), (Object)claimedAmount);
        String totalAmountWithCurrency = M.getCurrencyFormatStr((DynamicObject)((DynamicObject)this.getModel().getValue("currency")), (Object)claimedAmount.add(unclaimAmount));
        labelap61.setText(String.format("%s / %s", claimedAmountWithCurrency, totalAmountWithCurrency));
    }

    private void handleEntryPanel() {
        IDataModel model = this.getModel();
        String claimno = (String)model.getValue("claimno");
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"isaddfee,fee,entryentity", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)claimno)});
        Boolean feeEnable = Boolean.FALSE;
        BigDecimal resEfee = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            DynamicObject firstClaimAnnounce = (DynamicObject)colls.get(0);
            feeEnable = firstClaimAnnounce.getBoolean("isaddfee");
            resEfee = feeEnable != false ? firstClaimAnnounce.getBigDecimal("fee") : BigDecimal.ZERO;
        }
        BigDecimal res = BigDecimal.ZERO;
        DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : entryentity) {
            BigDecimal val = (BigDecimal)entry.get("e_receivableamt");
            BigDecimal eFee = (BigDecimal)entry.get("e_fee");
            res = res.add(val);
            if (feeEnable.booleanValue()) continue;
            resEfee = resEfee.add(eFee);
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        Label entryCountMoneyLabel = (Label)this.getControl("entrysummary_money");
        entryCountMoneyLabel.setText(M.getCurrencyFormatStr((DynamicObject)currency, (Object)res));
        Label efeeLabel = (Label)this.getControl("efeedetail");
        efeeLabel.setText(M.getCurrencyFormatStr((DynamicObject)currency, (Object)resEfee));
    }

    private void setBaseDataPayer() {
        Object recPayer;
        IDataModel model = this.getModel();
        String paymenttype = (String)model.getValue("paymenttype");
        if (EmptyUtil.isNotEmpty((String)paymenttype) && !StringUtils.equals((CharSequence)paymenttype, (CharSequence)"other") && EmptyUtil.isNoEmpty((Object)(recPayer = model.getValue("recpayer")))) {
            model.setValue("recbasepayer", recPayer);
        }
    }

    private void setPaymentType() {
        IDataModel model;
        String paymenttype = (String)(model = this.getModel()).getValue("paymenttype");
        model.setValue("paymentbasetype", (Object)(StringUtils.equals((CharSequence)"other", (CharSequence)paymenttype) ? "" : paymenttype));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("paymenttype".equals(name)) {
            this.setPaymentType();
            this.getModel().setValue("recbasepayer", (Object)"");
            this.getModel().setValue("recpayer", (Object)"");
            this.validateOther();
        } else if ("recbasepayer".equals(name)) {
            this.setRecPayer();
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"recpaytype")) {
            this.handleRecpaytype(e);
        }
    }

    private void handleRecpaytype(PropertyChangedArgs e) {
        DynamicObject recpaytype = (DynamicObject)e.getChangeSet()[0].getNewValue();
        FieldEdit innerAccount = (FieldEdit)this.getView().getControl("inneraccount");
        if (recpaytype != null) {
            String bizType = recpaytype.getString("biztype");
            if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType)) {
                innerAccount.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccountname"});
            } else {
                innerAccount.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
                this.getModel().setValue("inneraccount", null);
            }
        } else {
            innerAccount.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
            this.getModel().setValue("inneraccount", null);
        }
        Boolean multiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
        if (!multiReceivingType.booleanValue()) {
            DynamicObjectCollection recEntries = this.getModel().getEntryEntity(ENTRYENTITY);
            this.fillEntryType(recEntries, "e_receivingtype", recpaytype);
        }
    }

    private void fillEntryType(DynamicObjectCollection entries, String recPayType, DynamicObject type) {
        for (int i = 0; i < entries.size(); ++i) {
            this.getModel().setValue(recPayType, (Object)type, i);
        }
    }

    private void rebuildCoreBillType(boolean ispartreceivable) {
        List comboItems;
        ArrayList<ComboItem> coreComboItem = new ArrayList<ComboItem>();
        ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_claimbill").getProperty(ispartreceivable ? "settlecorebilltype" : "unsettlecorebilltype");
        if (EmptyUtil.isNoEmpty((Object)property) && EmptyUtil.isNoEmpty((Object)(comboItems = property.getComboItems()))) {
            for (ValueMapItem valueMapItem : comboItems) {
                ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                coreComboItem.add(comboItem);
            }
        }
        ComboEdit coreCbo = (ComboEdit)this.getView().getControl("e_corebilltype");
        coreCbo.setComboItems(coreComboItem);
    }

    private void validateOther() {
        FieldEdit recbasePayer = (FieldEdit)this.getView().getControl("recbasepayer");
        FieldEdit recPayer = (FieldEdit)this.getView().getControl("recpayer");
        if (!StringUtils.equals((CharSequence)"other", (CharSequence)((String)this.getModel().getValue("paymenttype")))) {
            recbasePayer.setMustInput(true);
            recPayer.setMustInput(false);
        } else {
            recbasePayer.setMustInput(false);
            recPayer.setMustInput(true);
        }
    }

    private void setRecPayer() {
        Object payerid = this.getModel().getValue("recbasepayer");
        if (payerid != null) {
            this.getModel().setValue("recpayer", ((DynamicObject)payerid).getPkValue());
        } else {
            this.getModel().setValue("recpayer", (Object)"");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (ADD_ENTRY.equals(key)) {
            RecClaimPageJumpHandler.claimBillToClaimEntry((AbstractFormPlugin)this, (int)-1);
        } else if (VIEW_ANNOUNCE_INFO.equals(key)) {
            this.viewAnnounceInfo();
        } else if (DELETE_ENTRY.equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DELETE_ENTRY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_done"});
            for (int i = 0; i < this.getModel().getEntryRowCount(ENTRYENTITY); ++i) {
                this.getModel().setValue("mobiledeldoneflag", (Object)1, i);
            }
        } else if ("btn_done".equals(key)) {
            this.doneVisible();
        } else if ("flex_reject_reason".equals(key)) {
            this.showSpecialOrTips((AbstractFormPlugin)this);
        } else if (StringUtils.equals((CharSequence)"btn_auditinformation", (CharSequence)key)) {
            MobileBillShowParameter parameter = new MobileBillShowParameter();
            parameter.setFormId("cas_claimauditor_m");
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setCaption(ResManager.loadKDString((String)"\u5ba1\u6838\u4fe1\u606f\u8be6\u60c5", (String)"RecClaimBillMobBillPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0]));
            parameter.setPkId(this.getModel().getDataEntity().getPkValue());
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void showSpecialOrTips(AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        String tips = this.getModel().getValue("rejectreason").toString();
        String headName = ResManager.loadKDString((String)"\u9a73\u56de\u4fe1\u606f", (String)"RecClaimBillMobBillPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0]);
        this.showDetailsMob(view, tips, headName);
    }

    private void showDetailsMob(IFormView view, String tips, String headName) {
        String formId = view.getEntityId() + "_mob";
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("formid", formId);
        customParam.put("tips", tips);
        customParam.put("headname", headName);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cas_rejectiontips_mb");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCaption(headName);
        formShowParameter.getCustomParams().putAll(customParam);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        view.showForm(formShowParameter);
    }

    private void doneVisible() {
        this.getView().setVisible(Boolean.TRUE, new String[]{DELETE_ENTRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_done"});
        for (int i = 0; i < this.getModel().getEntryRowCount(ENTRYENTITY); ++i) {
            this.getModel().setValue("mobiledeldoneflag", (Object)0, i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("change".equals(operateKey)) {
            this.beforeDoChange(args);
        } else if ("adjust".equals(operateKey)) {
            this.beforeDoAdjust(args);
        } else if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            operate.getOption().setVariableValue("source", "mobile");
        }
    }

    private void beforeDoAdjust(BeforeDoOperationEventArgs args) {
        Object claimBillPk = this.getModel().getValue("id");
        IFormView view = this.getView();
        InvokeResult ret = CasServiceHelper.beforeAdjust((Object)claimBillPk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, (Object)ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
            } else {
                this.getView().showTipNotification(ret.getMsg());
            }
            args.setCancel(true);
            return;
        }
        args.setCancel(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow srcBill = new ListSelectedRow(claimBillPk);
        selectedRows.add(srcBill);
        new TempPush().pushClaimBill((AbstractFormPlugin)this, selectedRows, args);
    }

    private boolean beforeDoChange(BeforeDoOperationEventArgs args) {
        Object claimBillPk = this.getModel().getValue("id");
        IFormView view = this.getView();
        InvokeResult ret = CasServiceHelper.beforeChangeClaimBill((Object)claimBillPk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, (Object)ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
                args.setCancel(true);
            } else {
                this.getView().showTipNotification(ret.getMsg());
                args.setCancel(true);
            }
            return false;
        }
        args.setCancel(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow srcBill = new ListSelectedRow(claimBillPk);
        selectedRows.add(srcBill);
        new TempPush().pushClaimBill((AbstractFormPlugin)this, selectedRows, args);
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        OperationResult operationResult = eventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = eventArgs.getOperateKey();
        String claimtype = String.valueOf(this.getModel().getValue("claimtype"));
        String billno = (String)this.getModel().getValue("billno");
        if ("deleteentry".equals(operateKey)) {
            this.handleEntryPanel();
        } else if ("submit".equals(operateKey)) {
            if (this.isFromOldPage(this.getView()).booleanValue()) {
                this.refreshParentPageAfterOpt();
            } else {
                this.submitAfterDo();
            }
        } else if (StringUtils.equals((CharSequence)"change", (CharSequence)operateKey)) {
            this.showOperationForm(claimtype, billno);
        } else if (StringUtils.equals((CharSequence)"adjust", (CharSequence)operateKey)) {
            this.showOperationForm(claimtype, billno);
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            this.refreshParentPageAfterOpt();
        } else if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)operateKey)) {
            this.refreshParentPageAfterOpt();
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)operateKey)) {
            this.refreshParentPageAfterOpt();
        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey)) {
            this.refreshBillList();
            this.showOperationForm(claimtype, billno);
        }
    }

    private void refreshBillList() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    private void refreshParentPageAfterOpt() {
        RecClaimNoticeMobUtils.refreshTargetParentPage((IFormView)this.getView(), (String)"cas_claimanno_moblist");
        RecClaimNoticeMobUtils.refreshTargetParentPage((IFormView)this.getView(), (String)"cas_index_m");
        RecClaimNoticeMobUtils.refreshTab((IFormView)this.getView(), (String)"cas_claimnotice_m", (List)RecClaimAnnounceMobListPlugin.noticeTabList);
        RecClaimNoticeMobUtils.refreshTargetParentPage((IFormView)this.getView(), (String)"cas_claimbill_moblist");
        this.getView().invokeOperation("refresh");
    }

    private void showOperationForm(String pagetype, String billno) {
        if (this.isFromOldPage(this.getView()).booleanValue()) {
            return;
        }
        RecClaimBillMobBillPlugin.showOperationForm(pagetype, billno, (AbstractFormPlugin)this);
    }

    private Boolean isFromOldPage(IFormView view) {
        for (IFormView targetView = view; targetView != null; targetView = targetView.getParentView()) {
            if (!StringUtils.equals((CharSequence)"cas_recclaim_m", (CharSequence)targetView.getEntityId())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void showOperationForm(String pagetype, String billno, AbstractFormPlugin plugIn) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pagetype", pagetype);
        params.put("billno", billno);
        parameter.setCustomParams(params);
        parameter.setFormId("cas_result_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        plugIn.getView().showForm((FormShowParameter)parameter);
    }

    private void viewAnnounceInfo() {
        IDataModel model = this.getModel();
        Object claimno = model.getValue("claimno");
        DynamicObject announceBill = QueryServiceHelper.queryOne((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter("billno", "in", claimno).toArray());
        if (announceBill != null) {
            Object announcePK = announceBill.get("id");
            RecClaimPageJumpHandler.claimBillToAnnounceBill((AbstractFormPlugin)this, (Object)announcePK);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        if (ENTRYENTITY.equals(source.getEntryKey())) {
            this.doneVisible();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            RecClaimPageJumpHandler.claimBillToClaimEntry((AbstractFormPlugin)this, (int)rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("cas_claimbill_detail_m".equals(closedCallBackEvent.getActionId())) {
            this.handleEntryPanel();
        }
    }

    private void refreshNoticeBillInfo() {
        IDataModel iDataModel = this.getModel();
        String claimNo = (String)iDataModel.getValue("claimno");
        QFilter claimNoQ = new QFilter("billno", "=", (Object)claimNo);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"currency.sign,currency.amtprecision,claimstatus,claimedamount,unclaimamount,isaddfee,fee", (QFilter[])new QFilter[]{claimNoQ});
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            iDataModel.setValue("claimstatus", ((DynamicObject)colls.get(0)).get("claimstatus"));
            iDataModel.setValue("claimedamount", ((DynamicObject)colls.get(0)).get("claimedamount"));
            iDataModel.setValue("unclaimamount", ((DynamicObject)colls.get(0)).get("unclaimamount"));
            this.getView().updateView("claimstatus");
            DynamicObject firstClaimAnnounce = (DynamicObject)colls.get(0);
            Boolean feeEnable = !firstClaimAnnounce.getBoolean("isaddfee");
            if (!feeEnable.booleanValue()) {
                BigDecimal fee = firstClaimAnnounce.getBigDecimal("fee");
                String sign = firstClaimAnnounce.getString("currency.sign");
                int amtPrecision = firstClaimAnnounce.getInt("currency.amtprecision");
                ((Label)this.getControl("efeedetail")).setText(M.getCurrencyFormatStr((String)sign, (int)amtPrecision, (Object)fee));
            }
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity(ENTRYENTITY))) {
                int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getView().setEnable(feeEnable, i, new String[]{"e_fee"});
                }
            }
        }
    }

    private void submitAfterDo() {
        String claimtype = this.getModel().getValue("claimtype").toString();
        String billno = this.getModel().getValue("billno").toString();
        String id = this.getModel().getValue("id").toString();
        List maps = RecClaimBillOperationHelper.forecastWorkflow((String)id);
        if (CollectionUtils.isEmpty((Collection)maps)) {
            String ignore = RecClaimBillOperationHelper.getIgnoreTipAutoAudit((Long)Long.parseLong(RequestContext.get().getUserId()));
            if ("true".equals(ignore)) {
                this.doAutoAudit(id, billno, claimtype);
            } else {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("_t", new Date().getTime());
                data.put("claimtype", claimtype);
                data.put("billno", billno);
                data.put("id", id);
                data.put("show", Boolean.TRUE);
                CustomCtrlPropHelper.setCustomCtrlProp((IFormView)this.getView(), (String)"custom_control_dialog", data);
            }
        } else {
            this.showOperationForm(claimtype, billno);
            this.refreshParentPageAfterOpt();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        if ("custom_control_dialog".equals(key) && "click".equals(eventName)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)e.getEventArgs(), Map.class);
            switch (data.get("nodeKey").toString()) {
                case "btn_ok": {
                    this.doOk((Map)CastUtils.cast(data.get("data")));
                    break;
                }
                case "btn_cancel": {
                    this.doCancel();
                }
            }
        }
    }

    private void doOk(Map<String, Object> data) {
        String claimtype = data.getOrDefault("claimtype", "").toString();
        String billno = data.getOrDefault("billno", "").toString();
        String id = data.getOrDefault("id", "").toString();
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        Boolean ignore = (Boolean)data.getOrDefault("ignore", Boolean.FALSE);
        if (ignore.booleanValue()) {
            RecClaimBillOperationHelper.saveIgnoreTipAutoAudit((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"true");
        }
        this.doAutoAudit(id, billno, claimtype);
    }

    private void doAutoAudit(String id, String billno, String claimtype) {
        OperationResult result = RecClaimBillOperationHelper.executeOperateAuditById((Object)id);
        if (result.isSuccess()) {
            this.showOperationForm(claimtype, billno);
        } else {
            log.info("\u63d0\u4ea4->\u81ea\u52a8\u5ba1\u6838 :" + Arrays.toString(result.getAllErrorOrValidateInfo().toArray()));
            this.getView().showErrorNotification(RecClaimBillOperationHelper.validateInfo((OperationResult)result));
        }
        this.refreshParentPageAfterOpt();
    }

    private void doCancel() {
        this.refreshParentPageAfterOpt();
    }
}

