/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeGetSourceDataEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.helper.AgentPluginHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentRepayConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        String hadCheck = this.getOption().getVariableValue("had_check", "false");
        if (Boolean.parseBoolean(hadCheck)) {
            return;
        }
        List selectedRows = e.getSelectedRows();
        if (selectedRows.size() != 1) {
            String msg = ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"AgentPayBillList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        Object primaryKeyValue = ((ListSelectedRow)selectedRows.get(0)).getPrimaryKeyValue();
        QFilter filter = new QFilter("id", "=", primaryKeyValue);
        DynamicObjectCollection entryList = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,billno,billstatus,isrepulsed,entry.e_issuccess,entry.e_isrepaid,entry.e_isrefund,entry.id,entry.seq", (QFilter[])filter.toArray());
        String errMsg = AgentPluginHelper.checkAgentRepayByBankAgentStatus(entryList);
        if (EmptyUtil.isNoEmpty((String)errMsg)) {
            throw new KDBizException(errMsg);
        }
    }

    public void beforeGetSourceData(BeforeGetSourceDataEventArgs e) {
        super.beforeGetSourceData(e);
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()).and("isrepulsed", "=", (Object)"1").and("entry.e_issuccess", "=", (Object)"0").and("entry.e_isrepaid", "=", (Object)"0").and("entry.e_isrefund", "=", (Object)"0");
        e.getQFilters().add(filter);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] targetBills;
        for (ExtendedDataEntity agentPayBill : targetBills = e.getTargetExtDataEntitySet().FindByEntityKey("cas_agentpaybill")) {
            DynamicObject bill = agentPayBill.getDataEntity();
            bill.set("payeetype", (Object)bill.getString("payeetypelist"));
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal localAmountSum = BigDecimal.ZERO;
            for (DynamicObject row : entrys) {
                if (row.getString("e_encryptamount") != null) {
                    String encryptAmount = row.getString("e_encryptamount");
                    BigDecimal amount = AgentPayBillHelper.decodeAmount((String)encryptAmount);
                    row.set("e_amount", (Object)amount);
                    amountSum = amountSum.add(amount);
                } else {
                    amountSum = amountSum.add(row.getBigDecimal("e_amount"));
                }
                if (row.getString("e_encryptlocalamt") != null) {
                    String encryptLocalAmount = row.getString("e_encryptlocalamt");
                    BigDecimal localAmount = AgentPayBillHelper.decodeAmount((String)encryptLocalAmount);
                    row.set("e_localamt", (Object)localAmount);
                    localAmountSum = localAmountSum.add(localAmount);
                } else {
                    localAmountSum = localAmountSum.add(row.getBigDecimal("e_localamt"));
                }
                row.set("e_localamt2", (Object)"****");
                row.set("e_amount2", (Object)"****");
            }
            bill.set("payamount", (Object)amountSum);
            bill.set("localamt", (Object)localAmountSum);
        }
    }
}

