/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class AppParameterPlugin
extends AbstractFormPlugin {
    private boolean cancelPropChanged = false;
    private static final Log log = LogFactory.getLog(AppParameterPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setJournalDateSettingComboList();
        log.info("======afterBindData.");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String cs1046;
        super.propertyChanged(e);
        log.info("======propertyChanged.getName:{}.", (Object)e.getProperty().getName());
        if (this.cancelPropChanged) {
            return;
        }
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        String key = e.getProperty().getName();
        if ("cs105".equals(key)) {
            String checkBookModeParameter = this.checkBookModeParameter(oldValue);
            if (StringUtils.isNotEmpty((CharSequence)checkBookModeParameter)) {
                this.cancelPropChanged = true;
                this.getModel().setValue("cs105", oldValue);
                this.cancelPropChanged = false;
                IFormView parentView = this.getView().getParentView();
                parentView.showTipNotification(checkBookModeParameter);
                this.getView().sendFormAction(parentView);
                return;
            }
            this.setJournalDateSettingComboList();
        } else if ("cs1046".equals(key) && StringUtils.isNotBlank((CharSequence)(cs1046 = (String)newValue)) && cs1046.contains(SysParamCs1046Enum.DIFF.getValue()) && !cs1046.contains(SysParamCs1046Enum.FEE.getValue())) {
            String[] values = cs1046.split(",");
            ArrayList<String> asList = new ArrayList<String>(Arrays.asList(values));
            asList.add(SysParamCs1046Enum.FEE.getValue());
            asList.add("");
            this.getModel().beginInit();
            this.getModel().setValue("cs1046", (Object)StringUtils.join((Object[])asList.toArray(new String[0]), (String)","));
            this.getModel().endInit();
            this.getView().updateView("cs1046");
        }
    }

    private void setJournalDateSettingComboList() {
        ComboEdit cs104Edit = (ComboEdit)this.getControl("cs104");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (this.isBizBillBook()) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u4e1a\u52a1\u65e5\u671f", (String)"AppParameterPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])), "1"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u7cfb\u7edf\u65e5\u671f", (String)"AppParameterPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0])), "2"));
        } else {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u4e1a\u52a1\u65e5\u671f", (String)"AppParameterPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])), "1"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u8bb0\u8d26\u65e5\u671f", (String)"AppParameterPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0])), "3"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u7cfb\u7edf\u65e5\u671f", (String)"AppParameterPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0])), "2"));
        }
        if (!this.isBizBillBook() && !this.isMixBillBook()) {
            this.getModel().setValue("cs109", null);
        }
        cs104Edit.setComboItems(items);
    }

    private boolean isBizBillBook() {
        String cs105 = (String)this.getModel().getValue("cs105");
        return "0".equals(cs105);
    }

    private boolean isMixBillBook() {
        String cs105 = (String)this.getModel().getValue("cs105");
        return "3".equals(cs105);
    }

    private boolean isManualBillBook() {
        String cs105 = (String)this.getModel().getValue("cs105");
        return "2".equals(cs105);
    }

    private boolean isVoucherBillBook() {
        String cs105 = (String)this.getModel().getValue("cs105");
        return "1".equals(cs105);
    }

    private String checkBookModeParameter(Object oldValue) {
        try {
            QFilter[] filters;
            log.info("======checkBookModeParameter.begin.");
            DynamicObject org = this.getOrg();
            if (org == null) {
                log.info("======checkBookModeParameter.org == null.");
                return null;
            }
            DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)((Long)org.getPkValue()));
            if (currentPeriod == null) {
                log.info("======checkBookModeParameter.currentPeriod == null.");
                return null;
            }
            QFilter periodFilter = new QFilter("period", ">=", currentPeriod.getPkValue());
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            if ("3".equals(oldValue) || "4".equals(oldValue)) {
                filters = new QFilter[]{orgFilter, periodFilter};
                if (QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])filters)) {
                    log.info("======0.current exists bank.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u94f6\u884c\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                if (QueryServiceHelper.exists((String)"cas_cashjournal", (QFilter[])filters)) {
                    log.info("======0.current exists bank.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u73b0\u91d1\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
            }
            if (this.isBizBillBook()) {
                filters = new QFilter[]{orgFilter, periodFilter, new QFilter("sourcebilltype", "in", (Object)new String[]{"gl_voucher", "cas_manualbankjournal"})};
                if (QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])filters)) {
                    log.info("======1.current exists no bill bank.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u5355\u636e\u767b\u8bb0\u7684\u94f6\u884c\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                QFilter[] cashFilters = new QFilter[]{orgFilter, periodFilter, new QFilter("sourcebilltype", "in", (Object)new String[]{"gl_voucher", "cas_manualcashjournal"})};
                if (QueryServiceHelper.exists((String)"cas_cashjournal", (QFilter[])cashFilters)) {
                    log.info("======1.current exists no bill cash.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u5355\u636e\u767b\u8bb0\u7684\u73b0\u91d1\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
            } else if (this.isMixBillBook()) {
                if ("0".equals(oldValue)) {
                    log.info("======oldValue == 0.");
                    return null;
                }
                filters = new QFilter[]{orgFilter, periodFilter, new QFilter("sourcebilltype", "in", (Object)new String[]{"gl_voucher", "cas_manualbankjournal"})};
                if (QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])filters)) {
                    log.info("======2.current exit no bill bank.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u5355\u636e\u767b\u8bb0\u7684\u94f6\u884c\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                QFilter[] cashFilters = new QFilter[]{orgFilter, periodFilter, new QFilter("sourcebilltype", "in", (Object)new String[]{"gl_voucher", "cas_manualcashjournal"})};
                if (QueryServiceHelper.exists((String)"cas_cashjournal", (QFilter[])cashFilters)) {
                    log.info("======2.current exit no bill cash.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u5355\u636e\u767b\u8bb0\u7684\u73b0\u91d1\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
            } else if (this.isManualBillBook()) {
                filters = new QFilter[]{orgFilter, periodFilter, new QFilter("sourcebilltype", "!=", (Object)"cas_manualbankjournal")};
                if (QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])filters)) {
                    log.info("======3.current exit no bill bank.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u624b\u5de5\u7684\u94f6\u884c\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                QFilter[] cashFilters = new QFilter[]{orgFilter, periodFilter, new QFilter("sourcebilltype", "!=", (Object)"cas_manualcashjournal")};
                if (QueryServiceHelper.exists((String)"cas_cashjournal", (QFilter[])cashFilters)) {
                    log.info("======3.current exit no bill cash.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u624b\u5de5\u7684\u73b0\u91d1\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
            } else if (this.isVoucherBillBook()) {
                filters = new QFilter[]{orgFilter, periodFilter, new QFilter("sourcebilltype", "not in", (Object)new String[]{"gl_voucher", "", " "})};
                if (QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])filters)) {
                    log.info("======4.current exit no bill bank.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u51ed\u8bc1\u767b\u8bb0\u7684\u94f6\u884c\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                if (QueryServiceHelper.exists((String)"cas_cashjournal", (QFilter[])filters)) {
                    log.info("======4.current exit no bill cash.");
                    return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u975e\u51ed\u8bc1\u767b\u8bb0\u7684\u73b0\u91d1\u65e5\u8bb0\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u767b\u8d26\u65b9\u5f0f\u3002", (String)"AppParameterPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
            }
            log.info("======checkBookModeParameter.end.");
            return null;
        }
        catch (Throwable e) {
            log.error("error:", e);
            throw e;
        }
    }

    private DynamicObject getOrg() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        return (DynamicObject)parentView.getModel().getValue("orgfield");
    }
}

