/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.common.CasCommonFilterListPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementListPlugin
extends CasCommonFilterListPlugin {
    private static final String DOWNLOAD = "download";

    protected String getAcctEntity() {
        return "bd_accountbanks";
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Long defalutOrgId = this.getDefalutOrgId("47150e89000000ac");
        if (defalutOrgId != null) {
            FilterColumn orgFilter = args.getFilterColumn("org.id");
            orgFilter.setDefaultValue(String.valueOf(defalutOrgId));
            this.getView().getPageCache().put("defaultOrgID", String.valueOf(defalutOrgId));
        }
        if (this.isTrack()) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if ("org.id".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValue(formShowParameter.getCustomParam("trackOrg").toString());
                    continue;
                }
                if ("accountbank.id".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValues(new Object[]{""});
                    continue;
                }
                if ("bizdate".equals(filterColumn.getFieldName())) {
                    String startDate = (String)formShowParameter.getCustomParam("trackStartDate");
                    String endDate = (String)formShowParameter.getCustomParam("trackEndDate");
                    filterColumn.setDefaultValues(new Object[]{startDate, endDate});
                    continue;
                }
                if (!"currency.id".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
            }
        }
    }

    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        super.cacheFirstSelectedOrg(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String refEntityId = args.getRefEntityId();
        String fieldName = args.getFieldName();
        if ("bd_accountbanks".equals(refEntityId) || "cas_accountcash".equals(refEntityId)) {
            String orgIdsStr = this.getPageCache().get("selectedOrgIdList");
            if (orgIdsStr != null && !"[\"\"]".equals(orgIdsStr)) {
                List orgIds = (List)SerializationUtils.fromJsonString((String)orgIdsStr, List.class);
                List orgIdList = orgIds.stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
                if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"accountbank")) {
                    ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
                    qFilterList.add(AccountBankHelper.getUseAuthAccountBankFilterByOrg(orgIdList));
                    args.setQfilters(qFilterList);
                } else {
                    args.getQfilters().add(new QFilter("org", "in", orgIdList));
                }
            } else {
                ListShowParameter listParam = (ListShowParameter)this.getView().getFormShowParameter();
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)listParam.getBillFormId(), (String)"47150e89000000ac");
                args.getQfilters().add(new QFilter("org", "in", (Object)orgIds));
            }
        }
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"accountbank")) {
            args.getQfilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        }
    }

    protected DynamicObject[] getAcctsShowByOrg(List<Object> selectedOrgIdList) {
        DynamicObject[] acctsShow = null;
        if ("cas_accountcash".equals(this.getAcctEntity())) {
            acctsShow = BusinessDataServiceHelper.load((String)this.getAcctEntity(), (String)"id,name,number,isbycurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])new QFilter[]{new QFilter("org", "in", selectedOrgIdList)});
        } else {
            List orgPks = selectedOrgIdList.stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
            QFilter[] accountFilter = AccountBankHelper.getCreateOrgAccountFilter(orgPks);
            if ("bd_accountbanks".equals(this.getAcctEntity())) {
                ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
                Collections.addAll(qFilterArrayList, AccountBankHelper.getUseAuthAccountBankFilterByOrg(orgPks));
                qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
            }
            acctsShow = BusinessDataServiceHelper.load((String)this.getAcctEntity(), (String)"id,name,number,ismulcurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])accountFilter);
        }
        return acctsShow;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (DOWNLOAD.equals(key)) {
            this.showDownloadView();
        } else if ("introduce".equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u8b66\u544a\u6d88\u606f\u9700\u8981\u60a8\u786e\u8ba4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BankStatementListPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e3a\u907f\u514d\u6570\u636e\u91cd\u590d\uff0c\u7cfb\u7edf\u5efa\u8bae\u60a8\u5728\u201c\u94f6\u4f01\u4e92\u8054>\u79bb\u7ebf\u660e\u7ec6\u5bfc\u5165\u201d\u529f\u80fd\u4e2d\u5bfc\u5165\u4ea4\u6613\u660e\u7ec6\u4fe1\u606f\u540e\uff0c\u518d\u901a\u8fc7\u201c\u4e0b\u8f7d\u201d\u529f\u80fd\u83b7\u53d6\u94f6\u884c\u5bf9\u8d26\u5355\u4fe1\u606f\u3002\u70b9\u201c\u662f\u201d\u8df3\u8f6c\u201c\u79bb\u7ebf\u660e\u7ec6\u5bfc\u5165\u201d\u9875\u9762\uff0c\u70b9\u201c\u5426\u201d\u8df3\u8f6c\u201c\u6570\u636e\u5bfc\u5165\u201d\u9875\u9762\u3002", (String)"BankStatementListPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_ INTRODUCE_CALLBACK", (IFormPlugin)this));
        }
    }

    private void showDownloadView() {
        Long defalutOrgId = this.getDefalutOrgId("4730fc9f000007ae");
        if (defalutOrgId == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_downbankstate");
        showParameter.getCustomParams().put("defaultorg", defalutOrgId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "listoperation");
        callBack.setControlKey("billlistap");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("modifynew".equals(operateKey)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Set pkSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            DynamicObjectCollection statements = QueryServiceHelper.query((String)"cas_bankstatement", (String)"id, ischeck, source, accountbank, currency,org,bizdate,period", (QFilter[])new QFilter[]{new QFilter("id", "in", pkSet)});
            HashSet<Long> accountIds = new HashSet<Long>(statements.size());
            HashSet<Long> currencyIds = new HashSet<Long>(statements.size());
            boolean isError = false;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject bankStatement : statements) {
                Long accountbank = DynamicObjectHelper.getPk((DynamicObject)bankStatement, (String)"accountbank");
                Long currency = DynamicObjectHelper.getPk((DynamicObject)bankStatement, (String)"currency");
                accountIds.add(accountbank);
                currencyIds.add(currency);
                if (isError) continue;
                isError = this.checkModifyProps(isError, sb, bankStatement, accountbank, currency);
            }
            StringBuilder errorMsg = new StringBuilder();
            if (accountIds.size() > 1 || currencyIds.size() > 1) {
                errorMsg.append(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u4fee\u6539\u76f8\u540c\u8d26\u53f7\u3001\u76f8\u540c\u5e01\u79cd\u7684\u94f6\u884c\u5bf9\u8d26\u5355\u6570\u636e\u3002", (String)"BankStatementListPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0])).append("\n");
            }
            if (EmptyUtil.isNotEmpty((String)sb.toString())) {
                errorMsg.append((CharSequence)sb);
            }
            if (EmptyUtil.isNotEmpty((String)errorMsg.toString())) {
                this.getView().showErrorNotification(errorMsg.toString());
                args.setCancel(true);
            }
        } else if ("setimportscheme".equals(operateKey)) {
            ListShowParameter sp = new ListShowParameter();
            sp.setBillFormId("cas_bankstaimpsche");
            sp.setStatus(OperationStatus.ADDNEW);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barnew"));
            this.getView().showForm((FormShowParameter)sp);
        } else if ("importbankstatement".equals(operateKey)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("cas_bankstatementimp");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setCaption(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u94f6\u884c\u5bf9\u8d26\u5355", (String)"BankStatementListPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "cas_bankstatementimp");
            fsp.setCloseCallBack(closeCallBack);
            this.getView().showForm(fsp);
        }
    }

    private boolean checkModifyProps(boolean isError, StringBuilder sb, DynamicObject bankStatement, Long accountbank, Long currency) {
        Date bizDate;
        Long org;
        String errorMessage;
        boolean isCheck;
        String source = bankStatement.getString("source");
        if (!Arrays.asList("3", "4").contains(source)) {
            isError = true;
            sb.append(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u4fee\u6539\u6765\u6e90\u4e3a\u201c\u624b\u5de5\u5bfc\u5165\u201d\u6216\u201c\u624b\u5de5\u65b0\u589e\u201d\u7684\u94f6\u884c\u5bf9\u8d26\u5355\u6570\u636e\u3002", (String)"BankStatementListPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0])).append("\n");
        }
        if (isCheck = bankStatement.getBoolean("ischeck")) {
            isError = true;
            sb.append(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u4fee\u6539\u672a\u52fe\u5bf9\u7684\u94f6\u884c\u5bf9\u8d26\u5355\u6570\u636e\u3002", (String)"BankStatementListPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0])).append("\n");
        }
        if (EmptyUtil.isNotEmpty((String)(errorMessage = AccountBankHelper.checkBalanceAdjustOfStatement((Long)(org = DynamicObjectHelper.getPk((DynamicObject)bankStatement, (String)"org")), (Long)accountbank, (Long)currency, (Date)(bizDate = bankStatement.getDate("bizdate")), (boolean)false, (boolean)true)))) {
            isError = true;
            sb.append(errorMessage).append("\n");
        }
        return isError;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey = args.getOperateKey()) {
            case "barnew": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u8b66\u544a\u6d88\u606f\u9700\u8981\u60a8\u786e\u8ba4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BankStatementListPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e3a\u907f\u514d\u6570\u636e\u91cd\u590d\uff0c\u7cfb\u7edf\u5efa\u8bae\u60a8\u5728\u201c\u94f6\u4f01\u4e92\u8054>\u79bb\u7ebf\u660e\u7ec6\u5bfc\u5165\u201d\u529f\u80fd\u4e2d\u5bfc\u5165\u4ea4\u6613\u660e\u7ec6\u4fe1\u606f\u540e\uff0c\u518d\u901a\u8fc7\u201c\u4e0b\u8f7d\u201d\u529f\u80fd\u83b7\u53d6\u94f6\u884c\u5bf9\u8d26\u5355\u4fe1\u606f\u3002\u70b9\u201c\u662f\u201d\u8df3\u8f6c\u201c\u79bb\u7ebf\u660e\u7ec6\u5bfc\u5165\u201d\u9875\u9762\uff0c\u70b9\u201c\u5426\u201d\u8df3\u8f6c\u201c\u94f6\u884c\u5bf9\u8d26\u5355\u624b\u5de5\u65b0\u589e\u201d\u9875\u9762\u3002", (String)"BankStatementListPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_ADD_CALLBACK", (IFormPlugin)this));
                break;
            }
            case "modifynew": {
                if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) break;
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("cas_bankstatement_manual");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.getCustomParams().put("isModify", true);
                showParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\uff08\u4fee\u6539\uff09", (String)"BankStatementListPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                showParameter.getCustomParams().put("selectids", operationResult.getSuccessPkIds());
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifynew"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "barnew": {
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BankStatementManualEdit_11", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.refreshAndShowMsg(closedCallBackEvent, msg);
                break;
            }
            case "cas_importstart_extend": {
                BillList billList = (BillList)this.getControl("billlistap");
                if (billList == null) break;
                billList.refresh();
                break;
            }
            case "modifynew": {
                String msg = ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"BankStatementManualEdit_22", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.refreshAndShowMsg(closedCallBackEvent, msg);
                break;
            }
        }
    }

    private void refreshAndShowMsg(ClosedCallBackEvent closedCallBackEvent, String msg) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refreshData();
            this.getView().showSuccessNotification(msg);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        BillShowParameter showParameter;
        ListShowParameter sp;
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes == res && id.equals("CONFIRM_ADD_CALLBACK")) {
            sp = new ListShowParameter();
            sp.setBillFormId("bei_betransdetail_imp");
            sp.setStatus(OperationStatus.ADDNEW);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barnew"));
            this.getView().showForm((FormShowParameter)sp);
        } else if (MessageBoxResult.No == res && id.equals("CONFIRM_ADD_CALLBACK")) {
            showParameter = new BillShowParameter();
            showParameter.setFormId("cas_bankstatement_manual");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barnew"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (MessageBoxResult.Yes == res && id.equals("CONFIRM_ INTRODUCE_CALLBACK")) {
            sp = new ListShowParameter();
            sp.setBillFormId("bei_betransdetail_imp");
            sp.setStatus(OperationStatus.ADDNEW);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barnew"));
            this.getView().showForm((FormShowParameter)sp);
        } else if (MessageBoxResult.No == res && id.equals("CONFIRM_ INTRODUCE_CALLBACK")) {
            showParameter = new FormShowParameter();
            showParameter.setAppId("cas");
            showParameter.getCustomParams().put("ServiceAppId", this.getView().getFormShowParameter().getAppId());
            showParameter.getCustomParams().put("CheckRightAppId", this.getView().getFormShowParameter().getAppId());
            showParameter.getCustomParams().put("BillFormId", "cas_bankstatement");
            showParameter.getCustomParams().put("ListName", ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355", (String)"BankStatementListPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            showParameter.getCustomParams().put("ImportPlugin", "kd.fi.cas.formplugin.importplugin.BankStatementImportNewPlugin");
            showParameter.setFormId("cas_importstart_extend");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_importstart_extend"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private Long getDefalutOrgId(String permissionItem) {
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgIds = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankstatement", (String)permissionItem);
        Long defaultOrgId = null;
        if (orgIds.size() == 0) {
            if ("4730fc9f000007ae".equals(permissionItem)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u597d\u7684\u8d44\u91d1\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u94f6\u884c\u5bf9\u8d26\u5355\u3002", (String)"BankStatementListPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else {
            List cachedOrgList = this.getCachedOrgList();
            if (cachedOrgList != null) {
                for (int i = 0; i < cachedOrgList.size(); ++i) {
                    Long id;
                    String orgStr = cachedOrgList.get(i).toString().trim();
                    if (orgStr.isEmpty() || !orgIds.contains(id = Long.valueOf(orgStr))) continue;
                    defaultOrgId = id;
                    break;
                }
            }
            if (defaultOrgId == null) {
                Long loginOrgId = RequestContext.get().getOrgId();
                defaultOrgId = orgIds.contains(loginOrgId) ? loginOrgId : (Long)orgIds.toArray()[0];
            }
        }
        return defaultOrgId;
    }

    public boolean isTrack() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isTrack = formShowParameter.getCustomParam("isTrack");
        return EmptyUtil.isEmpty((Object)isTrack) ? false : (Boolean)isTrack;
    }
}

