/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.common.CasBillEdit;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementManualEdit
extends CasBillEdit
implements ClickListener {
    private static Log logger = LogFactory.getLog(BankStatementManualEdit.class);
    private static final String BEGINBALANCEAMT = "beginbalanceamt";
    private static final String ENDBALANCEAMT = "endbalanceamt";
    private static final String COUNTBALANCEAMT = "countbalanceamt";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initOrgF7();
        this.intAccountBankF7();
        this.fillCurrency();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "entryimport": {
                DynamicObject accountbankdy = this.getDynamicObject("accountbank");
                if (accountbankdy == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u548c\u5e01\u79cd\u3002", (String)"BankStatementManualEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.entryImportStart();
                break;
            }
            case "b_save": {
                BigDecimal endbalanceamt;
                IDataModel model = this.getModel();
                DynamicObjectCollection entryentities = model.getEntryEntity(ENTRYENTITY);
                BigDecimal beginbalanceamt = (BigDecimal)model.getValue(BEGINBALANCEAMT);
                if (beginbalanceamt == null || entryentities.size() <= 0 || (endbalanceamt = (BigDecimal)model.getValue(ENDBALANCEAMT)).compareTo((BigDecimal)model.getValue("balanceamt", entryentities.size() - 1)) == 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u6700\u540e\u4e00\u884c\u4f59\u989d\u4e0e\u5bf9\u8d26\u5355\u672b\u7b14\u4f59\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u81ea\u52a8\u586b\u5145\u529f\u80fd\u8fdb\u884c\u5237\u65b0\u3002", (String)"BankStatementManualEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        String formid = (String)paramMap.get("formid");
        Object isModify = paramMap.get("isModify");
        if ("cas_bankstatementimp".equals(formid)) {
            this.bindDataFromImportPage(paramMap);
        } else if (null != isModify && ((Boolean)isModify).booleanValue()) {
            this.getPageCache().put("isModify", String.valueOf(isModify));
            this.bindDataByModify(paramMap);
        } else {
            DynamicObject org = this.getDynamicObject("org");
            if (org != null && EmptyUtil.isNoEmpty((DynamicObject)org)) {
                this.getModel().setValue("org", org.getPkValue());
            } else {
                Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"cas_bankstatement", (String)"47156aff000000ac");
                if (orgList.size() > 0) {
                    boolean contain = orgList.contains(RequestContext.get().getOrgId());
                    this.getModel().setValue("org", contain ? Long.valueOf(RequestContext.get().getOrgId()) : orgList.toArray()[0]);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("sourcebilltype", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355", (String)"BankStatementManualEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    private void bindDataByModify(Map<String, Object> paramMap) {
        List selectIds = (List)paramMap.get("selectids");
        if (selectIds.isEmpty()) {
            return;
        }
        DynamicObject[] bankStatements = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement"));
        this.setHeadValues(bankStatements);
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.setEntryValues(Arrays.asList(bankStatements));
        this.setEnableProps();
    }

    private void setEnableProps() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "accountbank", "currency", "bar_addrow", "bar_deleterow", "m_entryimport"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"autosetbalanceamt", BEGINBALANCEAMT, ENDBALANCEAMT, "sortno"});
    }

    private void setHeadValues(DynamicObject[] bankStatements) {
        DynamicObject bankStatement = bankStatements[0];
        this.getModel().setValue("org", (Object)bankStatement.getDynamicObject("org").getLong("id"));
        this.getModel().setValue("accountbank", (Object)bankStatement.getDynamicObject("accountbank").getLong("id"));
        this.getModel().setValue("currency", (Object)bankStatement.getDynamicObject("currency").getLong("id"));
    }

    private void bindDataFromImportPage(Map<String, Object> paramMap) {
        JSONObject jsonObject = (JSONObject)paramMap.get("data");
        JSONObject org = jsonObject.getJSONObject("org1");
        this.getModel().setValue("org", (Object)org.getLong("id"));
        org = jsonObject.getJSONObject("accountbank1");
        this.getModel().setValue("accountbank", (Object)org.getLong("id"));
        org = jsonObject.getJSONObject("currency1");
        this.getModel().setValue("currency", (Object)org.getLong("id"));
        this.getModel().setValue(BEGINBALANCEAMT, (Object)jsonObject.getBigDecimal("init_balance1"));
        this.getModel().setValue("debitamounttotal", (Object)jsonObject.getBigDecimal("total_debitamount1"));
        this.getModel().setValue("creditamounttotal", (Object)jsonObject.getBigDecimal("total_creditamount1"));
        this.getModel().setValue(COUNTBALANCEAMT, (Object)jsonObject.getIntValue("deal_count1"));
        this.getModel().setValue(ENDBALANCEAMT, (Object)jsonObject.getBigDecimal("last_balance1"));
        this.getModel().deleteEntryRow(ENTRYENTITY, 0);
        String addKey = (String)paramMap.get("addKey");
        if (EmptyUtil.isEmpty((String)addKey)) {
            return;
        }
        this.getPageCache().put("addKey", addKey);
        this.getPageCache().put("source", "3");
        String[] addKeys = addKey.split(",");
        Object[] pkIds = new Long[addKeys.length];
        for (int i = 0; i < pkIds.length; ++i) {
            pkIds[i] = Long.valueOf(addKeys[i]);
        }
        logger.info("this time import count\uff1a{}", (Object)pkIds.length);
        Object[] bankStatements = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement"));
        if (EmptyUtil.isEmpty((Object[])bankStatements)) {
            return;
        }
        List<DynamicObject> resultList = Arrays.stream(bankStatements).filter(b -> "3".equals(b.getString("source"))).sorted(Comparator.comparing(c -> c.getLong("sortno"))).collect(Collectors.toList());
        for (Object bankStatement : bankStatements) {
            Optional<DynamicObject> notExistsOptional = resultList.stream().filter(arg_0 -> BankStatementManualEdit.lambda$bindDataFromImportPage$2((DynamicObject)bankStatement, arg_0)).findFirst();
            if (notExistsOptional.isPresent()) continue;
            resultList.add((DynamicObject)bankStatement);
        }
        this.setEntryValues(resultList);
    }

    private void setEntryValues(List<DynamicObject> resultList) {
        for (DynamicObject bankStatement : resultList) {
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("bankstatementid", (Object)bankStatement.getLong("id"), row);
            this.getModel().setValue("bizdate", (Object)bankStatement.getDate("bizdate"), row);
            this.getModel().setValue("description", (Object)bankStatement.getString("description"), row);
            this.getModel().setValue("debitamount", (Object)bankStatement.getBigDecimal("debitamount"), row);
            this.getModel().setValue("creditamount", (Object)bankStatement.getBigDecimal("creditamount"), row);
            this.getModel().setValue("balanceamt", (Object)bankStatement.getBigDecimal("balanceamt"), row);
            this.getModel().setValue("oppunitname", (Object)bankStatement.getString("oppunit"), row);
            this.getModel().setValue("oppbank", (Object)bankStatement.getString("oppbank"), row);
            this.getModel().setValue("oppaccountnumber", (Object)bankStatement.getString("oppaccountnumber"), row);
            this.getModel().setValue("settlementnumber", (Object)bankStatement.getString("settlementnumber"), row);
            this.getModel().setValue("bankcheckflag", (Object)bankStatement.getString("bankcheckflag"), row);
            this.getModel().setValue("bankvouvherno", (Object)bankStatement.getString("bankvouvherno"), row);
            this.getModel().setValue("bankdetailno", (Object)bankStatement.getString("bankdetailno"), row);
            this.getModel().setValue("sequencenumber", (Object)bankStatement.getString("sequencenumber"), row);
            this.getModel().setValue("sortno", (Object)bankStatement.getLong("sortno"), row);
            this.getModel().setValue("cashier", (Object)bankStatement.getString("cashier"), row);
            this.getModel().setValue("tradenumber", (Object)bankStatement.getString("tradenumber"), row);
            this.getModel().setValue("vouchernumber", (Object)bankStatement.getString("vouchernumber"), row);
            this.getModel().setValue("ratesdate", (Object)bankStatement.getDate("ratesdate"), row);
            this.getModel().setValue("transtime", (Object)bankStatement.getDate("transtime"), row);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "cas_entryimport": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                logger.info("EntryImport >> Data>> {}", (Object)SerializationUtils.toJsonString((Object)returnData));
                this.entryImportDataHandler(returnData);
                this.getPageCache().remove("cas_entryimportCache");
                this.totalLoans();
                this.totalLender();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        String propertyName = e.getProperty().getName();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int row = changeData[0].getRowIndex();
        switch (propertyName) {
            case "accountbank": {
                this.accountCashChanged();
                break;
            }
            case "bizdate": {
                this.endDateChanged(newValue, oldValue);
                break;
            }
            case "debitamount": {
                this.isNullAccountBank("debitamount", (BigDecimal)newValue, row);
                this.totalLoans();
                break;
            }
            case "creditamount": {
                this.isNullAccountBank("creditamount", (BigDecimal)newValue, row);
                this.totalLender();
                break;
            }
            case "balanceamt": {
                this.isNullAccountBank("balanceamt", (BigDecimal)newValue, row);
                break;
            }
            case "org": {
                String source = this.getPageCache().get("source");
                if (!EmptyUtil.isEmpty((String)source)) break;
                this.getPageCache().remove("addKey");
                break;
            }
            case "beginbalanceamt": {
                if (newValue == null) {
                    for (int i = 0; i < this.getModel().getEntryEntity(ENTRYENTITY).size(); ++i) {
                        this.getModel().setValue("balanceamt", null, i);
                    }
                    break;
                }
                this.isNullAccountBank(BEGINBALANCEAMT, (BigDecimal)newValue, 0);
                this.isNegativeJudge((BigDecimal)this.getModel().getValue(BEGINBALANCEAMT));
            }
        }
    }

    private void autoSetBalanceAmt() {
        this.totalLoans();
        this.totalLender();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryentities = model.getEntryEntity(ENTRYENTITY);
        BigDecimal beginbalanceamt = (BigDecimal)model.getValue(BEGINBALANCEAMT);
        BigDecimal endbalanceamt = (BigDecimal)model.getValue(ENDBALANCEAMT);
        if (beginbalanceamt != null) {
            for (int i = 0; i < entryentities.size(); ++i) {
                DynamicObject entryentity = (DynamicObject)entryentities.get(i);
                beginbalanceamt = beginbalanceamt.add(entryentity.getBigDecimal("creditamount")).subtract(entryentity.getBigDecimal("debitamount"));
                model.setValue("balanceamt", (Object)beginbalanceamt, i);
            }
            if (entryentities.size() > 0) {
                model.setValue("balanceamt", (Object)endbalanceamt, entryentities.size() - 1);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5bf9\u8d26\u5355\u521d\u59cb\u4f59\u989d\u3002", (String)"BankStatementManualEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateCountBalanceAmt() {
        this.getModel().updateCache();
        this.getModel().setValue(COUNTBALANCEAMT, (Object)this.getModel().getEntryEntity(ENTRYENTITY).size());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "b_save": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getPageCache().remove("addKey");
                String key = op.getOption().getVariableValue("key");
                String msg = op.getOption().getVariableValue("msg");
                if (msg != null) {
                    this.getView().showErrorNotification(msg);
                }
                if (key != null) {
                    this.getView().getModel().setDataChanged(false);
                    HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                    customParams.put("accountbank", this.getModel().getValue("accountbank"));
                    customParams.put("currency", this.getModel().getValue("currency"));
                    customParams.put(BEGINBALANCEAMT, this.getModel().getValue(BEGINBALANCEAMT));
                    customParams.put("debitamounttotal", this.getModel().getValue("debitamounttotal"));
                    customParams.put("creditamounttotal", this.getModel().getValue("creditamounttotal"));
                    customParams.put(COUNTBALANCEAMT, this.getModel().getValue(COUNTBALANCEAMT));
                    customParams.put(ENDBALANCEAMT, this.getModel().getValue(ENDBALANCEAMT));
                    customParams.put("addKey", key);
                    this.getView().returnDataToParent(customParams);
                    this.getView().close();
                }
                this.getPageCache().put("addKey", key);
                break;
            }
            case "deleteentry": {
                BigDecimal debitamounttotal = BigDecimal.ZERO;
                BigDecimal creditamounttotal = BigDecimal.ZERO;
                DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
                for (DynamicObject entrydy : entryentitys) {
                    debitamounttotal = debitamounttotal.add(entrydy.getBigDecimal("debitamount"));
                    creditamounttotal = creditamounttotal.add(entrydy.getBigDecimal("creditamount"));
                }
                this.getModel().setValue("debitamounttotal", (Object)debitamounttotal);
                this.getModel().setValue("creditamounttotal", (Object)creditamounttotal);
                break;
            }
            case "autosetbalanceamt": {
                this.autoSetBalanceAmt();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "b_save": {
                int errorCount = 0;
                int errorEntry = 0;
                DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY);
                for (int i = 0; i < entryEntitys.size(); ++i) {
                    DynamicObject entrydy = (DynamicObject)entryEntitys.get(i);
                    if (!CasHelper.isEmpty((Object)entrydy.getBigDecimal("debitamount")) || !CasHelper.isEmpty((Object)entrydy.getBigDecimal("creditamount"))) continue;
                    ++errorCount;
                    errorEntry = i;
                }
                if (errorCount > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u591a\u6761\uff1a\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"BankStatementManualEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (errorCount == 1) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"BankStatementManualEdit_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorEntry + 1));
                    return;
                }
                OperateOption op = OperateOption.create();
                String addkey = this.getPageCache().get("addKey");
                op.setVariableValue("add", addkey);
                op.setVariableValue("isModify", this.getPageCache().get("isModify"));
                String source = this.getPageCache().get("source");
                if (EmptyUtil.isEmpty((String)source)) {
                    op.setVariableValue("source", null);
                } else {
                    op.setVariableValue("source", source);
                }
                this.getView().invokeOperation("b_save", op);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.updateCountBalanceAmt();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.updateCountBalanceAmt();
    }

    private void initOrgF7() {
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl("org");
        f7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"cas_bankstatement", (String)"47156aff000000ac");
            showParameter.setCustomParam("range", new ArrayList(orgList));
        });
    }

    private void intAccountBankF7() {
        BasedataEdit acctCtr = (BasedataEdit)this.getControl("accountbank");
        acctCtr.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                QFilter usableAccountFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
                ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
                qFilterArrayList.add(usableAccountFilter);
                qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                showParameter.setIsolationOrg(false);
                showParameter.getListFilterParameter().getQFilters().addAll(qFilterArrayList);
            }
        });
    }

    private void accountCashChanged() {
        DynamicObject accountCash = this.getDynamicObject("accountbank");
        if (accountCash == null) {
            this.setValue("currency", null);
            return;
        }
        DynamicObjectCollection currencys = accountCash.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys) && currencys.size() > 1) {
            return;
        }
        DynamicObject defaultCurrency = accountCash.getDynamicObject("defaultcurrency");
        this.setValue("currency", defaultCurrency);
    }

    private void endDateChanged(Object newValue, Object oldValue) {
        Date date = (Date)newValue;
        Date date1 = new Date();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long id = org.getLong("id");
        DynamicObject initObj = PeriodHelper.getCasInitInfo((long)id);
        DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
        if (ExtendConfigHelper.isInitOnlySet() && currentperiod == null) {
            currentperiod = initObj.getDynamicObject("startperiod");
        }
        if (currentperiod == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\uff0c\u8bf7\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u540e\u518d\u64cd\u4f5c", (String)"BankStatementManualEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Date begindate = currentperiod.getDate("begindate");
        if ((date == null || begindate.compareTo(date) <= 0) && date != null && date.after(date1)) {
            this.getModel().setValue("bizdate", oldValue);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u662f\u5f53\u5929\u4e4b\u524d\u7684\u65e5\u671f\uff01", (String)"BankStatementManualEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void totalLoans() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            BigDecimal bd = BigDecimal.ZERO;
            for (DynamicObject entry : entryEntity) {
                bd = bd.add(entry.getBigDecimal("debitamount"));
            }
            this.getModel().setValue("debitamounttotal", (Object)bd);
        }
    }

    private void totalLender() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            BigDecimal bd = BigDecimal.ZERO;
            for (DynamicObject entry : entryEntity) {
                bd = bd.add(entry.getBigDecimal("creditamount"));
            }
            this.getModel().setValue("creditamounttotal", (Object)bd);
        }
    }

    private void isNullAccountBank(String big, BigDecimal newValue, int row) {
        DynamicObject dynamicObject = this.getDynamicObject("accountbank");
        DynamicObject dynamicObjectCurr = this.getDynamicObject("currency");
        BigDecimal def = BigDecimal.ZERO;
        if (BEGINBALANCEAMT.equals(big)) {
            def = null;
            if (newValue != null) {
                if (dynamicObject == null && dynamicObjectCurr == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u548c\u5e01\u79cd\u3002", (String)"BankStatementManualEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(big, (Object)def);
                } else if (dynamicObject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BankStatementManualEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(big, (Object)def);
                } else if (dynamicObjectCurr == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"BankStatementManualEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(big, (Object)def);
                }
            }
        } else if (def.compareTo(newValue) != 0) {
            if (dynamicObject == null && dynamicObjectCurr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u548c\u5e01\u79cd\u3002", (String)"BankStatementManualEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(big, (Object)def, row);
            } else if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BankStatementManualEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(big, (Object)def, row);
            } else if (dynamicObjectCurr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"BankStatementManualEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(big, (Object)def, row);
            }
        }
    }

    private void isNegativeJudge(BigDecimal value) {
        if (value != null && value.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6", (String)"BankStatementManualEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject accountCash = (DynamicObject)this.getModel().getValue("accountbank");
            if (accountCash != null) {
                Set currencys = AccountBankHelper.getCurrencyPks((long)accountCash.getLong("id"));
                qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
            }
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private void entryImportStart() {
        this.getPageCache().put("cas_entryimportCache", "true");
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("cas_entryimport");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        String billFormId = this.getModel().getDataEntityType().getName();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("BillFormId", billFormId);
        params.put("BillEntryId", ENTRYENTITY);
        showForm.setCustomParams(params);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_entryimport"));
        this.getView().showForm(showForm);
    }

    private void entryImportDataHandler(Map<String, Object> returnData) {
        BigDecimal debitamounttotal = BigDecimal.ZERO;
        BigDecimal creditamounttotal = BigDecimal.ZERO;
        BigDecimal creditamounttotalNum = BigDecimal.ZERO;
        BigDecimal debitamounttotalNum = BigDecimal.ZERO;
        BigDecimal debitamount = BigDecimal.ZERO;
        BigDecimal creditamount = BigDecimal.ZERO;
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Integer> deleteList = new ArrayList<Integer>(10);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject entrydy = (DynamicObject)entryEntitys.get(i);
            debitamounttotal = debitamounttotal.add(entrydy.getBigDecimal("debitamount"));
            creditamounttotalNum = creditamounttotal = creditamounttotal.add(entrydy.getBigDecimal("debitamount"));
            debitamounttotalNum = debitamounttotal;
            if (!CasHelper.isEmpty((Object)entrydy.getBigDecimal("debitamount")) || !CasHelper.isEmpty((Object)entrydy.getBigDecimal("creditamount")) || !CasHelper.isEmpty((Object)entrydy.getString("description")) || !CasHelper.isEmpty((Object)entrydy.getString("oppunitname")) || !CasHelper.isEmpty((Object)entrydy.getString("oppbank")) || !CasHelper.isEmpty((Object)entrydy.getString("oppaccountnumber")) || !CasHelper.isEmpty((Object)entrydy.getString("settlementtype")) || !CasHelper.isEmpty((Object)entrydy.getString("settlementnumber")) || !CasHelper.isEmpty((Object)entrydy.getString("bankcheckflag")) || !CasHelper.isEmpty((Object)entrydy.getString("bankvouvherno")) || !CasHelper.isEmpty((Object)entrydy.getString("sequencenumber")) || !CasHelper.isEmpty((Object)entrydy.getString("cashier")) || !CasHelper.isEmpty((Object)entrydy.getString("tradenumber")) || !CasHelper.isEmpty((Object)entrydy.getString("vouchernumber"))) continue;
            deleteList.add(i);
        }
        int[] deleteNum1 = new int[deleteList.size()];
        for (int k = 0; k < deleteList.size(); ++k) {
            deleteNum1[k] = (Integer)deleteList.get(k);
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, deleteNum1);
        deleteList.clear();
        List rowDatas = (List)returnData.get("rowDatas");
        StringBuilder errorInfo = new StringBuilder();
        boolean isdelete = false;
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            Map row = (Map)rowDatas.get(rowNum);
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            deleteList.add(rowIndex);
            creditamount = BigDecimal.ZERO;
            debitamount = BigDecimal.ZERO;
            try {
                block21: for (Map.Entry entry : row.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!(value != null && !CasHelper.isEmpty((Object)value) || !"entryentity_id".equals(key) && !"debitamount".equals(key) && !"creditamount".equals(key) && !"description".equals(key) && !"balanceamt".equals(key) && !"oppunitname".equals(key) && !"oppbank".equals(key) && !"oppaccountnumber".equals(key) && !"bankcheckflag".equals(key) && !"bankvouvherno".equals(key) && !"cashier".equals(key) && !"vouchernumber".equals(key))) continue;
                    IDataEntityProperty property = null;
                    property = this.getModel().getProperty(key);
                    if (property == null) continue;
                    switch (key) {
                        case "description": 
                        case "oppunitname": 
                        case "oppbank": {
                            this.isTextMax(key, property, value, row, errorInfo, rowIndex, isdelete);
                            continue block21;
                        }
                        case "debitamount": {
                            String agentPayBillEdit_17;
                            debitamount = new BigDecimal(value);
                            this.getModel().setValue("debitamounttotal", (Object)creditamounttotal);
                            if (creditamount.compareTo(BigDecimal.ZERO) != 0 && debitamount.compareTo(BigDecimal.ZERO) != 0) {
                                agentPayBillEdit_17 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\uff0c\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\uff0c\u540c\u4e00\u884c\u6570\u636e\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\u6570\u503c\u3002", (String)"BankStatementManualEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                                errorInfo.append(agentPayBillEdit_17);
                                isdelete = true;
                                continue block21;
                            }
                            debitamounttotal = debitamounttotal.add(debitamount);
                            this.getModel().setValue(key, (Object)debitamount, rowIndex);
                            continue block21;
                        }
                        case "creditamount": {
                            String agentPayBillEdit_17;
                            creditamount = new BigDecimal(value);
                            this.getModel().setValue("creditamounttotal", (Object)creditamounttotal);
                            if (debitamount.compareTo(BigDecimal.ZERO) != 0 && creditamount.compareTo(BigDecimal.ZERO) != 0) {
                                agentPayBillEdit_17 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\uff0c\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\uff0c\u540c\u4e00\u884c\u6570\u636e\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\u6570\u503c\u3002", (String)"BankStatementManualEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                                errorInfo.append(agentPayBillEdit_17);
                                isdelete = true;
                                continue block21;
                            }
                            creditamounttotal = creditamounttotal.add(creditamount);
                            this.getModel().setValue(key, (Object)creditamount, rowIndex);
                            continue block21;
                        }
                        case "bizdate": {
                            try {
                                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                                long id = org.getLong("id");
                                boolean cs096Boolean = SystemParameterHelper.getParameterBoolean((long)id, (String)"cs096");
                                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                                Date date = sf.parse(value);
                                if (!cs096Boolean) {
                                    Date begindate;
                                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)id);
                                    DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
                                    if (ExtendConfigHelper.isInitOnlySet() && currentperiod == null) {
                                        currentperiod = initObj.getDynamicObject("startperiod");
                                    }
                                    if ((begindate = currentperiod.getDate("begindate")).compareTo(date) > 0) {
                                        String agentPayBillEdit_19 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u201c%2$s\u201d\u5b57\u6bb5\uff0c\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6240\u9009\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u7684\u7b2c\u4e00\u65e5\u3002", (String)"BankStatementManualEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                                        errorInfo.append(agentPayBillEdit_19);
                                        isdelete = true;
                                        continue block21;
                                    }
                                } else if (date.compareTo(new Date()) > 0) {
                                    String agentPayBillEdit_20 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\uff0c\u65e5\u671f\u5fc5\u987b\u4e3a\u5f53\u5929\u4e4b\u524d\u7684\u65e5\u671f\u3002", (String)"BankStatementManualEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                                    errorInfo.append(agentPayBillEdit_20);
                                    isdelete = true;
                                    continue block21;
                                }
                                this.getModel().setValue(key, (Object)value, rowIndex);
                                continue block21;
                            }
                            catch (Exception e) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u53c2\u80032020-01-01\u3002", (String)"BankStatementManualEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                    this.getModel().setValue(key, (Object)value, rowIndex);
                }
                this.getModel().setValue("creditamounttotal", (Object)creditamounttotal);
                this.getModel().setValue("debitamounttotal", (Object)debitamounttotal);
                if (!isdelete) continue;
                throw new KDBizException(errorInfo.toString());
            }
            catch (KDBizException bizExp) {
                logger.error("EntryImport >> data >> ", (Throwable)bizExp);
                break;
            }
        }
        if (!CasHelper.isEmpty((Object)errorInfo.toString())) {
            int[] deleteNum2 = new int[deleteList.size()];
            for (int k = 0; k < deleteList.size(); ++k) {
                deleteNum2[k] = (Integer)deleteList.get(k);
            }
            this.getModel().deleteEntryRows(ENTRYENTITY, deleteNum2);
            this.getModel().setValue("debitamounttotal", (Object)debitamounttotalNum);
            this.getModel().setValue("creditamounttotal", (Object)creditamounttotalNum);
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u70b9\u51fb\u201c\u5c55\u793a\u8be6\u60c5\u201d\u67e5\u770b\u3002", (String)"BankStatementManualEdit_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        }
    }

    public void isTextMax(String key, IDataEntityProperty property, String value, Map<String, String> row, StringBuilder errorInfo, int rowIndex, boolean isdelete) {
        TextAreaProp text = new TextAreaProp();
        if (property instanceof TextAreaProp) {
            text = (TextAreaProp)property;
        }
        if (text.getMaxLenth() > 0 && value.length() > text.getMaxLenth()) {
            value = value.substring(0, text.getMaxLenth());
            String agentPayBillEdit_16 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236\uff0c\u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"BankStatementManualEdit_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
            errorInfo.append(agentPayBillEdit_16);
        } else {
            this.getModel().setValue(key, (Object)value, rowIndex);
        }
    }

    private static /* synthetic */ boolean lambda$bindDataFromImportPage$2(DynamicObject bankStatement, DynamicObject c) {
        return bankStatement.getString("id").equals(c.getString("id"));
    }
}

