/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.PaymentTypeEnum;
import kd.fi.cas.enums.RecTypeEnum;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.util.EmptyUtil;

public class BatchPayRecTypeEdit
extends DynamicFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String batchBillName;
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (parentModel.getProperty(propName) == null) continue;
            this.setValue(propName, parentModel.getValue(propName));
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        switch (batchBillName = (String)showParameter.getCustomParam("batchbillname")) {
            case "cas_batchpayapply": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applypayflex"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"paybillflex"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"recbillflex"});
                break;
            }
            case "cas_batchpaybill": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"applypayflex"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"paybillflex"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"recbillflex"});
                String entrance = (String)this.getModel().getValue("entrance");
                this.fillPayeeType(entrance, false);
                break;
            }
            case "cas_batchrecbill": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"applypayflex"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"paybillflex"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"recbillflex"});
                String biztype = (String)this.getModel().getValue("biztype");
                this.fillPayerType(biztype, false);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "paymenttype": {
                this.updateEntryPayeeType((DynamicObject)newValue);
                break;
            }
            case "entrance": {
                this.fillPayeeType((String)newValue, true);
                break;
            }
            case "biztype": {
                this.fillPayerType((String)newValue, true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                this.btnOk();
            }
        }
    }

    private void fillPayeeType(String entrance, boolean setDefaultValue) {
        ComboEdit payeetypeCbo = (ComboEdit)this.getView().getControl("payeetype");
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        if (PaymentTypeEnum.AP.name().equals(entrance)) {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
        } else {
            for (AsstActTypeEnum asstAct : AsstActTypeEnum.values()) {
                comboItem.add(new ComboItem(new LocaleString(asstAct.getName()), asstAct.getValue()));
            }
        }
        payeetypeCbo.setComboItems(comboItem);
        if (setDefaultValue) {
            this.getModel().setValue("payeetype", (Object)((ComboItem)comboItem.get(0)).getValue());
        }
    }

    private void updateEntryPayeeType(DynamicObject paymentType) {
        if (EmptyUtil.isEmpty((DynamicObject)paymentType)) {
            return;
        }
        ComboItem customerCI = new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue());
        ComboItem supplierCI = new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue());
        ComboItem employeeCI = new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue());
        ComboItem companyCI = new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue());
        ComboItem otherCI = new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue());
        String bizType = paymentType.getString("biztype");
        boolean isPartPay = paymentType.getBoolean("ispartpayment");
        ComboEdit ePayeeType = (ComboEdit)this.getView().getControl("e_payeetype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (PayAndRecBizTypeEnum.TRANSFER_SAME.getValue().equals(bizType) || PayAndRecBizTypeEnum.CASH_ACCESS.getValue().equals(bizType)) {
            comboItems.add(companyCI);
            ePayeeType.setComboItems(comboItems);
            ePayeeType.selectedStore(companyCI);
        }
        if (isPartPay) {
            comboItems.add(supplierCI);
            comboItems.add(customerCI);
            comboItems.add(employeeCI);
            ePayeeType.setComboItems(comboItems);
        } else {
            comboItems.add(supplierCI);
            comboItems.add(customerCI);
            if (!comboItems.contains(companyCI)) {
                comboItems.add(companyCI);
            }
            comboItems.add(employeeCI);
            comboItems.add(otherCI);
            ePayeeType.setComboItems(comboItems);
        }
    }

    private void fillPayerType(String rectype, boolean setDefaultValue) {
        ComboEdit payertypeList = (ComboEdit)this.getView().getControl("payertype");
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        if (rectype.equals(RecTypeEnum.OtherRec.toString())) {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
        } else {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
        }
        payertypeList.setComboItems(comboItem);
        if (setDefaultValue) {
            this.getModel().setValue("payertype", (Object)((ComboItem)comboItem.get(0)).getValue());
        }
    }

    private void btnOk() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("paymenttype", this.getValue("paymenttype"));
        resultMap.put("e_payeetype", this.getValue("e_payeetype"));
        resultMap.put("entrance", this.getValue("entrance"));
        resultMap.put("payeetype", this.getValue("payeetype"));
        resultMap.put("biztype", this.getValue("biztype"));
        resultMap.put("payertype", this.getValue("payertype"));
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }
}

