/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.check.CheckByHandHelper;
import kd.fi.cas.business.journal.SourceNumber;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.CheckedResultSourceEnum;
import kd.fi.cas.formplugin.helper.UnCheckExportHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.util.CreateExcelUtil;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CheckResultPlugin
extends AbstractFormPlugin
implements ListRowClickListener,
SetFilterListener {
    private static final Log logger = LogFactory.getLog(CheckResultPlugin.class);
    protected static final String[] exportFieldSheet1 = new String[]{"company.number", "company.name", "accountbank", "accountbank.name", "accountbank.bankaccountnumber", "currency", "checktype", "checkdate"};
    protected static final String[] exportFieldSheet2 = new String[]{"company.number", "company.name", "accountbank", "accountbank.name", "accountbank.bankaccountnumber", "currency", "checktype", "checkdate", "bizobject", "bizdate", "debitamount", "creditamount", "oppunit", "description", "bankcheckflag", "matchcode", "settlementnumber", "vouchernumber", "pddate", "avddate", "sysdate", "settlementtype.name", "oppacctnumber", "balanceamt", "sourcebillnumber", "tradenumber", "bankvouvherno", "ischeck", "source", "cashier.name"};
    private static final String EXPORT_UNCHECK = "exportuncheck";
    private BalanceCountService balanceCountService = new BalanceCountService();
    private static final String CAS_CHECK_RESULT_CALLBACK = "CasCheckResultCallBack";
    private static final String CHECK_RESULT_LOCK_OP = "CheckResultPage";
    private static final String PAGE_CACHE_VIEW = "ViewCheckResult";
    private static final String SPLIT_STRING = "_";

    public void initialize() {
        super.initialize();
        BillList checkedBillList = (BillList)this.getControl("billlistap_checked");
        checkedBillList.setOrderBy("checkdate");
        BillList stateBillList = (BillList)this.getControl("billlistap_state");
        stateBillList.setOrderBy("bizdate,creditamount,debitamount");
        BillList journalBillList = (BillList)this.getControl("billlistap_journal");
        journalBillList.setOrderBy("bizdate,creditamount,debitamount");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tabpageap_unchecked", "tabpageap_checked", "showdetail"});
        this.addItemClickListeners(new String[]{"refresh", "check", "uncheck", "checkset", "toolbarap", "showdetail", EXPORT_UNCHECK});
        BillList bankaccbilllistap = (BillList)this.getControl("billlistap_journal");
        bankaccbilllistap.addHyperClickListener((HyperLinkClickListener)new /* Unavailable Anonymous Inner Class!! */);
        BillList checkBilllist = (BillList)this.getControl("billlistap_checked");
        checkBilllist.addListRowClickListener((ListRowClickListener)new /* Unavailable Anonymous Inner Class!! */);
        BillList statmBilllist = (BillList)this.getControl("billlistap_state");
        statmBilllist.addListRowClickListener((ListRowClickListener)new /* Unavailable Anonymous Inner Class!! */);
        statmBilllist.addClearSelectionListener((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        statmBilllist.addListRowSelectAllListeners((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        BillList journalBilllist = (BillList)this.getControl("billlistap_journal");
        journalBilllist.addListRowClickListener((ListRowClickListener)new /* Unavailable Anonymous Inner Class!! */);
        journalBilllist.addListRowSelectAllListeners((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        journalBilllist.addClearSelectionListener((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)new /* Unavailable Anonymous Inner Class!! */);
        BillList checkedBillList = (BillList)this.getControl("billlistap_checked");
        checkedBillList.addSetFilterListener((SetFilterListener)this);
        BillList stateBillList = (BillList)this.getControl("billlistap_state");
        stateBillList.addSetFilterListener((SetFilterListener)this);
        BillList journalBillList = (BillList)this.getControl("billlistap_journal");
        journalBillList.addSetFilterListener((SetFilterListener)this);
        Search search_state = (Search)this.getControl("searchap_state");
        search_state.addEnterListener(event -> this.quickSearch(stateBillList, event));
        Search search_journal = (Search)this.getControl("searchap_journal");
        search_journal.addEnterListener(event -> this.quickSearch(journalBillList, event));
        Search search_result = (Search)this.getControl("searchap_result");
        search_result.addEnterListener((SearchEnterListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void afterCreateNewData(EventObject e) {
        boolean authorityAccount;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orgId = Long.parseLong(customParams.get("orgid").toString());
        long accountBankId = Long.parseLong(customParams.get("accountbankid").toString());
        long currencyId = Long.parseLong(customParams.get("currencyid").toString());
        boolean verifyStatus = (Boolean)customParams.get("verifystatus");
        this.checkSyncOpen(kd.fi.cas.util.StringUtils.joinKeyString((String)SPLIT_STRING, (Object[])new Object[]{orgId, accountBankId, currencyId}));
        model.setValue("org", (Object)orgId);
        model.setValue("accountbank", (Object)accountBankId);
        model.setValue("currency", (Object)currencyId);
        model.setValue("verifystatus", (Object)verifyStatus);
        Date beginDate = customParams.get("bizdate") != null ? DateUtils.stringToDate((String)customParams.get("bizdate").toString(), (String)"yyyy-MM-dd HH:mm:ss") : null;
        Date endDate = customParams.get("bizdateend") != null ? DateUtils.stringToDate((String)customParams.get("bizdateend").toString(), (String)"yyyy-MM-dd HH:mm:ss") : null;
        model.setValue("begindate", (Object)beginDate);
        model.setValue("enddate", (Object)endDate);
        Tab tab = (Tab)this.getControl("tabap");
        if (!verifyStatus) {
            tab.activeTab("tabpageap_checked");
            view.setVisible(Boolean.valueOf(false), new String[]{"check", "autocheck", "more"});
            view.setVisible(Boolean.valueOf(true), new String[]{"uncheck"});
        } else {
            tab.activeTab("tabpageap_unchecked");
            view.setVisible(Boolean.valueOf(true), new String[]{"check", "autocheck", "more"});
            view.setVisible(Boolean.valueOf(false), new String[]{"uncheck"});
        }
        Object org = model.getValue("org");
        Object accountBank = model.getValue("accountbank");
        if (org != null && accountBank != null && !(authorityAccount = AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)accountBank), (DynamicObject)((DynamicObject)org)))) {
            view.setVisible(Boolean.valueOf(false), new String[]{"newbalance"});
        }
        Date balanceEndDate = customParams.get("bizdateend") != null ? DateUtils.stringToDate((String)customParams.get("bizdateend").toString(), (String)"yyyy-MM-dd") : null;
        model.setValue("bizdateend", (Object)balanceEndDate);
        try {
            boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
            if (!useBalanceModel) {
                this.getBalance(balanceEndDate, accountBankId, currencyId);
            } else {
                BigDecimal journalMontBalance = this.balanceCountService.queryByBalanceModel(BalanceType.JOURNAL, orgId, accountBankId, currencyId, beginDate, endDate);
                BigDecimal stateMonthBalance = this.balanceCountService.queryByBalanceModel(BalanceType.STATE, orgId, accountBankId, currencyId, beginDate, endDate);
                this.getModel().setValue("stmtamt", (Object)stateMonthBalance);
                this.getModel().setValue("journalamt", (Object)journalMontBalance);
            }
        }
        catch (Exception e1) {
            logger.error("error:", (Throwable)e1);
            throw new KDBizException("Check Result Error");
        }
        this.refresh();
    }

    private void checkSyncOpen(String pkId) {
        boolean locked = MutexServiceHelper.request((String)pkId, (String)"cas_checkresult", (String)CHECK_RESULT_LOCK_OP);
        if (!locked) {
            Long userid;
            DynamicObject userObj;
            Map lockInfo = MutexServiceHelper.getLockInfo((String)pkId, (String)"cas_checkresult", (String)CHECK_RESULT_LOCK_OP);
            String userName = "";
            String number = "";
            if (lockInfo != null && lockInfo.size() > 0 && (userObj = BusinessDataServiceHelper.loadSingle((Object)(userid = Long.valueOf((String)lockInfo.get("userid"))), (String)"bos_user")) != null) {
                userName = userObj.getString("name");
                number = userObj.getString("number");
            }
            String msg = "";
            msg = kd.fi.cas.util.StringUtils.isNotEmpty((String)userName) ? String.format(ResManager.loadKDString((String)"\u5f53\u524d\u624b\u5de5\u5bf9\u8d26\u754c\u9762\u5df2\u88ab\u7528\u6237\u3010%1$s(\u5de5\u53f7\uff1a%2$s)\u3011\u5360\u7528\uff0c\u662f\u5426\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\uff1f", (String)"CheckResultPlugin_34", (String)"fi-cas-formplugin", (Object[])new Object[0]), userName, number) : ResManager.loadKDString((String)"\u5f53\u524d\u624b\u5de5\u5bf9\u8d26\u754c\u9762\u5df2\u88ab\u4ed6\u4eba\u5360\u7528\uff0c\u662f\u5426\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\uff1f", (String)"CheckResultPlugin_33", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CAS_CHECK_RESULT_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void click(EventObject evt) {
        Label label;
        super.click(evt);
        if (evt.getSource() instanceof Label && "showdetail".equalsIgnoreCase((label = (Label)evt.getSource()).getKey())) {
            BillList billList = (BillList)this.getControl("billlistap_checked");
            ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("cas_showcheckeddetail");
            parameter.setCustomParam("billId", selectedRow.getPrimaryKeyValue());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "unreachdata": {
                this.refresh();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String appId = this.getView().getFormShowParameter().getAppId();
        long orgId = dataEntity.getDynamicObject("org").getLong("id");
        boolean hasPermission = false;
        switch (key) {
            case "check": {
                boolean checkSuccess = this.handCheck("1");
                if (checkSuccess) {
                    this.refresh();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u52fe\u5bf9\u6210\u529f\u3002", (String)"CheckResultPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                this.doNeedRefresh(checkSuccess);
                break;
            }
            case "difcheck": {
                boolean checkSuccess = this.handCheck("2");
                if (checkSuccess) {
                    this.refresh();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5dee\u989d\u52fe\u5bf9\u6210\u529f\u3002", (String)"CheckResultPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                this.doNeedRefresh(checkSuccess);
                break;
            }
            case "sglcheck": {
                boolean checkSuccess = this.handCheckSingle();
                if (checkSuccess) {
                    this.refresh();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u8fb9\u52fe\u5bf9\u6210\u529f\u3002", (String)"CheckResultPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                this.doNeedRefresh(checkSuccess);
                break;
            }
            case "uncheck": {
                boolean checkAdjustByDate;
                IFormView view = this.getView();
                BillList checkedBillList = (BillList)this.getControl("billlistap_checked");
                ListSelectedRowCollection checkedBillRows = checkedBillList.getSelectedRows();
                if (checkedBillRows.size() == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckResultPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                int billCount = checkedBillRows.getPrimaryKeyValues().length;
                HashSet<Long> checkedBillIds = new HashSet<Long>();
                for (ListSelectedRow checkedBillRow : checkedBillRows) {
                    Long checkedBillId = (Long)checkedBillRow.getPrimaryKeyValue();
                    checkedBillIds.add(checkedBillId);
                }
                Map unCheckId = CheckByHandHelper.reverseCheck(checkedBillIds, (boolean)true, (IFormView)view, null);
                Set unCheckIdByVoucher = (Set)unCheckId.get("Voucher");
                Set unCheckIdByBalance = (Set)unCheckId.get("Balance");
                boolean balanceNoEmpty = EmptyUtil.isNoEmpty((Object)unCheckIdByBalance);
                HashSet allUnCheckId = new HashSet(billCount);
                if (EmptyUtil.isNoEmpty((Object)unCheckIdByVoucher)) {
                    allUnCheckId.addAll(unCheckIdByVoucher);
                }
                if (balanceNoEmpty) {
                    allUnCheckId.addAll(unCheckIdByBalance);
                }
                String sourceBillNumbers = view.getPageCache().get("sourceBillNumbers");
                if (EmptyUtil.isNoEmpty((Object)unCheckIdByVoucher)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u53f7\u201c%s\u201d\u5bf9\u5e94\u7684\u4e0a\u6e38\u51ed\u8bc1\u5f53\u524d\u6b63\u5728\u7f16\u8f91\u9501\u5b9a\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u5bf9\u8d26\uff0c\u82e5\u9700\u64a4\u9500\u5bf9\u8d26\u8bf7\u5148\u5b8c\u6210\u51ed\u8bc1\u590d\u6838\u3002", (String)"CheckByHandHelper_7", (String)"fi-cas-formplugin", (Object[])new Object[]{sourceBillNumbers}));
                    return;
                }
                if (allUnCheckId.size() != billCount) {
                    this.refresh();
                }
                if ((checkAdjustByDate = CheckByHandHelper.checkAdjustByDate((Long)orgId)) && balanceNoEmpty) {
                    StringBuilder str = new StringBuilder();
                    unCheckIdByBalance.forEach(c -> str.append(c).append(","));
                    String strIds = str.toString();
                    if (CasHelper.isNotEmpty((Object)strIds) && strIds.length() >= 1) {
                        strIds = strIds.substring(0, strIds.length() - 1);
                    }
                    this.getPageCache().put("uncheckid", strIds);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u53cd\u52fe\u5bf9\u7684\u65e5\u8bb0\u8d26\u548c\u5bf9\u8d26\u5355\u5df2\u7ecf\u751f\u6210\u4e86\u975e\u6682\u5b58\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u7ee7\u7eed\u53cd\u52fe\u5bf9\u53ef\u80fd\u5bfc\u81f4\u539f\u4f59\u989d\u8c03\u8282\u8868\u4e2d\u8c03\u6574\u540e\u4f59\u989d\u4e0d\u51c6\u786e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CheckResultPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CHECKADJUST_CALLBACK", (IFormPlugin)this));
                    return;
                }
                String billStatus = this.getPageCache().get("billstatus");
                if (billCount == 1 && balanceNoEmpty && unCheckIdByBalance.size() == billCount) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868%s\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u5bf9\u8d26", (String)"CheckByHandHelper_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), BillStatusEnum.SUBMIT.getValue().equals(billStatus) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"CheckByHandHelper_5", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"CheckByHandHelper_6", (String)"fi-cas-formplugin", (Object[])new Object[0])));
                    return;
                }
                if (balanceNoEmpty && billCount - unCheckIdByBalance.size() >= 0) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5df2\u64a4\u9500\u52fe\u5bf9%1$s\u6761\u8bb0\u5f55\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"CheckResultPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), billCount, billCount - unCheckId.size(), unCheckId.size()), ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868\u5df2\u63d0\u4ea4/\u5df2\u5ba1\u6279\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u5bf9\u8d26", (String)"CheckResultPlugin_28", (String)"fi-cas-formplugin", (Object[])new Object[0]), null);
                    return;
                }
                if (allUnCheckId.size() != 0) break;
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u64a4\u9500\u5bf9\u8d26%s\u6761\u8bb0\u5f55\u3002", (String)"CheckResultPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), billCount));
                break;
            }
            case "unchechkrule": {
                if (!this.unCheckByRule()) break;
                this.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u5bf9\u8d26\u6210\u529f\u3002", (String)"CheckResultPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "refresh": {
                this.refresh();
                break;
            }
            case "newbalance": {
                boolean hasNewPerm = PermissionHelper.checkCurrentUserPermission((long)orgId, (String)"cas_bankvccheck", (String)"0QEETXG4R41/");
                if (hasNewPerm) {
                    DynamicObject startPeriod;
                    Date startPeriodBegin;
                    if (this.getModel().getValue("enddate") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckResultPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)org.getLong("id"));
                    boolean isFinished = initObj.getBoolean("isfinishinit");
                    DynamicObject startperiod = initObj.getDynamicObject("startperiod");
                    if (!isFinished && (startperiod == null || EmptyUtil.isEmpty((DynamicObject)startperiod))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u3002", (String)"BankVcAdjustValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), org.getString("name")));
                        return;
                    }
                    QFilter filterRecEdc = new QFilter("org", "=", org.getPkValue());
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filterRecEdc});
                    if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u672a\u542f\u7528\u5bf9\u8d26\uff0c\u65e0\u9700\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868!", (String)"CheckResultPlugin_29", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Date dateEnd = (Date)this.getModel().getValue("enddate");
                    if (dateEnd.compareTo(startPeriodBegin = (startPeriod = dynamicObject.getDynamicObject("recperiod")).getDate("begindate")) < 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u5f53\u524d\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u542f\u7528\u5bf9\u8d26\u671f\u95f4\u7b2c\u4e00\u65e5\uff0c\u65e0\u9700\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868!", (String)"CheckResultPlugin_31", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String balance = this.getBalance();
                    if (!CasHelper.isEmpty((Object)balance) && balance.length() > 1) {
                        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u4f1a\u8986\u76d6%s\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CheckResultPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), balance), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_BALANCE_CALLBACK", (IFormPlugin)this));
                        return;
                    }
                    if (BillStatusEnum.SUBMIT.getValue().equals(balance)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u5f53\u65e5\u4f59\u989d\u8c03\u8282\u8868\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210!", (String)"CheckResultPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (BillStatusEnum.AUDIT.getValue().equals(balance)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u5f53\u65e5\u4f59\u989d\u8c03\u8282\u8868\u5df2\u5ba1\u6279\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"CheckResultPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().invokeOperation("balance");
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u624b\u5de5\u5bf9\u8d26\u201d\u7684\u64cd\u4f5c\u201c\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckResultPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "lookbalance": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter filterRecEdc = new QFilter("org", "=", org.getPkValue());
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filterRecEdc});
                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u672a\u542f\u7528\u5bf9\u8d26\uff0c\u65e0\u9700\u9884\u89c8\u4f59\u989d\u8c03\u8282\u8868\uff01", (String)"CheckResultPlugin_30", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean hasViewPerm = PermissionHelper.checkCurrentUserPermission((long)orgId, (String)"cas_bankvccheck", (String)"0QEEW5JO7058");
                if (hasViewPerm) {
                    ShowType showType;
                    BillShowParameter parameter = new BillShowParameter();
                    parameter.setFormId("cas_balanceadjust");
                    parameter.setCustomParam("org", (Object)orgId);
                    parameter.setCustomParam("accountbank", (Object)dataEntity.getDynamicObject("accountbank").getLong("id"));
                    parameter.setCustomParam("currency", (Object)dataEntity.getDynamicObject("currency").getLong("id"));
                    parameter.setCustomParam("enddate", (Object)DateUtils.getBeforeDate((Date)dataEntity.getDate("enddate"), (Date)new Date()));
                    ShowType parentshowType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
                    if (parentshowType == ShowType.Modal) {
                        showType = ShowType.Modal;
                    } else {
                        showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
                        parameter.getOpenStyle().setTargetKey("tabap");
                    }
                    parameter.getOpenStyle().setShowType(showType);
                    parameter.setStatus(OperationStatus.EDIT);
                    this.getView().showForm((FormShowParameter)parameter);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u624b\u5de5\u5bf9\u8d26\u201d\u7684\u201c\u9884\u89c8\u4f59\u989d\u8c03\u8282\u8868\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u201c\u7ec4\u7ec7\u9884\u89c8\u4f59\u989d\u8c03\u8282\u8868\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckResultPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "checkset": {
                boolean hasPerm = PermissionHelper.checkCurrentUserPermission((long)orgId, (String)"cas_bankvccheck", (String)"0C4GTWNOP=IC");
                if (!hasPerm) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u624b\u5de5\u5bf9\u8d26\u201d\u7684\u64cd\u4f5c\u201c\u5bf9\u8d26\u89c4\u5219\u8bbe\u7f6e\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckResultPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> orgIdList = new ArrayList<Long>();
                orgIdList.add(this.getModel().getDataEntity().getDynamicObject("org").getLong("id"));
                BillShowParameter parameterSet = new BillShowParameter();
                parameterSet.setFormId("cas_reconciliationrule");
                parameterSet.getOpenStyle().setShowType(ShowType.Modal);
                parameterSet.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checkset"));
                parameterSet.setCustomParam("orgList", orgIdList.stream().distinct().collect(Collectors.toList()));
                this.getView().showForm((FormShowParameter)parameterSet);
                break;
            }
            case "exportexcel": {
                hasPermission = PermissionHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankvccheck", (String)"4FT13VAN74HJ");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u5df2\u5bf9\u8d26\u7ed3\u679c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckResultPlugin_36", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                Set<Long> selectedIdList = this.getSelectedIdList();
                if (selectedIdList == null || selectedIdList.size() == 0) {
                    BillList s = (BillList)this.getView().getControl("billlistap_checked");
                    s.selectAllRows();
                    selectedIdList = this.getSelectedIdList();
                    s.clearSelection();
                    s.refresh();
                    if (selectedIdList == null || selectedIdList.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"ExportExcelErrorCode_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                this.exportExcelFile(selectedIdList);
                break;
            }
            case "exportuncheck": {
                hasPermission = PermissionHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankvccheck", (String)"4FT19/GI92BJ");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u672a\u5bf9\u8d26\u7ed3\u679c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckResultPlugin_37", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.exportUnCheck();
                break;
            }
        }
    }

    private void doNeedRefresh(boolean checkSuccess) {
        if (!checkSuccess && "true".equals(this.getPageCache().get("needRefresh"))) {
            this.refresh();
            this.getPageCache().remove("needRefresh");
        }
    }

    private void exportUnCheck() {
        HashMap<String, DynamicObject[]> unCheckSelectedIdMapSet = new HashMap<String, DynamicObject[]>(4);
        int size = this.getUnCheckSelectedObjectMapArr(unCheckSelectedIdMapSet);
        if (size == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"ExportExcelErrorCode_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        UnCheckExportHelper unCheckExportHelper = UnCheckExportHelper.getInstance();
        String[] exportTitleSheet = UnCheckExportHelper.getExportUnCheckHeadTitle();
        SXSSFWorkbook wb = new SXSSFWorkbook(-1);
        ArrayList exportEntitySheet = new ArrayList(size);
        for (Map.Entry entry : unCheckSelectedIdMapSet.entrySet()) {
            unCheckExportHelper.doExprotUnCheckBatch(exportEntitySheet, (String)entry.getKey(), (DynamicObject[])entry.getValue());
        }
        String excelName = ResManager.loadKDString((String)"\u672a\u5bf9\u8d26\u8bb0\u5f55", (String)"BankVCCheckList_22", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        CreateExcelUtil.createExcelFile((SXSSFWorkbook)wb, (String)excelName, (String[])exportTitleSheet, exportEntitySheet);
        try {
            excelName = CreateExcelUtil.getTempFilename1((String)excelName);
            String fileUrl = CreateExcelUtil.writeFile((SXSSFWorkbook)wb, (String)excelName);
            this.getView().download(fileUrl);
        }
        catch (KDException e) {
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private int getUnCheckSelectedObjectMapArr(Map<String, DynamicObject[]> map) {
        Set<Long> billlistap_state = this.getAllIdSetIfUncheck("billlistap_state");
        Set<Long> billlistap_journal = this.getAllIdSetIfUncheck("billlistap_journal");
        Object[] bankCheck = null;
        Object[] bankDaily = null;
        if (!CollectionUtils.isEmpty(billlistap_state)) {
            bankCheck = BusinessDataServiceHelper.load((Object[])billlistap_state.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_bankstatement"));
        }
        if (!CollectionUtils.isEmpty(billlistap_journal)) {
            bankDaily = BusinessDataServiceHelper.load((Object[])billlistap_journal.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_bankjournal"));
        }
        int size = 0;
        if (bankCheck != null && EmptyUtil.isNoEmpty((Object[])bankCheck)) {
            size += bankCheck.length;
        }
        if (bankDaily != null && EmptyUtil.isNoEmpty((Object[])bankDaily)) {
            size += bankDaily.length;
        }
        map.put("bankcheck", (DynamicObject[])bankCheck);
        map.put("bankdaily", (DynamicObject[])bankDaily);
        return size;
    }

    private Set<Long> getAllIdSetIfUncheck(String control) {
        BillList billList = (BillList)this.getControl(control);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            billList.selectAllRows();
            selectedRows = billList.getSelectedRows();
            billList.clearSelection();
            billList.refresh();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                return new HashSet<Long>(2);
            }
            return selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
        }
        return selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
    }

    protected static String[] getExportHeadTitle() {
        String[] exportHeadTitle = new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"CheckResultPlugin_ExportExcelH_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"CheckResultPlugin_ExportExcelH_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"CheckResultPlugin_ExportExcelH_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u540d\u79f0", (String)"CheckResultPlugin_ExportExcelH_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"CheckResultPlugin_ExportExcelH_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CheckResultPlugin_ExportExcelH_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u5f0f", (String)"CheckResultPlugin_ExportExcelH_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u8d26\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"CheckResultPlugin_ExportExcelH_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"CheckResultPlugin_ExportExcelH_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"CheckResultPlugin_ExportExcelH_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u65b9\u6237\u540d", (String)"CheckResultPlugin_ExportExcelH_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6458\u8981", (String)"CheckResultPlugin_ExportExcelH_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u8d26\u6807\u8bc6\u7801", (String)"CheckResultPlugin_ExportExcelH_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5339\u914d\u7801", (String)"CheckResultPlugin_ExportExcelH_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u53f7", (String)"CheckResultPlugin_ExportExcelH_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7", (String)"CheckResultPlugin_ExportExcelH_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u671f\u671b\u4ed8\u6b3e\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7cfb\u7edf\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"CheckResultPlugin_ExportExcelH_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"CheckResultPlugin_ExportExcelH_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f59\u989d", (String)"CheckResultPlugin_ExportExcelH_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u53f7", (String)"CheckResultPlugin_ExportExcelH_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u8003\u53f7", (String)"CheckResultPlugin_ExportExcelH_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u6d41\u6c34\u53f7", (String)"CheckResultPlugin_ExportExcelH_26", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f\u5426\u52fe\u5bf9", (String)"CheckResultPlugin_ExportExcelH_27", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6765\u6e90", (String)"CheckResultPlugin_ExportExcelH_28", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51fa\u7eb3", (String)"CheckResultPlugin_ExportExcelH_29", (String)"fi-cas-formplugin", (Object[])new Object[0])};
        return exportHeadTitle;
    }

    public void exportExcelFile(Set<Long> selectedData) {
        SXSSFWorkbook wb = new SXSSFWorkbook(-1);
        Object exportDetail = null;
        String[] exportTitleSheet2 = CheckResultPlugin.getExportHeadTitle();
        ArrayList exportEntitySheet2 = new ArrayList(selectedData.size());
        for (Long id : selectedData) {
            DynamicObject dyObj1 = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_checkedresult");
            DynamicObjectCollection dynamicObjectCollection = dyObj1.getDynamicObjectCollection("entry");
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(exportFieldSheet1.length);
            int amtPrecision = 0;
            String[] stringArray = exportFieldSheet1;
            int n = stringArray.length;
            block26: for (int i = 0; i < n; ++i) {
                String str;
                switch (str = stringArray[i]) {
                    case "accountbank": {
                        DynamicObject tempDyn;
                        if (dyObj1.getDynamicObject("accountbank") == null || (tempDyn = BusinessDataServiceHelper.loadSingle((Object)dyObj1.getDynamicObject("accountbank").getPkValue(), (String)"bd_accountbanks")).get("bank.bank_cate") == null) continue block26;
                        details.put(str, ((OrmLocaleValue)tempDyn.get("bank.bank_cate.name")).getLocaleValue());
                        continue block26;
                    }
                    case "currency": {
                        if (dyObj1.getDynamicObject("currency") == null) continue block26;
                        details.put(str, dyObj1.getString("currency.name"));
                        DynamicObject currency = dyObj1.getDynamicObject("currency");
                        amtPrecision = currency.getInt("amtprecision");
                        continue block26;
                    }
                    case "checktype": {
                        String tempStr = dyObj1.getString("checktype");
                        if (StringUtils.equals((CharSequence)tempStr, (CharSequence)"byauto")) {
                            tempStr = ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26", (String)"CheckResultPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                        } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)"byhand")) {
                            tempStr = ResManager.loadKDString((String)"\u624b\u5de5\u5bf9\u8d26", (String)"CheckResultPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                        }
                        details.put(str, tempStr);
                        continue block26;
                    }
                    default: {
                        details.put(str, dyObj1.get(str));
                    }
                }
            }
            Object res = null;
            for (DynamicObject dyObj2 : dynamicObjectCollection) {
                LinkedHashMap details1 = new LinkedHashMap(exportFieldSheet2.length);
                int count = 0;
                for (Map.Entry entry : details.entrySet()) {
                    if (count++ > 7) break;
                    details1.put(entry.getKey(), entry.getValue());
                }
                String tempStr = "";
                block29: for (int i = 8; i < exportFieldSheet2.length; ++i) {
                    String str = exportFieldSheet2[i];
                    try {
                        res = dyObj2.get(str);
                    }
                    catch (ORMDesignException e) {
                        res = null;
                    }
                    switch (str) {
                        case "bizobject": {
                            if (res == null) {
                                details1.put(str, null);
                                continue block29;
                            }
                            tempStr = res.toString();
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)"cas_bankstatement")) {
                                tempStr = ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355", (String)"CheckResultPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)"cas_bankjournal")) {
                                tempStr = ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"CheckResultPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                            }
                            details1.put(str, tempStr);
                            continue block29;
                        }
                        case "source": {
                            if (res == null) {
                                details1.put(str, null);
                                continue block29;
                            }
                            tempStr = res.toString();
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.BNKK_TRANSDOWNLOAD.getValue())) {
                                details1.put(str, CheckedResultSourceEnum.BNKK_TRANSDOWNLOAD.getName());
                                continue block29;
                            }
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.INNER_FIN_DOWNLOAD.getValue())) {
                                details1.put(str, CheckedResultSourceEnum.INNER_FIN_DOWNLOAD.getName());
                                continue block29;
                            }
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.INTRODUCE_BYHAND.getValue())) {
                                details1.put(str, CheckedResultSourceEnum.INTRODUCE_BYHAND.getName());
                                continue block29;
                            }
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.ADD_BYHAND.getValue())) {
                                details1.put(str, CheckedResultSourceEnum.ADD_BYHAND.getName());
                                continue block29;
                            }
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.ENTER_BYHAND.getValue())) {
                                details1.put(str, CheckedResultSourceEnum.ENTER_BYHAND.getName());
                                continue block29;
                            }
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.BILL_PRODUCE.getValue())) {
                                details1.put(str, CheckedResultSourceEnum.BILL_PRODUCE.getName());
                                continue block29;
                            }
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.STANDARD_IMPORT.getValue())) {
                                details1.put(str, CheckedResultSourceEnum.STANDARD_IMPORT.getName());
                                continue block29;
                            }
                            if (!StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.VOUCHER_ACCOUNT.getValue())) continue block29;
                            details1.put(str, CheckedResultSourceEnum.VOUCHER_ACCOUNT.getName());
                            continue block29;
                        }
                        case "matchcode": {
                            details1.put(str, dyObj1.getLong("id") + "");
                            continue block29;
                        }
                        default: {
                            details1.put(str, res);
                        }
                    }
                }
                details1.put("amtprecision", amtPrecision);
                exportEntitySheet2.add(details1);
            }
        }
        String fileUrl = null;
        CreateExcelUtil.createExcelFile((SXSSFWorkbook)wb, (String)ResManager.loadKDString((String)"\u5df2\u5bf9\u8d26\u7ed3\u679c", (String)"CheckResultPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), (String[])exportTitleSheet2, exportEntitySheet2);
        try {
            String excelName = ResManager.loadKDString((String)"\u5df2\u5bf9\u8d26\u7ed3\u679c", (String)"CheckResultPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            excelName = CreateExcelUtil.getTempFilename1((String)excelName);
            fileUrl = CreateExcelUtil.writeFile((SXSSFWorkbook)wb, (String)excelName);
            this.getView().download(fileUrl);
        }
        catch (KDException e) {
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    protected Set<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap_checked");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Long> idSet = new HashSet<Long>(selectedRows.size());
        for (ListSelectedRow listSelectedRowValue : selectedRows) {
            idSet.add((Long)listSelectedRowValue.getPrimaryKeyValue());
        }
        return idSet;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("autocheck".equals(key)) {
            op.getOption().setVariableValue("bizdate", DateUtils.formatString((Date)((Date)this.getModel().getValue("begindate")), (String)"yyyy-MM-dd HH:mm:ss"));
            op.getOption().setVariableValue("bizdateend", DateUtils.formatString((Date)((Date)this.getModel().getValue("enddate")), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        OperationResult result = args.getOperationResult();
        if ("autocheck".equalsIgnoreCase(operateKey)) {
            int count = result.getBillCount();
            if (count == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5bf9\u8d26\u7ed3\u679c\u3002\u53ef\u80fd\u662f\u5df2\u914d\u7f6e\u7684\u5bf9\u8d26\u89c4\u5219\u4e0d\u9002\u7528\uff0c\u6216\u8005\u6ca1\u6709\u627e\u5230\u7b26\u5408\u81ea\u52a8\u5bf9\u8d26\u89c4\u5219\u7684\u6570\u636e\u3002", (String)"CheckResultPlugin_27", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
                return;
            }
            List successPkIds = result.getSuccessPkIds();
            logger.info("----->>> autocheck,count={},successPkIds.size()={}", (Object)count, (Object)successPkIds.size());
            successPkIds.removeIf(Objects::isNull);
            logger.info("----->>> autocheck,after remove null,successPkIds.size()={}", (Object)successPkIds.size());
            if (!successPkIds.isEmpty()) {
                this.refresh();
                int sucCount = successPkIds.size();
                String tips = String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26\u6210\u529f\uff0c\u5df2\u52fe\u5bf9%s\u6761\u6570\u636e\u3002", (String)"CheckResultPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), sucCount);
                this.getView().showSuccessNotification(tips, Integer.valueOf(6000));
            } else {
                this.getView().showTipNotification(CheckResultPlugin.decodeMultiErrorMsg(result), Integer.valueOf(6000));
            }
        }
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List uniqueErrorInfos = operationResult.getAllErrorOrValidateInfo().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IOperateInfo>(Comparator.comparing(IOperateInfo::getMessage))), ArrayList::new));
        StringBuilder buf = new StringBuilder();
        int len = uniqueErrorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)uniqueErrorInfos.get(i)).getMessage());
        }
        return buf.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if ("CONFIRM_BALANCE_CALLBACK".equals(callBackId) && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("balance");
        } else if ("CONFIRM_CHECKADJUST_CALLBACK".equals(callBackId) && MessageBoxResult.Yes.equals((Object)res)) {
            String unCheckId = this.getPageCache().get("uncheckid");
            if (!CasHelper.isEmpty((Object)unCheckId)) {
                Set unCheckSets = Arrays.stream(unCheckId.split(",")).map(Long::parseLong).collect(Collectors.toSet());
                CheckByHandHelper.reverseCheck(unCheckSets, (boolean)false, (IFormView)this.getView(), null);
                this.refresh();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u64a4\u9500\u5bf9\u8d26%s\u6761\u8bb0\u5f55\u3002", (String)"CheckResultPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), unCheckSets.size()));
            }
        } else if (CAS_CHECK_RESULT_CALLBACK.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)res)) {
                this.getPageCache().put(PAGE_CACHE_VIEW, "true");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"check", "autocheck", "uncheck", "newbalance", "exportexcel", "refresh", "more"});
                return;
            }
            this.getPageCache().put(PAGE_CACHE_VIEW, "false");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean releaseLock;
        super.beforeClosed(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orgId = Long.parseLong(customParams.get("orgid").toString());
        long accountBankId = Long.parseLong(customParams.get("accountbankid").toString());
        long currencyId = Long.parseLong(customParams.get("currencyid").toString());
        String pkId = kd.fi.cas.util.StringUtils.joinKeyString((String)SPLIT_STRING, (Object[])new Object[]{orgId, accountBankId, currencyId});
        String viewPage = this.getPageCache().get(PAGE_CACHE_VIEW);
        if (kd.fi.cas.util.StringUtils.isEmpty((String)viewPage) && !"true".equals(viewPage) && !(releaseLock = MutexServiceHelper.release((String)pkId, (String)"cas_checkresult", (String)CHECK_RESULT_LOCK_OP))) {
            logger.error("\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\uff0c\u7528\u5de5\u5bf9\u8d26\u754c\u9762\u91ca\u653e\u9501\u5931\u8d25\uff0c\u9501ID\uff1a{}", (Object)pkId);
            String tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u754c\u9762\u91ca\u653e\u9501\u5931\u8d25\uff01\u9501\uff1a%s\u3002", (String)"CheckResultPlugin_32", (String)"fi-cas-formplugin", (Object[])new Object[0]), CHECK_RESULT_LOCK_OP);
            this.getView().showErrorNotification(tip);
            e.setCancel(true);
        }
    }

    private void quickSearch(BillList billList, SearchEnterEvent event) {
        List fields = event.getSearchFields();
        this.getPageCache().put("journalsearch", "");
        this.getPageCache().put("statesearch", "");
        this.getPageCache().put("journalname", "");
        this.getPageCache().put("statename", "");
        if (fields == null) {
            if ("cas_bankstatement".equals(billList.getEntityId())) {
                billList.setFilter(this.getBankStateFilter());
            } else if ("cas_bankjournal".equals(billList.getEntityId())) {
                billList.setFilter(this.getJournalFilter());
            }
            billList.refresh();
        } else {
            QFilter filter = null;
            String searchStr = "";
            String searchNameStr = "";
            for (Map field : fields) {
                List fieldName = (List)field.get("fieldName");
                List fieldValue = (List)field.get("value");
                searchStr = String.valueOf(fieldValue.get(0));
                for (Object value : fieldValue) {
                    QFilter subFilter = null;
                    if (fieldName.size() == 1) {
                        searchNameStr = (String)fieldName.get(0);
                        if ("creditamount".equals(fieldName.get(0)) && value != null) {
                            subFilter = this.getSearchFilter("creditamount", String.valueOf(value), subFilter);
                        } else if ("debitamount".equals(fieldName.get(0)) && value != null) {
                            subFilter = this.getSearchFilter("debitamount", String.valueOf(value), subFilter);
                        } else if ("oppunit".equals(fieldName.get(0))) {
                            subFilter = this.getSearchFilter("oppunit", String.valueOf(value), subFilter);
                        }
                    } else if (value != null) {
                        subFilter = this.getSearchFilter("oppunit", String.valueOf(value), subFilter);
                        subFilter = this.getSearchFilter("creditamount", String.valueOf(value), subFilter);
                        subFilter = this.getSearchFilter("debitamount", String.valueOf(value), subFilter);
                    }
                    if (filter == null) {
                        filter = subFilter;
                        continue;
                    }
                    filter.and(subFilter);
                }
            }
            if ("cas_bankstatement".equals(billList.getEntityId())) {
                billList.setFilter(this.getBankStateFilter().and(filter));
                this.getPageCache().put("statesearch", searchStr);
                this.getPageCache().put("statename", searchNameStr);
            } else if ("cas_bankjournal".equals(billList.getEntityId())) {
                billList.setFilter(this.getJournalFilter().and(filter));
                this.getPageCache().put("journalname", searchNameStr);
                this.getPageCache().put("journalsearch", searchStr);
            }
            billList.refresh();
        }
    }

    private boolean handCheck(String checkType) {
        IFormView view = this.getView();
        BillList stateBillList = (BillList)this.getControl("billlistap_state");
        ListSelectedRowCollection stateBillRows = stateBillList.getSelectedRows();
        BillList journalBillList = (BillList)this.getControl("billlistap_journal");
        ListSelectedRowCollection journalBillRows = journalBillList.getSelectedRows();
        if (stateBillRows.size() == 0 || journalBillRows.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e24\u4e2a\u5217\u8868\u4e2d\u5206\u522b\u9009\u4e2d\u9700\u8981\u5bf9\u8d26\u7684\u6570\u636e\u3002", (String)"CheckResultPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return CheckByHandHelper.checkByHand(this.getBillIdsFomRow(stateBillRows), this.getBillIdsFomRow(journalBillRows), (String)checkType, (IFormView)view, null);
    }

    private boolean handCheckSingle() {
        IFormView view = this.getView();
        BillList stateBillList = (BillList)this.getControl("billlistap_state");
        ListSelectedRowCollection stateBillRows = stateBillList.getSelectedRows();
        BillList journalBillList = (BillList)this.getControl("billlistap_journal");
        ListSelectedRowCollection journalBillRows = journalBillList.getSelectedRows();
        if (stateBillRows.size() == 0 && journalBillRows.size() == 0 || stateBillRows.size() > 0 && journalBillRows.size() > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bf9\u8d26\u7684\u65e5\u8bb0\u8d26\u6216\u5bf9\u8d26\u5355\u6570\u636e\u3002", (String)"CheckResultPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return CheckByHandHelper.checkByHand(this.getBillIdsFomRow(stateBillRows), this.getBillIdsFomRow(journalBillRows), (String)"3", (IFormView)view, null);
    }

    private boolean unCheckByRule() {
        try (TXHandle h = TX.required((String)"checkresult_uncheckByrule");){
            HashSet<Long> stateIdset = new HashSet<Long>(16);
            HashSet<Long> journalIdset = new HashSet<Long>(16);
            String userId = RequestContext.get().getUserId();
            QFilter filter = new QFilter("creator", "=", (Object)userId).and(new QFilter("batchno", "=", (Object)"1"));
            DynamicObjectCollection checkResult = QueryServiceHelper.query((String)"cas_checkedresult", (String)"id,entry.bizobject,entry.bizobjectid", (QFilter[])new QFilter[]{filter});
            if (checkResult != null && checkResult.size() > 0) {
                for (DynamicObject result : checkResult) {
                    if ("cas_bankstatement".equals(result.getString("entry.bizobject"))) {
                        stateIdset.add(result.getLong("entry.bizobjectid"));
                        continue;
                    }
                    journalIdset.add(result.getLong("entry.bizobjectid"));
                }
            }
            if (stateIdset.size() == 0 || journalIdset.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u64a4\u9500\uff0c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u81ea\u52a8\u5bf9\u8d26\u8bb0\u5f55\u3002", (String)"CheckResultPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                boolean bl = false;
                return bl;
            }
            try {
                DeleteServiceHelper.delete((String)"cas_checkedresult", (QFilter[])new QFilter[]{filter});
                String stateSql = "update t_cas_bankstatement set fischeck=0 where fid in " + kd.fi.cas.util.StringUtils.setToString(stateIdset);
                DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement").getDBRouteKey()), (String)stateSql, (Object[])new Object[0]);
                String journalSql = "update t_cas_bankjournal set fischeck=0 where fid in " + kd.fi.cas.util.StringUtils.setToString(journalIdset);
                DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal").getDBRouteKey()), (String)journalSql, (Object[])new Object[0]);
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u6309\u89c4\u5219\u64a4\u9500\u5bf9\u8d26\u629b\u5f02\u5e38\uff1a" + e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return true;
    }

    private void refresh() {
        BillList checkedBillList = (BillList)this.getControl("billlistap_checked");
        checkedBillList.setFilter(this.getCheckedFilter());
        checkedBillList.clearSelection();
        checkedBillList.refresh();
        String checkRowIndex = this.getPageCache().get("checkRowIndex");
        if (CasHelper.isNotEmpty((Object)checkRowIndex)) {
            int pageRow = checkedBillList.getListModel().getDataCount() - 1;
            Integer RowIndex = Integer.valueOf(checkRowIndex);
            if (RowIndex > pageRow) {
                RowIndex = pageRow;
            }
            checkedBillList.focusCell(RowIndex.intValue(), "bizdate");
        }
        BillList stateBillList = (BillList)this.getControl("billlistap_state");
        stateBillList.setFilter(this.getBankStateFilter());
        stateBillList.clearSelection();
        stateBillList.refresh();
        String stateRowIndex = this.getPageCache().get("stateRowIndex");
        if (CasHelper.isNotEmpty((Object)stateRowIndex)) {
            int pageRow = stateBillList.getListModel().getDataCount() - 1;
            Integer RowIndex = Integer.valueOf(stateRowIndex);
            if (RowIndex > 15) {
                RowIndex = RowIndex + 5;
            }
            if (RowIndex > pageRow) {
                RowIndex = pageRow;
            }
            stateBillList.focusCell(RowIndex.intValue(), "");
        }
        BillList journalBillList = (BillList)this.getControl("billlistap_journal");
        journalBillList.setFilter(this.getJournalFilter());
        IListModel journalModel = journalBillList.getListModel();
        journalModel.setProvider((IListDataProvider)new JournalListDataProvider());
        journalBillList.clearSelection();
        journalBillList.refresh();
        String journalRowIndex = this.getPageCache().get("journalRowIndex");
        if (CasHelper.isNotEmpty((Object)journalRowIndex)) {
            int pageRow = journalBillList.getListModel().getDataCount() - 1;
            Integer RowIndex = Integer.valueOf(journalRowIndex);
            if (RowIndex > 15) {
                RowIndex = RowIndex + 5;
            }
            if (RowIndex > pageRow) {
                RowIndex = pageRow;
            }
            journalBillList.focusCell(RowIndex.intValue(), "");
        }
        this.getModel().setValue("desumcount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("cesumcount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("journaldecount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("journalcecount", (Object)BigDecimal.ZERO);
    }

    private QFilter getBankStateFilter() {
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("accountbank", "=", (Object)accountBank.getLong("id"));
        filter = filter.and("currency", "=", EmptyUtil.isEmpty((DynamicObject)currency) ? null : Long.valueOf(currency.getLong("id")));
        filter = filter.and("ischeck", "=", (Object)"0");
        if (this.getModel().getValue("begindate") != null && !((Boolean)this.getModel().getValue("unreachdata")).booleanValue()) {
            filter = filter.and("bizdate", ">=", this.getModel().getValue("begindate"));
        }
        if (this.getModel().getValue("begindate") != null && this.getModel().getValue("enddate") != null) {
            filter = filter.and("bizdate", "<=", this.getModel().getValue("enddate"));
        }
        String stateSearch = this.getPageCache().get("statesearch");
        String stateName = this.getPageCache().get("statename");
        if (EmptyUtil.isNoEmpty((Object)stateName) && EmptyUtil.isNoEmpty((Object)stateSearch)) {
            if ("creditamount".equals(stateName) && this.isBigDecimal(stateSearch.toString())) {
                filter = filter.and(new QFilter("creditamount", "=", (Object)new BigDecimal(stateSearch.toString())));
            } else if ("debitamount".equals(stateName) && this.isBigDecimal(stateSearch.toString())) {
                filter = filter.and(new QFilter("debitamount", "=", (Object)new BigDecimal(stateSearch.toString())));
            } else if ("oppunit".equals(stateName)) {
                filter = filter.and(new QFilter("oppunit", "like", (Object)("%" + stateSearch + "%")));
            }
        } else if (EmptyUtil.isNoEmpty((Object)stateSearch)) {
            QFilter filterSearch = new QFilter("oppunit", "like", (Object)("%" + stateSearch + "%"));
            if (this.isBigDecimal(stateSearch.toString())) {
                filterSearch.or(new QFilter("creditamount", "=", (Object)new BigDecimal(stateSearch.toString()))).or(new QFilter("debitamount", "=", (Object)new BigDecimal(stateSearch.toString())));
            }
            filter = filter.and(filterSearch);
        }
        filter.and(new QFilter("isbank", "=", (Object)"1"));
        filter.and(new QFilter("isvalid", "=", (Object)"1"));
        return filter;
    }

    private QFilter getJournalFilter() {
        DynamicObject mainOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("accountbank", "=", (Object)accountBank.getLong("id"));
        if (mainOrg != null && mainOrg.getLong("id") != accountBank.getDynamicObject("createorg").getLong("id")) {
            filter.and(new QFilter("org", "in", mainOrg.getPkValue()));
        }
        filter = filter.and("currency", "=", EmptyUtil.isEmpty((DynamicObject)currency) ? null : Long.valueOf(currency.getLong("id")));
        filter = filter.and("ischeck", "=", (Object)"0");
        filter = filter.and("isvalid", "=", (Object)"1");
        if (this.getModel().getValue("begindate") != null && !((Boolean)this.getModel().getValue("unreachdata")).booleanValue()) {
            filter = filter.and("bookdate", ">=", this.getModel().getValue("begindate"));
        }
        if (this.getModel().getValue("enddate") != null) {
            filter = filter.and("bookdate", "<=", this.getModel().getValue("enddate"));
        }
        String journalsearch = this.getPageCache().get("journalsearch");
        String journalName = this.getPageCache().get("journalname");
        if (EmptyUtil.isNoEmpty((Object)journalName) && EmptyUtil.isNoEmpty((Object)journalsearch)) {
            if ("creditamount".equals(journalName) && this.isBigDecimal(journalsearch.toString())) {
                filter = filter.and(new QFilter("creditamount", "=", (Object)new BigDecimal(journalsearch.toString())));
            } else if ("debitamount".equals(journalName) && this.isBigDecimal(journalsearch.toString())) {
                filter = filter.and(new QFilter("debitamount", "=", (Object)new BigDecimal(journalsearch.toString())));
            } else if ("oppunit".equals(journalName)) {
                filter = filter.and(new QFilter("oppunit", "like", (Object)("%" + journalsearch + "%")));
            }
        } else if (EmptyUtil.isNoEmpty((Object)journalsearch)) {
            QFilter filterSearch = new QFilter("oppunit", "like", (Object)("%" + journalsearch + "%"));
            if (this.isBigDecimal(journalsearch.toString())) {
                filterSearch.or(new QFilter("creditamount", "=", (Object)new BigDecimal(journalsearch.toString()))).or(new QFilter("debitamount", "=", (Object)new BigDecimal(journalsearch.toString())));
            }
            filter = filter.and(filterSearch);
        }
        BillList journalBillList = (BillList)this.getControl("billlistap_journal");
        List rowFilters = journalBillList.getFilterParameter().getQFilters();
        if (EmptyUtil.isNoEmpty((Object)rowFilters)) {
            for (QFilter rowFilter : rowFilters) {
                filter = filter.and(rowFilter);
            }
        }
        return filter;
    }

    private QFilter getCheckedFilter() {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("accountbank", "=", (Object)accountBank.getLong("id"));
        if (currency != null) {
            filter = filter.and("currency", "=", (Object)currency.getLong("id"));
        }
        if (!AccountBankHelper.isAuthorityAccount((DynamicObject)accountBank, (DynamicObject)orgObj)) {
            filter.and(new QFilter("entry.org", "=", orgObj.getPkValue()));
        }
        if (this.getModel().getValue("begindate") != null && this.getModel().getValue("enddate") != null) {
            filter = filter.and("entry.bizdate", ">=", this.getModel().getValue("begindate"));
            filter = filter.and("entry.bizdate", "<=", this.getModel().getValue("enddate"));
        }
        String checksearch = this.getPageCache().get("checksearch");
        String checkfieldName = this.getPageCache().get("checkfieldname");
        if (EmptyUtil.isNoEmpty((Object)checkfieldName) && EmptyUtil.isNoEmpty((Object)checksearch)) {
            if ("creditamount".equals(checkfieldName)) {
                filter = this.getSearchFilter("entry.creditamount", String.valueOf(checksearch), filter);
            } else if ("debitamount".equals(checkfieldName)) {
                filter = this.getSearchFilter("entry.debitamount", String.valueOf(checksearch), filter);
            } else if ("oppunit".equals(checkfieldName)) {
                filter = this.getSearchFilter("entry.oppunit", String.valueOf(checksearch), filter);
            }
        } else if (EmptyUtil.isNoEmpty((Object)checksearch)) {
            filter = this.getSearchFilter("entry.oppunit", String.valueOf(checksearch), filter);
            filter = this.getSearchFilter("entry.creditamount", String.valueOf(checksearch), filter);
            filter = this.getSearchFilter("entry.debitamount", String.valueOf(checksearch), filter);
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_checkedresult", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> idSet = new HashSet<Long>(coll.size());
        for (DynamicObject dynamicObject : coll) {
            idSet.add(dynamicObject.getLong("id"));
        }
        return new QFilter("id", "in", idSet);
    }

    public String getBalance() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject initObj = PeriodHelper.getCasInitInfo((long)org.getLong("id"));
        if (initObj == null || !initObj.getBoolean("isfinishinit")) {
            logger.info("\u7ec4\u7ec7\uff1a\u3010{}\u3011\u672a\u8fdb\u884c\u521d\u59cb\u5316......", (Object)org.getLong("id"));
            return "";
        }
        DynamicObject startperiod = initObj.getDynamicObject("startperiod");
        Date date = (Date)this.getModel().getValue("enddate");
        QFilter filter = this.getBaseQfilter().and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)startperiod.getDate("begindate"), (boolean)true)).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false)));
        DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,billstatus,bizdate", (QFilter[])new QFilter[]{filter});
        if (balances == null || balances.length == 0) {
            return "";
        }
        if (date.after(DateUtils.getCurrentDate())) {
            date = DateUtils.getCurrentDate();
        }
        for (DynamicObject balance : balances) {
            if (BillStatusEnum.SAVE.getValue().equals(balance.getString("billstatus"))) {
                return DateUtils.formatString((Date)balance.getDate("bizdate"), (String)"yyyy-MM-dd");
            }
            if (!DateUtils.isSameDay((Date)balance.getDate("bizdate"), (Date)date)) continue;
            return balance.getString("billstatus");
        }
        return "";
    }

    private QFilter getBaseQfilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("bankaccount", "=", (Object)accountBank.getLong("id"));
        filter = filter.and("org", "=", org.getPkValue()).and("currency", "=", (Object)currency.getLong("id")).and("period", "!=", (Object)0);
        return filter;
    }

    private void getCountByClick(ListSelectedRowCollection listSelects, String entityName) {
        BigDecimal debitamount = BigDecimal.ZERO;
        BigDecimal creditamount = BigDecimal.ZERO;
        if (listSelects != null && listSelects.size() > 0) {
            ArrayList ids = new ArrayList(listSelects.size());
            listSelects.forEach(listSelect -> {
                ListSelectedRow row = listSelect;
                ids.add((Long)row.getPrimaryKeyValue());
            });
            QFilter filter = new QFilter("id", "in", ids);
            try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CheckResultPlugin.class.getName() + "." + entityName), (String)entityName, (String)"debitamount,creditamount", (QFilter[])new QFilter[]{filter}, null);
                 DataSet finalJournalDataSet = balanceRawDataSet.groupBy().sum("debitamount").sum("creditamount").finish();){
                for (Row next : finalJournalDataSet) {
                    debitamount = next.getBigDecimal("debitamount");
                    creditamount = next.getBigDecimal("creditamount");
                }
            }
        }
        this.getModel().setValue("cas_bankstatement".equals(entityName) ? "desumcount" : "journaldecount", (Object)debitamount);
        this.getModel().setValue("cas_bankstatement".equals(entityName) ? "cesumcount" : "journalcecount", (Object)creditamount);
    }

    private void getCountBySelectAll(QFilter filter, String entityName) {
        BigDecimal debitamount = BigDecimal.ZERO;
        BigDecimal creditamount = BigDecimal.ZERO;
        if (filter != null) {
            try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CheckResultPlugin.class.getName() + "." + entityName), (String)entityName, (String)"debitamount,creditamount", (QFilter[])new QFilter[]{filter}, null);
                 DataSet finalJournalDataSet = balanceRawDataSet.groupBy().sum("debitamount").sum("creditamount").finish();){
                for (Row next : finalJournalDataSet) {
                    debitamount = next.getBigDecimal("debitamount");
                    creditamount = next.getBigDecimal("creditamount");
                }
            }
        }
        this.getModel().setValue("cas_bankstatement".equals(entityName) ? "desumcount" : "journaldecount", (Object)debitamount);
        this.getModel().setValue("cas_bankstatement".equals(entityName) ? "cesumcount" : "journalcecount", (Object)creditamount);
    }

    private boolean isBigDecimal(String str) {
        return this.isInteger(str) || this.isDouble(str);
    }

    private boolean isInteger(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    private boolean isDouble(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?\\d*[.]\\d+$");
        return pattern.matcher(str).matches();
    }

    private QFilter getSearchFilter(String propName, String value, QFilter filter) {
        if (EmptyUtil.isEmpty((String)value)) {
            return filter;
        }
        String[] valueSplit = value.split(" ");
        QFilter searchFilter = filter == null ? new QFilter("id", "=", null) : filter;
        logger.info("getSearchFilter propName: " + propName + "searchText: " + value);
        for (String str : valueSplit) {
            if ("oppunit".equals(propName) || "entry.oppunit".equals(propName)) {
                searchFilter.or(propName, "like", (Object)("%" + str + "%"));
                continue;
            }
            if (!this.isBigDecimal(str)) continue;
            searchFilter.or(propName, "=", (Object)new BigDecimal(str));
        }
        return searchFilter;
    }

    private void getBalance(Date endDate, Long accountBankId, Long currencyId) {
        logger.info("endDate\uff1a{}\uff0caccountBankId\uff1a{}\uff0ccurrencyId\uff1a{}", new Object[]{endDate, accountBankId, currencyId});
        if (endDate == null || accountBankId == null || currencyId == null) {
            return;
        }
        BigDecimal bankBalance = this.balanceCountService.getJournalBalanceByAccount(accountBankId, currencyId, endDate);
        this.getModel().setValue("journalamt", (Object)bankBalance);
        HashSet<Long> accounts = new HashSet<Long>(1);
        accounts.add(accountBankId);
        HashMap<Long, Set<Long>> acctToCnyMap = new HashMap<Long, Set<Long>>(2);
        acctToCnyMap.put(accountBankId, Collections.singleton(currencyId));
        Map statmBalanceMap = this.balanceCountService.getStatmBalanceBatch(accounts, acctToCnyMap, endDate);
        String key = accountBankId + "-" + currencyId;
        if (statmBalanceMap != null && statmBalanceMap.get(key) != null) {
            this.getModel().setValue("stmtamt", statmBalanceMap.get(key));
        }
    }

    public void beforeBindData(EventObject e) {
        BillList journalBillList = (BillList)this.getControl("billlistap_journal");
        IListModel journalModel = journalBillList.getListModel();
        journalModel.setProvider((IListDataProvider)new JournalListDataProvider());
        journalBillList.clearSelection();
        journalBillList.refresh();
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        BillList billList = (BillList)setFilterEvent.getSource();
        switch (billList.getKey()) {
            case "billlistap_checked": {
                setFilterEvent.getQFilters().add(this.getCheckedFilter());
                break;
            }
            case "billlistap_state": {
                setFilterEvent.getQFilters().add(this.getBankStateFilter());
                break;
            }
            case "billlistap_journal": {
                setFilterEvent.getQFilters().add(this.getJournalFilter());
            }
        }
    }

    private Set<Long> getBillIdsFomRow(ListSelectedRowCollection rows) {
        HashSet<Long> billIds = new HashSet<Long>();
        if (rows != null && rows.size() > 0) {
            for (ListSelectedRow row : rows) {
                Long stateBillId = (Long)row.getPrimaryKeyValue();
                billIds.add(stateBillId);
            }
        }
        return billIds;
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orgId = Long.parseLong(customParams.get("orgid").toString());
        long accountBankId = Long.parseLong(customParams.get("accountbankid").toString());
        long currencyId = Long.parseLong(customParams.get("currencyid").toString());
        String pkId = kd.fi.cas.util.StringUtils.joinKeyString((String)SPLIT_STRING, (Object[])new Object[]{orgId, accountBankId, currencyId});
        Map lockInfo = MutexServiceHelper.getLockInfo((String)pkId, (String)"cas_checkresult", (String)CHECK_RESULT_LOCK_OP);
        RequestContext requestContext = RequestContext.get();
        String currentUserID = requestContext.getUserId();
        if (lockInfo == null || lockInfo.size() == 0) {
            logger.info("\u9875\u9762\u9000\u51fa\u91ca\u653e\u9501\u65f6\uff0c\u9501{}\u4fe1\u606f\u4e3a\u7a7a(\u53ef\u80fd\u6b63\u5e38\u9000\u51fa\uff0c\u9501\u5df2\u7ecf\u91ca\u653e)\u3002", (Object)pkId);
            return;
        }
        if (currentUserID == null || kd.fi.cas.util.StringUtils.isEmpty((String)currentUserID)) {
            logger.info("\u9875\u9762\u9000\u51fa\u91ca\u653e\u9501\u65f6\uff0c\u5f53\u524d\u7528\u6237ID\u4e3a\u7a7a\u3002");
            return;
        }
        String lockUserId = (String)lockInfo.get("userid");
        if (lockUserId == null || kd.fi.cas.util.StringUtils.isEmpty((String)lockUserId)) {
            logger.info("\u9875\u9762\u9000\u51fa\u91ca\u653e\u9501\u65f6\uff0c\u5f53\u524d\u7528\u6237\u6267\u884c\u9501\u7684\u4ebaID\u4e3a\u7a7a(\u53ef\u80fd\u6b63\u5e38\u9000\u51fa\uff0c\u9501\u5df2\u7ecf\u91ca\u653e)\u3002");
            return;
        }
        String viewPage = this.getPageCache().get(PAGE_CACHE_VIEW);
        if (currentUserID.equals(lockUserId) && kd.fi.cas.util.StringUtils.isEmpty((String)viewPage) && !"true".equals(viewPage)) {
            logger.info("\u9875\u9762\u9000\u51fa\u91ca\u653e\u9501\uff1a{}", (Object)pkId);
            MutexServiceHelper.release((String)pkId, (String)"cas_checkresult", (String)CHECK_RESULT_LOCK_OP);
        }
    }

    private boolean checkVisibleForDiffUser() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orgId = Long.parseLong(customParams.get("orgid").toString());
        long accountBankId = Long.parseLong(customParams.get("accountbankid").toString());
        long currencyId = Long.parseLong(customParams.get("currencyid").toString());
        String pkId = kd.fi.cas.util.StringUtils.joinKeyString((String)SPLIT_STRING, (Object[])new Object[]{orgId, accountBankId, currencyId});
        Map lockInfo = MutexServiceHelper.getLockInfo((String)pkId, (String)"cas_checkresult", (String)CHECK_RESULT_LOCK_OP);
        if (EmptyUtil.isNoEmpty((Object)lockInfo)) {
            long userid = Long.parseLong((String)lockInfo.get("userid"));
            long currUserId = RequestContext.get().getCurrUserId();
            return userid != 0L && currUserId != 0L && userid != currUserId;
        }
        return false;
    }

    static /* synthetic */ void access$000(CheckResultPlugin x0, ListSelectedRowCollection x1, String x2) {
        x0.getCountByClick(x1, x2);
    }

    static /* synthetic */ void access$100(CheckResultPlugin x0, QFilter x1, String x2) {
        x0.getCountBySelectAll(x1, x2);
    }

    static /* synthetic */ QFilter access$200(CheckResultPlugin x0) {
        return x0.getBankStateFilter();
    }

    static /* synthetic */ QFilter access$300(CheckResultPlugin x0) {
        return x0.getJournalFilter();
    }

    static /* synthetic */ boolean access$400(CheckResultPlugin x0) {
        return x0.checkVisibleForDiffUser();
    }

    static /* synthetic */ QFilter access$500(CheckResultPlugin x0) {
        return x0.getCheckedFilter();
    }

    static /* synthetic */ QFilter access$600(CheckResultPlugin x0, String x1, String x2, QFilter x3) {
        return x0.getSearchFilter(x1, x2, x3);
    }

    static class JournalListDataProvider
    extends ListDataProvider {
        JournalListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            Map voucherNoCache = new VoucherBookService().getSourceNumbers((Collection)rows, "cas_bankjournal");
            rows.forEach(d -> {
                if ("gl_voucher".equals(d.getString("sourcebilltype"))) {
                    SourceNumber sourceNumber = (SourceNumber)voucherNoCache.get(d);
                    d.set("sourcebillnumber", (Object)sourceNumber.getVoucherNo());
                }
            });
            return rows;
        }
    }
}

