/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.consts.Constants;
import kd.fi.cas.dao.QueryDynamic;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.helper.InitCheckPluginHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PaymentBillDraftEditPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(PaymentBillDraftEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initDraftBillF7();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.setAmountLabelVisible(settleType, org);
    }

    private void setAmountLabelVisible(DynamicObject settleType, DynamicObject org) {
        DynamicObject drafttradebill;
        boolean visible = false;
        if (Objects.nonNull(org) && Objects.nonNull(settleType)) {
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            Object settlementType = settleType.get("settlementtype");
            if (Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"isdraft");
            } else if (Objects.equals(settlementType, SettleMentTypeEnum.PROMISSORY.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"ischeck");
            } else if (Objects.equals(settlementType, SettleMentTypeEnum.CHECK.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"ispromissorynote");
            }
            this.draftAmountSum();
        }
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"balancelb", "balancev"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"draftamttotaltital", "draftamttotal"});
        DynamicObjectCollection draftbill = (DynamicObjectCollection)this.getModel().getValue("draftbill");
        String sourcebilltype = (String)this.getModel().getValue("sourcebilltype");
        if (visible && draftbill != null && draftbill.size() > 0 && "cas_payapplybill".equals(sourcebilltype)) {
            List draftBillIdList = draftbill.stream().map(d -> d.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            if (PayBillHepler.checkDraftAllInPayApplyBill((DynamicObject)this.getModel().getDataEntity(), draftBillIdList)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settletype", "draftbill"});
            }
        } else if (visible && "cdm_drafttradebill".equals(sourcebilltype) && (drafttradebill = BusinessDataServiceHelper.loadSingle((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter("tradetype", "=", (Object)"refund").and("id", "=", this.getModel().getValue("sourcebillid")).toArray())) != null && !"0".equals(drafttradebill.getString("id"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"settletype", "draftbill", "paymentchannel"});
        }
    }

    private void draftAmountSum() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_draftinfo");
        BigDecimal draftAmountSum = BigDecimal.ZERO;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            draftAmountSum = entryEntity.stream().map(d -> d.getBigDecimal("transamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            DynamicObjectCollection draftBills = this.getModel().getDataEntity().getDynamicObjectCollection("draftbill");
            draftAmountSum = draftBills.stream().filter(d -> d.getDynamicObject("fbasedataid") != null).map(d -> d.getDynamicObject("fbasedataid").getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (Objects.nonNull(currency)) {
            String sign = currency.getString("sign");
            FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
            fobj.getCurrencyFormat().setCurrencySymbols(sign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(currency.getInt("amtprecision"));
            Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
            ((Label)this.getControl("draftamttotal")).setText(currencyFormat.format(draftAmountSum));
        } else {
            ((Label)this.getControl("draftamttotal")).setText(draftAmountSum.toString());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey().toLowerCase();
        if ("viewdrafbill".equals(key)) {
            this.viewDrafBill();
        }
    }

    private List<Long> getBillPoolByCompany(long orgId) {
        DynamicObject[] billPools = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.e_company", "=", (Object)orgId).or(new QFilter("company", "=", (Object)orgId)), new QFilter("enable", "=", (Object)"1")});
        ArrayList<Long> poolIds = new ArrayList<Long>(billPools.length);
        for (DynamicObject dy0 : billPools) {
            poolIds.add(dy0.getLong("id"));
        }
        return poolIds;
    }

    private void initDraftBillF7() {
        BasedataEdit draftbill = (BasedataEdit)this.getControl("draftbill");
        draftbill.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set cdm_payablebill;
            Set cdm_receivablebill;
            List<Long> ids;
            Object currency = this.getModel().getValue("currency");
            if (CasHelper.isEmpty((Object)currency)) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object payeetype = this.getModel().getValue("payeetype");
            Object payeename = this.getModel().getValue("payeename");
            if (CasHelper.isEmpty((Object)payeetype) || CasHelper.isEmpty((Object)payeename)) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            long orgId = this.getModel().getValue("org") == null ? 0L : ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            String orgName = this.getModel().getValue("org") == null ? "" : ((DynamicObject)this.getModel().getValue("org")).getString("name");
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            QFilter receFilter = new QFilter("company.id", "=", (Object)orgId);
            receFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
            receFilter.and(new QFilter("availableamount", ">", (Object)0));
            receFilter.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
            receFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            receFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
            receFilter.and(new QFilter("istransfer", "=", (Object)"1"));
            QFilter nullFilter = QFilter.isNull((String)"billpool");
            receFilter.and(new QFilter("billpool", "=", (Object)0).or(nullFilter));
            List<Long> poolIds = this.getBillPoolByCompany(orgId);
            QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
            boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isShowUnLockBill");
            if (isShowUnLockBill) {
                qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(QFilter.isNull((String)"poollockstatus")).or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId))));
            } else {
                qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId)));
            }
            qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
            qFilterBillPool.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
            qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
            qFilterBillPool.and(new QFilter("availableamount", ">", (Object)0));
            boolean isExcludedBills = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isexcludedbills");
            if (isExcludedBills && EmptyUtil.isNoEmpty(ids = this.getIsExcludedBills(orgId, currency, orgName, appId)) && ids.size() > 0) {
                qFilterBillPool.and("id", "not in", (Object)ids.toArray());
            }
            QFilter payFilter = new QFilter("company.id", "=", (Object)orgId);
            payFilter.and(new QFilter("source", "not in", (Object)new String[]{"cas", "ifm"}));
            payFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
            payFilter.and(new QFilter("availableamount", ">", (Object)0));
            payFilter.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
            payFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            payFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
            payFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
            payFilter.and(new QFilter("receivername", "=", payeename));
            Object settleType = this.getModel().getValue("settletype");
            if (settleType != null) {
                DynamicObject settleTypeObj = (DynamicObject)settleType;
                List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleTypeObj.getPkValue(), (String)settleTypeObj.getString("settlementtype"));
                receFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
                qFilterBillPool.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
                payFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            }
            if (EmptyUtil.isNoEmpty((Object)(cdm_receivablebill = DraftHelper.getReleatedCasPayBill((QFilter)receFilter, (String)"cdm_receivablebill")))) {
                receFilter.and(new QFilter("id", "not in", (Object)cdm_receivablebill));
            }
            if (EmptyUtil.isNoEmpty((Object)(cdm_payablebill = DraftHelper.getReleatedCasPayBill((QFilter)payFilter, (String)"cdm_payablebill")))) {
                payFilter.and(new QFilter("id", "not in", (Object)cdm_payablebill));
            }
            QFilter qFilter = receFilter.or(qFilterBillPool).or(payFilter);
            Object draftbillColl = this.getModel().getValue("draftbill");
            if (null != draftbillColl) {
                DynamicObjectCollection colls = (DynamicObjectCollection)draftbillColl;
                ArrayList<Long> ids2 = new ArrayList<Long>(0);
                for (DynamicObject coll : colls) {
                    DynamicObject fbasedataidDy = coll.getDynamicObject("fbasedataid");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataidDy)) continue;
                    ids2.add(fbasedataidDy.getLong("id"));
                }
                if (ids2.size() > 0) {
                    qFilter.or(new QFilter("id", "in", ids2));
                }
            }
            showParameter.setCustomParam("paymentbillid", this.getModel().getValue("id"));
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private List<Long> getIsExcludedBills(long orgId, Object currency, String orgName, String appId) {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (EmptyUtil.isEmpty((String)orgName)) {
            return new ArrayList<Long>(2);
        }
        List<Long> poolIds = this.getBillPoolByCompany(orgId);
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isShowUnLockBill");
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(QFilter.isNull((String)"poollockstatus")).or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId)));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        qFilterBillPool.and(new QFilter("company.id", "!=", (Object)orgId));
        DynamicObjectCollection receivablebills = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,delivername,drawername,receivername, endorseentry.id,endorseentry.initiatorname,endorseentry.opponentname", (QFilter[])qFilterBillPool.toArray());
        Map<Long, QueryDynamic> data = this.dealQueryDynamicMap(receivablebills);
        if (data.size() == 0) {
            logger.info("deal with query data is empty.");
            return new ArrayList<Long>(ids);
        }
        block0: for (QueryDynamic receivablebill : data.values()) {
            String delivername = receivablebill.getString("delivername");
            String drawername = receivablebill.getString("drawername");
            String receivername = receivablebill.getString("receivername");
            if (orgName.equals(delivername) || orgName.equals(drawername) || orgName.equals(receivername)) {
                ids.add(receivablebill.getLong("id"));
                continue;
            }
            QueryDynamic.QueryDynamicCollection endorseentrys = receivablebill.getQueryDynamicCollection("endorseentry");
            if (!EmptyUtil.isNoEmpty((Object)endorseentrys) || endorseentrys.size() <= 0) continue;
            for (QueryDynamic endorseentry : endorseentrys.getEntry()) {
                String initiatorname = endorseentry.getString("initiatorname");
                String opponentname = endorseentry.getString("opponentname");
                if (!orgName.equals(initiatorname) && !orgName.equals(opponentname)) continue;
                ids.add(receivablebill.getLong("id"));
                continue block0;
            }
        }
        return new ArrayList<Long>(ids);
    }

    private Map<Long, QueryDynamic> dealQueryDynamicMap(DynamicObjectCollection receivablebills) {
        HashMap<Long, QueryDynamic> data = new HashMap<Long, QueryDynamic>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)receivablebills) || receivablebills.size() == 0) {
            logger.info("query data is empty.");
            return data;
        }
        for (DynamicObject receivablebill : receivablebills) {
            Long entryId;
            Long keyId = receivablebill.getLong("id");
            QueryDynamic queryDynamic = (QueryDynamic)data.get(keyId);
            if (queryDynamic == null) {
                queryDynamic = new QueryDynamic("endorseentry");
                String delivername = receivablebill.getString("delivername");
                String drawername = receivablebill.getString("drawername");
                String receivername = receivablebill.getString("receivername");
                queryDynamic.put("id", (Object)keyId).put("delivername", (Object)delivername).put("drawername", (Object)drawername).put("receivername", (Object)receivername);
                data.put(keyId, queryDynamic);
            }
            if ((entryId = Long.valueOf(receivablebill.getLong("endorseentry.id"))) == null || EmptyUtil.isEmpty((Long)entryId)) continue;
            QueryDynamic.QueryDynamicCollection entries = queryDynamic.getQueryDynamicCollection("endorseentry");
            QueryDynamic entry = new QueryDynamic();
            String initiatorname = receivablebill.getString("endorseentry.initiatorname");
            String opponentname = receivablebill.getString("endorseentry.opponentname");
            entry.put("id", (Object)entryId).put("initiatorname", (Object)initiatorname).put("opponentname", (Object)opponentname);
            entries.add(entry);
        }
        logger.info("result data size:{}", (Object)data.size());
        return data;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String key = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        switch (key) {
            case "draftbill": {
                BigDecimal eActAmt;
                BigDecimal ePayableAmt;
                Set<String> hasRelatedBillNoSet = this.checkDraftRelatedPaymentBill();
                if (hasRelatedBillNoSet.size() > 0) {
                    this.getModel().setValue("draftbill", null);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u518d\u6b21\u5173\u8054\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u7ed3\u7b97\u53f7\u4e3a\uff1a%s\u3002", (String)"PaymentBillDraftEditPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[]{hasRelatedBillNoSet}));
                    return;
                }
                BigDecimal draftAmt = Constants.ZERO;
                DynamicObjectCollection draftbillColl = (DynamicObjectCollection)data[0].getNewValue();
                for (DynamicObject draftbill : draftbillColl) {
                    draftAmt = draftAmt.add(((DynamicObject)draftbill.get("fbasedataid")).getBigDecimal("amount"));
                }
                if (this.getModel().getEntryRowCount("entry") == 0) {
                    this.getModel().createNewEntryRow("entry");
                }
                if ((ePayableAmt = (BigDecimal)this.getModel().getValue("e_payableamt", 0)) != null && ePayableAmt.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("e_payableamt", (Object)draftAmt, 0);
                }
                if ((eActAmt = (BigDecimal)this.getModel().getValue("e_actamt", 0)) != null && eActAmt.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("e_actamt", (Object)draftAmt, 0);
                }
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
                this.setAmountLabelVisible(settleType, org);
                break;
            }
            case "settletype": {
                this.getModel().setValue("draftbill", null);
                this.getPageCache().remove("endorseRecBill");
                this.setAmountLabelVisible((DynamicObject)data[0].getNewValue(), org);
            }
        }
    }

    private Set<String> checkDraftRelatedPaymentBill() {
        return DraftHelper.getRelatedBillNoSet((DynamicObject)this.getModel().getDataEntity(true));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "submit": {
                String endorseRecBill = this.getPageCache().get("endorseRecBill");
                if (!StringUtils.isNotEmpty((String)endorseRecBill)) break;
                op.getOption().setVariableValue("endorseRecBill", endorseRecBill);
                break;
            }
            case "endorse": {
                String billStatus = (String)this.getModel().getValue("billstatus");
                if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u80cc\u4e66\u3002", (String)"PaymentBillDraftEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!InitCheckPluginHelper.checkInitForPlugin((IFormView)this.getView(), (DynamicObject)((DynamicObject)this.getModel().getValue("org")), (String[])new String[0])) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject settletype = this.getModel().getDataEntity().getDynamicObject("settletype");
                DynamicObjectCollection draftbills = this.getModel().getDataEntity().getDynamicObjectCollection("draftbill");
                if (settletype == null || draftbills == null || !settletype.getString("settlementtype").equals("5") && !settletype.getString("settlementtype").equals("6") || draftbills.size() == 0) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u80cc\u4e66\u4ec5\u9002\u7528\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u662f\u201c\u627f\u5151\u6c47\u7968\u201d\u4e14\u7ed3\u7b97\u53f7\u9009\u62e9\u4e86\u201c\u5e93\u5b58\u7968\u636e\u201d\u7684\u4ed8\u6b3e\u5355\uff0c\u4f60\u6240\u9009\u5355\u636e\u4e0d\u652f\u6301\u80cc\u4e66\u3002", (String)"PaymentBillDraftEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!DraftHelper.isHasRecDrafBill((DynamicObjectCollection)draftbills)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u80cc\u4e66\u4ec5\u9002\u7528\u9009\u62e9\u4e86\u5e93\u5b58\u5e94\u6536\u7968\u636e\u7684\u4ed8\u6b3e\u5355\uff0c\u4f60\u6240\u9009\u5355\u636e\u4e0d\u652f\u6301\u80cc\u4e66\u3002", (String)"PaymentBillDraftEditPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!DraftHelper.isParameterDraftOn((Long)((Long)this.getModel().getDataEntity().getPkValue()), (String)"cas_paybill")) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3002", (String)"PaymentBillDraftEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (settletype == null || draftbills == null || draftbills.size() <= 0 || !Arrays.asList("5", "6").contains(settletype.getString("settlementtype"))) break;
                if (!Boolean.parseBoolean(this.getView().getPageCache().get("doDraftAllocation"))) {
                    Object incompany = this.getModel().getDataEntity().getDynamicObject("org").getPkValue();
                    if (!this.checkDoDraftAllocation(incompany, draftbills.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList()))) {
                        args.setCancel(true);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u8c03\u5ea6\u7535\u5b50\u7968\u636e\uff0c\u9700\u8981\u5728\u7535\u7968\u76f4\u8fde\u8bbe\u7f6e\u5185\u7ef4\u62a4\u8c03\u51fa\u65b9\u8d44\u91d1\u7ec4\u7ec7\u7684\u7968\u636e\u8d26\u6237\uff0c\u5982\u679c\u6ca1\u6709\u7ef4\u62a4\uff0c\u5219\u6309\u7167\u975e\u7535\u7968\u65b9\u5f0f\u5904\u7406\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentBillDraftEditPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("doDraftAllocation", (IFormPlugin)this));
                        return;
                    }
                } else {
                    this.getView().getPageCache().remove("doDraftAllocation");
                }
                Pair result = (Pair)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"EBDraftAllocationService", (String)"doDraftAllocationService", (Object[])new Object[]{this.getModel().getDataEntity()});
                if (result == null) break;
                if ("ING".equals(result.getLeft())) {
                    args.setCancel(true);
                    DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"cas_paybill", (String)"billstatus");
                    info.set("billstatus", (Object)BillStatusEnum.DRAFTING.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
                    this.getView().showSuccessNotification(BillStatusEnum.DRAFTING.getName());
                    this.getView().invokeOperation("refresh");
                    break;
                }
                if ("S".equals(result.getLeft())) break;
                args.setCancel(true);
                this.getView().showErrorNotification(String.join((CharSequence)"\n", (Iterable)result.getRight()));
                break;
            }
            case "recbook": {
                if (!InitCheckPluginHelper.checkInitForPlugin((IFormView)this.getView(), (DynamicObject)((DynamicObject)this.getModel().getValue("org")), (String[])new String[0])) {
                    args.setCancel(true);
                    return;
                }
                String msg = this.vaRecBook();
                if (CasHelper.isEmpty((Object)msg)) break;
                args.setCancel(true);
                this.getView().showTipNotification(msg);
                return;
            }
        }
    }

    private boolean checkDoDraftAllocation(Object incompany, List<Long> draftbills) {
        List draftBillList = Arrays.stream(BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,company,billpool,bankaccount", (QFilter[])new QFilter("id", "in", draftbills).and("company.id", "!=", incompany).and("draftbilltype.billmedium", "=", (Object)"2").toArray())).filter(o -> o.getDynamicObject("company") != null).collect(Collectors.toList());
        if (draftBillList == null || draftBillList.size() < 1) {
            return true;
        }
        Map<Object, Object> billpoolMap = new HashMap(0);
        Object[] billpoolIds = draftBillList.stream().filter(item -> item.getDynamicObject("billpool") != null).map(item -> item.getDynamicObject("billpool").getPkValue()).distinct().toArray();
        if (billpoolIds != null && billpoolIds.length > 0) {
            DynamicObject[] billpools = BusinessDataServiceHelper.load((Object[])billpoolIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_billpool"));
            billpoolMap = Arrays.asList(billpools).stream().collect(Collectors.toMap(item -> item.getPkValue(), item -> item));
        }
        Map<Object, Object> bankaccountMap = new HashMap(0);
        List bankaccountIds = draftBillList.stream().filter(item -> item.getDynamicObject("bankaccount") != null).map(item -> item.getDynamicObject("bankaccount").getPkValue()).collect(Collectors.toList());
        if (bankaccountIds != null && bankaccountIds.size() > 0) {
            DynamicObject[] bankaccounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"bank.bank_cate", (QFilter[])new QFilter("id", "in", bankaccountIds).toArray());
            bankaccountMap = Arrays.asList(bankaccounts).stream().collect(Collectors.toMap(item -> item.getPkValue(), item -> item.getLong("bank.bank_cate.id")));
        }
        Object company = null;
        Object bank_cate = null;
        DynamicObject billpool = null;
        DynamicObject defBillpool = BusinessDataServiceHelper.loadSingle((String)"cdm_billpool", (String)"id,company,dispatchrule", (QFilter[])new QFilter("isdefault", "=", (Object)"1").toArray());
        for (DynamicObject draftbill : draftBillList) {
            company = draftbill.getDynamicObject("company").getPkValue();
            if (!this.isElectronicbill(company)) continue;
            bank_cate = bankaccountMap.get(draftbill.get("bankaccount.id"));
            if (this.isNotInElecticdirconset(company, bank_cate, draftbill.getString("bankaccount.bankaccountnumber"))) {
                return false;
            }
            billpool = draftbill.getDynamicObject("billpool") != null ? (DynamicObject)billpoolMap.get(draftbill.getDynamicObject("billpool").getPkValue()) : defBillpool;
            if (billpool == null || !"indirect".equals(billpool.getString("dispatchrule")) || !this.isNotInElecticdirconset(billpool.getDynamicObject("company").getPkValue(), bank_cate, null)) continue;
            return false;
        }
        return true;
    }

    private boolean isElectronicbill(Object companyId) {
        if (companyId == null) {
            return false;
        }
        AppParam param = new AppParam();
        param.setAppId(AppMetadataCache.getAppInfo((String)"cdm").getId());
        param.setOrgId(Long.valueOf(Long.parseLong(companyId.toString())));
        param.setViewType("08");
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"iselectronicbill");
        return value != null && Boolean.parseBoolean(value.toString());
    }

    private boolean isNotInElecticdirconset(Object company, Object bank_cate, String bankaccountnumber) {
        DynamicObject electricDirect;
        QFilter orgFilter = new QFilter("company", "=", company);
        orgFilter.and("directconnchannel", "=", bank_cate);
        if (bankaccountnumber != null && bankaccountnumber.length() > 0) {
            orgFilter.and("defaultaccount.bankaccountnumber", "=", (Object)bankaccountnumber);
        }
        return (electricDirect = BusinessDataServiceHelper.loadSingle((String)"cdm_electicdirconset", (String)"defaultaccount", (QFilter[])orgFilter.toArray())) == null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "submit": {
                this.endorseSaveCheck(args);
            }
        }
    }

    private void endorseSaveCheck(AfterDoOperationEventArgs args) {
        String errorMsg = OperateServiceHelper.decodeErrorMsg((OperationResult)args.getOperationResult());
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            String BillEndorse = "BillEndorse:";
            if (errorMsg.contains("BillEndorse:")) {
                int indexOf = errorMsg.indexOf("BillEndorse:");
                String aa = errorMsg.substring(indexOf + "BillEndorse:".length());
                args.getOperationResult().setShowMessage(false);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("billEndorse", (IFormPlugin)this);
                this.getView().showConfirm(aa, MessageBoxOptions.OKCancel, confirmCallBacks);
            }
        } else if (args.getOperationResult().isSuccess()) {
            this.saveRelation(this.getPageCache().get("endorseRecBill"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.startsWith("billEndorse") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"cas_recbill", (boolean)false, (int)2);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u6536\u6b3e\u5355", (String)"CasBillEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            DynamicObject paybill = this.getModel().getDataEntity();
            QFilter filter = new QFilter("currency.id", "=", (Object)paybill.getDynamicObject("currency").getLong("id"));
            filter.and(new QFilter("org.id", "=", (Object)paybill.getDynamicObject("org").getLong("id")));
            filter.and(new QFilter("payer", "=", (Object)paybill.getLong("payee")));
            filter.and(new QFilter("billstatus", "=", (Object)"D"));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_draftinfo");
            BigDecimal draftAmt = Constants.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
                draftAmt = entryEntity.stream().map(d -> d.getBigDecimal("transamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            } else {
                DynamicObjectCollection draftbillColl = paybill.getDynamicObjectCollection("draftbill");
                for (DynamicObject draftbill : draftbillColl) {
                    draftAmt = draftAmt.add(((DynamicObject)draftbill.get("fbasedataid")).getBigDecimal("amount"));
                }
            }
            draftAmt = draftAmt.subtract((BigDecimal)this.getModel().getValue("actpayamt"));
            filter.and(new QFilter("actrecamt", "=", (Object)draftAmt));
            List ids = CasBotpHelper.getIdByLink((String)"cas_paybill", (String)"cas_recbill", (Boolean)Boolean.FALSE);
            List recBillPks = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            if (ids != null && ids.size() > 0) {
                filter.and(new QFilter("id", "not in", recBillPks));
            }
            parameter.getListFilterParameter().setFilter(filter);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "billEndorse");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (callBackId.startsWith("doDraftAllocation") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().getPageCache().put("doDraftAllocation", Boolean.TRUE.toString());
            this.getView().invokeOperation("endorse");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object[] pks;
        Object returnData;
        super.closedCallBack(e);
        if ("billEndorse".equals(e.getActionId()) && !CasHelper.isEmpty((Object)(returnData = e.getReturnData())) && (pks = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues()).length > 0) {
            this.getPageCache().put("endorseRecBill", pks[0].toString());
        }
    }

    private void saveRelation(String pkId) {
        Map targetBills;
        Long id = this.getModel().getDataEntity().getLong("id");
        BigDecimal draftAmt = Constants.ZERO;
        DynamicObjectCollection draftbillColl = (DynamicObjectCollection)this.getModel().getValue("draftbill");
        for (DynamicObject draftbill : draftbillColl) {
            draftAmt = draftAmt.add(((DynamicObject)draftbill.get("fbasedataid")).getBigDecimal("amount"));
        }
        BigDecimal actpayamt = (BigDecimal)this.getModel().getValue("actpayamt");
        if (!(id == null || CasHelper.isEmpty((Object)pkId) && draftAmt.compareTo(actpayamt) != 0 && draftbillColl.size() != 0 || CasHelper.isEmpty((Object)(targetBills = BFTrackerServiceHelper.findTargetBills((String)"cas_paybill", (Long[])new Long[]{id}))) || !targetBills.containsKey("cas_recbill") || ((HashSet)targetBills.get("cas_recbill")).size() <= 0)) {
            CasBotpHelper.deleteRation(((HashSet)targetBills.get("cas_recbill")).iterator().next(), (String[])new String[]{"cas_paybill"});
        }
        if (CasHelper.isEmpty((Object)pkId) || Constants.ZERO.equals(draftAmt) || draftAmt.compareTo(actpayamt) == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(Long.valueOf(pkId));
        CasBotpHelper.saveRelation((String)"cas_paybill", (Long)id, (String)"cas_recbill", ids);
    }

    private String vaRecBook() {
        IDataModel model = this.getModel();
        Object draf = model.getValue("draftbill");
        if (!BillStatusEnum.AUDIT.getValue().equals(model.getValue("billstatus"))) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u5f00\u7968\u767b\u8bb0\u3002", (String)"PaymentBillDraftEditPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        if (!DraftHelper.isSettle((Object)model.getValue("settletype"))) {
            return ResManager.loadKDString((String)"\u5f00\u7968\u767b\u8bb0\u4ec5\u9002\u7528\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u662f\u627f\u5151\u6c47\u7968\u3001\u652f\u7968\u6216\u672c\u7968\u7684\u4ed8\u6b3e\u5355\uff0c\u4f60\u6240\u9009\u5355\u636e\u4e0d\u652f\u6301\u5f00\u7968\u767b\u8bb0\u3002", (String)"PaymentBillDraftEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        if (!CasHelper.isEmpty((Object)draf) && ((DynamicObjectCollection)draf).size() > 0) {
            if (DraftHelper.isHasRecDrafBill((DynamicObjectCollection)((DynamicObjectCollection)draf))) {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u9009\u62e9\u76f8\u5173\u5e94\u6536\u7968\u636e\uff0c\u8bf7\u8fdb\u884c\u80cc\u4e66\u5904\u7406\u3002", (String)"PaymentBillDraftEditPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u9009\u62e9\u76f8\u5173\u5e94\u4ed8\u7968\u636e\uff0c\u8bf7\u8fdb\u884c\u786e\u8ba4\u4ed8\u6b3e\u5904\u7406\u3002", (String)"PaymentBillDraftEditPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        if (!DraftHelper.isParameterDraftOn((Long)((Long)this.getModel().getDataEntity().getPkValue()), (String)"cas_paybill")) {
            return ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3002", (String)"PaymentBillDraftEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"cas_paybill", (Long[])new Long[]{(Long)this.getModel().getDataEntity().getPkValue()});
        HashSet pkValues = (HashSet)botpMap.get("cdm_payablebill");
        boolean isExistNotDeadFlag = false;
        if (null != pkValues && pkValues.size() > 0) {
            DynamicObject[] payableBills;
            for (DynamicObject payableBill : payableBills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues.toArray())})) {
                if (BillStatusEnum.DEAD.getValue().equals(payableBill.getString("billstatus"))) continue;
                isExistNotDeadFlag = true;
            }
        }
        if (isExistNotDeadFlag) {
            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u8fdb\u884c\u5f00\u7968\u767b\u8bb0\u3002", (String)"PaymentBillDraftEditPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void viewDrafBill() {
        DynamicObjectCollection draftBills = (DynamicObjectCollection)this.getModel().getValue("draftbill");
        if (draftBills == null || draftBills.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7968\u636e\u8bb0\u5f55\u3002", (String)"PaymentBillDraftEditPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject draftBill : draftBills) {
            idSet.add(((DynamicObject)draftBill.get("fbasedataid")).getLong("id"));
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("cdm_payandrecdraft_f7");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setLookUp(true);
        QFilter qFilter = new QFilter("id", "in", idSet);
        parameter.getListFilterParameter().getQFilters().add(qFilter);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

