/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomPrintDataObjectArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.AcctBalanceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.opservice.impl.PaymentPayImpl;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.util.PayeeInfoHelper;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AcctClassifyEnum;
import kd.fi.cas.enums.AsstActTypeAddressEnum;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.FeePayerEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.PaymentTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.SourceTypeEnum;
import kd.fi.cas.formplugin.PaymentBillList;
import kd.fi.cas.formplugin.common.CasBillEdit;
import kd.fi.cas.formplugin.helper.InitCheckPluginHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPayeeOrPayerHelper;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.CountryHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.PayBillListPlugnHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.PluginSignHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.FormUtils;

public class PaymentBillEdit
extends CasBillEdit
implements ClickListener,
RowClickEventListener,
SignCallbackLisenter {
    private String labCurrencySign;
    private int currencyAmtprecision;
    private Format currencyFormat;
    private static final String KEY_DIFFPAY_CALLBACK = "KEY_DIFFPAY_CALLBACK";
    private static final String CONFIRM_DEL_CALLBACK = "CONFIRM_DEL_CALLBACK";
    private static final String KEY_CALLBACK_CHARGEBACK = "CALLBACK_CHARGEBACK";
    private static final String KEY_CLOSECALLBACK_CHARGEBACK = "CALLBACK_SELECTDRAFT";
    private static Log logger = LogFactory.getLog(PaymentBillEdit.class);
    private Long orgId;
    private boolean isBeConfirmOK = false;
    private Set<String> settleTypes = Stream.of(SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.DRAFT.getValue(), SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());

    private void initFormat() {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(this.labCurrencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(this.currencyAmtprecision);
        this.currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        BillShowParameter showParameter = (BillShowParameter)e.getSource();
        Object pkId = showParameter.getPkId();
        if (pkId != null && !pkId.equals(0L)) {
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"cas_paybill", (String)"id, billtype");
            DynamicObject billtype = info.getDynamicObject("billtype");
            if (billtype != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue())) {
                e.getFormShowParameter().setFormId("cas_paybill_synonym");
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u540c\u540d\u8f6c\u8d26", (String)"PaymentBillEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
                e.getFormShowParameter().setFormId("cas_paybill_cash");
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u73b0\u91d1\u5b58\u53d6", (String)"PaymentBillEdit_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (billtype != null && BillTypeConstants.PAYBILL_SPAN.equals(billtype.getPkValue())) {
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8de8\u4e3b\u4f53\u8c03\u62e8", (String)"PaymentBillEdit_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (billtype != null && BillTypeConstants.PAYBILL_DCEP.equals(billtype.getPkValue())) {
                e.getFormShowParameter().setFormId("cas_paybill_dcep");
                e.getFormShowParameter().addCustPlugin("kd.fi.cas.formplugin.pay.PayBillDcepEdit");
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6570\u5e01\u5b58\u53d6", (String)"PaymentBillEdit_32", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else {
            String formId = showParameter.getFormId();
            if ("cas_paybill_synonym".equals(formId)) {
                e.getFormShowParameter().setFormId("cas_paybill_synonym");
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u540c\u540d\u8f6c\u8d26", (String)"PaymentBillEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if ("cas_paybill_cash".equals(formId)) {
                e.getFormShowParameter().setFormId("cas_paybill_cash");
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u73b0\u91d1\u5b58\u53d6", (String)"PaymentBillEdit_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if ("cas_paybill_spanmainpart".equals(formId)) {
                e.getFormShowParameter().setFormId("cas_paybill_spanmainpart");
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8de8\u4e3b\u4f53\u8c03\u62e8", (String)"PaymentBillEdit_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if ("cas_paybill_dcep".equals(formId)) {
                e.getFormShowParameter().setFormId("cas_paybill_dcep");
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6570\u5e01\u5b58\u53d6", (String)"PaymentBillEdit_32", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"changepayer", "changepayee", "addpayeelb1", "addpayeelb2", "settletnumber", "applyname"});
        this.initF7();
    }

    private void initF7() {
        this.fillPaymentType();
        this.fillEntryPaymentType();
        this.fillCurrency();
        this.fillEntrustorg();
        this.setSettlementTypeFilter();
        CasPluginHelper.filterNetBankAcct((BasedataEdit)((BasedataEdit)this.getControl("netbankacct")), (DynamicObject)((DynamicObject)this.getValue("payeracctbank")));
        this.expenseItem();
        this.fillFundFlow();
    }

    private void fillFundFlow() {
    }

    protected void expenseItem() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("e_expenseitem");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object[] objects = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"id,expenseitem", (QFilter[])new QFilter[]{new QFilter("billtype.bill_number.number", "=", (Object)"cas_paybill")});
            if (EmptyUtil.isEmpty((Object[])objects)) {
                return;
            }
            List ids = Arrays.stream(objects).map(o -> o.get("expenseitem.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    protected String getControlBankAcctForSettleType() {
        return "payeracctbank";
    }

    private void fillEntrustorg() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("entrustorg");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("orgFuncId", (Object)"08");
        });
    }

    private void fillEntryPaymentType() {
        BasedataEdit entryPaymenttypeF7 = (BasedataEdit)this.getControl("e_paymenttype");
        entryPaymenttypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter = qFilter.and(new QFilter("biztype", "!=", (Object)"110"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillPaymentType() {
        BasedataEdit paymenttypeF7 = (BasedataEdit)this.getControl("paymenttype");
        paymenttypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
            boolean multipaymenttype = (Boolean)this.getModel().getValue("multipaymenttype");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            Object entrance = this.getModel().getValue("entrance");
            if (!CasHelper.isEmpty((Object)this.getModel().getDataEntity().getPkValue())) {
                DynamicObject payemntType = (DynamicObject)this.getModel().getValue("paymenttype");
                String sourceType = (String)this.getModel().getValue("sourcetype");
                if (payemntType != null && !PaymentTypeEnum.OTR.name().equals(entrance)) {
                    qFilter = PaymentTypeEnum.DCEP.name().equals(entrance) ? qFilter.and(new QFilter("biztype", "=", (Object)"219_S")) : qFilter.and(new QFilter("ispartpayment", "=", (Object)(payemntType.getBoolean("ispartpayment") ? "1" : "0")));
                } else if (PaymentTypeEnum.AP.name().equals(sourceType)) {
                    qFilter = qFilter.and(new QFilter("ispartpayment", "=", (Object)"1"));
                } else if (!PaymentTypeEnum.AP.name().equals(entrance) && !PaymentTypeEnum.OTR.name().equals(entrance)) {
                    qFilter = qFilter.and(new QFilter("ispartpayment", "=", (Object)"0"));
                }
            }
            if (entrance != null && !"".equals(entrance)) {
                if (PaymentTypeEnum.AP.name().equals(entrance)) {
                    qFilter = qFilter.and(new QFilter("ispartpayment", "=", (Object)"1"));
                } else if (PaymentTypeEnum.DCEP.name().equals(entrance)) {
                    qFilter = qFilter.and(new QFilter("biztype", "=", (Object)"219_S"));
                } else if (!PaymentTypeEnum.OTR.name().equals(entrance)) {
                    qFilter = qFilter.and(new QFilter("ispartpayment", "=", (Object)"0"));
                }
            }
            if ("pm_purorderbill".equals(sourceBillType) || "conm_purcontract".equals(sourceBillType)) {
                qFilter = qFilter.and(new QFilter("biztype", "=", (Object)"202")).and(new QFilter("ispartpayment", "=", (Object)"1"));
                qFilter = qFilter.and(new QFilter("ispartpayment", "=", (Object)"1"));
            }
            qFilter = multipaymenttype ? qFilter.and(new QFilter("biztype", "=", (Object)"110")) : qFilter.and(new QFilter("biztype", "!=", (Object)"110"));
            if (multipaymenttype) {
                QFilter multipaymenttypeqFilter = new QFilter("enable", "=", (Object)"1");
                multipaymenttypeqFilter.and(new QFilter("biztype", "=", (Object)"110"));
                qFilter = multipaymenttypeqFilter;
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
            if (!isDiffCur.booleanValue()) {
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
                if (isCash) {
                    DynamicObject accountCash = (DynamicObject)this.getModel().getValue("payeracctcash");
                    if (accountCash != null) {
                        List currencys = AccountCashHelper.getCurrencys(Collections.singletonList((Long)accountCash.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                } else {
                    DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
                    if (payerAcctBank != null) {
                        Set currencys = AccountBankHelper.getCurrencyPks((long)((Long)payerAcctBank.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                }
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultPaymentChannelValue();
        if (!"true".equals(this.getPageCache().get("isFromWebApi"))) {
            this.createNewModel();
        }
        this.setValue("businesstype", null);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"netbankacct"});
        this.getEntryCache();
        this.calculateAmt();
        DynamicObject settleType = this.getDynamicObject("settletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.setValue("payeracctcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payer"));
        }
        this.setCrossPayValue();
        DynamicObject paymenttype = this.getDynamicObject("paymenttype");
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            entry.set("e_paymenttype", (Object)paymenttype);
        }
    }

    private void getEntryCache() {
        String str_json = this.getPageCache().get("entry");
        if (str_json != null) {
            this.getModel().deleteEntryRow("entry", 0);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("e_expenseitem", new Object[0]).addField("e_payableamt", new Object[0]).addField("project", new Object[0]).addField("e_fundflowitem", new Object[0]).addField("e_remark", new Object[0]).addField("e_paymenttype", new Object[0]);
            Map maps = (Map)SerializationUtils.fromJsonString((String)str_json, Map.class);
            ArrayList list = (ArrayList)maps.get("entry");
            for (Map map : list) {
                vs.addRow(new Object[]{map.get("e_expenseitem"), map.get("e_payableamt"), map.get("project"), map.get("e_fundflowitem"), map.get("e_remark"), map.get("e_paymenttype")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entry", vs);
            this.getView().updateView("entry");
        }
    }

    private void setDefaultPaymentChannelValue() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChannelEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.COUNTER.getName(), (String)"PaymentBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        comboItems.add(comboItem);
        paymentChannel.setComboItems(comboItems);
        this.getModel().setValue("paymentchannel", (Object)comboItem.getValue());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject paymenttype = (DynamicObject)this.getModel().getValue("paymenttype");
        if (null != paymenttype && !paymenttype.getBoolean("ispartpayment")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"settleorg"});
        }
        this.settleOrg(false);
        if (this.isBotpNew()) {
            this.supplePayeeInfo();
        }
        this.getModel().setDataChanged(false);
    }

    private void supplePayeeInfo() {
        Object sourcebilltype = this.getModel().getValue("sourcebilltype");
        if (!CasHelper.isEmpty((Object)sourcebilltype)) {
            Object payee = this.getModel().getValue("payee");
            Object payeebanknumMo = this.getModel().getValue("payeebanknum");
            Object payeebankMo = this.getModel().getValue("payeebank");
            Object payeeType = this.getValue("payeetype");
            if (CasHelper.isEmpty((Object)payeebanknumMo) && CasHelper.isEmpty((Object)payeebankMo)) {
                String billName = this.getModel().getDataEntityType().getName();
                Map resultMap = CasPayeeOrPayerHelper.getPayeeOrPayerInfo((Object)payee, (Object)payeeType, (String)billName);
                if (resultMap.size() > 0) {
                    Object bankaccount = resultMap.get("payeebanknum");
                    Object accountname = resultMap.get("accountname");
                    DynamicObject payeebank = (DynamicObject)resultMap.get("payeebank");
                    this.getModel().setValue("payeebanknum", bankaccount);
                    this.getModel().setValue("recaccbankname", accountname);
                    if (!CasHelper.isEmpty((Object)payeebank)) {
                        this.fillProvinceAndCity(payeebank);
                    }
                }
            } else if (!CasHelper.isEmpty((Object)payeebankMo)) {
                this.fillProvinceAndCity((DynamicObject)payeebankMo);
            }
        }
    }

    private void fillProvinceAndCity(DynamicObject payeeBank) {
        payeeBank = BusinessDataServiceHelper.loadSingle((Object)payeeBank.getPkValue(), (String)payeeBank.getDataEntityType().getName(), (String)"id,name,number,country,provincetxt,citytxt,union_number");
        this.getModel().setValue("payeebank", (Object)payeeBank);
        this.getModel().setValue("payeebankname", (Object)payeeBank.getString("name"));
        this.getModel().setValue("recbanknumber", (Object)payeeBank.getString("union_number"));
        this.getModel().setValue("reccountry", (Object)payeeBank.getDynamicObject("country"));
        this.getModel().setValue("recprovince", (Object)payeeBank.getString("provincetxt"));
        this.getModel().setValue("reccity", (Object)payeeBank.getString("citytxt"));
    }

    private void createNewModel() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"usage"});
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        if (this.getModel().getValue("org") != null) {
            this.orgId = this.getPk("org");
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_paybill", (String)"47156aff000000ac");
            if (!CollectionUtils.isEmpty((Collection)authorizedBankOrgId)) {
                this.orgId = (Long)authorizedBankOrgId.get(0);
                this.setValue("org", this.orgId);
            } else {
                this.orgId = null;
            }
        }
        this.setValueIfAbsent("bizdate", DateUtils.getCurrentDate());
        if (customParams != null && customParams.containsKey("paymentType")) {
            QFilter qFilter;
            String entrance = (String)customParams.get("paymentType");
            this.setValue("entrance", entrance);
            long billTypeID = 0L;
            if (PaymentTypeEnum.AP.name().equals(entrance)) {
                qFilter = new QFilter("ispartpayment", "=", (Object)"1").and("biztype", "=", (Object)"201");
                this.setPaymentType(qFilter);
                billTypeID = BillTypeConstants.PAYBILL_PUR;
            } else if (PaymentTypeEnum.SYN.name().equals(entrance)) {
                qFilter = new QFilter("biztype", "=", (Object)"214");
                this.setPaymentType(qFilter);
                billTypeID = BillTypeConstants.PAYBILL_SYN;
            } else if (PaymentTypeEnum.SPAN.name().equals(entrance)) {
                qFilter = new QFilter("biztype", "=", (Object)"217");
                this.setPaymentType(qFilter);
                billTypeID = BillTypeConstants.PAYBILL_SPAN;
            } else if (PaymentTypeEnum.CASH.name().equals(entrance)) {
                qFilter = new QFilter("biztype", "=", (Object)"215");
                this.setPaymentType(qFilter);
                billTypeID = BillTypeConstants.PAYBILL_CASH;
            } else if (PaymentTypeEnum.DCEP.name().equals(entrance)) {
                qFilter = new QFilter("biztype", "=", (Object)"219_S");
                this.setPaymentType(qFilter);
                billTypeID = BillTypeConstants.PAYBILL_DCEP;
            } else {
                if (PaymentTypeEnum.ER.name().equals(entrance)) {
                    qFilter = new QFilter("biztype", "=", (Object)"211");
                    this.setPaymentType(qFilter);
                } else if (PaymentTypeEnum.OTR.name().equals(entrance)) {
                    qFilter = new QFilter("biztype", "=", (Object)"999");
                    this.setPaymentType(qFilter);
                }
                billTypeID = BillTypeConstants.PAYBILL_OTR;
            }
            this.setValue("issingle", "1");
            if (billTypeID != 0L && QueryServiceHelper.exists((String)"bos_billtype", (Object)billTypeID)) {
                this.setValue("billtype", billTypeID);
            }
        }
        this.fillPayeeType(true);
        if (CasHelper.isEmpty((Object)this.orgId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit", "bar_beforesubmit"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u3002", (String)"PaymentBillEdit_30", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!InitCheckPluginHelper.checkInitForPlugin((IFormView)this.getView(), (DynamicObject)this.getDynamicObject("org"), (String[])new String[]{"bar_save", "bar_submit", "bar_beforesubmit"})) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit", "bar_beforesubmit"});
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)this.orgId);
        this.setValue("basecurrency", baseCurrency);
        this.setPayBillCurrency(baseCurrency);
        this.setDefaultExratetable(this.orgId);
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        this.setValue("settletype", defaultSettleType);
        if (!BaseDataHelper.isSettleTypeCash((DynamicObject)defaultSettleType)) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)this.orgId);
            if (defaultPayAccount != null && (BaseDataHelper.isSettleTypeVirtual((DynamicObject)defaultSettleType) && VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultPayAccount).booleanValue() || !BaseDataHelper.isSettleTypeVirtual((DynamicObject)defaultSettleType) && !VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultPayAccount).booleanValue())) {
                this.setValue("payeracctbank", defaultPayAccount);
                baseCurrency = defaultPayAccount.getDynamicObject("defaultcurrency");
                this.setPayBillCurrency(baseCurrency);
                this.payerAcctBankF7Changed(defaultPayAccount);
                this.currencyF7Changed(false);
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchangerate"});
                this.clearBalanceValue();
            }
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgId, (String)"bos_org");
        this.getModel().setValue("payernumber", (Object)org.getString("number"));
        this.getModel().setValue("uniformsocialcreditcode", (Object)org.getString("uniformsocialcreditcode"));
        this.setPayerInfo4Lb();
        this.setOpenOrg();
    }

    private void setPayBillCurrency(DynamicObject baseCurrency) {
        this.setValue("currency", baseCurrency);
        this.setValue("dpcurrency", baseCurrency);
        this.setValue("feecurrency", baseCurrency);
    }

    private void setPayerInfo4Lb() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        this.getModel().setValue("orgv", (Object)CasHelper.getLocalValue((DynamicObject)org, (String)"name"));
        String defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_fkf_80_80.png";
        Image orgPic = (Image)this.getControl("orgpic");
        orgPic.setUrl(defaultUrl);
        String v_payerbanknum = "";
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            DynamicObject payerAcctCash = (DynamicObject)this.getModel().getValue("payeracctcash");
            if (payerAcctCash != null) {
                v_payerbanknum = payerAcctCash.getString("number");
            }
            this.getModel().setValue("payeracctbank", null);
        } else {
            DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
            if (payerAcctBank != null) {
                v_payerbanknum = kd.fi.cas.util.StringUtils.splitString((String)payerAcctBank.getString("bankaccountnumber"), (int)4, (String)" ");
            }
            this.getModel().setValue("payeracctcash", null);
        }
        ((Label)this.getControl("payerbanknumv")).setText(v_payerbanknum);
        DynamicObject payerBank = (DynamicObject)this.getModel().getValue("payerbank");
        String v_payerbankname = "";
        if (payerBank != null) {
            v_payerbankname = CasHelper.getLocalValue((DynamicObject)payerBank, (String)"name");
        }
        ((Label)this.getControl("payerbanknamev")).setText(v_payerbankname);
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)((DynamicObject)this.getModel().getValue("settletype")));
        this.getView().setVisible(Boolean.valueOf(!isCash), new String[]{"payerbanknamev", "payerbanknamelb"});
        DcepConverHelper.initImage((IFormView)this.getView());
    }

    private void fillPayeeType(boolean setDefaultValue) {
        boolean multipaymenttype = (Boolean)this.getModel().getValue("multipaymenttype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject paymenttype = (DynamicObject)this.getModel().getValue("paymenttype");
        boolean isSelectallpayertype = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            isSelectallpayertype = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"selectallpayeetype");
        }
        ComboEdit payeetypeCbo = (ComboEdit)this.getView().getControl("payeetype");
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        String entrance = (String)this.getModel().getValue("entrance");
        if (PaymentTypeEnum.AP.name().equals(entrance)) {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
            if (multipaymenttype || isSelectallpayertype) {
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
            }
        } else if (PaymentTypeEnum.SYN.name().equals(entrance) || PaymentTypeEnum.CASH.name().equals(entrance) || PaymentTypeEnum.DCEP.name().equals(entrance)) {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
        } else if (PaymentTypeEnum.OTR.name().equals(entrance)) {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
            if (multipaymenttype || EmptyUtil.isNoEmpty((DynamicObject)paymenttype) && (!paymenttype.getBoolean("ispartpayment") || isSelectallpayertype)) {
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
            }
        } else {
            for (AsstActTypeEnum asstAct : AsstActTypeEnum.values()) {
                comboItem.add(new ComboItem(new LocaleString(asstAct.getName()), asstAct.getValue()));
            }
        }
        payeetypeCbo.setComboItems(comboItem);
        String payeetype = (String)this.getModel().getValue("payeetype");
        boolean conPayeeTypeBool = false;
        if (CasHelper.isNotEmpty((Object)payeetype)) {
            conPayeeTypeBool = comboItem.stream().anyMatch(b -> payeetype.equals(b.getValue()));
        }
        if (setDefaultValue && !conPayeeTypeBool) {
            this.getModel().setValue("payeetype", (Object)((ComboItem)comboItem.get(0)).getValue());
        }
        if (PaymentTypeEnum.SPAN.name().equals(entrance)) {
            this.getModel().setValue("payeetype", (Object)AsstActTypeEnum.COMPANY.getValue());
        }
        Object value = this.getModel().getValue("payeetype");
        boolean ishave = false;
        for (ComboItem combo : comboItem) {
            if (value == null || !combo.getValue().equals(value)) continue;
            ishave = true;
            break;
        }
        if (!ishave) {
            this.getModel().setValue("payeetype", null);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        boolean isFillPayeeInfo = Boolean.TRUE;
        if (e != null && e.getSourceData() != null && e.getSourceData().containsKey("isfillpayeeinfo")) {
            isFillPayeeInfo = (Boolean)e.getSourceData().get("isfillpayeeinfo");
        }
        this.setDefaultPayeeBank();
        if (isFillPayeeInfo) {
            PaymentFillPropHelper.fillProp((DynamicObject)this.getModel().getDataEntity(), (boolean)false);
        }
        if (this.getModel().getValue("entrance") == null) {
            this.setEntrance();
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getPageCache().put("isFromWebApi", "true");
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject billType = (DynamicObject)this.getValue("billtype");
        if (billType != null && BillTypeConstants.PAYBILL_PUR.longValue() == billType.getLong("id")) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.AP.name());
        }
        this.fillPayeeType(false);
        this.setValue("sourcetype", SourceTypeEnum.CAS);
        DynamicObject paymentType = (DynamicObject)this.getValue("paymenttype");
        if (paymentType != null && paymentType.getBoolean("ispartpayment")) {
            int count = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < count; ++i) {
                this.setValue("e_unlockamt", (BigDecimal)this.getModel().getValue("e_payableamt", i), i);
                this.setValue("e_unsettledamt", (BigDecimal)this.getModel().getValue("e_payableamt", i), i);
            }
            this.getView().updateView("entry");
        }
        this.showBalance();
        this.showRBalance();
        this.setNetBankAcctVisible();
        DynamicObject accountBank = this.getDynamicObject("payeracctbank");
        this.setPaymentChannelValue(accountBank, Boolean.TRUE);
        DynamicObject crossTranType0 = (DynamicObject)this.getModel().getValue("crosstrantype");
        if (crossTranType0 != null) {
            DynamicObject crossTransType = BusinessDataServiceHelper.loadSingle((Object)crossTranType0.getPkValue(), (String)"bei_crosstrantype");
            DynamicObjectCollection dynamicObjectCollection = crossTransType.getDynamicObjectCollection("entry");
            this.isCrossTranTypeHide(dynamicObjectCollection);
        }
        this.getModel().deleteEntryData("cas_draftinfo");
        this.getModel().setValue("applyorg", null);
        DynamicObject settleType = this.getDynamicObject("settletype");
        if (BaseDataHelper.isSettleTypeMatch((DynamicObject)settleType)) {
            this.setValue("matchflag", AutoMatchFlagEnum.NONEED.getValue());
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.showBalance();
        this.showRBalance();
        this.setNetBankAcctVisible();
        DynamicObject crossTranType0 = (DynamicObject)this.getModel().getValue("crosstrantype");
        if (crossTranType0 != null) {
            DynamicObject crossTransType = BusinessDataServiceHelper.loadSingle((Object)crossTranType0.getPkValue(), (String)"bei_crosstrantype");
            DynamicObjectCollection dynamicObjectCollection = crossTransType.getDynamicObjectCollection("entry");
            this.isCrossTranTypeHide(dynamicObjectCollection);
        }
    }

    private void ctrRefundInfoVisibility() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_refund_save"});
        String billstatus = (String)this.getValue("billstatus");
        this.getView().setVisible(Boolean.valueOf(BillStatusEnum.REFUND.getValue().equals(billstatus) || BillStatusEnum.RENOTE.getValue().equals(billstatus)), new String[]{"e_refundamt", "e_refunddes"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"e_refundamt", "e_refunddes"});
    }

    private void setNetBankAcctVisible() {
        String paymentchannel = (String)this.getValue("paymentchannel");
        this.getView().setVisible(Boolean.valueOf(null != paymentchannel && CasPluginHelper.isExistOnlineNetBank((DynamicObject)((DynamicObject)this.getValue("payeracctbank")))), new String[]{"netbankacct"});
    }

    private void setEntrance() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType == null) {
            return;
        }
        Long billTypeId = billType.getLong("id");
        if (BillTypeConstants.PAYBILL_PUR.equals(billTypeId)) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.AP.name());
        } else if (BillTypeConstants.PAYBILL_EXP.equals(billTypeId)) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.OTR.name());
        } else if (BillTypeConstants.PAYBILL_OTR.equals(billTypeId)) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.OTR.name());
        } else if (BillTypeConstants.PAYBILL_SYN.equals(billTypeId)) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.SYN.name());
        } else if (BillTypeConstants.PAYBILL_CASH.equals(billTypeId)) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.CASH.name());
        } else if (BillTypeConstants.PAYBILL_SPAN.equals(billTypeId)) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.SPAN.name());
        } else if (BillTypeConstants.PAYBILL_DCEP.equals(billTypeId)) {
            this.getModel().setValue("entrance", (Object)PaymentTypeEnum.DCEP.name());
        }
    }

    public void customPrintDataObject(CustomPrintDataObjectArgs e) {
        super.customPrintDataObject(e);
        String entityKey = e.getDataSourceName();
        if ("cas_paybill".equals(entityKey)) {
            ArrayList<DynamicObject> dataEntitiesv = new ArrayList<DynamicObject>();
            DynamicObject dsv = this.getModel().getDataEntity();
            DynamicObject basecur = (DynamicObject)this.getModel().getValue("basecurrency");
            if (basecur != null) {
                dsv.set("basecurrency", (Object)basecur.getString("name"));
            }
            if (dsv.getString("payeetype") != null && dsv.getString("payeetype").length() > 0) {
                dsv.set("payeetype", (Object)AsstActTypeEnum.getName((String)dsv.getString("payeetype")));
            }
            dataEntitiesv.add(dsv);
            e.setDataEntities(dataEntitiesv);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int iRow = changeData[0].getRowIndex();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "paymenttype": {
                this.paymentTypeChanged((DynamicObject)newValue);
                this.fillPayeeType(true);
                break;
            }
            case "bizdate": {
                this.exratedateChanged(newValue);
                break;
            }
            case "exratetable": {
                this.currencyF7Changed(false);
                this.setRecInfo("dpexratetable", newValue, Boolean.FALSE);
                break;
            }
            case "exratedate": {
                this.currencyF7Changed(false);
                this.setRecInfo("dpexratedate", newValue, Boolean.FALSE);
                break;
            }
            case "payeetype": {
                this.payeeTypeChanged((String)newValue, true);
                break;
            }
            case "org": {
                this.fillPayeeType(true);
                this.setOpenOrg();
                this.showBalance();
                this.showRBalance();
                this.resetExrateTableWhenSwitchOrg(newValue);
                break;
            }
            case "payeracctbank": {
                this.payerAcctBankF7Changed(newValue);
                this.isOnlinebankVisibility();
                break;
            }
            case "payeracctcash": {
                this.payerAcctCashChanged((DynamicObject)newValue);
                break;
            }
            case "currency": {
                this.currencyF7Changed(true);
                this.setRecInfo("dpcurrency", newValue, Boolean.TRUE);
                this.setExratetableVisibility();
                break;
            }
            case "exchangerate": 
            case "agreedquotation": 
            case "payquotation": 
            case "dppayquotation": {
                this.calculateAmt();
                break;
            }
            case "settletype": {
                this.settleTypeChanged(newValue);
                this.settletNumber((DynamicObject)newValue);
                this.isClearSettleType((DynamicObject)oldValue, (DynamicObject)newValue);
                if (this.isClearFeeSettleType()) {
                    this.setValue("fee", null);
                }
                this.setLCopenBtnShow((DynamicObject)newValue);
                break;
            }
            case "settletnumber": {
                this.settletNumberChg(oldValue, newValue);
            }
            case "billstatus": {
                PaymentBillPluginHelper.fillToolBar((AbstractFormPlugin)this, (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "e_payableamt": {
                this.entries_payableAmtChanged((BigDecimal)newValue, oldValue, iRow);
                break;
            }
            case "e_discountamt": {
                this.entries_discountAmtChanged((BigDecimal)newValue, oldValue, iRow);
                break;
            }
            case "entrustorg": {
                this.entrustorgChange(newValue);
                break;
            }
            case "paymentchannel": {
                this.paymentchannelChange();
                break;
            }
            case "e_refundamt": {
                this.refundChange((BigDecimal)newValue, (BigDecimal)oldValue, iRow);
                break;
            }
            case "crosstrantype": {
                DynamicObject crossTranType0 = (DynamicObject)this.getModel().getValue("crosstrantype");
                if (crossTranType0 == null) break;
                DynamicObject crossTransType = BusinessDataServiceHelper.loadSingle((Object)crossTranType0.getPkValue(), (String)"bei_crosstrantype");
                DynamicObjectCollection dynamicObjectCollection = crossTransType.getDynamicObjectCollection("entry");
                this.isCrossTranTypeHide(dynamicObjectCollection);
                for (DynamicObject dyobj : dynamicObjectCollection) {
                    String settleMethod = ResManager.loadKDString((String)"\u6e05\u7b97\u65b9\u5f0f", (String)"PaymentBillEdit_27", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                    if (!StringUtils.equals((CharSequence)settleMethod, (CharSequence)dyobj.getString("fieldname")) || !StringUtils.isNotEmpty((CharSequence)dyobj.getString("defaultvalue"))) continue;
                    this.getModel().setValue("settlementmethod", (Object)dyobj.getString("defaultvalue"));
                }
                break;
            }
            case "applyid": {
                DynamicObject applyDo = (DynamicObject)newValue;
                if (applyDo == null) break;
                String name = applyDo.getString("name");
                String phone = applyDo.getString("phone");
                this.getModel().beginInit();
                this.getModel().setValue("applyname", (Object)name);
                this.getModel().endInit();
                if (StringUtils.isNotEmpty((CharSequence)phone)) {
                    this.getModel().setValue("applyphone", (Object)phone);
                }
                this.batchUpdateView("applyname");
                break;
            }
            case "payerbank": {
                this.setCrossPayValue();
                break;
            }
            case "payeeacctbank": {
                this.showRBalance();
                break;
            }
            case "multipaymenttype": {
                this.dealMultiPayMentType(newValue);
                this.fillPayeeType(true);
                break;
            }
            case "e_paymenttype": {
                this.delaSettOrg(newValue, iRow);
                this.dealFoundFlowItem(newValue, iRow);
                break;
            }
            case "iscrosspay": {
                Long payeeId;
                if (newValue != null && !((Boolean)newValue).booleanValue()) {
                    this.setValue("recaddress", null);
                    break;
                }
                if (newValue == null || !((Boolean)newValue).booleanValue() || !EmptyUtil.isNoEmpty((Long)(payeeId = (Long)this.getValue("payee")))) break;
                this.setDefaultAddress(payeeId);
                break;
            }
            case "actpayamt": {
                DynamicObjectCollection entries;
                DynamicObject billtype = this.getDynamicObject("billtype");
                List<Object> objects = Arrays.asList(BillTypeConstants.PAYBILL_SYN, BillTypeConstants.PAYBILL_CASH, BillTypeConstants.PAYBILL_DCEP, BillTypeConstants.PAYBILL_SPAN);
                if (billtype == null || !objects.contains(billtype.getPkValue()) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)(entries = this.getModel().getEntryEntity("entry"))) || entries.size() <= 0) break;
                BigDecimal localPayAmt = this.calcLocalAmt((BigDecimal)newValue);
                this.getModel().beginInit();
                this.getModel().setValue("e_actamt", newValue, 0);
                this.getModel().setValue("e_payablelocamt", (Object)localPayAmt, 0);
                this.getModel().setValue("e_localamt", (Object)localPayAmt, 0);
                this.getModel().setValue("localamt", (Object)localPayAmt);
                this.getModel().endInit();
                this.getModel().setValue("e_payableamt", newValue, 0);
                this.getView().updateView("e_payableamt", 0);
                this.getView().updateView("e_actamt", 0);
                this.getView().updateView("e_payablelocamt", 0);
                this.getView().updateView("e_localamt", 0);
                this.getView().updateView("localamt");
                break;
            }
        }
    }

    private BigDecimal calcLocalAmt(BigDecimal actPayAmt) {
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        String quotation = this.getString("payquotation");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        return QuotationHelper.callToCurrency((BigDecimal)actPayAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
    }

    private void dealFoundFlowItem(Object newValue, int iRow) {
        DynamicObject e_paymenttype = (DynamicObject)newValue;
        if (EmptyUtil.isEmpty((DynamicObject)e_paymenttype)) {
            this.setValue("e_fundflowitem", null, iRow);
        } else {
            DynamicObject fundflowitem = e_paymenttype.getDynamicObject("fundflowitem");
            if (EmptyUtil.isNoEmpty((DynamicObject)fundflowitem)) {
                this.setValue("e_fundflowitem", fundflowitem.getPkValue(), iRow);
            }
        }
    }

    private void delaSettOrg(Object newValue, int iRow) {
        if (this.isLockSettleOrg()) {
            return;
        }
        DynamicObject e_paymenttype = (DynamicObject)newValue;
        if (EmptyUtil.isEmpty((DynamicObject)e_paymenttype)) {
            this.setValue("settleorg", null, iRow);
        } else {
            Object openOrg = this.getModel().getValue("openorg");
            if (openOrg != null) {
                DynamicObject accountOrg = (DynamicObject)openOrg;
                if (e_paymenttype.getBoolean("ispartpayment") && CasHelper.isEmpty((Object)this.getModel().getValue("settleorg", iRow))) {
                    this.setValue("settleorg", accountOrg.getPkValue(), iRow);
                }
            }
        }
    }

    private void dealMultiPayMentType(Object newValue) {
        boolean multipaymenttype = (Boolean)newValue;
        boolean ishave = false;
        if (multipaymenttype) {
            QFilter qFilter = new QFilter("biztype", "=", (Object)"110");
            qFilter.and("default", "=", (Object)Character.valueOf('1'));
            qFilter.and("enable", "=", (Object)"1");
            Object[] payMentBillTypes = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,name,number,ispartpayment,biztype", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((Object[])payMentBillTypes)) {
                this.getModel().setValue("paymenttype", null);
            } else {
                this.getModel().setValue("paymenttype", payMentBillTypes[0]);
            }
        } else {
            int count = this.getModel().getEntryRowCount("entry");
            if (count == 0) {
                this.getModel().setValue("paymenttype", null);
                return;
            }
            for (int i = 0; i < count; ++i) {
                DynamicObject e_paymenttype = (DynamicObject)this.getModel().getValue("e_paymenttype", i);
                if (!EmptyUtil.isNoEmpty((DynamicObject)e_paymenttype)) continue;
                ishave = true;
                break;
            }
            if (ishave) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u591a\u4ed8\u6b3e\u7c7b\u578b\u5c06\u81ea\u52a8\u6e05\u7a7a\u4ed8\u6b3e\u660e\u7ec6\u4ed8\u6b3e\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentBillEdit_31", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clearPaymentTypeConfirm", (IFormPlugin)this));
            } else {
                this.getModel().setValue("paymenttype", null);
            }
        }
    }

    private void isCrossTranTypeHide(DynamicObjectCollection dyobj) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject[] crossTransType = BusinessDataServiceHelper.load((String)"bei_crosstranfield", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        Set number = dyobj.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Arrays.stream(crossTransType).forEach(e -> {
            if (!number.contains(e.getLong("id"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{e.getString("number")});
            }
        });
    }

    private void isClearSettleType(DynamicObject oldValue, DynamicObject newValue) {
        String settletnumber = (String)this.getModel().getValue("settletnumber");
        if (this.settleTypeChg(settletnumber, SettleMentTypeEnum.CREDIT.getValue(), oldValue, newValue)) {
            this.getPageCache().put("isClearCreditSettletNumber", "true");
            this.getModel().setValue("settletnumber", null);
            this.getModel().setValue("sourcebilltype", null);
            this.getModel().setValue("sourcebillid", null);
            this.getModel().setValue("sourcetype", (Object)"CAS");
            this.getModel().deleteEntryData("billhead_lk");
            this.getModel().deleteEntryData("entry");
        }
        if (this.settleTypeChg(settletnumber, SettleMentTypeEnum.CREDITOPEN.getValue(), oldValue, newValue)) {
            this.getPageCache().put("srcLcNoHaveValueClear", settletnumber);
            this.getModel().setValue("settletnumber", null);
        }
    }

    private boolean settleTypeChg(String needClearValue, String pageOldValue, DynamicObject oldValue, DynamicObject newValue) {
        return EmptyUtil.isNoEmpty((String)needClearValue) && Objects.nonNull(oldValue) && pageOldValue.equals(oldValue.getString("settlementtype")) && (Objects.nonNull(newValue) && !pageOldValue.equals(newValue.getString("settlementtype")) || Objects.isNull(newValue));
    }

    private void settletNumber(DynamicObject newValue) {
        if (Objects.isNull(newValue)) {
            return;
        }
        Object settlementType = newValue.get("settlementtype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (Objects.nonNull(org)) {
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean visible = false;
            if (Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"isdraft");
            } else if (Objects.equals(settlementType, SettleMentTypeEnum.PROMISSORY.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"ischeck");
            } else if (Objects.equals(settlementType, SettleMentTypeEnum.CHECK.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"ispromissorynote");
            }
            this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"settletnumber"});
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"draftbill"});
        }
        String settlenumber = this.getString("settletnumber");
        if ((PayBillHepler.isCreditSettlement((DynamicObject)newValue) || PayBillHepler.isLCSettlement((DynamicObject)newValue, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN)) && settlenumber != null && settlenumber.trim().length() > 0 && "cas_payapplybill".equals(this.getString("sourcebilltype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"settletype", "settletnumber"});
        }
    }

    private void refundChange(BigDecimal newValue, BigDecimal oldValue, int iRow) {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal e_actamt = (BigDecimal)model.getValue("e_actamt", iRow);
        if (BigDecimal.ZERO.compareTo(newValue) != 0) {
            if (BigDecimal.ZERO.compareTo(newValue) > 0) {
                model.setValue("e_refundamt", (Object)oldValue, iRow);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0\u6216\u8005\u5c0f\u4e8e0\u3002", (String)"PaymentBillEdit_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (e_actamt.compareTo(newValue) < 0) {
                model.setValue("e_refundamt", (Object)oldValue, iRow);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u5f97\u8d85\u8fc7\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"PaymentBillEdit_20", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void paymentchannelChange() {
        if (this.isBeiBePay()) {
            this.setValue("fee", null);
        }
        this.isOnlinebankVisibility();
        this.ctrBeInfoVisibility();
        this.changePayeeValue();
    }

    private void entrustorgChange(Object newValue) {
        if (null != newValue) {
            this.getModel().setValue("settletype", null);
            this.setEntrustBtnShow(true);
            return;
        }
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        this.setValue("settletype", defaultSettleType);
        this.setEntrustBtnShow(false);
    }

    private void setLCopenBtnShow(DynamicObject newValue) {
        boolean lcOpenSettleType = null != newValue && SettleMentTypeEnum.CREDITOPEN.getValue().equals(newValue.getString("settlementtype"));
        this.getView().setVisible(Boolean.valueOf(lcOpenSettleType), new String[]{"lcopen"});
    }

    private void settletNumberChg(Object oldValue, Object newValue) {
        String oldSettletNumber;
        DynamicObject letterCredit;
        DynamicObject value = (DynamicObject)this.getModel().getValue("settletype");
        if (PayBillHepler.isLCSettlement((DynamicObject)value, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN) && StringUtils.isNotBlank((Object)oldValue) && StringUtils.isBlank((Object)newValue) && (letterCredit = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)(oldSettletNumber = (String)oldValue))})) != null) {
            this.getPageCache().put("srcLcNoHaveValueClear", oldSettletNumber);
        }
    }

    private void addEntryCache() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        ArrayList list = new ArrayList();
        for (DynamicObject row : entry) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("e_expenseitem", row.get("e_expenseitem") == null ? null : ((DynamicObject)row.get("e_expenseitem")).getPkValue());
            map.put("e_payableamt", row.get("e_payableamt"));
            map.put("project", row.get("project") == null ? null : row.getDynamicObject("project").getPkValue());
            map.put("e_fundflowitem", row.get("e_fundflowitem") == null ? null : row.getDynamicObject("e_fundflowitem").getPkValue());
            map.put("e_remark", row.get("e_remark"));
            map.put("e_paymenttype", row.get("e_paymenttype") == null ? null : row.getDynamicObject("e_paymenttype").getPkValue());
            list.add(map);
        }
        HashMap map = new HashMap();
        map.put("entry", list);
        String mapJson = SerializationUtils.toJsonString(map);
        this.getPageCache().put("entry", mapJson);
    }

    private void paymentTypeChanged(DynamicObject paymentType) {
        String entrance = (String)this.getModel().getValue("entrance");
        if (paymentType != null && PaymentTypeEnum.OTR.name().equals(entrance)) {
            boolean isAp = paymentType.getBoolean("ispartpayment");
            Long billTypeID = this.getPk("billtype");
            boolean isChange = false;
            if (isAp) {
                if (!BillTypeConstants.PAYBILL_EXP.equals(billTypeID)) {
                    this.addEntryCache();
                }
            } else if (!BillTypeConstants.PAYBILL_OTR.equals(billTypeID)) {
                this.addEntryCache();
                this.setValue("billtype", BusinessDataServiceHelper.loadSingleFromCache((Object)BillTypeConstants.PAYBILL_OTR, (String)"bos_billtype"));
                isChange = true;
            }
            if (isChange) {
                this.getModel().beginInit();
                this.setValue("paymenttype", paymentType);
                this.getModel().endInit();
                this.batchUpdateView("paymenttype");
                Label payeebanknumvLable = (Label)this.getControl("payeebanknumv");
                payeebanknumvLable.setText("");
                Label recaccbanknamevLable = (Label)this.getControl("recaccbanknamev");
                recaccbanknamevLable.setText("");
                Label payeebanknamevLable = (Label)this.getControl("payeebanknamev");
                payeebanknamevLable.setText("");
                Label recbanknumbervLable = (Label)this.getControl("recbanknumberv");
                recbanknumbervLable.setText("");
            }
        }
        boolean multipaymenttype = this.getModel().getDataEntity().getBoolean("multipaymenttype");
        if (paymentType != null) {
            boolean isAp = paymentType.getBoolean("ispartpayment");
            if (!multipaymenttype) {
                this.getView().setVisible(Boolean.valueOf(isAp), new String[]{"settleorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"settleorg"});
            }
            this.settleOrg(false);
            this.fillFundflowItem(true);
        }
        if (!multipaymenttype) {
            for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                this.setValue("e_paymenttype", paymentType, i);
            }
        }
    }

    private void settleTypeChanged(Object newValue) {
        this.ctrBeInfoVisibility();
        DynamicObject settleType = (DynamicObject)newValue;
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.setValue("payeracctbank", null);
            this.setValue("payerbank", null);
            DynamicObject accountCash = this.getDynamicObject("payeracctcash");
            if (accountCash == null) {
                this.setValue("payeracctcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payer"));
            }
            this.setValue("isdiffcur", "0");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdiffcur"});
        } else {
            this.setValue("payeracctcash", null);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isdiffcur"});
        }
        if (BaseDataHelper.isSettleTypeMatch((DynamicObject)settleType)) {
            this.setValue("matchflag", AutoMatchFlagEnum.NONEED.getValue());
        } else {
            this.setValue("matchflag", AutoMatchFlagEnum.NONE.getValue());
        }
        if (PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN)) {
            this.setValue("iswaitsche", false);
        }
        this.setPayerInfo4Lb();
        DynamicObject accountBank = this.getDynamicObject("payeracctbank");
        this.setPaymentChannelValue(accountBank, Boolean.TRUE);
        this.changePayeeValue();
    }

    private void ctrBeInfoVisibility() {
        boolean isBePay = this.isBePay();
        this.getView().setVisible(Boolean.valueOf(!this.isDraft()), new String[]{"settletnumber"});
        this.getView().setVisible(Boolean.valueOf(this.isDraft()), new String[]{"draftbill"});
        this.getView().setVisible(Boolean.valueOf(isBePay), new String[]{"usage"});
    }

    private boolean isDraft() {
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        if (settleType != null) {
            String settlementType = settleType.getString("settlementtype");
            return Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.CHECK.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.PROMISSORY.getValue());
        }
        return false;
    }

    private void exratedateChanged(Object newValue) {
        if (newValue == null) {
            return;
        }
        this.setValue("exratedate", newValue);
        this.setValue("dpexratedate", newValue);
    }

    private void currencyF7Changed(boolean reBalance) {
        if (reBalance) {
            this.showBalance();
            this.showRBalance();
        }
        this.setExchangerateEditable();
    }

    private void entries_payableAmtChanged(BigDecimal payableAmt, Object oldValue, int iRow) {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal discountAmt = (BigDecimal)model.getValue("e_discountamt", iRow);
        BigDecimal bigDecimal = discountAmt = discountAmt != null ? discountAmt : BigDecimal.ZERO;
        if (discountAmt.abs().compareTo(payableAmt.abs()) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6298\u6263\u7edd\u5bf9\u503c\u4e0d\u5f97\u8d85\u8fc7\u5e94\u4ed8\u91d1\u989d\u7edd\u5bf9\u503c\u3002", (String)"PaymentBillEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
            this.setValue("e_payableamt", oldValue, iRow);
            return;
        }
        this.calculateAmt();
    }

    private void entries_discountAmtChanged(BigDecimal discountAmt, Object oldValue, int iRow) {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal payableAmt = (BigDecimal)model.getValue("e_payableamt", iRow);
        BigDecimal bigDecimal = payableAmt = payableAmt != null ? payableAmt : BigDecimal.ZERO;
        if (discountAmt.abs().compareTo(payableAmt.abs()) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6298\u6263\u7edd\u5bf9\u503c\u4e0d\u5f97\u8d85\u8fc7\u5e94\u4ed8\u91d1\u989d\u7edd\u5bf9\u503c\u3002", (String)"PaymentBillEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
            this.setValue("e_discountamt", oldValue, iRow);
            return;
        }
        this.calculateAmt();
    }

    private void calculateAmt() {
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        String quotation = this.getString("payquotation");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal discountAmt;
            DynamicObject rowInfo = this.getModel().getEntryRowEntity("entry", i);
            BigDecimal payAmount = rowInfo.getBigDecimal("e_payableamt");
            if (payAmount != null) {
                this.setValue("e_payablelocamt", QuotationHelper.callToCurrency((BigDecimal)payAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if ((discountAmt = rowInfo.getBigDecimal("e_discountamt")) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if (payAmount != null && discountAmt != null) {
                BigDecimal actAmt = payAmount.subtract(discountAmt);
                sumAmt = sumAmt.add(actAmt);
                BigDecimal actLocalAmt = BigDecimal.ZERO;
                actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_actamt", actAmt, i);
                this.setValue("e_localamt", actLocalAmt, i);
            }
            if (payAmount == null) continue;
            this.setValue("e_unsettledamt", payAmount.subtract(rowInfo.getBigDecimal("e_settledamt")), i);
            this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)payAmount.subtract(rowInfo.getBigDecimal("e_settledamt")), (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            this.setValue("e_unlockamt", payAmount.subtract(rowInfo.getBigDecimal("e_lockAmt")), i);
        }
        this.setValue("actpayamt", sumAmt);
        sumLocalAmt = QuotationHelper.callToCurrency((BigDecimal)sumAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
        this.setValue("localamt", sumLocalAmt);
        if (count > 1) {
            BigDecimal sumTopCountDiff2 = this.getModel().getEntryEntity("entry").stream().limit(count - 1).map(dynamicObject -> dynamicObject.getBigDecimal("e_localamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.setValue("e_localamt", sumLocalAmt.subtract(sumTopCountDiff2), count - 1);
        }
        this.calculateDpAmt();
    }

    private void calculateDpAmt() {
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        DynamicObject currency = this.getDynamicObject("currency");
        String dppayquotation = this.getString("dppayquotation");
        String agreedquotation = this.getString("agreedquotation");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int dppayround = 10;
        if (dpcurrency != null) {
            dppayround = dpcurrency.getInt("amtprecision");
        }
        BigDecimal actPayAmt = this.getBigDecimal("actpayamt");
        if (currency != null) {
            actPayAmt = actPayAmt.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = this.getBigDecimal("localamt");
        BigDecimal agreedRate = this.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = BigDecimal.ZERO;
        dpAmt = QuotationHelper.callToCurrency((BigDecimal)actPayAmt, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = BigDecimal.ZERO;
        dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        this.getModel().beginInit();
        this.setValue("dpamt", dpAmt);
        this.setValue("dplocalamt", dpLocalAmt);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt));
        this.getModel().endInit();
        this.batchUpdateView("dpamt", "dplocalamt", "lossamt");
    }

    private void payeeTypeChanged(String payeeType, boolean isChanged) {
        if (isChanged) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_addpayee"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_payeeinfo"});
            this.clearPayeeValue();
        }
    }

    private void clearPayeeValue() {
        Object value = null;
        this.setValue("payeeformid", value);
        this.setValue("payee", value);
        this.setValue("payeename", value);
        this.setValue("payeeaccformid", value);
        this.setValue("payeeacctbank", value);
        this.setValue("payeebanknum", value);
        this.setValue("payeebank", value);
        this.setValue("payeebankname", value);
        this.setValue("recaccbankname", value);
        this.setValue("recbanknumber", value);
        this.setValue("payeenumber", null);
        this.setValue("supplierBankId", null);
        this.setValue("recaddress", null);
    }

    private void payerAcctBankF7Changed(Object newValue) {
        DynamicObject payerAcctBank = (DynamicObject)newValue;
        this.ctrBeInfoVisibility();
        this.showBalance();
        if (!FeePayerEnum.REC.getValue().equals(this.getString("feepayer"))) {
            this.setValue("feeactbank", payerAcctBank);
        }
        if (payerAcctBank == null) {
            this.setValue("payerbank", null);
            this.setPaymentChannelValue(null, Boolean.TRUE);
            this.setCurrencyEditable();
            return;
        }
        this.setValue("payerbank", payerAcctBank.getDynamicObject("bank"));
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        DynamicObject payCurrency = null;
        payCurrency = isDiffCur != false ? this.getDynamicObject("dpcurrency") : this.getDynamicObject("currency");
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"bd_accountbanks", (Object)payerAcctBank.getPkValue(), (DynamicObject)payCurrency);
        if (!containCurrency) {
            Long defaultCurrencyId = (Long)payerAcctBank.get("defaultcurrency.id");
            if (isDiffCur.booleanValue()) {
                this.setValue("dpcurrency", defaultCurrencyId);
            } else if (this.isBotpCreate()) {
                this.setValueIfAbsent("currency", defaultCurrencyId);
            } else {
                this.setValue("currency", defaultCurrencyId);
            }
        }
        this.setCurrencyEditable();
        DynamicObject openOrg = (DynamicObject)this.getModel().getValue("openorg");
        if (openOrg == null) {
            this.setOpenOrg();
        }
        this.setPaymentChannelValue(payerAcctBank, Boolean.TRUE);
        this.setSettleTypeValue(payerAcctBank);
        this.settleOrg(true);
    }

    private void setPaymentChannelValue(DynamicObject payerAcctBank, boolean isAdd) {
        ComboItem item2;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        DynamicObject settleType = this.getDynamicObject("settletype");
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChannelEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(PaymentChannelEnum.COUNTER.getName()));
        ComboItem selectedItem = comboItem;
        comboItems.add(comboItem);
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (null == payerAcctBank || settleType != null && "14".equals(settleType.getString("settlementtype")) || billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            paymentChannel.setComboItems(comboItems);
            if (isAdd) {
                this.getModel().setValue("paymentchannel", (Object)selectedItem.getValue());
                if ("bei".equalsIgnoreCase(selectedItem.getValue())) {
                    this.getModel().setValue("fee", null);
                    this.getModel().setValue("singlestream", (Object)Boolean.FALSE);
                }
            }
            return;
        }
        if (payerAcctBank.getBoolean("isopenbank")) {
            item2 = new ComboItem();
            item2.setValue(PaymentChannelEnum.ONLINEBANK.getValue());
            item2.setCaption(new LocaleString(PaymentChannelEnum.ONLINEBANK.getName()));
            selectedItem = item2;
            comboItems.add(item2);
        }
        if (payerAcctBank.getBoolean("issetbankinterface")) {
            item2 = new ComboItem();
            item2.setValue(PaymentChannelEnum.BEI.getValue());
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.BEI.getName(), (String)"PaymentBillEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            selectedItem = item2;
            comboItems.add(item2);
        }
        String defaultPaymentChannel = "";
        if (Objects.nonNull(settleType)) {
            String paymentChannelRange = settleType.getString("paymentchannel");
            defaultPaymentChannel = settleType.getString("defaultpaymentchannel");
            if (StringUtils.isNotEmpty((CharSequence)paymentChannelRange)) {
                Set paymentChannels = Arrays.stream(paymentChannelRange.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                comboItems.removeIf(i -> !paymentChannels.contains(i.getValue()));
            }
        }
        paymentChannel.setComboItems(comboItems);
        if (isAdd || this.isBotpNew() && Objects.isNull(this.getModel().getValue("paymentchannel"))) {
            String defChannel = selectedItem.getValue();
            if (settleType != null && !SettleMentTypeEnum.COLLECT.getValue().equals(settleType.getString("settlementtype"))) {
                defChannel = PaymentChannelEnum.COUNTER.getValue();
            }
            if (StringUtils.isNotEmpty((CharSequence)defaultPaymentChannel)) {
                defChannel = defaultPaymentChannel;
            }
            String finalDefChannel = defChannel;
            boolean contains = comboItems.stream().anyMatch(item -> Objects.equals(finalDefChannel, item.getValue()));
            if (!contains) {
                defChannel = null;
            }
            if ("bei".equalsIgnoreCase(defChannel)) {
                this.getModel().setValue("fee", null);
                this.getModel().setValue("singlestream", (Object)Boolean.FALSE);
            }
            this.getModel().setValue("paymentchannel", (Object)defChannel);
        }
    }

    private void payerAcctCashChanged(DynamicObject acctCash) {
        if (acctCash == null) {
            this.setValueIfAbsent("currency", this.getDynamicObject("basecurrency"));
            this.setCurrencyEditable();
            this.showBalance();
            return;
        }
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        DynamicObject payCurrency = null;
        payCurrency = isDiffCur != false ? this.getDynamicObject("dpcurrency") : this.getDynamicObject("currency");
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"cas_accountcash", (Object)acctCash.getPkValue(), (DynamicObject)payCurrency);
        if (!containCurrency) {
            DynamicObject defaultCurrency = acctCash.getDynamicObject("defaultcurrency");
            if (isDiffCur.booleanValue()) {
                this.setValue("dpcurrency", defaultCurrency);
            } else if (this.isBotpCreate()) {
                this.setValueIfAbsent("currency", defaultCurrency);
            } else {
                this.setValue("currency", defaultCurrency);
            }
        }
        this.setCurrencyEditable();
        this.setValue("openorg", acctCash.getDynamicObject("openorg"));
        this.showBalance();
    }

    private void setCurrencyEditable() {
        Boolean isCurrencyEditable = Boolean.TRUE;
        DynamicObject settleType = this.getDynamicObject("settletype");
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (isCash) {
            DynamicObject accountCash = this.getDynamicObject("payeracctcash");
            if (accountCash != null) {
                isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
            }
        } else {
            DynamicObject accountBank = this.getDynamicObject("payeracctbank");
            if (accountBank != null) {
                isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
            }
        }
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            this.getView().setEnable(isCurrencyEditable, new String[]{"dpcurrency"});
        } else {
            this.getView().setEnable(isCurrencyEditable, new String[]{"currency"});
        }
        if (this.isBotpCreate()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        }
    }

    private void showBalance() {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit", "bar_beforesubmit"});
        if (this.getModel().getValue("org") == null) {
            return;
        }
        Long orgID = this.getPk("org");
        Long acctBankId = this.getPk("payeracctbank");
        Long acctCashId = this.getPk("payeracctcash");
        Long currencyId = this.getPk("currency");
        boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur) {
            currencyId = this.getPk("dpcurrency");
        }
        if (orgID == null || acctBankId == null && acctCashId == null || currencyId == null) {
            this.clearBalanceValue();
            return;
        }
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        try {
            BigDecimal currentBalance = BigDecimal.ZERO;
            if (CasHelper.isNotEmpty((Object)acctBankId)) {
                DynamicObject acctBank = BusinessDataServiceHelper.loadSingle((Object)acctBankId, (String)"am_accountbank", (String)"acctclassify");
                if (Objects.equals(acctBank.get("acctclassify"), AcctClassifyEnum.I.getValue())) {
                    currentBalance = PaymentBillEdit.getCurrBalance(acctBank);
                } else {
                    String balanceType = SystemParameterFcsHelper.getParameterString((long)orgID, (String)"balancevalue");
                    Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalance", (Object[])new Object[]{balanceType, acctBankId, currencyId});
                    BizBalanceModelBean bizBalanceModelBean = (BizBalanceModelBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), BizBalanceModelBean.class);
                    currentBalance = bizBalanceModelBean.getAmount();
                }
            }
            if (CasHelper.isNotEmpty((Object)acctCashId)) {
                currentBalance = AcctBalanceHelper.getAccountCashCurrBalance((Long)orgID, (Long)acctCashId, (Long)currencyId, (Date)new Date());
                ((Label)this.getControl("balancelb")).setText(ResManager.loadKDString((String)"\u8d26\u9762\u4f59\u989d\uff1a", (String)"PaymentBillEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                LocaleString content = new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e3a\u73b0\u91d1\u8d26\u6237\u65f6\uff0c\u8d26\u9762\u4f59\u989d\u5373\u4e3a\u5f53\u524d\u65f6\u70b9\u73b0\u91d1\u65e5\u8bb0\u8d26\u8d26\u9762\u4f59\u989d\u3002", (String)"PaymentBillEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                ((Label)this.getControl("balancelb")).addTips(new Tips("text", null, content, false, null));
            }
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("balancev")).setText(this.currencyFormat.format(currentBalance == null ? Integer.valueOf(0) : currentBalance));
        }
        catch (Exception err) {
            this.clearBalanceValue();
            logger.error("\u4ed8\u6b3e\u5373\u65f6\u4f59\u989d\u5237\u65b0\u9519\u8bef", (Throwable)err);
        }
    }

    private void showRBalance() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"rbalanceflexpanelap"});
        Object billType = this.getModel().getValue("billtype");
        boolean isPayBillSyn = false;
        if (billType != null) {
            if (BillTypeConstants.PAYBILL_CASH.equals(((DynamicObject)billType).getPkValue())) {
                return;
            }
            if (BillTypeConstants.PAYBILL_SYN.equals(((DynamicObject)billType).getPkValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"rbalanceflexpanelap"});
                isPayBillSyn = true;
            }
        }
        if (this.getModel().getValue("org") == null) {
            return;
        }
        Long orgID = this.getPk("org");
        if (!isPayBillSyn && this.getModel().getValue("payee") != null) {
            Long payeeId = Long.valueOf(String.valueOf(this.getValue("payee")));
            if ("bos_org".equals(this.getModel().getValue("payeetype")) && Objects.equals(orgID, payeeId)) {
                isPayBillSyn = true;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"rbalanceflexpanelap"});
            }
        }
        if (!isPayBillSyn) {
            return;
        }
        Long acctBankId = null;
        if (this.getValue("payeeacctbank") != null) {
            acctBankId = Long.valueOf(String.valueOf(this.getValue("payeeacctbank")));
        }
        Long currencyId = this.getPk("currency");
        boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur) {
            currencyId = this.getPk("dpcurrency");
        }
        if (orgID == null || acctBankId == null || currencyId == null) {
            this.clearBalanceValue();
            return;
        }
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        BigDecimal currentBalance = BigDecimal.ZERO;
        try {
            if (CasHelper.isNotEmpty((Object)acctBankId)) {
                DynamicObject acctBank = BusinessDataServiceHelper.loadSingle((Object)acctBankId, (String)"am_accountbank", (String)"acctclassify");
                if (Objects.equals(acctBank.get("acctclassify"), AcctClassifyEnum.I.getValue())) {
                    currentBalance = PaymentBillEdit.getCurrBalance(acctBank);
                } else {
                    String balanceType = SystemParameterFcsHelper.getParameterString((long)orgID, (String)"balancevalue");
                    Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalance", (Object[])new Object[]{balanceType, acctBankId, currencyId});
                    BizBalanceModelBean bizBalanceModelBean = (BizBalanceModelBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), BizBalanceModelBean.class);
                    currentBalance = bizBalanceModelBean.getAmount();
                }
            }
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("rbalancev")).setText(this.currencyFormat.format(currentBalance == null ? Integer.valueOf(0) : currentBalance));
        }
        catch (Exception err) {
            this.clearRBalanceValue();
            logger.error("\u6536\u6b3e\u5373\u65f6\u4f59\u989d\u5237\u65b0\u9519\u8bef", (Throwable)err);
        }
    }

    private static BigDecimal getCurrBalance(DynamicObject bankAcct) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ifm_accountbalance", (String)"amount", (QFilter[])new QFilter("accountbank", "=", bankAcct.getPkValue()).toArray(), (String)"bizdate desc", (int)1);
        return load.length > 0 ? load[0].getBigDecimal("amount") : BigDecimal.ZERO;
    }

    private void clearBalanceValue() {
        ((Label)this.getControl("balancelb")).setText(ResManager.loadKDString((String)"\u5373\u65f6\u4f59\u989d\uff1a", (String)"PaymentBillEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        LocaleString content = new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u5f53\u524d\u65f6\u70b9\u4f59\u989d\u3002\u4ed8\u6b3e\u8d26\u6237\u5373\u65f6\u4f59\u989d\u53d6\u503c\u6765\u6e90\u6709\u94f6\u4f01\u4e92\u8054\u4f59\u989d\u8868\u3001\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u65e5\u8bb0\u8d26\uff1b\u7cfb\u7edf\u652f\u6301\u56db\u79cd\u53d6\u503c\u6a21\u5f0f\uff1a\uff081\uff09\u5b8c\u5168\u53d6\u81ea\u4f59\u989d\u8868\uff1b\uff082\uff09\u5b8c\u5168\u53d6\u81ea\u65e5\u8bb0\u8d26\uff1b\uff083\uff09\u4f18\u5148\u53d6\u4f59\u989d\u8868\uff0c\u518d\u53d6\u65e5\u8bb0\u8d26\uff1b\uff084\uff09\u5f00\u901a\u94f6\u4f01\u53d6\u4f59\u989d\u8868\uff0c\u672a\u5f00\u901a\u94f6\u4f01\u53d6\u65e5\u8bb0\u8d26\u3002\u5177\u4f53\u91c7\u53d6\u4f55\u79cd\u6a21\u5f0f\u8bf7\u524d\u5f80\u201c\u7cfb\u7edf\u670d\u52a1\u4e91>\u914d\u7f6e\u5de5\u5177>\u7cfb\u7edf\u53c2\u6570>\u8d44\u91d1\u4e91>\u8d44\u91d1\u516c\u5171\u670d\u52a1\u201d\u4e2d\u67e5\u770b\u3002", (String)"PaymentBillEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        ((Label)this.getControl("balancelb")).addTips(new Tips("text", null, content, false, null));
        DynamicObject currency = this.getDynamicObject("currency");
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            currency = this.getDynamicObject("dpcurrency");
        }
        if (!CasHelper.isEmpty((Object)currency)) {
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("balancev")).setText(this.currencyFormat.format(BigDecimal.ZERO));
        } else {
            ((Label)this.getControl("balancev")).setText("\uffe50.00");
        }
    }

    private void clearRBalanceValue() {
        ((Label)this.getControl("rbalancelb")).setText(ResManager.loadKDString((String)"\u5373\u65f6\u4f59\u989d\uff1a", (String)"PaymentBillEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        LocaleString content = new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u5f53\u524d\u65f6\u70b9\u4f59\u989d\u3002\u4ed8\u6b3e\u8d26\u6237\u5373\u65f6\u4f59\u989d\u53d6\u503c\u6765\u6e90\u6709\u94f6\u4f01\u4e92\u8054\u4f59\u989d\u8868\u3001\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u65e5\u8bb0\u8d26\uff1b\u7cfb\u7edf\u652f\u6301\u56db\u79cd\u53d6\u503c\u6a21\u5f0f\uff1a\uff081\uff09\u5b8c\u5168\u53d6\u81ea\u4f59\u989d\u8868\uff1b\uff082\uff09\u5b8c\u5168\u53d6\u81ea\u65e5\u8bb0\u8d26\uff1b\uff083\uff09\u4f18\u5148\u53d6\u4f59\u989d\u8868\uff0c\u518d\u53d6\u65e5\u8bb0\u8d26\uff1b\uff084\uff09\u5f00\u901a\u94f6\u4f01\u53d6\u4f59\u989d\u8868\uff0c\u672a\u5f00\u901a\u94f6\u4f01\u53d6\u65e5\u8bb0\u8d26\u3002\u5177\u4f53\u91c7\u53d6\u4f55\u79cd\u6a21\u5f0f\u8bf7\u524d\u5f80\u201c\u7cfb\u7edf\u670d\u52a1\u4e91-\u914d\u7f6e\u5de5\u5177-\u7cfb\u7edf\u53c2\u6570-\u8d44\u91d1\u4e91-\u8d44\u91d1\u516c\u5171\u670d\u52a1\u201d\u4e2d\u67e5\u770b\u3002", (String)"PaymentBillEdit_6_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        ((Label)this.getControl("rbalancelb")).addTips(new Tips("text", null, content, false, null));
        DynamicObject currency = this.getDynamicObject("currency");
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            currency = this.getDynamicObject("dpcurrency");
        }
        if (!CasHelper.isEmpty((Object)currency)) {
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = currency.getInt("amtprecision");
            this.initFormat();
            ((Label)this.getControl("rbalancev")).setText(this.currencyFormat.format(BigDecimal.ZERO));
        } else {
            ((Label)this.getControl("rbalancev")).setText("\uffe50.00");
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"e_payableamt", "e_discountamt", "contractnumber", "e_corebillno", "e_corebillentryseq"});
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "changepayer": {
                this.changePayerPage();
                break;
            }
            case "addpayeelb1": 
            case "addpayeelb2": {
                this.addPayee();
                break;
            }
            case "changepayee": {
                this.changePayeePage();
                break;
            }
            case "settletnumber": {
                this.settleNumberClick();
                break;
            }
            case "applyname": {
                BasedataEdit applyF7 = (BasedataEdit)this.getControl("applyid");
                applyF7.click();
            }
        }
    }

    private void settleNumberClick() {
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.CREDIT.getValue().equals(settleType.getString("settlementtype"))) {
            String appId = AppMetadataCache.getAppInfo((String)"lc").getId();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            AppParam param = new AppParam();
            param.setAppId(appId);
            param.setOrgId(Long.valueOf(org.getLong("id")));
            param.setViewType("08");
            String paymethod = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"paymethod");
            if ("0".equals(paymethod)) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "settletnumber");
                QFilter qFilterSour = new QFilter("arrivalstatus", "=", (Object)"arrival_confirm");
                qFilterSour.and("arrivalway", "!=", (Object)"protest");
                qFilterSour.and(QFilter.sqlExpress((String)"arrivalamount", (String)">", (String)"flockamount"));
                qFilterSour.and("isinit", "=", (Object)Character.valueOf('0'));
                qFilterSour.and("eassrcid", "=", (Object)"");
                CasBotpHelper.doBeforeDraw((IFormView)this.getView(), (String)"lc_arrival", (String)this.getModel().getDataEntityType().getName(), (Boolean)false, (QFilter)qFilterSour, (CloseCallBack)closeCallBack);
            }
        } else if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.CREDITOPEN.getValue().equals(settleType.getString("settlementtype"))) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "creditopen_settletnumber");
            Long orgId = this.getPk("org");
            Long bankId = this.getPk("payerbank");
            Long dpcurrencyId = this.getPk("dpcurrency");
            BigDecimal actPayAmt = this.getBigDecimal("actpayamt");
            String payeeType = this.getString("payeetype");
            String payeeName = this.getString("payeename");
            ArrayList<String> tipList = new ArrayList<String>(5);
            if (EmptyUtil.isEmpty((String)payeeType)) {
                tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Long)orgId) || CasHelper.isEmpty((Object)payeeName) || EmptyUtil.isEmpty((Long)bankId)) {
                tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u4fe1\u606f\u3002", (String)"PayApplyEdit_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Long)dpcurrencyId)) {
                tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u5e01\u79cd\u3002", (String)"PayApplyEdit_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (actPayAmt.compareTo(BigDecimal.ZERO) == 0) {
                tipList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"PayApplyEdit_27", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (!tipList.isEmpty()) {
                String tips = String.join((CharSequence)"\r\n", tipList);
                String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u4fe1\u7528\u8bc1\u5f00\u7acb\u65f6:\r\n%s", (String)"PayApplyEntryEdit_29", (String)"fi-cas-formplugin", (Object[])new Object[0]), tips);
                this.getView().showTipNotification(msg);
                return;
            }
            QFilter qFilter = PaymentBillEdit.lcBizF7Filter(orgId, bankId, dpcurrencyId, actPayAmt, payeeType, payeeName);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"lc_lettercredit", (boolean)false);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public static QFilter lcBizF7Filter(Long orgId, Long bankId, Long dpcurrencyId, BigDecimal actPayAmt, String payeeType, String payeeName) {
        QFilter qFilter = new QFilter("tradechannel", "=", (Object)"online").and("bebankstatus", "=", (Object)"TS").or("tradechannel", "=", (Object)"offline");
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("creditstatus", "=", (Object)"done_register");
        qFilter.and("org", "=", (Object)orgId);
        qFilter.and("bank", "=", (Object)bankId);
        qFilter.and("currency", "=", (Object)dpcurrencyId);
        qFilter.and("amount", ">=", (Object)actPayAmt);
        List<String> payeeTypeList = Arrays.asList("bos_user", "other");
        if (payeeTypeList.contains(payeeType)) {
            payeeType = "fbd_other";
        }
        qFilter.and("benefitertype", "=", (Object)payeeType);
        qFilter.and("benefiterother", "=", (Object)payeeName);
        qFilter.and("sourcebilltype", "!=", (Object)"cas_paybill");
        return qFilter;
    }

    private void changePayeePage() {
        String payeeType = this.getString("payeetype");
        if (EmptyUtil.isEmpty((String)payeeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            this.opreatePayee(Boolean.FALSE);
        }
    }

    private void addPayee() {
        this.opreatePayee(Boolean.TRUE);
    }

    private void opreatePayee(Boolean isAddNew) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (this.isHwControl()) {
            paramMap.put("hw_payeesiteid", this.getValue("hw_payeesiteid"));
        }
        paramMap.put("org", this.getPk("org"));
        paramMap.put("asstActType", this.getString("payeetype"));
        paramMap.put("isBE", this.isBePay());
        paramMap.put("billtype", Optional.ofNullable(this.getDynamicObject("billtype")).map(DataEntityBase::getPkValue).orElse(null));
        boolean isCrossPay = (Boolean)this.getModel().getValue("iscrosspay");
        paramMap.put("iscrosspay", isCrossPay);
        paramMap.put("currency", this.getPk("currency"));
        paramMap.put("businesstype", this.getString("businesstype"));
        paramMap.put("settletype", this.getPk("settletype"));
        paramMap.put("payeracctbank", this.getPk("payeracctbank"));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_addpayee");
        parameter.setStatus(isAddNew != false ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        parameter.getCustomParams().putAll(paramMap);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addpayee"));
        this.getView().showForm(parameter);
    }

    private void addPayeeValue(Map<String, Object> resultMap) {
        DynamicObject old_settletype;
        DynamicObject new_settletype;
        this.setValue("payeeformid", resultMap.get("payeeformid"));
        this.setValue("payee", resultMap.get("payee"));
        this.setValue("payeename", resultMap.get("payeename"));
        if (this.isHwControl()) {
            this.setValue("hw_payeesiteid", resultMap.get("hw_payeesiteid"));
            this.setValue("scorg", resultMap.get("scorg"));
        }
        this.setValue("payeenumber", resultMap.get("payeenumber"));
        this.setValue("payeeaccformid", resultMap.get("payeeaccformid"));
        this.setValue("payeeacctbank", resultMap.get("payeeacctbank"));
        this.setValue("payeeacctcash", resultMap.get("payeeacctcash"));
        this.setValue("payeebanknum", resultMap.get("payeebanknum"));
        this.setValue("payeebank", resultMap.get("payeebank"));
        this.setValue("payeebankname", resultMap.get("payeebankname"));
        this.setValue("recaccbankname", resultMap.get("recaccbankname"));
        String beBankNumber = (String)resultMap.get("recbanknumber");
        this.setValue("recbanknumber", beBankNumber);
        this.setValue("reccountry", resultMap.get("reccountry"));
        this.setValue("recprovince", resultMap.get("recprovince"));
        this.setValue("reccity", resultMap.get("reccity"));
        this.setValue("recswiftcode", resultMap.get("swift_code"));
        this.setValue("recroutingnum", resultMap.get("routingnum"));
        this.setValue("recothercode", resultMap.get("other_code"));
        this.setValue("recbankaddress", resultMap.get("address_eng"));
        this.setValue("recemail", resultMap.get("payeeemail"));
        this.setValue("payeecurrency", resultMap.get("payeecurrency"));
        this.setValue("recaddress", resultMap.get("payeeaddress"));
        this.setValue("supplierBankId", resultMap.get("supplierBankId"));
        this.setValue("auditparam", resultMap.get("liquidationparam"));
        PaymentBillPluginHelper.fillProxyBeBankInfo((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        Object recCurId = resultMap.get("payeecurrency");
        if (recCurId != null && ((Long)recCurId).intValue() != 0 && !this.isBotpCreate() && isDiffCur.booleanValue()) {
            this.setValue("currency", resultMap.get("payeecurrency"));
        }
        if (AsstActTypeEnum.SUPPLIER.getValue().equals(this.getModel().getValue("payeetype")) && !CasHelper.isEquals((Object)(new_settletype = (DynamicObject)resultMap.get("settlment")), (Object)(old_settletype = (DynamicObject)this.getModel().getValue("settletype"))) && new_settletype != null) {
            this.setValue("settletype", new_settletype);
        }
        String businessType = (String)this.getValue("businesstype");
        if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
            this.setValue("institutioncode", resultMap.get("institutioncode"));
            this.setValue("institutionname", resultMap.get("institutionname"));
        }
        this.setPayeeInfo4Lb();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_addpayee"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_payeeinfo"});
    }

    private void changePayeeValue() {
        this.setPayeeInfo4Lb();
        boolean addpayView = this.hasPayeeInfo();
        this.getView().setVisible(Boolean.valueOf(!addpayView), new String[]{"flex_addpayee"});
        this.getView().setVisible(Boolean.valueOf(addpayView), new String[]{"flex_payeeinfo"});
    }

    private void setPayeeInfo4Lb() {
        String payeeformid = this.getString("payeetype");
        Set payeetypeList = Stream.of("bos_org", "bd_supplier", "bd_customer", "bos_user").collect(Collectors.toSet());
        Long payeeId = Long.parseLong(this.getValue("payee") == null ? "0" : this.getValue("payee").toString());
        String payeeType = this.getString("payeetype");
        if (AsstActTypeEnum.OTHER.getValue().equals(payeeType)) {
            this.setValue("payeenamev", this.getValue("payeename"));
        } else if (CasHelper.isNotEmpty((Object)payeeformid) && payeetypeList.contains(payeeformid) && CasHelper.isNotEmpty((Object)payeeId)) {
            DynamicObject payeeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)payeeformid, (String)"name");
            this.setValue("payeenamev", CasHelper.getLocalValue((DynamicObject)payeeObj, (String)"name"));
        }
        Image payeePic = (Image)this.getControl("payeepic");
        String defaultUrl = BaseDataHelper.getPictureUrl((Long)payeeId, (String)payeeformid);
        defaultUrl = defaultUrl == null ? "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png" : defaultUrl;
        payeePic.setUrl(defaultUrl);
        ((Label)this.getControl("payeebanknumv")).setText(kd.fi.cas.util.StringUtils.splitString((String)this.getString("payeebanknum"), (int)4, (String)" "));
        ((Label)this.getControl("payeebanknamev")).setText(this.getString("payeebankname"));
        ((Label)this.getControl("recaccbanknamev")).setText(this.getString("recaccbankname"));
        ((Label)this.getControl("recbanknumberv")).setText(this.getString("recbanknumber"));
        DcepConverHelper.initImage((IFormView)this.getView());
        DynamicObject billType = this.getDynamicObject("billtype");
        if (PayeeInfoHelper.isPaymentBill((DynamicObject)billType)) {
            boolean isCash = PayeeInfoHelper.useCashAccount((DynamicObject)((DynamicObject)this.getValue("settletype")), (long)(EmptyUtil.isNoEmpty((Object)this.getValue("payee")) ? Long.parseLong(this.getValue("payee").toString()) : 0L), (String)((String)this.getValue("payeetype")));
            this.getView().setVisible(Boolean.valueOf(!isCash), new String[]{"payeebanknamev", "payeebanknamelb"});
        }
    }

    private void changePayerPage() {
        DynamicObject settleType = this.getDynamicObject("settletype");
        Object sourceBillType = this.getModel().getValue("sourcebilltype");
        Object sourceBillNumber = this.getModel().getValue("sourcebillnumber");
        Object sourceBillId = this.getModel().getValue("sourcebillid");
        HashMap<String, Object> payerInfo = new HashMap<String, Object>();
        payerInfo.put("cash", BaseDataHelper.isSettleTypeCash((DynamicObject)settleType));
        payerInfo.put("virtual", BaseDataHelper.isSettleTypeVirtual((DynamicObject)settleType));
        payerInfo.put("sourceBillType", sourceBillType);
        payerInfo.put("sourceBillNumber", sourceBillNumber);
        payerInfo.put("sourceBillId", sourceBillId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_changepayer");
        parameter.getCustomParams().putAll(payerInfo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changepayer"));
        this.getView().showForm(parameter);
    }

    private void changePayerValue(Map<String, Object> returnMap) {
        String payerNumber;
        String uniformsocialcreditcode;
        DynamicObject old_bank;
        DynamicObject new_bank;
        DynamicObject old_acctbank;
        DynamicObject new_acctbank;
        DynamicObject old_acctcash;
        DynamicObject new_acctcash;
        boolean isChangeCur = false;
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject new_org = (DynamicObject)returnMap.get("org");
        DynamicObject old_org = (DynamicObject)model.getValue("org");
        DynamicObject cur = OrgHelper.getBaseCurrency((long)((Long)new_org.getPkValue()));
        if (!CasHelper.isEquals((Object)new_org, (Object)old_org)) {
            this.setValue("org", new_org);
            this.setValue("basecurrency", cur);
            this.setValue("draftbill", null);
            isChangeCur = true;
        }
        if (!CasHelper.isEquals((Object)(new_acctcash = (DynamicObject)returnMap.get("payeracctcash")), (Object)(old_acctcash = (DynamicObject)model.getValue("payeracctcash")))) {
            this.setValue("payeracctcash", new_acctcash);
            isChangeCur = false;
        }
        if (!CasHelper.isEquals((Object)(new_acctbank = (DynamicObject)returnMap.get("payeracctbank")), (Object)(old_acctbank = (DynamicObject)model.getValue("payeracctbank")))) {
            logger.info("closedCallBack changepayer new_acctbank:{}", (Object)new_acctbank);
            this.setValue("payeracctbank", new_acctbank);
            isChangeCur = false;
        }
        if (!CasHelper.isEquals((Object)(new_bank = (DynamicObject)returnMap.get("payerbank")), (Object)(old_bank = (DynamicObject)model.getValue("payerbank")))) {
            this.setValue("payerbank", new_bank);
        }
        this.setPayerInfo4Lb();
        if (isChangeCur) {
            this.setValue("currency", cur);
        }
        if (StringUtils.isNotBlank((CharSequence)(uniformsocialcreditcode = new_org.getString("uniformsocialcreditcode")))) {
            this.setValue("uniformsocialcreditcode", uniformsocialcreditcode);
        }
        if (StringUtils.isNotBlank((CharSequence)(payerNumber = new_org.getString("number")))) {
            this.setValue("payernumber", payerNumber);
        }
        this.setValue("openorg", returnMap.get("openorg"));
        String businessType = (String)this.getValue("businesstype");
        if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
            this.setValue("institutioncode", returnMap.get("institutioncode"));
            this.setValue("institutionname", returnMap.get("institutionname"));
        }
        this.settleOrg(true);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        String confirm;
        Map resultMap;
        super.closedCallBack(e);
        if ("changepayer".equals(e.getActionId())) {
            resultMap = (Map)e.getReturnData();
            if (resultMap != null) {
                logger.info("closedCallBack changepayer resultMap:{}", (Object)resultMap);
                this.changePayerValue(resultMap);
            }
        } else if ("addpayee".equals(e.getActionId())) {
            resultMap = (Map)e.getReturnData();
            if (resultMap != null) {
                this.addPayeeValue(resultMap);
                this.setCrossPayValue();
            }
        } else if ("beforesubmit".equals(e.getActionId())) {
            confirm = (String)e.getReturnData();
            if (confirm != null && confirm.equals("ok")) {
                this.getView().invokeOperation("submit");
            }
        } else if ("beforesubmitnew".equals(e.getActionId())) {
            confirm = (String)e.getReturnData();
            if (confirm != null && confirm.equals("ok")) {
                this.getView().invokeOperation("submitandnew");
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_DIFFPAY_CALLBACK)) {
            Map data = (Map)e.getReturnData();
            OperateOption option = OperateOption.create();
            if (data != null) {
                for (Map.Entry entry : data.entrySet()) {
                    if (entry.getValue() == null) continue;
                    option.setVariableValue((String)entry.getKey(), entry.getValue().toString());
                }
                option.setVariableValue("payConfirm", "1");
                this.getView().invokeOperation("pay", option);
            } else {
                this.getView().invokeOperation("refresh", option);
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_CLOSECALLBACK_CHARGEBACK)) {
            Object draftIdList = e.getReturnData();
            if (draftIdList != null) {
                Map data = (Map)draftIdList;
                Object draftBillIdList = data.get("draftBillIdList");
                OperateOption option = OperateOption.create();
                option.setVariableValue("draftids", JSON.toJSONString(draftBillIdList));
                this.getView().invokeOperation("pay", option);
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"settletnumber")) {
            rows = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                this.getModel().deleteEntryData("entry");
                CasBotpHelper.doDraw((IFormView)this.getView(), (String)"lc_arrival", (String)this.getModel().getDataEntityType().getName(), (ListSelectedRowCollection)rows);
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"creditopen_settletnumber")) {
            rows = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                Object pKValue = rows.getPrimaryKeyValues()[0];
                DynamicObject lcInfo = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"id,billno,creditno", (QFilter[])new QFilter[]{new QFilter("id", "=", pKValue)});
                this.getModel().setValue("settletnumber", (Object)lcInfo.getString("billno"));
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"CALLBACK_SELECTCREDIT")) {
            PayBillHepler.closedCallBack((String)e.getActionId(), (IFormView)this.getView(), (Object)e.getReturnData());
        }
        PaymentBillPluginHelper.isSchePayEditable((AbstractFormPlugin)this, (IDataModel)this.getModel());
        DynamicObject org = this.getDynamicObject("org");
        InitCheckPluginHelper.checkInitForPlugin((IFormView)this.getView(), (DynamicObject)org, (String[])new String[]{"bar_save", "bar_submit"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String msg;
        String opKey = evt.getOperationKey();
        if ("delete".equals(opKey)) {
            if ("cas_recbill".equals(this.getString("sourcebilltype"))) {
                evt.setCancel(true);
                String billno = this.getString("billno");
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e\u5355\u7531\u5185\u90e8\u6536\u4ed8\u534f\u540c\u4e1a\u52a1\u81ea\u52a8\u751f\u6210\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"PaymentBillEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DEL_CALLBACK, (IFormPlugin)this));
            }
        } else if ("pay".equals(opKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long orgDynId = dataEntity.getDynamicObject("org").getLong("id");
            boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)orgDynId, (String)"cs122");
            String settleTypeKey = DraftHelper.getKey((Object)dataEntity.get("settletype"));
            logger.info("selectDraftFlag is:" + selectDraftFlag + ",key:" + settleTypeKey);
            boolean isdraft = SystemParameterHelper.getCdmParameterBoolean((long)orgDynId, (String)"isdraft");
            boolean ischeck = SystemParameterHelper.getCdmParameterBoolean((long)orgDynId, (String)"ischeck");
            boolean ispromissorynote = SystemParameterHelper.getCdmParameterBoolean((long)orgDynId, (String)"ispromissorynote");
            if (!CasHelper.isEmpty((Object)settleTypeKey)) {
                switch (settleTypeKey) {
                    case "isdraft": {
                        if (!isdraft || selectDraftFlag) break;
                        String typeName = ResManager.loadKDString((String)"\u6c47\u7968", (String)"DraftHelper_4", (String)"fi-cas-common", (Object[])new Object[0]);
                        this.cancelAndWarn(evt, dataEntity, typeName);
                        break;
                    }
                    case "ischeck": {
                        if (!ischeck || selectDraftFlag) break;
                        String typeName = ResManager.loadKDString((String)"\u652f\u7968", (String)"DraftHelper_5", (String)"fi-cas-common", (Object[])new Object[0]);
                        this.cancelAndWarn(evt, dataEntity, typeName);
                        break;
                    }
                    case "ispromissorynote": {
                        if (!ispromissorynote || selectDraftFlag) break;
                        String typeName = ResManager.loadKDString((String)"\u672c\u7968", (String)"DraftHelper_6", (String)"fi-cas-common", (Object[])new Object[0]);
                        this.cancelAndWarn(evt, dataEntity, typeName);
                        break;
                    }
                }
            }
        }
        if ("commitbe".equals(opKey)) {
            PluginSignHelper.signOperate((BeforeItemClickEvent)evt, (SignCallbackLisenter)this, (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (IFormView)this.getView(), (String)"cas_paybill", (Boolean)false);
        }
        if ("lcopen".equals(opKey) && StringUtils.isNotEmpty((CharSequence)(msg = PaymentBillList.checkLCOpen((DynamicObject)this.getDynamicObject("settletype"), (String)this.getString("billstatus"), (String)this.getString("settletnumber"))))) {
            this.getView().showTipNotification(msg);
            evt.setCancel(true);
        }
    }

    private void cancelAndWarn(BeforeItemClickEvent evt, DynamicObject dataEntity, String typeName) {
        String msg = String.format(ResManager.loadKDString((String)"%1$s :\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a%2$s\u7684\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u786e\u8ba4\u4ed8\u6b3e", (String)"DraftHelper_7_1", (String)"fi-cas-common", (Object[])new Object[0]), dataEntity.getString("billno"), typeName);
        evt.setCancel(true);
        this.getView().showTipNotification(msg);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey().toLowerCase()) {
            case "bar_beforesubmit": {
                this.getView().invokeOperation("beforesubmit");
                break;
            }
            case "bar_cancelpay": {
                this.cancelPay();
                break;
            }
            case "viewsettle": {
                this.viewSettle();
                break;
            }
            case "bar_save": {
                this.batchUpdateView("feeactbank", "feecurrency");
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.calculateAmt();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = this.getDynamicObject("org");
        InitCheckPluginHelper.checkInitForPlugin((IFormView)this.getView(), (DynamicObject)org, (String[])new String[]{"bar_save", "bar_submit"});
        DynamicObject paymentBill = this.getModel().getDataEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object showConer = customParams.get("showConer");
        List workflowlist = WorkflowServiceHelper.getAllApprovalRecord((String)paymentBill.getPkValue().toString());
        this.fillterEntryPaymentType();
        if (CollectionUtils.isEmpty((Collection)workflowlist) || CasHelper.isEmpty(showConer)) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
            control.setCollapse("splitpanelap1", true);
        }
        this.setCrossPayValue();
        Long orgId = this.getPk("org");
        if (this.isBotpNew()) {
            DynamicObject paymentType;
            if (orgId == null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit", "bar_beforesubmit"});
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e0a\u6e38\u5355\u636e\u7ef4\u62a4\u4ed8\u6b3e\u7ec4\u7ec7\u6765\u6e90\u518d\u63a8\u4ed8\u6b3e\u5355\u3002", (String)"PaymentBillEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject cur = OrgHelper.getBaseCurrency((long)orgId);
            if (cur == null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit", "bar_beforesubmit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_refund_save", "bar_submitandnew", "bar_del", "bar_audit", "bar_unaudit", "bar_pay", "bar_cancelpay", "bar_commitbe", "genvoucher", "deletevoucher", "copyentryrow"});
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().showErrorNotification(SystemStatusCtrolHelper.notFinishInitSetMsg((String)CasHelper.getLocalValue((DynamicObject)this.getDynamicObject("org"), (String)"name")));
                return;
            }
            this.setValueIfAbsent("basecurrency", cur);
            DynamicObject payeracctbank = this.getDynamicObject("payeracctbank");
            if (payeracctbank != null) {
                this.setValueIfAbsent("payerbank", payeracctbank.getDynamicObject("bank"));
                this.setValueIfAbsent("openorg", payeracctbank.getDynamicObject("openorg"));
            }
            this.setNetBankAcctVisible();
            String initFundflowitem = this.getPageCache().get("init_fundflowitem");
            if (!Boolean.parseBoolean(initFundflowitem) && (paymentType = paymentBill.getDynamicObject("paymenttype")) != null) {
                this.fillFundflowItem(false);
                this.getPageCache().put("init_fundflowitem", "true");
            }
        }
        if (null == this.getDynamicObject("exratetable")) {
            this.setDefaultExratetable(orgId);
        }
        this.setPayerInfo4Lb();
        this.changePayeeValue();
        this.ctrChangeLableVisible();
        this.setCurrencyEditable();
        this.ctrBeInfoVisibility();
        this.setExchangerateEditable();
        this.ctrRefundInfoVisibility();
        DynamicObject accountBank = this.getDynamicObject("payeracctbank");
        this.setPaymentChannelValue(accountBank, Boolean.FALSE);
        this.setDiffCurInfo();
        this.setCountryValue();
        this.isDiffCurVisibility();
        this.isOnlinebankVisibility();
        this.setPayerAndPayeeInfo(orgId);
        this.getModel().setDataChanged(false);
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        if (Objects.nonNull(settleType)) {
            this.settletNumber(settleType);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"draftbill"});
        }
        PaymentBillPluginHelper.fillToolBar((AbstractFormPlugin)this, (IDataModel)this.getModel(), (IFormView)this.getView());
        this.showBalance();
        this.showRBalance();
        this.setEntrustBtnShow(EmptyUtil.isNoEmpty((Object)paymentBill.get("entrustorg")));
        this.setLCopenBtnShow(paymentBill.getDynamicObject("settletype"));
        if (this.getModel().getValue("entrance") == null) {
            this.setEntrance();
        }
    }

    private void fillterEntryPaymentType() {
        boolean ishavenull = false;
        DynamicObject defaultPayMentBillType = null;
        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] paymentBillType = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,biztype,ispartpayment", (QFilter[])new QFilter[]{qFilter});
        if (paymentBillType != null && paymentBillType.length != 0) {
            defaultPayMentBillType = paymentBillType[0];
        }
        DynamicObject paymenttype = (DynamicObject)this.getModel().getValue("paymenttype");
        HashSet<DynamicObject> entryPaymentTypes = new HashSet<DynamicObject>(4);
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("entry");
        for (DynamicObject entry : entrys) {
            DynamicObject e_paymenttype = entry.getDynamicObject("e_paymenttype");
            if (e_paymenttype != null) {
                entryPaymentTypes.add(e_paymenttype);
                continue;
            }
            ishavenull = true;
        }
        if (entryPaymentTypes != null && entryPaymentTypes.size() > 0) {
            if (entryPaymentTypes.size() > 1) {
                this.getModel().setValue("multipaymenttype", (Object)true);
                if (paymenttype == null) {
                    this.getModel().setValue("paymenttype", (Object)defaultPayMentBillType);
                }
            } else {
                Iterator iterator;
                if (!ishavenull) {
                    this.getModel().setValue("multipaymenttype", (Object)false);
                }
                if (paymenttype == null && (iterator = entryPaymentTypes.iterator()).hasNext()) {
                    this.getModel().setValue("paymenttype", iterator.next());
                }
            }
        } else if (paymenttype != null) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("e_paymenttype", (Object)paymenttype, i);
            }
            this.getModel().setValue("multipaymenttype", (Object)false);
        }
    }

    private void setPayerAndPayeeInfo(Long orgId) {
        if (CasHelper.isEmpty((Object)orgId)) {
            return;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        this.getModel().setValue("payernumber", (Object)org.getString("number"));
        this.getModel().setValue("uniformsocialcreditcode", (Object)org.getString("uniformsocialcreditcode"));
        Long payeeId = Long.valueOf(this.getModel().getValue("payee").toString());
        Object payeetype = this.getModel().getValue("payeetype");
        if (payeetype == null) {
            return;
        }
        String type = this.getModel().getValue("payeetype").toString();
        String number = this.getModel().getValue("payeenumber").toString();
        if (number.isEmpty() && (AsstActTypeEnum.SUPPLIER.getValue().equals(type) || AsstActTypeEnum.CUSTOMER.getValue().equals(type))) {
            number = this.getPayeeOrPayerInfoNumber(payeeId, type);
        } else if (number.isEmpty() && (AsstActTypeEnum.EMPLOYEE.getValue().equals(type) || AsstActTypeEnum.COMPANY.getValue().equals(type))) {
            number = this.getUserOrOrgNumber(payeeId, type);
        }
        this.getModel().setValue("payeenumber", (Object)number);
        if (!this.getModel().getDataEntity().getString("billstatus").equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"priority"});
        }
    }

    protected void setExchangerateEditable() {
        DynamicObject srcCurrency = this.getDynamicObject("currency");
        DynamicObject destCurrency = this.getDynamicObject("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchangerate"});
        }
    }

    private void setDefaultExratetable(Long orgId) {
        Long exchangeRateTableId = 0L;
        try {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
    }

    private void ctrChangeLableVisible() {
        Object sourceBillType = this.getModel().getValue("sourcebilltype");
        if ("cas_recbill".equals(sourceBillType) || "bei_transdetail_cas".equals(sourceBillType) || !BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer", "changepayee"});
        } else if (!((Boolean)this.getModel().getValue("issupplecontract")).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"changepayer", "changepayee"});
        }
    }

    private boolean isBePay() {
        DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank");
        if (payerAcctBank != null && PayBillCrossHelper.isIfmBankAcc((DynamicObject)payerAcctBank)) {
            return true;
        }
        return payerAcctBank != null && (Boolean)payerAcctBank.get("issetbankinterface") != false && "bei".equalsIgnoreCase(this.getString("paymentchannel"));
    }

    private boolean isBeiBePay() {
        DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank");
        return payerAcctBank != null && (Boolean)payerAcctBank.get("issetbankinterface") != false && "bei".equalsIgnoreCase(this.getString("paymentchannel"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank");
        if ("trackdown".equals(operateKey)) {
            String settlementtype;
            DynamicObject settleType = this.getDynamicObject("settletype");
            if (settleType != null && EmptyUtil.isNoEmpty((String)(settlementtype = settleType.getString("settlementtype"))) && this.settleTypes.contains(settlementtype)) {
                op.getOption().setVariableValue("botp_track_edit_status", "true");
            }
        } else if ("save".equals(operateKey) && !((Boolean)this.getModel().getValue("issupplecontract")).booleanValue() || "submit".equals(operateKey) || "submitandnew".equals(operateKey) || "beforesubmit".equals(operateKey) || "beforesubmitnew".equals(operateKey)) {
            if (!this.isBeConfirmOK) {
                this.storeFields();
            }
        } else if ("refundsave".equals(operateKey)) {
            DynamicObjectCollection payEntrys;
            BigDecimal refundamtTotal;
            Long rebillid = (Long)this.getView().getFormShowParameter().getCustomParam("rebillid");
            DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill");
            BigDecimal actrecamt = recbill.getBigDecimal("actrecamt");
            if (actrecamt.compareTo(refundamtTotal = (payEntrys = this.getModel().getEntryEntity("entry")).stream().map(o -> o.getBigDecimal("e_refundamt")).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9000\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u6536\u6b3e\u5355\u91d1\u989d\u4e0d\u76f8\u7b49\u3002", (String)"PaymentBillEdit_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            FormOperate operate = (FormOperate)args.getSource();
            operate.getOption().setVariableValue("rebillid", SerializationUtils.toJsonString((Object)this.getView().getFormShowParameter().getCustomParam("rebillid")));
            operate.getOption().setVariableValue("billtype", "cas_paybill");
        } else if ("recbook".equals(operateKey)) {
            DynamicObject accountBank = this.getDynamicObject("payeracctbank");
            if (null != accountBank && AccountBankHelper.isClosed((long)accountBank.getLong("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")));
            }
            if (payerAcctBank != null && PayBillCrossHelper.isIfmBankAcc((DynamicObject)payerAcctBank)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u8bf7\u9009\u62e9\u5185\u90e8\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_48", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (PaymentBillPluginHelper.checkPayeeTypeFreeze(Collections.singletonList(this.getModel().getDataEntity()))) {
                throw new KDBizException(new PaymentErrorCode().CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
            }
            String msg = WriteBackServiceImpl.getInstance().validate(this.getModel().getDataEntity(), WriteBackOperateEnum.RECBOOKVALIDATE, PaymentDisposeConsumer.class, (String)this.getModel().getValue("sourcebilltype"));
            if (EmptyUtil.isNoEmpty((String)msg)) {
                throw new KDBizException(msg);
            }
        } else if ("endorse".equals(operateKey)) {
            long sourcebillid;
            DynamicObjectCollection tradeBills;
            if (payerAcctBank != null && PayBillCrossHelper.isIfmBankAcc((DynamicObject)payerAcctBank)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u8bf7\u9009\u62e9\u5185\u90e8\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_48", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            DynamicObject info = this.getModel().getDataEntity(true);
            String sourcebilltype = info.getString("sourcebilltype");
            if ("cdm_drafttradebill".equals(sourcebilltype) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(tradeBills = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id,tradetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(sourcebillid = info.getLong("sourcebillid"))), new QFilter("tradetype", "=", (Object)"refund")}))) && tradeBills.size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62d2\u6536\u9000\u7968\u751f\u6210\u7684\u4ed8\u6b3e\u5904\u7406\u53ea\u80fd\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentBillList_20_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (PaymentBillPluginHelper.checkPayeeTypeFreeze(Collections.singletonList(this.getModel().getDataEntity()))) {
                throw new KDBizException(new PaymentErrorCode().CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
            }
            String msg = WriteBackServiceImpl.getInstance().validate(this.getModel().getDataEntity(), WriteBackOperateEnum.ENDORSEVALIDATE, PaymentDisposeConsumer.class, (String)this.getModel().getValue("sourcebilltype"));
            if (EmptyUtil.isNoEmpty((String)msg)) {
                throw new KDBizException(msg);
            }
        } else if ("pay".equals(operateKey)) {
            boolean cancel;
            String draftIds = op.getOption().getVariableValue("draftids", "");
            String lcBillNo = op.getOption().getVariableValue("lcBillNo", "");
            CloseCallBack lcSelectCloseCallBack = new CloseCallBack((IFormPlugin)this, "CALLBACK_SELECTCREDIT");
            DynamicObject dbData = this.getModel().getDataEntity();
            if (StringUtils.isEmpty((CharSequence)lcBillNo)) {
                dbData = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"cas_paybill", (String)"id,billno,billstatus,settletype,settletnumber");
            }
            if (cancel = PaymentBillList.letterCreditSelect((IFormView)this.getView(), (CloseCallBack)lcSelectCloseCallBack, (String)lcBillNo, (DynamicObject[])new DynamicObject[]{dbData})) {
                args.setCancel(cancel);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)draftIds)) {
                String payConfirm;
                DynamicObject orgData = (DynamicObject)this.getValue("org");
                Long pkValue = (Long)orgData.getPkValue();
                boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)pkValue, (String)"cs122");
                DynamicObject data = this.getModel().getDataEntity(true);
                if (selectDraftFlag && PaymentBillPluginHelper.needSelectedDraft((DynamicObject)data)) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setAppId("cas");
                    showParameter.setFormId("cas_payment_selectdraft");
                    showParameter.setCustomParam("payBillId", data.getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CLOSECALLBACK_CHARGEBACK));
                    this.getView().showForm(showParameter);
                    args.setCancel(true);
                } else if (!DraftHelper.isAllPayDrafBill((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("draftbill"))) && !((Boolean)this.getModel().getValue("feepay")).booleanValue() && StringUtils.isEmpty((CharSequence)(payConfirm = op.getOption().getVariableValue("payConfirm", "")))) {
                    this.pay(args);
                }
            }
        }
        if (Arrays.asList("save", "submit").contains(operateKey)) {
            String isClearCreditSettletNumber;
            String oldSettletNumber = this.getPageCache().get("srcLcNoHaveValueClear");
            if (EmptyUtil.isNotBlank((CharSequence)oldSettletNumber)) {
                op.getOption().setVariableValue("srcLcNoHaveValueClear", oldSettletNumber);
            }
            if (EmptyUtil.isNotBlank((CharSequence)(isClearCreditSettletNumber = this.getPageCache().get("isClearCreditSettletNumber")))) {
                op.getOption().setVariableValue("isClearCreditSettletNumber", isClearCreditSettletNumber);
            }
        }
        if ("submit".equals(operateKey)) {
            FormUtils.deleteEmptyRows((IDataModel)this.getModel(), (String[])new String[]{"e_payableamt"});
        }
        if (Arrays.asList("unaudit", "chargeback", "invalid", "delete", "pay").contains(operateKey) && PayBillHepler.getViewSettle((DynamicObject)this.getModel().getDataEntity()).size() > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\u7ed3\u7b97\u8bb0\u5f55\uff0c\u5bfc\u81f4\u64cd\u4f5c\u5931\u8d25\u3002\u5982\u9700\u7ee7\u7eed\u6267\u884c\u64cd\u4f5c\uff0c\u8bf7\u5148\u53cd\u7ed3\u7b97\u3002", (String)"PaymentBillList_36", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
            args.setCancel(true);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (id.equals("CONFIRM_CANCELPAY_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            String billno = (String)this.getModel().getValue("billno");
            DynamicObject payObj = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            if (!CasPluginHelper.cancelCheckSettleForPay((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)payObj).booleanValue()) {
                this.getView().invokeOperation("cancelpay");
            }
        }
        if (id.equals("CONFIRM_CANCELPAY_SETTLE_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("cancelpay");
        }
        if (id.equals(CONFIRM_DEL_CALLBACK)) {
            OperateOption option = OperateOption.create();
            if (MessageBoxResult.Yes.equals((Object)res)) {
                option.setVariableValue("delrecpay", "1");
                this.getView().invokeOperation("delete", option);
            }
        }
        if ("clearPaymentTypeConfirm".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            this.getModel().setValue("paymenttype", null);
            for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                this.setValue("e_paymenttype", null, i);
            }
        }
        if ("clearPaymentTypeConfirm".equals(id) && MessageBoxResult.Cancel.equals((Object)res)) {
            this.setValue("multipaymenttype", true);
        }
    }

    private void storeFields() {
        IBillModel model = (IBillModel)this.getModel();
        String entrance = (String)model.getValue("entrance");
        if (PaymentTypeEnum.OTR.name().equals(entrance)) {
            DynamicObject paymentType = (DynamicObject)model.getValue("paymenttype");
            if (paymentType != null && !paymentType.getBoolean("ispartpayment")) {
                int count = model.getEntryRowCount("entry");
                for (int i = 0; i < count; ++i) {
                    this.setValue("e_discountamt", null, i);
                    this.setValue("e_discountlocamt", null, i);
                    this.setValue("e_corebilltype", null, i);
                    this.setValue("e_corebillno", null, i);
                    this.setValue("e_corebillentryseq", null, i);
                    this.setValue("e_lockamt", null, i);
                    this.setValue("e_unlockamt", null, i);
                    this.setValue("e_settledamt", null, i);
                    this.setValue("e_unsettledamt", null, i);
                }
            }
        } else if (PaymentTypeEnum.SYN.name().equals(entrance) || PaymentTypeEnum.CASH.name().equals(entrance) || PaymentTypeEnum.SPAN.name().equals(entrance) || PaymentTypeEnum.DCEP.name().equals(entrance)) {
            Map sourceBills;
            String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
            if (EmptyUtil.isNoEmpty((String)sourceBillType)) {
                return;
            }
            Long id = (Long)this.getModel().getValue("id");
            if (EmptyUtil.isNoEmpty((Long)id) && (sourceBills = BFTrackerServiceHelper.findDirtSourceBills((String)"cas_paybill", (Long[])new Long[]{id})) != null && sourceBills.size() > 0) {
                return;
            }
            int count = model.getEntryRowCount("entry");
            if (count < 1) {
                this.getView().updateView("entry");
                this.getView().invokeOperation("newentry");
            }
            this.setValue("e_payableamt", this.getBigDecimal("actpayamt"), 0);
            this.setValue("e_fundflowitem", this.getValue("fundflowitem"), 0);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        AbstractOperate op = (AbstractOperate)arg.getSource();
        OperationResult operationResult = arg.getOperationResult();
        String key = op.getOperateKey();
        if ("copyentryrow".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl("entry");
            if (entry.getSelectRows().length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"PaymentBillEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.calculateAmt();
        } else if ("beforesubmit".equals(key) || "beforesubmitnew".equals(key)) {
            if ("beforesubmit".equals(key)) {
                List pks;
                IDataModel model = this.getModel();
                DynamicObject entrustorg = (DynamicObject)model.getValue("entrustorg");
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (CasHelper.isNotEmpty((Object)entrustorg) && CasHelper.isNotEmpty((Object)org) && !org.get("id").equals(entrustorg.get("id"))) {
                    model.setValue("payeracctbank", null);
                    model.setValue("payerbank", null);
                    ((Label)this.getControl("payerbanknumv")).setText("");
                    ((Label)this.getControl("payerbanknamev")).setText("");
                    model.setValue("settletype", null);
                }
                DynamicObject payerBank = this.getDynamicObject("payerbank");
                DynamicObject payeeBank = this.getDynamicObject("payeebank");
                if (payerBank != null && payerBank.containsProperty("country") && payeeBank != null && payeeBank.containsProperty("country")) {
                    long orgId;
                    boolean autoOpenCrossPay;
                    DynamicObject payCountry = payerBank.getDynamicObject("country");
                    Object recCountry = payeeBank.getDynamicObject("country");
                    if (org != null && (autoOpenCrossPay = SystemParameterHelper.getParameterBoolean((long)(orgId = ((Long)org.getPkValue()).longValue()), (String)"autoopencrosspay")) && (payCountry != null && !CountryHelper.isChina((DynamicObject)payCountry) || recCountry != null && !CountryHelper.isChina((DynamicObject)recCountry))) {
                        this.setValue("iscrosspay", Boolean.TRUE);
                    }
                }
                if (arg.getOperationResult().isSuccess() && !EmptyUtil.isEmpty((Collection)(pks = arg.getOperationResult().getSuccessPkIds()))) {
                    this.getView().invokeOperation("submit");
                }
            }
        } else if ("newentry".equals(key)) {
            this.settleOrg(false);
            boolean multipaymenttype = this.getModel().getDataEntity().getBoolean("multipaymenttype");
            DynamicObject paymenttype = this.getModel().getDataEntity().getDynamicObject("paymenttype");
            if (!multipaymenttype) {
                int index = this.getModel().getEntryRowCount("entry") - 1;
                this.getModel().setValue("e_paymenttype", (Object)paymenttype, index);
            }
        } else {
            if ("refundsave".equals(key) && arg.getOperationResult().isSuccess()) {
                IFormView parentView = this.getView().getParentView();
                parentView.close();
                this.getView().sendFormAction(parentView);
                return;
            }
            if ("delete".equals(key) && arg.getOperationResult().isSuccess()) {
                IFormView view = this.getView();
                view.close();
                this.getView().sendFormAction(view);
            } else if ("pay".equals(key) || "cancelpay".equals(key)) {
                String message = arg.getOperationResult().getMessage();
                if (!arg.getOperationResult().isSuccess() && !new CasErrorCode().VOUCHER_NOT_CHECK().getMessage().equals(message)) {
                    this.getModel().setValue("billstatus", (Object)("pay".equals(key) ? BillStatusEnum.AUDIT.getValue() : BillStatusEnum.PAY.getValue()));
                }
                if ("pay".equals(key) && ((Boolean)this.getValue("isdiffcur")).booleanValue()) {
                    this.batchUpdateView("dpamt", "agreedrate", "dplocalamt", "lossamt", "billstatus", "exchangerate", "dpexchangerate", "localamt", "paydate", "feeactbank", "feecurrency", "singlestream", "fee");
                    for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                        this.getView().updateView("e_payablelocamt", i);
                        this.getView().updateView("e_discountlocamt", i);
                        this.getView().updateView("e_localamt", i);
                    }
                }
                this.batchUpdateView("draftbill");
                if (arg.getOperationResult().isSuccess()) {
                    this.getView().invokeOperation("refresh", OperateOption.create());
                }
                if ("pay".equals(key) && arg.getOperationResult().isSuccess()) {
                    long payee = (Long)this.getModel().getValue("payee");
                    Object companyId = null;
                    String payeetype = (String)this.getModel().getValue("payeetype");
                    boolean showSuccess = Boolean.FALSE;
                    switch (payeetype) {
                        case "bd_supplier": 
                        case "bd_customer": {
                            QFilter filter = new QFilter("id", "in", (Object)payee);
                            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)payeetype, (String)"id,internal_company", (QFilter[])filter.toArray());
                            if (CasHelper.isEmpty((Object)obj) || CasHelper.isEmpty((Object)obj.getDynamicObject("internal_company"))) {
                                logger.info(payeetype + "\uff1a\u975e\u5185\u90e8\u5ba2\u5546");
                                showSuccess = Boolean.TRUE;
                                break;
                            }
                            companyId = obj.getDynamicObject("internal_company").getPkValue();
                            break;
                        }
                        case "bos_org": {
                            companyId = payee;
                            break;
                        }
                        default: {
                            logger.info("====\u65e0\u903b\u8f91\u5206\u652f\u3002");
                            showSuccess = Boolean.TRUE;
                        }
                    }
                    if (showSuccess) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"PaymentBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (EmptyUtil.isNoEmpty((Object)companyId)) {
                        Date bizDate = (Date)this.getModel().getValue("bizdate");
                        DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)((Long)companyId));
                        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((DynamicObject)currentPeriod) && bizDate.before(currentPeriod.getDate("begindate"))) {
                            Object allowObj = SystemParameterHelper.getCASParamByOrgIds((Long)((Long)companyId), (String)"cs127");
                            Object CS047 = SystemParameterHelper.getCASParamByOrgIds((Long)((Long)companyId), (String)"cs047");
                            logger.info("CS047\uff1a", CS047);
                            if (EmptyUtil.isNoEmpty((Object)CS047)) {
                                boolean isCheck = (Boolean)CS047;
                                if (isCheck) {
                                    if (EmptyUtil.isNoEmpty((Object)allowObj)) {
                                        boolean allow = (Boolean)allowObj;
                                        if (!allow) {
                                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u6210\u529f\u3002\u56e0\u6536\u6b3e\u65b9\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u65b0\u589e\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u6536\u6b3e\u4e1a\u52a1\uff0c\u56e0\u6b64\u6536\u4ed8\u534f\u540c\u751f\u6210\u6536\u6b3e\u5355\u5931\u8d25\u3002", (String)"PaymentBillEdit_33", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                        } else {
                                            logger.info("CS127\uff1a", allowObj);
                                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"PaymentBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                        }
                                    }
                                } else {
                                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"PaymentBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                }
                            } else {
                                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"PaymentBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            }
                        } else {
                            logger.info("currentPeriod\uff1a{}", (Object)currentPeriod);
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"PaymentBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
            } else if ("chargebacknoreason".equals(key)) {
                String reason = ResManager.loadKDString((String)"\u81ea\u52a8\u9000\u5355", (String)"PaymentBillList_37", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                List successPkIds = operationResult.getSuccessPkIds();
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                data.put("billid", successPkIds);
                data.put("reason", reason);
                data.put("operateKey", "chargeback");
                PayBillListPlugnHelper.closeCallBack((String)KEY_CALLBACK_CHARGEBACK, (IFormView)this.getView(), data);
            }
        }
        if (Arrays.asList("save", "submit").contains(key) && arg.getOperationResult().isSuccess()) {
            this.batchUpdateView("entrustorg", "totalpayamt", "multipaymenttype", "paymenttype");
            for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                this.getView().updateView("e_lockAmt", i);
                this.getView().updateView("e_unlockAmt", i);
                this.getView().updateView("e_paymenttype", i);
            }
            this.getPageCache().remove("srcLcNoHaveValueClear");
            this.getPageCache().remove("isClearCreditSettletNumber");
        }
        if ("unaudit".equals(key)) {
            this.getView().invokeOperation("refresh", OperateOption.create());
        }
        PaymentBillPluginHelper.fillToolBar((AbstractFormPlugin)this, (IDataModel)this.getModel(), (IFormView)this.getView());
        this.ctrChangeLableVisible();
        PaymentBillPluginHelper.isSchePayEditable((AbstractFormPlugin)this, (IDataModel)this.getModel());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        try {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || billShowParameter.getStatus() == OperationStatus.VIEW) {
                e.setCheckDataChange(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cancelPay() {
        String billno = (String)this.getModel().getValue("billno");
        DynamicObject payObj = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billno,isvoucher,billstatus,org", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        String billstatus = payObj.getString("billstatus");
        if (!billstatus.equals("D")) {
            this.getView().invokeOperation("cancelpay");
            return;
        }
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        int CS116 = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs116");
        Boolean isv = payObj.getBoolean("isvoucher");
        if (3 == CS116 && isv.booleanValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"PaymentBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
        } else if (!CasPluginHelper.cancelCheckSettleForPay((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)payObj).booleanValue()) {
            this.getView().invokeOperation("cancelpay");
        }
    }

    protected String recPayAccount() {
        return "payeracctbank";
    }

    private void settleOrg(boolean isOrg) {
        if (this.isLockSettleOrg()) {
            return;
        }
        Object openOrg = this.getModel().getValue("openorg");
        if (openOrg != null) {
            DynamicObject accountOrg = (DynamicObject)openOrg;
            for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                DynamicObject e_paymenttype = (DynamicObject)this.getModel().getValue("e_paymenttype", i);
                if (!EmptyUtil.isNoEmpty((DynamicObject)e_paymenttype) || !e_paymenttype.getBoolean("ispartpayment") || !isOrg && !CasHelper.isEmpty((Object)this.getModel().getValue("settleorg", i))) continue;
                this.setValue("settleorg", accountOrg.getPkValue(), i);
            }
        }
    }

    private boolean isHwControl() {
        return this.getPageCache().getAll().containsKey("isHwControl");
    }

    private void setRecInfo(String key, Object value, Boolean isCheckDiff) {
        if (isCheckDiff.booleanValue()) {
            Boolean isDiffCur = (Boolean)this.getModel().getValue("isdiffcur");
            if (!isDiffCur.booleanValue()) {
                this.getModel().setValue(key, value);
            }
        } else {
            this.getModel().setValue(key, value);
        }
    }

    private void setDiffCurInfo() {
        Boolean isDiffCur = (Boolean)this.getModel().getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            return;
        }
        this.setValueIfAbsent("dpcurrency", this.getModel().getValue("currency"));
        this.setValueIfAbsent("dpamt", this.getModel().getValue("actpayamt"));
        if (!FeePayerEnum.REC.getValue().equals(this.getString("feepayer"))) {
            this.setValueIfAbsent("feeactbank", this.getModel().getValue("payeracctbank"));
            this.setValueIfAbsent("feecurrency", this.getModel().getValue("currency"));
        }
    }

    private void setExratetableVisibility() {
        Long currencyId = this.getPk("currency");
        Long dpCurrencyId = this.getPk("dpcurrency");
        Long basecurrencyId = this.getPk("basecurrency");
        if (currencyId != null && !currencyId.equals(basecurrencyId) || dpCurrencyId != null && !dpCurrencyId.equals(basecurrencyId)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"exratetable"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"exratedate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exratetable"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exratedate"});
        }
    }

    private void setSettleTypeValue(DynamicObject payerAcctBank) {
        DynamicObjectCollection settlementypes;
        if (payerAcctBank != null && (settlementypes = payerAcctBank.getDynamicObjectCollection("settlementtype")) != null && settlementypes.size() > 0) {
            HashSet<Long> idSet = new HashSet<Long>();
            for (DynamicObject settlementype : settlementypes) {
                idSet.add(((DynamicObject)settlementype.get("fbasedataid")).getLong("id"));
            }
            DynamicObject settleType = this.getDynamicObject("settletype");
            if (idSet.size() == 1) {
                DynamicObject settletype = BusinessDataServiceHelper.loadSingleFromCache(idSet.iterator().next(), (String)"bd_settlementtype", (String)"id,settlementtype");
                if (!BaseDataHelper.isSettleTypeCash((DynamicObject)settletype)) {
                    this.setValue("settletype", idSet.iterator().next());
                }
            } else if (settleType != null && !idSet.contains((Long)settleType.getPkValue())) {
                this.setValue("settletype", null);
            }
        }
    }

    private void setCrossPayValue() {
        long orgId;
        boolean autoOpenCrossPay;
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscrosspay"});
        DynamicObject payerBank = this.getDynamicObject("payerbank");
        DynamicObject payCountry = payerBank != null ? payerBank.getDynamicObject("country") : null;
        DynamicObject payeeBank = this.getDynamicObject("payeebank");
        DynamicObject recCountry = payeeBank != null ? payeeBank.getDynamicObject("country") : null;
        DynamicObject org = this.getDynamicObject("org");
        if (org != null && (autoOpenCrossPay = SystemParameterHelper.getParameterBoolean((long)(orgId = ((Long)org.getPkValue()).longValue()), (String)"autoopencrosspay"))) {
            if (payCountry != null && !CountryHelper.isChina((DynamicObject)payCountry) || recCountry != null && !CountryHelper.isChina((DynamicObject)recCountry)) {
                this.setValue("iscrosspay", Boolean.TRUE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"iscrosspay"});
            } else {
                this.setValue("iscrosspay", Boolean.FALSE);
            }
        }
    }

    private void isDiffCurVisibility() {
        DynamicObject settleType = this.getDynamicObject("settletype");
        if (CasHelper.isNotEmpty((Object)settleType) && BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.setValue("isdiffcur", "0");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdiffcur"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isdiffcur"});
        }
    }

    private void setCountryValue() {
        DynamicObject payerBank = this.getDynamicObject("payerbank");
        if (payerBank != null) {
            this.setValueIfAbsent("paycountry", payerBank.getDynamicObject("country"));
        }
    }

    private void pay(BeforeDoOperationEventArgs evt) {
        long orgId = (Long)this.getDynamicObject("org").getPkValue();
        Set cs1046 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs1046");
        DynamicObject payBill = this.getModel().getDataEntity();
        new PaymentPayImpl().validate(payBill);
        if (PaymentBillPluginHelper.isShowPayConfirm((DynamicObject)payBill, (Set)cs1046)) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("cas_paybill_diffpay");
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DIFFPAY_CALLBACK));
            para.getOpenStyle().setShowType(ShowType.Modal);
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"cas_paybill_diffpay").getProperties();
            HashMap<String, Object> customParams = new HashMap<String, Object>(properties.size());
            for (IDataEntityProperty property : properties) {
                String propName = property.getName();
                if (this.getModel().getProperty(propName) == null) continue;
                Object value = this.getValue(propName);
                if (value instanceof DynamicObject) {
                    customParams.put(propName, ((DynamicObject)value).getPkValue());
                    continue;
                }
                customParams.put(propName, value);
            }
            para.setCustomParams(customParams);
            para.setCustomParam("payamount", (Object)payBill.getBigDecimal("actpayamt"));
            para.setCustomParam("payamt", (Object)payBill.getBigDecimal("dpamt"));
            para.setCustomParam("matchFlag", (Object)payBill.getString("matchflag"));
            para.setCustomParam("sourcebilltype", (Object)payBill.getString("sourcebilltype"));
            para.setCustomParam("payBillId", (Object)payBill.getString("id"));
            String selectLcNo = (String)this.getView().getFormShowParameter().getCustomParam("paySelectLcNo");
            para.setCustomParam("paySelectLcNo", (Object)selectLcNo);
            this.getView().showForm(para);
            evt.setCancel(true);
        }
    }

    private void setPaymentType(QFilter qFilter) {
        qFilter.and("enable", "=", (Object)"1");
        Map paymentTypes = BusinessDataServiceHelper.loadFromCache((String)"cas_paymentbilltype", (String)"id,default,predata", (QFilter[])qFilter.toArray(), (String)"default desc,predata desc");
        if (EmptyUtil.isNoEmpty((Object)paymentTypes)) {
            Iterator iterator = paymentTypes.entrySet().iterator();
            if (iterator.hasNext()) {
                this.setValue("paymenttype", iterator.next().getValue());
            }
            this.fillFundflowItem(true);
        } else {
            this.setValue("paymenttype", null);
        }
    }

    private void viewSettle() {
        Long billId = (Long)this.getModel().getDataEntity().getPkValue();
        if (billId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"PaymentBillList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Set mainSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByMain((String)"ap_settlerecord", (String)"cas_paybill", (Object[])new Object[]{billId});
        Set asstSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByAsst((String)"ap_settlerecord", (String)"cas_paybill", (Object[])new Object[]{billId});
        HashSet settleRecordIds = new HashSet();
        settleRecordIds.addAll(mainSettleIds);
        settleRecordIds.addAll(asstSettleIds);
        if (settleRecordIds.size() > 0) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ap_settlerecord");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter param = new ListFilterParameter();
            param.setFilter(new QFilter("id", "in", settleRecordIds));
            parameter.setListFilterParameter(param);
            parameter.setCustomParam("checkKey", (Object)true);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"PaymentBillList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        boolean multipaymenttype = (Boolean)this.getModel().getValue("multipaymenttype");
        DynamicObject paymenttype = (DynamicObject)this.getModel().getValue("paymenttype");
        if ("entry".equals(entryName) && (rows = e.getRowDataEntities()).length > 0) {
            for (RowDataEntity row : rows) {
                this.getModel().setValue("e_sourcebillid", this.getValue("sourcebillid"), row.getRowIndex());
                this.getModel().setValue("e_sourcebillentryid", this.getValue("sourceentryid"), row.getRowIndex());
                if (multipaymenttype) continue;
                this.getModel().setValue("e_paymenttype", (Object)paymenttype, row.getRowIndex());
            }
        }
    }

    private void isOnlinebankVisibility() {
        String paymentchannel = (String)this.getValue("paymentchannel");
        if (paymentchannel != null && CasPluginHelper.isExistOnlineNetBank((DynamicObject)((DynamicObject)this.getValue("payeracctbank")))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"netbankacct"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"netbankacct"});
        }
    }

    public String getPayeeOrPayerInfoNumber(Object payeeOrPayer, Object payeeOrPayerType) {
        DynamicObject supplierCustDO;
        String payeenumber = "";
        String entityNameTemp = "";
        String addressPropName = "";
        if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.SUPPLIER.getValue();
            addressPropName = "supplieraddress";
        }
        if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.CUSTOMER.getValue();
            addressPropName = "customeraddress";
        }
        if (!(CasHelper.isEmpty((Object)entityNameTemp) || CasHelper.isEmpty((Object)payeeOrPayer) || CasHelper.isEmpty((Object)(supplierCustDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeOrPayer, (String)entityNameTemp, (String)("number,entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank,entry_bank.accountname,entry_address." + addressPropName)))))) {
            payeenumber = supplierCustDO.getString("number");
        }
        return payeenumber;
    }

    public String getUserOrOrgNumber(Object id, Object type) {
        DynamicObject userOrgDO;
        String entityNameTemp = "";
        String payeenumber = "";
        if (AsstActTypeEnum.EMPLOYEE.getValue().equals(type) || AsstActTypeEnum.COMPANY.getValue().equals(type)) {
            entityNameTemp = (String)type;
        }
        if (!(CasHelper.isEmpty((Object)entityNameTemp) || CasHelper.isEmpty((Object)id) || CasHelper.isEmpty((Object)(userOrgDO = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityNameTemp, (String)"number"))))) {
            payeenumber = userOrgDO.getString("number");
        }
        return payeenumber;
    }

    private void fillFundflowItem(boolean isCover) {
        for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
            DynamicObject fundflowitem;
            DynamicObject e_paymenttype = (DynamicObject)this.getModel().getValue("e_paymenttype", i);
            if (EmptyUtil.isEmpty((DynamicObject)e_paymenttype) || EmptyUtil.isEmpty((DynamicObject)(fundflowitem = e_paymenttype.getDynamicObject("fundflowitem")))) continue;
            if (isCover) {
                this.setValue("e_fundflowitem", fundflowitem.getPkValue(), i);
                continue;
            }
            this.setValueIfAbsent("e_fundflowitem", fundflowitem.getPkValue(), i);
        }
    }

    private boolean isLockSettleOrg() {
        String sourceBillType = this.getString("sourcebilltype");
        return "ap_finapbill".equals(sourceBillType) || "ar_finarbill".equals(sourceBillType) || "ap_payapply".equals(sourceBillType) || "pm_purorderbill".equals(sourceBillType);
    }

    private boolean isClearFeeSettleType() {
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        if (settleType == null) {
            return true;
        }
        String settlementType = settleType.getString("settlementtype");
        return Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.CHECK.getValue());
    }

    private boolean hasPayeeInfo() {
        Long payeeId = Long.parseLong(this.getValue("payee") == null ? "0" : this.getValue("payee").toString());
        String payeeType = this.getString("payeetype");
        if (AsstActTypeEnum.OTHER.getValue().equals(payeeType)) {
            return StringUtils.isNotBlank((Object)this.getValue("payeename")) || StringUtils.isNotBlank((Object)this.getValue("payeebanknum"));
        }
        return CasHelper.isNotEmpty((Object)payeeType) && CasHelper.isNotEmpty((Object)payeeId);
    }

    public void signCallback(SignCallbackEvent evt) {
        PluginSignHelper.signCallBack((SignCallbackEvent)evt, (IFormView)this.getView(), (Boolean)false);
    }

    private void resetExrateTableWhenSwitchOrg(Object newValue) {
        DynamicObject org;
        long orgId;
        if (EmptyUtil.isNoEmpty((Object)newValue) && EmptyUtil.isNoEmpty((Long)(orgId = (org = (DynamicObject)newValue).getLong("id")))) {
            long exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
            this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
        }
    }

    private void setDefaultAddress(Long payeeId) {
        String payeeType = (String)this.getValue("payeetype");
        String address = AsstActTypeAddressEnum.getAddressByAsstActType((String)payeeType, (Long)payeeId);
        this.setValue("recaddress", address);
    }

    private void setEntrustBtnShow(boolean isEntrustBill) {
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean showEntrustBtn = isEntrustBill && PermissionHelper.hasEntrustPayPermission((String)appId, (String)"cas_paybill");
        this.getView().setVisible(Boolean.valueOf(showEntrustBtn), new String[]{"paypushandsave", "cancelentrustpay"});
    }

    private void batchUpdateView(String ... controlNames) {
        for (String controlName : controlNames) {
            this.getView().updateView(controlName);
        }
    }

    private void setDefaultPayeeBank() {
        QFilter filter;
        DynamicObject bebankNew;
        IDataModel model = this.getModel();
        DynamicObject bebank = (DynamicObject)model.getValue("payeebank");
        String payeeBankName = (String)model.getValue("payeebankname");
        if (EmptyUtil.isEmpty((DynamicObject)bebank) && EmptyUtil.isNoEmpty((String)payeeBankName) && (bebankNew = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id,name,number,union_number,country,provincetxt,citytxt", (QFilter[])new QFilter[]{filter = new QFilter("name", "=", (Object)payeeBankName).and("enable", "=", (Object)"1").and("status", "=", (Object)"C")})) != null) {
            model.setValue("payeebank", (Object)bebankNew);
        }
    }
}

