/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TracePaymentBillList
extends AbstractListPlugin {
    private String targetBillType = null;
    private String sourceBillType = null;

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("no")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setHasRight(true);
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("istmctracebillop");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("yes")) {
            List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            commonFilterColumns.clear();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "tracebankpaymentbill": {
                this.tracePaymentBill();
            }
        }
    }

    private void tracePaymentBill() {
        this.sourceBillType = ((AbstractListView)this.getView()).getEntityTypeId();
        if (this.sourceBillType.equalsIgnoreCase("cas_paybill") || this.sourceBillType.equalsIgnoreCase("cas_paybill_spanmainpart") || this.sourceBillType.equalsIgnoreCase("cas_paybill_synonym") || this.sourceBillType.equalsIgnoreCase("cas_paybill_dcep")) {
            this.targetBillType = "bei_bankpaybill";
        } else if (this.sourceBillType.equalsIgnoreCase("cas_agentpaybill")) {
            this.targetBillType = "bei_bankagentpay";
        }
        HashSet<Long> billIds = this.getSelectedBillIds();
        if (billIds == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"TracePaymentBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (billIds.size() == 1) {
            DynamicObject[] targetBills = BusinessDataServiceHelper.load((String)this.targetBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billIds.iterator().next())}, (String)"createtime desc");
            if (null == targetBills || targetBills.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"TracePaymentBillList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            String curAppId = this.getView().getFormShowParameter().getAppId();
            curAppId = curAppId != null && curAppId.equals("cas") ? "cbei" : (curAppId != null && (curAppId.equals("fs") || curAppId.equals("tr")) ? "bei" : "cbei");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getCustomParams().put("checkRightAppId", curAppId);
            showParameter.setHasRight(true);
            showParameter.setPkId(targetBills[0].get("id"));
            showParameter.setFormId(this.targetBillType);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (billIds.size() > 1) {
            DynamicObject[] targetBills = BusinessDataServiceHelper.load((String)this.targetBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds)});
            if (targetBills == null || targetBills.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"TracePaymentBillList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            String curAppId = this.getView().getFormShowParameter().getAppId();
            curAppId = curAppId != null && curAppId.equals("cas") ? "cbei" : (curAppId != null && (curAppId.equals("fs") || curAppId.equals("tr")) ? "bei" : "cbei");
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getCustomParams().put("checkRightAppId", curAppId);
            showParameter.setHasRight(true);
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(this.targetBillType);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            HashSet<Object> pks = new HashSet<Object>(targetBills.length);
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setCustomParam("istmctracebillop", (Object)"yes");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    protected HashSet<Long> getSelectedBillIds() {
        HashSet<Long> billIds = new HashSet<Long>();
        IListView listView = (IListView)this.getView();
        for (ListSelectedRow row : listView.getSelectedRows()) {
            Long billId;
            if (!(row.getPrimaryKeyValue() instanceof Long) || billIds.contains(billId = (Long)row.getPrimaryKeyValue())) continue;
            billIds.add(billId);
        }
        return billIds;
    }
}

