/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.agentpay;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.AgentPayBillPluginHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.ViewUtils;
import org.apache.commons.lang.StringUtils;

public class AgentPayEncodePlugin
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeBindData(EventObject e) {
        if (this.isCopy() || this.isBotpNew()) {
            IDataModel dataModel = this.getModel();
            String entryEncryptAmtStr = (String)dataModel.getValue("e_encryptamount");
            BigDecimal entryAmt = Optional.ofNullable((BigDecimal)dataModel.getValue("e_amount")).orElse(BigDecimal.ZERO);
            Boolean isEncryption = (Boolean)dataModel.getValue("isencryption");
            if (!isEncryption.booleanValue() || BigDecimal.ZERO.compareTo(entryAmt) != 0 || StringUtils.isBlank((String)entryEncryptAmtStr)) {
                Boolean isClear = false;
                AgentPayBillPluginHelper.setEncodeAmount((IDataModel)this.getModel(), (Boolean)isClear);
            }
        }
        this.setEncryFieldValue();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isSuccess;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (result != null && (isSuccess = result.isSuccess()) && ("save".equals(key) || "submit".equals(key) || "unsubmit".equals(key) || "unaudit".equals(key))) {
            this.setEncryFieldValue();
            this.getModel().setDataChanged(false);
        }
    }

    public void setEncryFieldValue() {
        boolean isVisible = false;
        if (AgentPayBillPluginHelper.isEncodeAmount((IDataModel)this.getModel(), (IFormView)this.getView())) {
            AgentPayBillPluginHelper.setEncodeField((IDataModel)this.getModel(), (IFormView)this.getView());
            isVisible = true;
        } else {
            for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                this.getModel().beginInit();
                String encryptAmount = (String)this.getModel().getValue("e_encryptamount", i);
                BigDecimal amount = AgentPayBillHelper.decodeAmount((String)encryptAmount);
                this.getModel().setValue("e_amount", (Object)(amount != null ? amount : BigDecimal.ZERO), i);
                String encrptyLocalAmount = (String)this.getModel().getValue("e_encryptlocalamt", i);
                BigDecimal loaclAmount = AgentPayBillHelper.decodeAmount((String)encrptyLocalAmount);
                this.getModel().setValue("e_localamt", (Object)(loaclAmount != null ? loaclAmount : BigDecimal.ZERO), i);
                this.getModel().endInit();
                this.getView().updateView("e_amount", i);
                this.getView().updateView("e_localamt", i);
            }
        }
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)isVisible, (String[])new String[]{"e_amount2", "e_localamt2", "encryptpayeeacctbank", "encryptunmatchamount", "encryptmatchamount"});
        ViewUtils.setVisible((AbstractFormPlugin)this, (!isVisible ? 1 : 0) != 0, (String[])new String[]{"e_amount", "e_localamt", "payeeacctbank", "entryunmatchamount", "entrymatchamount"});
    }

    private boolean isCopy() {
        Object value = this.getView().getFormShowParameter().getCustomParam("iscopy");
        return value != null && "true".equals(value.toString());
    }

    protected boolean isBotpNew() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        return this.isBotpCreate() && CasHelper.isEmpty((Object)billShowParameter.getPkId());
    }

    protected boolean isBotpCreate() {
        String sourceBillType = this.getString("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }
}

