/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.agentpay;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.helper.AgentPluginHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class AgentPayRepayListPlugin
extends AbstractListPlugin {
    private static final String OP_REPAY = "repay";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (OP_REPAY.equals(opKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows.size() > 1) {
                String msg = ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"AgentPayBillList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.showTipsAndCancel(args, msg);
                return;
            }
            Object agentBillId = selectedRows.get(0).getPrimaryKeyValue();
            QFilter filter = new QFilter("id", "=", agentBillId);
            DynamicObjectCollection entryList = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,billno,billstatus,isrepulsed,entry.e_issuccess,entry.e_isrepaid,entry.e_isrefund,entry.id,entry.seq", (QFilter[])filter.toArray());
            if (CollectionUtils.isEmpty((Collection)entryList) || entryList.size() == 1 && EmptyUtil.isEmpty((Object)((DynamicObject)entryList.get(0)).get("entry.id"))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u5b58\u5728\u5206\u5f55\u3002", (String)"AgentRepayConvertPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), selectedRows.get(0).getBillNo());
                this.showTipsAndCancel(args, errorMsg);
                return;
            }
            DynamicObject agentBill = (DynamicObject)entryList.get(0);
            String billStatus = agentBill.getString("billstatus");
            if (!BillStatusEnum.PAY.getValue().equals(billStatus) || !agentBill.getBoolean("isrepulsed")) {
                String errorMsg = AgentPayRepayListPlugin.buildEntryErrMsg(entryList, agentBill);
                this.showTipsAndCancel(args, errorMsg);
                return;
            }
            boolean noMatch = entryList.stream().noneMatch(e -> !e.getBoolean("entry.e_issuccess") && !e.getBoolean("entry.e_isrepaid") && !e.getBoolean("entry.e_isrefund"));
            if (noMatch) {
                String errorMsg = AgentPayRepayListPlugin.buildEntryErrMsg(entryList, agentBill);
                this.showTipsAndCancel(args, errorMsg);
                return;
            }
            String checkBankAgentBillMsg = AgentPluginHelper.checkAgentRepayByBankAgentStatus(entryList);
            if (StringUtils.isNotEmpty((String)checkBankAgentBillMsg)) {
                this.showTipsAndCancel(args, checkBankAgentBillMsg);
                return;
            }
            OperateOption option = operate.getOption();
            if (option == null) {
                option = OperateOption.create();
                operate.setOption(option);
            }
            option.setVariableValue("had_check", "true");
        }
    }

    private static String buildEntryErrMsg(DynamicObjectCollection entryList, DynamicObject agentBill) {
        List entryLineNos = IntStream.range(1, entryList.size() + 1).mapToObj(String::valueOf).collect(Collectors.toList());
        String lineNoStr = String.join((CharSequence)",", entryLineNos);
        return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5206\u5f55\u7b2c%2$s\u884c\uff1a\u4e0d\u5b58\u5728\u4ea4\u6613\u5931\u8d25\u7684\u5206\u5f55\u6216\u5df2\u7ecf\u8fdb\u884c\u8fc7\u5931\u8d25\u91cd\u4ed8\u6216\u8005\u6ca1\u6709\u88ab\u6253\u56de\u3002", (String)"AgentRepayConvertPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), agentBill.getString("billno"), lineNoStr);
    }

    private void showTipsAndCancel(BeforeDoOperationEventArgs args, String errorMsg) {
        this.getView().showTipNotification(errorMsg);
        args.setCancel(true);
    }
}

