/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journal.manual;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.journal.manual.ManualJournalExtend;
import kd.fi.cas.helper.BalanceAccHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.ManualJournalHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

abstract class ManualJournalEditPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(ManualJournalEditPlugin.class);
    protected final String BTN_MANUAL_ADD = "btn_add";
    protected final String BTN_MANUAL_DEL = "btn_del";
    protected final String IS_AUTO_FILLSTATUS = "isAutoFillStatus";

    ManualJournalEditPlugin() {
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    public void afterCreateNewData(EventObject e) {
        Object org;
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List orgs = (List)fsp.getCustomParam("filtersCacheOrgsKey");
        this.removeNonManualModeOrg(orgs);
        if (orgs != null && orgs.size() > 0) {
            this.getModel().setValue("org", orgs.get(0));
            if (orgs.size() == 1) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
            }
        }
        if ((org = this.getModel().getValue("org")) != null) {
            this.fillOrgAndPeriodInfo(((DynamicObject)org).getLong("id"));
        }
        this.reviseData();
        int rowIndex = this.getModel().createNewEntryRow("manualentry");
        this.setExchangerate(rowIndex);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    protected abstract String getBillType();

    private Boolean isBankBillType() {
        return "cas_manualbankjournal".equalsIgnoreCase(this.getBillType());
    }

    private String getMainEntity() {
        return this.isBankBillType() != false ? "cas_bankjournal" : "cas_cashjournal";
    }

    private String getFoundEntity() {
        return this.isBankBillType() != false ? "cas_bankjournalentry" : "cas_cashjournalentry";
    }

    private String getAccountName() {
        return this.isBankBillType() != false ? "accountbank" : "accountcash";
    }

    protected void addListener() {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List orgIds = (List)fsp.getCustomParam("filtersCacheOrgsKey");
        ArrayList<Long> orgs = new ArrayList<Long>();
        if (orgIds != null && orgIds.size() > 0) {
            orgIds.forEach(o -> orgs.add(Long.parseLong(String.valueOf(o))));
        }
        this.removeNonManualModeOrg(orgs);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> {
            if (orgs != null && orgs.size() > 0) {
                ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
                lsp.setCustomParam("range", (Object)orgs);
            }
        });
        BasedataEdit acct = (BasedataEdit)this.getControl(this.getAccountName());
        acct.addBeforeF7SelectListener(evt -> {
            DynamicObject mainOrg = (DynamicObject)this.getModel().getValue("org");
            if (mainOrg == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"RevPayRuleEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isContainClosed = (Boolean)fsp.getCustomParam("filtersCacheCONTAINKey");
            QFilter[] filters = this.getAcctFilter(isContainClosed, Collections.singletonList(mainOrg.getLong("id")));
            if (filters == null || filters.length < 1) {
                return;
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.getListFilterParameter().getQFilters().addAll(Arrays.asList(filters));
        });
        BasedataEdit settleType = (BasedataEdit)this.getControl("settlementtype");
        settleType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            String filterKey = this.isBankBillType() != false ? "in" : "=";
            String filterValue = this.isBankBillType() != false ? Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13") : "0";
            QFilter filter = new QFilter("settlementtype", filterKey, (Object)filterValue);
            param.getListFilterParameter().getQFilters().add(filter);
        });
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener(evt -> {
            DynamicObject account = this.getModel().getDataEntity().getDynamicObject(this.getAccountName());
            if (account == null || account.getDynamicObjectCollection("currency") == null) {
                return;
            }
            DynamicObjectCollection currencys = account.getDynamicObjectCollection("currency");
            ArrayList<Object> currencyIds = new ArrayList<Object>(currencys.size());
            for (int i = 0; i < currencys.size(); ++i) {
                DynamicObject data;
                DynamicObject item = (DynamicObject)currencys.get(i);
                if (item == null || (data = item.getDynamicObject(1)) == null || !EmptyUtil.isNoEmpty((DynamicObject)data)) continue;
                currencyIds.add(data.getPkValue());
            }
            if (currencyIds.isEmpty()) {
                return;
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.setMultiSelect(false);
            QFilter filter = new QFilter("id", "in", currencyIds);
            param.getListFilterParameter().getQFilters().add(filter);
        });
    }

    private void removeNonManualModeOrg(List<Long> orgs) {
        if (orgs == null || orgs.isEmpty()) {
            return;
        }
        Iterator<Long> it = orgs.iterator();
        while (it.hasNext()) {
            Long orgId;
            Long object = it.next();
            if (object == null || SystemParameterHelper.isManualJournal((long)(orgId = Long.valueOf(((Object)object).toString()))) || SystemParameterHelper.isVoucherMixBookJournal((long)orgId) || SystemParameterHelper.isTradeMixHandJournal((long)orgId)) continue;
            it.remove();
        }
    }

    private void fillOrgAndPeriodInfo(Long orgId) {
        if (orgId == null || orgId < 1L) {
            return;
        }
        this.getModel().setValue("orgid", (Object)orgId);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        DynamicObject initOrg = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"id,standardcurrency,periodtype", (QFilter[])filter.toArray());
        if (initOrg != null) {
            this.getModel().setValue("periodtype", initOrg.get("periodtype"));
            this.getModel().setValue("basecurrency", initOrg.get("standardcurrency"));
        }
    }

    protected boolean isAutoFilling() {
        String isAutoFillStatus = this.getPageCache().get("isAutoFillStatus");
        return StringUtils.isNotEmpty((String)isAutoFillStatus) && Boolean.parseBoolean(isAutoFillStatus);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_new": {
                break;
            }
            case "bar_save": {
                this.save();
            }
        }
    }

    protected abstract QFilter[] getAcctFilter(boolean var1, List<Long> var2);

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isAutoFilling()) {
            return;
        }
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "debitamount": {
                this.changeX("debit", "debitamount", "creditamount", newValue, oldValue);
                this.localAmount();
                this.localAmountIsNull(newValue);
                this.processRpTypeBaseData(name, newValue, rowIndex);
                break;
            }
            case "creditamount": {
                this.changeX("credit", "creditamount", "debitamount", newValue, oldValue);
                this.localAmount();
                this.localAmountIsNull(newValue);
                this.processRpTypeBaseData(name, newValue, rowIndex);
                break;
            }
            case "billstatus": {
                this.getView().updateView();
                this.reviseData();
                break;
            }
            case "exchangerate": {
                this.localAmount();
                break;
            }
            case "currency": {
                IDataModel model = this.getModel();
                Object currency = model.getValue("currency");
                Object basecurrency = model.getValue("basecurrency");
                if (currency == null || basecurrency == null || ((DynamicObject)currency).getLong("id") != ((DynamicObject)basecurrency).getLong("id")) break;
                for (int i = 0; i < model.getEntryRowCount("manualentry"); ++i) {
                    model.setValue("exchangerate", (Object)1, i);
                }
                break;
            }
            case "org": {
                this.getModel().setValue(this.getAccountName(), null);
                this.getModel().setValue("currency", null);
            }
        }
    }

    public void processRpTypeBaseData(String key, Object newValue, int rowIndex) {
        String rpBaseType = this.getRpBaseType(key);
        if (EmptyUtil.isEmpty((Object)newValue)) {
            this.getModel().setValue("rpbasetype", null, rowIndex);
        } else {
            this.getModel().setValue("rpbasetype", (Object)rpBaseType, rowIndex);
        }
    }

    public String getRpBaseType(String key) {
        return "debitamount".equals(key) ? "cas_receivingbilltype" : "cas_paymentbilltype";
    }

    public void localAmount() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("manualentry");
        IDataModel model = this.getModel();
        Object exchangerate = model.getValue("exchangerate", rowIndex);
        if (exchangerate == null) {
            model.setValue("localamount", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            Object debit = model.getValue("debitamount", rowIndex);
            Object credit = model.getValue("creditamount", rowIndex);
            if (((BigDecimal)debit).compareTo(BigDecimal.ZERO) != 0) {
                model.setValue("localamount", (Object)((BigDecimal)debit).multiply((BigDecimal)exchangerate), rowIndex);
            } else if (((BigDecimal)credit).compareTo(BigDecimal.ZERO) != 0) {
                model.setValue("localamount", (Object)((BigDecimal)credit).multiply((BigDecimal)exchangerate), rowIndex);
            }
        }
    }

    public void localAmountIsNull(Object newValue) {
        if (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) == 0) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("manualentry");
            IDataModel model = this.getModel();
            model.setValue("localamount", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("copyentryrow".equals(operateKey)) {
            this.calculateXSum();
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        this.calculateXSum();
    }

    private void isNullAccountBank(String big) {
        Object dynamicObjectBank = this.getModel().getValue(this.getAccountName());
        Object dynamicObjectCurr = this.getModel().getValue("currency");
        if (dynamicObjectBank == null && dynamicObjectCurr == null) {
            this.getView().showErrorNotification(this.isBankBillType() != false ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u548c\u5e01\u79cd\u3002", (String)"BankStatementManualEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u73b0\u91d1\u8d26\u6237\u548c\u5e01\u79cd\u3002", (String)"ManualJournalEditPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(big, (Object)BigDecimal.ZERO);
        } else if (dynamicObjectBank == null) {
            this.getView().showTipNotification(this.isBankBillType() != false ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BankStatementManualEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u73b0\u91d1\u8d26\u6237\u3002", (String)"ManualJournalEditPlugin_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(big, (Object)BigDecimal.ZERO);
        } else if (dynamicObjectCurr == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"BankStatementManualEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(big, (Object)BigDecimal.ZERO);
        }
    }

    protected void changeAccount(Object newValue) {
        if (newValue == null) {
            return;
        }
        DynamicObject acct = (DynamicObject)newValue;
        DynamicObject defaultCurrency = acct.getDynamicObject("defaultcurrency");
        if (defaultCurrency == null) {
            DynamicObjectCollection currencys = acct.getDynamicObjectCollection("currency");
            defaultCurrency = (DynamicObject)currencys.get(0);
        }
        if (defaultCurrency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5e01\u79cd\u3002", (String)"ManualJournalEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(this.getAccountName(), null);
            return;
        }
        this.getModel().setValue("currency", defaultCurrency.getPkValue());
        this.calculateXSum();
    }

    private void changeX(String filedKey, String amountField, String disableField, Object newValue, Object oldValue) {
        this.isNullAccountBank(amountField);
        BigDecimal amount = (BigDecimal)newValue;
        int rowIndex = this.getModel().getEntryCurrentRowIndex("manualentry");
        if (amount.doubleValue() > 0.0) {
            this.getModel().setValue(disableField, (Object)BigDecimal.ZERO, rowIndex);
        }
        this.calculateXSum();
        this.autoCreateLastEntry();
    }

    private void autoCreateLastEntry() {
        int size = this.getModel().getEntryRowCount("manualentry");
        if (size < 1) {
            return;
        }
        int currentIndex = this.getModel().getEntryCurrentRowIndex("manualentry");
        if (currentIndex != size - 1) {
            return;
        }
        DynamicObject lastEntry = this.getModel().getEntryRowEntity("manualentry", size - 1);
        if (lastEntry == null) {
            return;
        }
        BigDecimal debit = lastEntry.getBigDecimal("debitamount");
        BigDecimal credit = lastEntry.getBigDecimal("creditamount");
        if (debit.doubleValue() == 0.0 && credit.doubleValue() == 0.0) {
            return;
        }
        int rowIndex = this.getModel().createNewEntryRow("manualentry");
        this.setExchangerate(rowIndex);
    }

    public void setExchangerate(int index) {
        IDataModel model = this.getModel();
        Object currency = model.getValue("currency");
        Object basecurrency = model.getValue("basecurrency");
        if (currency != null && basecurrency != null && ((DynamicObject)currency).getLong("id") == ((DynamicObject)basecurrency).getLong("id")) {
            model.setValue("exchangerate", (Object)1, index);
        }
    }

    private Long getOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        if (org != null) {
            return org.getLong("id");
        }
        return null;
    }

    private void calculateXSum() {
        BigDecimal debitSum = new BigDecimal(0);
        BigDecimal creditSum = new BigDecimal(0);
        DynamicObjectCollection manualEntrys = this.getModel().getEntryEntity("manualentry");
        for (DynamicObject entry : manualEntrys) {
            debitSum = debitSum.add(entry.getBigDecimal("debitamount"));
            creditSum = creditSum.add(entry.getBigDecimal("creditamount"));
        }
        if (debitSum.doubleValue() > 0.0) {
            this.getModel().setValue("debitsum", (Object)debitSum);
        }
        if (creditSum.doubleValue() > 0.0) {
            this.getModel().setValue("creditsum", (Object)creditSum);
        }
    }

    private boolean checkSaveInfo() {
        DynamicObject balanceAdust;
        IDataModel model = this.getModel();
        DynamicObject acct = (DynamicObject)model.getValue(this.isBankBillType() != false ? "accountbank" : "accountcash");
        if (acct == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u5148\u9009\u62e9\u8d26\u53f7\u3002", (String)"ManualJournalEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        int size = model.getEntryRowCount("manualentry");
        if (size < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5206\u5f55\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"ManualJournalEditPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date startPeriod = null;
        Date currentPeriodBegin = null;
        Date currentPeriodEnd = null;
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        Long orgId = this.getOrgId();
        DynamicObject exratetable = null;
        if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
            this.getView().showTipNotification(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
            return false;
        }
        DynamicObject initDy = SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
        startPeriod = initDy.getDate("startperiod.begindate");
        DynamicObject currentperiod = initDy.getDynamicObject("currentperiod");
        if (currentperiod != null) {
            currentPeriodBegin = currentperiod.getDate("begindate");
            currentPeriodEnd = currentperiod.getDate("enddate");
        } else {
            currentPeriodBegin = initDy.getDate("startperiod.begindate");
            currentPeriodEnd = initDy.getDate("startperiod.enddate");
        }
        exratetable = initDy.getDynamicObject("exratetable");
        if (startPeriod == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"ManualJournalEditPlugin_30", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        if (currentPeriodBegin == null || currentPeriodEnd == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff01", (String)"ManualJournalEditPlugin_31", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        if (exratetable == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u6c47\u7387\u8868\u4e3a\u7a7a\u3002", (String)"ManualJournalEditPlugin_34", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        Object account = model.getValue(this.getAccountName());
        Object currency = model.getValue("currency");
        Date balanceDate = null;
        String billNo = "";
        boolean parameterBoolean = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs095");
        if (!parameterBoolean && (balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust((Long)orgId, (Long)((DynamicObject)account).getLong("id"), (Long)((DynamicObject)currency).getLong("id"))) != null && (BillStatusEnum.AUDIT.getValue().equals(balanceAdust.getString("billstatus")) || BillStatusEnum.SUBMIT.getValue().equals(balanceAdust.getString("billstatus")))) {
            balanceDate = balanceAdust.getDate("bizdate");
            billNo = balanceAdust.getString("billno");
        }
        boolean diffCurr = false;
        BigDecimal exchangerate = BigDecimal.ONE;
        Object basecurrency = model.getValue("basecurrency");
        if (currency != null && basecurrency != null && ((DynamicObject)currency).getLong("id") != ((DynamicObject)basecurrency).getLong("id")) {
            diffCurr = true;
        }
        for (int i = 0; i < size; ++i) {
            BigDecimal crdit;
            DynamicObject entry = model.getEntryRowEntity("manualentry", i);
            Date bookDate = entry.getDate("bookdate");
            Date bizDate = entry.getDate("bizdate");
            String dateCheckCode = ManualJournalHelper.checkDate((Date)bizDate, (Date)bookDate);
            if (StringUtils.isNotEmpty((String)dateCheckCode)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"ManualJournalEditPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1, dateCheckCode));
                return false;
            }
            BigDecimal debit = entry.getBigDecimal("debitamount");
            int code = ManualJournalHelper.checkAmount((BigDecimal)debit, (BigDecimal)(crdit = entry.getBigDecimal("creditamount")));
            if (code == -1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%s\u884c\uff1a\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"ManualJournalEditPlugin_10_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (code == -2) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%s\u884c\uff1a\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u6709\u503c\u3002", (String)"ManualJournalEditPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (startPeriod != null && bookDate.before(startPeriod)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%s\u884c\uff1a\u4e0d\u5141\u8bb8\u65b0\u589e\u521d\u59cb\u5316\u65e5\u671f\u4e4b\u524d\u7684\u65e5\u8bb0\u8d26\u3002", (String)"ManualJournalEditPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (diffCurr && entry.getBigDecimal("exchangerate").compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)((DynamicObject)currency).getLong("id"), (Long)((DynamicObject)basecurrency).getLong("id"), (Long)orgId, (Date)bizDate, (Long)exratetable.getLong("id"));
                if (exchangeRate == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%s\u884c\uff1a\u8bf7\u7ef4\u62a4\u5f53\u524d\u65e5\u671f\u7684\u6c47\u7387\u3002", (String)"ManualJournalEditPlugin_35", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
                    return false;
                }
                this.getModel().setValue("exchangerate", (Object)exchangeRate, i);
                if (debit.compareTo(BigDecimal.ZERO) != 0) {
                    model.setValue("localamount", (Object)debit.multiply(exchangerate), i);
                } else if (crdit.compareTo(BigDecimal.ZERO) != 0) {
                    model.setValue("localamount", (Object)crdit.multiply(exchangerate), i);
                }
            }
            if (!diffCurr && entry.getBigDecimal("exchangerate").compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("exchangerate", (Object)BigDecimal.ONE);
            }
            if (bookDate.compareTo(currentPeriodBegin) < 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7b2c%s\u884c\u8bb0\u8d26\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u5df2\u7ed3\u8d26\u3002", (String)"ManualJournalEditPlugin_33", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (balanceDate == null || balanceDate.compareTo(bookDate) <= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%1$s\u884c\uff1a \u8bb0\u8d26\u65e5\u671f\u4e4b\u540e\u5df2\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868[%2$s]", (String)"ManualJournalEditPlugin_27", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1, billNo));
            return false;
        }
        return true;
    }

    private void save() {
        this.reviseData();
        if (!this.checkSaveInfo()) {
            return;
        }
        if (this.saveEvent()) {
            List<String> formrpt;
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ManualJournalEditPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            IFormView view = this.getView().getParentView();
            if (view != null && (formrpt = Arrays.asList("cas_cashjournalformrpt", "cas_bankjournalformrpt")).indexOf(view.getFormShowParameter().getFormId()) < 0) {
                this.getView().getParentView().updateView();
            }
        }
    }

    private void reviseData() {
        int size = this.getModel().getEntryRowCount("manualentry");
        if (size < 2) {
            return;
        }
        int lastIndex = size - 1;
        for (int i = 0; i < size; ++i) {
            DynamicObject lastRow = this.getModel().getEntryRowEntity("manualentry", lastIndex);
            BigDecimal debit = lastRow.getBigDecimal("debitamount");
            BigDecimal credit = lastRow.getBigDecimal("creditamount");
            if (debit.compareTo(BigDecimal.ZERO) != 0 || credit.compareTo(BigDecimal.ZERO) != 0) continue;
            this.getModel().deleteEntryRow("manualentry", lastIndex);
            --lastIndex;
        }
    }

    protected boolean saveEvent() {
        try (TXHandle tx = TX.requiresNew();){
            this.handleSaveMainInfo();
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            boolean bl = true;
            return bl;
        }
    }

    public void handleSaveMainInfo() {
        DynamicObject accountOrg;
        Long accountOrgId;
        DynamicObject balanceAccount;
        IDataModel model = this.getModel();
        DynamicObject baseInfo = model.getDataEntity();
        String entity = this.getMainEntity();
        DynamicObjectCollection manualEntrys = model.getEntryEntity("manualentry");
        if (manualEntrys == null || manualEntrys.isEmpty()) {
            return;
        }
        if (model.getValue("org") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"ManualJournalEditPlugin_36", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        DynamicObject account = (DynamicObject)baseInfo.get(this.getAccountName());
        DynamicObject recPeriod = null;
        if (this.isBankBillType().booleanValue() && EmptyUtil.isNoEmpty((DynamicObject)account) && EmptyUtil.isNoEmpty((DynamicObject)(balanceAccount = BalanceAccHelper.balanceAcc((Long)(accountOrgId = Long.valueOf((accountOrg = account.getDynamicObject("openorg")).getLong("id"))))))) {
            recPeriod = balanceAccount.getDynamicObject("recperiod");
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        Date createTime = new Date();
        ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>(10);
        DynamicObject periodType = null;
        DynamicObject initDy = SystemStatusCtrolHelper.getSystemStatusCtrol((long)((Long)baseInfo.getDynamicObject("org").getPkValue()));
        if (CasHelper.isNotEmpty((Object)initDy)) {
            periodType = initDy.getDynamicObject("periodtype");
        }
        String timeStr = DateUtils.formatString((Date)createTime, (String)"yyyyMMddhhmmss");
        for (int i = 0; i < manualEntrys.size(); ++i) {
            DynamicObject periodByDate;
            Boolean isValid = true;
            DynamicObject manual = (DynamicObject)manualEntrys.get(i);
            DynamicObject saveInfo = BusinessDataServiceHelper.newDynamicObject((String)entity);
            saveInfo.set("createtime", (Object)createTime);
            saveInfo.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            saveInfo.set("cashier", (Object)Long.valueOf(RequestContext.get().getUserId()));
            saveInfo.set("source", (Object)1);
            saveInfo.set("sourcebilltype", (Object)this.getBillType());
            saveInfo.set("batchno", (Object)timeStr);
            saveInfo.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            saveInfo.set("org", (Object)this.getOrgId());
            saveInfo.set("currency", baseInfo.get("currency"));
            saveInfo.set("basecurrency", baseInfo.get("basecurrency"));
            saveInfo.set("settlementtype", manual.get("settlementtype"));
            saveInfo.set("description", manual.get("description"));
            saveInfo.set("bizdate", manual.get("bizdate"));
            saveInfo.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
            saveInfo.set("modifytime", (Object)new Date());
            Date bookDate = manual.getDate("bookdate");
            saveInfo.set("bookdate", (Object)bookDate);
            if (null != periodType) {
                long period = ManualJournalHelper.getPeriodIdByDate((Date)bookDate, (long)periodType.getLong("id"));
                saveInfo.set("period", (Object)period);
            }
            if (this.isBankBillType().booleanValue() && EmptyUtil.isNoEmpty((DynamicObject)recPeriod) && EmptyUtil.isNoEmpty((DynamicObject)(periodByDate = PeriodHelper.getPeriodByDate((long)this.getOrgId(), (Date)bookDate))) && PeriodHelper.before((DynamicObject)periodByDate, (DynamicObject)recPeriod)) {
                isValid = false;
            }
            if (this.isBankBillType().booleanValue()) {
                saveInfo.set("isvalid", (Object)isValid);
            }
            BigDecimal debit = manual.getBigDecimal("debitamount");
            BigDecimal credit = manual.getBigDecimal("creditamount");
            saveInfo.set("debitamount", (Object)debit);
            saveInfo.set("creditamount", (Object)credit);
            saveInfo.set("exchangerate", (Object)manual.getBigDecimal("exchangerate"));
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal localamount = BigDecimal.ZERO;
            if (debit != null && debit.compareTo(BigDecimal.ZERO) > 0) {
                saveInfo.set("direction", (Object)1);
                amount = debit;
                localamount = debit.multiply(manual.getBigDecimal("exchangerate"));
            } else if (credit != null && credit.compareTo(BigDecimal.ZERO) > 0) {
                saveInfo.set("direction", (Object)2);
                amount = credit;
                localamount = credit.multiply(manual.getBigDecimal("exchangerate"));
            }
            saveInfo.set("localamount", (Object)localamount);
            saveInfo.set("oppunit", manual.get("oppunit"));
            saveInfo.set(this.getAccountName(), baseInfo.get(this.getAccountName()));
            if ("accountbank".equals(this.getAccountName())) {
                saveInfo.set("openorg", ((DynamicObject)baseInfo.get(this.getAccountName())).get("openorg"));
            }
            if (this.isBankBillType().booleanValue()) {
                saveInfo.set("settlementnumber", manual.get("settlementnumber"));
                saveInfo.set("oppbank", manual.get("oppbank"));
                saveInfo.set("oppacctnumber", manual.get("oppacctnumber"));
                saveInfo.set("ischeck", manual.get("ischeck"));
            }
            if (this.getOrgId() != null) {
                String code = CodeRuleHelper.generateNumber((String)this.getMainEntity(), (DynamicObject)saveInfo, (String)String.valueOf(this.getOrgId()), (String)timeStr);
                saveInfo.set("billno", (Object)code);
                String sourcebillnumber = manual.getString("sourcebillnumber");
                if (CasHelper.isEmpty((Object)sourcebillnumber)) {
                    sourcebillnumber = code;
                }
                saveInfo.set("sourcebillnumber", (Object)sourcebillnumber);
            }
            saveInfo.set("rpbasetype", manual.get("rpbasetype"));
            saveInfo.set("rptype", manual.get("rptype"));
            DynamicObjectCollection entrys = saveInfo.getDynamicObjectCollection("entry");
            DynamicObject entry = entrys.addNew();
            entry.set("e_fundflowitem", manual.get("fundflowitem"));
            entry.set("e_amount", (Object)amount);
            entry.set("e_localamount", (Object)localamount);
            entry.set("e_oppunit", manual.get("oppunit"));
            entry.set("e_org", baseInfo.get("org"));
            entry.set("e_currency", baseInfo.get("currency"));
            try {
                for (Object plugin : this.getView().getFormShowParameter().createPlugin()) {
                    if (!(plugin instanceof ManualJournalExtend)) continue;
                    ((ManualJournalExtend)plugin).extendSaveInfo(saveInfo, baseInfo, i);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            journalList.add(saveInfo);
        }
        if (!journalList.isEmpty()) {
            if ("cas_bankjournal".equals(entity)) {
                CasBankJournalHelper.updateBillValue((DynamicObject[])journalList.toArray(new DynamicObject[0]));
                CasBankJournalHelper.updateBalance((DynamicObject[])journalList.toArray(new DynamicObject[0]));
            }
            BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])journalList.toArray(new DynamicObject[0]), (OperateType)OperateType.ADD);
            logger.info("casBalanceModelLog_needBalanceModelBillNo:{}:", (Object)journalList.stream().map(o -> o.get("billno")).collect(Collectors.toSet()).toString());
            SaveServiceHelper.save((IDataEntityType)type, (Object[])journalList.toArray(new DynamicObject[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("new_call") && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getModel().setDataChanged(false);
            this.getView().invokeOperation("new");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        if (e.getSource() instanceof FormOperate && (opKey = ((FormOperate)e.getSource()).getOperateKey()).equals("new") && this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u65b0\u589e\uff1f", (String)"ManualJournalEditPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("new_call", (IFormPlugin)this));
            e.setCancel(true);
        }
    }
}

