/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;

public class PayBillCrossPlugin
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "payerbank": {
                this.payerBankChanged(newValue);
                break;
            }
            case "feeactbank": {
                this.feeActBankF7Changed(newValue);
                break;
            }
            case "currency": 
            case "dpcurrency": {
                this.setValue("transtype", null);
                break;
            }
            case "iscrosspay": {
                this.defaultCrossTranType(this.getDynamicObject("payerbank"));
                break;
            }
            case "proxybebank": {
                this.proxyBeBankChanged(newValue);
            }
        }
    }

    private void countryChanged(Object newValue) {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscrosspay"});
        if (newValue == null) {
            return;
        }
        DynamicObject country = (DynamicObject)newValue;
    }

    private void payerBankChanged(Object newValue) {
        this.setValue("crosstrantype", null);
        this.setValue("transtype", null);
        this.setValue("paycountry", null);
        if (newValue == null) {
            return;
        }
        DynamicObject payerBank = (DynamicObject)newValue;
        this.setValue("paycountry", payerBank.getDynamicObject("country"));
        this.defaultCrossTranType(payerBank);
    }

    private void proxyBeBankChanged(Object newValue) {
        if (newValue == null) {
            this.setValue("proxybebankname", null);
            this.setValue("proxybebanksc", null);
            this.setValue("proxybebankad", null);
            this.setValue("proxybebankcountry", null);
            return;
        }
        DynamicObject proxyBeBank = (DynamicObject)newValue;
        String proxyBeBankFieldVis = this.getPageCache().get("proxyBeBankFieldVisible");
        Map proxyBeBankFieldVisibleM = CasHelper.isNotEmpty((Object)proxyBeBankFieldVis) ? (Map)SerializationUtils.fromJsonString((String)proxyBeBankFieldVis, Map.class) : new HashMap();
        PaymentBillPluginHelper.fillBeBankInfo((Object)proxyBeBank.getPkValue(), proxyBeBankFieldVisibleM, (IDataModel)this.getModel(), (boolean)true);
    }

    private void defaultCrossTranType(DynamicObject payerBank) {
        Boolean isCrossPay = (Boolean)this.getValue("iscrosspay");
        if (!isCrossPay.booleanValue()) {
            return;
        }
        if (payerBank == null) {
            return;
        }
        DynamicObject bankCate = payerBank.getDynamicObject("bank_cate");
        if (bankCate == null) {
            return;
        }
        QFilter eFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dFilter = new QFilter("isdefault", "=", (Object)"1");
        QFilter bcFilter = new QFilter("bankcate", "=", bankCate.getPkValue());
        DynamicObject[] crosstrantypes = BusinessDataServiceHelper.load((String)"bei_crosstrantype", (String)"id", (QFilter[])new QFilter[]{eFilter, dFilter, bcFilter});
        if (crosstrantypes != null && crosstrantypes.length > 0) {
            this.setValue("crosstrantype", crosstrantypes[0].getPkValue());
        }
    }

    private void feeActBankF7Changed(Object newValue) {
        DynamicObject feeActBank = (DynamicObject)newValue;
        if (feeActBank == null) {
            return;
        }
        Boolean iscrosspay = (Boolean)this.getValue("iscrosspay");
        if (iscrosspay.booleanValue()) {
            DynamicObject feeCurrency = this.getDynamicObject("feecurrency");
            boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"bd_accountbanks", (Object)feeActBank.getPkValue(), (DynamicObject)feeCurrency);
            if (!containCurrency) {
                Long defaultCurrencyId = (Long)feeActBank.get("defaultcurrency.id");
                this.setValue("feecurrency", defaultCurrencyId);
            }
        }
        Boolean isCurrencyEditable = feeActBank.getBoolean("ismulcurrency");
        this.getView().setEnable(isCurrencyEditable, new String[]{"feecurrency"});
    }

    private void initF7() {
        this.fillTransType();
        this.fillCrossTranType();
        this.fillFeeCurrency();
        this.fillFeeActBank();
    }

    private void fillFeeActBank() {
        BasedataEdit feeActBank = (BasedataEdit)this.getControl("feeactbank");
        feeActBank.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject org = this.getDynamicObject("org");
            if (org == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba", (String)"PayBillCrossPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            long orgID = org.getPkValue() == null ? 0L : Long.parseLong(org.getPkValue().toString());
            QFilter accountAuthAssignFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgID);
            ArrayList<QFilter> listQ = new ArrayList<QFilter>(2);
            listQ.add(accountAuthAssignFilter);
            listQ.add(AccountBankHelper.getUsableFilter());
            showParameter.getListFilterParameter().setQFilters(listQ);
        });
    }

    private void fillFeeCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("feecurrency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject feeActBank = (DynamicObject)this.getModel().getValue("feeactbank");
            if (feeActBank != null) {
                Set currencys = AccountBankHelper.getCurrencyPks((long)((Long)feeActBank.getPkValue()));
                qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillCrossTranType() {
        BasedataEdit crosstrantypeF7 = (BasedataEdit)this.getControl("crosstrantype");
        crosstrantypeF7.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection tyList;
            DynamicObject payerBank = this.getDynamicObject("payerbank");
            if (payerBank == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ed8\u6b3e\u94f6\u884c\u3002", (String)"PayBillCrossPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bankCate = payerBank.getDynamicObject("bank_cate");
            if (bankCate != null && (tyList = QueryServiceHelper.query((String)"queryTranType", (String)"bei_crosstrantype", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankcate", "=", bankCate.getPkValue())}, null)) != null && tyList.size() > 0) {
                List tyIds = tyList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", tyIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void fillTransType() {
        BasedataEdit transtypeF7 = (BasedataEdit)this.getControl("transtype");
        transtypeF7.addBeforeF7SelectListener(evt -> {
            DynamicObject[] transtypes;
            DynamicObject payerBank = this.getDynamicObject("payerbank");
            if (payerBank == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ed8\u6b3e\u94f6\u884c\u3002", (String)"PayBillCrossPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject currency = this.getDynamicObject("currency");
            if (currency == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u6b3e\u5e01\u79cd\u3002", (String)"PayBillCrossPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dpCurrency = this.getDynamicObject("dpcurrency");
            if (dpCurrency == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ed8\u6b3e\u5e01\u79cd\u3002", (String)"PayBillCrossPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bankCate = payerBank.getDynamicObject("bank_cate");
            Long bankCateId = 0L;
            if (bankCate != null) {
                bankCateId = (Long)bankCate.getPkValue();
            }
            Long currencyId = (Long)currency.getPkValue();
            Long dpCurrencyId = (Long)currency.getPkValue();
            QFilter eFilter = new QFilter("enable", "=", (Object)"1");
            HashSet<Long> pks = new HashSet<Long>();
            for (DynamicObject transtype : transtypes = BusinessDataServiceHelper.load((String)"bei_transtype", (String)"id,bankcategory,currency", (QFilter[])new QFilter[]{eFilter})) {
                DynamicObjectCollection bankcategorys = transtype.getDynamicObjectCollection("bankcategory");
                DynamicObjectCollection currencys = transtype.getDynamicObjectCollection("currency");
                Boolean isBankCMatch = Boolean.TRUE;
                Boolean isCurMatch = Boolean.TRUE;
                Boolean isDpCurMatch = Boolean.TRUE;
                if (bankcategorys != null && bankcategorys.size() > 0 && bankCateId > 0L) {
                    isBankCMatch = Boolean.FALSE;
                    for (DynamicObject bankcategory : bankcategorys) {
                        Long bankcategoryId = bankcategory.getLong("fbasedataid_id");
                        if (bankCateId.longValue() != bankcategoryId.longValue()) continue;
                        isBankCMatch = Boolean.TRUE;
                        break;
                    }
                }
                if (currencys != null && currencys.size() > 0) {
                    isCurMatch = Boolean.FALSE;
                    isDpCurMatch = Boolean.FALSE;
                    for (DynamicObject c : currencys) {
                        Long cId = c.getLong("fbasedataid_id");
                        if (currencyId.longValue() == cId.longValue()) {
                            isCurMatch = Boolean.TRUE;
                            break;
                        }
                        if (dpCurrencyId.longValue() != cId.longValue()) continue;
                        isDpCurMatch = Boolean.TRUE;
                        break;
                    }
                }
                if (!isBankCMatch.booleanValue() || !isCurMatch.booleanValue() && !isDpCurMatch.booleanValue()) continue;
                pks.add(transtype.getLong("id"));
            }
            if (pks.size() > 0) {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", pks);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        Map searchResult = e.getSearchResult();
        for (Map.Entry entry : searchResult.entrySet()) {
            DynamicObject finorgInfo;
            List baseData = (List)entry.getValue();
            if (!"transtype".equals(((BasedataItem)entry.getKey()).getFieldKey()) || baseData.isEmpty() || baseData.size() <= 1) continue;
            Object source = e.getSource();
            Map sourceObj = ((RowMapper)source).getSourceObj();
            Map payerbankMap = (Map)sourceObj.get("payerbank");
            String payerbankNumer = (String)payerbankMap.get("number");
            long bankCateId = 0L;
            if (CasHelper.isNotEmpty((Object)payerbankNumer) && CasHelper.isNotEmpty((Object)(finorgInfo = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"bank_cate", (QFilter[])new QFilter("number", "=", (Object)payerbankNumer).toArray())))) {
                bankCateId = finorgInfo.getLong("bank_cate");
            }
            String currencyNumber = this.getCurrencyNubmber(sourceObj, "currency");
            String dpCurrencyNumber = this.getCurrencyNubmber(sourceObj, "dpcurrency");
            Long keepId = 0L;
            Map transTypeMap = BusinessDataServiceHelper.loadFromCache((Object[])baseData.toArray(), (String)"bei_transtype");
            for (DynamicObject transType : transTypeMap.values()) {
                DynamicObjectCollection bankcategorys = transType.getDynamicObjectCollection("bankcategory");
                Set bankcateIds = bankcategorys.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toSet());
                DynamicObjectCollection currencys = transType.getDynamicObjectCollection("currency");
                Set bankCurrency = currencys.stream().map(s -> s.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
                if (!bankcateIds.contains(bankCateId) || bankCurrency.size() != 0 && !bankCurrency.contains(currencyNumber) && !bankCurrency.contains(dpCurrencyNumber)) continue;
                keepId = transType.getLong("id");
                break;
            }
            if (CasHelper.isNotEmpty((Object)keepId)) {
                Iterator iterator = baseData.iterator();
                while (iterator.hasNext()) {
                    Long next = (Long)iterator.next();
                    if (keepId.equals(next)) continue;
                    iterator.remove();
                }
            }
            if (baseData.isEmpty() || baseData.size() <= 1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7b26\u5408\u94f6\u884c\u7c7b\u522b\u3001\u5e01\u79cd\u4e14\u53ef\u7528\u7684\u4ea4\u6613\u79cd\u7c7b\u3002", (String)"PayBillCrossPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private String getCurrencyNubmber(Map<String, Object> sourceObj, String currencyProp) {
        Map currencyMap = (Map)sourceObj.get(currencyProp);
        if (currencyMap != null) {
            return (String)currencyMap.get("number");
        }
        return null;
    }
}

