/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.enums.FeePayerEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class PayBillDiffCurrency
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillDpCurrency();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long orgId = this.getPk("org");
        this.setDefaultRecExratetable(orgId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFieldCaption();
        this.setRecExchangerateEditable();
        this.setExratetableVisibility();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "dpexratetable": 
            case "dpexratedate": {
                this.setRecExchangerateEditable();
                break;
            }
            case "dpcurrency": {
                this.setRecExchangerateEditable();
                this.setExratetableVisibility();
                this.setFeeCurrency();
                break;
            }
            case "dpexchangerate": 
            case "agreedrate": 
            case "agreedquotation": 
            case "dppayquotation": {
                this.calculateDpAmt();
                break;
            }
            case "isdiffcur": {
                this.isDiffCurChanged(newValue);
                break;
            }
            case "feepayer": {
                this.feePayerChanged(newValue);
                break;
            }
            case "currency": 
            case "exratedate": 
            case "exratetable": {
                break;
            }
            case "dpamt": {
                this.dpAmtChanged(newValue);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void isDiffCurChanged(Object newValue) {
        Boolean isDiffCur = (Boolean)newValue;
        if (!isDiffCur.booleanValue()) {
            if (!this.isBotpCreate()) {
                this.getModel().beginInit();
                this.getModel().setValue("exchangerate", this.getModel().getValue("dpexchangerate"));
                this.getModel().setValue("agreedrate", (Object)1);
                this.getModel().endInit();
                this.getView().updateView("exchangerate");
                this.getView().updateView("agreedrate");
                this.getModel().setValue("currency", this.getModel().getValue("dpcurrency"));
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("dpexchangerate", this.getModel().getValue("exchangerate"));
                this.getModel().setValue("agreedrate", (Object)1);
                this.getModel().endInit();
                this.getView().updateView("dpexchangerate");
                this.getView().updateView("agreedrate");
                this.getModel().setValue("dpcurrency", this.getModel().getValue("currency"));
            }
            this.setValue("contractno", null);
        } else {
            this.setValue("fee", null);
            DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank");
            if (payerAcctBank != null) {
                Long defaultCurrencyId = (Long)payerAcctBank.get("defaultcurrency.id");
                this.setValue("dpcurrency", defaultCurrencyId);
            }
        }
        this.calculateDpAmt();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"dpcurrency"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
        this.setCurrencyEditable(isDiffCur);
        this.initFieldCaption();
    }

    private void calculateDpAmt() {
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        DynamicObject currency = this.getDynamicObject("currency");
        BigDecimal actPayAmt = this.getBigDecimal("actpayamt");
        String dppayquotation = this.getString("dppayquotation");
        String agreedquotation = this.getString("agreedquotation");
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        if (dpcurrency == null) {
            return;
        }
        int dppayround = dpcurrency.getInt("amtprecision");
        if (currency != null) {
            actPayAmt = actPayAmt.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = this.getBigDecimal("localamt");
        BigDecimal agreedRate = this.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = QuotationHelper.callToCurrency((BigDecimal)actPayAmt, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        this.getModel().beginInit();
        this.setValue("dpamt", dpAmt);
        this.setValue("dplocalamt", dpLocalAmt);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt));
        this.getModel().endInit();
        this.getView().updateView("dpamt");
        this.getView().updateView("dplocalamt");
        this.getView().updateView("lossamt");
    }

    private void dpAmtChanged(Object newValue) {
        BigDecimal dpAmt = (BigDecimal)newValue;
        String dppayquotation = this.getString("dppayquotation");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        BigDecimal localAmt = this.getBigDecimal("localamt");
        this.setValue("dplocalamt", dpLocalAmt);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt));
        BigDecimal actPayAmt = this.getBigDecimal("actpayamt");
        if (actPayAmt.compareTo(new BigDecimal(0)) == 0 || dpAmt.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        String agreedquotation = this.getString("agreedquotation");
        BigDecimal agreedRate = BigDecimal.ONE;
        agreedRate = "1".equals(agreedquotation) ? actPayAmt.divide(dpAmt, 10, RoundingMode.HALF_UP) : dpAmt.divide(actPayAmt, 10, RoundingMode.HALF_UP);
        this.getModel().beginInit();
        this.setValue("agreedrate", agreedRate);
        this.getModel().endInit();
        this.getView().updateView("agreedrate");
    }

    protected void setRecExchangerateEditable() {
        DynamicObject srcCurrency = this.getDynamicObject("dpcurrency");
        DynamicObject destCurrency = this.getDynamicObject("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dpexchangerate"});
        }
    }

    private void setDefaultRecExratetable(Long orgId) {
        Long exchangeRateTableId = 0L;
        try {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getModel().setValue("dpexratetable", (Object)exchangeRateTableId);
    }

    private void setCurrencyEditable(Boolean isDiffCur) {
        Boolean isCurrencyEditable = Boolean.TRUE;
        DynamicObject settleType = this.getDynamicObject("settletype");
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (isCash) {
            DynamicObject accountCash = this.getDynamicObject("payeracctcash");
            if (accountCash != null) {
                isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
            }
        } else {
            DynamicObject accountBank = this.getDynamicObject("payeracctbank");
            if (accountBank != null) {
                isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
            }
        }
        if (isDiffCur.booleanValue()) {
            this.getView().setEnable(isCurrencyEditable, new String[]{"dpcurrency"});
        } else {
            this.getView().setEnable(isCurrencyEditable, new String[]{"currency"});
        }
        if (this.isBotpCreate()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        }
        if (isDiffCur.booleanValue() && this.isBotpCreate() && "bei_intelpay".equals(this.getValue("sourcebilltype"))) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
        }
    }

    private void fillDpCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("dpcurrency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
            if (isDiffCur.booleanValue()) {
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
                if (isCash) {
                    DynamicObject accountCash = (DynamicObject)this.getModel().getValue("payeracctcash");
                    if (accountCash != null) {
                        List currencys = AccountCashHelper.getCurrencys(Collections.singletonList((Long)accountCash.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                } else {
                    DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
                    if (payerAcctBank != null) {
                        Set currencys = AccountBankHelper.getCurrencyPks((long)((Long)payerAcctBank.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                }
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initFieldCaption() {
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            ((FieldEdit)this.getControl("currency")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"PayBillDiffCurrency_1", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("exchangerate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u6c47\u7387", (String)"PayBillDiffCurrency_2", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("payquotation")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u6c47\u7387\u6362\u7b97\u65b9\u5f0f", (String)"PayBillDiffCurrency_20", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("actpayamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"PayBillDiffCurrency_3", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("localamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"PayBillDiffCurrency_4", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dpcurrency")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd", (String)"PayBillDiffCurrency_5", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dpexchangerate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387", (String)"PayBillDiffCurrency_6", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dppayquotation")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387\u6362\u7b97\u65b9\u5f0f", (String)"PayBillDiffCurrency_60", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dpamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"PayBillDiffCurrency_7", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("dplocalamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"PayBillDiffCurrency_8", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        } else {
            ((FieldEdit)this.getControl("currency")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd", (String)"PayBillDiffCurrency_5", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("exchangerate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387", (String)"PayBillDiffCurrency_6", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("payquotation")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6c47\u7387\u6362\u7b97\u65b9\u5f0f", (String)"PayBillDiffCurrency_60", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("actpayamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"PayBillDiffCurrency_7", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getControl("localamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"PayBillDiffCurrency_8", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        }
    }

    private boolean isBotpCreate() {
        String sourceBillType = this.getString("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }

    private void setExratetableVisibility() {
        Long currencyId = this.getPk("currency");
        Long dpCurrencyId = this.getPk("dpcurrency");
        Long basecurrencyId = this.getPk("basecurrency");
        if (currencyId != null && !currencyId.equals(basecurrencyId) || dpCurrencyId != null && !dpCurrencyId.equals(basecurrencyId)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"exratetable"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"exratedate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exratetable"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exratedate"});
        }
    }

    private void feePayerChanged(Object newValue) {
        String feePayer = (String)newValue;
        this.getModel().beginInit();
        if (FeePayerEnum.REC.getValue().equals(feePayer)) {
            this.setValue("feeactbank", null);
            this.setValue("feecurrency", null);
        } else {
            this.setValue("feeactbank", this.getValue("payeracctbank"));
            this.setFeeCurrency();
        }
        this.getModel().endInit();
        this.getView().updateView("feeactbank");
        this.getView().updateView("feecurrency");
    }

    private void setFeeCurrency() {
        if (!FeePayerEnum.REC.getValue().equals(this.getString("feepayer"))) {
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
            if (isDiffCur.booleanValue()) {
                this.setValue("feecurrency", this.getValue("dpcurrency"));
            } else {
                this.setValue("feecurrency", this.getValue("currency"));
            }
        }
    }
}

