/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.EventObject;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.errorcode.PayErrorCode;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class PayTempatePlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"paytemplate"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("paytemplate".equals(itemKey)) {
            this.showInterPayPlan();
        }
    }

    private void showInterPayPlan() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(new PayErrorCode().INTER_PAY_NOROW().getMessage());
            return;
        }
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"cas_interpayplan", (boolean)false, (int)2);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_paybill", (String)"4715a0df000000ac");
        QFilter qFilter = new QFilter("org", "in", (Object)orgList);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        parameter.getListFilterParameter().getQFilters().add(qFilter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "KEY_PAYTEMPLATE"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"KEY_PAYTEMPLATE") && closedCallBackEvent.getReturnData() != null) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData.size() == 0) {
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("tempid", String.valueOf(returnData.get(0)));
            this.getView().invokeOperation("paytemplate", option);
        }
    }
}

