/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyRecChgPlugin
extends AbstractFormPlugin {
    private static final String MESSAGEBOXCLOSED = "recchg";
    private static final String CACHE_RECHGPKVALUE = "rechgPKvalue";
    private static final String PAYAPPLYDATA = "payApplyData";
    private static final String ORG = "org";
    private static final String SOURCEID = "sourceId";
    private static final String SOURCEBILLNO = "sourcebillno";
    private static final String SOURCETYPE = "sourceType";
    private static final String SOURCEACTION = "sourceAction";
    private static final String SELECTROW = "selectRow";
    private static final String QFILTERSTR = "qFilterStr";
    private static final String CALLBACK_LOCKBILL = "CALLBACK_LOCKBILL";
    private static final String[] LOCKOP = new String[]{"batchsche", "comfirmsche"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection payapplyentrys = this.getModel().getEntryEntity("cas_payapplyentry");
        boolean hasChange = payapplyentrys.stream().anyMatch(item -> !PayApplyRecChgStatusEnum.NOCHG.getValue().equals(item.get("e_chgstatus")));
        boolean Changed = payapplyentrys.stream().anyMatch(item -> !EmptyUtil.isEmpty((Object)item.get("e_chgpayeebank")) || !EmptyUtil.isEmpty((Object)item.get("e_chgpayeeaccbanknum")));
        this.getView().setVisible(Boolean.valueOf(hasChange), new String[]{"e_chgstatus", "e_operation"});
        this.getView().setVisible(Boolean.valueOf(Changed), new String[]{"e_chgpayeeaccbanknum", "e_chgpayeebank"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)MESSAGEBOXCLOSED)) {
            DynamicObject dynamicObject;
            int index = this.getModel().getEntryCurrentRowIndex("cas_payapplyentry");
            DynamicObject applyEntry = this.getModel().getEntryRowEntity("cas_payapplyentry", index);
            boolean hasInvalid = this.getModel().getEntryEntity("cas_payinfo").stream().filter(o -> StringUtils.equals((CharSequence)o.getString("entry_applyid"), (CharSequence)applyEntry.getString("e_splitid"))).allMatch(o -> o.getBoolean("entry_invalid"));
            if (hasInvalid) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7b14\u7533\u8bf7\u5df2\u5168\u90e8\u62d2\u4ed8\uff0c\u65e0\u9700\u53d1\u8d77\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayApplyRecChgPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("entrys.sourceentryid", "=", applyEntry.getPkValue());
            DynamicObjectCollection resultdate = QueryServiceHelper.query((String)"cas_paychgbill", (String)"id,entrys.sourceentryid,billstatus,iscashconfirm", (QFilter[])filter.toArray(), (String)"createtime desc", (int)1);
            if (resultdate.size() > 0 && !(dynamicObject = (DynamicObject)resultdate.get(0)).getBoolean("iscashconfirm")) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(MESSAGEBOXCLOSED, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u7533\u8bf7\u660e\u7ec6\u5df2\u7ecf\u5728\u53d8\u66f4\u4e2d\uff0c\u662f\u5426\u8054\u67e5\u53d8\u66f4\u5355?", (String)"PayApplyRecChgPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                this.getPageCache().put(CACHE_RECHGPKVALUE, String.valueOf(dynamicObject.get("id")));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)MESSAGEBOXCLOSED, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setFormId("cas_paychgbill_payapply");
                parameter.setPkId((Object)this.getPageCache().get(CACHE_RECHGPKVALUE));
                this.getView().showForm((FormShowParameter)parameter);
            }
            this.getPageCache().remove(CACHE_RECHGPKVALUE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)MESSAGEBOXCLOSED)) {
            EntryGrid applyEntryGrid = (EntryGrid)this.getView().getControl("cas_payapplyentry");
            int[] selectRows = applyEntryGrid.getSelectRows();
            boolean checkChg = this.checkChg(selectRows);
            if (!checkChg) {
                return;
            }
            for (int index : selectRows) {
                DynamicObject applyEntry = this.getModel().getEntryRowEntity("cas_payapplyentry", index);
                if (applyEntry.getBigDecimal("e_paidamount").compareTo(BigDecimal.ZERO) != 0) continue;
                this.payInfoChg(this.setRecChg(this.getModel().getDataEntity(), selectRows));
            }
        }
        if (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"seachrecchg")) {
            int index = this.getModel().getEntryCurrentRowIndex("cas_payapplyentry");
            DynamicObject applyEntry = this.getModel().getEntryRowEntity("cas_payapplyentry", index);
            Object pkValue = applyEntry.getPkValue();
            QFilter filter = new QFilter("entrys.sourceentryid", "=", applyEntry.getPkValue());
            DynamicObjectCollection resultdate = QueryServiceHelper.query((String)"cas_paychgbill", (String)"id,entrys.sourceentryid", (QFilter[])filter.toArray());
            if (resultdate.size() == 1) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setFormId("cas_paychgbill_payapply");
                parameter.setPkId(((DynamicObject)resultdate.get(0)).get("id"));
                this.getView().showForm((FormShowParameter)parameter);
            }
            if (resultdate.size() > 1) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("cas_paychgbill");
                FormConfig formConfig = FormMetadataCache.getListFormConfig((String)"cas_paychgbill");
                String f7ListFormId = formConfig.getF7ListFormId();
                showParameter.setFormId(f7ListFormId);
                showParameter.setLookUp(false);
                showParameter.setShowApproved(false);
                showParameter.setShowTitle(false);
                showParameter.setMultiSelect(false);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                QFilter qFilter = new QFilter("entrys.sourceentryid", "in", pkValue);
                showParameter.setCustomParam(QFILTERSTR, (Object)qFilter.toSerializedString());
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void payInfoChg(JSONObject data) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cas_paychgbill_payapply");
        showParameter.setCustomParam(PAYAPPLYDATA, (Object)data.toJSONString());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_LOCKBILL));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private JSONObject setRecChg(DynamicObject dynamicObject, int[] indexs) {
        JSONObject entity = new JSONObject();
        entity.put(ORG, dynamicObject.get("billno"));
        entity.put(SOURCEID, this.getModel().getDataEntity().getPkValue());
        entity.put(SOURCEBILLNO, dynamicObject.get("billno"));
        entity.put(SOURCETYPE, (Object)dynamicObject.getDataEntityType().getName());
        entity.put(SOURCEACTION, (Object)SOURCEACTION);
        entity.put(SELECTROW, (Object)JSONArray.parseArray((String)JSON.toJSONString((Object)indexs)));
        return entity;
    }

    private boolean checkChg(int[] selectRows) {
        if (selectRows.length <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PayApplyRecChgPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Object> applyIds = new ArrayList<Object>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject applyEntry = this.getModel().getEntryRowEntity("cas_payapplyentry", index);
            applyIds.add(applyEntry.get("e_splitid"));
        }
        DynamicObjectCollection payInfoCollection = this.getModel().getEntryEntity("cas_payinfo");
        for (DynamicObject payInfo : payInfoCollection) {
            String entry_paystatus = payInfo.getString("entry_paystatus");
            Long applyid = payInfo.getLong("entry_applyid");
            if (applyIds.indexOf(applyid) < 0) continue;
            if (PayStatusEnum.PAYING.getValue().equals(entry_paystatus.trim())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7b14\u7533\u8bf7\u5df2\u7ecf\u5728\u4ed8\u6b3e\u4e2d\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u4ed8\u6b3e\u5355\u518d\u53d1\u8d77\u53d8\u66f4\u3002", (String)"PayApplyRecChgPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (PayStatusEnum.PAYMENTSUCCESS.getValue().equals(entry_paystatus.trim())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7b14\u7533\u8bf7\u5df2\u7ecf\u4ed8\u6b3e\uff0c\u65e0\u9700\u53d1\u8d77\u53d8\u66f4\u3002", (String)"PayApplyRecChgPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!PayStatusEnum.PAYSCHEFUND.getValue().equals(entry_paystatus.trim())) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7b14\u7533\u8bf7\u5df2\u7ecf\u6392\u6b3e\uff0c\u8bf7\u5148\u53d6\u6d88\u6392\u6b3e\u518d\u53d1\u8d77\u53d8\u66f4\u3002", (String)"PayApplyRecChgPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

