/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateTargetEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.ConvertPluginEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.ConvertRuleIdEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class Pay2RecConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(Pay2RecConvertPlugin.class);
    private Map<Object, DynamicObject> srcBills = new HashMap<Object, DynamicObject>(2);
    private Map<String, Set<Long>> needQueryIds = new HashMap<String, Set<Long>>(2);

    private Set<Long> getSrcIds(ConvertPluginEventArgs e) {
        ExtendedDataEntity[] billDataEntitys = this.getBillDataEntitys(e);
        if (billDataEntitys == null || billDataEntitys.length == 0) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(billDataEntitys.length);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = this.getSrcId((DynamicObject)srcData.get(0), e);
            if (id == null) continue;
            returns.add(Long.valueOf(id.toString()));
        }
        return returns;
    }

    private Object getSrcId(DynamicObject srcData, ConvertPluginEventArgs e) {
        if (e instanceof AfterCreateTargetEventArgs) {
            return ((DynamicProperty)((AfterCreateTargetEventArgs)e).getFldProperties().get("id")).getValue((Object)srcData);
        }
        if (e instanceof AfterCreateTargetEventArgs) {
            return ((DynamicProperty)((AfterFieldMappingEventArgs)e).getFldProperties().get("id")).getValue((Object)srcData);
        }
        return null;
    }

    private ExtendedDataEntity[] getBillDataEntitys(ConvertPluginEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        if (e instanceof AfterCreateTargetEventArgs) {
            return ((AfterCreateTargetEventArgs)e).getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        }
        if (e instanceof AfterCreateTargetEventArgs) {
            return ((AfterFieldMappingEventArgs)e).getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        }
        return null;
    }

    public void afterCreateTarget(AfterCreateTargetEventArgs e) {
        super.afterCreateTarget(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Set<Long> srcIds = this.getSrcIds((ConvertPluginEventArgs)e);
        if (srcIds == null || srcIds.size() == 0) {
            return;
        }
        this.srcBills = PaymentServiceHelper.queryDatas((String)"cas_paybill", (String)"org,payeetype,payee,payeeacctbank,payeebanknum,payeebank,payeracctbank,basecurrency", (String)"id", srcIds);
        this.needQueryIds = PaymentServiceHelper.getNeedQueryIds((DynamicObject[])((DynamicObject[])this.srcBills.values().stream().map(o -> o).toArray(DynamicObject[]::new)), null, (boolean)true);
        Map suppliers = PaymentServiceHelper.queryDatas((String)AsstActTypeEnum.SUPPLIER.getValue(), (String)"id,internal_company", (String)"id", this.needQueryIds.get("key_Supplier"));
        Map customers = PaymentServiceHelper.queryDatas((String)AsstActTypeEnum.CUSTOMER.getValue(), (String)"id,internal_company", (String)"id", this.needQueryIds.get("key_Customer"));
        PaymentServiceHelper.addIds(this.needQueryIds, suppliers.values().stream().filter(d -> !CasHelper.isEmpty((Object)d.getDynamicObject("internal_company"))).map(o -> o.getDynamicObject("internal_company").getLong("id")).collect(Collectors.toSet()), (String)"key_allpayee");
        PaymentServiceHelper.addIds(this.needQueryIds, customers.values().stream().filter(d -> !CasHelper.isEmpty((Object)d.getDynamicObject("internal_company"))).map(o -> o.getDynamicObject("internal_company").getLong("id")).collect(Collectors.toSet()), (String)"key_allpayee");
        Map orgs = null;
        Set<Long> allPayeeIds = this.needQueryIds.get("key_allpayee");
        if (CollectionUtils.isNotEmpty(allPayeeIds)) {
            orgs = BusinessDataServiceHelper.loadFromCache((Object[])allPayeeIds.toArray(), (String)"bos_org");
        }
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject internal_company;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject payeetypeDO = this.srcBills.get(id);
            Long payee = payeetypeDO.getLong("payee");
            Object pkValue = null;
            String payeeType = payeetypeDO.getString("payeetype");
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType)) {
                DynamicObject supplierDO = (DynamicObject)suppliers.get(payee);
                internal_company = supplierDO.getDynamicObject("internal_company");
                if (CasHelper.isEmpty((Object)internal_company)) {
                    return;
                }
                pkValue = internal_company.getPkValue();
            } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) {
                DynamicObject customerDO = (DynamicObject)customers.get(payee);
                internal_company = customerDO.getDynamicObject("internal_company");
                if (CasHelper.isEmpty((Object)internal_company)) {
                    return;
                }
                pkValue = internal_company.getPkValue();
            } else {
                pkValue = payee;
            }
            if (orgs == null || !targetBill.containsProperty("org") || !EmptyUtil.isEmpty((Object)targetBill.get("org"))) continue;
            DynamicObject org = (DynamicObject)orgs.get(pkValue);
            targetBill.set("org", (Object)org);
            logger.info("\u6536\u6b3e\u5355\u7ec4\u7ec7\u4e3a\uff1a{}", (Object)org);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map payeeacctbanks = PaymentServiceHelper.queryDatas((String)"bd_accountbanks", (String)"id,openorg,bank", (String)"id", this.needQueryIds.get("key_payeeAcctbank"));
        Map multiFilterbanks = PaymentServiceHelper.queryMultiFilterBanks((DynamicObject[])this.srcBills.values().toArray(new DynamicObject[0]), (Map)payeeacctbanks, null, (boolean)true);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String quotation;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject payeetypeDO = this.srcBills.get(id);
            DynamicObject payeeAccount = null;
            Long payeeacctbank = payeetypeDO.getLong("payeeacctbank");
            if (payeeacctbank != null && payeeacctbank != 0L) {
                payeeAccount = (DynamicObject)payeeacctbanks.get(payeeacctbank);
            }
            if (payeeAccount == null) {
                payeeAccount = (DynamicObject)multiFilterbanks.get(targetBill.getDynamicObject("org").getPkValue() + "!" + payeetypeDO.getString("payeebanknum"));
            }
            if (!ConvertRuleIdEnum.AUTO_RENOTE_PAY_REV.getRuleId().equals(this.getRule().getId()) && payeeAccount != null) {
                targetBill.set("accountbank", (Object)payeeAccount);
                this.setValueIfAbsent(targetBill, "payeebank", payeeAccount.getDynamicObject("bank"));
                this.setValueIfAbsent(targetBill, "openorg", payeeAccount.getDynamicObject("openorg"));
            }
            this.setSettleOrg(targetBill);
            DynamicObject org = targetBill.getDynamicObject("org");
            long orgId = (Long)org.getPkValue();
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
            if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) {
                targetBill.set("basecurrency", (Object)baseCurrency);
            }
            this.setValueIfAbsent(targetBill, "exratedate", DateUtils.getCurrentDate());
            if (CasHelper.isEmpty((Object)targetBill.getDynamicObject("exratetable"))) {
                Pay2RecConvertPlugin.setDefaultExratetable(targetBill, orgId);
            }
            DynamicObject currency = targetBill.getDynamicObject("currency");
            BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
            if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                exchangeRate = BigDecimal.ONE;
                quotation = "0";
                if (currency != null && baseCurrency != null) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurrencyId, (Long)destCurrencyId, (Long)exrateTable.getLong("id"), (Date)exrateDate);
                            if (exchangeRateMap.get("exchangeRate") != null) {
                                exchangeRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
                            }
                            if (exchangeRateMap.get("quoteType") != null && ((Boolean)exchangeRateMap.get("quoteType")).booleanValue()) {
                                quotation = "1";
                            }
                        }
                    }
                }
                targetBill.set("exchangerate", (Object)exchangeRate);
                targetBill.set("quotation", (Object)quotation);
            } else {
                this.setValueIfAbsent(targetBill, "quotation", "0");
            }
            quotation = targetBill.getString("quotation");
            DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
            int round = 10;
            if (basecurrency != null) {
                round = basecurrency.getInt("amtprecision");
            }
            DynamicObjectCollection entries = (DynamicObjectCollection)targetBill.get("entry");
            BigDecimal sumLocAmt = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal discountAmt;
                BigDecimal receivableAmt = entry.getBigDecimal("e_receivableamt");
                if (receivableAmt != null) {
                    BigDecimal recLocAmt = QuotationHelper.callToCurrency((BigDecimal)receivableAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                    entry.set("e_receivablelocamt", (Object)recLocAmt);
                }
                if ((discountAmt = entry.getBigDecimal("e_discountamt")) != null) {
                    BigDecimal disLocAmt = QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                    entry.set("e_discountlocamt", (Object)disLocAmt);
                }
                BigDecimal actAmt = entry.getBigDecimal("e_actamt");
                if (receivableAmt != null && discountAmt != null && CasHelper.isEmpty((Object)actAmt)) {
                    actAmt = currency != null ? receivableAmt.subtract(discountAmt).subtract(entry.getBigDecimal("e_fee")).setScale(currency.getInt("amtprecision"), 4) : receivableAmt.subtract(discountAmt).subtract(entry.getBigDecimal("e_fee"));
                    entry.set("e_actamt", (Object)actAmt);
                }
                if (CasHelper.isNotEmpty((Object)(actAmt = entry.getBigDecimal("e_actamt")))) {
                    BigDecimal actLocAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                    entry.set("e_localamt", (Object)actLocAmt);
                }
                BigDecimal actLocalAmt = entry.getBigDecimal("e_localamt");
                sumLocAmt = sumLocAmt.add(actLocalAmt);
            }
            targetBill.set("localamt", (Object)sumLocAmt);
        }
    }

    private void setSettleOrg(DynamicObject targetBill) {
        DynamicObject receivingtype = targetBill.getDynamicObject("receivingtype");
        Object org = null;
        if (receivingtype != null && receivingtype.getBoolean("ispartreceivable")) {
            DynamicObject recOrg = targetBill.getDynamicObject("org");
            if ((recOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting")).getBoolean("fisaccounting")) {
                org = recOrg;
            } else {
                DynamicObject recAccount = targetBill.getDynamicObject("accountbank");
                if (recAccount != null) {
                    org = recAccount.get("openorg");
                }
            }
        } else {
            org = targetBill.get("openorg");
        }
        for (DynamicObject entry : targetBill.getDynamicObjectCollection("entry")) {
            if (org == null || entry.getDynamicObject("e_settleorg") != null) continue;
            entry.set("e_settleorg", org);
        }
    }

    public void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty((Object)targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    private static void setDefaultExratetable(DynamicObject targetBill, Long orgId) {
        DynamicObject exchangeRateTable = null;
        try {
            exchangeRateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        targetBill.set("exratetable", (Object)exchangeRateTable);
    }
}

