/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payinfochg;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentPayeeInfo;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicListHelper;
import kd.fi.cas.info.SCAccountInfo;
import kd.fi.cas.util.EmptyUtil;

public class PayInfoChgPayApplyPlugin
extends BillEditPlugin {
    private static final String PAYEEACCOUNTBANK = "payeeaccountbank";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payeeBankNum = (TextEdit)this.getView().getControl("changerecacctbank");
        payeeBankNum.addButtonClickListener((ClickListener)this);
        this.ePayeeAccBank();
        this.eUserAccBank();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Objects.equals(operateKey, "save") || Objects.equals(operateKey, "submit")) {
            DynamicObjectCollection payApplyEntry = this.getModel().getEntryEntity("entrys");
            ArrayList<String> errorRows = new ArrayList<String>();
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                this.fillByPayeeType(errorRows, rowIndex);
            }
        }
    }

    private void fillByPayeeType(List<String> errorRows, int rowIndex) {
        if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
            DynamicObject internalOrg;
            Long recerid = (Long)this.getModel().getValue("recerid", rowIndex);
            String payeetype = (String)this.getModel().getValue("payeetype", rowIndex);
            DynamicObject ePayee = null;
            if (recerid != null && recerid != 0L && StringUtils.isNotBlank((CharSequence)payeetype) && (ePayee = BusinessDataServiceHelper.loadSingle((Object)recerid, (String)payeetype)) != null && (internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)ePayee)) != null) {
                this.checkPayeeAccBank(errorRows, rowIndex, internalOrg);
            }
        } else if (this.isCompany(rowIndex)) {
            Long recerid = (Long)this.getModel().getValue("recerid", rowIndex);
            String payeetype = (String)this.getModel().getValue("payeetype", rowIndex);
            DynamicObject ePayee = null;
            if (recerid != null && recerid != 0L && StringUtils.isNotBlank((CharSequence)payeetype) && (ePayee = BusinessDataServiceHelper.loadSingle((Object)recerid, (String)payeetype)) != null) {
                this.checkPayeeAccBank(errorRows, rowIndex, ePayee);
            }
        }
    }

    private void checkPayeeAccBank(List<String> errorRows, int rowIndex, DynamicObject internalOrg) {
        Object value = this.getModel().getValue("changerecacctbank");
        if (StringUtils.isBlank((Object)this.getModel().getValue("changerecacctbank"))) {
            return;
        }
        QFilter bankNumberFilter = new QFilter("bankaccountnumber", "=", this.getModel().getValue("changerecacctbank", rowIndex));
        QFilter useOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)((Long)internalOrg.getPkValue()));
        DynamicObject[] bankAccounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, bank.bebank", (QFilter[])new QFilter[]{useOrgFilter, bankNumberFilter});
        if (bankAccounts == null || bankAccounts.length == 0) {
            this.getModel().setValue("chgpayeeaccbank", null, rowIndex);
        } else {
            this.getModel().setValue("chgpayeeaccbank", bankAccounts[0].getPkValue(), rowIndex);
            String accountName = (String)this.getModel().getValue("chgaccountname", rowIndex);
            if (StringUtils.isEmpty((CharSequence)accountName)) {
                this.fillAccountName(rowIndex, null);
            }
            DynamicObject beBank = (DynamicObject)bankAccounts[0].get("bank.bebank");
            this.getModel().setValue("afterrecerbank", (Object)beBank, rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entrys");
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DynamicObject bank = dynamicObject.getDynamicObject("afterrecerbank");
                String bankName = dynamicObject.getString("afterrecerbankname");
                if (bank == null || !"".equals(bankName)) continue;
                this.getModel().setValue("afterrecerbankname", (Object)bank.getString("name"), i);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dataJsonStr = (String)this.getView().getFormShowParameter().getCustomParam("payApplyData");
        if (StringUtils.isNotEmpty((CharSequence)dataJsonStr)) {
            JSONObject data = JSONObject.parseObject((String)dataJsonStr);
            String sourceType = data.getString("sourceType");
            Long sourceId = data.getLong("sourceId");
            if (sourceType != null && sourceId != null) {
                DynamicObject bizBill = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)sourceType);
                BillModel model = (BillModel)this.getModel();
                model.setValue("billstatus", (Object)"A");
                model.setValue("sourcebillno", bizBill.get("billno"));
                model.setValue("chgtype", (Object)"recchg");
                model.setValue("sourcetype", (Object)sourceType);
                model.setValue("sourcebillid", (Object)sourceId);
                model.setValue("sourcecurrency", bizBill.get("payeecurrency"));
                DynamicObject orgObj = bizBill.getDynamicObject("payorg");
                model.setValue("applyuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
                model.setValue("alterationuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
                Long org = null;
                if (!CasHelper.isEmpty((Object)orgObj)) {
                    org = (Long)orgObj.getPkValue();
                }
                model.setValue("org", (Object)org);
                this.getModel().deleteEntryData("entrys");
                JSONArray selectRow = data.getJSONArray("selectRow");
                selectRow.forEach(item -> {
                    if (item instanceof Integer) {
                        Integer index = Integer.valueOf(item.toString());
                        int entrys = this.getModel().createNewEntryRow("entrys");
                        DynamicObjectCollection cas_payapplyentry = bizBill.getDynamicObjectCollection("cas_payapplyentry");
                        DynamicObject e_settlementtype = ((DynamicObject)cas_payapplyentry.get(index.intValue())).getDynamicObject("e_settlementtype");
                        model.setValue("settletype", e_settlementtype != null ? e_settlementtype.getPkValue() : null, entrys);
                        model.setValue("businesstype", (Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_businesstype"), entrys);
                        model.setValue("payeeamount", (Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getBigDecimal("e_payeeamount"), entrys);
                        model.setValue("payeetype", (Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_payeetype"), entrys);
                        model.setValue("recername", (Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_payeename"), entrys);
                        String recacctbank = ((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_payeeaccbanknum");
                        if (StringUtils.isNotBlank((CharSequence)((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_chgpayeeaccbanknum"))) {
                            recacctbank = ((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_chgpayeeaccbanknum");
                        }
                        model.setValue("recacctbank", (Object)recacctbank, entrys);
                        model.setValue("institutioncode", (Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_institutioncode"), entrys);
                        model.setValue("institutionname", (Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getString("e_institutionname"), entrys);
                        DynamicObject payeebank = ((DynamicObject)cas_payapplyentry.get(index.intValue())).getDynamicObject("e_payeebank");
                        String payeebankname = "";
                        if (!EmptyUtil.isEmpty((DynamicObject)payeebank)) {
                            payeebankname = ((DynamicObject)cas_payapplyentry.get(index.intValue())).getDynamicObject("e_payeebank").getString("name");
                        }
                        if (EmptyUtil.isNotBlank((Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getDynamicObject("e_chgpayeebank"))) {
                            payeebankname = ((DynamicObject)cas_payapplyentry.get(index.intValue())).getDynamicObject("e_chgpayeebank").getString("name");
                        }
                        model.setValue("payeebankname", (Object)payeebankname, entrys);
                        model.setValue("recerid", (Object)((DynamicObject)cas_payapplyentry.get(index.intValue())).getLong("e_payeeid"), entrys);
                        model.setValue("sourceentryid", ((DynamicObject)cas_payapplyentry.get(index.intValue())).getPkValue(), entrys);
                    }
                });
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entrys");
        if (newValue == oldValue) {
            return;
        }
        if (fieldKey.equals("chgpayeeaccbank") && newValue != null) {
            this.setValue("chgpayeeaccbankid", null);
            this.setValue("changerecacctbank", null);
            this.setValue("afterrecerbank", null);
            this.setValue("chguseraccbank", null);
            PaymentPayeeInfo paymentPayeeInfo = PaymentPayeeInfo.createByAccountBank((DynamicObject)((DynamicObject)newValue));
            this.setValue("changerecacctbank", paymentPayeeInfo.getAccountNumber());
            this.setValue("chgpayeeaccbankid", ((DynamicObject)newValue).getPkValue());
            this.setValue("afterrecerbank", paymentPayeeInfo.getBebankId());
        }
        if (fieldKey.equals("chguseraccbank") && newValue != null) {
            this.setValue("chgpayeeaccbank", null);
            this.setValue("chgpayeeaccbankid", null);
            this.setValue("changerecacctbank", null);
            this.setValue("afterrecerbank", null);
            DynamicObject erPayee = (DynamicObject)newValue;
            this.setValue("changerecacctbank", erPayee.getString("payeraccount"));
            this.setValue("chgpayeeaccbankid", erPayee.getPkValue());
            this.setValue("afterrecerbank", erPayee.getDynamicObject("payerbank"));
            this.fillAccountName(this.getModel().getEntryCurrentRowIndex("entrys"), null);
        }
        if (fieldKey.equals("changerecacctbank") && newValue != null) {
            DynamicObject payeeAccBank = (DynamicObject)this.getValue("chgpayeeaccbank", rowIndex);
            if (payeeAccBank != null && !Objects.equals(payeeAccBank.get("number"), newValue)) {
                this.setValue("chgpayeeaccbank", null, rowIndex);
                this.setValue("afterrecerbank", null, rowIndex);
            }
            this.fillAccountName(rowIndex, null);
            if (StringUtils.isEmpty((CharSequence)((String)newValue))) {
                this.setValue("chguseraccbank", null, rowIndex);
                this.setValue("afterrecerbank", null, rowIndex);
                this.setValue("afterrecerbankname", null, rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey().toLowerCase();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"changerecacctbank")) {
            if (this.isUser()) {
                BasedataEdit erPayee = (BasedataEdit)this.getControl("chguseraccbank");
                erPayee.click();
            } else if (this.isSupplier() || this.isCustomer()) {
                this.showAccountBankInfoF7();
            } else if (this.isCompany()) {
                BasedataEdit payeeAcctBank = (BasedataEdit)this.getControl("chgpayeeaccbank");
                payeeAcctBank.click();
            }
        }
    }

    private void showAccountBankInfoF7() {
        Long recerid = (Long)this.getModel().getValue("recerid");
        String payeetype = (String)this.getModel().getValue("payeetype");
        DynamicObject ePayee = null;
        if (recerid != null && recerid != 0L && StringUtils.isNotBlank((CharSequence)payeetype)) {
            ePayee = BusinessDataServiceHelper.loadSingle((Object)recerid, (String)payeetype);
        }
        DynamicObject internalOrg = null;
        SCAccountInfo defaultBankInfo = null;
        if (ePayee != null) {
            internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), ePayee);
            defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)ePayee);
        }
        if (internalOrg != null) {
            BasedataEdit ePayeeAccBank = (BasedataEdit)this.getControl("chgpayeeaccbank");
            ePayeeAccBank.click();
        } else {
            if (defaultBankInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"PayApplyEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = null;
            lsp = this.isSupplier() ? DynamicListHelper.getSupplierBankInfoShowParameter((Object)ePayee.getPkValue()) : DynamicListHelper.getCustomerBankInfoShowParameter((Object)ePayee.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PAYEEACCOUNTBANK);
            lsp.setCloseCallBack(closeCallBack);
            lsp.getListFilterParameter().setFilter(this.getCurrencyFilter());
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void ePayeeAccBank() {
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl("chgpayeeaccbank");
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "freeze"});
            DynamicObject currency = (DynamicObject)this.getModel().getValue("sourcecurrency");
            showPara.getListFilterParameter().setFilter(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            Long recerid = (Long)this.getModel().getValue("recerid");
            String payeetype = (String)this.getModel().getValue("payeetype");
            DynamicObject payee = null;
            if (recerid != null && recerid != 0L && StringUtils.isNotBlank((CharSequence)payeetype)) {
                DynamicObject useOrg;
                payee = BusinessDataServiceHelper.loadSingle((Object)recerid, (String)payeetype);
                DynamicObject dynamicObject = useOrg = this.isCompany() ? payee : BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)payee);
                if (useOrg != null) {
                    QFilter useOrgFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)((Long)useOrg.getPkValue()));
                    qFilter.and(useOrgFilter);
                }
            }
            String filterIsElec = "0";
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", this.getModel().getEntryCurrentRowIndex("entrys"));
            DynamicObject settletype = entryRowEntity.getDynamicObject("settletype");
            String businessType = entryRowEntity.getString("businesstype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settletype);
            if (isDcep && (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType))) {
                filterIsElec = "1";
            }
            qFilter.and(new QFilter("iselecpayment", "=", (Object)filterIsElec));
            showPara.setCustomParam("isclearcorefilter", (Object)"true");
            showPara.getListFilterParameter().setFilter(qFilter);
            showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chgpayeeaccbank"));
        });
    }

    private void eUserAccBank() {
        BasedataEdit eUserAccBankF7 = (BasedataEdit)this.getControl("chguseraccbank");
        eUserAccBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Long recerid = (Long)this.getModel().getValue("recerid");
            String payeetype = (String)this.getModel().getValue("payeetype");
            DynamicObject ePayee = null;
            if (recerid != null && recerid != 0L && StringUtils.isNotBlank((CharSequence)payeetype)) {
                ePayee = BusinessDataServiceHelper.loadSingle((Object)recerid, (String)payeetype);
            }
            if (ePayee != null) {
                QFilter qFilter = new QFilter("payer", "=", ePayee.getPkValue());
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("sourcecurrency");
                if (currency != null) {
                    qFilter.and(new QFilter("currency.id", "is null", null).or(new QFilter("currency.id", "=", (Object)0).or(new QFilter("currency.id", "=", currency.getPkValue()))));
                }
                showPara.getListFilterParameter().setFilter(qFilter);
                List qFilters = showPara.getListFilterParameter().getQFilters();
                qFilters.removeIf(q -> q.toString().contains("t_er_Payee_U"));
                showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chguseraccbank"));
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (PAYEEACCOUNTBANK.equals(actionId)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 != null) {
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData2;
                Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                String asstActType = this.getString("payeetype");
                SCAccountInfo scAccountInfo = BaseDataHelper.loadBankInfo((String)asstActType, (Long)((Long)entryKey));
                this.bindAccountBankInfo(scAccountInfo);
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("entrys"), returnData2);
            }
        } else if ("chgpayeeaccbank".equals(actionId)) {
            Object returnData3 = closedCallBackEvent.getReturnData();
            if (returnData3 != null) {
                this.fillAccountName(this.getModel().getEntryCurrentRowIndex("entrys"), returnData3);
            }
        } else if ("chguseraccbank".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.fillAccountName(this.getModel().getEntryCurrentRowIndex("entrys"), returnData);
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.setValue("chguseraccbank", entryKey);
        }
    }

    private void fillAccountName(int rowIndex, Object returnData) {
        Long recerid = (Long)this.getModel().getValue("recerid");
        String payeetype = (String)this.getModel().getValue("payeetype");
        DynamicObject baseData = null;
        if (recerid != null && recerid != 0L && StringUtils.isNotBlank((CharSequence)payeetype)) {
            baseData = BusinessDataServiceHelper.loadSingle((Object)recerid, (String)payeetype);
        }
        if (this.isSupplier(rowIndex) || this.isCustomer(rowIndex)) {
            DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), baseData);
            if (internalOrg == null) {
                if (returnData != null) {
                    ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                    Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                    if (baseData != null) {
                        SCAccountInfo bankInfo = BaseDataHelper.loadBankInfo((String)baseData.getDataEntityType().getName(), (Long)((Long)entryKey));
                        this.setValue("chgaccountname", bankInfo.getAccountName(), rowIndex);
                    }
                } else {
                    this.setValue("chgaccountname", this.getValue("recer"), rowIndex);
                }
            } else {
                this.fillAccountNameByReturnData(rowIndex, returnData);
            }
        } else if (this.isCompany()) {
            this.fillAccountNameByReturnData(rowIndex, returnData);
        } else if (this.isUser()) {
            if (returnData != null) {
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryKey = rowInfo.getPrimaryKeyValues()[0];
                DynamicObject payeer = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"er_payeer");
                this.setValue("chgaccountname", payeer.get("payeraccountname"), rowIndex);
                this.setValue("changerecacctbank", payeer.get("payeraccount"), rowIndex);
                this.setValue("afterrecerbank", payeer.get("payerbank"), rowIndex);
            } else {
                DynamicObject userAccBank = (DynamicObject)this.getValue("chguseraccbank", rowIndex);
                if (userAccBank != null) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)userAccBank.getPkValue(), (String)"er_payeer");
                    this.setValue("chgaccountname", dynamicObject.get("payeraccountname"), rowIndex);
                } else {
                    this.setValue("chgaccountname", this.getValue("recer"), rowIndex);
                }
            }
        }
    }

    private void fillAccountNameByReturnData(int rowIndex, Object returnData) {
        if (returnData != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getPrimaryKeyValues()[0];
            this.fillAccountNameByBankAccount(entryKey, rowIndex);
            this.setValue("chgpayeeaccbank", entryKey, rowIndex);
        } else {
            DynamicObject payeeAccBank = (DynamicObject)this.getValue("chgpayeeaccbank", rowIndex);
            if (payeeAccBank != null) {
                this.fillAccountNameByBankAccount(payeeAccBank.getPkValue(), rowIndex);
            }
        }
    }

    private void fillAccountNameByBankAccount(Object entryKey, int rowIndex) {
        DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((Object)entryKey, (String)"bd_accountbanks");
        if (accountBank.getBoolean("issetbankinterface")) {
            this.setValue("chgaccountname", accountBank.get("acctname"), rowIndex);
        } else {
            this.setValue("chgaccountname", accountBank.get("openorg") == null ? null : accountBank.getDynamicObject("openorg").get("name"), rowIndex);
        }
    }

    private void bindAccountBankInfo(SCAccountInfo scAccountInfo) {
        if (scAccountInfo == null) {
            this.setValue("chgpayeeaccbank", null);
            this.setValue("chgpayeeaccbankid", null);
            this.setValue("changerecacctbank", null);
            this.setValue("afterrecerbank", null);
            return;
        }
        this.setValue("changerecacctbank", scAccountInfo.getAccount());
        this.setValue("afterrecerbank", scAccountInfo.getBeBank());
    }

    private boolean isUser() {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE);
    }

    private boolean isSupplier() {
        return this.isAimType(AsstActTypeEnum.SUPPLIER);
    }

    private boolean isSupplier(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.SUPPLIER, rowIndex);
    }

    private boolean isCustomer() {
        return this.isAimType(AsstActTypeEnum.CUSTOMER);
    }

    private boolean isCustomer(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.CUSTOMER, rowIndex);
    }

    private boolean isCompany() {
        return this.isAimType(AsstActTypeEnum.COMPANY);
    }

    private boolean isCompany(int rowIndex) {
        return this.isAimType(AsstActTypeEnum.COMPANY, rowIndex);
    }

    private boolean isAimType(AsstActTypeEnum asstActType) {
        Object payeeType = this.getValue("payeetype");
        return asstActType.getValue().equals(payeeType);
    }

    private boolean isAimType(AsstActTypeEnum asstActType, int rowIndex) {
        Object payeeType = this.getValue("payeetype", rowIndex);
        return asstActType.getValue().equals(payeeType);
    }

    private QFilter getCurrencyFilter() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("sourcecurrency");
        return new QFilter("entry_bank.currency.id", "in", currency.getPkValue());
    }
}

