/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeGetSourceDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasDetailInfoExtFieldsHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.util.EmptyUtil;

public class UnClaim2RecBillConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeGetSourceData(BeforeGetSourceDataEventArgs e) {
        super.beforeGetSourceData(e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ArrayList<Object> claimIdList = new ArrayList<Object>(billDataEntitys.length);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            claimIdList.add(pkValue);
        }
        DynamicObject[] claimDts = BusinessDataServiceHelper.load((Object[])claimIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getSrcMainType().getName()));
        DynamicObject[] details = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)("id,billno,bizdate,currency,bankcheckflag,debitamount,creditamount" + CasDetailInfoExtFieldsHelper.getSrcDetailInfoSelectFields((String)targetEntityNumber)), (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", Arrays.stream(claimDts).flatMap(claim -> claim.getDynamicObjectCollection("bankcheckentity").stream().map(entry -> entry.getString("ebankcheckflag"))).collect(Collectors.toSet()))});
        Map detailInfoFieldsMap = CasDetailInfoExtFieldsHelper.getDetailInfoFields((String)targetEntityNumber);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String strFlag;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)this.getSrcMainType());
            RecClaimHelper.setRefundDetailId((DynamicObject)sourceBill, (DynamicObject)targetBill);
            Object settleType = targetBill.get("settletype");
            if (CasHelper.isEmpty((Object)settleType)) {
                Object settleTypeDy = null;
                if (StringUtils.equals((CharSequence)sourceBill.getString("businesstype"), (CharSequence)"recticket")) {
                    DynamicObject draftBillType = sourceBill.getDynamicObject("draftbilltype");
                    DynamicObjectCollection settTypeColl = draftBillType.getDynamicObjectCollection("settlementtypebd");
                    if (!CollectionUtils.isEmpty((Collection)settTypeColl)) {
                        List sortedList = settTypeColl.stream().map(i -> i.getDynamicObject("fbasedataid")).sorted((a, b) -> a.getString("number").compareTo(b.getString("number"))).collect(Collectors.toList());
                        settleTypeDy = (DynamicObject)sortedList.get(0);
                    } else {
                        String settlementtype = sourceBill.getString("settlementtype");
                        QFilter[] filters = new QFilter[]{new QFilter("settlementtype", "=", (Object)settlementtype), new QFilter("enable", "=", (Object)"1")};
                        Object[] settleDy = BusinessDataServiceHelper.load((String)"bd_settlementtype", (String)"id", (QFilter[])filters);
                        if (EmptyUtil.isNoEmpty((Object[])settleDy)) {
                            settleTypeDy = settleDy[0];
                        }
                    }
                    List noticeList = RecClaimHelper.getAllChildNoticeBill((Object)sourceBill.getPkValue());
                    Object[] sourceDys = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,draftbillno,currency,amount,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)noticeList.stream().map(dy -> dy.getLong("sourceid")).toArray())});
                    if (EmptyUtil.isNoEmpty((Object[])sourceDys)) {
                        targetBill.set("settletnumber", (Object)Stream.of(sourceDys).map(dy -> dy.getString("draftbillno")).collect(Collectors.joining(",")));
                        DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)targetBill, (String)"settletnumber");
                        this.fillDraftBillEntry(targetBill, Arrays.asList(sourceDys));
                    }
                }
                if (EmptyUtil.isEmpty(settleTypeDy)) {
                    settleTypeDy = BaseDataHelper.getDefaultSettleType();
                }
                targetBill.set("settletype", settleTypeDy);
            }
            if (sourceBill == null) continue;
            DynamicObjectCollection bankCheckEntity = sourceBill.getDynamicObjectCollection("bankcheckentity");
            StringBuilder str = new StringBuilder();
            if (bankCheckEntity != null && !bankCheckEntity.isEmpty() && details != null && details.length > 0) {
                DynamicObjectCollection banFlagEntry = targetBill.getDynamicObjectCollection("bankcheckentity");
                Set bankCheckFlagSet = bankCheckEntity.stream().map(entity -> entity.getString("ebankcheckflag")).collect(Collectors.toSet());
                for (DynamicObject entry : bankCheckEntity) {
                    String ebankcheckflag = entry.getString("ebankcheckflag");
                    Set detailSet = Arrays.stream(details).filter(detail -> ebankcheckflag.equals(detail.getString("bankcheckflag"))).collect(Collectors.toSet());
                    if (EmptyUtil.isNoEmpty((String)ebankcheckflag) && !bankCheckFlagSet.contains(ebankcheckflag)) {
                        DynamicObject dynamicObject = banFlagEntry.addNew();
                        dynamicObject.set("ebankcheckflag", (Object)ebankcheckflag);
                        if (!detailSet.isEmpty()) {
                            CasDetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)((DynamicObject)detailSet.iterator().next()), (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                        }
                    } else if (bankCheckFlagSet.contains(ebankcheckflag)) {
                        List objectList = bankCheckEntity.stream().filter(entity -> ebankcheckflag.equals(entity.getString("ebankcheckflag"))).collect(Collectors.toList());
                        if (!detailSet.isEmpty() && !objectList.isEmpty()) {
                            CasDetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)((DynamicObject)detailSet.iterator().next()), (DynamicObject)((DynamicObject)objectList.get(0)), (Map)detailInfoFieldsMap);
                        }
                    }
                    str.append(ebankcheckflag).append(',');
                }
            }
            if (EmptyUtil.isNotEmpty((String)(strFlag = str.toString())) && strFlag.length() >= 1) {
                strFlag = strFlag.substring(0, strFlag.length() - 1);
            }
            targetBill.set("bankcheckflag_tag", (Object)strFlag);
            targetBill.set("bankcheckflag", (Object)strFlag);
        }
    }

    private void fillDraftBillEntry(DynamicObject targetBill, List<DynamicObject> sourceCdmDysList) {
        DynamicObjectCollection draftBills = targetBill.getDynamicObjectCollection("draftbill");
        DynamicObjectCollection draftEntryInfo = targetBill.getDynamicObjectCollection("cas_draftinfo");
        Map draftBaseData = BusinessDataServiceHelper.loadFromCache((Object[])sourceCdmDysList.stream().map(DataEntityBase::getPkValue).toArray(), (String)"cdm_payandrecdraft_f7");
        draftBills.clear();
        draftEntryInfo.clear();
        for (DynamicObject draftBill : sourceCdmDysList) {
            DynamicObject newDraftBill = new DynamicObject(draftBills.getDynamicObjectType());
            newDraftBill.set("fbasedataid", draftBaseData.get(draftBill.getPkValue()));
            draftBills.add((Object)newDraftBill);
            DynamicObject newDraftEntry = new DynamicObject(draftEntryInfo.getDynamicObjectType());
            newDraftEntry.set("transamount", (Object)draftBill.getBigDecimal("amount"));
            newDraftEntry.set("recbillcurrency", (Object)draftBill.getDynamicObject("currency"));
            newDraftEntry.set("draftbillinfo", draftBaseData.get(draftBill.getPkValue()));
            draftEntryInfo.add((Object)newDraftEntry);
        }
        targetBill.set("draftbill", (Object)draftBills);
        targetBill.set("cas_draftinfo", (Object)draftEntryInfo);
    }
}

