/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.builder.ListRowStyleBuilder;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.business.helper.ManualMatchHelper;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.formplugin.smartmatch.ManualMatchPlugin;
import kd.fi.cas.param.AutoMatchInfoParam;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DifferMatchPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String transDetailsStr = (String)customParams.get("transdetails");
        String bizBillStr = (String)customParams.get("bizBills");
        if (EmptyUtil.isEmpty((String)transDetailsStr) || EmptyUtil.isEmpty((String)bizBillStr)) {
            return;
        }
        DynamicObjectCollection transDetails = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)transDetailsStr);
        Map allSelectBills = (Map)SerializationUtils.deSerializeFromBase64((String)bizBillStr);
        ArrayList allBizBills = new ArrayList(10);
        for (DynamicObjectCollection bizBillList : allSelectBills.values()) {
            allBizBills.addAll(bizBillList);
        }
        IDataModel model = this.getModel();
        model.appendEntryRow("entryentity", 0, transDetails.size() + 1);
        int rowIndex = 0;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (DynamicObject transDetail : transDetails) {
            model.setValue("billno", (Object)transDetail.getString("billno"), rowIndex);
            model.setValue("currency", (Object)transDetail.getLong("currency"), rowIndex);
            model.setValue("creditamount", (Object)transDetail.getBigDecimal("creditamount"), rowIndex);
            model.setValue("debitamount", (Object)transDetail.getBigDecimal("debitamount"), rowIndex);
            ++rowIndex;
        }
        BigDecimal creditAmtSum = transDetails.stream().map(v -> v.getBigDecimal("creditamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal debitAmtSum = transDetails.stream().map(v -> v.getBigDecimal("debitamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        model.setValue("billno", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DifferMatchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex);
        model.setValue("creditamount", (Object)creditAmtSum, rowIndex);
        model.setValue("debitamount", (Object)debitAmtSum, rowIndex);
        model.setValue("sumrow", (Object)true, rowIndex);
        this.getPageCache().put("totalDetailIndex", String.valueOf(rowIndex));
        int[] rowArr = IntStream.rangeClosed(0, transDetails.size()).toArray();
        this.setSumRowBackColor(rowIndex, "entryentity");
        entryGrid.setRowLock(true, rowArr);
        model.appendEntryRow("bizbillentry", 0, allBizBills.size() + 1);
        int bizRowIndex = 0;
        for (Map.Entry bizEntry : allSelectBills.entrySet()) {
            String bizBillKey = (String)bizEntry.getKey();
            Pair<List<String>, String> pair = ManualMatchPlugin.matchFieldMap.get(bizBillKey);
            DynamicObjectCollection bizBills = (DynamicObjectCollection)bizEntry.getValue();
            String unMatchAmtField = (String)((List)pair.getLeft()).get(0);
            Map unMatchAmtRec = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillKey, (boolean)true, (String)unMatchAmtField, (boolean)false);
            Map unMatchAmtPay = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillKey, (boolean)false, (String)unMatchAmtField, (boolean)false);
            for (DynamicObject bizBill : bizBills) {
                String bizBillType = bizBillKey.substring(5);
                model.setValue("bizbilltype", (Object)bizBillKey.substring(5), bizRowIndex);
                model.setValue("bizbillid", bizBill.get("id"), bizRowIndex);
                if ("list_cas_agentpaybill".equals(bizBillKey) || "list_fca_transupbill".equals(bizBillKey) || "list_fca_transdownbill".equals(bizBillKey)) {
                    String entryIdField = "list_cas_agentpaybill".equals(bizBillKey) ? "entry.id" : "entrys.id";
                    model.setValue("bizbillentryid", bizBill.get(entryIdField), bizRowIndex);
                }
                this.setBizCurrency(model, bizBill, bizBillKey, bizRowIndex);
                model.setValue("bizbillno", (Object)bizBill.getString("billno"), bizRowIndex);
                model.setValue("unmatchrecamount", unMatchAmtRec.get(bizBill.getString("id")), bizRowIndex);
                model.setValue("unmatchpayamount", unMatchAmtPay.get(bizBill.getString("id")), bizRowIndex);
                this.getView().setEnable(Boolean.valueOf(false), bizRowIndex, new String[]{"bizbillno", "unmatchrecamount", "unmatchpayamount"});
                ++bizRowIndex;
            }
        }
        model.setValue("bizbillno", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DifferMatchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), bizRowIndex);
        model.setValue("bizsumrow", (Object)true, bizRowIndex);
        this.setSumRowBackColor(bizRowIndex, "bizbillentry");
        EntryGrid bizEntryGrid = (EntryGrid)this.getControl("bizbillentry");
        bizEntryGrid.setRowLock(true, new int[]{bizRowIndex});
        this.getPageCache().put("totalBizIndex", String.valueOf(bizRowIndex));
    }

    private void setBizCurrency(IDataModel model, DynamicObject bizBill, String bizBillKey, int bizRowIndex) {
        if (Arrays.asList("list_cas_recbill", "list_fca_transupbill", "list_fca_transdownbill", "list_ifm_transhandlebill").contains(bizBillKey)) {
            model.setValue("bizcreditcurrency", (Object)bizBill.getLong("currency"), bizRowIndex);
            model.setValue("bizdebitcurrency", (Object)bizBill.getLong("currency"), bizRowIndex);
        } else if (Arrays.asList("list_cas_paybill", "list_cas_agentpaybill").contains(bizBillKey)) {
            model.setValue("bizcreditcurrency", (Object)bizBill.getLong("dpcurrency"), bizRowIndex);
            model.setValue("bizdebitcurrency", (Object)bizBill.getLong("dpcurrency"), bizRowIndex);
        } else {
            model.setValue("bizcreditcurrency", (Object)bizBill.getLong("buyingcurrency"), bizRowIndex);
            model.setValue("bizdebitcurrency", (Object)bizBill.getLong("sellingcurrency"), bizRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "matchcreditamount": {
                this.calcMatchCreditAmtSum("matchcreditamount");
                break;
            }
            case "matchdebitamount": {
                this.calcMatchCreditAmtSum("matchdebitamount");
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            String totalDetailIndex = this.getPageCache().get("totalDetailIndex");
            String totalBizIndex = this.getPageCache().get("totalBizIndex");
            BigDecimal creditAmtSum = (BigDecimal)this.getModel().getValue("creditamount", Integer.parseInt(totalDetailIndex));
            BigDecimal debitAmtSum = (BigDecimal)this.getModel().getValue("debitamount", Integer.parseInt(totalDetailIndex));
            BigDecimal matchCreditAmtSum = (BigDecimal)this.getModel().getValue("matchcreditamount", Integer.parseInt(totalBizIndex));
            BigDecimal matchDebitAmtSum = (BigDecimal)this.getModel().getValue("matchdebitamount", Integer.parseInt(totalBizIndex));
            if (!creditAmtSum.subtract(debitAmtSum).equals(matchCreditAmtSum.subtract(matchDebitAmtSum))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u4ea4\u6613\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1-\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1=\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u5408\u8ba1-\u672a\u5339\u914d\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u3002", (String)"DifferMatchPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bizbillentry");
            List entrys = entryEntity.stream().filter(o -> !o.getBoolean("bizsumrow")).collect(Collectors.toList());
            for (DynamicObject bizEntry : entrys) {
                BigDecimal matchCreditAmount = bizEntry.getBigDecimal("matchcreditamount");
                BigDecimal matchDebitAmount = bizEntry.getBigDecimal("matchdebitamount");
                if (EmptyUtil.isNoEmpty((BigDecimal)matchCreditAmount) && EmptyUtil.isNoEmpty((BigDecimal)matchDebitAmount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u540c\u4e00\u884c\u4e2d\u672c\u6b21\u53c2\u4e0e\u5339\u914d\u6536\u6b3e\u91d1\u989d\u4e0e\u672c\u6b21\u53c2\u4e0e\u5339\u914d\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u540c\u65f6\u6709\u503c\u3002", (String)"DifferMatchPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                BigDecimal unMatchRecAmount = bizEntry.getBigDecimal("unmatchrecamount");
                if (EmptyUtil.isNoEmpty((BigDecimal)matchCreditAmount) && matchCreditAmount.compareTo(unMatchRecAmount) != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u672c\u6b21\u53c2\u4e0e\u5339\u914d\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u3002", (String)"DifferMatchPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                BigDecimal unMatchPayAmount = bizEntry.getBigDecimal("unmatchpayamount");
                if (!EmptyUtil.isNoEmpty((BigDecimal)matchDebitAmount) || matchDebitAmount.compareTo(unMatchPayAmount) == 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u672c\u6b21\u53c2\u4e0e\u5339\u914d\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u672a\u5339\u914d\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"DifferMatchPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        ArrayList bizBIllKeyList = new ArrayList(10);
        if ("btnok".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String transDetailsStr = (String)customParams.get("transdetails");
            String bizBillStr = (String)customParams.get("bizBills");
            if (EmptyUtil.isEmpty((String)transDetailsStr) || EmptyUtil.isEmpty((String)bizBillStr)) {
                return;
            }
            boolean autoConfirm = (Boolean)customParams.get("autoConfirm");
            DynamicObjectCollection transDetails = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)transDetailsStr);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bizbillentry");
            List entrys = entryEntity.stream().filter(o -> !o.getBoolean("bizsumrow")).collect(Collectors.toList());
            Map allSelectBills = (Map)SerializationUtils.deSerializeFromBase64((String)bizBillStr);
            ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(transDetails.size() * allSelectBills.size());
            bizBIllKeyList.addAll(allSelectBills.keySet());
            String thisOpnumber = DB.genGlobalLongId() + "";
            HashSet autoRecPayBizBillIdSet = new HashSet(16);
            for (DynamicObject transDetail : transDetails) {
                String differMatchEntityType;
                String string = differMatchEntityType = EmptyUtil.isNoEmpty((BigDecimal)transDetail.getBigDecimal("creditamount")) ? "bei_intelrec" : "bei_intelpay";
                if (autoConfirm) {
                    autoRecPayBizBillIdSet.addAll(entrys.stream().map(v -> v.get("bizbillid")).collect(Collectors.toSet()));
                }
                for (DynamicObject bizEntry : entrys) {
                    BigDecimal amount = EmptyUtil.isNoEmpty((BigDecimal)bizEntry.getBigDecimal("matchcreditamount")) ? bizEntry.getBigDecimal("matchcreditamount") : bizEntry.getBigDecimal("matchdebitamount");
                    String tDataEntityType = EmptyUtil.isNoEmpty((BigDecimal)bizEntry.getBigDecimal("matchcreditamount")) ? "bei_intelrec" : "bei_intelpay";
                    String traceType = "";
                    String bizBillType = (String)bizEntry.get("bizbilltype");
                    if ("cas_exchangebill".equals(bizBillType)) {
                        traceType = EmptyUtil.isNoEmpty((BigDecimal)bizEntry.getBigDecimal("matchcreditamount")) ? "buy" : "sell";
                    }
                    AutoMatchInfoParam autoMatchInfoParam = new AutoMatchInfoParam(tDataEntityType, transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), (String)bizEntry.get("bizbilltype"), (String)bizEntry.get("bizbillno"), Long.valueOf(bizEntry.getLong("bizbillid")), Long.valueOf(bizEntry.getLong("bizbillentryid")), Long.valueOf(transDetail.getLong("currency")), traceType, amount, transDetail.getString("bankcheckflag"), transDetail.getDate("bizdate"), thisOpnumber, "");
                    autoMatchInfoParam.setDifferMatchSourceEntity(differMatchEntityType);
                    tAutoMatchInfoList.add(autoMatchInfoParam);
                }
            }
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, ReceredWayEnum.DIFFERMATCH.getValue(), null, true, autoRecPayBizBillIdSet});
            CasFlowConfirmLogHelper.saveDifferMatchLog(tAutoMatchInfoList);
        }
        this.getView().returnDataToParent(bizBIllKeyList);
        this.getView().close();
    }

    private void calcMatchCreditAmtSum(String amtProp) {
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bizbillentry");
        BigDecimal totalAmt = entryEntity.stream().filter(o -> !o.getBoolean("bizsumrow")).map(v -> v.getBigDecimal(amtProp)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        String totalBizIndex = this.getPageCache().get("totalBizIndex");
        this.getModel().setValue(amtProp, (Object)totalAmt, Integer.parseInt(totalBizIndex));
        this.getModel().endInit();
        this.getView().updateView(amtProp, Integer.parseInt(totalBizIndex));
    }

    private void setSumRowBackColor(int rowIndex, String entryName) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ListRowStyleBuilder rowStyleBuilder = ClientActions.createRowStyleBuilder();
        rowStyleBuilder.setRows(new int[]{rowIndex});
        rowStyleBuilder.setForeColor("#45cdff");
        rowStyleBuilder.setBackColor("#fff4d9");
        rowStyleBuilder.buildStyle();
        rowStyleBuilder.build();
        rowStyleBuilder.invokeControlMethod(proxy, entryName);
    }
}

