/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.formplugin.smartmatch.ManualMatchPlugin;
import kd.fi.cas.param.AutoMatchInfoParam;
import kd.fi.cas.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PartAmtAllotPlugin
extends AbstractListPlugin
implements ItemClickListener {
    public void afterCreateNewData(EventObject e) {
        List<Object> bizBillList;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean recFlag = (Boolean)customParams.get("transDetailType");
        List bizBillIds = ((JSONArray)customParams.get("bizBillId")).toJavaList(String.class);
        String bizBillKey = (String)customParams.get("bizBillKey");
        String detailAmtField = recFlag != false ? "creditamount" : "debitamount";
        DynamicObjectCollection transDetails = this.getTransDetailColl(recFlag);
        String bizEntity = bizBillKey.substring(5);
        Pair<List<String>, String> pair = ManualMatchPlugin.matchFieldMap.get(bizBillKey);
        String queryField = (String)pair.getRight();
        ArrayList<Long> idList = new ArrayList<Long>(bizBillIds.size());
        ArrayList<Long> entryIdList = new ArrayList<Long>(bizBillIds.size());
        Boolean haveEntryId = ((String)bizBillIds.get(0)).contains(",");
        this.getPageCache().put("haveEntryIdKey", haveEntryId.toString());
        for (String bizBillId : bizBillIds) {
            if (haveEntryId.booleanValue()) {
                String[] idStr = bizBillId.split(",");
                idList.add(Long.valueOf(idStr[0]));
                entryIdList.add(Long.valueOf(idStr[1]));
                continue;
            }
            idList.add(Long.valueOf(bizBillId));
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        String entryName = "";
        boolean entrySelected = false;
        if ("list_cas_agentpaybill".equals(bizBillKey) && entryIdList.size() > 0) {
            entryName = "entry.";
            idFilter.and(entryName + "id", "in", entryIdList);
            entrySelected = true;
        } else if ("list_fca_transupbill".equals(bizBillKey) || "list_fca_transdownbill".equals(bizBillKey)) {
            entryName = "entrys.";
            idFilter.and(entryName + "id", "in", entryIdList);
        }
        String bizBillAmtField = ManualMatchPlugin.getRecFlowBizAmtField(bizBillKey, (String)((List)pair.getLeft()).get(0), recFlag, haveEntryId);
        DynamicObjectCollection bizBillColl = QueryServiceHelper.query((String)bizEntity, (String)queryField, (QFilter[])new QFilter[]{idFilter}, (String)(bizBillAmtField + " asc"));
        if ("list_cas_agentpaybill".equals(bizBillKey) && !entrySelected) {
            Map<Long, List<DynamicObject>> idAgentBillMap = bizBillColl.stream().collect(Collectors.groupingBy(b -> b.getLong("id")));
            bizBillList = idAgentBillMap.values().stream().map(l -> (DynamicObject)l.get(0)).collect(Collectors.toList());
        } else {
            bizBillList = new ArrayList(bizBillColl);
        }
        String billAmtField = recFlag != false ? "unmatchamtrec" : "unmatchamtpay";
        String currencyField = ManualMatchPlugin.billListFieldMap.get(bizBillKey).get(2);
        if ("list_cas_exchangebill".equals(bizBillKey)) {
            currencyField = recFlag != false ? "buyingcurrency" : "sellingcurrency";
        }
        IDataModel model = this.getModel();
        int detailSize = transDetails.size();
        int bizBillSize = bizBillList.size();
        model.appendEntryRow("entryentity", 0, detailSize * bizBillSize);
        int rowIndex = 0;
        ArrayList<BigDecimal> detailAmtList = new ArrayList<BigDecimal>(detailSize);
        boolean bizBillAdd = true;
        ArrayList<BigDecimal> bizBillAmtList = new ArrayList<BigDecimal>(bizBillSize);
        Object detailCurrency = null;
        Object bizbillCurrency = null;
        for (int i = 0; i < detailSize; ++i) {
            DynamicObject detail = (DynamicObject)transDetails.get(i);
            model.setValue("detailseq", (Object)String.valueOf(i + 1), rowIndex);
            model.setValue("detailno", (Object)detail.getString("billno"), rowIndex);
            detailCurrency = detail.get("currency");
            model.setValue("detailcurrency", detailCurrency, rowIndex);
            BigDecimal detailAmt = detail.getBigDecimal(detailAmtField);
            model.setValue(detailAmtField, (Object)detailAmt, rowIndex);
            detailAmtList.add(detailAmt);
            for (int j = 0; j < bizBillSize; ++j) {
                DynamicObject bizBill = (DynamicObject)bizBillList.get(j);
                model.setValue("detailid", (Object)detail.getLong("id"), rowIndex);
                model.setValue("billid", (Object)bizBill.getLong("id"), rowIndex);
                model.setValue("billno", (Object)bizBill.getString("billno"), rowIndex);
                Integer billSeq = StringUtils.isNotEmpty((String)entryName) ? (Integer)bizBill.get(entryName + "seq") : -2;
                model.setValue("billseq", (Object)billSeq, rowIndex);
                bizbillCurrency = bizBill.get(currencyField);
                model.setValue("bizbillcurrency", bizbillCurrency, rowIndex);
                Long billEntryId = StringUtils.isNotEmpty((String)entryName) ? Long.valueOf(bizBill.getLong(entryName + "id")) : null;
                model.setValue("billentryid", billEntryId, rowIndex);
                BigDecimal unMatchAmt = bizBill.getBigDecimal(bizBillAmtField);
                model.setValue(billAmtField, (Object)unMatchAmt, rowIndex);
                if (bizBillAdd) {
                    bizBillAmtList.add(unMatchAmt);
                }
                ++rowIndex;
            }
            bizBillAdd = false;
        }
        BigDecimal detailAmtSum = detailAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal bizBillAmtSum = bizBillAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        model.setValue("detailseq", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"PartAmtAllotPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex);
        model.setValue(detailAmtField, (Object)detailAmtSum, rowIndex);
        model.setValue("detailcurrency", detailCurrency, rowIndex);
        model.setValue(billAmtField, (Object)bizBillAmtSum, rowIndex);
        model.setValue("bizbillcurrency", bizbillCurrency, rowIndex);
        model.setValue("billseq", (Object)(StringUtils.isNotEmpty((String)entryName) ? 0 : -1), rowIndex);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.setRowLock(true, new int[]{rowIndex});
        this.getPageCache().put("detailAmtList", JSON.toJSONString(detailAmtList));
        this.getPageCache().put("bizBillAmtList", JSON.toJSONString(bizBillAmtList));
    }

    private DynamicObjectCollection getTransDetailColl(Boolean recFlag) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List transDetailIds = ((JSONArray)customParams.get("transDetailId")).toJavaList(Long.class);
        String detailAmtField = recFlag != false ? "creditamount" : "debitamount";
        return QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,billno,bizdate,currency,bankcheckflag,creditamount,debitamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)transDetailIds)}, (String)(detailAmtField + " asc"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            List<BigDecimal> detailAmtList = this.getJsonToJava("detailAmtList", BigDecimal.class);
            int detailSize = detailAmtList.size();
            List<BigDecimal> bizBillAmtList = this.getJsonToJava("bizBillAmtList", BigDecimal.class);
            int bizBillSize = bizBillAmtList.size();
            int recAmtSize = detailSize * bizBillSize;
            List<BigDecimal> receiveAmtList = this.getJsonToJava("receiveAmtList", BigDecimal.class);
            if (receiveAmtList == null || receiveAmtList.size() != recAmtSize) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6240\u6709\u884c\u7684\u672c\u6b21\u63a5\u6536\u91d1\u989d\u3002", (String)"PartAmtAllotPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            TreeSet<String> errorMsgSet = new TreeSet<String>(Collections.reverseOrder());
            this.checkRecAmt(true, detailAmtList, bizBillAmtList, receiveAmtList, errorMsgSet);
            this.checkRecAmt(false, detailAmtList, bizBillAmtList, receiveAmtList, errorMsgSet);
            if (!errorMsgSet.isEmpty()) {
                String errorMsg = String.join((CharSequence)"\r\n", errorMsgSet);
                this.getView().showTipNotification(errorMsg);
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String bizBillKey = (String)customParams.get("bizBillKey");
            Pair<QFilter, Map<String, BigDecimal>> pair = this.getIdToRecMatchAmtMap(bizBillKey);
            String bizEntity = bizBillKey.substring(5);
            String queryField = (String)ManualMatchPlugin.matchFieldMap.get(bizBillKey).getRight();
            String haveEntryIdStr = this.getPageCache().get("haveEntryIdKey");
            boolean entrySelected = Boolean.parseBoolean(haveEntryIdStr);
            if ("list_cas_agentpaybill".equals(bizBillKey) && !entrySelected) {
                Set queryFieldSet = Stream.of(queryField.split(",")).map(String::trim).filter(f -> !f.startsWith("entry.")).collect(Collectors.toSet());
                queryField = String.join((CharSequence)",", queryFieldSet);
            }
            QFilter idFilter = (QFilter)pair.getLeft();
            DynamicObjectCollection bizBills = QueryServiceHelper.query((String)bizEntity, (String)queryField, (QFilter[])new QFilter[]{idFilter});
            Boolean recFlag = (Boolean)customParams.get("transDetailType");
            List<Map<String, Object>> dynObjList = ManualMatchPlugin.bizBillToSameDynObj(bizBills, bizBillKey, null, recFlag, entrySelected);
            DynamicObjectCollection transDetails = this.getTransDetailColl(recFlag);
            Map idToRecAmtMap = (Map)pair.getRight();
            this.unequalAmtConfirmToAcct(recFlag, (DynamicObject[])transDetails.toArray((Object[])new DynamicObject[0]), dynObjList, idToRecAmtMap);
            this.getView().returnDataToParent((Object)bizBillKey);
            this.getView().close();
        }
    }

    private Pair<QFilter, Map<String, BigDecimal>> getIdToRecMatchAmtMap(String bizBillKey) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap<String, BigDecimal> idToRecAmtMap = new HashMap<String, BigDecimal>(entryEntity.size());
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        for (DynamicObject entry : entryEntity) {
            Long detailId = entry.getLong("detailid");
            if (detailId == 0L) continue;
            Long billId = entry.getLong("billid");
            idList.add(billId);
            Long entryId = entry.getLong("billentryid");
            String entryIdStr = null;
            if (entryId != 0L) {
                entryIdList.add(entryId);
                entryIdStr = entryId.toString();
            }
            String idKey = String.join((CharSequence)",", detailId.toString(), billId.toString(), entryIdStr);
            BigDecimal recAmt = entry.getBigDecimal("receiveamt");
            idToRecAmtMap.put(idKey, recAmt);
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        if ("list_cas_agentpaybill".equals(bizBillKey) && entryIdList.size() > 0) {
            idFilter.and("entry.id", "in", entryIdList);
        }
        if (("list_fca_transupbill".equals(bizBillKey) || "list_fca_transdownbill".equals(bizBillKey)) && entryIdList.size() > 0) {
            idFilter.and("entrys.id", "in", entryIdList);
        }
        return Pair.of((Object)idFilter, idToRecAmtMap);
    }

    private void unequalAmtConfirmToAcct(boolean recFlag, DynamicObject[] details, List<Map<String, Object>> bizBills, Map<String, BigDecimal> idToRecMatchAmt) {
        ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(details.length * bizBills.size());
        String tDataEntityType = recFlag ? "bei_intelrec" : "bei_intelpay";
        String thisOpnumber = DB.genGlobalLongId() + "";
        String direction = recFlag ? "rec" : "pay";
        for (Map<String, Object> bizBill : bizBills) {
            for (DynamicObject detail : details) {
                String idStr = String.join((CharSequence)",", detail.getString("id"), bizBill.get("billid").toString(), bizBill.get("billentryid") != null ? bizBill.get("billentryid").toString() : null);
                BigDecimal matchAmount = idToRecMatchAmt.get(idStr);
                if (BigDecimal.ZERO.compareTo(matchAmount) == 0) continue;
                tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, detail.getString("billno"), Long.valueOf(detail.getLong("id")), (String)bizBill.get("billtype"), (String)bizBill.get("billno"), (Long)bizBill.get("billid"), (Long)bizBill.get("billentryid"), Long.valueOf(detail.getLong("currency")), (String)bizBill.get("tracetype"), matchAmount, detail.getString("bankcheckflag"), detail.getDate("bizdate"), thisOpnumber, direction));
            }
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, ReceredWayEnum.HANDMATCH.getValue(), null, true, null});
        CasFlowConfirmLogHelper.saveMatchLog(tAutoMatchInfoList, (String)ReceredWayEnum.HANDMATCH.getValue());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("autofill".equals(itemKey)) {
            List<BigDecimal> detailAmtList = this.getJsonToJava("detailAmtList", BigDecimal.class);
            List<BigDecimal> bizBillAmtList = this.getJsonToJava("bizBillAmtList", BigDecimal.class);
            List<BigDecimal> recAmtList = PartAmtAllotPlugin.getRecMatchAmtList(detailAmtList, bizBillAmtList);
            IDataModel model = this.getModel();
            for (int i = 0; i < recAmtList.size(); ++i) {
                model.setValue("receiveamt", (Object)recAmtList.get(i), i);
            }
        }
    }

    private <T> List<T> getJsonToJava(String cacheKey, Class<T> clazz) {
        String listStr = this.getPageCache().get(cacheKey);
        return (List)JSON.parseObject((String)listStr, List.class);
    }

    private void checkRecAmt(boolean detailFlag, List<BigDecimal> detailAmtList, List<BigDecimal> bizBillAmtList, List<BigDecimal> receiveAmtList, Set<String> errorMsg) {
        int len = bizBillAmtList.size();
        int number = detailFlag ? bizBillAmtList.size() : detailAmtList.size();
        List<BigDecimal> amtList = detailFlag ? detailAmtList : bizBillAmtList;
        int count = amtList.size();
        DynamicObjectCollection entryEntity = detailFlag ? null : this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < count; ++i) {
            ArrayList<BigDecimal> recAmtList = new ArrayList<BigDecimal>(number);
            for (int j = 0; j < number; ++j) {
                int index = detailFlag ? i * len + j : j * len + i;
                BigDecimal detailRecAmt = receiveAmtList.get(index);
                recAmtList.add(detailRecAmt);
            }
            BigDecimal amt = amtList.get(i);
            BigDecimal curRecAmt = recAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (detailFlag && amt.compareTo(curRecAmt) != 0) {
                errorMsg.add(ResManager.loadKDString((String)"\u672c\u6b21\u63a5\u6536\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u4ea4\u6613\u660e\u7ec6\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"PartAmtAllotPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (detailFlag || !(Math.abs(amt.doubleValue()) < Math.abs(curRecAmt.doubleValue()))) continue;
            String billNo = null == entryEntity ? "" : ((DynamicObject)entryEntity.get(i)).getString("billno");
            String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u201c%1$s\u201d\u672c\u6b21\u63a5\u6536\u91d1\u989d\u5408\u8ba1\u201c%2$s\u201d\u5df2\u7ecf\u8d85\u8fc7\u5176\u672a\u5339\u914d\u91d1\u989d\u5408\u8ba1\u201c%3$s\u201d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"PartAmtAllotPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), billNo, curRecAmt.setScale(2), amt.setScale(2));
            errorMsg.add(msg);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("receiveamt".equals(key)) {
            IDataModel model = this.getModel();
            int maxRowIndex = model.getEntryRowCount("entryentity") - 1;
            ChangeData[] changeData = e.getChangeSet();
            int rowIndex = changeData[0].getRowIndex();
            if (rowIndex < maxRowIndex) {
                ArrayList<BigDecimal> recAmtList = new ArrayList<BigDecimal>(maxRowIndex);
                for (int i = 0; i < maxRowIndex; ++i) {
                    BigDecimal value = (BigDecimal)model.getValue(key, i);
                    recAmtList.add(value);
                }
                BigDecimal recAmtSum = recAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                model.setValue("receiveamt", (Object)recAmtSum, maxRowIndex);
                this.getPageCache().put("receiveAmtList", JSON.toJSONString(recAmtList));
            }
        }
    }

    private static List<BigDecimal> getRecMatchAmtList(List<BigDecimal> detailAmtList, List<BigDecimal> bizBillAmtList) {
        BigDecimal detailAmtSum = detailAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal bizBillAmtSum = bizBillAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        boolean amtValueDiff = bizBillAmtSum.compareTo(detailAmtSum) > 0;
        int detailAmtSize = detailAmtList.size();
        int bizBillAmtSize = bizBillAmtList.size();
        ArrayList<BigDecimal> recAmtList = new ArrayList<BigDecimal>(detailAmtSize * bizBillAmtSize);
        for (int i = 0; i < detailAmtSize; ++i) {
            BigDecimal endBizBillAmt;
            BigDecimal prefixAmtSum;
            int j;
            ArrayList<BigDecimal> prefixAmtList;
            if (detailAmtSize == 1 || i < detailAmtSize - 1 || amtValueDiff) {
                prefixAmtList = new ArrayList<BigDecimal>(bizBillAmtSize);
                for (j = 0; j < bizBillAmtSize; ++j) {
                    if (j < bizBillAmtSize - 1) {
                        BigDecimal result = detailAmtList.get(i).multiply(bizBillAmtList.get(j)).divide(bizBillAmtSum, 2, 4);
                        prefixAmtList.add(result);
                        continue;
                    }
                    prefixAmtSum = prefixAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    endBizBillAmt = detailAmtList.get(i).subtract(prefixAmtSum);
                    prefixAmtList.add(endBizBillAmt);
                }
                recAmtList.addAll(prefixAmtList);
                continue;
            }
            prefixAmtList = new ArrayList(bizBillAmtSize);
            for (j = 0; j < bizBillAmtSize; ++j) {
                if (j < bizBillAmtSize - 1) {
                    BigDecimal bizBillUnMatchAmt = bizBillAmtList.get(j);
                    ArrayList<BigDecimal> tmpPrefixAmtList = new ArrayList<BigDecimal>(bizBillAmtSize);
                    for (int n = 0; n < detailAmtSize - 1; ++n) {
                        int index = n * bizBillAmtSize + j;
                        BigDecimal prefixAmt = (BigDecimal)recAmtList.get(index);
                        tmpPrefixAmtList.add(prefixAmt);
                    }
                    BigDecimal bizBillPrefixAmt = tmpPrefixAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal recAmt = bizBillUnMatchAmt.subtract(bizBillPrefixAmt);
                    prefixAmtList.add(recAmt);
                    continue;
                }
                prefixAmtSum = prefixAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                endBizBillAmt = detailAmtList.get(i).subtract(prefixAmtSum);
                prefixAmtList.add(endBizBillAmt);
            }
            recAmtList.addAll(prefixAmtList);
        }
        return recAmtList;
    }

    public static Map<String, BigDecimal> getRecMatchAmtMap(Map<String, BigDecimal> detailAmtMap, Map<String, BigDecimal> bizBillAmtMap) {
        Map<String, BigDecimal> detailMap = PartAmtAllotPlugin.sortMapByValue(detailAmtMap);
        Map<String, BigDecimal> bizBillMap = PartAmtAllotPlugin.sortMapByValue(bizBillAmtMap);
        ArrayList<BigDecimal> detailAmt = new ArrayList<BigDecimal>(detailMap.values());
        ArrayList<BigDecimal> bizBillAmt = new ArrayList<BigDecimal>(bizBillMap.values());
        List<BigDecimal> recMatchAmtList = PartAmtAllotPlugin.getRecMatchAmtList(detailAmt, bizBillAmt);
        int index = 0;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
        for (Map.Entry<String, BigDecimal> detail : detailMap.entrySet()) {
            for (Map.Entry<String, BigDecimal> bizBill : bizBillMap.entrySet()) {
                String idStr = String.join((CharSequence)",", detail.getKey(), bizBill.getKey());
                result.put(idStr, recMatchAmtList.get(index));
                ++index;
            }
        }
        return result;
    }

    private static Map<String, BigDecimal> sortMapByValue(Map<String, BigDecimal> map) {
        ArrayList<Map.Entry<String, BigDecimal>> list = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        list.sort(Comparator.comparing(Map.Entry::getValue));
        LinkedHashMap<String, BigDecimal> map2 = new LinkedHashMap<String, BigDecimal>(16);
        for (Map.Entry entry : list) {
            map2.put((String)entry.getKey(), (BigDecimal)entry.getValue());
        }
        return map2;
    }
}

