/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.log.RefundLogExecutor;
import kd.fi.cas.pojo.ReceiptRefund;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class ReceivingBillRefundPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final Log logger = LogFactory.getLog(ReceivingBillRefundPlugin.class);
    private RefundLogExecutor refundLogExecutor;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"btnok", "btnokreturnmoney"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageData(null, Collections.singleton("payeebanknum"));
        this.setDynamicBillTitle();
    }

    private void setDynamicBillTitle() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String operateKey = (String)showParameter.getCustomParam("operateKey");
        Label labelTitle = (Label)this.getControl("labeltitle");
        String titleName = "";
        if ("refund".equals(operateKey)) {
            titleName = ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7968", (String)"ReceivingBillRefundPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        } else if ("returnmoney".equals(operateKey)) {
            titleName = ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u6b3e", (String)"ReceivingBillRefundPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        labelTitle.setText(titleName);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        List searchFields = evt.getSearchFields();
        HashSet<String> searchKeys = new HashSet<String>(2);
        if (EmptyUtil.isNoEmpty((Object)searchFields)) {
            for (Map searchField : searchFields) {
                List fieldNames = (List)searchField.get("fieldName");
                searchKeys.addAll(fieldNames);
            }
        }
        this.getPageData(searchText, searchKeys);
    }

    private void getPageData(String searchText, Set<String> searchKeys) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long recbillId = (Long)showParameter.getCustomParam("billId");
        String operateKey = (String)showParameter.getCustomParam("operateKey");
        if (null == recbillId) {
            return;
        }
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)recbillId, (String)"cas_recbill", (String)"payername,actrecamt,fee,receivingtype.ispartreceivable,receivingtype.ispartreceivable,payer,currency.id,receivingtype.biztype,inneraccount.company.id,accountbank.id,payeracctbanknum");
        if (searchText == null) {
            searchText = recbill.getString("payeracctbanknum");
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("payeebanknum", searchText);
            clientViewProxy.invokeControlMethod("searchap", "setSearchCondition", new Object[]{map});
        }
        String receivingTypeBizType = recbill.getString("receivingtype.biztype");
        this.getPageCache().put("receivingtype_biztype", receivingTypeBizType);
        if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(receivingTypeBizType)) {
            this.internalSettlement(operateKey, recbill, searchText);
        } else {
            this.pageData(recbillId, recbill, operateKey, searchText, searchKeys);
        }
    }

    private void internalSettlement(String operateKey, DynamicObject recbill, String searchText) {
        this.getView().setVisible(Boolean.valueOf("returnmoney".equals(operateKey)), new String[]{"btnokreturnmoney"});
        this.getView().setVisible(Boolean.valueOf(!"returnmoney".equals(operateKey)), new String[]{"btnok"});
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(4);
        lstFilters.add(new QFilter("payeename", "ftlike", (Object)searchText).or("payeebanknum", "ftlike", (Object)searchText));
        if ("refund".equals(operateKey)) {
            lstFilters.add(new QFilter("agentpayeraccount.id", "=", (Object)recbill.getLong("accountbank.id")));
        } else if ("returnmoney".equals(operateKey)) {
            lstFilters.add(new QFilter("payee", "=", recbill.get("payer")));
        }
        DynamicObjectCollection bills = RefundHelper.loadIfmTransHandleBills((DynamicObject)recbill, lstFilters);
        ArrayList<ReceiptRefund> list = new ArrayList<ReceiptRefund>(bills.size());
        for (DynamicObject bill : bills) {
            ReceiptRefund receiptRefund = new ReceiptRefund(bill.getLong("id"), "ifm_transhandlebill", bill.getString("billno"), bill.getString("payeracctbank.number"), bill.getLong("currency.id"), bill.getBigDecimal("actpayamt"), bill.getString("payeename"), bill.getString("payeebanknum"), bill.getString("description"), bill.getString("usage"), bill.getString("sourcebilltype"), "ifm_transhandlebill");
            list.add(receiptRefund);
        }
        this.appendEntryRow(list);
    }

    private void appendEntryRow(List<ReceiptRefund> list) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"id", "targetbilltype", "billno", "payeracctbank", "currency", "actpayamt", "payee", "payeebanknum", "description", "usage", "sourcebilltype", "billtype", "entryid"});
        for (ReceiptRefund receiptRefund : list) {
            vs.addRow(new Object[]{receiptRefund.getId(), receiptRefund.getTargetBillType(), receiptRefund.getBillNo(), receiptRefund.getPayerAccountBank(), receiptRefund.getCurrency(), receiptRefund.getPaymentAmt(), receiptRefund.getPayee(), receiptRefund.getPayeeBankNum(), receiptRefund.getDescription(), receiptRefund.getUsage(), receiptRefund.getSourceBillType(), receiptRefund.getBillType(), 0L});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void pageData(Long recbillId, DynamicObject recbill, String operateKey, String searchText, Set<String> searchKeys) {
        DynamicObjectCollection paybills;
        Boolean ispartreceivable = recbill.getBoolean("receivingtype.ispartreceivable");
        DynamicObjectCollection agentpaybills = null;
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(10);
        if ("returnmoney".equals(operateKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnokreturnmoney"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
            lstFilters.add(new QFilter(searchKeys.contains("payee") ? "payeename" : "payeebanknum", "ftlike", (Object)searchText).or(searchKeys.contains("payeebanknum") ? "payeebanknum" : "payeename", "ftlike", (Object)searchText));
            lstFilters.add(new QFilter("billtype", "not in", Arrays.asList(BillTypeConstants.PAYBILL_SYN, BillTypeConstants.PAYBILL_SPAN)));
            paybills = RefundHelper.loadPaymentBillRefund((Long)recbillId, lstFilters);
            if (!ispartreceivable.booleanValue()) {
                lstFilters.clear();
                lstFilters.add(new QFilter(searchKeys.contains("payee") ? "entry.payeename" : "entry.payeeacctbank", "ftlike", (Object)searchText).or(searchKeys.contains("payeebanknum") ? "entry.payeeacctbank" : "entry.payeename", "ftlike", (Object)searchText));
                agentpaybills = RefundHelper.loadAgentRefundPayBill((Long)recbillId, lstFilters);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnokreturnmoney"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnok"});
            lstFilters.add(new QFilter(searchKeys.contains("payee") ? "payeename" : "payeebanknum", "ftlike", (Object)searchText).or(searchKeys.contains("payeebanknum") ? "payeebanknum" : "payeename", "ftlike", (Object)searchText));
            paybills = RefundHelper.loadPaymentBillRenote((Long)recbillId, lstFilters);
            if (!ispartreceivable.booleanValue()) {
                lstFilters.clear();
                lstFilters.add(new QFilter(searchKeys.contains("payee") ? "entry.payeename" : "entry.payeeacctbank", "ftlike", (Object)searchText).or(searchKeys.contains("payeebanknum") ? "entry.payeeacctbank" : "entry.payeename", "ftlike", (Object)searchText));
                agentpaybills = RefundHelper.loadAgentRenotePayBill((Long)recbillId, lstFilters);
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("targetbilltype", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("payeracctbank", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("actpayamt", new Object[0]);
        vs.addField("payee", new Object[0]);
        vs.addField("payeebanknum", new Object[0]);
        vs.addField("description", new Object[0]);
        vs.addField("usage", new Object[0]);
        vs.addField("sourcebilltype", new Object[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("entryid", new Object[0]);
        for (DynamicObject dynamicObject : paybills) {
            vs.addRow(new Object[]{dynamicObject.get("id"), "cas_paybill", dynamicObject.get("billno"), dynamicObject.get("payeracctbank.bankaccountnumber"), dynamicObject.get("currency.id"), dynamicObject.get("actpayamt"), dynamicObject.get("payeename"), dynamicObject.get("payeebanknum"), dynamicObject.get("description"), dynamicObject.get("usage"), dynamicObject.get("sourcebilltype"), "cas_paybill", 0L});
        }
        if (agentpaybills != null && !agentpaybills.isEmpty()) {
            for (DynamicObject dynamicObject : agentpaybills) {
                boolean encryption = dynamicObject.getBoolean("isencryption");
                BigDecimal recAmt = recbill.getBigDecimal("actrecamt");
                BigDecimal actRecAmtFee = recAmt.add(recbill.getBigDecimal("fee"));
                BigDecimal agentPayAmt = AgentPayBillHelper.decodeAmount((String)dynamicObject.getString("entry.e_encryptamount"));
                if (!dynamicObject.getBoolean("entry.e_issuccess") || dynamicObject.getBoolean("entry.e_isrefund") || "returnmoney".equals(operateKey) && agentPayAmt.compareTo(actRecAmtFee) < 0 || "refund".equals(operateKey) && agentPayAmt.compareTo(actRecAmtFee) < 0) continue;
                if (encryption) {
                    String entryActPayAmtKey = dynamicObject.get("billno") + "#" + dynamicObject.get("entry.id");
                    this.getPageCache().put(entryActPayAmtKey, agentPayAmt.toString());
                    agentPayAmt = null;
                }
                vs.addRow(new Object[]{dynamicObject.get("id"), "cas_agentpaybill", dynamicObject.get("billno"), dynamicObject.get("payeracctbank.bankaccountnumber"), dynamicObject.get("currency.id"), agentPayAmt, dynamicObject.get("entry.payeename"), dynamicObject.get("entry.payeeacctbank"), dynamicObject.get("description"), dynamicObject.get("entry.e_remark"), dynamicObject.get("sourcebilltype"), "cas_agentpaybill", dynamicObject.get("entry.id")});
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key) || "btnokreturnmoney".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            int[] rows = entry.getSelectRows();
            if (rows.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ReceivingBillRefundPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Long recbillId = (Long)showParameter.getCustomParam("billId");
            if (null == recbillId) {
                return;
            }
            DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)recbillId, (String)"cas_recbill", (String)"actrecamt,entry,entry.e_receivableamt");
            BigDecimal actrecamt = recbill.getBigDecimal("actrecamt");
            DynamicObjectCollection recCol = recbill.getDynamicObjectCollection("entry");
            BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rows[0]);
            String billtype = entryRowEntity.getString("billtype");
            if ("cas_paybill".equals(billtype)) {
                long payBillId = entryRowEntity.getLong("id");
                DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
                DynamicObjectCollection payCol = payBill.getDynamicObjectCollection("entry");
                BigDecimal payAmtSum = payCol.stream().map(o -> o.getBigDecimal("e_payableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (recAmtSum.compareTo(payAmtSum) > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5e94\u6536\u91d1\u989d\u8d85\u8fc7\u6240\u9009\u4ed8\u6b3e\u5355\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u64cd\u4f5c", (String)"ReceivingBillRefundPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                ReceivingBillRefundPlugin.feeBillRefundVerify(payBill, payAmtSum, actrecamt);
                HashMap<Long, BigDecimal> refundAMtMap = new HashMap<Long, BigDecimal>(payCol.size());
                for (DynamicObject d : payCol) {
                    BigDecimal e_refundamt_i = d.getBigDecimal("e_payableamt");
                    if (e_refundamt_i.compareTo(recAmtSum) <= 0) {
                        recAmtSum = recAmtSum.subtract(e_refundamt_i);
                        refundAMtMap.put(d.getLong("id"), e_refundamt_i);
                        continue;
                    }
                    refundAMtMap.put(d.getLong("id"), recAmtSum);
                    recAmtSum = BigDecimal.ZERO;
                }
                HashMap<String, HashMap<Long, BigDecimal>> params = new HashMap<String, HashMap<Long, BigDecimal>>();
                params.put("refundrowamts", refundAMtMap);
                WriteBackOperateEnum operateEnum = WriteBackOperateEnum.REFUNDVALIDATE;
                if ("btnok".equals(key)) {
                    operateEnum = WriteBackOperateEnum.RENOTEVALIDATE;
                }
                WriteBackValidateHelper.writeBackValidate((DynamicObject)payBill, (WriteBackOperateEnum)operateEnum, PaymentDisposeConsumer.class, params);
                String sourcebilltype = payBill.getString("sourcebilltype");
                if (!WriteBackValidateHelper.getOldValidateTypeBills().contains(sourcebilltype)) {
                    boolean erValidateBill = WriteBackValidateHelper.isErValidateBill((String)sourcebilltype);
                    String msg = WriteBackServiceImpl.getInstance().validate(payBill, operateEnum, PaymentDisposeConsumer.class, sourcebilltype, !erValidateBill);
                    if (EmptyUtil.isNoEmpty((String)msg)) {
                        throw new KDBizException(msg);
                    }
                }
            } else if ("cas_agentpaybill".equals(billtype)) {
                Long entryId = entryRowEntity.getLong("entryid");
                QFilter queryFilter = new QFilter("entry.id", "=", (Object)entryId);
                DynamicObject agentBill = BusinessDataServiceHelper.loadSingle((String)"cas_agentpaybill", (String)"sourcebilltype,isdiffcur,entry.sourceentryid,entry.e_issuccess,entry.e_amount,entry.e_isrefund,entry.e_refundamt,entry.e_refunddes,entry.refundbillid,entry.refundtype", (QFilter[])new QFilter[]{queryFilter});
                boolean isDiffCurrency = agentBill.getBoolean("isdiffcur");
                if (isDiffCurrency) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u4ed8\u6b3e\u4e1a\u52a1\u9000\u6b3e\u9000\u7968\u3002\u656c\u8bf7\u671f\u5f85\u540e\u7eed\u4f18\u5316\u3002", (String)"ReceivingBillRefundPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                DynamicObjectCollection entrys = agentBill.getDynamicObjectCollection("entry");
                HashMap<String, Comparable<Boolean>> refundAInfoMap = new HashMap<String, Comparable<Boolean>>(0);
                for (DynamicObject row : entrys) {
                    if (!entryId.equals(row.getLong("id"))) continue;
                    refundAInfoMap.put("e_issuccess", Boolean.valueOf(false));
                    refundAInfoMap.put("e_isrefund", Boolean.valueOf(true));
                    refundAInfoMap.put("e_refundamt", recAmtSum);
                    break;
                }
                HashMap params = new HashMap();
                WriteBackOperateEnum operateEnum = WriteBackOperateEnum.REFUNDVALIDATE;
                if ("btnok".equals(key)) {
                    operateEnum = WriteBackOperateEnum.RENOTEVALIDATE;
                }
                params.put("entryPks", Collections.singletonList(entryId));
                params.put("refundAInfoMap", refundAInfoMap);
                WriteBackValidateHelper.writeBackValidate((DynamicObject)agentBill, (WriteBackOperateEnum)operateEnum, AgentWriteBackConsumer.class, (Map)params);
                String sourcebilltype = agentBill.getString("sourcebilltype");
                if (!WriteBackValidateHelper.getOldValidateTypeBills().contains(sourcebilltype)) {
                    boolean erValidateBill = WriteBackValidateHelper.isErValidateBill((String)sourcebilltype);
                    String msg = WriteBackServiceImpl.getInstance().validate(agentBill, operateEnum, AgentWriteBackConsumer.class, sourcebilltype, !erValidateBill);
                    if (EmptyUtil.isNoEmpty((String)msg)) {
                        throw new KDBizException(msg);
                    }
                }
            }
            if ("btnok".equals(key)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u9000\u7968\uff1f", (String)"PaymentBillEdit_23_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_RENOTE_CALLBACK", (IFormPlugin)this));
            } else if ("btnokreturnmoney".equals(key)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u9000\u6b3e\uff1f", (String)"PaymentBillEdit_23_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_REFUND_CALLBACK", (IFormPlugin)this));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        logger.info("--\u9000\u6b3e-- ReceivingBillRefundPlugin.beforeDoOperation");
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "refund": 
            case "returnmoney": {
                this.beforeDoOperationRefundOrRenote(operate);
                break;
            }
            case "ifm_refund": 
            case "ifm_returnmoney": {
                this.beforeDoOperationRefundOrRenoteIfm(operate);
                EntryGrid entry = (EntryGrid)this.getControl("entryentity");
                int[] rows = entry.getSelectRows();
                Long revId = (Long)this.getView().getFormShowParameter().getCustomParam("billId");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rows[0]);
                String operateType = "ifm_returnmoney".equals(operate.getOperateKey()) ? "refund" : "renote";
                this.refundLogExecutor = new RefundLogExecutor(revId, Long.valueOf(entryRowEntity.getLong("id")), operateType);
                break;
            }
        }
    }

    private void beforeDoOperationRefundOrRenote(FormOperate operate) {
        IDataModel model = this.getModel();
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (rows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ReceivingBillRefundPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rows[0]);
        String targetbilltype = entryRowEntity.getString("targetbilltype");
        logger.info("targetbilltype:" + targetbilltype + ",e_actpayamt:" + entryRowEntity.getBigDecimal("actpayamt") + ",operate:" + operate.getOperateKey());
        boolean paymentBillAndFullRefund = this.checkIsPaymentBillAndFullRefund(targetbilltype, entryRowEntity.getBigDecimal("actpayamt"), operate.getOperateKey());
        logger.info("--\u9000\u6b3e-- checkIsPaymentBillAndFullRefund:" + paymentBillAndFullRefund);
        if (paymentBillAndFullRefund || "cas_agentpaybill".equals(targetbilltype) || "refund".equals(operate.getOperateKey())) {
            operate.getOption().setVariableValue("isdooperate", SerializationUtils.toJsonString((Object)true));
            this.getPageCache().put("isdooperate", "true");
            logger.info("\u8d70\u8001\u7684\u9000\u6b3e\u9000\u7968");
            if ("refund".equals(operate.getOperateKey())) {
                operate.getOption().setVariableValue("selected", SerializationUtils.toJsonString((Object)rows));
                operate.getOption().setVariableValue("rebillid", SerializationUtils.toJsonString((Object)this.getView().getFormShowParameter().getCustomParam("billId")));
            } else if ("returnmoney".equals(operate.getOperateKey())) {
                operate.getOption().setVariableValue("selected", SerializationUtils.toJsonString((Object)rows));
                operate.getOption().setVariableValue("rebillid", SerializationUtils.toJsonString((Object)this.getView().getFormShowParameter().getCustomParam("billId")));
                Object actPayAmtObj = this.getActPayAmt(targetbilltype, rows[0]);
                operate.getOption().setVariableValue("actpayamt", SerializationUtils.toJsonString((Object)actPayAmtObj));
            }
        } else {
            operate.getOption().setVariableValue("isdooperate", SerializationUtils.toJsonString((Object)true));
            this.getPageCache().put("isdooperate", "true");
            operate.getOption().setVariableValue("selected", SerializationUtils.toJsonString((Object)rows));
            operate.getOption().setVariableValue("rebillid", SerializationUtils.toJsonString((Object)this.getView().getFormShowParameter().getCustomParam("billId")));
            operate.getOption().setVariableValue("actpayamt", SerializationUtils.toJsonString((Object)this.getModel().getValue("actpayamt", rows[0])));
        }
    }

    private void beforeDoOperationRefundOrRenoteIfm(FormOperate operate) {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (rows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ReceivingBillRefundPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        operate.getOption().setVariableValue("rebillid", SerializationUtils.toJsonString((Object)this.getView().getFormShowParameter().getCustomParam("billId")));
        operate.getOption().setVariableValue("selected", SerializationUtils.toJsonString((Object)rows));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        logger.info("--\u9000\u6b3e-- ReceivingBillRefundPlugin.afterDoOperation");
        FormOperate operate = (FormOperate)args.getSource();
        if (("ifm_returnmoney".equals(operate.getOperateKey()) || "ifm_refund".equals(operate.getOperateKey())) && this.refundLogExecutor != null) {
            this.refundLogExecutor.saveLog(args.getOperationResult());
        }
        if ("ifm_returnmoney".equals(operate.getOperateKey()) || "ifm_refund".equals(operate.getOperateKey()) || ("returnmoney".equals(operate.getOperateKey()) || "refund".equals(operate.getOperateKey())) && args.getOperationResult().isSuccess()) {
            logger.info("\u64cd\u4f5c\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)args.getOperationResult()));
            IFormView parentView = this.getView().getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u9000\u6b3e/\u5df2\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u9000\u6b3e/\u9000\u7968\u76f8\u5173\u5355\u636e\u7ed3\u7b97\u4fe1\u606f\u662f\u5426\u51c6\u786e\u3002", (String)"ReceivingBillRefundPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            IFormView view = this.getView();
            view.close();
            this.getView().sendFormAction(view);
        }
    }

    private boolean checkIsPaymentBillAndFullRefund(String targetbilltype, BigDecimal actpayamt, String operatekey) {
        Long billId = (Long)this.getView().getFormShowParameter().getCustomParam("billId");
        return "cas_paybill".equals(targetbilltype) && this.checkIsFullRefund(billId, actpayamt) && "returnmoney".equals(operatekey);
    }

    private boolean checkIsFullRefund(Long rebillid, BigDecimal actpayamt) {
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill");
        BigDecimal actrecamt = recbill.getBigDecimal("actrecamt");
        logger.info("--\u9000\u6b3e,\u6536\u6b3e\u5355\u91d1\u989d-- actrecamt:" + actrecamt);
        logger.info("--\u9000\u6b3e,\u4ed8\u6b3e\u5355\u91d1\u989d-- actpayamt:" + actpayamt);
        return actrecamt.compareTo(actpayamt) == 0;
    }

    private Object getActPayAmt(String targetBillType, int rowIndex) {
        Object actPayAmtObj;
        if ("cas_agentpaybill".equals(targetBillType)) {
            Object billno = this.getModel().getValue("billno", rowIndex);
            String entryActPayAmtKey = billno + "#" + this.getModel().getValue("entryid", rowIndex);
            String actPayAmtStr = this.getPageCache().get(entryActPayAmtKey);
            actPayAmtObj = StringUtils.isNotEmpty((String)actPayAmtStr) ? new BigDecimal(actPayAmtStr) : this.getModel().getValue("actpayamt", rowIndex);
        } else {
            actPayAmtObj = this.getModel().getValue("actpayamt", rowIndex);
        }
        return actPayAmtObj;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        String receivingTypeBizType = this.getPageCache().get("receivingtype_biztype");
        if (MessageBoxResult.Yes.equals((Object)res)) {
            if (id.equals("CONFIRM_RENOTE_CALLBACK")) {
                if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(receivingTypeBizType)) {
                    this.getView().invokeOperation("ifm_refund");
                } else {
                    this.getView().invokeOperation("refund");
                }
            } else if (id.equals("CONFIRM_REFUND_CALLBACK")) {
                if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(receivingTypeBizType)) {
                    this.getView().invokeOperation("ifm_returnmoney");
                } else {
                    this.getView().invokeOperation("returnmoney");
                }
            }
        }
    }

    private static void feeBillRefundVerify(DynamicObject payBill, BigDecimal payAmtSum, BigDecimal actrecamt) {
        String paySourceBillType = payBill.getString("sourcebilltype");
        if (EmptyUtil.isNotEmpty((String)paySourceBillType) && "cfm_feebill".equals(paySourceBillType)) {
            if (payAmtSum.compareTo(actrecamt) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u6536\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\u3002", (String)"ReceivingBillRefundPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            long feeBillId = payBill.getLong("sourcebillid");
            DynamicObject feeBill = QueryServiceHelper.queryOne((String)"cfm_feebill", (String)"id,issettle", (QFilter[])new QFilter("id", "=", (Object)feeBillId).toArray());
            boolean issettle = feeBill.getBoolean("issettle");
            if (!issettle) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6\u5355\u672a\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"ReceivingBillRefundPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

