/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebservice.service.sync.impl;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.ebservice.bean.EBResultStatusCode;
import kd.fi.cas.business.ebservice.bean.SyncStatusInfo;
import kd.fi.cas.business.ebservice.bean.SyncStatusResult;
import kd.fi.cas.business.ebservice.service.sync.IPayBillSyncStatusService;
import kd.fi.cas.business.ebservice.service.sync.impl.AbstractPayBillSyncStatusService;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractPayBillSyncStatusService
implements IPayBillSyncStatusService {
    private static final Log logger = LogFactory.getLog(AbstractPayBillSyncStatusService.class);
    private boolean throwException = false;

    @Override
    public boolean throwException() {
        return this.throwException;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public SyncStatusResult syncStatus(SyncStatusInfo info) {
        SyncStatusResult result = new SyncStatusResult();
        StringBuilder errMsg = new StringBuilder();
        TXHandle tx = TX.requiresNew();
        Object object = null;
        try {
            try {
                this.doSyncStatusMainProcess(info);
                List<IBranchProcess> processList = this.getBranchProcess();
                for (IBranchProcess process : processList) {
                    String branchErrMsg = process.doBranchProcessWithoutException();
                    if (branchErrMsg == null) continue;
                    errMsg.append(branchErrMsg).append('\n');
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                result.setErrMsg(e.getMessage());
                result.setStatusCode(EBResultStatusCode.ROLLBACK);
                ThreadPools.executeOnceIncludeRequestContext((String)"logResponseException", () -> {
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"cas_synclog");
                    obj.set("billid", (Object)info.getPayBillId());
                    obj.set("billtype", (Object)info.getEntityType());
                    obj.set("bizdate", (Object)new Date());
                    TextProp property = (TextProp)obj.getDataEntityType().getProperties().get((Object)"errormsg");
                    int maxLenth = property.getMaxLenth();
                    String msg = e.getMessage();
                    if (msg != null && msg.length() > maxLenth) {
                        msg = msg.substring(0, maxLenth);
                    }
                    obj.set("errormsg", (Object)msg);
                    obj.set("errormsg_tag", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                });
                if (this.throwException) {
                    throw e;
                }
                SyncStatusResult syncStatusResult = result;
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return syncStatusResult;
            }
        }
        catch (Throwable e) {
            object = e;
            throw e;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)object).addSuppressed(e);
                    }
                } else {
                    tx.close();
                }
            }
        }
        try {
            List<IBranchProcess> processList = this.getBranchProcessAfter();
            if (processList != null) {
                for (IBranchProcess process : processList) {
                    process.doBranchProcessWithoutException();
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (errMsg.length() > 0) {
            result.setStatusCode(EBResultStatusCode.ERROR);
            result.setErrMsg(errMsg.toString());
        } else {
            result.setStatusCode(EBResultStatusCode.SUCCESS);
        }
        return result;
    }

    protected abstract void doSyncStatusMainProcess(SyncStatusInfo var1);

    protected abstract List<IBranchProcess> getBranchProcess();

    protected abstract List<IBranchProcess> getBranchProcessAfter();
}

