/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebservice.service.sync.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.business.ebservice.bean.SyncStatusDetail;
import kd.fi.cas.business.ebservice.bean.SyncStatusInfo;
import kd.fi.cas.business.ebservice.service.sync.impl.AbstractPayBillSyncStatusService;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.PaymentBillBookJournalBuilder;
import kd.fi.cas.business.opservice.helper.PaymentSaleServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.business.refund.RefundService;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.message.MessageTemplateEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PayBillSyncStatusService
extends AbstractPayBillSyncStatusService {
    private static final Log logger = LogFactory.getLog(PayBillSyncStatusService.class);
    private Map<Long, Pair<String, String>> paymentStatusMap = new HashMap<Long, Pair<String, String>>();
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private DynamicObject payBill;
    private String bankcheckflag;
    private String bankpaystate;
    private Long bankBillId;
    private boolean autoRefund;

    @Override
    protected void doSyncStatusMainProcess(SyncStatusInfo info) {
        String sql;
        int[] result;
        logger.info("-------\u6267\u884c\u4ed8\u6b3e\u5355\u540c\u6b65\u72b6\u6001\u4e3b\u6d41\u7a0b: SyncStatusInfo = " + SerializationUtils.toJsonString((Object)info));
        Long payBillId = info.getPayBillId();
        this.bankBillId = info.getBankBillId();
        this.payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        if (!("ifm_transhandlebill".equals(info.getSourceType()) || (result = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)(sql = "update T_CAS_PaymentBill set fmodifytime = ? where fid = " + payBillId + " and FIsCommitBE = ? "), Collections.singletonList(new Object[]{DateUtils.getCurrentDate(), "1"}))).length >= 1 && result[0] != 0)) {
            logger.info("-------\u6267\u884c\u4ed8\u6b3e\u5355\u540c\u6b65\u72b6\u6001\u4e3b\u6d41\u7a0b\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u662f\u5426\u63d0\u4ea4\u94f6\u4f01\u4e3a\u5426");
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u662f\u5426\u63d0\u4ea4\u94f6\u4f01\u4e3a\u5426\uff0c\u540c\u6b65\u66f4\u65b0\u4ed8\u6b3e\u5355\u72b6\u6001\u5931\u8d25\u3002", (String)"PayBillSyncStatusService_14", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        SyncStatusDetail infoDetail = (SyncStatusDetail)info.getDetailList().get(0);
        this.bankpaystate = info.getBankPayStatus();
        this.bankcheckflag = infoDetail.getBankDetailSeqId();
        boolean isbitback = info.isBitBack();
        String bitbackopinion = info.getBitbackopinion();
        String bankReturnMsg = infoDetail.getEbStatusMsg();
        String exchangeRateStr = infoDetail.getExchangeRate();
        String actualAmountStr = infoDetail.getActualAmount();
        Date payDate = infoDetail.getPayDate();
        this.paymentStatusMap.put(payBillId, (Pair<String, String>)new MutablePair((Object)this.payBill.getString("bankpaystatus"), (Object)this.bankpaystate));
        String bankpaystatus = this.payBill.getString("bankpaystatus");
        Date currentDate = DateUtils.getCurrentDate();
        Long pkValue = (Long)this.payBill.getPkValue();
        DynamicObject[] bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,bankcheckflag,bankcheckflag_tag,batchno,accountbank,currency,creditamount,sourcebillid,tracedate", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)pkValue)});
        DynamicObjectCollection bankCheckEntity = this.payBill.getDynamicObjectCollection("bankcheckentity");
        if (BeBillStatusEnum.OF.getValue().equals(this.bankpaystate) || BeBillStatusEnum.OP.getValue().equals(this.bankpaystate)) {
            this.payBill.set("bankcheckflag", null);
            this.payBill.set("bankcheckflag_tag", null);
            bankCheckEntity.clear();
            currentDate = null;
        } else if (BeBillStatusEnum.TS.getValue().equals(this.bankpaystate)) {
            boolean isDifCurrency;
            this.autoRefund = CollectionUtils.isNotEmpty((Collection)info.getDetailList()) && info.getDetailList().get(0) != null && ((SyncStatusDetail)info.getDetailList().get(0)).isRenote();
            this.payBill.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
            this.payBill.set("bankpaystatus", (Object)this.bankpaystate);
            this.payBill.set("bankreturnmsg", (Object)bankReturnMsg);
            if (this.bankcheckflag != null && this.bankcheckflag.trim().length() > 0) {
                DynamicObject entryEntity = bankCheckEntity.addNew();
                if (!bankCheckEntity.contains((Object)this.bankcheckflag)) {
                    entryEntity.set("ebankcheckflag", (Object)this.bankcheckflag);
                }
                this.payBill.set("bankcheckflag", (Object)CasHelper.subFlag((String)this.bankcheckflag));
                this.payBill.set("bankcheckflag_tag", (Object)this.bankcheckflag);
            }
            if (CasHelper.isEmpty((Object)bankpaystatus) || !BeBillStatusEnum.TS.getValue().equals(bankpaystatus)) {
                this.payBill.set("paydate", (Object)(EmptyUtil.isNoEmpty((Object)payDate) ? payDate : new Date()));
                this.payBill.set("acttradedate", (Object)(EmptyUtil.isNoEmpty((Object)payDate) ? payDate : currentDate));
            }
            if (CasHelper.isNotEmpty((Object)bankpaystatus) && (BeBillStatusEnum.TF.getValue().equals(bankpaystatus) || BeBillStatusEnum.NC.getValue().equals(bankpaystatus))) {
                currentDate = null;
                this.payBill.set("acttradedate", null);
            }
            if ((isDifCurrency = this.payBill.getBoolean("isdiffcur")) && StringUtils.isNotEmpty((String)actualAmountStr) && StringUtils.isNotEmpty((String)exchangeRateStr)) {
                BigDecimal exchangeRate = new BigDecimal(exchangeRateStr);
                BigDecimal actualAmount = new BigDecimal(actualAmountStr);
                BigDecimal payAmt = this.payBill.getBigDecimal("actpayamt");
                BigDecimal dpAmt = payAmt.multiply(exchangeRate);
                this.payBill.set("dpamt", (Object)dpAmt);
                this.payBill.set("agreedrate", (Object)exchangeRate);
                BigDecimal fee = actualAmount.add(dpAmt.negate());
                this.payBill.set("fee", (Object)fee);
                this.payBill.set("totalpayamt", (Object)dpAmt.add(fee));
            }
            OperateOption operateOption = OperateOption.create();
            String syncStatusInfoJsonString = SerializationUtils.toJsonString((Object)info);
            operateOption.setVariableValue("SyncStatusInfo", syncStatusInfoJsonString);
            OperateServiceHelper.execOperate((String)"syncstatus", (String)this.payBill.getDataEntityType().getName(), (Object[])new Object[]{this.payBill.getPkValue()}, (OperateOption)operateOption);
        } else if (BeBillStatusEnum.TF.getValue().equals(this.bankpaystate)) {
            logger.info("\u94f6\u884c\u4ed8\u6b3e\u5355:\u70b9\u51fb\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001:\u4ea4\u6613\u5931\u8d25 \u5bf9\u8d26\u6807\u8bc6\u7801bankcheckflag: " + this.bankcheckflag);
            this.payBill.set("billstatus", (Object)BillStatusEnum.BEING.getValue());
            this.payBill.set("bankpaystatus", (Object)this.bankpaystate);
            this.payBill.set("bankreturnmsg", (Object)bankReturnMsg);
            this.payBill.set("bankcheckflag", null);
            this.payBill.set("bankcheckflag_tag", null);
            this.payBill.set("acttradedate", null);
            bankCheckEntity.clear();
            currentDate = null;
        } else {
            this.payBill.set("bankcheckflag", null);
            this.payBill.set("bankcheckflag_tag", null);
            this.payBill.set("bankpaystatus", (Object)this.bankpaystate);
            this.payBill.set("bankreturnmsg", (Object)bankReturnMsg);
            this.payBill.set("acttradedate", null);
            bankCheckEntity.clear();
            currentDate = null;
        }
        for (DynamicObject bankjournal : bankjournals) {
            bankjournal.set("tracedate", (Object)currentDate);
        }
        if ("ifm_transhandlebill".equals(info.getSourceType())) {
            this.payBill.set("bankpaystatus", (Object)this.bankpaystate);
            this.payBill.set("iscommitbe", (Object)info.getCommitBe());
            this.payBill.set("commitbetime", (Object)info.getCommitBeTime());
            this.payBill.set("bankreturnmsg", (Object)bankReturnMsg);
        }
        this.payBill.set("isrepulsed", (Object)isbitback);
        this.payBill.set("repulsedreason", (Object)bitbackopinion);
        logger.info("isrepulsed \u662f\uff1a" + isbitback + ";repulsedreason \u662f\uff1a" + bitbackopinion + "");
        SaveServiceHelper.save((DynamicObject[])bankjournals);
        PaymentPayHelper.updateEntryDpAmt((DynamicObject)this.payBill);
        DynamicObject[] payBills = new DynamicObject[]{this.payBill};
        RefundHelper.setSomeRefundAmtFields((DynamicObject[])payBills, (String)"cas_paybill");
        SaveServiceHelper.save((DynamicObject[])payBills);
    }

    @Override
    protected List<AbstractPayBillSyncStatusService.IBranchProcess> getBranchProcess() {
        return Arrays.asList(this.book(), this.updateSrcPayBillStatus(), this.writeBack(), this.generateRecPayBill(), this.sendNoticeMessage(), this.pushOrCancelIfmAndInnerRec());
    }

    private AbstractPayBillSyncStatusService.IBranchProcess book() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                if (BeBillStatusEnum.TS.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                    if (!PayBillSyncStatusService.this.journalServiceAdapter.hasBooked(PayBillSyncStatusService.this.payBill)) {
                        PayBillSyncStatusService.this.journalServiceAdapter.validateBook((IBookJournalBuilder)new PaymentBillBookJournalBuilder(), PayBillSyncStatusService.this.payBill);
                        PayBillSyncStatusService.this.journalServiceAdapter.book(PayBillSyncStatusService.this.payBill);
                    }
                    AgentPayBillHelper.saveBankCheckFlag((DynamicObject)PayBillSyncStatusService.this.payBill);
                } else if (BeBillStatusEnum.TF.getValue().equals(PayBillSyncStatusService.this.bankpaystate) && PayBillSyncStatusService.this.journalServiceAdapter.hasBooked(PayBillSyncStatusService.this.payBill)) {
                    PayBillSyncStatusService.this.journalServiceAdapter.validateCancelBook(PayBillSyncStatusService.this.payBill);
                    PayBillSyncStatusService.this.journalServiceAdapter.cancelBook(PayBillSyncStatusService.this.payBill);
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u767b\u8d26", (String)"PayBillSyncStatusService_6", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess updateSrcPayBillStatus() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                if (BeBillStatusEnum.TS.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                    DynamicObject payMent;
                    if (!CasHelper.isEmpty((Object)PayBillSyncStatusService.this.payBill.get("applyorg")) && "cas_paybill".equals(PayBillSyncStatusService.this.payBill.get("sourcebilltype")) && !CasHelper.isEmpty((Object)PayBillSyncStatusService.this.payBill.get("sourcebillid")) && !CasHelper.isEmpty((Object)(payMent = BusinessDataServiceHelper.loadSingle((Object)PayBillSyncStatusService.this.payBill.get("sourcebillid"), (String)"cas_paybill")))) {
                        payMent.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
                        payMent.set("paydate", (Object)new Date());
                        payMent.set("acttradedate", (Object)DateUtils.getCurrentDate());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payMent});
                        if (!CasHelper.isEmpty((Object)payMent.getString("sourcebilltype"))) {
                            WriteBackTaskHelper.addRealtimeTask((DynamicObject)payMent, (String)payMent.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.PAY, PaymentDisposeConsumer.class);
                        }
                        WriteBackTaskHelper.addRealtimeTask((DynamicObject)payMent, (String)"ap_settle", (WriteBackOperateEnum)WriteBackOperateEnum.PAY, PaymentDisposeConsumer.class);
                        boolean isPushArAp = SystemParameterHelper.getParameterBoolean((long)PayBillSyncStatusService.this.payBill.getDynamicObject("org").getLong("id"), (String)"cs088");
                        if (isPushArAp) {
                            OperateServiceHelper.execOperate((String)"paypusharandsave", (String)PayBillSyncStatusService.this.payBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{PayBillSyncStatusService.this.payBill}, (OperateOption)OperateOption.create());
                        }
                    }
                } else if (BeBillStatusEnum.TF.getValue().equals(PayBillSyncStatusService.this.bankpaystate) || BeBillStatusEnum.NC.getValue().equals(PayBillSyncStatusService.this.bankpaystate) || BeBillStatusEnum.BP.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                    DynamicObject payment;
                    logger.info("\u94f6\u884c\u4ed8\u6b3e\u5355\u72b6\u6001\uff1a{}", (Object)PayBillSyncStatusService.this.bankpaystate);
                    if (Objects.nonNull(PayBillSyncStatusService.this.payBill) && Objects.equals(PayBillSyncStatusService.this.payBill.getDataEntityType().getName(), "cas_paybill") && !CasHelper.isEmpty((Object)(payment = BusinessDataServiceHelper.loadSingle((Object)PayBillSyncStatusService.this.payBill.getPkValue(), (String)"cas_paybill"))) && "cas_transferapply".equals(payment.get("sourcebilltype"))) {
                        WriteBackTaskHelper.addRealtimeTask((DynamicObject)payment, (String)payment.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.SYNCSTATUS, PaymentDisposeConsumer.class);
                        logger.info("\u94f6\u884c\u4ed8\u6b3e\u5355\u72b6\u6001\u540c\u6b65\u8c03\u62e8\u7533\u8bf7\u660e\u7ec6");
                    }
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u66f4\u65b0\u59d4\u6258\u4ed8\u6b3e\u5355", (String)"PayBillSyncStatusService_7", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess writeBack() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                Pair status = (Pair)PayBillSyncStatusService.this.paymentStatusMap.get(PayBillSyncStatusService.this.payBill.getLong("id"));
                if (status == null) {
                    return null;
                }
                if (PayBillSyncStatusService.this.isRefund((Pair<String, String>)status)) {
                    if (!CasHelper.isEmpty((Object)PayBillSyncStatusService.this.payBill.getString("sourcebilltype"))) {
                        WriteBackTaskHelper.addRealtimeTask((DynamicObject)PayBillSyncStatusService.this.payBill, (String)PayBillSyncStatusService.this.payBill.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAY, PaymentDisposeConsumer.class);
                    }
                    WriteBackTaskHelper.addRealtimeTask((DynamicObject)PayBillSyncStatusService.this.payBill, (String)"ap_settle", (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAY, PaymentDisposeConsumer.class);
                } else if (PayBillSyncStatusService.this.isStatusChanged((Pair<String, String>)status) && PayBillSyncStatusService.this.isSuccess((Pair<String, String>)status)) {
                    WriteBackOperateEnum opertion = WriteBackOperateEnum.PAY;
                    if (!CasHelper.isEmpty((Object)PayBillSyncStatusService.this.payBill.getString("sourcebilltype"))) {
                        WriteBackTaskHelper.addRealtimeTask((DynamicObject)PayBillSyncStatusService.this.payBill, (String)PayBillSyncStatusService.this.payBill.getString("sourcebilltype"), (WriteBackOperateEnum)opertion, PaymentDisposeConsumer.class);
                    }
                    WriteBackTaskHelper.addRealtimeTask((DynamicObject)PayBillSyncStatusService.this.payBill, (String)"ap_settle", (WriteBackOperateEnum)opertion, PaymentDisposeConsumer.class);
                    PaymentSaleServiceHelper.convertPur((DynamicObject[])new DynamicObject[]{PayBillSyncStatusService.this.payBill}, (boolean)true);
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u53cd\u5199\u4e0a\u6e38\u5355\u636e", (String)"PayBillSyncStatusService_8", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess generateRecPayBill() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                if (BeBillStatusEnum.TS.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                    OperateServiceHelper.execOperate((String)"pregenpurpay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{PayBillSyncStatusService.this.payBill}, (OperateOption)OperateOption.create());
                    PaymentServiceHelper.genReceivingBill((DynamicObject)PayBillSyncStatusService.this.payBill);
                } else if (BeBillStatusEnum.TF.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                    OperateServiceHelper.execOperate((String)"delpurpay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{PayBillSyncStatusService.this.payBill}, (OperateOption)OperateOption.create());
                    QFilter qFilter = new QFilter("sourcebillid", "in", (Object)new Long[]{PayBillSyncStatusService.this.payBill.getLong("id")}).and(new QFilter("sourcebilltype", "=", (Object)"cas_paybill").and("billstatus", "=", (Object)"A"));
                    DynamicObjectCollection recBillCollection = QueryServiceHelper.query((String)"cas_recbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (CasHelper.isNotEmpty((Object)recBillCollection)) {
                        Set<Long> delRecIds = recBillCollection.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                        OperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])delRecIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
                    }
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u751f\u6210\u6536\u4ed8\u534f\u540c", (String)"PayBillSyncStatusService_10", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess updatePayScheBill() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                long payBillId = PayBillSyncStatusService.this.payBill.getLong("id");
                boolean isPaySchePush = (Boolean)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"isSchePayBill", (Object[])new Object[]{payBillId});
                List<Long> infos = Collections.singletonList(payBillId);
                logger.info("\u662f\u5426\u4ed8\u6b3e\u6392\u7a0b\u4e0b\u63a8\uff1a{}, \u4ed8\u6b3e\u5355id\uff1a{}", (Object)isPaySchePush, (Object)payBillId);
                if (isPaySchePush) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("payBillIds", JSON.toJSONString(infos));
                    params.put("status", PayBillSyncStatusService.this.bankpaystate);
                    try {
                        CommonParam param = new CommonParam();
                        param.put((Object)"retry", (Object)"true");
                        logger.info("\u94f6\u884c\u4ed8\u6b3e\u5355\u72b6\u6001\uff1a{}", (Object)PayBillSyncStatusService.this.bankpaystate);
                        if (BeBillStatusEnum.TS.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                            param.put((Object)"pay", (Object)JSON.toJSONString(params));
                            param.put((Object)"operation", (Object)"pay");
                        } else {
                            param.put((Object)"synPaySche", (Object)JSON.toJSONString(params));
                            param.put((Object)"operation", (Object)"synPaySche");
                        }
                        List businessIdList = infos.stream().map(String::valueOf).collect(Collectors.toList());
                        try (TXHandle tx = TX.requiresNew();){
                            ECGlobalSession.begin((String)"paybill_syncstatus", (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                            ECGlobalSession.setBusinessType((String)"paybill_syncstatus");
                            ECGlobalSession.setAsync((boolean)true);
                            ECGlobalSession.setBusinessInfo(businessIdList);
                            ECGlobalSession.register((String)"tmc", (String)"psd", (String)"UpdatePayScheBillService", (Param)param);
                        }
                        catch (Exception e) {
                            logger.error("error:", (Throwable)e);
                        }
                    }
                    catch (Exception ext) {
                        logger.error("\u53cd\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355\u6700\u7ec8\u4e00\u81f4\u6027\u5411\u670d\u52a1\u7aef\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)ext);
                        throw ext;
                    }
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u53cd\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355", (String)"PayBillSyncStatusService_11", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess sendNoticeMessage() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                try {
                    QFilter qFilter;
                    DynamicObject detail;
                    if (EmptyUtil.isNoEmpty((Long)PayBillSyncStatusService.this.bankBillId) && (detail = BusinessDataServiceHelper.loadSingle((String)"bei_bankpaybill", (String)"id,bankpaystate,billno", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)PayBillSyncStatusService.this.bankBillId)})) != null) {
                        String payState = detail.getString("bankpaystate");
                        if (BeBillStatusEnum.TF.getValue().equals(payState) || BeBillStatusEnum.NC.getValue().equals(payState)) {
                            DynamicObject cashier = PayBillSyncStatusService.this.payBill.getDynamicObject("cashier");
                            if (EmptyUtil.isEmpty((DynamicObject)cashier)) {
                                return null;
                            }
                            MessageInfo message = new MessageInfo();
                            message.setEntityNumber("bei_bankpaybill");
                            message.setMessageTag((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u94f6\u4f01\u652f\u4ed8\u7ed3\u679c", (String)"PayBillSyncStatusService_0", (String)"fi-cas-business", (Object[])new Object[0])));
                            String templateNumber = "";
                            if (BeBillStatusEnum.TF.getValue().equals(payState)) {
                                templateNumber = MessageTemplateEnum.BEI_BANKPAYBILL_PAYFAIL.getValue();
                            } else if (BeBillStatusEnum.NC.getValue().equals(payState)) {
                                templateNumber = MessageTemplateEnum.BEI_BANKPAYBILL_NOTCONFIRM.getValue();
                            }
                            message.setUserIds(Collections.singletonList(cashier.getLong("id")));
                            message.setTemplateNumber(templateNumber);
                            message.setBizDataId(PayBillSyncStatusService.this.bankBillId);
                            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=bei_bankpaybill&pkId=" + PayBillSyncStatusService.this.bankBillId);
                            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ed8\u6b3e\u5355\uff08ID\uff1a%s\uff09\u53d1\u9001\u6d88\u606f\u5931\u8d25\u3002", (String)"PayBillSyncStatusService_5", (String)"fi-cas-business", (Object[])new Object[0]), PayBillSyncStatusService.this.bankBillId) + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\u53d1\u9001\u6d88\u606f", (String)"PayBillSyncStatusService_12", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private boolean isRefund(Pair<String, String> status) {
        return BeBillStatusEnum.TS.getValue().equals(status.getLeft()) && BeBillStatusEnum.TF.getValue().equals(status.getRight());
    }

    private boolean isStatusChanged(Pair<String, String> status) {
        return !((String)status.getLeft()).equals(status.getRight());
    }

    private boolean isSuccess(Pair<String, String> status) {
        return BeBillStatusEnum.TS.getValue().equals(status.getRight());
    }

    @Override
    protected List<AbstractPayBillSyncStatusService.IBranchProcess> getBranchProcessAfter() {
        logger.info("===getBranchProcessAfter===");
        return Arrays.asList(this.writeBackOther(), this.updatePayScheBill(), this.payBillAutoRenote());
    }

    private AbstractPayBillSyncStatusService.IBranchProcess writeBackOther() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                OperateServiceHelper.execOperate((String)"synctrigger", (String)PayBillSyncStatusService.this.payBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{PayBillSyncStatusService.this.payBill}, (OperateOption)OperateOption.create());
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u5199\u5165\u9884\u7b97\u6267\u884c\u6570", (String)"PayBillSyncStatusService_13", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess pushOrCancelIfmAndInnerRec() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                if (BeBillStatusEnum.TS.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                    OperateServiceHelper.execOperate((String)"syncpay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{PayBillSyncStatusService.this.payBill}, (OperateOption)OperateOption.create());
                } else if (BeBillStatusEnum.TF.getValue().equals(PayBillSyncStatusService.this.bankpaystate)) {
                    OperateServiceHelper.execOperate((String)"synccancelpay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{PayBillSyncStatusService.this.payBill}, (OperateOption)OperateOption.create());
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u4e0b\u63a8\u6216\u53d6\u6d88\u4e0b\u63a8\u6536\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u548c\u5185\u90e8\u6536\u6b3e\u5355\u3002", (String)"PayBillSyncStatusService_15", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess payBillAutoRenote() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            public String doBranchProcessWithoutException() {
                long orgId;
                boolean bankAutoRefund;
                if (PayBillSyncStatusService.this.autoRefund && BeBillStatusEnum.TS.getValue().equals(PayBillSyncStatusService.this.bankpaystate) && (bankAutoRefund = SystemParameterHelper.getParameterBoolean((long)(orgId = PayBillSyncStatusService.this.payBill.getDynamicObject("org").getLong("id")), (String)"bank_auto_refund"))) {
                    new RefundService().autoRenote((Long)PayBillSyncStatusService.this.payBill.getPkValue(), "cas_paybill");
                }
                return null;
            }

            public String getProcessName() {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u540c\u6b65\u72b6\u6001\u81ea\u52a8\u9000\u7968\u3002", (String)"PayBillSyncStatusService_16", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }
}

