/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.AcctBalanceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class BalanceCountHelper {
    private static final Log logger = LogFactory.getLog(BalanceCountHelper.class);

    public static BigDecimal getJournalBalamt(BigDecimal journalbalamt, DynamicObject period, Long orgId, Object accountId, Object currencyId, Date endDate) {
        QFilter[] journalBalFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period", "=", period.getPkValue()), new QFilter("accountbank", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("type", "=", (Object)"2")};
        logger.info("----->>> BalanceCountHelper.getJournalBalamt(),journalBalFilters={}", (Object)JSON.toJSONString((Object)journalBalFilters));
        DynamicObject[] journalBal = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, monthstart", (QFilter[])journalBalFilters);
        if (journalBal.length > 0) {
            for (DynamicObject dynamicObject : journalBal) {
                journalbalamt = journalbalamt.add(dynamicObject.getBigDecimal("monthstart"));
            }
        }
        Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        QFilter journalFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", accountId)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("bookdate", ">=", (Object)period.getDate("begindate"))).and(new QFilter("bookdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)));
        journalFilter.and(new QFilter("period", "!=", (Object)0L));
        QFilter[] journalFilters = new QFilter[]{journalFilter};
        logger.info("----->>> BalanceCountHelper.getJournalBalamt(),journalFilters={}", (Object)JSON.toJSONString((Object)journalFilters));
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"1 as group,debitamount-creditamount as factamt", (QFilter[])journalFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                journalbalamt = journalbalamt.add(journalSum);
                logger.info("=======\u65e5\u8bb0\u8d26\u4e1a\u52a1\u6570\u636e\u91d1\u989d\uff1a" + journalSum);
            }
        }
        return journalbalamt;
    }

    public static BigDecimal getCashBalamt(BigDecimal journalbalamt, DynamicObject period, Object accountId, Object currencyId, Date endDate) {
        QFilter[] journalBalFilters = new QFilter[]{new QFilter("period", "=", period.getPkValue()), new QFilter("accountcash", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("type", "=", (Object)"1")};
        DynamicObject[] journalCashBal = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, monthstart", (QFilter[])journalBalFilters);
        if (journalCashBal.length > 0) {
            for (DynamicObject dynamicObject : journalCashBal) {
                journalbalamt = journalbalamt.add(dynamicObject.getBigDecimal("monthstart"));
            }
        }
        QFilter[] journalFilters = new QFilter[]{new QFilter("accountcash", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("bookdate", ">=", (Object)period.getDate("begindate")), new QFilter("bookdate", "<=", (Object)endDate)};
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".cashjournal"), (String)"cas_cashjournal", (String)"1 as group,debitamount-creditamount as factamt", (QFilter[])journalFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                journalbalamt = journalbalamt.add(journalSum);
                logger.info("=======\u73b0\u91d1\u65e5\u8bb0\u8d26\u4e1a\u52a1\u6570\u636e\u91d1\u989d\uff1a" + journalSum);
            }
        }
        return journalbalamt;
    }

    public static BigDecimal getStateBalance(Long accountId, Long currencyId, Date startDate, Date endDate) {
        BigDecimal statmntbalamt = BigDecimal.ZERO;
        Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        QFilter[] statmntFilters = new QFilter[]{new QFilter("accountbank", "=", (Object)accountId), new QFilter("currency", "=", (Object)currencyId), new QFilter("bizdate", ">=", (Object)startDate), new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)), new QFilter("isbank", "=", (Object)"1"), new QFilter("period", "!=", (Object)0L)};
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankstatement"), (String)"cas_bankstatement", (String)"1 as group,creditamount-debitamount as factamt", (QFilter[])statmntFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                statmntbalamt = statmntbalamt.add(((Row)iterator.next()).getBigDecimal("factamt"));
            }
        }
        return statmntbalamt;
    }

    public static BigDecimal getStatmntBalamt(BigDecimal statmntbalamt, DynamicObject period, Object accountId, Object currencyId, Date endDate) {
        return BalanceCountHelper.getStatmntBalamt(statmntbalamt, period, accountId, currencyId, endDate, null);
    }

    public static BigDecimal getStatmntBalamt(BigDecimal statmntbalamt, DynamicObject period, Object accountId, Object currencyId, Date endDate, Date startDate) {
        if (startDate == null) {
            startDate = period.getDate("begindate");
        }
        Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        QFilter[] statmntFilters = new QFilter[]{new QFilter("accountbank", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("bizdate", ">=", (Object)startDate), new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)), new QFilter("isbank", "=", (Object)"1"), new QFilter("period", "!=", (Object)0L)};
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankstatement"), (String)"cas_bankstatement", (String)"1 as group,creditamount-debitamount as factamt", (QFilter[])statmntFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                statmntbalamt = statmntbalamt.add(((Row)iterator.next()).getBigDecimal("factamt"));
            }
        }
        return statmntbalamt;
    }

    public static void getStatemMapByOrg(Map<String, BigDecimal> statmMap, DynamicObject period, Date endDate, Set<Long> acountCurrByOrgs, Map<Long, Set<Long>> acctToCnyMap) {
        QFilter journalFilters = new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)endDate, (int)1)).and(new QFilter("isvalid", "=", (Object)"1")).and(new QFilter("isbank", "=", (Object)"1"));
        ArrayList<QFilter> acctCnyFilterList = new ArrayList<QFilter>(acountCurrByOrgs.size());
        for (Long acountCurrByOrg : acountCurrByOrgs) {
            Set<Long> cnyIdSet;
            QFilter acctCnyFilter = new QFilter("accountbank", "=", (Object)acountCurrByOrg);
            if (acctToCnyMap != null && !EmptyUtil.isEmpty(cnyIdSet = acctToCnyMap.get(acountCurrByOrg))) {
                acctCnyFilter.and("currency", "in", cnyIdSet);
            }
            acctCnyFilterList.add(acctCnyFilter);
        }
        if (!EmptyUtil.isEmpty(acctCnyFilterList)) {
            QFilter allAcctFilter = null;
            for (QFilter filter : acctCnyFilterList) {
                allAcctFilter = allAcctFilter != null ? allAcctFilter.or(filter) : filter;
            }
            journalFilters.and(allAcctFilter);
        }
        if (period != null) {
            journalFilters.and(new QFilter("bizdate", ">=", (Object)period.getDate("begindate")));
        }
        DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".statm"), (String)"cas_bankstatement", (String)"org as orgid,accountbank as accoutid,currency as cuid,creditamount-debitamount as factamt", (QFilter[])new QFilter[]{journalFilters}, null);
        Object object = null;
        try (DataSet finalStatmDataSet = balanceRawDataSet.groupBy(new String[]{"orgid", "accoutid", "cuid"}).sum("factamt").finish();){
            for (Row next : finalStatmDataSet) {
                BigDecimal statemSum = next.getBigDecimal("factamt");
                String key = next.getString("accoutid") + '-' + next.getString("cuid");
                statmMap.put(key, statemSum);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (balanceRawDataSet != null) {
                if (object != null) {
                    try {
                        balanceRawDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    balanceRawDataSet.close();
                }
            }
        }
    }

    public static void getJournalInit(Map<String, BigDecimal> journalMap, Set<Long> accounts, boolean isJournal) {
        if (accounts.size() == 0) {
            return;
        }
        String sumAmount = isJournal ? "journal" : "statm";
        QFilter initFilters = new QFilter("entrybank.bank_accountbank", "in", accounts);
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_cashmgtinit", (String)"org,entrybank.bank_accountbank as accoutid,entrybank.bank_currency as cuid, entrybank.bank_journalbalance as journal,entrybank.bank_statementbalance as statm", (QFilter[])new QFilter[]{initFilters}, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"accoutid", "cuid"}).sum(sumAmount).finish();){
            for (Row next : finalJournalDataSet) {
                BigDecimal journalSum = next.getBigDecimal(sumAmount);
                String key = next.getString("accoutid") + '-' + next.getString("cuid");
                if (isJournal) {
                    key = next.getString("org") + '-' + key;
                }
                journalMap.put(key, journalSum);
            }
        }
    }

    public static Map<String, BigDecimal> getJournalBalance(Long orgId, DynamicObject period) {
        HashMap<String, BigDecimal> journalBalanceMap = new HashMap<String, BigDecimal>();
        if (period == null) {
            logger.error("BalanceCountHelper#getJournalBalance period is null. orgId:{}", (Object)orgId);
            return journalBalanceMap;
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"2"));
        DynamicObject[] journalBals = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, org,accountbank,currency,monthstart", (QFilter[])new QFilter[]{filter});
        if (journalBals != null && journalBals.length > 0) {
            for (DynamicObject journalBal : journalBals) {
                String key = BalanceCountHelper.getMapKey(journalBal.getDynamicObject("org"), journalBal.getDynamicObject("accountbank"), journalBal.getDynamicObject("currency"));
                if (CasHelper.isEmpty((Object)key)) continue;
                journalBalanceMap.put(key, journalBal.getBigDecimal("monthstart"));
            }
        }
        return journalBalanceMap;
    }

    public static Map<String, BigDecimal> getCashBalance(Long orgId, DynamicObject period) {
        HashMap<String, BigDecimal> journalBalanceMap = new HashMap<String, BigDecimal>();
        if (period == null) {
            logger.error("BalanceCountHelper#getCashBalance period is null. orgId:{}", (Object)orgId);
            return journalBalanceMap;
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"1"));
        DynamicObject[] journalBals = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, org,accountcash,currency,monthstart", (QFilter[])new QFilter[]{filter});
        if (journalBals != null && journalBals.length > 0) {
            for (DynamicObject journalBal : journalBals) {
                String key = BalanceCountHelper.getMapKey(journalBal.getDynamicObject("org"), journalBal.getDynamicObject("accountcash"), journalBal.getDynamicObject("currency"));
                if (CasHelper.isEmpty((Object)key)) continue;
                journalBalanceMap.put(key, journalBal.getBigDecimal("monthstart"));
            }
        }
        return journalBalanceMap;
    }

    public static BigDecimal getStatemMonthStart(Long orgId, Long accountId, Long currencyId, DynamicObject period) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", (Object)accountId)).and(new QFilter("currency", "=", (Object)currencyId)).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"3"));
        DynamicObjectCollection journalBals = QueryServiceHelper.query((String)"cas_journalbalance", (String)"id, org,accountbank,currency,monthstart", (QFilter[])new QFilter[]{filter}, (String)"period", (int)1);
        if (journalBals != null && journalBals.size() > 0) {
            return ((DynamicObject)journalBals.get(0)).getBigDecimal("monthstart");
        }
        return BigDecimal.ZERO;
    }

    public static Boolean isExistBalnce(Long orgId, Long accountId, Long currencyId, DynamicObject period) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", (Object)accountId)).and(new QFilter("currency", "=", (Object)currencyId)).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"3"));
        DynamicObjectCollection journalBals = QueryServiceHelper.query((String)"cas_journalbalance", (String)"id, org,accountbank,currency,monthstart", (QFilter[])new QFilter[]{filter}, (String)"period", (int)1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)journalBals)) {
            return false;
        }
        return true;
    }

    public static String getMapKey(DynamicObject org, DynamicObject accountBank, DynamicObject currency) {
        if (CasHelper.isNotEmpty((Object)org) && CasHelper.isNotEmpty((Object)accountBank) && CasHelper.isNotEmpty((Object)currency)) {
            return org.getString("id") + '-' + accountBank.getString("id") + '-' + currency.getString("id");
        }
        return "";
    }

    public static void getJournalMapByOrg(Map<String, BigDecimal> journalMap, Long orgId, DynamicObject period, Date endDate, Set<String> acountCurrByOrgs) {
        Map<String, BigDecimal> journalBalance = BalanceCountHelper.getJournalBalance(orgId, period);
        journalMap.putAll(journalBalance);
        QFilter journalFilters = new QFilter("org", "=", (Object)orgId).and(new QFilter("bookdate", ">=", (Object)period.getDate("begindate"))).and(new QFilter("bookdate", "<", (Object)endDate));
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"org as orgid,accountbank as accoutid,currency as cuid,debitamount-creditamount as factamt", (QFilter[])new QFilter[]{journalFilters}, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"orgid", "accoutid", "cuid"}).sum("factamt").finish();){
            for (Row next : finalJournalDataSet) {
                BigDecimal journalSum = next.getBigDecimal("factamt");
                String key = next.getString("orgid") + '-' + next.getString("accoutid") + '-' + next.getString("cuid");
                if (!acountCurrByOrgs.contains(key)) continue;
                BigDecimal bigDecimal = journalBalance.get(key);
                if (bigDecimal != null) {
                    journalSum = bigDecimal.add(journalSum);
                }
                journalMap.put(key, journalSum);
            }
        }
    }

    public static Set<String> getAcountCurrByOrgs(Set<Long> orgIds) {
        if (orgIds == null || orgIds.size() == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        QFilter filter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company as orgid,currency.fbasedataid.id as currencyid", (QFilter[])new QFilter[]{filter});
        if (colls != null && colls.size() > 0) {
            colls.forEach(coll -> set.add(coll.getString("orgid") + '-' + coll.getString("id") + '-' + coll.getString("currencyid")));
        }
        return set;
    }

    public static Set<String> getAccountKey(String orgId, DynamicObjectCollection colls) {
        HashSet<String> set = new HashSet<String>();
        colls.forEach(coll -> set.add(orgId + '-' + coll.getString("accountbankid") + '-' + coll.getString("currencyid")));
        return set;
    }

    public static DynamicObjectCollection getAcctColl(Long orgId, List<Long> acctIds, List<Long> currenyIds) {
        QFilter filter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgId);
        if (acctIds != null && !acctIds.isEmpty()) {
            filter.and(new QFilter("id", "in", acctIds));
        }
        if (currenyIds != null && !currenyIds.isEmpty()) {
            filter.and(new QFilter("currency.fbasedataid.id", "in", currenyIds));
        }
        DynamicObjectCollection acctPlainColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id as accountbankid,company as orgid,currency.fbasedataid.id as currencyid,bank.bank_cate.id as bankcgsetting", (QFilter[])new QFilter[]{filter});
        return acctPlainColl;
    }

    public static ReturnData searchOriginBalance(Set<Long> accounts, Map<Long, Set<Long>> currencyIdMap, Date endDate) {
        HashMap<String, DynamicObject> returnMonthStart = new HashMap<String, DynamicObject>(16);
        HashMap<String, String> relations = new HashMap<String, String>(16);
        ReturnData returnData = new ReturnData(returnMonthStart, relations);
        QFilter[] qFilters = new QFilter[]{new QFilter("accountbank", "in", accounts), new QFilter("billstatus", "=", (Object)"C")};
        DynamicObjectCollection accountTransfer = QueryServiceHelper.query((String)"am_management_transfer", (String)"id, accountbank, originorg", (QFilter[])qFilters, (String)"modifytime desc");
        if (accountTransfer.isEmpty()) {
            return returnData;
        }
        HashMap<Long, Set<Long>> accountCurrencyIds = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Long> accCreateOrgIds = new HashMap<Long, Long>(16);
        BalanceCountHelper.coaxAccount(accounts, accountCurrencyIds, accCreateOrgIds);
        if (currencyIdMap == null || currencyIdMap.isEmpty()) {
            currencyIdMap = new HashMap<Long, Set<Long>>(16);
            currencyIdMap.putAll(accountCurrencyIds);
        }
        DynamicObjectCollection initBalances = BalanceCountHelper.getInitStatement(accountTransfer);
        Map<Long, DynamicObject> orgInitBalances = initBalances.stream().collect(Collectors.toMap(o -> o.getLong("org"), o -> o, (o1, o2) -> o1));
        Date[] dates = BalanceCountHelper.getDates(initBalances);
        Map<String, BigDecimal> statementBalances = BalanceCountHelper.getStatementStartBalance(accounts, dates);
        for (DynamicObject accTransfer : accountTransfer) {
            Long originOrgId = accTransfer.getLong("originorg");
            Long accountId = accTransfer.getLong("accountbank");
            Set<Long> currencyIds = currencyIdMap.get(accountId);
            Long createOrgId = (Long)accCreateOrgIds.get(accountId);
            for (Long currencyId : currencyIds) {
                String strKey;
                BigDecimal startMonth;
                DynamicObject initBalance = orgInitBalances.get(originOrgId);
                Date periodEndDate = null;
                if (initBalance != null) {
                    periodEndDate = initBalance.getDate("enddate");
                }
                DynamicObject periodBalance = PeriodHelper.getBeginPeriodByDate((Long)originOrgId, (Date)periodEndDate, (Date)endDate);
                Long periodId = periodBalance.getLong("id");
                String returnKey = StringUtils.joinKeyString((String)"-", (Object[])new Object[]{accountId, currencyId});
                if (returnMonthStart.containsKey(returnKey) || (startMonth = statementBalances.get(strKey = StringUtils.joinKeyString((String)"-", (Object[])new Object[]{originOrgId, accountId, currencyId, periodId}))) == null || BigDecimal.ZERO.compareTo(startMonth) == 0) continue;
                MainEntityType journalType = MetadataServiceHelper.getDataEntityType((String)"cas_journalbalance");
                DynamicObject journal = new DynamicObject((DynamicObjectType)journalType);
                journal.set("id", (Object)accTransfer.getLong("id"));
                journal.set("monthstart", (Object)startMonth);
                MainEntityType currencyType = MetadataServiceHelper.getDataEntityType((String)"bd_currency");
                DynamicObject currencyObject = new DynamicObject((DynamicObjectType)currencyType);
                currencyObject.set("id", (Object)currencyId);
                journal.set("currency", (Object)currencyObject);
                returnMonthStart.put(returnKey, journal);
                Date date = returnData.getMiniStartDate();
                if (date == null || date.getTime() > periodBalance.getDate("begindate").getTime()) {
                    returnData.setMiniStartDate(periodBalance.getDate("begindate"));
                }
                if (createOrgId == null) continue;
                String currentKey = StringUtils.joinKeyString((String)"-", (Object[])new Object[]{createOrgId, accountId, currencyId});
                String originKey = StringUtils.joinKeyString((String)"-", (Object[])new Object[]{originOrgId, accountId, currencyId});
                relations.put(originKey, currentKey);
            }
        }
        return returnData;
    }

    private static DynamicObjectCollection getInitStatement(DynamicObjectCollection accountTransfer) {
        Set originOrgIds = accountTransfer.stream().map(o -> o.getLong("originorg")).collect(Collectors.toSet());
        DynamicObjectCollection initBalances = QueryServiceHelper.query((String)"cas_rec_edc", (String)"org, recperiod.enddate as enddate, recperiod.begindate as begindate", (QFilter[])new QFilter[]{new QFilter("org", "in", originOrgIds)});
        return initBalances;
    }

    private static void coaxAccount(Set<Long> accounts, Map<Long, Set<Long>> accountCurrencyIds, Map<Long, Long> accCreateOrgIds) {
        QFilter[] qAccount = new QFilter[]{new QFilter("id", "in", accounts)};
        DynamicObjectCollection accountInfos = QueryServiceHelper.query((String)"am_accountbank", (String)"id, createorg, currency.fbasedataid.id as currencyid", (QFilter[])qAccount);
        for (DynamicObject accountInfo : accountInfos) {
            Long accountId = accountInfo.getLong("id");
            Long currencyId = accountInfo.getLong("currencyid");
            Set<Long> currencyIdSet = accountCurrencyIds.get(accountId);
            if (currencyIdSet == null) {
                currencyIdSet = new HashSet<Long>(16);
                accountCurrencyIds.put(accountId, currencyIdSet);
            }
            currencyIdSet.add(currencyId);
            if (accCreateOrgIds.containsKey(accountId)) continue;
            accCreateOrgIds.put(accountId, accountInfo.getLong("createorg"));
        }
    }

    private static Date[] getDates(DynamicObjectCollection initBalances) {
        Date[] dates = new Date[]{null, null};
        for (DynamicObject initBalance : initBalances) {
            Date initBeginDate = initBalance.getDate("begindate");
            Date initEndDate = initBalance.getDate("enddate");
            Date bDate = dates[0];
            Date eDate = dates[1];
            if (bDate == null || bDate.getTime() > initBeginDate.getTime()) {
                dates[0] = initBeginDate;
            }
            if (eDate != null && eDate.getTime() >= initEndDate.getTime()) continue;
            dates[1] = initEndDate;
        }
        return dates;
    }

    private static Map<String, BigDecimal> getStatementStartBalance(Set<Long> accounts, Date[] dates) {
        QFilter[] filterStm = new QFilter[]{new QFilter("accountbank", "in", accounts), new QFilter("type", "=", (Object)"3"), new QFilter("period.begindate", ">=", (Object)dates[0]), new QFilter("period.enddate", "<=", (Object)dates[1])};
        HashMap<String, BigDecimal> statementBalances = new HashMap<String, BigDecimal>(16);
        try (DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"entity_journalbalance", (String)"cas_journalbalance", (String)"org,accountbank,period,currency,monthstart", (QFilter[])filterStm, null);
             DataSet groupByDataSet = bankAcctSet.groupBy(new String[]{"org", "accountbank", "period", "currency"}).sum("monthstart").finish();){
            groupByDataSet.forEach(row -> {
                Long orgId = row.get("org") == null ? Long.valueOf("0") : (Long)row.get("org");
                Long acctBankId = row.get("accountbank") == null ? Long.valueOf("0") : (Long)row.get("accountbank");
                Long currencyId = row.get("currency") == null ? Long.valueOf("0") : (Long)row.get("currency");
                BigDecimal monthStart = row.get("monthstart") == null ? BigDecimal.ZERO : (BigDecimal)row.get("monthstart");
                Long periodId = row.get("period") == null ? Long.valueOf("0") : (Long)row.get("period");
                statementBalances.put(StringUtils.joinKeyString((String)"-", (Object[])new Object[]{orgId, acctBankId, currencyId, periodId}), monthStart);
            });
        }
        return statementBalances;
    }

    public static class ReturnData {
        private Map<String, DynamicObject> returnData;
        private Map<String, String> relations;
        private Date miniStartDate;
        private BigDecimal balance;

        public ReturnData() {
        }

        public ReturnData(Map<String, DynamicObject> returnData, Map<String, String> relations) {
            this.returnData = returnData;
            this.relations = relations;
        }

        public Map<String, DynamicObject> getReturnData() {
            return this.returnData;
        }

        public Map<String, String> getRelations() {
            return this.relations;
        }

        public Date getMiniStartDate() {
            return this.miniStartDate;
        }

        public void setMiniStartDate(Date miniStartDate) {
            this.miniStartDate = miniStartDate;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public void setBalance(BigDecimal balance) {
            this.balance = balance;
        }
    }
}

