/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class RecBillHepler {
    private static JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    public static boolean isNeedBook(DynamicObject info) {
        boolean isVirtualRec;
        boolean settlePromise = DraftHelper.isSettlePromise((Object)info.get("settletype"));
        if (settlePromise) {
            return false;
        }
        DynamicObject receivingType = info.getDynamicObject("receivingtype");
        boolean bl = isVirtualRec = receivingType != null && "107".equals(receivingType.getString("biztype"));
        return !isVirtualRec;
    }

    public static DynamicObject dealReverse(DynamicObject newRecBill, DynamicObject recBill) {
        boolean isNotice = "cas_claimcenterbill".equals(recBill.getString("sourcebilltype"));
        newRecBill.set("actrecamt", (Object)newRecBill.getBigDecimal("actrecamt").negate());
        newRecBill.set("fee", (Object)newRecBill.getBigDecimal("fee").negate());
        newRecBill.set("localamt", (Object)newRecBill.getBigDecimal("localamt").negate());
        newRecBill.set("billstatus", (Object)"C");
        String generateNumber = CodeRuleHelper.generateNumber((String)"cas_recbill", (DynamicObject)newRecBill, null, null);
        if (StringUtils.isEmpty((CharSequence)generateNumber)) {
            generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        }
        newRecBill.set("billno", (Object)generateNumber);
        newRecBill.set("hotaccount", (Object)"2");
        newRecBill.set("hotedrecvnum", (Object)recBill.getString("billno"));
        newRecBill.set("hotedrecvid", (Object)recBill.getLong("id"));
        newRecBill.set("settleamount", (Object)BigDecimal.ZERO);
        newRecBill.set("settleamountbase", (Object)BigDecimal.ZERO);
        newRecBill.set("isvoucher", null);
        DynamicObjectCollection entrys = newRecBill.getDynamicObjectCollection("entry");
        BigDecimal[] unsettleamount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] unsettleamountbase = new BigDecimal[]{BigDecimal.ZERO};
        entrys.forEach(entry -> {
            entry.set("e_receivableamt", (Object)entry.getBigDecimal("e_receivableamt").negate());
            entry.set("e_receivablelocamt", (Object)entry.getBigDecimal("e_receivablelocamt").negate());
            entry.set("e_discountamt", (Object)entry.getBigDecimal("e_discountamt").negate());
            entry.set("e_discountlocamt", (Object)entry.getBigDecimal("e_discountlocamt").negate());
            entry.set("e_fee", (Object)entry.getBigDecimal("e_fee").negate());
            entry.set("e_actamt", (Object)entry.getBigDecimal("e_actamt").negate());
            entry.set("e_localamt", (Object)entry.getBigDecimal("e_localamt").negate());
            entry.set("e_lockamt", (Object)entry.getBigDecimal("e_lockamt").negate());
            entry.set("e_unlockamt", (Object)entry.getBigDecimal("e_unlockamt").negate());
            entry.set("e_settledamt", (Object)BigDecimal.ZERO);
            entry.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
            entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_receivableamt"));
            unsettleamount[0] = unsettleamount[0].add(entry.getBigDecimal("e_receivableamt"));
            entry.set("e_unsettledlocalamt", (Object)entry.getBigDecimal("e_receivablelocamt"));
            unsettleamountbase[0] = unsettleamountbase[0].add(entry.getBigDecimal("e_receivablelocamt"));
        });
        newRecBill.set("unsettleamount", (Object)unsettleamount[0]);
        newRecBill.set("unsettleamountbase", (Object)unsettleamountbase[0]);
        if (!isNotice) {
            newRecBill.set("sourcebilltype", (Object)"cas_recbill");
            newRecBill.set("sourcebillid", (Object)String.valueOf(recBill.getPkValue()));
        }
        newRecBill.set("matchamountrec", (Object)newRecBill.getBigDecimal("matchamountrec").negate());
        newRecBill.set("unmatchamountrec", (Object)newRecBill.getBigDecimal("unmatchamountrec").negate());
        newRecBill.set("matchamountpay", (Object)newRecBill.getBigDecimal("matchamountpay").negate());
        newRecBill.set("unmatchamountpay", (Object)newRecBill.getBigDecimal("unmatchamountpay").negate());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newRecBill});
        OperateOption option = OperateOption.create();
        option.setVariableValue("isLock", "true");
        option.setVariableValue("isHot", "true");
        option.setVariableValue("blueBillId", recBill.getLong("id") + "");
        OperationResult operationResult = OperateServiceHelper.execOperateWithoutThrow((String)"receivingrec", (String)"cas_recbill", (Object[])new Object[]{newRecBill.getPkValue()}, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(OperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
        }
        return newRecBill;
    }

    public static DynamicObject dealReverse(DynamicObject recBill, Date bizDate) {
        recBill.set("hotaccount", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
        DynamicObject newRecBill = (DynamicObject)OrmUtils.clone((Object)recBill, (IDataEntityType)recBill.getDataEntityType(), (boolean)true, (boolean)true);
        newRecBill.set("bizdate", (Object)bizDate);
        return RecBillHepler.dealReverse(newRecBill, recBill);
    }

    public static DynamicObject dealReverse(DynamicObject recBill) {
        recBill.set("hotaccount", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
        DynamicObject newRecBill = (DynamicObject)OrmUtils.clone((Object)recBill, (IDataEntityType)recBill.getDataEntityType(), (boolean)true, (boolean)true);
        return RecBillHepler.dealReverse(newRecBill, recBill);
    }

    public static void checkJournal(DynamicObject info) {
        DynamicObject[] bills;
        Boolean isBillBook = false;
        DynamicObject org = info.getDynamicObject("org");
        if (org != null) {
            isBillBook = SystemParameterHelper.isBillBookJournal((long)org.getLong("id"));
        }
        if (isBillBook.booleanValue()) {
            QFilter filter = new QFilter("sourcebilltype", "=", (Object)info.getDynamicObjectType().getName()).and("sourcebillid", "=", (Object)info.getString("id"));
            DeleteServiceHelper.delete((String)"cas_bankjournal", (QFilter[])new QFilter[]{filter});
        }
        if (CasHelper.isNotEmpty((Object)(bills = BusinessDataServiceHelper.load((String)info.getDynamicObjectType().getName(), (String)"id,hotaccount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)info.getLong("sourcebillid"))}))) && bills.length > 0) {
            DynamicObject bill = bills[0];
            bill.set("hotaccount", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
    }

    public static DynamicObject matchByName(Long orgId, String name) {
        DynamicObject userobject;
        String basedataSelector = "id,name,number";
        QFilter filter = new QFilter("name", "=", (Object)name);
        String[] oppType = new String[]{"bd_customer", "bd_supplier"};
        for (int i = 0; i < oppType.length; ++i) {
            DynamicObjectCollection customerOrSupplier = BaseDataServiceHelper.queryBaseData((String)oppType[i], (Long)orgId, (QFilter)filter, (String)basedataSelector);
            if (customerOrSupplier == null || customerOrSupplier.isEmpty()) continue;
            return (DynamicObject)customerOrSupplier.get(0);
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)basedataSelector, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        if (org != null) {
            for (int i = 0; i < oppType.length; ++i) {
                DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingleFromCache((String)oppType[i], (String)basedataSelector, (QFilter[])new QFilter[]{new QFilter("internal_company", "=", (Object)org.getLong("id"))});
                if (customerOrSupplier == null) continue;
                return customerOrSupplier;
            }
        }
        if ((userobject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)basedataSelector, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)})) != null) {
            return userobject;
        }
        return null;
    }

    public static void genIfmRecBill(DynamicObject recBill) {
        if (RecBillHepler.isSettleCenterAndCompany(recBill)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult operationResult = OperateServiceHelper.executeOperate((String)"pushifmrec", (String)"cas_recbill", (Object[])new Object[]{recBill.getLong("id")}, (OperateOption)option);
            if (!operationResult.isSuccess()) {
                throw new KDBizException(RecBillHepler.decodeErrorMsg(operationResult));
            }
        }
    }

    private static boolean isSettleCenterAndCompany(DynamicObject recBill) {
        String receivingType = recBill.getDynamicObject("receivingtype").getString("biztype");
        return receivingType.equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue());
    }

    public static String decodeErrorMsg(OperationResult operationResult) {
        String errMsg;
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            errMsg = RecBillHepler.decodeMultiErrorMsg(operationResult);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            errMsg = errorInfo.getMessage();
        } else {
            errMsg = operationResult.getMessage();
        }
        return errMsg;
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder buf = new StringBuilder();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append('\n');
        }
        return buf.toString();
    }

    public static boolean existsRecBill(Long draftBillId) {
        QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", (Object)draftBillId);
        filter.and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
        filter.and("hotaccount", "=", (Object)"");
        DynamicObject objs = BusinessDataServiceHelper.loadSingle((String)"cas_recbill", (String)"id", (QFilter[])new QFilter[]{filter});
        return objs != null && objs.getLong("id") != 0L;
    }

    public static void dealMatchInfo(DynamicObject recBill) {
        String sourceBillType;
        String payerType = recBill.getString("payertype");
        Long payerId = recBill.getLong("payer");
        Long payeeId = recBill.getDynamicObject("org").getLong("id");
        if ("bos_org".equals(payerType) && payeeId.compareTo(payerId) == 0) {
            boolean cs1047 = SystemParameterHelper.getParameterBoolean((long)recBill.getDynamicObject("org").getLong("id"), (String)"cs1047");
            recBill.set("relateotherflow", (Object)cs1047);
        } else {
            recBill.set("relateotherflow", (Object)false);
        }
        BigDecimal matchPayAmt = recBill.getBigDecimal("matchamountpay");
        if (matchPayAmt.compareTo(BigDecimal.ZERO) == 0) {
            recBill.set("matchamountpay", (Object)BigDecimal.ZERO);
            recBill.set("unmatchamountpay", (Object)recBill.getBigDecimal("actrecamt"));
        }
        if ("bei_intelrec".equals(sourceBillType = recBill.getString("sourcebilltype")) || "cas_claimcenterbill".equals(sourceBillType)) {
            recBill.set("matchamountrec", (Object)recBill.getBigDecimal("actrecamt"));
            recBill.set("unmatchamountrec", (Object)BigDecimal.ZERO);
            recBill.set("matchflag", (Object)"1");
        } else if (kd.fi.cas.util.StringUtils.isEmpty((String)recBill.getString("matchflag")) || "0".equals(recBill.getString("matchflag"))) {
            recBill.set("matchamountrec", (Object)BigDecimal.ZERO);
            recBill.set("unmatchamountrec", (Object)recBill.getBigDecimal("actrecamt"));
            recBill.set("matchflag", (Object)"0");
        }
        Map tMatchResult = AutoMatchHelper.getMatchAmount((BigDecimal)BigDecimal.ZERO, (BigDecimal)recBill.getBigDecimal("matchamountrec"), (BigDecimal)recBill.getBigDecimal("unmatchamountrec"), (Boolean)recBill.getBoolean("relateotherflow"), (BigDecimal)recBill.getBigDecimal("matchamountpay"), (BigDecimal)recBill.getBigDecimal("unmatchamountpay"));
        AutoMatchHelper.initMatchAmount((DynamicObject)recBill, (Map)tMatchResult, (String)"matchamountrec", (String)"unmatchamountrec", (String)"matchflag", (String)"matchflagmsg");
    }
}

