/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.func.BaseDataBean;
import kd.bos.ext.fi.func.BasedataMatcher;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.builder.FormulaGetHandle;
import kd.fi.cas.builder.ISingleTaskContext;
import kd.fi.cas.builder.SingleTaskContext;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RecPayRuleHelper {
    private static final Log LOGGER = LogFactory.getLog(RecPayRuleHelper.class);
    private static final String UP_BILL = "upbill";
    private static final String DOWN_BILL = "downbill";
    private static final String selectProperties = "id,enable,biztype,org_entry.u_org,entryentity.e_rulesname,entryentity.e_datafilterdesc,entryentity.e_datafilter_TAG,entryentity.e_datafilter,entryentity.e_receivingtype,entryentity.e_payertype,entryentity.e_payertype,entryentity.e_paymenttype,entryentity.e_payeetype,entryentity.e_fundflowitem,entryentity.e_remark,entryentity.e_savenotifi,entryentity.e_savenotifi_TAG,entryentity.e_handlescheme,entryentity.e_payer,entryentity.e_payerbasetype,entryentity.e_payerid,entryentity.e_recer,entryentity.e_recerbasetype,entryentity.e_recerid,entryentity.e_handlebill";
    private static final Log logger = LogFactory.getLog(RecPayRuleHelper.class);

    public static Map<Long, Pair<String, Map<String, Object>>> getBillNameByMatchRuleApiFill(Object[] ids, String type) {
        HashMap<Long, Pair<String, Map<String, Object>>> pairHashMap = new HashMap<Long, Pair<String, Map<String, Object>>>(ids.length);
        if (StringUtils.isBlank((CharSequence)type) || EmptyUtil.isEmpty((Object[])ids)) {
            return null;
        }
        List list = Arrays.asList(ids).stream().map(o -> (Long)o).collect(Collectors.toList());
        block0: for (int i = 0; i < list.size(); ++i) {
            HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
            Long aLong = (Long)list.get(i);
            QFilter filter = new QFilter("id", "=", (Object)aLong);
            DynamicObjectCollection detailAllDys = RecPayRuleHelper.getBankDetailDy(fldProperties, new QFilter[]{filter});
            if (detailAllDys == null) {
                pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
                continue;
            }
            DynamicObject rule = RecPayRuleHelper.getMatchingRule((DynamicObject)detailAllDys.get(0), type, "rule", false);
            if (CasHelper.isEmpty((Object)rule)) {
                pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
                continue;
            }
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
                continue;
            }
            String bill = null;
            for (int j = 0; j < entryentity.size(); ++j) {
                DynamicObject entryrule = (DynamicObject)entryentity.get(j);
                if (!"rule".equals(entryrule.getString("e_handlescheme"))) continue;
                bill = RecPayRuleHelper.matchRuleBill(entryrule, (DynamicObject)detailAllDys.get(0), fldProperties);
                if (bill == null) {
                    pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
                    continue;
                }
                if (UP_BILL.equals(bill) || DOWN_BILL.equals(bill)) {
                    pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)bill, RecPayRuleHelper.getFillInfo(type, entryrule, (DynamicObject)detailAllDys.get(0))));
                    continue block0;
                }
                pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, RecPayRuleHelper.getFillInfo(type, entryrule, (DynamicObject)detailAllDys.get(0))));
                continue block0;
            }
        }
        return pairHashMap;
    }

    public static HashMap<Long, String> getBillNameByMatchRuleApi(Object[] ids, String type) {
        if (StringUtils.isBlank((CharSequence)type) || ids == null || ids.length == 0) {
            return null;
        }
        HashMap<Long, String> map = new HashMap<Long, String>(ids.length);
        List list = Arrays.asList(ids).stream().map(o -> (Long)o).collect(Collectors.toList());
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
            Long aLong = (Long)list.get(i);
            QFilter filter = new QFilter("id", "=", (Object)aLong);
            DynamicObjectCollection detailAllDys = RecPayRuleHelper.getBankDetailDy(fldProperties, new QFilter[]{filter});
            if (detailAllDys == null) {
                map.put(aLong, type);
                continue;
            }
            DynamicObject rule = RecPayRuleHelper.getMatchingRule((DynamicObject)detailAllDys.get(0), type, "rule", false);
            if (CasHelper.isEmpty((Object)rule)) {
                map.put(aLong, type);
                continue;
            }
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                map.put(aLong, type);
                continue;
            }
            String bill = null;
            for (int j = 0; j < entryentity.size(); ++j) {
                DynamicObject entryrule = (DynamicObject)entryentity.get(j);
                if (!"rule".equals(entryrule.getString("e_handlescheme")) || (bill = RecPayRuleHelper.matchRuleBill(entryrule, (DynamicObject)detailAllDys.get(0), fldProperties)) == null) continue;
                if (UP_BILL.equals(bill) || DOWN_BILL.equals(bill)) {
                    map.put(aLong, bill);
                    break;
                }
                map.put(aLong, type);
                break;
            }
            if (bill != null) continue;
            map.put(aLong, type);
        }
        return map;
    }

    private static boolean isMatchFcaDefaultRule(DynamicObject dynamicObject) {
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return false;
        }
        Long company = dynamicObject.getLong("company.id");
        Long account = dynamicObject.getLong("accountbank.id");
        String sonAcct = dynamicObject.getString("oppbanknumber");
        if (EmptyUtil.isEmpty((Long)company) || EmptyUtil.isEmpty((Long)account) || EmptyUtil.isEmpty((String)sonAcct)) {
            return false;
        }
        boolean isUnAcctGroup = RecPayRuleHelper.getFcaParameterBoolean(company, "isunacctgroup");
        return isUnAcctGroup ? RecPayRuleHelper.isUnAcctGroup(account, sonAcct) : RecPayRuleHelper.unAcctGroup(account, sonAcct);
    }

    private static boolean unAcctGroup(Long acctId, String sonAcct) {
        DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)acctId, (String)"bd_accountbanks", (String)"createorg");
        if (EmptyUtil.isEmpty((DynamicObject)acct)) {
            return false;
        }
        DynamicObject[] son = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)sonAcct)});
        if (son == null || son.length == 0) {
            return false;
        }
        DynamicObject[] acctGroup = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountbank", "=", (Object)acctId)});
        if (acctGroup == null || acctGroup.length == 0) {
            return false;
        }
        List ids = Arrays.stream(acctGroup).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] acctGroups = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fca_acctgroup"));
        boolean flag = false;
        for (DynamicObject dynamicObject2 : acctGroups) {
            DynamicObjectCollection sons = dynamicObject2.getDynamicObjectCollection("entrys");
            Set sonIds = sons.stream().map(e -> e.getDynamicObject("bankacct").getLong("id")).collect(Collectors.toSet());
            if (!sonIds.contains(son[0].getLong("id"))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean isUnAcctGroup(Long acctId, String sonAcct) {
        DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)acctId, (String)"bd_accountbanks", (String)"createorg");
        if (EmptyUtil.isEmpty((DynamicObject)acct)) {
            return false;
        }
        DynamicObject org = acct.getDynamicObject("createorg");
        DynamicObject[] group = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("company", "=", (Object)org.getLong("id"))});
        if (group == null || group.length == 0) {
            return false;
        }
        DynamicObject[] son = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)sonAcct)});
        if (son == null || son.length == 0) {
            return false;
        }
        DynamicObject[] acctGroup = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)son[0].getLong("id"))});
        return acctGroup != null && acctGroup.length != 0;
    }

    private static boolean getFcaParameterBoolean(long orgId, String key) {
        AppParam appParam = new AppParam();
        appParam.setOrgId(Long.valueOf(orgId));
        appParam.setViewType("08");
        appParam.setAppId("/WJL3RFSDXE9");
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
        if (value == null) {
            return false;
        }
        return value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(value);
    }

    public static Map<String, Object> getInfoByMatchRule(DynamicObject dy, String type) {
        DynamicObject rule;
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        Long sourcebillid = dy.getLong("sourcebillid");
        QFilter filter = new QFilter("id", "=", (Object)sourcebillid);
        DynamicObjectCollection detailAllDys = RecPayRuleHelper.getBankDetailDy(fldProperties, new QFilter[]{filter});
        if (detailAllDys == null) {
            return null;
        }
        HashMap<String, Object> ruleMap = new HashMap<String, Object>();
        String entityName = "rec".equals(type) ? "bei_intelrec" : "bei_intelpay";
        DynamicObject transDetail = QueryServiceHelper.queryOne((String)entityName, (String)"rulename", (QFilter[])new QFilter("id", "=", (Object)sourcebillid).toArray());
        String ruleName = transDetail.getString("rulename");
        if (StringUtils.isNotBlank((CharSequence)ruleName)) {
            DynamicObjectCollection entryentity;
            List ruleEntry;
            QFilter qFilter;
            QFilter orgCommonFilter = RecPayRuleHelper.getRuleCommonFilter((DynamicObject)detailAllDys.get(0), type, false);
            rule = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (String)selectProperties, (QFilter[])new QFilter[]{orgCommonFilter, qFilter = new QFilter("entryentity.e_rulesname", "=", (Object)ruleName)});
            if (rule == null) {
                QFilter allCommonFilter = RecPayRuleHelper.getRuleCommonFilter((DynamicObject)detailAllDys.get(0), type, true);
                rule = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (String)selectProperties, (QFilter[])new QFilter[]{allCommonFilter, qFilter});
            }
            if (rule != null && EmptyUtil.isNoEmpty(ruleEntry = (entryentity = rule.getDynamicObjectCollection("entryentity")).stream().filter(e -> ruleName.equals(e.getString("e_rulesname")) && "rule".equals(e.getString("e_handlescheme"))).collect(Collectors.toList()))) {
                DynamicObject matchRule = (DynamicObject)ruleEntry.get(0);
                return RecPayRuleHelper.getFillInfo(type, matchRule, (DynamicObject)detailAllDys.get(0));
            }
        } else {
            rule = RecPayRuleHelper.getMatchingRule((DynamicObject)detailAllDys.get(0), type, "rule", false);
        }
        if (rule == null) {
            return null;
        }
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return null;
        }
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject entryrule = (DynamicObject)entryentity.get(i);
            if (!"rule".equals(entryrule.getString("e_handlescheme")) || !RecPayRuleHelper.isMatchRule(entryrule, (DynamicObject)detailAllDys.get(0), fldProperties)) continue;
            return RecPayRuleHelper.getFillInfo(type, entryrule, (DynamicObject)detailAllDys.get(0));
        }
        return ruleMap;
    }

    private static Map<String, Object> getFillInfo(String type, DynamicObject entryRule, DynamicObject detail) {
        String e_remark;
        Object payerValue;
        HashMap<String, Object> ruleMap = new HashMap<String, Object>(8);
        if ("rec".equals(type)) {
            String e_payertype = entryRule.getString("e_payertype");
            ruleMap.put("e_receivingtype", entryRule.getDynamicObject("e_receivingtype"));
            ruleMap.put("e_payertype", e_payertype);
            String e_payer = entryRule.getString("e_payer");
            payerValue = RecPayRuleHelper.dealPayerValue(detail, entryRule);
            if (!EmptyUtil.isEmpty((Object)payerValue)) {
                ruleMap.put("e_payer", payerValue);
            } else if (!CasHelper.isEmpty((Object)e_payer)) {
                ruleMap.put("e_payer", e_payer);
            } else {
                ruleMap.put("e_payer", null);
            }
        }
        if ("pay".equals(type)) {
            String payeetype = entryRule.getString("e_payeetype");
            ruleMap.put("e_paymenttype", entryRule.getDynamicObject("e_paymenttype"));
            ruleMap.put("e_payeetype", payeetype);
            String e_recer = entryRule.getString("e_recer");
            payerValue = RecPayRuleHelper.dealPayerValue(detail, entryRule);
            if (!EmptyUtil.isEmpty((Object)payerValue)) {
                ruleMap.put("e_recer", payerValue);
            } else if (!CasHelper.isEmpty((Object)e_recer)) {
                ruleMap.put("e_recer", e_recer);
            } else {
                ruleMap.put("e_recer", null);
            }
        }
        String e_rulesname = entryRule.getString("e_rulesname");
        ruleMap.put("e_rulesname", e_rulesname);
        DynamicObject e_fundflowitem = entryRule.getDynamicObject("e_fundflowitem");
        if (!CasHelper.isEmpty((Object)e_fundflowitem)) {
            ruleMap.put("e_fundflowitem", entryRule.getDynamicObject("e_fundflowitem"));
        }
        if (!CasHelper.isEmpty((Object)(e_remark = entryRule.getString("e_remark")))) {
            ruleMap.put("e_remark", entryRule.getString("e_remark"));
        }
        return ruleMap;
    }

    public static String getNameByDetailApi(DynamicObject detailDy) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        Object pkValue = detailDy.getPkValue();
        QFilter filter = new QFilter("id", "=", pkValue);
        DynamicObjectCollection detailAllDys = RecPayRuleHelper.getBankDetailDy(fldProperties, new QFilter[]{filter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)detailAllDys)) {
            return "";
        }
        return RecPayRuleHelper.getMatchRuleName((DynamicObject)detailAllDys.get(0), fldProperties);
    }

    public static void asynRecPayRuleWriteByOrgAndType(Set<Object> diffOrgSet, DynamicObject recPayRule, boolean isDeleteDisEnable) {
        ThreadPools.executeOnceIncludeRequestContext((String)"asynRecPayRuleWriteByOrgAndType", () -> RecPayRuleHelper.recPayRuleWriteByOrgAndType(diffOrgSet, recPayRule, isDeleteDisEnable));
    }

    public static DynamicObject getClaimInfoByMatchRule(Long sourcebillid, String type, String includePay) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        QFilter filter = new QFilter("id", "=", (Object)sourcebillid);
        DynamicObjectCollection detailAllDys = RecPayRuleHelper.getBankDetailDy(fldProperties, new QFilter[]{filter});
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)detailAllDys)) {
            DynamicObjectCollection entryentity;
            DynamicObject rule = null;
            if (StringUtils.equals((CharSequence)"claim", (CharSequence)includePay)) {
                rule = RecPayRuleHelper.getMatchingRule((DynamicObject)detailAllDys.get(0), type, "recv", false);
            } else if (StringUtils.equals((CharSequence)"all", (CharSequence)includePay)) {
                rule = RecPayRuleHelper.getMatchingRule((DynamicObject)detailAllDys.get(0), type, "recv", true);
            }
            if (rule != null && !CasHelper.isEmpty(rule) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryentity = rule.getDynamicObjectCollection("entryentity")))) {
                for (int i = 0; i < entryentity.size(); ++i) {
                    DynamicObject entryrule = (DynamicObject)entryentity.get(i);
                    if (!"recv".equals(entryrule.getString("e_handlescheme")) || !RecPayRuleHelper.isMatchRule(entryrule, (DynamicObject)detailAllDys.get(0), fldProperties)) continue;
                    return entryrule;
                }
            }
        }
        return null;
    }

    public static Set<Object> getEntryOrg(DynamicObject recPayRule) {
        DynamicObjectCollection entryRows = recPayRule.getDynamicObjectCollection("org_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryRows)) {
            return null;
        }
        return entryRows.stream().map(o -> o.getDynamicObject("u_org")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
    }

    public static Set<String> getEntryRuleName(DynamicObject recPayRule) {
        DynamicObjectCollection entryRows = recPayRule.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryRows)) {
            return new HashSet<String>();
        }
        return entryRows.stream().map(o -> o.getString("e_rulesname")).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static String getMatchRuleName(DynamicObject detailAllDy, DynamicObject recPayRule, Map<String, DynamicProperty> fldProperties) {
        DynamicObjectCollection entryEntity;
        String ruleName = " ";
        if (recPayRule != null && recPayRule.getBoolean("enable") && !(entryEntity = recPayRule.getDynamicObjectCollection("entryentity")).isEmpty()) {
            for (DynamicObject rule : entryEntity) {
                if (!RecPayRuleHelper.isMatchRule(rule, detailAllDy, fldProperties)) continue;
                return rule.getString("e_rulesname");
            }
        }
        return ruleName;
    }

    private static String getMatchRuleName(DynamicObject detailAllDy, Map<String, DynamicProperty> fldProperties) {
        BigDecimal creditAmount = detailAllDy.getBigDecimal("creditamount");
        BigDecimal debitAmount = detailAllDy.getBigDecimal("debitamount");
        if (BigDecimal.ZERO.compareTo(creditAmount) != 0 && BigDecimal.ZERO.compareTo(debitAmount) != 0) {
            return " ";
        }
        String type = "";
        if (BigDecimal.ZERO.compareTo(creditAmount) != 0) {
            type = "rec";
        }
        if (BigDecimal.ZERO.compareTo(debitAmount) != 0) {
            type = "pay";
        }
        DynamicObject rule = RecPayRuleHelper.getMatchingRule(detailAllDy, type, "rule", true);
        return RecPayRuleHelper.getMatchRuleName(detailAllDy, rule, fldProperties);
    }

    private static void recPayRuleWriteByOrgAndType(Set<Object> diffOrgSet, DynamicObject recPayRule, boolean isDeleteDisable) {
        LOGGER.info("recPayRuleWriteByOrgAndType begin");
        QFilter receredFilter = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
        if (!CollectionUtils.isEmpty(diffOrgSet)) {
            receredFilter.and(new QFilter("company", "in", diffOrgSet));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        Date beginDate = DateUtils.getDataFormat((Date)calendar.getTime(), (boolean)true);
        QFilter dateDetailFilter = new QFilter("modifytime", ">=", (Object)beginDate);
        QFilter claimnoticebillfilter = new QFilter("claimnoticebillno", "=", (Object)" ");
        QFilter amountFilter = null;
        if ("rec".equals(recPayRule.getString("biztype"))) {
            amountFilter = new QFilter("creditamount", "!=", (Object)0);
        }
        if ("pay".equals(recPayRule.getString("biztype"))) {
            amountFilter = new QFilter("debitamount", "!=", (Object)0);
        }
        if (isDeleteDisable) {
            QFilter ruleNameFilter;
            DynamicObject[] dynamicObjects;
            Set ruleNames = recPayRule.getDynamicObjectCollection("entryentity").stream().map(r -> r.getString("e_rulesname")).collect(Collectors.toSet());
            if (!ruleNames.isEmpty() && (dynamicObjects = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,rulename", (QFilter[])new QFilter[]{receredFilter, amountFilter, dateDetailFilter, claimnoticebillfilter, ruleNameFilter = new QFilter("ruleName", "in", ruleNames)})).length != 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("rulename", (Object)" ");
                }
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                    LOGGER.info("\u4ea4\u6613\u660e\u7ec6\u8de8\u5e94\u7528\u4fdd\u5b58\u6210\u529f: {}", (Object)dynamicObjects.length);
                }
            }
        } else {
            HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(16);
            DynamicObjectCollection detailDys = RecPayRuleHelper.getBankDetailDy(fldProperties, new QFilter[]{receredFilter, amountFilter, dateDetailFilter, claimnoticebillfilter});
            if (detailDys != null && !detailDys.isEmpty()) {
                HashSet details = new HashSet(detailDys.size());
                HashMap<String, Set> ruleNameMap = new HashMap<String, Set>(16);
                for (DynamicObject detailDy : detailDys) {
                    String matchRuleName = RecPayRuleHelper.getMatchRuleName(detailDy, recPayRule, fldProperties);
                    ruleNameMap.computeIfAbsent(matchRuleName, k -> new HashSet());
                    ruleNameMap.computeIfPresent(matchRuleName, (k, v) -> {
                        v.add(detailDy.getLong("id"));
                        return v;
                    });
                }
                for (Map.Entry entry : ruleNameMap.entrySet()) {
                    ((Set)entry.getValue()).forEach(id -> {
                        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
                        dynamicObject.set("id", id);
                        dynamicObject.set("rulename", entry.getKey());
                        details.add(dynamicObject);
                    });
                }
                if (!details.isEmpty()) {
                    try (TXHandle tx = TX.requiresNew();){
                        SaveServiceHelper.update((DynamicObject[])details.toArray(new DynamicObject[0]));
                        LOGGER.info("\u4ea4\u6613\u660e\u7ec6\u8de8\u5e94\u7528\u4fdd\u5b58\u6210\u529f: {}", (Object)details.size());
                    }
                }
            }
        }
    }

    private static DynamicObjectCollection getBankDetailDy(Map<String, DynamicProperty> fldProperties, QFilter[] filters) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias()) || prop.getName().contains("_id")) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias()) || tp.getName().contains("_id")) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        String selectString = StringUtils.join((Object[])selProps.toArray(new Object[selProps.size()]), (String)",");
        DynamicObjectCollection rows = null;
        DataSet dsn = QueryServiceHelper.queryDataSet((String)RecPayRuleHelper.class.getName(), (String)"bei_transdetail_cas", (String)selectString, (QFilter[])filters, null);
        Object object = null;
        try {
            rows = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        catch (Throwable bdProperties) {
            object = bdProperties;
            throw bdProperties;
        }
        finally {
            if (dsn != null) {
                if (object != null) {
                    try {
                        dsn.close();
                    }
                    catch (Throwable bdProperties) {
                        ((Throwable)object).addSuppressed(bdProperties);
                    }
                } else {
                    dsn.close();
                }
            }
        }
        if (rows != null && !rows.isEmpty() && fldProperties != null) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            for (String prop : selProps) {
                fldProperties.put(prop, dType.getProperty(prop));
            }
        }
        int rowsize = rows == null ? 0 : rows.size();
        LOGGER.info("\u5f97\u5230\u8f6c\u6362\u540e\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u4e3a: " + rowsize + "");
        return rows;
    }

    private static boolean isMatchRule(DynamicObject entryrule, DynamicObject detailDy, Map<String, DynamicProperty> fldProperties) {
        String bill;
        boolean isMatchRule = false;
        String filterStr = entryrule.containsProperty("e_datafilter_TAG") && StringUtils.isNotBlank((CharSequence)entryrule.getString("e_datafilter_TAG")) ? entryrule.getString("e_datafilter_TAG") : entryrule.getString("e_datafilter");
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                    if (baseBoolean.booleanValue()) {
                        isMatchRule = true;
                    }
                }
                catch (Exception ee) {
                    LOGGER.info("\u5339\u914d\u5f02\u5e38\uff0c%s", (Object)ee.toString());
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        if (isMatchRule && (UP_BILL.equals(bill = entryrule.getString("e_handlebill")) || DOWN_BILL.equals(bill)) && !RecPayRuleHelper.isMatchFcaDefaultRule(detailDy)) {
            return false;
        }
        return isMatchRule;
    }

    private static String matchRuleBill(DynamicObject entryrule, DynamicObject detailDy, Map<String, DynamicProperty> fldProperties) {
        String bill = null;
        String filterStr = entryrule.getString("e_datafilter_TAG");
        if (!CasHelper.isEmpty((Object)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                    if (baseBoolean.booleanValue()) {
                        bill = entryrule.getString("e_handlebill");
                    }
                }
                catch (Exception ee) {
                    LOGGER.info("\u5339\u914d\u5f02\u5e38\uff0c%s", (Object)ee.toString());
                }
            } else {
                bill = entryrule.getString("e_handlebill");
            }
        } else {
            bill = entryrule.getString("e_handlebill");
        }
        if (bill != null && (UP_BILL.equals(bill) || DOWN_BILL.equals(bill)) && !RecPayRuleHelper.isMatchFcaDefaultRule(detailDy)) {
            return null;
        }
        return bill;
    }

    private static DynamicObject getMatchingRule(DynamicObject detailAllDys, String type, String dealBizType, boolean isWriteBack) {
        QFilter ruleCommonFilter = RecPayRuleHelper.getRuleCommonFilter(detailAllDys, type, false, dealBizType, isWriteBack);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"cas_recpayrule", (String)selectProperties, (QFilter[])new QFilter[]{ruleCommonFilter});
        if (rules.length == 0) {
            ruleCommonFilter = RecPayRuleHelper.getRuleCommonFilter(detailAllDys, type, true, dealBizType, isWriteBack);
            rules = BusinessDataServiceHelper.load((String)"cas_recpayrule", (String)selectProperties, (QFilter[])new QFilter[]{ruleCommonFilter});
        }
        if (rules.length == 0) {
            return null;
        }
        return rules[0];
    }

    private static QFilter getRuleCommonFilter(DynamicObject detailDy, String type, Boolean isFaceAllOrg, String dealBizType, Boolean isWriteBack) {
        Object company = detailDy.get("company.id");
        QFilter filter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1"));
        if (!isWriteBack.booleanValue() && !"pay".equals(type)) {
            filter.and(new QFilter("entryentity.e_handlescheme", "=", (Object)dealBizType));
        }
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", company));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org").or("org_entry.u_org", "=", null));
        }
        return filter;
    }

    private static QFilter getRuleCommonFilter(DynamicObject detailDy, String type, Boolean isFaceAllOrg) {
        Object company = detailDy.get("company.id");
        QFilter filter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("entryentity.e_handlescheme", "=", (Object)"rule"));
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", company));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org").or("org_entry.u_org", "=", null));
        }
        return filter;
    }

    private static Object dealPayerValue(DynamicObject detailDO, DynamicObject entryrule) {
        String filterStr = entryrule.getString("e_datafilter_TAG");
        if (!EmptyUtil.isEmpty((String)filterStr) && (filterStr.contains("IsCustomer") || filterStr.contains("IsSupplier"))) {
            Long companyId;
            String oppunitName;
            Object pkValue;
            DynamicObject detailDY;
            BaseDataBean baseDataBean;
            String entityName = AsstActTypeEnum.CUSTOMER.getValue();
            if (filterStr.contains("IsSupplier")) {
                entityName = AsstActTypeEnum.SUPPLIER.getValue();
            }
            if ((baseDataBean = new BasedataMatcher().dealCustomerOrSupplier(entityName, detailDY = QueryServiceHelper.queryOne((String)"bei_transdetail_cas", (String)"company.id,oppunit,oppbanknumber,billno", (QFilter[])new QFilter("id", "=", pkValue = detailDO.get("id")).toArray()), oppunitName = detailDY.getString("oppunit"), "bei_transdetail_cas", companyId = Long.valueOf(detailDY.getLong("company.id")), false)) != null) {
                return baseDataBean.getPkId();
            }
        }
        return null;
    }

    public static void writerBackDetailInfo(DynamicObject bizBill, String receredWay, String e_rulename) {
        try {
            long sourcebillid = bizBill.getLong("sourcebillid");
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"smartRecPayHelperService", (String)"saveDetailReceredWayAndRuleNameApi", (Object[])new Object[]{sourcebillid, receredWay, e_rulename});
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
        }
    }

    public static void writerBackDetailInfoByHandMerge(Object[] detailsIds, String receredWay) {
        try {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"smartRecPayHelperService", (String)"setReceredWay", (Object[])new Object[]{detailsIds, receredWay});
        }
        catch (Exception e) {
            LOGGER.info("====\u4e1a\u52a1\u5355\u636e\u4fdd\u5b58,\u53cd\u5199\u4ea4\u6613\u660e\u7ec6\u4fe1\u606f\u5fae\u670d\u52a1\u62a5\u9519" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4fdd\u5b58\uff0c\u53cd\u5199\u4ea4\u6613\u660e\u7ec6\u5165\u8d26\u65b9\u5f0f\u5fae\u670d\u52a1\u62a5\u9519\u3002", (String)"RecPayRuleHelper_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }
}

