/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.func.BaseDataBean;
import kd.bos.ext.fi.func.BasedataMatcher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;

public class ValidAndSetMatchInfoHelper {
    public static String validAndSetMatchInfo(DynamicObject bizDy, String eType, String thisType, boolean isThrowErr) {
        long sourcebillid = bizDy.getLong("sourcebillid");
        String sourceSelector = "id,billno,oppunit,company.id,oppBankNumber";
        QFilter sourceFilter = new QFilter("id", "=", (Object)sourcebillid);
        DynamicObject transDetailDy = QueryServiceHelper.queryOne((String)"bei_transdetail_cas", (String)sourceSelector, (QFilter[])new QFilter[]{sourceFilter});
        String oppUnitName = transDetailDy.getString("oppunit");
        Long companyId = transDetailDy.getLong("company.id");
        return ValidAndSetMatchInfoHelper.matchBaseData(bizDy, transDetailDy, eType, thisType, oppUnitName, companyId, isThrowErr);
    }

    public static String validClaimNoticeInfo(DynamicObject bizDy, String eType, String thisType, boolean isThrowErr) {
        Long sourcebillid = bizDy.getLong("sourcebillid");
        String sourceSelector = "id,billno,oppunit,description,org.id,org";
        QFilter sourceFilter = new QFilter("id", "=", (Object)sourcebillid);
        DynamicObject transDetailDy = BusinessDataServiceHelper.loadSingle((String)"cas_claimcenterbill", (String)sourceSelector, (QFilter[])new QFilter[]{sourceFilter});
        String oppUnitName = transDetailDy.getString("oppunit");
        if (StringUtils.isBlank((CharSequence)oppUnitName)) {
            return "";
        }
        Long companyId = transDetailDy.getLong("org.id");
        return ValidAndSetMatchInfoHelper.matchBaseData(bizDy, transDetailDy, eType, thisType, oppUnitName, companyId, isThrowErr);
    }

    private static String matchBaseData(DynamicObject bizDy, DynamicObject transDetailDy, String eType, String thisType, String oppUnitName, Long companyId, boolean isThrowErr) {
        String errInfo = "";
        if (AsstActTypeEnum.OTHER.getValue().equals(eType)) {
            return errInfo;
        }
        BaseDataBean baseDataBean = null;
        if (AsstActTypeEnum.CUSTOMER.getValue().equals(eType) || AsstActTypeEnum.SUPPLIER.getValue().equals(eType)) {
            baseDataBean = new BasedataMatcher().dealCustomerOrSupplier(eType, transDetailDy, oppUnitName, "bei_transdetail_cas", companyId, false);
        } else if (AsstActTypeEnum.COMPANY.getValue().equals(eType)) {
            baseDataBean = new BasedataMatcher().dealBosOrg(null, transDetailDy, oppUnitName, "bei_transdetail_cas", companyId);
        } else if (AsstActTypeEnum.EMPLOYEE.getValue().equals(eType)) {
            baseDataBean = new BasedataMatcher().dealBosUser(transDetailDy, oppUnitName, "bei_transdetail_cas", companyId, false);
        }
        if (baseDataBean != null) {
            ValidAndSetMatchInfoHelper.updatePayRecId(baseDataBean, bizDy, thisType);
        } else {
            errInfo = ValidAndSetMatchInfoHelper.throwException(transDetailDy, thisType, AsstActTypeEnum.getName((String)eType), isThrowErr);
        }
        return errInfo;
    }

    private static void updatePayRecId(BaseDataBean baseDataBean, DynamicObject bizDy, String thisType) {
        long payee;
        String pkValueString = baseDataBean.getPkId() + "";
        if ("rec".equals(thisType)) {
            long payer = bizDy.getLong("payer");
            if (!pkValueString.equals(payer + "")) {
                bizDy.set("payer", baseDataBean.getPkId());
                DynamicObject baseData = QueryServiceHelper.queryOne((String)baseDataBean.getEntity(), (String)"id,number,name", (QFilter[])new QFilter("id", "=", baseDataBean.getPkId()).toArray());
                if (bizDy.containsProperty("itempayer")) {
                    bizDy.set("itempayer", baseDataBean.getPkId());
                }
                if (bizDy.containsProperty("payername")) {
                    bizDy.set("payername", (Object)baseData.getString("name"));
                }
                if (bizDy.containsProperty("payernumber")) {
                    bizDy.set("payernumber", (Object)baseData.getString("number"));
                }
            }
        } else if ("pay".equals(thisType) && !pkValueString.equals((payee = bizDy.getLong("payee")) + "")) {
            bizDy.set("payee", baseDataBean.getPkId());
            DynamicObject baseData = QueryServiceHelper.queryOne((String)baseDataBean.getEntity(), (String)"id,number,name", (QFilter[])new QFilter("id", "=", baseDataBean.getPkId()).toArray());
            if (bizDy.containsProperty("payeenumber")) {
                bizDy.set("payeenumber", (Object)baseData.getString("number"));
            }
            if (bizDy.containsProperty("payeename")) {
                bizDy.set("payeename", (Object)baseData.getString("name"));
            }
        }
    }

    private static String throwException(DynamicObject transDetailDy, String thisType, String name, boolean isThrowErr) {
        String oppUnitName = transDetailDy.getString("oppunit");
        String billno = transDetailDy.getString("billno");
        String errorMsg = "";
        if ("rec".equals(thisType) || "pay".equals(thisType)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u751f\u5355\u5931\u8d25\uff0c\u201c%2$s\u201d%3$s\u57fa\u7840\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"validatorMatchType_0", (String)"fi-cas-business", (Object[])new Object[0]), billno, oppUnitName, name);
        }
        if (isThrowErr) {
            throw new KDBizException(errorMsg);
        }
        return errorMsg;
    }

    private ValidAndSetMatchInfoHelper() {
        throw new IllegalStateException("Utility class");
    }
}

