/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.DownloadDayEnum;
import kd.fi.cas.helper.BalanceAccHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementDownloadService {
    private static final Log logger = LogFactory.getLog(BankStatementDownloadService.class);
    private static final int MAX_SAVE_COUNT = 3000;
    private String downloadDay = "";
    private Map<Long, List<DynamicObject>> periodCache = new HashMap<Long, List<DynamicObject>>();

    public BankStatementDownloadService() {
    }

    public BankStatementDownloadService(String downloadDay) {
        this.downloadDay = downloadDay;
    }

    public List<Object> download(long orgId, long acctId) {
        DownloadDayEnum downloadDayEnum;
        logger.info("###BankStatementDownloadService###start to download.......");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        ArrayList<Long> acctIds = new ArrayList<Long>();
        acctIds.add(acctId);
        Date endDate = null;
        Date startDate = null;
        if (this.downloadDay == null || StringUtils.isEmpty((CharSequence)this.downloadDay)) {
            this.downloadDay = "";
        }
        if ((downloadDayEnum = DownloadDayEnum.toEnum((String)this.downloadDay)) == null) {
            endDate = DateUtils.getDataFormat((Date)new Date(), (boolean)false);
            startDate = null;
        } else {
            Date now = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
            Date tomorrow = DateUtils.getFrontDay((Date)now, (int)1);
            endDate = DateUtils.getDataFormat((Date)tomorrow, (boolean)false);
            switch (downloadDayEnum) {
                case THE_MONTH: {
                    startDate = DateUtils.getMinMonthDate((Date)now);
                    endDate = DateUtils.getDataFormat((Date)now, (boolean)false);
                    break;
                }
                case LAST_MONTH: {
                    startDate = DateUtils.getPreMonth((Date)tomorrow, (int)DownloadDayEnum.LAST_MONTH.getDay());
                    break;
                }
                case LAST_THREE_MONTH: {
                    startDate = DateUtils.getPreMonth((Date)tomorrow, (int)DownloadDayEnum.LAST_THREE_MONTH.getDay());
                    break;
                }
                case HALF_YEAR: {
                    startDate = DateUtils.getPreMonth((Date)tomorrow, (int)DownloadDayEnum.HALF_YEAR.getDay());
                    break;
                }
                case YEAR: {
                    startDate = DateUtils.getPreMonth((Date)tomorrow, (int)DownloadDayEnum.YEAR.getDay());
                }
            }
        }
        logger.info("###BankStatementDownloadService###start to download.begin time: {}, end time :{}", startDate, (Object)endDate);
        return this.download(orgIds, acctIds, startDate, endDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> download(List<Long> orgIds, List<Long> acctIds, Date beginDate, Date endDate) {
        ArrayList<Object> idList = new ArrayList();
        List orgIdStrList = orgIds.stream().map(String::valueOf).collect(Collectors.toList());
        ArrayList<String> requestIds = new ArrayList<String>(orgIds.size());
        ArrayList<Long> requestFailIds = new ArrayList<Long>(orgIds.size());
        Map request = MutexServiceHelper.batchRequest(orgIdStrList, (String)"am_acctbank_schedule", (String)"downbankstatement");
        try {
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (Boolean.TRUE.equals(entry.getValue())) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            logger.info("\u52a0\u9501\u6210\u529f\u7684\u7ec4\u7ec7\uff1a{}", requestIds);
            logger.info("\u52a0\u9501\u5931\u8d25\u7684\u7ec4\u7ec7\uff1a{}", requestFailIds);
            List<Long> lockSucceedOrgIds = requestIds.stream().filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            QFilter[] filters = this.getTransDetailFilters(lockSucceedOrgIds, acctIds, beginDate, endDate);
            String queryProps = "id,billno,company,accountbank,currency,bizdate,description,debitamount,creditamount,transbalance,oppunit,oppbanknumber,oppbank,biztype,bankcheckflag,detailid,sortno,bizrefno,businessbillnum,biztime,bankdetailno";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bei_transdetail_cas", (String)queryProps, (QFilter[])filters, (String)"bizdate");
            Map casInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(new HashSet<Long>(orgIds));
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement");
            ArrayList<DynamicObject> bankStates = new ArrayList<DynamicObject>();
            DynamicObject[] recDecArray = BalanceAccHelper.balanceAccByOrgIds(new HashSet<Long>(orgIds));
            HashMap<Long, DynamicObject> orgRecDecPeriod = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject recDec : recDecArray) {
                DynamicObject org = recDec.getDynamicObject("org");
                DynamicObject period = recDec.getDynamicObject("recperiod");
                Long orgId = org.getLong("id");
                orgRecDecPeriod.put(orgId, period);
            }
            Map paramCS095 = SystemParameterHelper.getBatchParameterString(orgIds, (String)"cs095");
            Map paramCS096 = SystemParameterHelper.getBatchParameterString(orgIds, (String)"cs096");
            Map lastBalanceAdjustBatch = BalanceAdjustHelper.getLastBalanceAdjustBatch(orgIds, acctIds, null);
            DataSet copyDataSet = dataSet.copy();
            HashSet<String> detailIdSet = new HashSet<String>(dataSet.copy().count("detailid", false));
            try {
                copyDataSet.forEach(row -> detailIdSet.add(row.getString("detailid")));
            }
            finally {
                if (copyDataSet != null) {
                    copyDataSet.close();
                }
            }
            if (EmptyUtil.isNoEmpty(detailIdSet)) {
                QFilter qFilter = new QFilter("bankvouvherno", "in", detailIdSet);
                DynamicObjectCollection existBankStatementList = QueryServiceHelper.query((String)"cas_bankstatement", (String)"bankvouvherno", (QFilter[])qFilter.toArray());
                Set bankVoucherNoSet = existBankStatementList.stream().map(existBankStatement -> existBankStatement.getString("bankvouvherno")).collect(Collectors.toSet());
                detailIdSet.removeAll(bankVoucherNoSet);
            }
            for (Row data : dataSet) {
                DynamicObject bankStatement = this.conversionToBankStatement(data, entityType, casInitMap, orgRecDecPeriod, paramCS095, paramCS096, lastBalanceAdjustBatch, detailIdSet);
                if (null == bankStatement) continue;
                bankStates.add(bankStatement);
            }
            if (EmptyUtil.isNoEmpty(bankStates)) {
                idList = this.batchProcess(bankStates);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"am_acctbank_schedule", (String)"downbankstatement");
        }
        return idList;
    }

    public Boolean getValid(Map<Long, DynamicObject> orgRecDecPeriod, Long orgId, Date bookDate) {
        DynamicObject periodByDate;
        Boolean isValid = true;
        DynamicObject recPeriod = orgRecDecPeriod.get(orgId);
        if (EmptyUtil.isNoEmpty((DynamicObject)recPeriod) && EmptyUtil.isNoEmpty((DynamicObject)(periodByDate = this.getPeriod(orgId, bookDate))) && PeriodHelper.before((DynamicObject)periodByDate, (DynamicObject)recPeriod)) {
            isValid = false;
        }
        return isValid;
    }

    private QFilter[] getTransDetailFilters(List<Long> orgIds, List<Long> acctIds, Date beginDate, Date endDate) {
        QFilter downloadStatusFilter = new QFilter("isDownToBankState", "=", (Object)"0");
        QFilter orgFilter = new QFilter("company", "in", orgIds);
        QFilter acctFilter = null;
        if (!acctIds.isEmpty()) {
            acctFilter = new QFilter("accountbank", "in", acctIds);
        }
        QFilter beginBizDateFilter = null;
        if (beginDate != null) {
            beginBizDateFilter = new QFilter("bizdate", ">=", (Object)beginDate);
        }
        QFilter endBizDateFilter = null;
        if (endDate != null) {
            endBizDateFilter = new QFilter("bizdate", "<=", (Object)endDate);
        }
        return new QFilter[]{orgFilter, downloadStatusFilter, beginBizDateFilter, endBizDateFilter, acctFilter};
    }

    private DynamicObject conversionToBankStatement(Row data, MainEntityType entityType, Map<String, DynamicObject> casInitMap, Map<Long, DynamicObject> orgRecDecPeriod, Map<String, String> paramCS095Map, Map<String, String> paramCS096Map, Map<String, DynamicObject> lastBalanceAdjustMap, Set<String> detailIdSet) {
        Date beginDate = data.getDate("bizdate");
        DynamicObject bankState = new DynamicObject((DynamicObjectType)entityType);
        Long orgId = data.getLong("company");
        Date bizDate = data.getDate("bizdate");
        if (orgId == null || bizDate == null) {
            return null;
        }
        DynamicObject casInit = casInitMap.get(String.valueOf(orgId));
        if (EmptyUtil.isEmpty((DynamicObject)casInit) || EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("startperiod"))) {
            return null;
        }
        Date startperiodBeginDate = casInit.getDynamicObject("startperiod").getDate("begindate");
        if (null != beginDate && beginDate.before(startperiodBeginDate)) {
            return null;
        }
        if (bizDate.before(startperiodBeginDate)) {
            return null;
        }
        DynamicObject period = this.getPeriod(orgId, bizDate);
        if (period == null) {
            logger.info(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"BankStatementDownloadService_0", (String)"fi-cas-business", (Object[])new Object[0]), data.get("bizdate")));
            return null;
        }
        if (EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("currentperiod")) || EmptyUtil.isEmpty((Object)casInit.getDynamicObject("currentperiod").getDate("begindate"))) {
            return null;
        }
        Date currentperiodBeginDate = casInit.getDynamicObject("currentperiod").getDate("begindate");
        String paramCS096 = paramCS096Map.get(orgId + "");
        if (null != beginDate && beginDate.before(currentperiodBeginDate) && paramCS096.equals(Boolean.FALSE.toString())) {
            return null;
        }
        String paramCS095 = paramCS095Map.get(orgId + "");
        DynamicObject lastBalanceAdjust = lastBalanceAdjustMap.get(orgId + "_" + data.get("accountbank") + "_" + data.get("currency"));
        if (EmptyUtil.isNoEmpty((DynamicObject)lastBalanceAdjust) && EmptyUtil.isNoEmpty((Object)lastBalanceAdjust.get("bizdate")) && null != beginDate && beginDate.before(lastBalanceAdjust.getDate("bizdate")) && paramCS095.equals(Boolean.FALSE.toString())) {
            return null;
        }
        String detailId = data.getString("detailid");
        if (EmptyUtil.isNoEmpty((String)detailId)) {
            if (!detailIdSet.remove(detailId)) {
                return null;
            }
        } else {
            return null;
        }
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"period", (Object)period);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"org", (Object)orgId);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"billno", (Object)DB.genStringId((String)"T_cas_BankStatement"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"billstatus", (Object)"B");
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"accountbank", (Object)data.get("accountbank"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"currency", (Object)data.get("currency"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bizdate", (Object)bizDate);
        String description = data.getString("description");
        if (description != null) {
            description = description.substring(0, Math.min(255, description.length()));
        }
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"description", (Object)description);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"settlementtype", null);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"settlementnumber", (Object)data.get("businessbillnum"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"debitamount", (Object)data.get("debitamount"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"creditamount", (Object)data.get("creditamount"));
        int direction = data.getBigDecimal("debitamount") != null && data.getBigDecimal("debitamount").doubleValue() != 0.0 ? 1 : 2;
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"direction", (Object)direction);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"balanceamt", (Object)data.get("transbalance"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"sortno", (Object)data.get("sortno"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"tradenumber", (Object)data.get("bizrefno"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"cashier", null);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"vouchernumber", (Object)data.get("businessbillnum"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"oppunit", (Object)data.get("oppunit"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"oppaccountnumber", (Object)data.get("oppbanknumber"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"oppbank", (Object)data.get("oppbank"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"biztype", (Object)data.get("biztype"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"ischeck", (Object)0);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"source", (Object)1);
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"sourcebillid", (Object)data.get("id"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"createtime", (Object)new Date());
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bankcheckflag", (Object)data.get("bankcheckflag"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bankvouvherno", (Object)data.get("detailid"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"bankdetailno", (Object)data.get("bankdetailno"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"transtime", (Object)data.get("biztime"));
        DynamicObjectHelper.setValue((DynamicObject)bankState, (String)"isvalid", (Object)this.getValid(orgRecDecPeriod, orgId, bizDate));
        return bankState;
    }

    private List<Object> batchProcess(List<DynamicObject> bankStates) {
        LinkedList<Object> result = new LinkedList<Object>();
        ArrayList<DynamicObject> onceSaveList = new ArrayList<DynamicObject>(3000);
        for (int i = 0; i < bankStates.size(); ++i) {
            if ((i + 1) % 3000 == 0) {
                List<Object> onceSaveResult = this.saveAndDispose(onceSaveList.toArray(new DynamicObject[0]));
                result.addAll(onceSaveResult);
                onceSaveList = new ArrayList(3000);
            }
            onceSaveList.add(bankStates.get(i));
        }
        if (!onceSaveList.isEmpty()) {
            List<Object> onceSaveResult = this.saveAndDispose(onceSaveList.toArray(new DynamicObject[0]));
            result.addAll(onceSaveResult);
        }
        return result;
    }

    private List<Object> saveAndDispose(DynamicObject[] bankStates) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            Object[] result = SaveServiceHelper.save((DynamicObject[])bankStates);
            BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])bankStates, (OperateType)OperateType.ADD);
            try (TXHandle tmcTx = TX.requiresNew();){
                LinkedList<Object[]> transIds = new LinkedList<Object[]>();
                for (DynamicObject statement : bankStates) {
                    transIds.add(new Object[]{statement.getLong("sourcebillid")});
                }
                String sql = "update t_bei_transdetail set FisDownToBankState=1 where fid = ?";
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, transIds);
            }
            LinkedList<Object> savedPks = new LinkedList<Object>();
            for (int j = 0; j < result.length; ++j) {
                DynamicObject obj = (DynamicObject)result[j];
                savedPks.add(obj.getLong("id"));
            }
            ThreadPools.executeOnceIncludeRequestContext((String)ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u7535\u5b50\u5f52\u6863", (String)"BankStatementDownloadService_1", (String)"fi-cas-business", (Object[])new Object[0]), () -> OperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)"cas_bankstatement", (Object[])savedPks.toArray(), (OperateOption)OperateOption.create()));
            LinkedList<Object> linkedList = savedPks;
            return linkedList;
        }
        catch (Exception e) {
            try {
                logger.error("saveAndDispose", (Throwable)e);
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private DynamicObject getPeriod(Long orgId, Date bizDate) {
        List<DynamicObject> periodList = this.periodCache.get(orgId);
        if (periodList != null) {
            for (DynamicObject period : periodList) {
                if (period == null) continue;
                Date beginDate = period.getDate("begindate");
                Date endDate = period.getDate("enddate");
                if (bizDate.compareTo(beginDate) < 0 || bizDate.compareTo(endDate) > 0) continue;
                return period;
            }
        }
        DynamicObject period = PeriodHelper.getPeriodByDate((long)orgId, (Date)bizDate);
        if (periodList == null) {
            periodList = new ArrayList<DynamicObject>();
            this.periodCache.put(orgId, periodList);
        }
        if (period != null) {
            periodList.add(period);
        }
        return period;
    }
}

